(* ::Package:: *)

Clear[PlotInterpolatedShieldings]
PlotInterpolatedShieldings::usage =
"PlotInterpolatedShieldings[\[Sigma]Func, center, {\[Theta]min, \[Theta]max}, step, highlightAngle] \
visualizes antisymmetric shielding vectors from \[Sigma]Func[\[Theta]] centered at a specified 3D position. \
The vector at highlightAngle (in degrees) is emphasized.";


PlotInterpolatedShieldings[
  sigmaFunc_,
  center_,
  {thetaMinDeg_, thetaMaxDeg_},
  stepDeg_: 10,
  highlightAngleDeg_: -60
] := Module[
  {anglesDeg, anglesRad, vectors, arrows, highlightIndex, labelStyle},

  anglesDeg = Range[thetaMinDeg, thetaMaxDeg, stepDeg];
  anglesRad = anglesDeg Degree;

  vectors = sigmaFunc /@ anglesRad;

  highlightIndex = FirstPosition[anglesDeg, highlightAngleDeg, {None}][[1]];
  labelStyle = Style[#, 16, Black] &;

  arrows = Table[
    {
      If[i === highlightIndex, Opacity[1.0], Opacity[0.1]],
      Darker[Orange],
      Arrow[
        Tube[{100 center, 100 center + 50 vectors[[i]]}]
      ],
      If[i === highlightIndex, Opacity[1.0], Opacity[0]],
      Text[
        labelStyle[ToString[anglesDeg[[i]]] <> "\[Degree]"],
        100 center + 55 vectors[[i]]
      ]
    },
    {i, Length[anglesDeg]}
  ];

  Graphics3D[arrows, Axes -> False, Boxed -> False]
];
