(* ::Package:: *)

Clear[ProbabilityEllipsoidPlot]
ProbabilityEllipsoidPlot::usage = 
"ProbabilityEllipsoidPlot[filename_, numberOfItems_] computes the probability tensor \
from the given file using ProbabilityTensor, extracts its eigensystem, and plots the \
resulting ellipsoid scaled and oriented by the eigenvalues and eigenvectors.";


ProbabilityEllipsoidPlot[filename_, numberOfItems_] := 
 Module[{pTensor, eigenVals, eigenVecs, ellipsoidMatrix},
  
  (* Step 1: Compute the probability tensor *)
  pTensor = ProbabilityTensor[filename, numberOfItems];
  
  (* Step 2: Get eigensystem (centered by identity/3) *)
  {eigenVals, eigenVecs} = 
   Eigensystem[pTensor - IdentityMatrix[3]/3];
  
  (* Step 3: Compute scaled ellipsoid matrix *)
  ellipsoidMatrix = 
   Transpose[eigenVecs].DiagonalMatrix[Abs[2 eigenVals]].eigenVecs;
  
  (* Step 4: Build the ellipsoid graphic *)
  Graphics3D[{
    Opacity[0.9],
    Lighter[Blue],
    Ellipsoid[{0, 0, 0}, 100000 ellipsoidMatrix]
  }]
]
