(* ::Package:: *)

Clear[ProbabilityTensor]
ProbabilityTensor::usage = 
"ProbabilityTensor[filename, numberOfItems] reads numerical data from the file specified by \
filename, processes numberOfItems blocks of 10 numbers each (discarding the last in each block), \
constructs a 3\[Times]3 tensor from the normalized projection along {0,0,1}, and returns the average tensor \
over all processed items.

Each data block is assumed to contain at least 10 real numbers. The last number is ignored, and the \
remaining 9 values are reshaped into a 3\[Times]3 matrix (row-major).";


ProbabilityTensor = Function[{filename, numberOfItems},
  Module[{str, p, q, data},
    str = OpenRead[filename];
    p = ConstantArray[0, {3, 3}];
    
    Do[
      data = Read[str, Table[Number, {10}]];
      data = Most[data];  (* Remove last element *)
      q = Partition[data, 3] // Transpose;
      q = Normalize[Transpose[q].{0, 0, 1}];
      q = Outer[Times, q, q];  (* Outer product *)
      p += q,
      {k, 1, numberOfItems}
    ];
    
    Close[str];
    p/numberOfItems
  ]
];

