(* ::Package:: *)

BeginPackage["NMER`"];


SchrodingerToInteractionPicture::usage = "SchrodingerToInteractionPicture[\!\(\*SubscriptBox[
StyleBox[\"L\",\nFontSlant->\"Italic\"], \(1\)]\),\!\(\*SubscriptBox[
StyleBox[\"L\",\nFontSlant->\"Italic\"], \(2\)]\)]
transforms the Liouvillian \!\(\*SubscriptBox[
StyleBox[\"L\",\nFontSlant->\"Italic\"], \(1\)]\) in the Schr\[ODoubleDot]dinger picture to the interaction picture given by the Liouvillian \!\(\*SubscriptBox[
StyleBox[\"L\",\nFontSlant->\"Italic\"], \(2\)]\)";


Begin["Global`"]


SchrodingerToInteractionPicture=Function[{L1,L2,n},
inter=Take[
      MatrixExp[SuperoperatorMatrixRepresentation[I CommutationSuperoperator[L2]\[ScriptT]]].SuperoperatorMatrixRepresentation[L1].MatrixExp[SuperoperatorMatrixRepresentation[-I CommutationSuperoperator[L2]\[ScriptT]]]
       ,{1,(2^n)^2},{1,(2^n)^2}]//Simplify;
    Table[
       LeaveOutFastOscillatingTerms[
                              ExpandAll[
                                      inter[[i,j]]
                                        ]
                                   ]
        ,{i,1,(2^n)^2},{j,1,(2^n)^2}]
];


End[]


EndPackage[];
