(* ::Package:: *)

Clear[TransformCouplingVectors]
TransformCouplingVectors::usage =
"TransformCouplingVectors[dataFile, frame] reads antisymmetric coupling vectors from dataFile \
in the format {angle_in_degrees, x, y, z}, rotates them into the molecular frame, and returns \
an interpolation function couplingFunc[\[Theta]] with \[Theta] in radians.";


TransformCouplingVectors[dataFile_String, frame_] := Module[
  {str, rawData, rotated},

  str = OpenRead[dataFile];
  rawData = Table[
    Read[str, {Number, Number, Number, Number}],
    {36}
  ];
  Close[str];

  rotated = Table[
    {
      rawData[[i, 1]] Degree, 
      Transpose[frame].Take[rawData[[i]], {2, 4}]
    },
    {i, Length[rawData]}
  ];

  Interpolation[rotated /. {a_, v_} :> {a, v}, InterpolationOrder -> 1]
];
