(* ::Package:: *)

Clear[TransformDipoles]
TransformDipoles::usage =
"TransformDipoles[dataFile, frame] reads dipole vectors from 'dataFile' in the format \
{angle_in_degrees, x, y, z}, transforms them into the molecular frame using 'frame', \
and returns an interpolation function dipoleFunc[\[Theta]], where \[Theta] is in radians.";


TransformDipoles[dataFile_String, frame_] := Module[
  {str, rawData, rotated},

  str = OpenRead[dataFile];

  (* Step 1: Read all dipole entries from the file *)
  rawData = Table[
    Read[str, {Number, Number, Number, Number}],
    {36}
  ];
  Close[str];

  (* Step 2: Convert angles to radians and rotate dipoles into molecular frame *)
  rotated = Table[
    {
      rawData[[i, 1]] Degree,  (* angle converted to radians *)
      Transpose[frame].Take[rawData[[i]], {2, 4}]
    },
    {i, Length[rawData]}
  ];

  (* Step 3: Return only the interpolation function *)
  Interpolation[rotated /. {a_, v_} :> {a, v}, InterpolationOrder -> 1]
];
