(* ::Package:: *)

Clear[TransformShieldingVectors]
TransformShieldingVectors::usage =
"TransformShieldingVectors[dataFile, frame] reads antisymmetric shielding vectors from \
dataFile in the format {angle_in_degrees, x, y, z}, rotates them into the molecular frame, \
and returns an interpolation function \[Sigma]Func[\[Theta]] with \[Theta] in radians.";


TransformShieldingVectors[dataFile_String, frame_] := Module[
  {str, rawData, rotated},

  str = OpenRead[dataFile];
  rawData = Table[
    Read[str, {Number, Number, Number, Number}],
    {36}
  ];
  Close[str];

  rotated = Table[
    {
      rawData[[i, 1]] Degree,
      Transpose[frame].Take[rawData[[i]], {2, 4}]
    },
    {i, Length[rawData]}
  ];

  Interpolation[rotated /. {a_, v_} :> {a, v}, InterpolationOrder -> 1]
];
