(* ::Package:: *)

Clear[TransformToMolecularFrame]
TransformToMolecularFrame::usage =
"TransformToMolecularFrame[frame, origin, coords, outputFile] applies a rotation matrix 'frame' \
and translation origin to the coordinates in 'coords', preserving atom labels, and exports the result \
to outputFile.xyz.";


TransformToMolecularFrame[frame_, origin_, coords_List, outputFile_String] := Module[{transformed},

  transformed = Table[
    {
      coords[[i, 1]],  (* atom label: e.g., \"C\", \"H\" *)
      Sequence @@ (Transpose[frame].(coords[[i, 2 ;; 4]] - origin))  (* transformed coords *)
    },
    {i, Length[coords]}
  ];

  Export[outputFile <> ".dat", transformed];

  If[FileExistsQ[outputFile <> ".xyz"], DeleteFile[outputFile <> ".xyz"]];
  RenameFile[outputFile <> ".dat", outputFile <> ".xyz"];

  Import[outputFile <> ".xyz"]
];
