(* ::Package:: *)

BeginPackage["NMER`"];


UseNumericalValues::usage = "UseNumericalValues[\!\(\*
StyleBox[\"expr\",\nFontSlant->\"Italic\"]\),\!\(\*
StyleBox[\"n\",\nFontSlant->\"Italic\"]\)]
Substitutes constants of the \!\(\*SuperscriptBox[
StyleBox[\"n\",\nFontSlant->\"Italic\"], \(th\)]\) spin system in the expression \!\(\*
StyleBox[\"expr\",\nFontSlant->\"Italic\"]\)";


Begin["Global`"]


UseNumericalValues=Function[{expr,property,frequency},
const0={Subscript[\[Mu], 0]  -> 1.256637062 10^-6,
         \[HBar]  -> 6.6260701 10^-34/(2\[Pi]),
         kB -> 1.380649 10^-23,
         T  -> 298};
const1={Subscript[\[Omega], 1] -> -GyromagneticRatio["19F"] 11.75,
        Subscript[\[Omega], 2] -> -GyromagneticRatio["1H"] 11.75,
         \[ScriptCapitalJ] -> 6.3 ,
         Subscript[\[Tau], 2] -> 15 10^-12,
         Subscript[\[ScriptB], FF] -> -((\[HBar] Subscript[\[Mu], 0])/(4\[Pi]))GyromagneticRatio["19F"]GyromagneticRatio["19F"](2.16 10^-10)^-3,
         Subscript[\[ScriptB], FH] -> -((\[HBar] Subscript[\[Mu], 0])/(4\[Pi]))GyromagneticRatio["19F"]GyromagneticRatio["1H"](2.80 10^-10)^-3,
         Subscript[\[ScriptB], HH] -> -((\[HBar] Subscript[\[Mu], 0])/(4\[Pi]))GyromagneticRatio["19F"]GyromagneticRatio["1H"](2.67 10^-10)^-3

         };
const2={
         Subscript[\[ScriptC], 1] -> 0.038,
         Subscript[\[ScriptC], 2] -> 0.057,
         Subscript[\[ScriptC], 3] -> 0.032,
         Subscript[\[ScriptC], 4] -> -143.57,      
         Subscript[\[ScriptC], 5] -> 0.407
         };
const3={
         Subscript[\[ScriptC], 1] -> 0.177,
         Subscript[\[ScriptC], 2] -> 0.187,
         Subscript[\[ScriptC], 3] -> -0.053,
         Subscript[\[ScriptC], 4] -> -127.53,        
         Subscript[\[ScriptC], 5] -> 0.407
         };
Which[
  property=="jcoupling",
         const=Antisymmetry["jcoupling",frequency]/.const2,
  property=="shielding",
         const=Antisymmetry["shielding",frequency]/.const3
     ];         
expr/.{sin\[Phi]->Sin[\[Phi]],cos\[Phi]->Cos[\[Phi]]}/.const/.const1/.const0//N];


End[]


EndPackage[];
