(* ::Package:: *)

ValidateAverageOverMoleculesFile[filename_, totalMolecules_, expectedFrames_: Automatic] :=
 Module[
   {data, totalValues, valuesPerFrame, totalFrames, passedQ},
   
   valuesPerFrame = 10 * totalMolecules;
   
   Quiet[
     data = ReadList[filename, Number];
     If[data === $Failed || data === {}, 
       Message[ValidateAverageOverMoleculesFile::readfail, filename]; 
       Return[$Failed];
     ]
   ];
   
   totalValues = Length[data];
   totalFrames = totalValues / valuesPerFrame;
   passedQ = IntegerQ[totalFrames];
   
   If[!passedQ,
     Message[ValidateAverageOverMoleculesFile::badlen, totalValues, totalMolecules];
     Return[$Failed];
   ];
   
   If[expectedFrames =!= Automatic && expectedFrames =!= totalFrames,
     Message[ValidateAverageOverMoleculesFile::framecount, expectedFrames, totalFrames];
     Return[$Failed];
   ];
   
   Print[
     Style["\:2705 File is correctly structured!", Darker[Green]],
     "\nTotal molecules per frame: ", totalMolecules,
     "\nFrames detected: ", totalFrames
   ];
   True
];

ValidateAverageOverMoleculesFile::readfail = "Failed to read numeric data from file `1`.";
ValidateAverageOverMoleculesFile::badlen = "File contains `1` values, which is not divisible by 10 \[Times] `2` (molecule count).";
ValidateAverageOverMoleculesFile::framecount = "Expected `1` frames, but detected `2` based on file length.";
