(* ::Package:: *)

Clear[VisualizeMolecularFrameWithLabels]
VisualizeMolecularFrameWithLabels::usage =
"VisualizeMolecularFrameWithLabels[rotationMatrix, centerCoordinates, tfpStructure] \
visualizes a molecular backbone with labeled fluorine atoms.";

VisualizeMolecularFrameWithLabels[rotationMatrix_, centerCoordinates_, tfpStructure_] := Module[
  {atomCoords, transformedCoords, cylinders, labels},

  (* Read and transform coordinates from file *)
  atomCoords = Module[{str, atoms},
    str = OpenRead["Data//TFP_lowest_energy.xyz"];
    atoms = Table[
      Read[str, {Word, Number, Number, Number}],
      {12}
    ];
    Close[str];
    atoms[[All, {2, 3, 4}]]
  ];

  transformedCoords = 100 * Map[
    Transpose[rotationMatrix].(# - centerCoordinates) &,
    atomCoords
  ];

  (* Cylinders to connect backbone atoms *)
  cylinders = {
    Lighter[Blue],
    Cylinder[{transformedCoords[[1]], transformedCoords[[2]]}, 16],
    Cylinder[{transformedCoords[[2]], transformedCoords[[3]]}, 16],
    Cylinder[{transformedCoords[[3]], transformedCoords[[4]]}, 16]
  };

  (* Labels for Fa, Fb, Fc *)
  labels = {
    Black,
    Text[Style["\!\(\*SubscriptBox[\"F\", \"a\"]\)", Bold, 30, SingleLetterItalics -> False],
      transformedCoords[[10]]],
    Text[Style["\!\(\*SubscriptBox[\"F\", \"b\"]\)", Bold, 30, SingleLetterItalics -> False],
      transformedCoords[[11]]],
    Text[Style["\!\(\*SubscriptBox[\"F\", \"c\"]\)", Bold, 30, SingleLetterItalics -> False],
      transformedCoords[[12]]]
  };

  Show[
    {
      tfpStructure,
      Graphics3D[{cylinders, labels}]
    },
    ImageSize -> 800
  ]
];
