(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    116153,       2567]
NotebookOptionsPosition[    114152,       2497]
NotebookOutlinePosition[    114498,       2512]
CellTagsIndexPosition[    114455,       2509]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", "NMER.wl"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$Path", "=", 
   RowBox[{"Append", "[", 
    RowBox[{
    "$Path", ",", 
     "\"\<C:\\\\Program Files\\\\Wolfram \
Research\\\\Mathematica\\\\11.0\\\\AddOns\\\\SpinDynamica\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Needs", "[", "\"\<SpinDynamica`\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{"SetSpinSystem", "[", "2", "]"}], "\[IndentingNewLine]", 
 RowBox[{"SetOperatorBasis", "[", 
  RowBox[{"ShiftAndPolarizationOperatorBasis", "[", "]"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$IterationLimit", "=", "100"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$RecursionLimit", "=", "100"}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.8979029332461853`*^9, 3.8979029333555126`*^9}, {
   3.9084282902765293`*^9, 3.908428290608573*^9}, {3.908434156845696*^9, 
   3.9084341571057606`*^9}, {3.9084342203704367`*^9, 3.90843423064997*^9}, {
   3.9084342658446393`*^9, 3.90843426662166*^9}, {3.9239663419853973`*^9, 
   3.9239663428683977`*^9}, {3.9242179270710745`*^9, 
   3.9242179309820786`*^9}, {3.9242189923630667`*^9, 
   3.9242189928409357`*^9}, {3.929689130221174*^9, 3.929689130335905*^9}, {
   3.9296904704089746`*^9, 3.929690475661783*^9}, {3.9296906208124905`*^9, 
   3.9296906321806283`*^9}, {3.9297559111781435`*^9, 
   3.9297559170982122`*^9}, {3.929756156737685*^9, 3.929756159728757*^9}, {
   3.9297561955543327`*^9, 3.9297562018225355`*^9}, {3.929757372873993*^9, 
   3.9297573747952967`*^9}, {3.9297582795229845`*^9, 3.929758289056796*^9}, {
   3.929758392176601*^9, 3.9297583922917504`*^9}, {3.9297612208572*^9, 
   3.92976122748133*^9}, 3.9297617497266264`*^9, {3.929762516458739*^9, 
   3.9297625209660463`*^9}, {3.929770704520667*^9, 3.9297707094390993`*^9}, {
   3.9297844293939266`*^9, 3.9297844299365525`*^9}, {3.930180222835225*^9, 
   3.9301802230498767`*^9}, {3.930181076851877*^9, 3.9301810787443743`*^9}, {
   3.930181132811544*^9, 3.9301811436109858`*^9}, 3.9469489421891813`*^9, {
   3.9494502996115274`*^9, 3.949450300890308*^9}, {3.951813236601036*^9, 
   3.9518132629941573`*^9}},
 ExpressionUUID -> "caa63273-6624-4f32-98bc-f80e9fab0c09"],

Cell[BoxData[
 TemplateBox[{
  "SetSpinSystem","set",
   "\"the spin system has been set to \\!\\(\\*RowBox[{\\\"{\\\", \
RowBox[{RowBox[{\\\"{\\\", RowBox[{\\\"1\\\", \\\",\\\", \
FractionBox[\\\"1\\\", \\\"2\\\"]}], \\\"}\\\"}], \\\",\\\", \
RowBox[{\\\"{\\\", RowBox[{\\\"2\\\", \\\",\\\", FractionBox[\\\"1\\\", \\\"2\
\\\"]}], \\\"}\\\"}]}], \\\"}\\\"}]\\)\"",2,369,34,26617127362490670834,
   "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{{3.9494538297339225`*^9, 3.949453830341059*^9}, 
   3.9494541384927387`*^9, 3.9494542288420506`*^9, {3.949454654183945*^9, 
   3.949454654832794*^9}, {3.949536676823586*^9, 3.9495366775926404`*^9}, {
   3.9495455825848083`*^9, 3.9495455833324447`*^9}, 3.950154793641093*^9, {
   3.9501695150462685`*^9, 3.9501695157255173`*^9}, {3.9501695964668527`*^9, 
   3.9501695970982103`*^9}, {3.9501696828823557`*^9, 
   3.9501696835319743`*^9}, {3.950169792184293*^9, 3.9501697928285074`*^9}, 
   3.950173571875944*^9, {3.9518132680730658`*^9, 3.9518132707098827`*^9}, 
   3.951813458614745*^9, 3.95181380151254*^9, 3.952496920921914*^9, 
   3.9524974276649923`*^9, {3.958434966903729*^9, 3.958434969642068*^9}, {
   3.958454903470421*^9, 3.958454903630419*^9}, 3.9584556255102515`*^9, 
   3.9584560591404533`*^9, {3.9584562539433594`*^9, 3.9584562557663603`*^9}, 
   3.9584569750368958`*^9, 3.958458082244797*^9, 3.958458416278878*^9, {
   3.958462548204509*^9, 3.958462548356507*^9}, 3.9584679124104185`*^9}],

Cell[BoxData[
 TemplateBox[{
  "SetOperatorBasis","alreadyset",
   "\"The operator basis is already set to \
\\!\\(\\*RowBox[{\\\"ShiftAndPolarizationOperatorBasis\\\", \\\"[\\\", \
RowBox[{RowBox[{\\\"{\\\", RowBox[{RowBox[{\\\"{\\\", RowBox[{\\\"1\\\", \
\\\",\\\", FractionBox[\\\"1\\\", \\\"2\\\"]}], \\\"}\\\"}], \\\",\\\", \
RowBox[{\\\"{\\\", RowBox[{\\\"2\\\", \\\",\\\", FractionBox[\\\"1\\\", \\\"2\
\\\"]}], \\\"}\\\"}]}], \\\"}\\\"}], \\\",\\\", RowBox[{\\\"Sorted\\\", \\\"\
\[Rule]\\\", \\\"CoherenceOrder\\\"}]}], \\\"]\\\"}]\\). No action has been \
taken.\"",2,370,35,26617127362490670834,"Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{{3.9494538297339225`*^9, 3.949453830341059*^9}, 
   3.9494541384927387`*^9, 3.9494542288420506`*^9, {3.949454654183945*^9, 
   3.949454654832794*^9}, {3.949536676823586*^9, 3.9495366775926404`*^9}, {
   3.9495455825848083`*^9, 3.9495455833324447`*^9}, 3.950154793641093*^9, {
   3.9501695150462685`*^9, 3.9501695157255173`*^9}, {3.9501695964668527`*^9, 
   3.9501695970982103`*^9}, {3.9501696828823557`*^9, 
   3.9501696835319743`*^9}, {3.950169792184293*^9, 3.9501697928285074`*^9}, 
   3.950173571875944*^9, {3.9518132680730658`*^9, 3.9518132707098827`*^9}, 
   3.951813458614745*^9, 3.95181380151254*^9, 3.952496920921914*^9, 
   3.9524974276649923`*^9, {3.958434966903729*^9, 3.958434969642068*^9}, {
   3.958454903470421*^9, 3.958454903630419*^9}, 3.9584556255102515`*^9, 
   3.9584560591404533`*^9, {3.9584562539433594`*^9, 3.9584562557663603`*^9}, 
   3.9584569750368958`*^9, 3.958458082244797*^9, 3.958458416278878*^9, {
   3.958462548204509*^9, 3.958462548356507*^9}, 3.958467912472405*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Liouvillian of the spin system", "Chapter",
 Evaluatable->False,
 CellChangeTimes->{{3.9297563523069787`*^9, 3.92975636126001*^9}, 
   3.9297564154771423`*^9, {3.9297564743688354`*^9, 3.92975648531962*^9}, {
   3.9584679156834145`*^9, 3.95846791806105*^9}}],

Cell[TextData[{
 "Energy of the interaction betweeen the external magnetic field ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["B", "0"], 
    StyleBox[
     SubscriptBox[
      OverscriptBox["e", "^"], "z"],
     FontWeight->"Bold"]}], TraditionalForm]]],
 " and spins ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["I", "1"], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["I", "2"], TraditionalForm]]],
 " is\[LineSeparator]"
}], "Input",
 Evaluatable->False,
 CellChangeTimes->{{3.9297568739645395`*^9, 3.929756878807661*^9}, {
   3.929756920340457*^9, 3.9297569715296845`*^9}, {3.929757002411059*^9, 
   3.929757016912091*^9}, {3.929757139513809*^9, 3.9297571523258677`*^9}, 
   3.9584679204273834`*^9},
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[ScriptCapitalH]", "Zeeman"], "=", 
  RowBox[{
   RowBox[{
    SubscriptBox["\[Omega]", "1"], 
    RowBox[{"opI", "[", 
     RowBox[{"1", ",", "\"\<z\>\""}], "]"}]}], "+", 
   RowBox[{
    SubscriptBox["\[Omega]", "2"], 
    RowBox[{"opI", "[", 
     RowBox[{"2", ",", "\"\<z\>\""}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.9297570482358847`*^9, 3.9297570724088306`*^9}, {
  3.929761086071076*^9, 3.929761091022113*^9}, {3.9493753961299887`*^9, 
  3.949375413560275*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   TagBox[
    SubscriptBox["I", 
     RowBox[{"1", "z"}]],
    DisplayForm], " ", 
   SubscriptBox["\[Omega]", "1"]}], "+", 
  RowBox[{
   TagBox[
    SubscriptBox["I", 
     RowBox[{"2", "z"}]],
    DisplayForm], " ", 
   SubscriptBox["\[Omega]", "2"]}]}]], "Output",
 CellChangeTimes->{
  3.9297570727364626`*^9, 3.92975901457837*^9, 3.929759569484794*^9, 
   3.9297607329329634`*^9, 3.929760875574483*^9, 3.9297609680405903`*^9, 
   3.9297610358703957`*^9, 3.9297610916785088`*^9, 3.9297617677615905`*^9, 
   3.929763306801512*^9, 3.929764493691039*^9, 3.929764607077385*^9, 
   3.92976905508613*^9, 3.9297691067572474`*^9, 3.929769289870951*^9, 
   3.9297693382820497`*^9, 3.9297695228658185`*^9, {3.929769557329593*^9, 
   3.9297695818552685`*^9}, 3.9297696857980366`*^9, 3.929770072452414*^9, {
   3.9297705886295333`*^9, 3.9297706030050087`*^9}, 3.929784444558932*^9, 
   3.9297848605381737`*^9, 3.9297850683137546`*^9, 3.929785377566633*^9, 
   3.9297855327467566`*^9, {3.9301807496835957`*^9, 3.930180769957975*^9}, 
   3.930181107402342*^9, 3.93018116688455*^9, 3.9301812761086583`*^9, {
   3.949375404127507*^9, 3.949375413892925*^9}, 3.949392335585311*^9, 
   3.9493930441309566`*^9, 3.949451919800558*^9, 3.949453954782632*^9, 
   3.949454664073141*^9, 3.94945470658842*^9, 3.9495366777204556`*^9, 
   3.9495455847587404`*^9, 3.9501695158611183`*^9, 3.950169598478331*^9, 
   3.9501696850532837`*^9, 3.9501697942288175`*^9, 3.9501735720399446`*^9, 
   3.952497427806991*^9, 3.958434971764332*^9, 3.9584549054007998`*^9, 
   3.958455627179434*^9, 3.9584560592784233`*^9, 3.95845625584636*^9, 
   3.9584569751096487`*^9, 3.9584580823627987`*^9, 3.958458416388877*^9, 
   3.958462548453514*^9, 3.9584679238393965`*^9}]
}, Open  ]],

Cell[TextData[{
 "where ",
 Cell[BoxData[
  RowBox[{" ", 
   SubscriptBox["\[Omega]", "1"]}]],
  CellChangeTimes->{3.9297570727364626`*^9}],
 "=-",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Gamma]", "1"], 
    SubscriptBox["B", "0"]}], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  RowBox[{" ", 
   SubscriptBox["\[Omega]", "2"]}]],
  CellChangeTimes->{3.9297570727364626`*^9}],
 "=-",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Gamma]", "2"], 
    SubscriptBox["B", "0"]}], TraditionalForm]]],
 " are angular precession frequencies of the spins; ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Gamma]", "1"], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Gamma]", "2"], TraditionalForm]]],
 " are their gyromagnetic ratios."
}], "Input",
 Evaluatable->False,
 CellChangeTimes->{{3.9297568739645395`*^9, 3.929756878807661*^9}, {
  3.929756920340457*^9, 3.9297569715296845`*^9}, {3.929757002411059*^9, 
  3.929757016912091*^9}, {3.929757082561387*^9, 3.929757115656657*^9}, {
  3.9297571800156975`*^9, 3.929757283956853*^9}},
 FontWeight->"Plain"],

Cell[TextData[{
 "Energy of the indirect interaction betweeen the spins ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["I", "1"], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["I", "2"], TraditionalForm]]],
 " is\[LineSeparator]"
}], "Input",
 Evaluatable->False,
 CellChangeTimes->{{3.9297568739645395`*^9, 3.929756878807661*^9}, {
   3.929756920340457*^9, 3.9297569715296845`*^9}, {3.929757002411059*^9, 
   3.929757016912091*^9}, {3.929757139513809*^9, 3.9297571523258677`*^9}, {
   3.929757304023987*^9, 3.9297573093170333`*^9}, 3.958467926667343*^9},
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["J", 
       RowBox[{"anti", ",", "x"}]], ",", 
      SubscriptBox["J", 
       RowBox[{"anti", ",", "y"}]], ",", 
      SubscriptBox["J", 
       RowBox[{"anti", ",", "z"}]]}], "}"}], "=", "\[IndentingNewLine]", 
    RowBox[{"TrigToExp", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"TrigExpand", "[", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", 
         RowBox[{"\[ScriptCapitalA]", " ", 
          RowBox[{"Cos", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               SubscriptBox["\[Omega]", "1"], "-", 
               SubscriptBox["\[Omega]", "2"]}], ")"}], "\[ScriptT]"}], "+", 
            "\[Phi]"}], "]"}]}]}], "}"}], "]"}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"Sin", "[", "\[Phi]", "]"}], "\[Rule]", "sin\[Phi]"}], ",", 
        RowBox[{
         RowBox[{"Cos", "[", "\[Phi]", "]"}], "\[Rule]", "cos\[Phi]"}]}], 
       "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  SubscriptBox["\[ScriptCapitalH]", "\[ScriptCapitalJ]"], "=", 
  RowBox[{
   RowBox[{"2", " ", "\[Pi]", " ", "\[ScriptCapitalJ]", " ", 
    RowBox[{
     RowBox[{"opI", "[", "1", "]"}], ".", 
     RowBox[{"opI", "[", "2", "]"}]}]}], "+", 
   RowBox[{"2", "\[Pi]", " ", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["J", 
        RowBox[{"anti", ",", "x"}]], ",", 
       SubscriptBox["J", 
        RowBox[{"anti", ",", "y"}]], ",", 
       SubscriptBox["J", 
        RowBox[{"anti", ",", "z"}]]}], "}"}], ".", 
     RowBox[{"OperatorCross", "[", 
      RowBox[{"1", ",", "2"}], "]"}]}]}]}]}]}], "Input",
 CellChangeTimes->{{3.92975751195119*^9, 3.9297575199326124`*^9}, {
   3.9297575690543365`*^9, 3.9297576750559206`*^9}, {3.9297584089262867`*^9, 
   3.9297584134231105`*^9}, {3.9297584489204855`*^9, 
   3.9297584648693657`*^9}, {3.929758698112522*^9, 3.9297587554110856`*^9}, {
   3.9297591843106375`*^9, 3.929759203135015*^9}, {3.92975935125292*^9, 
   3.9297593515798874`*^9}, {3.9297694544074397`*^9, 3.9297694589255533`*^9}, 
   3.929769590003686*^9, {3.929769656072501*^9, 3.929769665536494*^9}, 
   3.92976993587959*^9, {3.9297701668046703`*^9, 3.92977018263323*^9}, {
   3.9297846955936146`*^9, 3.929784695676941*^9}, {3.9297850014734507`*^9, 
   3.929785001604987*^9}, {3.930181389127329*^9, 3.9301814076926837`*^9}, {
   3.9493924626466875`*^9, 3.9493924639596033`*^9}, {3.949392498971122*^9, 
   3.9493925216339083`*^9}, {3.949392560357374*^9, 3.949392640462913*^9}, {
   3.949392824488834*^9, 3.9493928313310213`*^9}, {3.9493928735145497`*^9, 
   3.9493928749929647`*^9}, {3.9493933083041687`*^9, 
   3.9493933118319497`*^9}, {3.949454050106407*^9, 3.9494540557812786`*^9}, {
   3.9494542764956117`*^9, 3.949454293438935*^9}, 3.9494546685588083`*^9, {
   3.9494547125795636`*^9, 3.94945471376362*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", "\[Pi]", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      FractionBox["1", "2"], " ", "cos\[Phi]", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", "\[ScriptT]", " ", 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["\[Omega]", "1"], "-", 
          SubscriptBox["\[Omega]", "2"]}], ")"}]}]], " ", 
      "\[ScriptCapitalA]"}], "+", 
     RowBox[{
      FractionBox["1", "2"], " ", "cos\[Phi]", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[ImaginaryI]", " ", "\[ScriptT]", " ", 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["\[Omega]", "1"], "-", 
          SubscriptBox["\[Omega]", "2"]}], ")"}]}]], " ", 
      "\[ScriptCapitalA]"}], "-", 
     RowBox[{
      FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", "\[ScriptT]", " ", 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["\[Omega]", "1"], "-", 
          SubscriptBox["\[Omega]", "2"]}], ")"}]}]], " ", "sin\[Phi]", " ", 
      "\[ScriptCapitalA]"}], "+", 
     RowBox[{
      FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[ImaginaryI]", " ", "\[ScriptT]", " ", 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["\[Omega]", "1"], "-", 
          SubscriptBox["\[Omega]", "2"]}], ")"}]}]], " ", "sin\[Phi]", " ", 
      "\[ScriptCapitalA]"}]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     TagBox[
      RowBox[{
       TagBox[
        SubscriptBox["I", 
         RowBox[{"1", "x"}]],
        DisplayForm], 
       AdjustmentBox["\[Bullet]",
        BoxMargins->{{-0.3, 0}, {0, 0}}], 
       TagBox[
        SubscriptBox["I", 
         RowBox[{"2", "y"}]],
        DisplayForm]}],
      DisplayForm], "-", 
     TagBox[
      RowBox[{
       TagBox[
        SubscriptBox["I", 
         RowBox[{"1", "y"}]],
        DisplayForm], 
       AdjustmentBox["\[Bullet]",
        BoxMargins->{{-0.3, 0}, {0, 0}}], 
       TagBox[
        SubscriptBox["I", 
         RowBox[{"2", "x"}]],
        DisplayForm]}],
      DisplayForm]}], ")"}]}], "+", 
  RowBox[{"2", " ", "\[Pi]", " ", "\[ScriptCapitalJ]", " ", 
   RowBox[{"(", 
    RowBox[{
     TagBox[
      RowBox[{
       TagBox[
        SubscriptBox["I", 
         RowBox[{"1", "x"}]],
        DisplayForm], 
       AdjustmentBox["\[Bullet]",
        BoxMargins->{{-0.3, 0}, {0, 0}}], 
       TagBox[
        SubscriptBox["I", 
         RowBox[{"2", "x"}]],
        DisplayForm]}],
      DisplayForm], "+", 
     TagBox[
      RowBox[{
       TagBox[
        SubscriptBox["I", 
         RowBox[{"1", "y"}]],
        DisplayForm], 
       AdjustmentBox["\[Bullet]",
        BoxMargins->{{-0.3, 0}, {0, 0}}], 
       TagBox[
        SubscriptBox["I", 
         RowBox[{"2", "y"}]],
        DisplayForm]}],
      DisplayForm], "+", 
     TagBox[
      RowBox[{
       TagBox[
        SubscriptBox["I", 
         RowBox[{"1", "z"}]],
        DisplayForm], 
       AdjustmentBox["\[Bullet]",
        BoxMargins->{{-0.3, 0}, {0, 0}}], 
       TagBox[
        SubscriptBox["I", 
         RowBox[{"2", "z"}]],
        DisplayForm]}],
      DisplayForm]}], ")"}]}]}]], "Output",
 CellChangeTimes->{{3.9493926036807904`*^9, 3.949392652652095*^9}, {
   3.9493928228614173`*^9, 3.949392834704887*^9}, {3.9493928754163876`*^9, 
   3.9493929214004188`*^9}, 3.949393046645733*^9, 3.9493933125446043`*^9, 
   3.9494519216265373`*^9, 3.949453956048133*^9, 3.949454056907069*^9, 
   3.9494541425204554`*^9, 3.9494542226150475`*^9, {3.949454277176459*^9, 
   3.949454293920277*^9}, {3.9494546655669003`*^9, 3.9494546689816647`*^9}, {
   3.9494547080491905`*^9, 3.9494547142710776`*^9}, 3.949536679027134*^9, 
   3.949545586549629*^9, 3.950169517424679*^9, 3.9501696001982703`*^9, 
   3.950169686737604*^9, 3.9501697969799566`*^9, 3.9501735720699415`*^9, 
   3.9524974278389926`*^9, 3.9584349745678496`*^9, 3.9584549069153476`*^9, 
   3.9584556285503693`*^9, 3.958456059307227*^9, 3.9584562558663597`*^9, 
   3.9584569751511188`*^9, 3.958458082382798*^9, 3.958458416410909*^9, 
   3.958462548473506*^9, 3.9584679287628927`*^9}]
}, Open  ]],

Cell[TextData[{
 "where the istropic coupling is \[ScriptCapitalJ] (in Hz), \
\[ScriptCapitalR][\[ScriptT]] the rotation matrix of the molecule, ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox[
     SubscriptBox["J", "anti"],
     FontWeight->"Bold"], "=", 
    RowBox[{"(", 
     RowBox[{
      SubscriptBox["J", 
       RowBox[{"anti", ",", "x"}]], ",", 
      SubscriptBox["J", 
       RowBox[{"anti", ",", "y"}]], ",", 
      SubscriptBox["J", 
       RowBox[{"anti", ",", "z"}]]}], ")"}]}], TraditionalForm]]],
 " is the antisymmetric coupling (in Hz)."
}], "Input",
 Evaluatable->False,
 CellChangeTimes->{{3.9297568739645395`*^9, 3.929756878807661*^9}, {
   3.929756920340457*^9, 3.9297569715296845`*^9}, {3.929757002411059*^9, 
   3.929757016912091*^9}, {3.929757139513809*^9, 3.9297571523258677`*^9}, {
   3.929757304023987*^9, 3.9297573093170333`*^9}, {3.9297594339916058`*^9, 
   3.9297595228886614`*^9}, 3.949392833041503*^9, 3.949536682904089*^9},
 FontWeight->"Plain"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    SubscriptBox["\[ScriptCapitalH]", "\[ScriptCapitalD]"], "[", "\[Tau]_", 
    "]"}], ":=", 
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], "k"], 
      RowBox[{"\[GothicCapitalD]", "[", 
       RowBox[{"2", ",", "l", ",", 
        RowBox[{"-", "k"}], ",", "\[Tau]"}], "]"}], 
      RowBox[{"opT", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "k"}], "}"}]}], "]"}], 
      RowBox[{
       RowBox[{"CartesianToSpherical", "[", 
        RowBox[{"2", ",", 
         RowBox[{"3", 
          SubscriptBox["\[ScriptB]", "FH"], " ", 
          RowBox[{"DiagonalMatrix", "[", 
           RowBox[{"{", 
            RowBox[{"2", ",", 
             RowBox[{"-", "1"}], ",", 
             RowBox[{"-", "1"}]}], "}"}], "]"}]}]}], "]"}], "[", "l", "]"}]}],
      ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", 
       RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"l", ",", 
       RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.9501696117895727`*^9, 3.950169613623601*^9}, 
   3.950171593007228*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[ScriptCapitalL]", "=", 
   RowBox[{
    RowBox[{"Superoperator", "[", "\[IndentingNewLine]", "           ", 
     RowBox[{"SchrodingerToInteractionPicture", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", "I"}], " ", 
         RowBox[{"CommutationSuperoperator", "[", 
          SubscriptBox["\[ScriptCapitalH]", "\[ScriptCapitalJ]"], "]"}]}], 
        "+", 
        RowBox[{
        "Superoperator", "[", "\[IndentingNewLine]", 
         "                                                                    \
                                                                              \
                     ", 
         RowBox[{
         "Lindbladian", "[", "\[IndentingNewLine]", 
          "                                                                   \
                                                                              \
                                              ", 
          RowBox[{
           RowBox[{
            SubscriptBox["\[ScriptCapitalH]", "\[ScriptCapitalD]"], "[", "0", 
            "]"}], ",", "\[IndentingNewLine]", 
           "                                                                  \
                                                                              \
                                               ", 
           RowBox[{"ExpressOperator", "[", " ", 
            RowBox[{
             RowBox[{"Exp", "[", 
              RowBox[{
               RowBox[{"-", "I"}], " ", 
               SubscriptBox["\[Tau]", "c"], " ", 
               RowBox[{"CommutationSuperoperator", "[", 
                SubscriptBox["\[ScriptCapitalH]", "Zeeman"], "]"}]}], "]"}], 
             "[", 
             RowBox[{"Adjoint", "[", 
              RowBox[{
               SubscriptBox["\[ScriptCapitalH]", "\[ScriptCapitalD]"], "[", 
               SubscriptBox["\[Tau]", "c"], "]"}], "]"}], "]"}], "]"}], ",", 
           "2"}], "\[IndentingNewLine]", 
          
          "                                                                   \
                                                                              \
                                                ", "]"}], 
         "\[IndentingNewLine]", 
         "                                                                    \
                                                                              \
                                        ", "]"}]}], ",", 
       "\[IndentingNewLine]", 
       "                                                                      \
   ", 
       SubscriptBox["\[ScriptCapitalH]", "Zeeman"], ",", "2"}], "]"}], 
     "\[IndentingNewLine]", "                                    ", "]"}], 
    "+", "\[IndentingNewLine]", 
    RowBox[{"ThermalizeSuperoperator", "[", 
     RowBox[{
      RowBox[{"PhenomenologicalRelaxationSuperoperator", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"3", 
              SuperscriptBox[
               SubscriptBox["\[ScriptB]", "FF"], "2"], 
              SubscriptBox["\[Tau]", "2"]}], ")"}], 
            RowBox[{"-", "1"}]], ",", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"3", 
              SuperscriptBox[
               SubscriptBox["\[ScriptB]", "FF"], "2"], 
              SubscriptBox["\[Tau]", "2"]}], ")"}], 
            RowBox[{"-", "1"}]]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"3", 
              SuperscriptBox[
               SubscriptBox["\[ScriptB]", "HH"], "2"], 
              SubscriptBox["\[Tau]", "2"]}], ")"}], 
            RowBox[{"-", "1"}]], ",", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"3", 
              SuperscriptBox[
               SubscriptBox["\[ScriptB]", "HH"], "2"], 
              SubscriptBox["\[Tau]", "2"]}], ")"}], 
            RowBox[{"-", "1"}]]}], "}"}]}], "}"}], "]"}], ",", 
      SubscriptBox["\[ScriptCapitalH]", "Zeeman"], ",", "300"}], "]"}]}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.929763606730373*^9, 3.9297636077221775`*^9}, {
   3.9297848264798355`*^9, 3.929784830358699*^9}, {3.9301806114243345`*^9, 
   3.9301806155873547`*^9}, {3.9301813569093323`*^9, 
   3.9301813782516336`*^9}, {3.9301814257604103`*^9, 3.930181685001317*^9}, {
   3.9493935971784534`*^9, 3.9493936491593847`*^9}, {3.9493936892432814`*^9, 
   3.9493937600870523`*^9}, {3.949393882575343*^9, 3.9493938953140793`*^9}, {
   3.9494540025623455`*^9, 3.94945402859719*^9}, {3.949454261980647*^9, 
   3.9494542637262354`*^9}, {3.9494543163548355`*^9, 
   3.9494543180941305`*^9}, {3.9495454366004047`*^9, 
   3.9495454401690907`*^9}, {3.94954583001618*^9, 3.949545833163107*^9}, {
   3.950154845919402*^9, 3.9501548545252914`*^9}, {3.9501695302289877`*^9, 
   3.9501695395963507`*^9}, {3.950169826002699*^9, 3.9501698347214594`*^9}, {
   3.9501698704918847`*^9, 3.9501698813756666`*^9}, {3.9501704541285477`*^9, 
   3.950170485763731*^9}, {3.950170805124567*^9, 3.9501708100719132`*^9}, {
   3.9501708789947224`*^9, 3.950170886101844*^9}, 3.9501709697460527`*^9, {
   3.9501710383917117`*^9, 3.9501710400757556`*^9}, {3.950171144670751*^9, 
   3.9501711454772053`*^9}, 3.9501712991010776`*^9, 3.950171482314021*^9, 
   3.950171563397753*^9, 3.9501716861145535`*^9, {3.950171738052456*^9, 
   3.9501717620081635`*^9}, {3.9501717943588915`*^9, 3.950171816604795*^9}, {
   3.9501718511470995`*^9, 3.9501718737188816`*^9}, {3.95017194857942*^9, 
   3.950171963524082*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", "\[IndentingNewLine]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     FractionBox[
      RowBox[{"\[HBar]", " ", 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["\[Omega]", "1"], "-", 
         SubscriptBox["\[Omega]", "2"]}], ")"}]}], 
      RowBox[{"4", " ", "kB", " ", "T"}]], ")"}], 
    RowBox[{"-", "1"}]], 
   RowBox[{"ExpressOperator", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"Superoperator", "[", "\[IndentingNewLine]", 
       RowBox[{"SchrodingerToInteractionPicture", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "I"}], " ", 
          RowBox[{"CommutationSuperoperator", "[", 
           SubscriptBox["\[ScriptCapitalH]", "\[ScriptCapitalJ]"], "]"}]}], 
         ",", 
         SubscriptBox["\[ScriptCapitalH]", "Zeeman"], ",", "2"}], "]"}], 
       "\[IndentingNewLine]", "]"}], "[", "\[IndentingNewLine]", 
      RowBox[{"ExpressOperator", "[", "\[IndentingNewLine]", 
       RowBox[{"ThermalEquilibriumDensityOperator", "[", 
        RowBox[{
         SubscriptBox["\[ScriptCapitalH]", "Zeeman"], ",", "T"}], "]"}], 
       "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"CartesianProductOperatorBasis", "[", "]"}]}], 
    "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", "]"}]], "Input",
 CellChangeTimes->{{3.9584555952336674`*^9, 3.958455612537116*^9}, {
  3.9584556486957293`*^9, 3.9584556524300385`*^9}}],

Cell[BoxData[
 RowBox[{"\[Pi]", " ", "\[ScriptCapitalA]", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"cos\[Phi]", " ", 
     RowBox[{"(", 
      TagBox[
       RowBox[{
        TagBox[
         SubscriptBox["I", 
          RowBox[{"1", "x"}]],
         DisplayForm], 
        AdjustmentBox["\[Bullet]",
         BoxMargins->{{-0.3, 0}, {0, 0}}], 
        TagBox[
         SubscriptBox["I", 
          RowBox[{"2", "x"}]],
         DisplayForm]}],
       DisplayForm], ")"}]}], "-", 
    RowBox[{"sin\[Phi]", " ", 
     RowBox[{"(", 
      TagBox[
       RowBox[{
        TagBox[
         SubscriptBox["I", 
          RowBox[{"1", "x"}]],
         DisplayForm], 
        AdjustmentBox["\[Bullet]",
         BoxMargins->{{-0.3, 0}, {0, 0}}], 
        TagBox[
         SubscriptBox["I", 
          RowBox[{"2", "y"}]],
         DisplayForm]}],
       DisplayForm], ")"}]}], "+", 
    RowBox[{"sin\[Phi]", " ", 
     RowBox[{"(", 
      TagBox[
       RowBox[{
        TagBox[
         SubscriptBox["I", 
          RowBox[{"1", "y"}]],
         DisplayForm], 
        AdjustmentBox["\[Bullet]",
         BoxMargins->{{-0.3, 0}, {0, 0}}], 
        TagBox[
         SubscriptBox["I", 
          RowBox[{"2", "x"}]],
         DisplayForm]}],
       DisplayForm], ")"}]}], "+", 
    RowBox[{"cos\[Phi]", " ", 
     RowBox[{"(", 
      TagBox[
       RowBox[{
        TagBox[
         SubscriptBox["I", 
          RowBox[{"1", "y"}]],
         DisplayForm], 
        AdjustmentBox["\[Bullet]",
         BoxMargins->{{-0.3, 0}, {0, 0}}], 
        TagBox[
         SubscriptBox["I", 
          RowBox[{"2", "y"}]],
         DisplayForm]}],
       DisplayForm], ")"}]}]}], ")"}]}]], "Output",
 CellChangeTimes->{{3.958455613888846*^9, 3.9584556531394463`*^9}, 
   3.9584559793096848`*^9, 3.9584560655133553`*^9, 3.9584562624506803`*^9, 
   3.958456981220044*^9, 3.9584580886451344`*^9, 3.9584584229918547`*^9, 
   3.9584625546779213`*^9, 3.958467960854698*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"ExpressOperator", "[", 
  RowBox[{
   RowBox[{"SingleTransitionOperator", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "3"}], "}"}], ",", 
       RowBox[{"SingletTripletBasis", "[", "]"}]}], "}"}], ",", "\"\<y\>\""}],
     "]"}], ",", 
   RowBox[{"CartesianProductOperatorBasis", "[", "]"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"ExpressOperator", "[", 
  RowBox[{
   RowBox[{"SingleTransitionOperator", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "1"}], "}"}], ",", 
       RowBox[{"SingletTripletBasis", "[", "]"}]}], "}"}], ",", "\"\<z\>\""}],
     "]"}], ",", 
   RowBox[{"CartesianProductOperatorBasis", "[", "]"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.958455694878686*^9, 3.9584558665948534`*^9}, {
  3.9584559927996106`*^9, 3.9584560180339894`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{"(", 
    TagBox[
     RowBox[{
      TagBox[
       SubscriptBox["I", 
        RowBox[{"1", "x"}]],
       DisplayForm], 
      AdjustmentBox["\[Bullet]",
       BoxMargins->{{-0.3, 0}, {0, 0}}], 
      TagBox[
       SubscriptBox["I", 
        RowBox[{"2", "y"}]],
       DisplayForm]}],
     DisplayForm], ")"}]}], "+", 
  TagBox[
   RowBox[{
    TagBox[
     SubscriptBox["I", 
      RowBox[{"1", "y"}]],
     DisplayForm], 
    AdjustmentBox["\[Bullet]",
     BoxMargins->{{-0.3, 0}, {0, 0}}], 
    TagBox[
     SubscriptBox["I", 
      RowBox[{"2", "x"}]],
     DisplayForm]}],
   DisplayForm]}]], "Output",
 CellChangeTimes->{{3.958455682106662*^9, 3.9584558668762226`*^9}, {
   3.9584559747097282`*^9, 3.9584560183726177`*^9}, 3.9584560655533867`*^9, 
   3.9584562625101357`*^9, 3.958456981261635*^9, 3.9584580886881666`*^9, 
   3.9584584230298843`*^9, 3.9584625547239213`*^9, 3.958467965185027*^9}],

Cell[BoxData[
 RowBox[{
  TagBox[
   RowBox[{
    TagBox[
     SubscriptBox["I", 
      RowBox[{"1", "x"}]],
     DisplayForm], 
    AdjustmentBox["\[Bullet]",
     BoxMargins->{{-0.3, 0}, {0, 0}}], 
    TagBox[
     SubscriptBox["I", 
      RowBox[{"2", "x"}]],
     DisplayForm]}],
   DisplayForm], "+", 
  TagBox[
   RowBox[{
    TagBox[
     SubscriptBox["I", 
      RowBox[{"1", "y"}]],
     DisplayForm], 
    AdjustmentBox["\[Bullet]",
     BoxMargins->{{-0.3, 0}, {0, 0}}], 
    TagBox[
     SubscriptBox["I", 
      RowBox[{"2", "y"}]],
     DisplayForm]}],
   DisplayForm]}]], "Output",
 CellChangeTimes->{{3.958455682106662*^9, 3.9584558668762226`*^9}, {
   3.9584559747097282`*^9, 3.9584560183726177`*^9}, 3.9584560655533867`*^9, 
   3.9584562625101357`*^9, 3.958456981261635*^9, 3.9584580886881666`*^9, 
   3.9584584230298843`*^9, 3.9584625547239213`*^9, 3.958467965206031*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"frqlist", "=", 
    RowBox[{"{", 
     RowBox[{
     "0.001", ",", "0.05", ",", "0.1", ",", "0.2", ",", "0.3", ",", "0.4", 
      ",", "0.5", ",", "0.568", ",", "0.75", ",", "1", ",", "1.5", ",", "2", 
      ",", "2.5", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", 
      "7.49"}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"eq", "=", 
    RowBox[{"Abs", "[", 
     RowBox[{"UseNumericalValues", "[", 
      RowBox[{
       FractionBox[
        RowBox[{"\[HBar]", " ", 
         SubscriptBox["\[Omega]", "1"]}], 
        RowBox[{"4", " ", "kB", " ", "T"}]], ",", "\"\<jcoupling\>\"", ",", 
       "0"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Rho]0", "=", 
    RowBox[{"UseNumericalValues", "[", 
     RowBox[{
      RowBox[{"ThermalEquilibriumDensityOperator", "[", 
       RowBox[{
        SubscriptBox["\[ScriptCapitalH]", "Zeeman"], ",", "T"}], "]"}], ",", 
      "\"\<jcoupling\>\"", ",", "0"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["\[ScriptCapitalS]", 
        RowBox[{"1", ",", "f"}]], ",", 
       SubscriptBox["\[ScriptCapitalS]", 
        RowBox[{"2", ",", "f"}]]}], "}"}], "=", 
     RowBox[{"Trajectory", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"\[Rho]0", "\[Rule]", 
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"opI", "[", 
             RowBox[{"1", ",", "\"\<x\>\""}], "]"}], ".", 
            RowBox[{"opI", "[", 
             RowBox[{"2", ",", "\"\<y\>\""}], "]"}]}], "-", 
           RowBox[{
            RowBox[{"opI", "[", 
             RowBox[{"1", ",", "\"\<y\>\""}], "]"}], ".", 
            RowBox[{"opI", "[", 
             RowBox[{"2", ",", "\"\<x\>\""}], "]"}]}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"opI", "[", 
             RowBox[{"1", ",", "\"\<x\>\""}], "]"}], ".", 
            RowBox[{"opI", "[", 
             RowBox[{"2", ",", "\"\<x\>\""}], "]"}]}], "+", 
           RowBox[{
            RowBox[{"opI", "[", 
             RowBox[{"1", ",", "\"\<y\>\""}], "]"}], ".", 
            RowBox[{"opI", "[", 
             RowBox[{"2", ",", "\"\<y\>\""}], "]"}]}]}]}], 
         "\[IndentingNewLine]", "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"RotationSuperoperator", "[", 
          RowBox[{"1", ",", 
           RowBox[{"{", 
            RowBox[{"\[Pi]", ",", "\"\<x\>\""}], "}"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"None", ",", "50"}], "}"}]}], "\[IndentingNewLine]", "}"}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{"BackgroundGenerator", "\[Rule]", 
        RowBox[{
        "Superoperator", "[", "\[IndentingNewLine]", 
         "                                                    ", 
         RowBox[{
         "UseNumericalValues", "[", "\[IndentingNewLine]", 
          "                                                            ", 
          RowBox[{
           RowBox[{
           "SuperoperatorMatrixRepresentation", "[", "\[ScriptCapitalL]", 
            "]"}], ",", "\"\<jcoupling\>\"", ",", "f"}], "]"}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"NormalizationFactor", "\[Rule]", "eq"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"InterpolationPoints", "\[Rule]", " ", "10000"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"MaxStepSize", "\[Rule]", 
        SuperscriptBox["10", 
         RowBox[{"-", "8"}]]}]}], "]"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"f", ",", "frqlist"}], "}"}]}], "\[IndentingNewLine]", "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.9297848769691687`*^9, 3.9297848777961226`*^9}, {
   3.9297849137582645`*^9, 3.9297849796333036`*^9}, {3.9297853039752803`*^9, 
   3.9297853346355696`*^9}, 3.930181060383525*^9, {3.9301813258608675`*^9, 
   3.9301813307419224`*^9}, {3.9301817680588655`*^9, 3.930181785039874*^9}, {
   3.9301819743691387`*^9, 3.9301819744581385`*^9}, {3.949393918784909*^9, 
   3.9493939982802587`*^9}, {3.9493945961742163`*^9, 3.949394598077523*^9}, {
   3.9493946385729623`*^9, 3.949394644654421*^9}, {3.9494520412228985`*^9, 
   3.949452114231209*^9}, {3.949454388721452*^9, 3.9494543926769395`*^9}, {
   3.949454441820709*^9, 3.9494545662509365`*^9}, {3.9494546146699853`*^9, 
   3.94945463794543*^9}, {3.9494548594238653`*^9, 3.9494548911740026`*^9}, {
   3.949455041383704*^9, 3.9494550779348755`*^9}, {3.949455165125407*^9, 
   3.9494551944855366`*^9}, {3.9494552829330454`*^9, 
   3.9494553352526164`*^9}, {3.9494553896425*^9, 3.949455389857184*^9}, {
   3.9494559238564653`*^9, 3.949455933508869*^9}, {3.9494563612229457`*^9, 
   3.949456385722101*^9}, {3.9494564817504587`*^9, 3.9494564828886766`*^9}, {
   3.9494565930309095`*^9, 3.9494565931037827`*^9}, {3.949456631821828*^9, 
   3.949456632129445*^9}, {3.949456945776065*^9, 3.949456948406827*^9}, {
   3.949457009208192*^9, 3.9494570093075285`*^9}, {3.9494572765769005`*^9, 
   3.949457317300383*^9}, {3.949457643114718*^9, 3.949457645175348*^9}, {
   3.9494577505893116`*^9, 3.9494577514206305`*^9}, {3.9494577919234333`*^9, 
   3.949457793178851*^9}, {3.94945782469937*^9, 3.949457824715129*^9}, 
   3.949457968273319*^9, {3.949460789400734*^9, 3.949460791192217*^9}, {
   3.9495369758005266`*^9, 3.949537003342338*^9}, {3.9501699454214115`*^9, 
   3.9501699466178403`*^9}, {3.9501699910037446`*^9, 
   3.9501700132028217`*^9}, {3.950172000711382*^9, 3.9501720066918755`*^9}, {
   3.9501724037201443`*^9, 3.950172409904271*^9}, 3.9501725868830757`*^9, {
   3.958455039900552*^9, 3.9584550608227453`*^9}, {3.958456076024646*^9, 
   3.9584560800752344`*^9}, {3.958456232452507*^9, 3.9584562325069866`*^9}, {
   3.9584568615714016`*^9, 3.9584568621684265`*^9}, {3.958456913136923*^9, 
   3.9584569149747643`*^9}, {3.9584572697307425`*^9, 3.958457279050086*^9}, {
   3.9584577975313826`*^9, 3.9584578125370183`*^9}, {3.9584584106688733`*^9, 
   3.9584584134330916`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"minS1", "=", "\[IndentingNewLine]", 
    RowBox[{"Table", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"extr", "=", 
        RowBox[{"t", "/.", 
         RowBox[{
          RowBox[{"FindMinimum", "[", 
           RowBox[{
            RowBox[{
             SubscriptBox["\[ScriptCapitalS]", 
              RowBox[{"1", ",", 
               RowBox[{"frqlist", "[", 
                RowBox[{"[", "i", "]"}], "]"}]}]], "[", "t", "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"t", ",", "0", ",", "20"}], "}"}]}], "]"}], "[", 
          RowBox[{"[", "2", "]"}], "]"}]}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"extr", ",", 
         RowBox[{
          SubscriptBox["\[ScriptCapitalS]", 
           RowBox[{"1", ",", 
            RowBox[{"frqlist", "[", 
             RowBox[{"[", "i", "]"}], "]"}]}]], "[", "extr", "]"}]}], "}"}]}],
       ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "17"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"minS2", "=", "\[IndentingNewLine]", 
    RowBox[{"Table", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"extr", "=", 
        RowBox[{"t", "/.", 
         RowBox[{
          RowBox[{"FindMinimum", "[", 
           RowBox[{
            RowBox[{
             SubscriptBox["\[ScriptCapitalS]", 
              RowBox[{"2", ",", 
               RowBox[{"frqlist", "[", 
                RowBox[{"[", "i", "]"}], "]"}]}]], "[", "t", "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"t", ",", "0", ",", "20"}], "}"}]}], "]"}], "[", 
          RowBox[{"[", "2", "]"}], "]"}]}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"extr", ",", 
         RowBox[{
          SubscriptBox["\[ScriptCapitalS]", 
           RowBox[{"2", ",", 
            RowBox[{"frqlist", "[", 
             RowBox[{"[", "i", "]"}], "]"}]}]], "[", "extr", "]"}]}], "}"}]}],
       ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "8"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"maxS2", "=", "\[IndentingNewLine]", 
   RowBox[{"Table", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"extr", "=", 
       RowBox[{"t", "/.", 
        RowBox[{
         RowBox[{"FindMaximum", "[", 
          RowBox[{
           RowBox[{
            SubscriptBox["\[ScriptCapitalS]", 
             RowBox[{"2", ",", 
              RowBox[{"frqlist", "[", 
               RowBox[{"[", "i", "]"}], "]"}]}]], "[", "t", "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"t", ",", "0", ",", "20"}], "}"}]}], "]"}], "[", 
         RowBox[{"[", "2", "]"}], "]"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"extr", ",", 
        RowBox[{
         SubscriptBox["\[ScriptCapitalS]", 
          RowBox[{"2", ",", 
           RowBox[{"frqlist", "[", 
            RowBox[{"[", "i", "]"}], "]"}]}]], "[", "extr", "]"}]}], "}"}]}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "10", ",", "15"}], "}"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.949538011180913*^9, 3.949538072911774*^9}, {
  3.9495382691712976`*^9, 3.949538370554034*^9}, {3.9495384496850567`*^9, 
  3.949538453697611*^9}, {3.9495385347211375`*^9, 3.9495385349612837`*^9}, {
  3.9495385731079535`*^9, 3.9495385731817665`*^9}, {3.9495386533088307`*^9, 
  3.949538672609412*^9}, {3.9495387523108807`*^9, 3.949538816850185*^9}, {
  3.9495388473502216`*^9, 3.949538920265233*^9}, {3.94953895141783*^9, 
  3.949538957018611*^9}, {3.94953898936617*^9, 3.9495390012132645`*^9}, {
  3.9495392983761396`*^9, 3.949539440758434*^9}, {3.9495396417701516`*^9, 
  3.949539659318574*^9}, {3.950172563974887*^9, 3.9501725780060496`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"gr1", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Orange", ",", 
      RowBox[{"Arrow", "[", 
       RowBox[{"BezierCurve", "[", 
        RowBox[{"Take", "[", 
         RowBox[{"minS1", ",", 
          RowBox[{"{", 
           RowBox[{"6", ",", "10"}], "}"}]}], "]"}], "]"}], "]"}]}], "}"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gr2", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Orange", ",", 
      RowBox[{"Arrow", "[", 
       RowBox[{"BezierCurve", "[", 
        RowBox[{"Take", "[", 
         RowBox[{"minS1", ",", 
          RowBox[{"{", 
           RowBox[{"10", ",", "17"}], "}"}]}], "]"}], "]"}], "]"}]}], "}"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gr3", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Lighter", "[", "Blue", "]"}], ",", 
      RowBox[{"Arrow", "[", 
       RowBox[{"BezierCurve", "[", 
        RowBox[{"Join", "[", 
         RowBox[{"minS2", ",", 
          RowBox[{"Take", "[", 
           RowBox[{"maxS2", ",", 
            RowBox[{"{", "1", "}"}]}], "]"}]}], "]"}], "]"}], "]"}]}], "}"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"gr4", "=", 
    RowBox[{"Graphics", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Darker", "[", "Green", "]"}], ",", 
       RowBox[{"Arrow", "[", 
        RowBox[{"BezierCurve", "[", "maxS2", "]"}], "]"}]}], "}"}], "]"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"p0", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SubscriptBox["\[ScriptCapitalS]", 
          RowBox[{"2", ",", "0.001"}]], "[", "t", "]"}], ",", 
        RowBox[{
         SubscriptBox["\[ScriptCapitalS]", 
          RowBox[{"1", ",", "0.568"}]], "[", "t", "]"}], ",", 
        RowBox[{
         SubscriptBox["\[ScriptCapitalS]", 
          RowBox[{"2", ",", "7.49"}]], "[", "t", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "20"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", "All"}], ",", "\[IndentingNewLine]", 
      RowBox[{"ImageSize", "\[Rule]", "800"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotLegends", "\[Rule]", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
          "\"\<\[LeftAngleBracket]\!\(\*SubscriptBox[\(I\), \(1  \
x\)]\)\!\(\*SubscriptBox[\(I\), \(2  x\)]\)+\!\(\*SubscriptBox[\(I\), \(1  \
x\)]\)\!\(\*SubscriptBox[\(I\), \(2  x\)]\)\[RightAngleBracket] \!\(\*
StyleBox[\"f\",
FontSlant->\"Italic\"]\) = 0.001 GHz\>\"", ",", "20"}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
          "\"\<\[LeftAngleBracket]\!\(\*SubscriptBox[\(I\), \(1  \
x\)]\)\!\(\*SubscriptBox[\(I\), \(2  y\)]\)-\!\(\*SubscriptBox[\(I\), \(1  \
y\)]\)\!\(\*SubscriptBox[\(I\), \(2  x\)]\)\[RightAngleBracket] \!\(\*
StyleBox[\"f\",
FontSlant->\"Italic\"]\) = 0.568 GHz\>\"", ",", "20"}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
          "\"\<\[LeftAngleBracket]\!\(\*SubscriptBox[\(I\), \(1  \
x\)]\)\!\(\*SubscriptBox[\(I\), \(2  x\)]\)+\!\(\*SubscriptBox[\(I\), \(1  \
x\)]\)\!\(\*SubscriptBox[\(I\), \(2  x\)]\)\[RightAngleBracket] \!\(\*
StyleBox[\"f\",
FontSlant->\"Italic\"]\) = 7.490 GHz\>\"", ",", "20"}], "]"}]}], 
        "\[IndentingNewLine]", "}"}]}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"p0", ",", "gr1", ",", "gr2", ",", "gr3", ",", "gr4", ",", 
   RowBox[{"ImageSize", "\[Rule]", "800"}]}], "]"}]}], "Input",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGCQAmIQzcYe/Fol963j+v1c70G04LOKzyB6+tM/XKpAet53
R3EQXfnGShFE+/61UAXRhy9M0wTRNgH+BiB6wbvF9iB6IVdhMIjeYxUaAqKP
nH6fDKJ5uHVTQPSmSWmZIDpHZ3YWiH7axJwPotMnNFWAaPUVGbUg+nnnIzCt
lnSzFUQfazLsA9E62aqzQfSED5oLQTSHyYelILpLJX0liObesnIHiM4w9NoL
opP+ah4D0T4f7I+D6HveXJfA7liccQVE8/Ws/gfWd/M4mNa57c+iBqSX7EkB
0zIrbouA6C+pzTIgumqfmjKITpx4Xg1EW1//pAuWX59mBKJ31U9ji85763j3
4xJOEP3k8iQFEM3Ek6MIojc7HdMH0YxNv8C0ye9eExAt4vwDTOu4PVhxquit
49mQjbtANABn9MSX
  "]],

Cell[BoxData[
 TemplateBox[{GraphicsBox[{{{{{}, {}, 
        TagBox[{
          Directive[
           Opacity[1.], 
           RGBColor[0.368417, 0.506779, 0.709798], 
           AbsoluteThickness[1.6]], 
          LineBox[CompressedData["
1:eJwV1nk8VP0XB/DBWGfGWtpsyS7r8JQW90QbiRLpUUpaRJI85UnriGwRikj2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           "]]}, Annotation[#, "Charting`Private`Tag$127138#1"]& ], 
        TagBox[{
          Directive[
           Opacity[1.], 
           RGBColor[0.880722, 0.611041, 0.142051], 
           AbsoluteThickness[1.6]], 
          LineBox[CompressedData["
1:eJwV1nk4Ve3XB/BjHs4x90hlyhwydDRItVepkCEzv0iSUKTypBJJkaEihZIh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           "]]}, Annotation[#, "Charting`Private`Tag$127138#2"]& ], 
        TagBox[{
          Directive[
           Opacity[1.], 
           RGBColor[0.560181, 0.691569, 0.194885], 
           AbsoluteThickness[1.6]], 
          LineBox[CompressedData["
1:eJwV1nc41e8bB3DbsWWVyEr2+BynklL3XaRCi0hSJJUkRamMxvcce4WszBQl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           "]]}, 
         Annotation[#, "Charting`Private`Tag$127138#3"]& ]}}, {}, {}}, {
      RGBColor[1, 0.5, 0], 
      ArrowBox[
       BezierCurveBox[{{3.585020675131421, -0.18812162521273373`}, {
        3.544786047368747, -0.22927322428136349`}, {
        3.515188196719362, -0.25531338083695515`}, {
        3.4322967415043033`, -0.3165225069763769}, {
        3.3230135040153854`, -0.3796593421695101}}]]}, {
      RGBColor[1, 0.5, 0], 
      ArrowBox[
       BezierCurveBox[{{3.3230135040153854`, -0.3796593421695101}, {
        3.160580547295719, -0.44025196247086607`}, {
        3.075272573199465, -0.4380850553919393}, {
        3.039459319471494, -0.401672665391147}, {
        3.0286462049437906`, -0.350490130863955}, {
        3.031954766119893, -0.24277010010928807`}, {
        3.039363924597226, -0.15078482721220265`}, {
        3.0436035628548375`, -0.07854196611292982}}]]}, {
      RGBColor[
       NCache[
        Rational[1, 3], 0.3333333333333333], 
       NCache[
        Rational[1, 3], 0.3333333333333333], 1], 
      ArrowBox[
       BezierCurveBox[{{3.668259396951663, -0.05087084556962229}, {
        3.666826102756428, -0.0504432374062459}, {
        3.662552283040901, -0.04916341706395541}, {
        3.645863434348529, -0.04409620353108186}, {
        3.619417686999445, -0.03583072927783935}, {
        3.585030737015416, -0.0246190562503614}, {
        3.544786047189312, -0.010782267183361645`}, {
        3.517453677375241, -0.00005528641631473754}, {3.3230135040136837`, 
        0.08465102499632}}]]}, {
      RGBColor[0, 
       NCache[
        Rational[2, 3], 0.6666666666666666], 0], 
      ArrowBox[
       BezierCurveBox[{{3.3230135040136837`, 0.08465102499632}, {
        3.1605805472865542`, 0.19335910596929728`}, {3.075272573191711, 
        0.28992737936655755`}, {3.039459319456624, 0.36610211613852306`}, {
        3.028646204921791, 0.4224405869749357}, {3.0319547661277793`, 
        0.49045364369763544`}}]]}}, {
    ImageSize -> 800, DisplayFunction -> Identity, 
     Ticks -> {Automatic, Automatic}, AxesOrigin -> {0, 0}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, DisplayFunction -> Identity, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.05], 
        Scaled[0.05]}}, PlotRangeClipping -> True, ImagePadding -> All, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {False, False}, 
     AxesLabel -> {None, None}, AxesOrigin -> {0, 0}, DisplayFunction :> 
     Identity, Frame -> {{True, True}, {True, True}}, 
     FrameLabel -> {{None, None}, {None, None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], ImageSize -> 800, 
     Method -> {
      "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
       AbsolutePointSize[6], "ScalingFunctions" -> None, 
       "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
            Part[#, 1]], 
           (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
            Part[#, 1]], 
           (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
            Part[#, 2]]}& )}}, PlotRange -> {All, All}, PlotRangeClipping -> 
     True, PlotRangePadding -> {{Automatic, Automatic}, {
       Automatic, Automatic}}, Ticks -> {Automatic, Automatic}}, LabelStyle -> 
    Directive[FontFamily -> "Helvetica", FontSize -> 14]],FormBox[
    FormBox[
     TemplateBox[{
       StyleBox[
       "\"\[LeftAngleBracket]\\!\\(\\*SubscriptBox[\\(I\\), \\(1  x\\)]\\)\\!\
\\(\\*SubscriptBox[\\(I\\), \\(2  x\\)]\\)+\\!\\(\\*SubscriptBox[\\(I\\), \
\\(1  x\\)]\\)\\!\\(\\*SubscriptBox[\\(I\\), \\(2  x\\)]\\)\
\[RightAngleBracket] \
\\!\\(\\*\\nStyleBox[\\\"f\\\",\\nFontSlant->\\\"Italic\\\"]\\) = 0.001 \
GHz\"", 20, StripOnInput -> False], 
       StyleBox[
       "\"\[LeftAngleBracket]\\!\\(\\*SubscriptBox[\\(I\\), \\(1  x\\)]\\)\\!\
\\(\\*SubscriptBox[\\(I\\), \\(2  y\\)]\\)-\\!\\(\\*SubscriptBox[\\(I\\), \
\\(1  y\\)]\\)\\!\\(\\*SubscriptBox[\\(I\\), \\(2  x\\)]\\)\
\[RightAngleBracket] \
\\!\\(\\*\\nStyleBox[\\\"f\\\",\\nFontSlant->\\\"Italic\\\"]\\) = 0.568 \
GHz\"", 20, StripOnInput -> False], 
       StyleBox[
       "\"\[LeftAngleBracket]\\!\\(\\*SubscriptBox[\\(I\\), \\(1  x\\)]\\)\\!\
\\(\\*SubscriptBox[\\(I\\), \\(2  x\\)]\\)+\\!\\(\\*SubscriptBox[\\(I\\), \
\\(1  x\\)]\\)\\!\\(\\*SubscriptBox[\\(I\\), \\(2  x\\)]\\)\
\[RightAngleBracket] \
\\!\\(\\*\\nStyleBox[\\\"f\\\",\\nFontSlant->\\\"Italic\\\"]\\) = 7.490 \
GHz\"", 20, StripOnInput -> False]}, "LineLegend", DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline), LabelStyle -> 
                    Directive[
                    FontFamily -> "Helvetica", FontSize -> 14]], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline), LabelStyle -> 
                    Directive[
                    FontFamily -> "Helvetica", FontSize -> 14]], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline), LabelStyle -> 
                    Directive[
                    FontFamily -> "Helvetica", FontSize -> 14]], #3}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
          Directive[FontFamily -> "Helvetica", FontSize -> 14], FontFamily -> 
          "Arial"}, Background -> Automatic, StripOnInput -> False], 
        TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0.368417, 0.506779, 0.709798]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0.880722, 0.611041, 0.142051]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.37345400000000006`, 0.461046, 0.12992333333333334`], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0.560181, 0.691569, 0.194885]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.560181, 0.691569, 0.194885]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.560181, 0.691569, 0.194885], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
               RowBox[{
                 RowBox[{"FontFamily", "\[Rule]", "\"Helvetica\""}], ",", 
                 RowBox[{"FontSize", "\[Rule]", "14"}]}], "]"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{
  3.949537144958857*^9, {3.949537187220742*^9, 3.949537223752797*^9}, {
   3.949537275325886*^9, 3.9495373685149603`*^9}, {3.9495374783631597`*^9, 
   3.9495375472167263`*^9}, {3.949537587437834*^9, 3.949537613283792*^9}, 
   3.9495377042153473`*^9, {3.949537744040215*^9, 3.9495377894781933`*^9}, 
   3.949537955071545*^9, 3.9495380820458107`*^9, {3.9495381247454925`*^9, 
   3.9495381331886845`*^9}, {3.9495381778253717`*^9, 3.94953824452029*^9}, {
   3.949538276376136*^9, 3.9495382874777527`*^9}, {3.9495383720039883`*^9, 
   3.9495384182425947`*^9}, 3.9495384556364536`*^9, {3.949538527653863*^9, 
   3.9495385745973024`*^9}, {3.9495386122500553`*^9, 3.9495386740984*^9}, {
   3.9495387845179586`*^9, 3.949538817981158*^9}, {3.949538903164089*^9, 
   3.9495389212714767`*^9}, {3.949538980269309*^9, 3.94953900224465*^9}, {
   3.9495392997782717`*^9, 3.9495394418960023`*^9}, {3.9495394970341887`*^9, 
   3.949539556712149*^9}, {3.9495396457632866`*^9, 3.949539660374987*^9}, {
   3.9495397189695835`*^9, 3.949539732229707*^9}, 3.9495398836665735`*^9, 
   3.949545972283578*^9, {3.9501721656896887`*^9, 3.950172174691581*^9}, {
   3.950172213542473*^9, 3.950172237482771*^9}, 3.950172522801846*^9, 
   3.950172569662505*^9, 3.9501726768427896`*^9, 3.9501736713631287`*^9, 
   3.9524975266275663`*^9, {3.9524979991699095`*^9, 3.9524981338686547`*^9}, 
   3.95845501078315*^9, 3.958456173067609*^9, 3.958456350819072*^9, 
   3.9584570714322243`*^9, 3.9584581804679413`*^9, 3.9584585166514273`*^9, 
   3.9584626484575424`*^9, 3.9584630533183765`*^9, 3.9584681085470114`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"pdatamineP", "=", 
     RowBox[{
      RowBox[{"Cases", "[", 
       RowBox[{"p0", ",", " ", 
        RowBox[{
         RowBox[{"Point", "[", "pts_", "]"}], "\[RuleDelayed]", "pts"}], ",", 
        " ", "Infinity"}], "]"}], " ", "//", " ", 
      RowBox[{
       RowBox[{"Flatten", "[", 
        RowBox[{"#", ",", "1"}], "]"}], "&"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"datamineL", "=", 
     RowBox[{
      RowBox[{"Cases", "[", 
       RowBox[{"p0", ",", 
        RowBox[{
         RowBox[{"Line", "[", "pts_", "]"}], "\[RuleDelayed]", "pts"}], ",", 
        " ", "Infinity"}], "]"}], " ", "//", " ", 
      RowBox[{
       RowBox[{"Flatten", "[", 
        RowBox[{"#", ",", "1"}], "]"}], "&"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{"\"\<plotData7.csv\>\"", ",", "datamineP", ",", "\"\<CSV\>\""}], 
    "]"}], "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.9584681215209913`*^9, 3.958468167957097*^9}}],

Cell[BoxData["\<\"plotData7.csv\"\>"], "Output",
 CellChangeTimes->{{3.9584681587368603`*^9, 3.958468170909812*^9}}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"p1", "=", 
   RowBox[{"ListPlot", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Transpose", "[", "\[IndentingNewLine]", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Join", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"FindMinimum", "[", 
              RowBox[{
               RowBox[{
                SubscriptBox["\[ScriptCapitalS]", 
                 RowBox[{"2", ",", 
                  RowBox[{"frqlist", "[", 
                   RowBox[{"[", "i", "]"}], "]"}]}]], "[", "t", "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"t", ",", "0", ",", "20"}], "}"}]}], "]"}], "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"i", ",", "1", ",", "8"}], "}"}]}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"FindMaximum", "[", 
              RowBox[{
               RowBox[{
                SubscriptBox["\[ScriptCapitalS]", 
                 RowBox[{"2", ",", 
                  RowBox[{"frqlist", "[", 
                   RowBox[{"[", "i", "]"}], "]"}]}]], "[", "t", "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"t", ",", "0", ",", "20"}], "}"}]}], "]"}], "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"i", ",", "9", ",", "18"}], "}"}]}], "]"}]}], 
         "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{
            RowBox[{"FindMinimum", "[", 
             RowBox[{
              RowBox[{
               SubscriptBox["\[ScriptCapitalS]", 
                RowBox[{"1", ",", 
                 RowBox[{"frqlist", "[", 
                  RowBox[{"[", "i", "]"}], "]"}]}]], "[", "t", "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"t", ",", "0", ",", "20"}], "}"}]}], "]"}], "[", 
            RowBox[{"[", "1", "]"}], "]"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "1", ",", "18"}], "}"}]}], "]"}]}], 
       "\[IndentingNewLine]", "}"}], "\[IndentingNewLine]", "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"PlotStyle", "\[Rule]", "Blue"}], ",", 
     RowBox[{"Joined", "\[Rule]", "False"}]}], "\[IndentingNewLine]", "]"}]}],
   ";"}]], "Input",
 CellChangeTimes->{{3.949458212280498*^9, 3.949458257824402*^9}, {
  3.949458298059905*^9, 3.94945834106256*^9}, {3.949458387227206*^9, 
  3.9494584349756556`*^9}, {3.9494607418541117`*^9, 3.9494607424324665`*^9}, {
  3.949460810303065*^9, 3.9494608157161517`*^9}, {3.94953703371826*^9, 
  3.9495370350021014`*^9}, {3.949537814242602*^9, 3.9495378343770213`*^9}, {
  3.950172684135715*^9, 3.9501727599023666`*^9}, {3.9501738229985495`*^9, 
  3.9501738410321207`*^9}, {3.9584585456623664`*^9, 3.958458640401311*^9}, {
  3.9584625416385903`*^9, 3.958462544512616*^9}, {3.958462813586051*^9, 
  3.9584628204165134`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"p2", "=", 
   RowBox[{"ParametricPlot", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{"7.8", 
       RowBox[{"ReIm", "[", 
        RowBox[{"UseNumericalValues", "[", 
         RowBox[{
          RowBox[{"\[ScriptCapitalA]", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"\[ImaginaryI]", " ", "\[Phi]"}]]}], ",", 
          "\"\<jcoupling\>\"", ",", "\[Nu]"}], "]"}], "]"}]}], 
      "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"\[Nu]", ",", "0", ",", "7.5"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Blue", ",", "Red"}], "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"AspectRatio", "\[Rule]", 
      RowBox[{"1", "/", "2"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"AxesOrigin", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "0"}], "}"}]}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.9494551477016463`*^9, 3.949455147917017*^9}, {
   3.9494552313462877`*^9, 3.949455239965022*^9}, {3.9494557402774954`*^9, 
   3.9494557576223187`*^9}, {3.9494583011792655`*^9, 3.9494583014719505`*^9}, 
   3.9494583890699544`*^9, {3.949458436269555*^9, 3.9494584376868362`*^9}, {
   3.949459242224915*^9, 3.9494592460322905`*^9}, {3.949460593780493*^9, 
   3.949460658512121*^9}, {3.9494606912495594`*^9, 3.9494607097732697`*^9}, {
   3.949460848331006*^9, 3.9494608501085815`*^9}, {3.9495368102342644`*^9, 
   3.949536868984703*^9}, {3.949536954117111*^9, 3.949536961789772*^9}, 
   3.950173841959573*^9, 3.9584561063783765`*^9, {3.958462824101097*^9, 
   3.9584628405941505`*^9}, {3.958463150880228*^9, 3.9584631786442275`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"p0", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p3", "=", 
   RowBox[{"Graphics", "[", "\[IndentingNewLine]", 
    RowBox[{"Table", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"v", "=", 
        RowBox[{"0.1", 
         RowBox[{"Normalize", "[", 
          RowBox[{"ReIm", "[", 
           RowBox[{"UseNumericalValues", "[", 
            RowBox[{
             RowBox[{"\[ScriptCapitalA]", " ", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{"\[ImaginaryI]", " ", "\[Phi]"}]]}], ",", 
             "\"\<jcoupling\>\"", ",", "i"}], "]"}], "]"}], "]"}]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Rotate", "[", 
          RowBox[{
           RowBox[{"Text", "[", 
            RowBox[{
             RowBox[{"StringJoin", "[", 
              RowBox[{
               RowBox[{"ToString", "[", "i", "]"}], ",", "\"\< GHz\>\""}], 
              "]"}], ",", 
             RowBox[{"p0", "+", 
              RowBox[{"8", "v"}]}]}], "]"}], ",", 
           RowBox[{
            RowBox[{"ArcTan", "[", 
             RowBox[{
              RowBox[{"v", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{"v", "[", 
               RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "-", 
            RowBox[{"\[Pi]", "/", "2"}]}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"GrayLevel", "[", "0.5", "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{"p0", ",", 
            RowBox[{"p0", "+", 
             RowBox[{"7", "v"}]}]}], "}"}], "]"}]}], "\[IndentingNewLine]", 
        "}"}]}], "\[IndentingNewLine]", ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", 
        RowBox[{"{", 
         RowBox[{
         "0.05", ",", "0.1", ",", "0.2", ",", "0.5", ",", "1", ",", "2", ",", 
          "5"}], "}"}]}], "}"}]}], "]"}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.949458477828309*^9, 3.9494584847873015`*^9}, {
   3.9494585410791883`*^9, 3.9494585511845536`*^9}, {3.949458605873294*^9, 
   3.949458717391867*^9}, {3.9494587805014668`*^9, 3.9494589742223372`*^9}, {
   3.949459086539304*^9, 3.9494591905505834`*^9}, {3.949460670898567*^9, 
   3.9494606782613373`*^9}, {3.9494608228103733`*^9, 3.9494608664295025`*^9}, 
   3.9494641620743837`*^9, {3.949536783525216*^9, 3.949536784600075*^9}, {
   3.949536882086482*^9, 3.9495369239143715`*^9}, {3.9584628519966974`*^9, 
   3.9584628776208344`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"p2", ",", "p3", ",", "p1", ",", 
   RowBox[{"ImageSize", "\[Rule]", "400"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.949458704662285*^9, 3.949458731855507*^9}, {
  3.949459159792941*^9, 3.949459161658117*^9}, {3.9494592531969748`*^9, 
  3.949459258508204*^9}, {3.952497714415311*^9, 3.952497809037051*^9}, {
  3.9524983084798126`*^9, 3.9524983085726533`*^9}, {3.9524983416080523`*^9, 
  3.952498341715036*^9}, {3.95249839537481*^9, 3.9524983993386135`*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[1, 0, 0], AbsoluteThickness[1.6], Opacity[1.], FaceForm[
      Opacity[0.3]], LineBox[CompressedData["
1:eJwV1nc41W0YB3BKQ4giDTQpI0lDKvpmZhZNRUpRNpEkqczSslLZozj2Cinj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       "]]},
     Annotation[#, "Charting`Private`Tag$127303#1"]& ]}, {{
     GeometricTransformationBox[
      InsetBox["\<\"0.05 GHz\"\>", {-0.7189116390975734, 0.350950217509607}], \
{{{0.43868777188700864`, -0.8986395488719667}, {0.8986395488719667, 
       0.43868777188700864`}}, Center}], 
     {GrayLevel[0.5], 
      LineBox[{{0, 0}, {-0.6290476842103767, 0.3070814403209061}}]}}, {
     GeometricTransformationBox[
      InsetBox["\<\"0.1 GHz\"\>", {-0.5658267670504155, 0.5655440475235108}], \
{{{0.7069300594043884, -0.7072834588130192}, {0.7072834588130192, 
       0.7069300594043884}}, Center}], 
     {GrayLevel[0.5], 
      LineBox[{{0, 0}, {-0.4950984211691135, 0.49485104158307197`}}]}}, {
     GeometricTransformationBox[
      InsetBox["\<\"0.2 GHz\"\>", {-0.3299412122822184, 0.7287926978488055}], \
{{{0.9109908723110067, -0.412426515352773}, {0.412426515352773, 
       0.9109908723110067}}, Center}], 
     {GrayLevel[0.5], 
      LineBox[{{0, 0}, {-0.2886985607469411, 0.6376936106177048}}]}}, {
     GeometricTransformationBox[
      InsetBox["\<\"0.5 GHz\"\>", {-0.0375808862656396, 0.7991168106024857}], \
{{{0.9988960132531072, -0.04697610783204956}, {0.04697610783204956, 
       0.9988960132531072}}, Center}], 
     {GrayLevel[0.5], 
      LineBox[{{0, 0}, {-0.03288327548243465, 0.699227209277175}}]}}, {
     GeometricTransformationBox[
      InsetBox["\<\"1 GHz\"\>", {0.17409755840071084, 0.7808265109221837}], \
{{{0.9760331386527297, 0.21762194800088847`}, {-0.21762194800088847`, 
       0.9760331386527297}}, Center}], 
     {GrayLevel[0.5], 
      LineBox[{{0, 0}, {0.152335363600622, 0.6832231970569107}}]}}, {
     GeometricTransformationBox[
      InsetBox["\<\"2 GHz\"\>", {0.4415127438307777, 0.6671330429794482}], {{{
       0.8339163037243101, 0.551890929788472}, {-0.551890929788472, 
       0.8339163037243101}}, Center}], 
     {GrayLevel[0.5], 
      LineBox[{{0, 0}, {0.3863236508519305, 0.5837414126070172}}]}}, {
     GeometricTransformationBox[
      InsetBox["\<\"5 GHz\"\>", {0.7685999685446667, 0.22193262120097926}], \
{{{0.2774157765012241, 0.9607499606808334}, {-0.9607499606808334, 
       0.2774157765012241}}, Center}], 
     {GrayLevel[0.5], 
      LineBox[{{0, 0}, {0.6725249724765834, 
        0.19419104355085684`}}]}}}, {{}, {{}, 
     {RGBColor[0, 0, 1], PointSize[0.012833333333333334`], AbsoluteThickness[
      1.6], PointBox[{{-0.05087084556962229, 
       0.0004928665789752536}, {-0.0504432374062459, 
       0.024624813644916033`}, {-0.04916341706395541, 
       0.04913885219928135}, {-0.04409620353108186, 
       0.09740217329604145}, {-0.03583072927783935, 
       0.14396943715692426`}, {-0.0246190562503614, 
       0.18812162521273373`}, {-0.010782267183361645`, 
       0.22927322428136349`}, {-0.00005528641631473754, 
       0.25531338083695515`}, {0.03284905133523364, 0.3165225069763769}, {
       0.08465102499632, 0.3796593421695101}, {0.19335910596929728`, 
       0.44025196247086607`}, {0.28992737936655755`, 0.4380850553919393}, {
       0.36610211613852306`, 0.401672665391147}, {0.4224405869749357, 
       0.350490130863955}, {0.49045364369763544`, 0.24277010010928807`}, {
       0.5221999939642132, 0.15078482721220265`}, {0.5356719640441479, 
       0.07854196611292982}, {0.5401443213743884, 
       0.02261422176770978}}]}, {}}, {}, {}, {{}, {}}}},
  AspectRatio->NCache[
    Rational[1, 2], 0.5],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{-1, 0},
  DisplayFunction->Identity,
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->400,
  LabelStyle->{},
  Method->{"ScalingFunctions" -> None},
  PlotRange->{{-1, 1}, {0, 1}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.9494587073195047`*^9, 3.94945873218014*^9}, {
   3.949459156041046*^9, 3.949459192800832*^9}, {3.9494592487511253`*^9, 
   3.949459258806593*^9}, {3.9494606040113907`*^9, 3.949460711585942*^9}, 
   3.9494607446921387`*^9, {3.9494608289666567`*^9, 3.949460867545129*^9}, 
   3.949461005123389*^9, 3.949464160051366*^9, {3.9495367678770304`*^9, 
   3.9495367866004095`*^9}, {3.949536821209803*^9, 3.949536924565692*^9}, 
   3.9495369632914553`*^9, 3.949537125614833*^9, {3.9495377997117863`*^9, 
   3.9495378364739313`*^9}, {3.9495397895383797`*^9, 3.949539792741542*^9}, 
   3.9495398841531067`*^9, 3.9495459777556114`*^9, {3.9501726913387012`*^9, 
   3.950172777356037*^9}, 3.9501736715986395`*^9, {3.9501738340299497`*^9, 
   3.950173844502017*^9}, 3.952496923231455*^9, 3.952497527082543*^9, {
   3.9524977014147835`*^9, 3.9524977495824957`*^9}, {3.952497780308705*^9, 
   3.9524978092308874`*^9}, {3.952498313368024*^9, 3.9524983420920973`*^9}, {
   3.9524983956724377`*^9, 3.9524983995348034`*^9}, 3.95845501121515*^9, 
   3.9584561738103466`*^9, 3.9584563516837897`*^9, 3.958457072624003*^9, 
   3.9584581811093955`*^9, 3.9584585169014606`*^9, {3.9584585693866725`*^9, 
   3.958458643121105*^9}, 3.9584626486992664`*^9, {3.9584628305098085`*^9, 
   3.9584628783237486`*^9}, 3.958463120879506*^9, {3.9584631523555355`*^9, 
   3.9584632040234733`*^9}, 3.958468184977346*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"datamineP", "=", 
   RowBox[{
    RowBox[{"Cases", "[", 
     RowBox[{"p1", ",", " ", 
      RowBox[{
       RowBox[{"Point", "[", "pts_", "]"}], "\[RuleDelayed]", "pts"}], ",", 
      " ", "Infinity"}], "]"}], " ", "//", " ", 
    RowBox[{
     RowBox[{"Flatten", "[", 
      RowBox[{"#", ",", "1"}], "]"}], "&"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"datamineL", "=", 
   RowBox[{
    RowBox[{"Cases", "[", 
     RowBox[{"p2", ",", 
      RowBox[{
       RowBox[{"Line", "[", "pts_", "]"}], "\[RuleDelayed]", "pts"}], ",", 
      " ", "Infinity"}], "]"}], " ", "//", " ", 
    RowBox[{
     RowBox[{"Flatten", "[", 
      RowBox[{"#", ",", "1"}], "]"}], "&"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{"\"\<plotData6.csv\>\"", ",", "datamineL", ",", "\"\<CSV\>\""}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.958468198021454*^9, 3.958468211286343*^9}}],

Cell[BoxData["\<\"plotData6.csv\"\>"], "Output",
 CellChangeTimes->{{3.958468203630413*^9, 3.9584682132828765`*^9}}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{913, 972},
WindowMargins->{{Automatic, 20}, {Automatic, 4}},
FrontEndVersion->"11.0 for Microsoft Windows (64-bit) (September 21, 2016)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 2351, 44, 180, "Input",
 InitializationCell->True],
Cell[2934, 68, 1470, 23, 40, "Message"],
Cell[4407, 93, 1675, 25, 59, "Message"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6119, 123, 263, 4, 72, "Chapter",
 Evaluatable->False],
Cell[6385, 129, 765, 25, 46, "Input",
 Evaluatable->False],
Cell[CellGroupData[{
Cell[7175, 158, 517, 14, 30, "Input"],
Cell[7695, 174, 1764, 34, 32, "Output"]
}, Open  ]],
Cell[9474, 211, 1107, 38, 30, "Input",
 Evaluatable->False],
Cell[10584, 251, 601, 16, 46, "Input",
 Evaluatable->False],
Cell[CellGroupData[{
Cell[11210, 271, 3003, 69, 130, "Input"],
Cell[14216, 342, 4271, 125, 69, "Output"]
}, Open  ]],
Cell[18502, 470, 988, 25, 33, "Input",
 Evaluatable->False],
Cell[19493, 497, 1288, 39, 79, "Input"],
Cell[20784, 538, 5650, 117, 252, "Input"],
Cell[CellGroupData[{
Cell[26459, 659, 1524, 35, 305, "Input"],
Cell[27986, 696, 1951, 67, 33, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[29974, 768, 905, 25, 50, "Input"],
Cell[30882, 795, 958, 33, 33, "Output"],
Cell[31843, 830, 890, 31, 33, "Output"]
}, Open  ]],
Cell[32748, 864, 6322, 135, 485, "Input"],
Cell[39073, 1001, 3853, 97, 293, "Input"],
Cell[CellGroupData[{
Cell[42951, 1102, 4289, 109, 305, "Input"],
Cell[47243, 1213, 41624, 756, 511, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[88904, 1974, 1069, 30, 107, "Input"],
Cell[89976, 2006, 116, 1, 30, "Output"]
}, Open  ]],
Cell[90107, 2010, 3132, 71, 247, "Input"],
Cell[93242, 2083, 2027, 44, 165, "Input"],
Cell[95272, 2129, 2655, 64, 242, "Input"],
Cell[CellGroupData[{
Cell[97952, 2197, 506, 8, 30, "Input"],
Cell[98461, 2207, 14568, 252, 225, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[113066, 2464, 939, 26, 69, "Input"],
Cell[114008, 2492, 116, 1, 30, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)

