(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    102016,       2095]
NotebookOptionsPosition[    100372,       2037]
NotebookOutlinePosition[    100718,       2052]
CellTagsIndexPosition[    100675,       2049]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", "NMER.wl"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$Path", "=", 
   RowBox[{"Append", "[", 
    RowBox[{
    "$Path", ",", 
     "\"\<C:\\\\Program Files\\\\Wolfram \
Research\\\\Mathematica\\\\11.0\\\\AddOns\\\\SpinDynamica\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Needs", "[", "\"\<SpinDynamica`\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{"SetSpinSystem", "[", "2", "]"}], "\[IndentingNewLine]", 
 RowBox[{"SetOperatorBasis", "[", 
  RowBox[{"ShiftAndPolarizationOperatorBasis", "[", "]"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$IterationLimit", "=", "100"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$RecursionLimit", "=", "100"}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.8979029332461853`*^9, 3.8979029333555126`*^9}, {
   3.9084282902765293`*^9, 3.908428290608573*^9}, {3.908434156845696*^9, 
   3.9084341571057606`*^9}, {3.9084342203704367`*^9, 3.90843423064997*^9}, {
   3.9084342658446393`*^9, 3.90843426662166*^9}, {3.9239663419853973`*^9, 
   3.9239663428683977`*^9}, {3.9242179270710745`*^9, 
   3.9242179309820786`*^9}, {3.9242189923630667`*^9, 
   3.9242189928409357`*^9}, {3.929689130221174*^9, 3.929689130335905*^9}, {
   3.9296904704089746`*^9, 3.929690475661783*^9}, {3.9296906208124905`*^9, 
   3.9296906321806283`*^9}, {3.9297559111781435`*^9, 
   3.9297559170982122`*^9}, {3.929756156737685*^9, 3.929756159728757*^9}, {
   3.9297561955543327`*^9, 3.9297562018225355`*^9}, {3.929757372873993*^9, 
   3.9297573747952967`*^9}, {3.9297582795229845`*^9, 3.929758289056796*^9}, {
   3.929758392176601*^9, 3.9297583922917504`*^9}, {3.9297612208572*^9, 
   3.92976122748133*^9}, 3.9297617497266264`*^9, {3.929762516458739*^9, 
   3.9297625209660463`*^9}, {3.929770704520667*^9, 3.9297707094390993`*^9}, {
   3.9297844293939266`*^9, 3.9297844299365525`*^9}, {3.930180222835225*^9, 
   3.9301802230498767`*^9}, {3.930181076851877*^9, 3.9301810787443743`*^9}, {
   3.930181132811544*^9, 3.9301811436109858`*^9}, 3.9469489421891813`*^9, {
   3.9494502996115274`*^9, 3.949450300890308*^9}, {3.949623645018272*^9, 
   3.949623649591976*^9}, {3.9496237069454217`*^9, 3.94962370707574*^9}, {
   3.949624773448871*^9, 3.949624773579413*^9}, {3.9496251429623003`*^9, 
   3.9496251430195055`*^9}, 3.9496253938061943`*^9, {3.949625720778123*^9, 
   3.9496257254721985`*^9}, {3.949629836558818*^9, 3.9496298367958345`*^9}, {
   3.949631284359875*^9, 3.9496312845000286`*^9}, {3.9496313398498907`*^9, 
   3.949631406384497*^9}, {3.949969907733423*^9, 3.949969907790249*^9}, 
   3.9499700687571983`*^9, {3.9499701114003716`*^9, 3.9499701354803863`*^9}, {
   3.94997026165933*^9, 3.9499702792523575`*^9}, {3.949970390003436*^9, 
   3.949970390313308*^9}, {3.949971218907962*^9, 3.9499712197424245`*^9}, {
   3.9499713733399997`*^9, 3.9499713734624777`*^9}, {3.9499715700922203`*^9, 
   3.9499715703541255`*^9}, {3.949971806109316*^9, 3.949971806196114*^9}, 
   3.949972437827448*^9, {3.9499724842154903`*^9, 3.949972495265328*^9}, {
   3.949973140159102*^9, 3.9499731402576914`*^9}, {3.9499747291547527`*^9, 
   3.9499747292222223`*^9}, {3.949987021489043*^9, 3.9499870270947466`*^9}, {
   3.9501497269023666`*^9, 3.950149727829323*^9}, {3.950154357640292*^9, 
   3.9501543594056067`*^9}, 3.9584352009694033`*^9, {3.9584621123911395`*^9, 
   3.9584621134135413`*^9}},
 ExpressionUUID -> "caa63273-6624-4f32-98bc-f80e9fab0c09"],

Cell[BoxData[
 TemplateBox[{
  "SetSpinSystem","set",
   "\"the spin system has been set to \\!\\(\\*RowBox[{\\\"{\\\", \
RowBox[{RowBox[{\\\"{\\\", RowBox[{\\\"1\\\", \\\",\\\", \
FractionBox[\\\"1\\\", \\\"2\\\"]}], \\\"}\\\"}], \\\",\\\", \
RowBox[{\\\"{\\\", RowBox[{\\\"2\\\", \\\",\\\", FractionBox[\\\"1\\\", \\\"2\
\\\"]}], \\\"}\\\"}]}], \\\"}\\\"}]\\)\"",2,316,31,26617127362490670834,
   "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{{3.9494538297339225`*^9, 3.949453830341059*^9}, 
   3.9494541384927387`*^9, 3.9494542288420506`*^9, {3.949454654183945*^9, 
   3.949454654832794*^9}, {3.949536676823586*^9, 3.9495366775926404`*^9}, {
   3.9495440308239217`*^9, 3.9495440314985986`*^9}, {3.9495454852284355`*^9, 
   3.94954548587721*^9}, {3.949546000712469*^9, 3.949546001366531*^9}, {
   3.9495465405510707`*^9, 3.949546541199572*^9}, 3.949554945676838*^9, {
   3.949622956754238*^9, 3.949622957460236*^9}, 3.9496230370597286`*^9, 
   3.949623649941227*^9, 3.9496237077712326`*^9, 3.949623848430968*^9, 
   3.949624774035494*^9, 3.9496249213157897`*^9, 3.949625143616089*^9, {
   3.9496253942448854`*^9, 3.9496254041369195`*^9}, 3.9496257259280014`*^9, 
   3.949629837036462*^9, 3.9496306005960407`*^9, 3.94963067258523*^9, {
   3.949630745155557*^9, 3.949630746646822*^9}, 3.9496309072452073`*^9, 
   3.949631285450014*^9, {3.949631340139638*^9, 3.9496313603056827`*^9}, {
   3.9496314076732197`*^9, 3.949631412835411*^9}, {3.949969579926573*^9, 
   3.949969580511571*^9}, 3.9499699084557343`*^9, 3.949970069162061*^9, {
   3.949970136116431*^9, 3.9499701495838375`*^9}, 3.9499702799629836`*^9, 
   3.9499703906117496`*^9, 3.9499712203797216`*^9, 3.9499713738523903`*^9, 
   3.949971540643302*^9, 3.9499715706592197`*^9, {3.9499718065936728`*^9, 
   3.9499718308992033`*^9}, 3.949971952222399*^9, {3.949972439956545*^9, 
   3.949972495635702*^9}, {3.9499732818068695`*^9, 3.9499732824817877`*^9}, 
   3.9499747381660028`*^9, 3.949977574160954*^9, {3.949987024379006*^9, 
   3.949987029633629*^9}, 3.949987087009001*^9, 3.949988002436309*^9, 
   3.9499902782589025`*^9, {3.950149731330085*^9, 3.9501497318092146`*^9}, {
   3.950172836257085*^9, 3.9501728364313726`*^9}, {3.9584352032894287`*^9, 
   3.9584352051560726`*^9}, {3.9584491928372602`*^9, 3.958449193009804*^9}, 
   3.958451750384266*^9, 3.9584517953523684`*^9, 3.9584527589136243`*^9, {
   3.958454506206169*^9, 3.9584545080639744`*^9}, {3.9584569094682627`*^9, 
   3.958456909608297*^9}, 3.9584572612657022`*^9, 3.958457392048601*^9, 
   3.958457539845327*^9, 3.9584577767429667`*^9, {3.95846198032071*^9, 
   3.9584619826879215`*^9}, {3.958462115179843*^9, 3.958462117266859*^9}, {
   3.958466429780724*^9, 3.9584664350761266`*^9}, 3.9584674356684856`*^9}],

Cell[BoxData[
 TemplateBox[{
  "SetOperatorBasis","alreadyset",
   "\"The operator basis is already set to \
\\!\\(\\*RowBox[{\\\"ShiftAndPolarizationOperatorBasis\\\", \\\"[\\\", \
RowBox[{RowBox[{\\\"{\\\", RowBox[{RowBox[{\\\"{\\\", RowBox[{\\\"1\\\", \
\\\",\\\", FractionBox[\\\"1\\\", \\\"2\\\"]}], \\\"}\\\"}], \\\",\\\", \
RowBox[{\\\"{\\\", RowBox[{\\\"2\\\", \\\",\\\", FractionBox[\\\"1\\\", \\\"2\
\\\"]}], \\\"}\\\"}]}], \\\"}\\\"}], \\\",\\\", RowBox[{\\\"Sorted\\\", \\\"\
\[Rule]\\\", \\\"CoherenceOrder\\\"}]}], \\\"]\\\"}]\\). No action has been \
taken.\"",2,317,32,26617127362490670834,"Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{{3.9494538297339225`*^9, 3.949453830341059*^9}, 
   3.9494541384927387`*^9, 3.9494542288420506`*^9, {3.949454654183945*^9, 
   3.949454654832794*^9}, {3.949536676823586*^9, 3.9495366775926404`*^9}, {
   3.9495440308239217`*^9, 3.9495440314985986`*^9}, {3.9495454852284355`*^9, 
   3.94954548587721*^9}, {3.949546000712469*^9, 3.949546001366531*^9}, {
   3.9495465405510707`*^9, 3.949546541199572*^9}, 3.949554945676838*^9, {
   3.949622956754238*^9, 3.949622957460236*^9}, 3.9496230370597286`*^9, 
   3.949623649941227*^9, 3.9496237077712326`*^9, 3.949623848430968*^9, 
   3.949624774035494*^9, 3.9496249213157897`*^9, 3.949625143616089*^9, {
   3.9496253942448854`*^9, 3.9496254041369195`*^9}, 3.9496257259280014`*^9, 
   3.949629837036462*^9, 3.9496306005960407`*^9, 3.94963067258523*^9, {
   3.949630745155557*^9, 3.949630746646822*^9}, 3.9496309072452073`*^9, 
   3.949631285450014*^9, {3.949631340139638*^9, 3.9496313603056827`*^9}, {
   3.9496314076732197`*^9, 3.949631412835411*^9}, {3.949969579926573*^9, 
   3.949969580511571*^9}, 3.9499699084557343`*^9, 3.949970069162061*^9, {
   3.949970136116431*^9, 3.9499701495838375`*^9}, 3.9499702799629836`*^9, 
   3.9499703906117496`*^9, 3.9499712203797216`*^9, 3.9499713738523903`*^9, 
   3.949971540643302*^9, 3.9499715706592197`*^9, {3.9499718065936728`*^9, 
   3.9499718308992033`*^9}, 3.949971952222399*^9, {3.949972439956545*^9, 
   3.949972495635702*^9}, {3.9499732818068695`*^9, 3.9499732824817877`*^9}, 
   3.9499747381660028`*^9, 3.949977574160954*^9, {3.949987024379006*^9, 
   3.949987029633629*^9}, 3.949987087009001*^9, 3.949988002436309*^9, 
   3.9499902782589025`*^9, {3.950149731330085*^9, 3.9501497318092146`*^9}, {
   3.950172836257085*^9, 3.9501728364313726`*^9}, {3.9584352032894287`*^9, 
   3.9584352051560726`*^9}, {3.9584491928372602`*^9, 3.958449193009804*^9}, 
   3.958451750384266*^9, 3.9584517953523684`*^9, 3.9584527589136243`*^9, {
   3.958454506206169*^9, 3.9584545080639744`*^9}, {3.9584569094682627`*^9, 
   3.958456909608297*^9}, 3.9584572612657022`*^9, 3.958457392048601*^9, 
   3.958457539845327*^9, 3.9584577767429667`*^9, {3.95846198032071*^9, 
   3.9584619826879215`*^9}, {3.958462115179843*^9, 3.958462117266859*^9}, {
   3.958466429780724*^9, 3.9584664350761266`*^9}, 3.958467435730482*^9}]
}, Open  ]],

Cell[TextData[{
 "Energy of the interaction betweeen the external magnetic field ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["B", "0"], 
    StyleBox[
     SubscriptBox[
      OverscriptBox["e", "^"], "z"],
     FontWeight->"Bold"]}], TraditionalForm]]],
 " and spins ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["I", "1"], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["I", "2"], TraditionalForm]]],
 " is\[LineSeparator]"
}], "Input",
 Evaluatable->False,
 CellChangeTimes->{{3.9297568739645395`*^9, 3.929756878807661*^9}, {
   3.929756920340457*^9, 3.9297569715296845`*^9}, {3.929757002411059*^9, 
   3.929757016912091*^9}, {3.929757139513809*^9, 3.9297571523258677`*^9}, 
   3.9584674401954775`*^9},
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[ScriptCapitalH]", "Zeeman"], "=", 
  RowBox[{
   RowBox[{
    SubscriptBox["\[Omega]", "1"], 
    RowBox[{"opI", "[", 
     RowBox[{"1", ",", "\"\<z\>\""}], "]"}]}], "+", 
   RowBox[{
    SubscriptBox["\[Omega]", "2"], 
    RowBox[{"opI", "[", 
     RowBox[{"2", ",", "\"\<z\>\""}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.9297570482358847`*^9, 3.9297570724088306`*^9}, {
   3.929761086071076*^9, 3.929761091022113*^9}, {3.9493753961299887`*^9, 
   3.949375413560275*^9}, 3.949544043073056*^9, {3.949544481836402*^9, 
   3.949544486714096*^9}, 3.949546281329373*^9, {3.9495463137947445`*^9, 
   3.9495463151175833`*^9}, {3.949546414598678*^9, 3.9495464291206746`*^9}, 
   3.949623596982746*^9, 3.9496236821476383`*^9, {3.9496247765481834`*^9, 
   3.9496247834369755`*^9}, {3.949625146385306*^9, 3.9496251472465754`*^9}, 
   3.9496305090212584`*^9, {3.949631278347809*^9, 3.9496312824908056`*^9}, {
   3.9496319387033854`*^9, 3.949631970505919*^9}, {3.949969911547146*^9, 
   3.9499699116530275`*^9}, {3.949971740423242*^9, 3.949971740522402*^9}, {
   3.9499718012383113`*^9, 3.9499718012979755`*^9}, {3.9499723762398233`*^9, 
   3.9499723805100937`*^9}, {3.9499724345299606`*^9, 3.949972434744522*^9}, {
   3.9499731429826746`*^9, 3.949973146358762*^9}, {3.949974734674734*^9, 
   3.949974735868309*^9}, {3.9501497830709114`*^9, 3.9501497845568237`*^9}, 
   3.9501728270167327`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   TagBox[
    SubscriptBox["I", 
     RowBox[{"1", "z"}]],
    DisplayForm], " ", 
   SubscriptBox["\[Omega]", "1"]}], "+", 
  RowBox[{
   TagBox[
    SubscriptBox["I", 
     RowBox[{"2", "z"}]],
    DisplayForm], " ", 
   SubscriptBox["\[Omega]", "2"]}]}]], "Output",
 CellChangeTimes->{
  3.9297570727364626`*^9, 3.92975901457837*^9, 3.929759569484794*^9, 
   3.9297607329329634`*^9, 3.929760875574483*^9, 3.9297609680405903`*^9, 
   3.9297610358703957`*^9, 3.9297610916785088`*^9, 3.9297617677615905`*^9, 
   3.929763306801512*^9, 3.929764493691039*^9, 3.929764607077385*^9, 
   3.92976905508613*^9, 3.9297691067572474`*^9, 3.929769289870951*^9, 
   3.9297693382820497`*^9, 3.9297695228658185`*^9, {3.929769557329593*^9, 
   3.9297695818552685`*^9}, 3.9297696857980366`*^9, 3.929770072452414*^9, {
   3.9297705886295333`*^9, 3.9297706030050087`*^9}, 3.929784444558932*^9, 
   3.9297848605381737`*^9, 3.9297850683137546`*^9, 3.929785377566633*^9, 
   3.9297855327467566`*^9, {3.9301807496835957`*^9, 3.930180769957975*^9}, 
   3.930181107402342*^9, 3.93018116688455*^9, 3.9301812761086583`*^9, {
   3.949375404127507*^9, 3.949375413892925*^9}, 3.949392335585311*^9, 
   3.9493930441309566`*^9, 3.949451919800558*^9, 3.949453954782632*^9, 
   3.949454664073141*^9, 3.94945470658842*^9, 3.9495366777204556`*^9, 
   3.9495440439856553`*^9, 3.9495444292342253`*^9, 3.949544487839947*^9, {
   3.9495445925642457`*^9, 3.9495446052226715`*^9}, 3.949544938519497*^9, 
   3.949545487859318*^9, 3.9495460049618826`*^9, 3.9495462821677294`*^9, 
   3.9495463155988517`*^9, {3.949546415168906*^9, 3.9495464296082077`*^9}, 
   3.949546543465254*^9, 3.9495549473052316`*^9, 3.949622958633783*^9, 
   3.949623040120773*^9, 3.9496235987932153`*^9, 3.9496236526681967`*^9, {
   3.9496236827040205`*^9, 3.9496237097270603`*^9}, 3.949623849969067*^9, {
   3.949624777194003*^9, 3.9496247839931316`*^9}, 3.949625147644747*^9, 
   3.949625405791905*^9, 3.9496257274720373`*^9, 3.949630509561105*^9, 
   3.9496306553044677`*^9, 3.9496307484940557`*^9, 3.949630909501519*^9, 
   3.9496312873195553`*^9, {3.9496313414217205`*^9, 3.949631361381016*^9}, 
   3.949631414063732*^9, 3.949631972271284*^9, 3.949969581793296*^9, 
   3.949969911950612*^9, 3.9499700710043936`*^9, {3.9499701380658293`*^9, 
   3.9499701520444355`*^9}, 3.9499702817214622`*^9, 3.949970393839255*^9, 
   3.9499713760519953`*^9, {3.949971542202327*^9, 3.9499715720642667`*^9}, 
   3.9499717409427853`*^9, {3.9499718027017775`*^9, 3.949971832525975*^9}, 
   3.949971954637087*^9, 3.949972518697688*^9, 3.9499731467669744`*^9, 
   3.9499732302595825`*^9, {3.9499732836249585`*^9, 3.9499733084950404`*^9}, {
   3.9499747363232746`*^9, 3.9499747433221006`*^9}, 3.9499870309886265`*^9, 
   3.949987088835973*^9, 3.949987285928377*^9, {3.950149766693181*^9, 
   3.950149787280727*^9}, 3.9501728381028366`*^9, 3.9584352068543806`*^9, 
   3.9584491944997773`*^9, 3.9584517972858286`*^9, 3.9584527606019597`*^9, 
   3.9584545093530874`*^9, 3.95845690969122*^9, 3.9584572613829403`*^9, 
   3.9584573921826*^9, 3.958457539979292*^9, 3.958457776869939*^9, 
   3.9584619827607446`*^9, 3.9584621174072514`*^9, 3.958466435220127*^9, 
   3.958467444073409*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["\[Sigma]", 
       RowBox[{"anti", ",", "x"}]], ",", 
      SubscriptBox["\[Sigma]", 
       RowBox[{"anti", ",", "y"}]], ",", 
      SubscriptBox["\[Sigma]", 
       RowBox[{"anti", ",", "z"}]]}], "}"}], "=", "\[IndentingNewLine]", 
    RowBox[{"TrigToExp", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"TrigExpand", "[", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\[ScriptCapitalA]", " ", 
          RowBox[{"Cos", "[", 
           RowBox[{
            RowBox[{
             SubscriptBox["\[Omega]", "1"], "\[ScriptT]"}], "+", "\[Phi]"}], 
           "]"}]}], ",", "0", ",", "0"}], "}"}], "]"}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"Sin", "[", "\[Phi]", "]"}], "\[Rule]", "sin\[Phi]"}], ",", 
        RowBox[{
         RowBox[{"Cos", "[", "\[Phi]", "]"}], "\[Rule]", "cos\[Phi]"}]}], 
       "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", "  ", 
   RowBox[{
    RowBox[{"Fluorine", "-", 
     RowBox[{"19", " ", "resonace", " ", 
      RowBox[{"frequency", " ", "@", " ", "11.75"}], " ", "T", " ", "is", " ",
       "470", " ", "MHz"}]}], ",", " ", 
    RowBox[{
    "so", " ", "to", " ", "avoid", " ", "un", " ", "unrealistic", 
     "\[IndentingNewLine]", "    ", "saturation", " ", "of", " ", "the", " ", 
     "sample", " ", "the", " ", "electric", " ", "field", " ", "is", " ", 
     "assumed", " ", "to", " ", "be", " ", "equal", " ", "to", " ", "1", " ", 
     RowBox[{"V", "/", "\[Mu]m"}]}]}], "  ", "*)"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  SubscriptBox["\[ScriptCapitalH]", "anti"], "=", " ", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Sigma]", 
      RowBox[{"anti", ",", "x"}]], ",", 
     SubscriptBox["\[Sigma]", 
      RowBox[{"anti", ",", "y"}]], ",", 
     SubscriptBox["\[Sigma]", 
      RowBox[{"anti", ",", "z"}]]}], "}"}], ".", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Cross", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"opI", "[", 
          RowBox[{"1", ",", "\"\<x\>\""}], "]"}], ",", 
         RowBox[{"opI", "[", 
          RowBox[{"1", ",", "\"\<y\>\""}], "]"}], ",", 
         RowBox[{"opI", "[", 
          RowBox[{"1", ",", "\"\<z\>\""}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["B", "x"], ",", 
         SubscriptBox["B", "y"], ",", 
         SubscriptBox["B", "z"]}], "}"}]}], "]"}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SubscriptBox["B", "x"], "\[Rule]", "0"}], ",", 
       RowBox[{
        SubscriptBox["B", "y"], "\[Rule]", "0"}], ",", 
       RowBox[{
        SubscriptBox["B", "z"], "\[Rule]", "1"}]}], "}"}]}], 
    ")"}]}]}]}], "Input",
 CellChangeTimes->{{3.9495445096126003`*^9, 3.949544540949747*^9}, {
   3.949544842561221*^9, 3.94954484335847*^9}, 3.949544883294674*^9, 
   3.9495449940788994`*^9, {3.949545089297593*^9, 3.9495450920700665`*^9}, {
   3.949554739670096*^9, 3.9495547468693027`*^9}, {3.9496238761595373`*^9, 
   3.949623891497752*^9}, 3.9496239309489417`*^9, {3.9496313019268255`*^9, 
   3.9496313176388617`*^9}, {3.949969917317161*^9, 3.9499699174800553`*^9}, {
   3.949971667634186*^9, 3.9499717447759438`*^9}, {3.949971836577121*^9, 
   3.9499718368483863`*^9}, {3.949971937674863*^9, 3.9499719377108326`*^9}, {
   3.94997315202398*^9, 3.9499731532433453`*^9}, {3.94997474685573*^9, 
   3.949974748152697*^9}, {3.9501728570006695`*^9, 3.950172871206421*^9}, {
   3.9584521863135386`*^9, 3.958452189570795*^9}, {3.958452490268653*^9, 
   3.9584525033379383`*^9}, 3.9584525604085717`*^9, {3.958452660944659*^9, 
   3.958452662402711*^9}, {3.958453094835582*^9, 3.958453097059105*^9}, {
   3.958453128389104*^9, 3.9584531315549264`*^9}, {3.9584531908244853`*^9, 
   3.9584531924663143`*^9}, {3.958453274232646*^9, 3.958453276324109*^9}, {
   3.9584534397125077`*^9, 3.9584534413426123`*^9}, {3.958453506677555*^9, 
   3.95845353613117*^9}, {3.958453940184903*^9, 3.9584539568577456`*^9}, {
   3.958453997440911*^9, 3.9584540018373346`*^9}, 3.95845404121091*^9, {
   3.95845509889122*^9, 3.9584551015472198`*^9}, {3.9584573880094013`*^9, 
   3.9584573896334457`*^9}, {3.958457530521307*^9, 3.9584575373380547`*^9}, {
   3.9584617507408075`*^9, 3.9584617914628773`*^9}, {3.958461848496334*^9, 
   3.958461966554903*^9}, 3.958462102648378*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], " ", "cos\[Phi]", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", "\[ScriptT]", " ", 
       SubscriptBox["\[Omega]", "1"]}]], " ", "\[ScriptCapitalA]"}], "+", 
    RowBox[{
     FractionBox["1", "2"], " ", "cos\[Phi]", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"\[ImaginaryI]", " ", "\[ScriptT]", " ", 
       SubscriptBox["\[Omega]", "1"]}]], " ", "\[ScriptCapitalA]"}], "-", 
    RowBox[{
     FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", "\[ScriptT]", " ", 
       SubscriptBox["\[Omega]", "1"]}]], " ", "sin\[Phi]", " ", 
     "\[ScriptCapitalA]"}], "+", 
    RowBox[{
     FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"\[ImaginaryI]", " ", "\[ScriptT]", " ", 
       SubscriptBox["\[Omega]", "1"]}]], " ", "sin\[Phi]", " ", 
     "\[ScriptCapitalA]"}]}], ")"}], " ", 
  TagBox[
   SubscriptBox["I", 
    RowBox[{"1", "y"}]],
   DisplayForm]}]], "Output",
 CellChangeTimes->{{3.949544536952373*^9, 3.949544541556881*^9}, 
   3.9495448459646935`*^9, 3.9495448839919753`*^9, 3.9495449417040825`*^9, {
   3.949544982330584*^9, 3.9495450026221385`*^9}, 3.949545092742154*^9, 
   3.9495454918105392`*^9, 3.949546009432393*^9, 3.9495463193285146`*^9, 
   3.949546432629427*^9, 3.9495465472349005`*^9, {3.949554740851343*^9, 
   3.949554747369466*^9}, 3.949622962569158*^9, 3.949623042914688*^9, 
   3.949623578085167*^9, 3.949623655294483*^9, 3.949623713041192*^9, {
   3.9496238529772873`*^9, 3.9496238921686068`*^9}, 3.949623931535449*^9, 
   3.9496247897981195`*^9, {3.9496251507198305`*^9, 3.949625178069723*^9}, 
   3.949625410155085*^9, 3.9496257300392375`*^9, {3.9496305150190096`*^9, 
   3.949630527429384*^9}, 3.9496306631553116`*^9, 3.9496306969815693`*^9, 
   3.949630750130802*^9, 3.949630910975605*^9, {3.9496313039493585`*^9, 
   3.9496313623771*^9}, 3.9496314162863483`*^9, 3.949631973896699*^9, 
   3.949969585181892*^9, 3.9499699179147215`*^9, 3.9499700730974045`*^9, {
   3.9499701394121275`*^9, 3.949970153602019*^9}, 3.9499702200731754`*^9, 
   3.9499702829766264`*^9, 3.949970395180025*^9, 3.9499713772481623`*^9, 
   3.949971543514366*^9, 3.9499715740104685`*^9, {3.9499716717947598`*^9, 
   3.9499717451571817`*^9}, 3.94997183722665*^9, 3.9499719566066003`*^9, 
   3.949972521508653*^9, 3.9499731650931034`*^9, 3.9499732285164404`*^9, 
   3.9499733097432804`*^9, 3.9499747485348525`*^9, 3.949987032658293*^9, 
   3.949987090904454*^9, 3.949987287793317*^9, {3.950172846348385*^9, 
   3.9501728715489945`*^9}, 3.9584352074876738`*^9, 3.9584491953412037`*^9, 
   3.958451798577161*^9, {3.9584524983647213`*^9, 3.9584525044197927`*^9}, 
   3.9584525609504576`*^9, {3.958452652963237*^9, 3.9584526630038047`*^9}, 
   3.9584527624733133`*^9, 3.9584530978550653`*^9, {3.9584531291135283`*^9, 
   3.958453139370446*^9}, 3.958453192853644*^9, 3.9584532770434713`*^9, 
   3.9584534418484926`*^9, {3.9584535096697545`*^9, 3.958453536622583*^9}, {
   3.9584539408583975`*^9, 3.9584539575095415`*^9}, {3.95845400243448*^9, 
   3.958454041935007*^9}, 3.958454358092808*^9, 3.958454510491726*^9, 
   3.958455153208025*^9, 3.9584569097068834`*^9, 3.958457261404971*^9, {
   3.9584573903105917`*^9, 3.9584573922106*^9}, {3.9584575313367577`*^9, 
   3.958457540007726*^9}, 3.9584577768919683`*^9, 3.9584619827865467`*^9, 
   3.958462117438727*^9, 3.958466435246125*^9, 3.958467447755434*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[ScriptCapitalH]", "\[ScriptCapitalJ]"], "=", 
  RowBox[{"2", " ", "\[Pi]", " ", "\[ScriptCapitalJ]", " ", 
   RowBox[{
    RowBox[{"opI", "[", "1", "]"}], ".", 
    RowBox[{"opI", "[", "2", "]"}]}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"2", " ", "\[Pi]", " ", "\[ScriptCapitalJ]", " ", 
  RowBox[{"(", 
   RowBox[{
    TagBox[
     RowBox[{
      TagBox[
       SubscriptBox["I", 
        RowBox[{"1", "x"}]],
       DisplayForm], 
      AdjustmentBox["\[Bullet]",
       BoxMargins->{{-0.3, 0}, {0, 0}}], 
      TagBox[
       SubscriptBox["I", 
        RowBox[{"2", "x"}]],
       DisplayForm]}],
     DisplayForm], "+", 
    TagBox[
     RowBox[{
      TagBox[
       SubscriptBox["I", 
        RowBox[{"1", "y"}]],
       DisplayForm], 
      AdjustmentBox["\[Bullet]",
       BoxMargins->{{-0.3, 0}, {0, 0}}], 
      TagBox[
       SubscriptBox["I", 
        RowBox[{"2", "y"}]],
       DisplayForm]}],
     DisplayForm], "+", 
    TagBox[
     RowBox[{
      TagBox[
       SubscriptBox["I", 
        RowBox[{"1", "z"}]],
       DisplayForm], 
      AdjustmentBox["\[Bullet]",
       BoxMargins->{{-0.3, 0}, {0, 0}}], 
      TagBox[
       SubscriptBox["I", 
        RowBox[{"2", "z"}]],
       DisplayForm]}],
     DisplayForm]}], ")"}]}]], "Output",
 CellChangeTimes->{
  3.9501729507257104`*^9, 3.9584491961208353`*^9, 3.9584518001254406`*^9, 
   3.9584525627974873`*^9, 3.958452665919292*^9, 3.958452766848555*^9, 
   3.9584530991477423`*^9, 3.9584531404019327`*^9, 3.958453193600863*^9, 
   3.958453278066002*^9, 3.9584534427127295`*^9, {3.958453510416059*^9, 
   3.95845353747683*^9}, 3.958453958246235*^9, {3.958454003513297*^9, 
   3.958454042633506*^9}, 3.9584543617122345`*^9, 3.9584545160195904`*^9, 
   3.958455153260026*^9, 3.9584569097383685`*^9, 3.958457261435141*^9, 
   3.958457392234598*^9, 3.9584575400342875`*^9, 3.9584577769199705`*^9, 
   3.9584619828022256`*^9, 3.9584621174644003`*^9, 3.958466435271126*^9, 
   3.958467451802034*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    SubscriptBox["\[ScriptCapitalH]", "\[ScriptCapitalD]"], "[", "\[Tau]_", 
    "]"}], ":=", 
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], "k"], 
      RowBox[{"\[GothicCapitalD]", "[", 
       RowBox[{"2", ",", "l", ",", 
        RowBox[{"-", "k"}], ",", "\[Tau]"}], "]"}], 
      RowBox[{"opT", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "k"}], "}"}]}], "]"}], 
      RowBox[{
       RowBox[{"CartesianToSpherical", "[", 
        RowBox[{"2", ",", 
         RowBox[{"3", 
          SubscriptBox["\[ScriptB]", "FH"], " ", 
          RowBox[{"DiagonalMatrix", "[", 
           RowBox[{"{", 
            RowBox[{"2", ",", 
             RowBox[{"-", "1"}], ",", 
             RowBox[{"-", "1"}]}], "}"}], "]"}]}]}], "]"}], "[", "l", "]"}]}],
      ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", 
       RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"l", ",", 
       RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.9499720635870466`*^9, 3.949972088168496*^9}, {
   3.9499725315785704`*^9, 3.949972563431012*^9}, {3.9499727549080553`*^9, 
   3.9499727693202944`*^9}, {3.9499729352373495`*^9, 
   3.9499729374418344`*^9}, {3.949974760730102*^9, 3.9499747611112814`*^9}, {
   3.949986982450588*^9, 3.949987016497267*^9}, {3.9499870546161404`*^9, 
   3.9499870664649982`*^9}, 3.950172899546421*^9, {3.958454031226149*^9, 
   3.958454033217907*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[ScriptCapitalL]", "=", 
   RowBox[{
    RowBox[{"Superoperator", "[", "\[IndentingNewLine]", "           ", 
     RowBox[{"SchrodingerToInteractionPicture", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", "I"}], " ", 
         RowBox[{"CommutationSuperoperator", "[", 
          RowBox[{"0.47", 
           SubscriptBox["\[ScriptCapitalH]", "anti"]}], "]"}]}], "+", 
        RowBox[{
        "Superoperator", "[", "\[IndentingNewLine]", 
         "                                                                    \
                                                                              \
                     ", 
         RowBox[{
         "Lindbladian", "[", "\[IndentingNewLine]", 
          "                                                                   \
                                                                              \
                                              ", 
          RowBox[{
           RowBox[{
            SubscriptBox["\[ScriptCapitalH]", "\[ScriptCapitalD]"], "[", "0", 
            "]"}], ",", "\[IndentingNewLine]", 
           "                                                                  \
                                                                              \
                                               ", 
           RowBox[{"ExpressOperator", "[", " ", 
            RowBox[{
             RowBox[{"Exp", "[", 
              RowBox[{
               RowBox[{"-", "I"}], " ", 
               SubscriptBox["\[Tau]", "c"], " ", 
               RowBox[{"CommutationSuperoperator", "[", 
                SubscriptBox["\[ScriptCapitalH]", "Zeeman"], "]"}]}], "]"}], 
             "[", 
             RowBox[{"Adjoint", "[", 
              RowBox[{
               SubscriptBox["\[ScriptCapitalH]", "\[ScriptCapitalD]"], "[", 
               SubscriptBox["\[Tau]", "c"], "]"}], "]"}], "]"}], "]"}], ",", 
           "2"}], "\[IndentingNewLine]", 
          "                                                                   \
                                                                              \
                                                ", "]"}], 
         "\[IndentingNewLine]", 
         "                                                                    \
                                                                              \
                                        ", "]"}]}], ",", 
       "\[IndentingNewLine]", 
       "                                                                      \
   ", 
       SubscriptBox["\[ScriptCapitalH]", "Zeeman"], ",", "2"}], "]"}], 
     "\[IndentingNewLine]", "                                    ", "]"}], 
    "+", "\[IndentingNewLine]", 
    RowBox[{"ThermalizeSuperoperator", "[", 
     RowBox[{
      RowBox[{"PhenomenologicalRelaxationSuperoperator", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"3", 
              SuperscriptBox[
               SubscriptBox["\[ScriptB]", "FF"], "2"], 
              SubscriptBox["\[Tau]", "2"]}], ")"}], 
            RowBox[{"-", "1"}]], ",", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"3", 
              SuperscriptBox[
               SubscriptBox["\[ScriptB]", "FF"], "2"], 
              SubscriptBox["\[Tau]", "2"]}], ")"}], 
            RowBox[{"-", "1"}]]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"3", 
              SuperscriptBox[
               SubscriptBox["\[ScriptB]", "HH"], "2"], 
              SubscriptBox["\[Tau]", "2"]}], ")"}], 
            RowBox[{"-", "1"}]], ",", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"3", 
              SuperscriptBox[
               SubscriptBox["\[ScriptB]", "HH"], "2"], 
              SubscriptBox["\[Tau]", "2"]}], ")"}], 
            RowBox[{"-", "1"}]]}], "}"}]}], "}"}], "]"}], ",", 
      SubscriptBox["\[ScriptCapitalH]", "Zeeman"], ",", "300"}], "]"}]}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.929763606730373*^9, 3.9297636077221775`*^9}, {
   3.9297848264798355`*^9, 3.929784830358699*^9}, {3.9301806114243345`*^9, 
   3.9301806155873547`*^9}, {3.9301813569093323`*^9, 
   3.9301813782516336`*^9}, {3.9301814257604103`*^9, 3.930181685001317*^9}, {
   3.9493935971784534`*^9, 3.9493936491593847`*^9}, {3.9493936892432814`*^9, 
   3.9493937600870523`*^9}, {3.949393882575343*^9, 3.9493938953140793`*^9}, {
   3.9494540025623455`*^9, 3.94945402859719*^9}, {3.949454261980647*^9, 
   3.9494542637262354`*^9}, {3.9494543163548355`*^9, 
   3.9494543180941305`*^9}, {3.949545421188259*^9, 3.9495454467539887`*^9}, {
   3.9495460288583*^9, 3.9495460311273446`*^9}, {3.949546151221953*^9, 
   3.9495461516356015`*^9}, {3.949554674463186*^9, 3.949554703628584*^9}, {
   3.949623524751647*^9, 3.9496235405998964`*^9}, {3.949623613834222*^9, 
   3.9496236210240364`*^9}, {3.949623909372935*^9, 3.9496239159900846`*^9}, {
   3.9496240154409804`*^9, 3.949624036542634*^9}, 3.949624599091488*^9, 
   3.949624644081599*^9, {3.9496246797248526`*^9, 3.949624680192522*^9}, 
   3.9496251195069637`*^9, 3.9496252143086767`*^9, 3.9496253671429214`*^9, 
   3.949625522738553*^9, 3.949625641913879*^9, {3.9496292268933964`*^9, 
   3.949629227354627*^9}, {3.9496305219141226`*^9, 3.9496305909263616`*^9}, {
   3.9496307606414146`*^9, 3.9496307606948204`*^9}, {3.949631329472797*^9, 
   3.9496313296368074`*^9}, {3.9496314569344587`*^9, 
   3.9496314797877054`*^9}, {3.9499704220492754`*^9, 3.949970435258035*^9}, {
   3.949970465529478*^9, 3.9499705048338537`*^9}, {3.9499705728854413`*^9, 
   3.9499706669406*^9}, 3.9499716435681367`*^9, {3.949971843978732*^9, 
   3.9499718613400707`*^9}, {3.9499731798317885`*^9, 3.949973182298588*^9}, {
   3.9499747673314962`*^9, 3.949974769360536*^9}, 3.9501729103729496`*^9, {
   3.950172971392317*^9, 3.9501729717224054`*^9}, 3.950173213405422*^9, 
   3.9584512270454946`*^9, 3.958451427136448*^9, {3.958462108029104*^9, 
   3.9584621087094574`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", "\[IndentingNewLine]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     FractionBox[
      RowBox[{"\[HBar]", " ", 
       SubscriptBox["\[Omega]", "1"]}], 
      RowBox[{"4", " ", "kB", " ", "T"}]], ")"}], 
    RowBox[{"-", "1"}]], 
   RowBox[{"ExpressOperator", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"Superoperator", "[", "\[IndentingNewLine]", 
       RowBox[{"SchrodingerToInteractionPicture", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "I"}], " ", 
          RowBox[{"CommutationSuperoperator", "[", 
           SubscriptBox["\[ScriptCapitalH]", "anti"], "]"}]}], ",", 
         SubscriptBox["\[ScriptCapitalH]", "Zeeman"], ",", "2"}], "]"}], 
       "\[IndentingNewLine]", "]"}], "[", "\[IndentingNewLine]", 
      RowBox[{"ExpressOperator", "[", "\[IndentingNewLine]", 
       RowBox[{"ThermalEquilibriumDensityOperator", "[", 
        RowBox[{
         SubscriptBox["\[ScriptCapitalH]", "Zeeman"], ",", "T"}], "]"}], 
       "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"CartesianProductOperatorBasis", "[", "]"}]}], 
    "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", "]"}]], "Input",
 CellChangeTimes->{{3.958449242721656*^9, 3.9584493865307665`*^9}, {
   3.9584494235634413`*^9, 3.958449446010228*^9}, {3.9584503679463835`*^9, 
   3.95845038158078*^9}, {3.9584504785404882`*^9, 3.958450480560214*^9}, {
   3.958450645359599*^9, 3.958450658121577*^9}, {3.958450876479375*^9, 
   3.9584509302944117`*^9}, {3.958452577308649*^9, 3.9584525957300143`*^9}, {
   3.958452788193961*^9, 3.9584528848789186`*^9}, {3.958453159127326*^9, 
   3.9584531792362022`*^9}, {3.958453219617049*^9, 3.9584532614820185`*^9}, {
   3.958453389098627*^9, 3.9584534089840145`*^9}, 3.958453445938571*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["1", "2"]}], " ", "\[ScriptCapitalA]", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"cos\[Phi]", " ", 
     TagBox[
      SubscriptBox["I", 
       RowBox[{"1", "x"}]],
      DisplayForm]}], "+", 
    RowBox[{"sin\[Phi]", " ", 
     TagBox[
      SubscriptBox["I", 
       RowBox[{"1", "y"}]],
      DisplayForm]}]}], ")"}]}]], "Output",
 CellChangeTimes->{
  3.9584493339112463`*^9, {3.958449365251257*^9, 3.958449387381238*^9}, {
   3.958449435855768*^9, 3.9584494466627007`*^9}, {3.9584503836002417`*^9, 
   3.9584503851451387`*^9}, {3.958450481388548*^9, 3.958450487637412*^9}, 
   3.9584506586713266`*^9, 3.9584508832728667`*^9, {3.958450918086803*^9, 
   3.9584509308135667`*^9}, 3.9584512318633356`*^9, 3.958451432683052*^9, 
   3.9584518100792894`*^9, {3.958451866621636*^9, 3.9584518718121233`*^9}, {
   3.9584525707978563`*^9, 3.9584525965485573`*^9}, 3.9584526762843366`*^9, {
   3.958452780072277*^9, 3.9584528855625362`*^9}, 3.9584531065435686`*^9, {
   3.958453148025547*^9, 3.95845328586808*^9}, {3.9584533939267*^9, 
   3.958453409517165*^9}, 3.9584534502429276`*^9, {3.958453517770361*^9, 
   3.958453544865226*^9}, 3.9584539654524117`*^9, 3.9584540107670836`*^9, {
   3.958454041109356*^9, 3.9584540804702053`*^9}, 3.9584543696306047`*^9, 
   3.9584545290936704`*^9, 3.9584551587625523`*^9, 3.9584560420364447`*^9, 
   3.958456915171924*^9, 3.9584572670186977`*^9, 3.958457397895567*^9, 
   3.958457545631668*^9, 3.958457782519392*^9, 3.958462001367482*^9, 
   3.9584621230907702`*^9, 3.9584664410161676`*^9, 3.958467466608219*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"frqlist", "=", 
    RowBox[{"{", 
     RowBox[{
     "0.001", ",", "0.1", ",", "0.2", ",", "0.5", ",", "1", ",", "1.572", ",",
       "2", ",", "3", ",", "4", ",", "5", ",", "10", ",", "15.28"}], "}"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"eq", "=", 
    RowBox[{"Abs", "[", 
     RowBox[{"UseNumericalValues", "[", 
      RowBox[{
       FractionBox[
        RowBox[{"\[HBar]", " ", 
         SubscriptBox["\[Omega]", "1"]}], 
        RowBox[{"4", " ", "kB", " ", "T"}]], ",", "\"\<shielding\>\"", ",", 
       "0"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Rho]0", "=", 
    RowBox[{"UseNumericalValues", "[", 
     RowBox[{
      RowBox[{"ThermalEquilibriumDensityOperator", "[", 
       RowBox[{
        SubscriptBox["\[ScriptCapitalH]", "Zeeman"], ",", "T"}], "]"}], ",", 
      "\"\<shielding\>\"", ",", "0"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["\[ScriptCapitalS]", 
        RowBox[{"1", ",", "f"}]], ",", 
       SubscriptBox["\[ScriptCapitalS]", 
        RowBox[{"2", ",", "f"}]]}], "}"}], "=", 
     RowBox[{"Trajectory", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"\[Rho]0", "\[Rule]", 
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"opI", "[", 
           RowBox[{"1", ",", "\"\<x\>\""}], "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"opI", "[", 
           RowBox[{"1", ",", "\"\<y\>\""}], "]"}]}], "\[IndentingNewLine]", 
         "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"None", ",", "20"}], "}"}], "\[IndentingNewLine]", "}"}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{"BackgroundGenerator", "\[Rule]", 
        RowBox[{
        "Superoperator", "[", "\[IndentingNewLine]", 
         "                                                    ", 
         RowBox[{
         "UseNumericalValues", "[", "\[IndentingNewLine]", 
          "                                                            ", 
          RowBox[{
           RowBox[{
           "SuperoperatorMatrixRepresentation", "[", "\[ScriptCapitalL]", 
            "]"}], ",", "\"\<shielding\>\"", ",", "f"}], "]"}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"NormalizationFactor", "\[Rule]", "eq"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"InterpolationPoints", "\[Rule]", " ", "10000"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"MaxStepSize", "\[Rule]", 
        SuperscriptBox["10", 
         RowBox[{"-", "8"}]]}]}], "]"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"f", ",", "frqlist"}], "}"}]}], "\[IndentingNewLine]", "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.9297848769691687`*^9, 3.9297848777961226`*^9}, {
   3.9297849137582645`*^9, 3.9297849796333036`*^9}, {3.9297853039752803`*^9, 
   3.9297853346355696`*^9}, 3.930181060383525*^9, {3.9301813258608675`*^9, 
   3.9301813307419224`*^9}, {3.9301817680588655`*^9, 3.930181785039874*^9}, {
   3.9301819743691387`*^9, 3.9301819744581385`*^9}, {3.949393918784909*^9, 
   3.9493939982802587`*^9}, {3.9493945961742163`*^9, 3.949394598077523*^9}, {
   3.9493946385729623`*^9, 3.949394644654421*^9}, {3.9494520412228985`*^9, 
   3.949452114231209*^9}, {3.949454388721452*^9, 3.9494543926769395`*^9}, {
   3.949454441820709*^9, 3.9494545662509365`*^9}, {3.9494546146699853`*^9, 
   3.94945463794543*^9}, {3.9494548594238653`*^9, 3.9494548911740026`*^9}, {
   3.949455041383704*^9, 3.9494550779348755`*^9}, {3.949455165125407*^9, 
   3.9494551944855366`*^9}, {3.9494552829330454`*^9, 
   3.9494553352526164`*^9}, {3.9494553896425*^9, 3.949455389857184*^9}, {
   3.9494559238564653`*^9, 3.949455933508869*^9}, {3.9494563612229457`*^9, 
   3.949456385722101*^9}, {3.9494564817504587`*^9, 3.9494564828886766`*^9}, {
   3.9494565930309095`*^9, 3.9494565931037827`*^9}, {3.949456631821828*^9, 
   3.949456632129445*^9}, {3.949456945776065*^9, 3.949456948406827*^9}, {
   3.949457009208192*^9, 3.9494570093075285`*^9}, {3.9494572765769005`*^9, 
   3.949457317300383*^9}, {3.949457643114718*^9, 3.949457645175348*^9}, {
   3.9494577505893116`*^9, 3.9494577514206305`*^9}, {3.9494577919234333`*^9, 
   3.949457793178851*^9}, {3.94945782469937*^9, 3.949457824715129*^9}, 
   3.949457968273319*^9, {3.949460789400734*^9, 3.949460791192217*^9}, {
   3.9495369758005266`*^9, 3.949537003342338*^9}, {3.949545081734702*^9, 
   3.949545139708101*^9}, {3.9496230646001883`*^9, 3.949623068660018*^9}, {
   3.949623439666108*^9, 3.9496234446707935`*^9}, 3.9496253273651266`*^9, 
   3.949625566875328*^9, {3.949631076818654*^9, 3.9496310815935507`*^9}, 
   3.9496311416686597`*^9, {3.949631669891509*^9, 3.949631696747203*^9}, {
   3.949631882658014*^9, 3.9496318840151567`*^9}, {3.9499720000608625`*^9, 
   3.9499720168365297`*^9}, {3.949973335828665*^9, 3.9499733446371202`*^9}, {
   3.9499736172306643`*^9, 3.9499736180866337`*^9}, {3.949987557812972*^9, 
   3.949987570083146*^9}, {3.949987662523695*^9, 3.9499876625780325`*^9}, {
   3.9499933225243483`*^9, 3.949993323421405*^9}, {3.9499936239024673`*^9, 
   3.9499936317595053`*^9}, {3.9499940665731287`*^9, 
   3.9499940666775336`*^9}, {3.950173019930371*^9, 3.9501730982633343`*^9}, {
   3.950173201440584*^9, 3.9501732023094873`*^9}, {3.958451889345547*^9, 
   3.9584519130042114`*^9}, {3.9584520856387243`*^9, 
   3.9584520863470106`*^9}, {3.9584529219792423`*^9, 3.958453000508596*^9}, {
   3.9584530478740115`*^9, 3.958453049579115*^9}, {3.9584533132907867`*^9, 
   3.9584533641959004`*^9}, {3.9584543066397524`*^9, 
   3.9584543127862883`*^9}, {3.958454759922855*^9, 3.958454819828848*^9}, {
   3.958456901281363*^9, 3.958456903490219*^9}, {3.9584577631509895`*^9, 
   3.9584577726033344`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"S1", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", 
       RowBox[{
        SubscriptBox["\[ScriptCapitalS]", 
         RowBox[{"1", ",", 
          RowBox[{"frqlist", "[", 
           RowBox[{"[", "i", "]"}], "]"}]}]], "[", "5", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", "frqlist", "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"S2", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"5", ",", 
        RowBox[{
         SubscriptBox["\[ScriptCapitalS]", 
          RowBox[{"2", ",", 
           RowBox[{"frqlist", "[", 
            RowBox[{"[", "i", "]"}], "]"}]}]], "[", "5", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", 
        RowBox[{"Length", "[", "frqlist", "]"}]}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gr1", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Lighter", "[", "Blue", "]"}], ",", 
      RowBox[{"Arrow", "[", 
       RowBox[{"BezierCurve", "[", 
        RowBox[{"Take", "[", 
         RowBox[{"S1", ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "7"}], "}"}]}], "]"}], "]"}], "]"}]}], "}"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gr2", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Lighter", "[", "Orange", "]"}], ",", 
      RowBox[{"Arrow", "[", 
       RowBox[{"BezierCurve", "[", 
        RowBox[{"Take", "[", 
         RowBox[{"S2", ",", 
          RowBox[{"{", 
           RowBox[{"3", ",", "6"}], "}"}]}], "]"}], "]"}], "]"}]}], "}"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"gr3", "=", 
    RowBox[{"Graphics", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Darker", "[", "Green", "]"}], ",", 
       RowBox[{"Arrow", "[", 
        RowBox[{"BezierCurve", "[", 
         RowBox[{"Take", "[", 
          RowBox[{"S1", ",", 
           RowBox[{"{", 
            RowBox[{"9", ",", "12"}], "}"}]}], "]"}], "]"}], "]"}]}], "}"}], 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"p0", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Re", "[", 
         RowBox[{
          SubscriptBox["\[ScriptCapitalS]", 
           RowBox[{"1", ",", "0.001"}]], "[", "t", "]"}], "]"}], ",", 
        RowBox[{"Re", "[", 
         RowBox[{
          SubscriptBox["\[ScriptCapitalS]", 
           RowBox[{"2", ",", "1.572"}]], "[", "t", "]"}], "]"}], ",", 
        RowBox[{"Re", "[", 
         RowBox[{
          SubscriptBox["\[ScriptCapitalS]", 
           RowBox[{"1", ",", "15.28"}]], "[", "t", "]"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "20"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", "All"}], ",", "\[IndentingNewLine]", 
      RowBox[{"ImageSize", "\[Rule]", "800"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotLegends", "\[Rule]", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
        "\"\<\[LeftAngleBracket]\!\(\*SubscriptBox[\(I\), \(1  \
x\)]\)\!\(\*SubscriptBox[\(I\), \(2  x\)]\)+\!\(\*SubscriptBox[\(I\), \(1  \
x\)]\)\!\(\*SubscriptBox[\(I\), \(2  x\)]\)\[RightAngleBracket] \!\(\*
StyleBox[\"f\",
FontSlant->\"Italic\"]\) = 0.001 GHz\>\"", ",", "\[IndentingNewLine]", 
         "\"\<\[LeftAngleBracket]\!\(\*SubscriptBox[\(I\), \(1  \
x\)]\)\!\(\*SubscriptBox[\(I\), \(2  y\)]\)-\!\(\*SubscriptBox[\(I\), \(1  \
y\)]\)\!\(\*SubscriptBox[\(I\), \(2  x\)]\)\[RightAngleBracket] \!\(\*
StyleBox[\"f\",
FontSlant->\"Italic\"]\) = 1.572 GHz\>\"", ",", "\[IndentingNewLine]", 
         "\"\<\[LeftAngleBracket]\!\(\*SubscriptBox[\(I\), \(1  \
x\)]\)\!\(\*SubscriptBox[\(I\), \(2  x\)]\)+\!\(\*SubscriptBox[\(I\), \(1  \
x\)]\)\!\(\*SubscriptBox[\(I\), \(2  x\)]\)\[RightAngleBracket] \!\(\*
StyleBox[\"f\",
FontSlant->\"Italic\"]\) = 15.28 GHz\>\""}], "\[IndentingNewLine]", "}"}]}]}],
      "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"p0", ",", "gr3", ",", "gr2", ",", "gr1"}], "]"}]}], "Input",
 CellChangeTimes->{{3.9495371145946074`*^9, 3.949537144335899*^9}, {
   3.9495371797780843`*^9, 3.949537367903026*^9}, {3.9495374660614767`*^9, 
   3.9495375458413663`*^9}, {3.9495375777809205`*^9, 
   3.9495376127129836`*^9}, {3.949537666478544*^9, 3.949537789122879*^9}, {
   3.9495379475325475`*^9, 3.9495379546634197`*^9}, {3.9495380794936237`*^9, 
   3.9495380814075985`*^9}, {3.949538123205407*^9, 3.9495381328491726`*^9}, {
   3.9495381681097283`*^9, 3.9495382440801272`*^9}, {3.9495382832705264`*^9, 
   3.949538287079334*^9}, {3.949538350793231*^9, 3.9495384175472136`*^9}, {
   3.9495385211693325`*^9, 3.9495385693106155`*^9}, {3.9495386075063515`*^9, 
   3.9495386352232103`*^9}, {3.949538757303228*^9, 3.949538794318531*^9}, {
   3.9495388653121805`*^9, 3.949538873998083*^9}, {3.949538960321761*^9, 
   3.9495389792699823`*^9}, {3.9495393173608465`*^9, 
   3.9495393182452445`*^9}, {3.9495393624955044`*^9, 
   3.9495393631480274`*^9}, {3.949539494864271*^9, 3.9495395561061954`*^9}, {
   3.9495396092107515`*^9, 3.9495396384864964`*^9}, {3.9495396955887733`*^9, 
   3.9495397312089787`*^9}, {3.949545249538372*^9, 3.949545258831875*^9}, {
   3.9496234531522865`*^9, 3.9496235091778307`*^9}, {3.949625051454354*^9, 
   3.9496250602863245`*^9}, 3.9496253321422067`*^9, 3.9496255706089225`*^9, {
   3.949631157288327*^9, 3.9496312518596478`*^9}, {3.9499768025593634`*^9, 
   3.949976827713539*^9}, {3.949987664795149*^9, 3.949987687130001*^9}, {
   3.9499944701044426`*^9, 3.949994496628728*^9}, {3.949994580529475*^9, 
   3.9499947523648396`*^9}, {3.9499947887269316`*^9, 3.949994822031122*^9}, {
   3.9499948535515337`*^9, 3.9499950877671337`*^9}, {3.9499951208384953`*^9, 
   3.949995197693754*^9}, {3.950173206566501*^9, 3.9501732294637947`*^9}, {
   3.950173470326994*^9, 3.9501734767861414`*^9}, {3.958461679811081*^9, 
   3.9584617381502333`*^9}}],

Cell[BoxData[
 TemplateBox[{GraphicsBox[{{{{{}, {}, 
        TagBox[{
          Directive[
           Opacity[1.], 
           RGBColor[0.368417, 0.506779, 0.709798], 
           AbsoluteThickness[1.6]], 
          LineBox[CompressedData["
1:eJwVz2tMkwcYBeAiODOsETRTFCkFK5Vy55s6RXlfYNGixSkIbBgnVG5R7lKU
i8LUUpkBq6IgXa3cdIQVCvRTcHIRWVUKVenAOXAg2OmQjnXYYQHHvv04OXn+
nOQ48JODYxbQaLQgKv+39CT/I69oiS+NphEbCgJ9u7RMXjgzE9KNkNwZx4Z5
VdtpJrMAvjO7JAuK2gTSjkL7hcyrcOzAO7/b+3ZAwjZB4rR9DUymdPHUPuGg
nY0v/su+BQx9LyqTLeNg0eAoW2//CCYtzvEiazKgvFuW+tb+OWROzzAv6IVQ
V18wmOA+DnqXY9ulQZchDp5enUibgpfe16LVCikk6ZzHlHUm8AngLktKqQBL
hzPs4c9o2C0pDVveXw1FVmpOeaQ5Vmx5IXp6+XvgD+5rN+/5CH1GLBK5brWQ
+tMZfjLbEns54r68SDk0pNBDbAKXoNDRfMkJ53oozz4y7hluhQl1rXTbBAWc
ks3tfTdhjd7Ngcrq1Q1A047g3azl+KZsR5OtogGc0mOP7+N8gr/pPEPWbWuE
V8aSsMWtK7D93YBQUN8IO3WHT1xMtcGZjZNZ5rZNsPuV2IXBWI3en06ofDKa
YPw+P++h3BaX3l1w26WjCdytB+wCDtqhiPHr4ScLlWAJxqihKQZm+7CmvXyV
sEMfMe0YykT6oXgV66gSfumMNotwdcCex35vZmVKIM92fc00UnYyVHG7lBC7
UDCi0TiizVFVSfzvSjiUlk3Sy9biRsK/aN6MBI84Fw0vioVlLgfk4lUkPF7m
uliweR2y/A9OtHqQ8GPdKYmruRPaZFkE1/qRkG3G2dPzwgn1pfzsnGASLIey
uElKNuYl92uVkSTobjgUy3LWY6W48qV3AgnF61dZtIQ6o7Eq0TCXQYK4LPZB
FJODrve2jzTkkhBRfEBDf81BXr7oJENEwvvPq02yNhe8KLRcaVNEwpjO/3in
yBXLMriRzZdIqNjmZdsb5Yb9UaHDc6UkyIUC6zg3d+zr7mveIiVBFHpol7nR
HUus1NED10nYMFReI+r1QEPzw9ObqkgodZbIe3d5YoX1D+LJGyTkdhSW7mrx
xKXDuqWZNSQE2YZWd7O8cJH0rIeklgS/pAf7rQu88Oay7VbBchJka/isHqMX
/hk2lPu2jgTW/ZtXdu/3xmb69XuEgvrn1snpa/PG61vTVIENJMROWTx9xCEw
K1U8y2skgd/wN7PgPIF5SY9j1jSRkHAqZG7nBQLvnJO021MWhCif0S8RqNO6
rlxL+axRUCS+QqBRXNXuTLlus2m2REpgKVj9s5Gy6d78wI1aav+a9cweyuI+
emHXAwI3K76MP025rDIxPv8RgfkfZ57Ip1yZrgngqgkM4X4rLqB8a4V4Rq0h
8Dh5RnGe8lDE8nhtP4H9zz88k1Bmj60KGB0jMHfBWlUTZU9lFqNKR2DSYf2d
W5S3CAdNMa8JPBbWKm+hzGNLFX+ME3hFlVbYTjntCJNhMBD4hVv4BjXlnK3f
mBqnCBx+mbJaQ1m4ZPTndCOBCruyD08ol9ZXnnv/nsAxO2bbAOWKPIu4OzME
dnyVK3lOuXZvjH/OHIHaxVMZQ5SVjio7338J1Cfm7Bmm3DblZJqfJ9ChZc36
Ucr/AWERTMk=
           "]]}, Annotation[#, "Charting`Private`Tag$106164#1"]& ], 
        TagBox[{
          Directive[
           Opacity[1.], 
           RGBColor[0.880722, 0.611041, 0.142051], 
           AbsoluteThickness[1.6]], 
          LineBox[CompressedData["
1:eJwVz3s0FGgYBvARqZXKZVUShhW5M9+qODKvtKlGllwqqmVyLSlFiYpEqNS4
lNvKym3lIEVi+D6LXHILpSxtDmYrl7ViYij22z/e85zfH895zqvGPX3AcxmD
wThM7//MuMKVNPZIt2Aw0g5bux3ADT1Mm4PMi+xgrWOCiV4jstSIrzGZsexD
4QYVe7qBZNTGqS5nprJDOpVNzVrsiN+OoFOzqgXs7rCNjzkVbqRnwSfpX9VK
tmXWqfNNiWfIiv4hrQnVFvYawYWeif3hJOtFZsCYah8b0ioTL8bdIcUlsf1+
BqPsjvl3vrV594k3uyt1/Ow0u/r1qmeXXXOJv0B7uKxYxI4xuZOjd/0hkVKL
1Hq/nQGBSjMK5l4l5LZMq06Wmzh82aqUIlFUSrj9jkS8TRKKnT2j+2KekIDn
kdzTWlLgY5u113lTOSk9I+2wYe9q+KZ4o9vu+FOSFXpy1OigDEhvys+WS64g
EZlf7WfGZeFM/7fKjbxnhNEzCNUh8mA01LxmyaOSaAZ6BTvqKECjoe5ChH4V
GREmO6+qWQfFg/fnSzuryD7BicsJARsA8RwKp7z5xHaEp6uishHetBRp4I98
MlrPDW8uUgLRyHq/d3bVxEC2V9nqF2WoSeYnFDyuJlJsofvAtArcJUiQLFZD
rCdcZtWdmODSaR5+kVND3tZ5iLnoqcGoZfXll7E1pDym4RhTqAZs5lzm+uoa
4rU8aLCjQx0218ZwdMdqyPGzoeXSaT+ANaNsu6wsJobeuh027hpgNmh7wsYY
k045vVVBppthfZDeX6E/Y8IvjkjXE9cEpxfN+XXemISK6di1vaOWPF3ucwUT
qYGQPf5lWpAz4PwlIB4TQZ5aUualLWC1tWR39W+YJG1RlKh00oa3aSvXLhVj
wkvzanJn6sCJ3vEAvypMXJKOdkh/0AGxoWh5xQZM5nblijKxLojfHbil3I7J
sGBncF20HuQ1Vr5xeIXJgx3GSu3u+tDZ7dgs0Y9JUVSQrLe+AchNc3kug5hE
Ox3niAsN4KOB9aO3I5iYDGQVRLcbQvwYf1rsEyYp2ulF7RwjiNl9/4ndOCZh
tXEpnEoj0OOoXTsyicl+JafcFxrGsHZbQs7QFCaW/k2usrHGMNg/xhiaxiRz
E1ejTWgMFjd1tCuEmGjU59+zdWWBaVFswJZZ+p9+nU43ZgEXhVm6zmHy+3bX
7yJqWWDiqb7SjZpYzXwwrmMBp9ah1YP6n8OaufHPWWD7t6+1PzXn+g1V+zYW
lNo9WHeVWvL9ge9f9rEgX54ln0cdyhv+1j7DAtVXosQJaq9pia4WHQTzFeba
50SYHHu4q+OIHoKfqjQHz1M7u0e2TuojuBEVmRRCvbtTvFHBGMGt0izhVWrN
wmV8920IChrjUnnUAi4jV2SF4KR+lG8RtUf3QrD2UQSLVZE/Cqi5pZ+ZsXcQ
OK5JaN4/j4lfhMPXffEInsos7rKnDnIoeyOdiGAvpxQ7UscIg27z7iHwEcwU
uFIXm4oWkjMQHHqp4eZLLfpjqTevEEFIVoNNJDWvWzquoQmBsK0YPaNOyz7l
c70FgWzIzSN86uzADqs9rQjMFj9GYOqn63jzrR0IvgToNzdQD7jI+/S8RtAi
L23SRa01rGg1NEz7i7+mfqI2KgtRyREgUG1ySB+nNovqF3l+QCAVlpc2SW2j
lfHo0yiCzy6aCULqsyeZKlNTCGSGazzEFjC5ZH5V9HgaQeq+CAcJ6qjVQ68C
hQgW6ifZK6hTSrJvzs0hOOfbJrua+kG4hHfVPIILXRaza6kL7T13XvqKwLDe
7U856jL1RmWLRbrXh/gK1HhaU7S0hEDiUWXqBur/AH5F5Js=
           "]]}, Annotation[#, "Charting`Private`Tag$106164#2"]& ], 
        TagBox[{
          Directive[
           Opacity[1.], 
           RGBColor[0.560181, 0.691569, 0.194885], 
           AbsoluteThickness[1.6]], 
          LineBox[CompressedData["
1:eJwV03s41PkXB/AJq3IJJaU2t+RuzMz3p9JWczRyj9x/KZbJpQsqmdYiRSFR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           "]]}, 
         Annotation[#, "Charting`Private`Tag$106164#3"]& ]}}, {}, {}}, {
      RGBColor[0, 
       NCache[
        Rational[2, 3], 0.6666666666666666], 0], 
      ArrowBox[
       BezierCurveBox[{{5, -0.09352504295760869}, {
         5, -0.10787316018877995`}, {5, -0.1271340632038508}, {
         5, -0.12875906895485462`}}]]}, {
      RGBColor[1, 0.6666666666666666, 
       NCache[
        Rational[1, 3], 0.3333333333333333]], 
      ArrowBox[
       BezierCurveBox[{{5, -0.018922862372139734`}, {
         5, -0.04546534754996997}, {5, -0.0796880800674996}, {
         5, -0.10019066534745866`}}]]}, {
      RGBColor[
       NCache[
        Rational[1, 3], 0.3333333333333333], 
       NCache[
        Rational[1, 3], 0.3333333333333333], 1], 
      ArrowBox[
       BezierCurveBox[{{5, 0.06979165698979571}, {5, 0.0693825859726374}, {
         5, 0.06816404982659335}, {5, 0.059988344056242884`}, {
         5, 0.035098057799977336`}, {5, -0.000017295546896651497`}, {
         5, -0.024767796100594885`}}]]}}, {
    DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
     AxesOrigin -> {0, 0}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, DisplayFunction -> Identity, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.05], 
        Scaled[0.05]}}, PlotRangeClipping -> True, ImagePadding -> All, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {False, False}, 
     AxesLabel -> {None, None}, AxesOrigin -> {0, 0}, DisplayFunction :> 
     Identity, Frame -> {{True, True}, {True, True}}, 
     FrameLabel -> {{None, None}, {None, None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], ImageSize -> 800, 
     Method -> {
      "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
       AbsolutePointSize[6], "ScalingFunctions" -> None, 
       "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
            Part[#, 1]], 
           (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
            Part[#, 1]], 
           (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
            Part[#, 2]]}& )}}, PlotRange -> {All, All}, PlotRangeClipping -> 
     True, PlotRangePadding -> {{Automatic, Automatic}, {
       Automatic, Automatic}}, Ticks -> {Automatic, Automatic}}, LabelStyle -> 
    Directive[FontFamily -> "Helvetica", FontSize -> 14]],FormBox[
    FormBox[
     TemplateBox[{
      "\"\[LeftAngleBracket]\\!\\(\\*SubscriptBox[\\(I\\), \\(1  \
x\\)]\\)\\!\\(\\*SubscriptBox[\\(I\\), \\(2  \
x\\)]\\)+\\!\\(\\*SubscriptBox[\\(I\\), \\(1  \
x\\)]\\)\\!\\(\\*SubscriptBox[\\(I\\), \\(2  x\\)]\\)\[RightAngleBracket] \\!\
\\(\\*\\nStyleBox[\\\"f\\\",\\nFontSlant->\\\"Italic\\\"]\\) = 0.001 GHz\"", 
       "\"\[LeftAngleBracket]\\!\\(\\*SubscriptBox[\\(I\\), \\(1  x\\)]\\)\\!\
\\(\\*SubscriptBox[\\(I\\), \\(2  y\\)]\\)-\\!\\(\\*SubscriptBox[\\(I\\), \
\\(1  y\\)]\\)\\!\\(\\*SubscriptBox[\\(I\\), \\(2  x\\)]\\)\
\[RightAngleBracket] \
\\!\\(\\*\\nStyleBox[\\\"f\\\",\\nFontSlant->\\\"Italic\\\"]\\) = 1.572 \
GHz\"", "\"\[LeftAngleBracket]\\!\\(\\*SubscriptBox[\\(I\\), \\(1  \
x\\)]\\)\\!\\(\\*SubscriptBox[\\(I\\), \\(2  \
x\\)]\\)+\\!\\(\\*SubscriptBox[\\(I\\), \\(1  \
x\\)]\\)\\!\\(\\*SubscriptBox[\\(I\\), \\(2  x\\)]\\)\[RightAngleBracket] \\!\
\\(\\*\\nStyleBox[\\\"f\\\",\\nFontSlant->\\\"Italic\\\"]\\) = 15.28 GHz\""}, 
      "LineLegend", DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline), LabelStyle -> 
                    Directive[
                    FontFamily -> "Helvetica", FontSize -> 14]], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline), LabelStyle -> 
                    Directive[
                    FontFamily -> "Helvetica", FontSize -> 14]], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline), LabelStyle -> 
                    Directive[
                    FontFamily -> "Helvetica", FontSize -> 14]], #3}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
          Directive[FontFamily -> "Helvetica", FontSize -> 14], FontFamily -> 
          "Arial"}, Background -> Automatic, StripOnInput -> False], 
        TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0.368417, 0.506779, 0.709798]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0.880722, 0.611041, 0.142051]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.37345400000000006`, 0.461046, 0.12992333333333334`], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0.560181, 0.691569, 0.194885]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.560181, 0.691569, 0.194885]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.560181, 0.691569, 0.194885], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
               RowBox[{
                 RowBox[{"FontFamily", "\[Rule]", "\"Helvetica\""}], ",", 
                 RowBox[{"FontSize", "\[Rule]", "14"}]}], "]"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{
  3.949537144958857*^9, {3.949537187220742*^9, 3.949537223752797*^9}, {
   3.949537275325886*^9, 3.9495373685149603`*^9}, {3.9495374783631597`*^9, 
   3.9495375472167263`*^9}, {3.949537587437834*^9, 3.949537613283792*^9}, 
   3.9495377042153473`*^9, {3.949537744040215*^9, 3.9495377894781933`*^9}, 
   3.949537955071545*^9, 3.9495380820458107`*^9, {3.9495381247454925`*^9, 
   3.9495381331886845`*^9}, {3.9495381778253717`*^9, 3.94953824452029*^9}, {
   3.949538276376136*^9, 3.9495382874777527`*^9}, {3.9495383720039883`*^9, 
   3.9495384182425947`*^9}, 3.9495384556364536`*^9, {3.949538527653863*^9, 
   3.9495385745973024`*^9}, {3.9495386122500553`*^9, 3.9495386740984*^9}, {
   3.9495387845179586`*^9, 3.949538817981158*^9}, {3.949538903164089*^9, 
   3.9495389212714767`*^9}, {3.949538980269309*^9, 3.94953900224465*^9}, {
   3.9495392997782717`*^9, 3.9495394418960023`*^9}, {3.9495394970341887`*^9, 
   3.949539556712149*^9}, {3.9495396457632866`*^9, 3.949539660374987*^9}, {
   3.9495397189695835`*^9, 3.949539732229707*^9}, 3.9495398836665735`*^9, {
   3.949545236697359*^9, 3.949545259512292*^9}, 3.9495468486932774`*^9, 
   3.9495563895174394`*^9, 3.9496230829659443`*^9, {3.9496234639260488`*^9, 
   3.9496235101064186`*^9}, {3.9496250320069714`*^9, 3.949625061019396*^9}, 
   3.949625206758112*^9, 3.949625237129821*^9, 3.949625349511857*^9, 
   3.949625384428697*^9, 3.9496254439741306`*^9, {3.9496255530199957`*^9, 
   3.949625571299712*^9}, 3.949625674802305*^9, 3.949625714543068*^9, 
   3.949628498685133*^9, 3.9496292517009473`*^9, 3.9496309314732943`*^9, {
   3.9496311845744505`*^9, 3.9496312521182814`*^9}, 3.949631434083929*^9, 
   3.949631526703053*^9, {3.949631749401573*^9, 3.9496317557833133`*^9}, 
   3.9496320691189885`*^9, 3.949970026317568*^9, 3.9499717937739077`*^9, 
   3.949972323033631*^9, 3.9499735729159527`*^9, 3.9499767274258585`*^9, {
   3.9499768094262357`*^9, 3.949976828042079*^9}, 3.949976868305844*^9, 
   3.9499878774422708`*^9, 3.9499879263252983`*^9, 3.949990227213361*^9, 
   3.9499931495799723`*^9, 3.949993553227309*^9, 3.949994027811393*^9, 
   3.949994292027253*^9, 3.9499943406253543`*^9, {3.9499946199048405`*^9, 
   3.9499946758590155`*^9}, {3.949994722036785*^9, 3.9499947531049585`*^9}, {
   3.949994798227585*^9, 3.9499948222109766`*^9}, 3.9499948540680003`*^9, {
   3.9499948882994003`*^9, 3.9499950166665998`*^9}, {3.949995048422932*^9, 
   3.949995088131486*^9}, {3.9499951355915184`*^9, 3.9499951980559406`*^9}, 
   3.950173164979268*^9, 3.9501732805377903`*^9, 3.9501734807576623`*^9, {
   3.9584542061289473`*^9, 3.958454209650628*^9}, 3.9584547460281568`*^9, 
   3.9584548074430475`*^9, 3.958454886152505*^9, 3.9584552158177023`*^9, 
   3.958456974642309*^9, {3.958457327216217*^9, 3.95845733374117*^9}, 
   3.9584574563102636`*^9, 3.958457603103019*^9, 3.958457841351945*^9, 
   3.958462055854574*^9, 3.958462179361296*^9, 3.9584676041205225`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"pdatamineP", "=", 
   RowBox[{
    RowBox[{"Cases", "[", 
     RowBox[{"p0", ",", " ", 
      RowBox[{
       RowBox[{"Point", "[", "pts_", "]"}], "\[RuleDelayed]", "pts"}], ",", 
      " ", "Infinity"}], "]"}], " ", "//", " ", 
    RowBox[{
     RowBox[{"Flatten", "[", 
      RowBox[{"#", ",", "1"}], "]"}], "&"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"datamineL", "=", 
   RowBox[{
    RowBox[{"Cases", "[", 
     RowBox[{"p0", ",", 
      RowBox[{
       RowBox[{"Line", "[", "pts_", "]"}], "\[RuleDelayed]", "pts"}], ",", 
      " ", "Infinity"}], "]"}], " ", "//", " ", 
    RowBox[{
     RowBox[{"Flatten", "[", 
      RowBox[{"#", ",", "1"}], "]"}], "&"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{"\"\<plotData4.csv\>\"", ",", "datamineL", ",", "\"\<CSV\>\""}], 
   "]"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.95846761029375*^9, 3.9584676684754915`*^9}, {
  3.9584677041594453`*^9, 3.958467705165794*^9}, {3.958467744983263*^9, 
  3.9584677481823673`*^9}}],

Cell[BoxData["\<\"plotData4.csv\"\>"], "Output",
 CellChangeTimes->{3.9584676317236633`*^9, 3.9584676774335175`*^9, 
  3.9584677087874155`*^9, 3.9584677558801107`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"p1", "=", 
   RowBox[{"ListPlot", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Transpose", "[", "\[IndentingNewLine]", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{
           SubscriptBox["\[ScriptCapitalS]", 
            RowBox[{"1", ",", 
             RowBox[{"frqlist", "[", 
              RowBox[{"[", "i", "]"}], "]"}]}]], "[", "20", "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "1", ",", 
            RowBox[{"Length", "[", "frqlist", "]"}]}], "}"}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{
           SubscriptBox["\[ScriptCapitalS]", 
            RowBox[{"2", ",", 
             RowBox[{"frqlist", "[", 
              RowBox[{"[", "i", "]"}], "]"}]}]], "[", "20", "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "1", ",", 
            RowBox[{"Length", "[", "frqlist", "]"}]}], "}"}]}], "]"}]}], 
       "\[IndentingNewLine]", "}"}], "\[IndentingNewLine]", "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"PlotStyle", "\[Rule]", "Blue"}], ",", 
     RowBox[{"Joined", "\[Rule]", "False"}]}], "\[IndentingNewLine]", "]"}]}],
   ";"}]], "Input",
 CellChangeTimes->{{3.949458212280498*^9, 3.949458257824402*^9}, {
   3.949458298059905*^9, 3.94945834106256*^9}, {3.949458387227206*^9, 
   3.9494584349756556`*^9}, {3.9494607418541117`*^9, 
   3.9494607424324665`*^9}, {3.949460810303065*^9, 3.9494608157161517`*^9}, {
   3.94953703371826*^9, 3.9495370350021014`*^9}, {3.949537814242602*^9, 
   3.9495378343770213`*^9}, {3.9496316016201115`*^9, 
   3.9496316491195307`*^9}, {3.9496317787548447`*^9, 3.949631852388104*^9}, {
   3.9496319096938567`*^9, 3.9496319209511356`*^9}, {3.9499932363657556`*^9, 
   3.9499932590765815`*^9}, {3.949993294572756*^9, 3.9499933078361893`*^9}, {
   3.949993572695161*^9, 3.949993579337019*^9}, {3.949994048371553*^9, 
   3.949994051950161*^9}, {3.949994420025407*^9, 3.9499944381494355`*^9}, {
   3.9501732997009597`*^9, 3.9501733302596607`*^9}, {3.950173360667926*^9, 
   3.9501733614445143`*^9}, {3.958457048839891*^9, 3.9584570516450853`*^9}, {
   3.9584573565252748`*^9, 3.9584573718684072`*^9}, 3.9584575085335093`*^9, {
   3.9584578529113255`*^9, 3.95845785365736*^9}, {3.958462218507362*^9, 
   3.9584622452405977`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"p2", "=", 
   RowBox[{"ParametricPlot", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{"0.675", 
       RowBox[{"ReIm", "[", 
        RowBox[{"UseNumericalValues", "[", 
         RowBox[{
          RowBox[{"\[ScriptCapitalA]", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"\[ImaginaryI]", " ", "\[Phi]"}]]}], ",", 
          "\"\<shielding\>\"", ",", "\[Nu]"}], "]"}], "]"}]}], 
      "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"\[Nu]", ",", "0", ",", "15.28"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Blue", ",", "Red"}], "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"AspectRatio", "\[Rule]", 
      RowBox[{"1", "/", "2"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.25"}], ",", "0.25"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"-", "0.25"}]}], "}"}]}], "}"}]}], ",", 
     RowBox[{"AxesOrigin", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.25"}], ",", "0"}], "}"}]}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.9494551477016463`*^9, 3.949455147917017*^9}, {
   3.9494552313462877`*^9, 3.949455239965022*^9}, {3.9494557402774954`*^9, 
   3.9494557576223187`*^9}, {3.9494583011792655`*^9, 3.9494583014719505`*^9}, 
   3.9494583890699544`*^9, {3.949458436269555*^9, 3.9494584376868362`*^9}, {
   3.949459242224915*^9, 3.9494592460322905`*^9}, {3.949460593780493*^9, 
   3.949460658512121*^9}, {3.9494606912495594`*^9, 3.9494607097732697`*^9}, {
   3.949460848331006*^9, 3.9494608501085815`*^9}, {3.9495368102342644`*^9, 
   3.949536868984703*^9}, {3.949536954117111*^9, 3.949536961789772*^9}, {
   3.9495466267118464`*^9, 3.949546627681324*^9}, {3.9496231246564283`*^9, 
   3.949623205725114*^9}, {3.949623244323118*^9, 3.949623249865218*^9}, {
   3.949623330964454*^9, 3.9496233554235897`*^9}, {3.949630949661104*^9, 
   3.949630951075779*^9}, 3.949631871055332*^9, {3.958462265215915*^9, 
   3.9584622919459286`*^9}, {3.9584623871446505`*^9, 3.9584623926982155`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"p0", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p3", "=", 
   RowBox[{"Graphics", "[", "\[IndentingNewLine]", 
    RowBox[{"Table", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"v", "=", 
        RowBox[{"0.1", 
         RowBox[{"Normalize", "[", 
          RowBox[{"ReIm", "[", 
           RowBox[{"UseNumericalValues", "[", 
            RowBox[{
             RowBox[{"\[ScriptCapitalA]", " ", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{"\[ImaginaryI]", " ", "\[Phi]"}]]}], ",", 
             "\"\<shielding\>\"", ",", "i"}], "]"}], "]"}], "]"}]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Rotate", "[", 
          RowBox[{
           RowBox[{"Text", "[", 
            RowBox[{
             RowBox[{"StringJoin", "[", 
              RowBox[{
               RowBox[{"ToString", "[", "i", "]"}], ",", "\"\< GHz\>\""}], 
              "]"}], ",", 
             RowBox[{"p0", "+", 
              RowBox[{"2.3", "v"}]}]}], "]"}], ",", 
           RowBox[{
            RowBox[{"ArcTan", "[", 
             RowBox[{
              RowBox[{"v", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{"v", "[", 
               RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "+", 
            RowBox[{"\[Pi]", "/", "2"}]}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"GrayLevel", "[", "0.5", "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{"p0", ",", 
            RowBox[{"p0", "+", 
             RowBox[{"2", "v"}]}]}], "}"}], "]"}]}], "\[IndentingNewLine]", 
        "}"}]}], "\[IndentingNewLine]", ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", 
        RowBox[{"{", 
         RowBox[{"0.2", ",", "0.5", ",", "1", ",", "2", ",", "5"}], "}"}]}], 
       "}"}]}], "]"}], "\[IndentingNewLine]", "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.949458477828309*^9, 3.9494584847873015`*^9}, {
   3.9494585410791883`*^9, 3.9494585511845536`*^9}, {3.949458605873294*^9, 
   3.949458717391867*^9}, {3.9494587805014668`*^9, 3.9494589742223372`*^9}, {
   3.949459086539304*^9, 3.9494591905505834`*^9}, {3.949460670898567*^9, 
   3.9494606782613373`*^9}, {3.9494608228103733`*^9, 3.9494608664295025`*^9}, 
   3.9494641620743837`*^9, {3.949536783525216*^9, 3.949536784600075*^9}, {
   3.949536882086482*^9, 3.9495369239143715`*^9}, {3.9495466316281433`*^9, 
   3.949546633604333*^9}, {3.9496232171548195`*^9, 3.9496232318985896`*^9}, {
   3.949623263519165*^9, 3.9496233087905397`*^9}, {3.9496233747632017`*^9, 
   3.949623400994502*^9}, {3.9499932218769484`*^9, 3.9499932245462775`*^9}, 
   3.95844432327635*^9, {3.9584623630223308`*^9, 3.9584623767004766`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"p2", ",", "p3", ",", "p1"}], "]"}]], "Input",
 CellChangeTimes->{{3.949458704662285*^9, 3.949458731855507*^9}, {
  3.949459159792941*^9, 3.949459161658117*^9}, {3.9494592531969748`*^9, 
  3.949459258508204*^9}, {3.9584572017329903`*^9, 3.958457210849079*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[1, 0, 0], AbsoluteThickness[1.6], Opacity[1.], FaceForm[
      Opacity[0.3]], LineBox[CompressedData["
1:eJwt1nc8V+/7B3BSRoVoSCWkjKLITOPYJSNZlS2JUIkQUlllhUIiyZaR+X7b
vN5GiqIQUWQUH4qS0dD63n6P3/nnPJ6Pcz/OfZ9zX9d1X8InzxvaL2FiYgpl
ZmJavE/05S9YnKVTTP9/fQg59/Ewscuv+HmlKFVkWH+qXEP8lmudw/aoo5is
bD1T5UKn1s9mKtwzNUPsNZFfe4mbrT9JTUfa4pTw5fMJznSKVXU6w2PGHg8C
W592OtGp4qnoqh4TJ5z86c4xfoZOvWymSaysPIcKKT25Pkc69eYv9zG2yAuw
4k7UzXKgU+bbdAOc4Q63Ck7TI6fpVMnzoPmCaQ8UGrYavzpFp5yMTVa1C1/C
3R82evJ2dEr1xSrZx4Y+MI7p0HCzpVOimq/qogMvw4wephJuTaf+Td5dK0W7
gt/SlRZHzemUotnJ3lNh/vhxTTbs73Hy/hNs1rZpARh6/6/7himdahgXXkNV
BWKV89H/dh6lU+we7H13JoKx10G7VlefTr3KETLkZL6BR3mXOrV06JRJw/Hn
lutDECvJM/RCg06V61cmB2uFweWy0aSVKp2aZRE7fcIyHEseXrFu3U+nfjcb
cDJdjMBYz/ssBQU6NeQ5NFKXEomjsclsp7fRqb/zKknjvreQGzse1ydEp1w/
09WCWW+jc2n8Z4lNdGpfz5ze0lu3sWUPXcmWl3zfywi+rMwYNMigb8cfGrUu
y0XZpi0O8kprTt74TqMi94c3fze9A850z92MrzTK/KVKh9PQHXypbfvaMkqj
TmXx/R6ciYf8YOwU9ZxGnVFSXfplbSIKKi3KbjymUcXB3AOHkxPRGrfF6lEd
jYpPsfT1Fb2Hj4GO928X0ajAy2zVxxSSMJ7ALfvkNo2qlTpzfNQoGV2snEWT
BjRKYbT54Eu1VJxn1Um1PEijQr85uXKGp6J0XmnXw/00qj3weZpEVypa/s1l
t0rQqLODWjJ/TqZh/pV2zyEmGqVYzuvJ4p+Oo9weY9pZpZSPw04pkbJMmHgc
tbBPLKW8P+f+5vudiYOKBrUWkaXU1uAS2w+qWbjKNDEy6EHGb/q5Y0lbFnZF
+KnuUy+lTG/LFWoOZ8OzJDzH7XUJlXDK6Fkkcy48PqxMsGkpoR5cDt3XqpGL
fcofRKWqS6iT3+1yem7k4q/0np6TySXUwMfvX2w48zAzNZWiaVdC3fm0sUZ6
XT6+j+k08P5XTP2Ykx9y2VyAOpYGM7HeIqooUFIgiKUYLSJ5OV5Piqiut1X+
bwSLsb/1vX5RWRHVFB0wybevGOlWY9pvY4uo9quGTgcvFuN2j/GTTQZFlIIG
r5zn+2K4dU48HA8qpFrfVJf+qSnBgjXvtlqbQkrOdLqr4nUJxMTVXzjsK6S2
/za+cmKmBOoP3vGqzhZQlkmnhXTESiHI3ynIaV1A3eS84jkVVQqxvqz2E7se
UftZpO5stqBhKdfs9mr2R5SL45EUCQ8a0v3nDX4M51PMA0ab+CNp2Kw6bcsW
m0/d9deVyQQNbVZeZwO+5VGfJP+YugrTwTOgUKFMz6Wmt/7H/nSQDu/xU9Fb
Nz2k1jYHPNl7sBwcN1Pf+M9kU3/408qNLcqxLseL+cnTbMpzwk/Y8EI5bFOc
dyz3yKbuHw0/tpBYjsBv1V2Xn2dRuo73eZimyrFpdG7qhFcmdUFtpHcwvAK6
Xr7pG5FGPZRKMflBq8Sa5pJGrpg06pP/x4yU5kpUfTMInz2dRq3cczFFqrcS
JbFye2K40qjon6to8wuV+DUetkHWMpXSjFBkpqgqMAJY0x2nH1B6evK3axqq
kBj02lJfP5FSZ5kaSaVXI/+aUDzLZAJVKmWXsPVxNWq+DwbmhSZQ6m9Lg0Ne
VWMmyYmlp+ku1XN9lJqbqcYakYMK2crxVJJ5Ipvlzhqs6b+5tmlrLFV4fjV7
4IMaWI39GPpcH0M5pJavFn5UAxNJY4F11jGUb8zAudSqGjD5PpC3SLhNXVZR
s9XurgFb+8vHPZy3KM3/HlsrcdTCLc5Tc8nncGq3qVBqhnMt9Dv4XzqLh1PU
iUn+C161cH9zu3LwZBilqRQnKRxYi6HfxfUfX4dQ7TLxXpKJtVjNYzWS0xBM
/R5rWzPTXAvDT6lHjihepfZyuFvobazDs80H/G6vMqeCmHPjJwrrkCPz7Bj9
lAnlMdYr9KS8DgFFL1u73I9QM8WvAyJRh/d7/9O5kCxD6ejpibxtr0Nsupa/
/i5DNH3tX3dusg6/3qyXXH/rPOzqyqcjRIBuz943uTsvoFLoWyXPduDE8RlN
t1g3dB2qe+gvDYTusi/7ZuUBmQpFHZH9gEREnlTFFx/MlgnPnjcBDh79Nnrv
XwAKS1OPqwYA7gsCG0sKA5GbFGQfcAPo7DOKirUOQqTe1k+FEcBreyOrmrpg
zDg301/eAQq5c5nCfUKQHjedtCMXqAgUi/omHgqnrcubOgvIesT7Xm5/HYpO
H1Uuh1Lg6Mef+LQ7HHGRMrbHaoBnwokdjf/dRBH/a+MTbcBhtqMeZ2Ijkamc
Me7cAaSxxUW/UolC9L4CbZduYN2OsK7LutF4cO7YU4UBYDj4q7ty+i2sf67N
Mf8JkFb2XD99OBYn1/aGrWFhIDNoNNcxKxZ5Y08Li5YycLqBJbaaOQ56cWKT
aqwMxDeNpXwpjwMVajGkzcFAzNcQvfAt8bjZ1iHxnosBzZ2mSh2X4/FuyxU/
mVUMqBs7LHzpiccG1/OGnjwM9FwJMywPu4sTShm096sZ2HBWMtlxOgExTxKf
6q9nQPC6WairdiLWtL2JNeRn4MnvOwtH0hLxwejxYb0NDNg+aO+KNbqHhBKD
bLFNDNyLa/ryM+8evt6udmATYIB9Wc1P+aVJqHt2SvMd8SGTX1q7aUk4HVAe
fkGQAbn+m+ozK+5jm+hXzp1CDKwvoaWE2N2HiVLo0DCx2cuL3xR5k3HkQmrO
ri0MzMv6PzI4k4ykKxcrW4gncpapUYxkuMbp6JqLMJCre/DG/bMPINtpJGW/
lYG8vku/VjY9gNi1+NgB4hP2Sz+Kc6bAh39psd42Bv792rggr5SCFxxcUXTi
K9nTD6TsUqBwQHjvWlEGTPRr2rgjU0icpNa7EL/NX+rZX5GCVTvHd9YQi1Qn
hse8T4FV+KEoFjEGKlYnMstzpSLj4IovasSuZo7PGEqp4L3vauZDXJRO61ew
SwWeFw7kEIv2e0rE30xF5orvQR3EE9JfMofLU7HN1dniKzHPpUytdSOp+DIo
7sohzkBigiOT/Mo0HP6r+pyfmOWn3tP9Cmno3sC4vGXRg0Ux0jZpiBVKvylC
/PO9zHHOsDTcCB5eLkA8Yla24lUpsbIjEzexb41DRtBAGm7f2+Dzk8y3e3Xp
ekG2dPjZdAb2E0c7HLJOl07HskhriQriXskN53nM0nHAIcQzgji3wII6E5gO
B2sOrxPEdVeCn+Tmp2PdyjgFQeJD7w//6+5ORxvfK8YA+V/rtNLfffybjmE5
e+E4YuGMJssJsQxUrRqw0ySO/CPi0WGQgWsHm2M+k/1Qab4okO6dAe7jqTXR
xAbHHh6xSsuA/t0PEzuIC8wLFW7NZoD1i/ZVPbK/m6kmEd2NmajKXKnZQ+Ih
fnvt0a9qmfgRc873OHGPgLbZwq1MuN/PPqVN4ud4m9l2q8pMcGmXSFYIM2De
qyuaP5QJ0X2NUULEhRH8Uay7srD586zBOxKvpjUbZnlNs/B8689GWeJgi0MX
OPyywBL04lfAZhL/A7n5tNYszCjqv+ci8a77iLuOxT4bHDO/iwZI/ljejYy2
Cc9G1fgepyXE7wS07LKLs1GksERZmOTbmdiFfzN/snGtwkhTbx0DW/YOvvOP
e4gMx/vCNrwMbPpP2Wdn9UM4+m7OMiX5a3qpgO3x0EMsvLaNPkjy+5ygwHzh
jhwobVleu57kv98eOQ4/Rg4mfqcEeZP68INLQcR7NAdnbu7V1GAn8Xlko6T1
8lzY+2lUcLAxEJ7KsnLCKBcKavJvg0i9GTHi5ZsbJYVxoXa3z1/gGrve2fFl
+chREv/u8x8gdj9iOlAiHw1JZk7nPwDfuNO8OfTykfex1t5smPjSZHZnTD7U
DwnuXfMWuGUf3mwp9AjaWpxa/O2AvvMAk5l8AWh/6p54lQB51NL5wyYF2N8z
s2ZjIdAyzPxL3KMAE3pz3OV5gNawtk4+rQDrnYQ0+jIAdT2eMy93F4L78crV
T0k95y1JE2hZW4TSF2tDzbwBq3gu/h3biuAhcKwh0gPwL/FEoFwRgq5GedRc
AJSFWfn4jYrAu/KDz1InQEgxQvFVVBFY7/YYHzID2HErIpKtGN6nw0pz9gA3
llSes1hXjJnC1B2+8mT89WpR4W3FqOBifaslAwRar90apVaMJ49WcbaJA3yy
P7L/XC4GuMN+xPEBl/ioULHpYjzjuXNLZK4OekM2CY9flMBi2XK+Szl1WHbM
0fveuxL8eRa9Yn9GHXawRXE7TJVg+LM3fifXgdW333VweSlCJ4PvuMTWQTFD
LtxEsxSVmZtMuK/WwXYb/xHzilK08c57OhvVoTVbKvHLHRoiR668bvtRC7Nn
eg+DM2jQ2SIpyzxbi3xLiRW8JTS8jOilS0+R5yNf33O20XCk6dnxoOFakjfX
L95eQsed0Vmpfy21WPcoqKjLmY5VuWtzdEj/8JrZ7Z+5Yhm4+Jod/JVq4ZzX
+3tWrQwduwP76btrIZr+TThIv4z0rcd//CdZC8Yk33yEfRlqRa1UNIVrcYJf
f69qTBnexixp+0D6mcKtvJJKU2VgqPVF176pQaRc58sr98rxsaTxMrNvDfoN
W5QdRyrQa9y7gbe8GvVhuct+f6rAQsjLpr9F1choGTINna/AgHfS9Y+51TBW
zE+KZq+EfHzDSSRXg9lUSNxwZyVEJrRmra5Xw2xzU1vGpUq0FhdweZuQfs3t
c0QGexXpcxKT5War0LNSnO3Tump4rfBTiJaqwrdblWcLBcm8oqnoE62CewyX
5VnxanKOu1IiQlUQuss60b2nGp4e6jJlvFXI+lOjbGZRja0/71H93yuxvNV/
WDalGmyDW5kkGyqhoFV9V0ekBo8ZA8HTppV4m7f9N+v6WkzRUjIf+Vdg/92N
6vUPSV81G1ll/6sM+VVaAmbLSd156h5VeYqOsFRd3HxAzpV92XuzJ0pRuNpm
/seaeoSuNTeKu1cCHSU3iaJr9RgNs9jVqVWMa5t5Z/u761Gu53AnY1MRdD26
ePdvbYAJY2ZPXv8jlHFKHDtv3wChrlGOnpI8qKmEdXgmNCDe8DSv64sczAVH
Vba3NOBIyoojG0azUXD16Mvr0w3gX7PtfKVSFl79ucZizdMI9uaRuzoFGUh5
3KYlIN0IaMRZvtqUjrd/fzoMHmoEz4HjbRtqU8F6/57pcptGPDJQ6/5kmoJx
rpS2BPdGOH7Q9/XjT0Zp47Nr9oGN0NP3MZ18dQ8dY+mvFW83otSn2mcqIAGp
J0R7dyQ3QrZF5o2VVzyituhvN3vYiB3tMiY/o+MQvlTBebS4EXMh6itX34/B
Z8WR+ujKRlKPnfO+j9xCWYF+dymjETPcX+MObYqGlMt8lH1zI6yK25yteW+i
7QA/085njUjXnD3gIxwGX0GlPbEvGmF345nlHN8NvLPNYmHvakTqZAQ94VQQ
/mbdktzW04hdZU+ldRP9kbI3ODijtxEO91+F/fvlh3rD+qF84qr2YouFcT8s
ZCvI04nvHTW7+qPbD10NfS2Pia8cqC79W+iHcQuztDHi1cw363ef8oPWqmWr
xfoaofK7vUKp7TKGLhewpxMrhZ+2Kkv1xXxv29SNN42o1mNP1TH2xnjzV5Uo
YmebOu1wFW8oJf2LuEN801I2qV3SG3O6/3FnEi90uirbLPPG8YjD9fXEfmaf
VArLLqHd91L3T2KtSP+kX/yXML755dtTbxsxL3ThldZ7TxQInhMQ629Edm7G
dbdrF6HMxHNakthdJZ3efe4i5mpUc2SI13XmDe+1vAiff6aC+4glJqekeJQv
wr4zvtWA+MHok4DBWXeYfMoW9CYW/C7ku9zRHXHhzt2PicvP5iTFGrph/eaM
i63EdzjtWE1V3XDmbSXXC+KMUknTDdJuEHW9LttLLFQkmJnH6QaZuTHqI7Hd
x4HJ6acXULGjz55zoBE6UftvLFO5AEm/D9+OEGubfeAylHYFxzmVESPi9b38
vY2CrjA4Pff0GLEDm6qJErcrfKddQqyJUz4UdBj2n4da69sX54iFxB42Hzt+
HhbqIQERxHyDRrvsjp5DyHRmcBOxSYORjNdBFxRkcw89IZYNhP4yMRc0JK9W
eEYce/V73l1WF0wbzrzqIHYyHRF68dgZtFa1d++IOfYYdfpoOCMleVLoB/GI
nZHaczUnsF1df1HsXSPCQx0G9dUdcXKaFrCdODO21OyFkCO6p85GSBFfF9/T
Y/LXAaYK1C1Z4tePRp9crHQAr1maDUVc/TXaeWGXA8S7/NebEitGSZ0S2Xwa
6j0Cf64Sd+aklA7/tcPE3xH3AGL51mdHBQfskEXjHgsi/ryrnnGy2g7MfQ9r
Qonn4vet+OVlh14VftkY4i7tSYkLX09CrmRcK5N45VoHHbdRWwwnVvA3Ew/l
iKpeTrdGa8SB4SfE2s71Ih321jAzZM5sIRYX6Xy9S9waRzQ0hNuIx0I18pY/
soIsx/RkF/EDiU0M+XJL8KRbdQ4Re/yjcqzbzLGr5arVCHFeaEqsQbQ5Lqz9
Ofae+FDtNSkdI3No9C1MjhFPNvVZWfaZ4eH0mbZJ4mUhzf7zoyegOeY0/J1Y
q+NC3wzTcRj79cj+JF4YEY/xazoG8SZawAIx5wzPa56QYygef7H2D3Hv4do5
U+5jeMlXwLNksBE33rofNtpsiv2f3G1XEB85dtSb94AxHDuf+64k/v7VskNu
iTGuSpfc5iS2bZ+Ntmk2gmyOeBk38XJtsQOv9I2g3DrdtZq4K6lpjaSNIcYM
9Vw2Er8RTe2+F2QA7xk3p03E6aPGyufVDND6z+mUAPHnzLOS+kwGODz/RkeQ
2FJml5nlD33ocnwb30Jc+I/9/uy4LhT6Pz4WIa57KpxgaK+LEJHG5K3EpvXm
/k+HdbDgJ6ohSryqc8m/H28OI2rHrKUE8Zp4OU6X9kN47XZgw3biTzdsnvrr
HELKF7/ORZt3+KkWPD2I8e5hBUnipn13TXUatfBpp9eLncQny1hd4io1cI4l
2XkX8ZdXTp42ihrYE9bCIk08sJ6dR42ujqV9CuIyxFf55YcOFavB60y6qixx
d3HxwVO5Kkh7LF636P6b2+Xfi6uggrNRQY5401e5FV/1KbQ4HdgkTyyo2XDh
ufZ+PPEXCV30s8QFIb+D+1ASsm1m0X7JCmfMNPditXVIhQJxoNr3+ETVPbAS
n1qrSHznoYjjH0oJ6t2e5xcdapGeEXFAEaYNTHxKxIYjqxWk98lDfW6p/aJ/
m7Zc1NgrB2pKvnDRCWbms0HKsmhbKaq0hzg8+XFg2B4Z8ApMeC5aSO7q1SN7
pPHiyVDxoqcSCgX83XbC9h/XxKJlRW/rVbtJYivdY5My8UW+lEt67ttxqW+d
7qJ/F74JUbwojnrzOa9Fm1457OjtIQr77atSFn2t/y/Taq+taN/t0rToWiOu
/Uu9t8DFdvnoog2d77Dq+QqBljrJvJd4cNor6s2vTRB6t2bjos9+Mu5uYeaH
DFOw9KLdBSRKHdjX4tz0AbVF71vm+KeUmwen7mgYLFpwdhuP5a7lyOuNN1u0
1nM3wwKVJXifpGz7fx4ZeVGWNVf3P/ZGQfQ=
       "]]},
     Annotation[#, "Charting`Private`Tag$106373#1"]& ]}, {{
     GeometricTransformationBox[
      InsetBox["\<\"0.2 GHz\"\>", \
{0.22161883884766978, -0.06152308727470164}], {{{
       0.26749168380305066`, -0.9635601689029122}, {0.9635601689029122, 
       0.26749168380305066`}}, Center}], 
     {GrayLevel[0.5], 
      LineBox[{{0, 0}, {0.19271203378058244`, -0.053498336760610124`}}]}}, {
     GeometricTransformationBox[
      InsetBox["\<\"0.5 GHz\"\>", {0.183302315468412, -0.13892537976884844}], \
{{{0.6040233902993412, -0.7969665889930956}, {0.7969665889930956, 
       0.6040233902993412}}, Center}], 
     {GrayLevel[0.5], 
      LineBox[{{0, 0}, {0.15939331779861915`, -0.12080467805986823`}}]}}, {
     GeometricTransformationBox[
      InsetBox["\<\"1 GHz\"\>", {0.09270799839619608, -0.21048806862473438}], \
{{{0.9151655157597148, -0.40307825389650465`}, {0.40307825389650465`, 
       0.9151655157597148}}, Center}], 
     {GrayLevel[0.5], 
      LineBox[{{0, 0}, {0.08061565077930094, -0.18303310315194296`}}]}}, {
     GeometricTransformationBox[
      InsetBox["\<\"2 GHz\"\>", {-0.0529013284009235, -0.22383353067272482}], \
{{{0.9731892637944557, 0.23000577565618918`}, {-0.23000577565618918`, 
       0.9731892637944557}}, Center}], 
     {GrayLevel[0.5], 
      LineBox[{{0, 0}, {-0.04600115513123783, -0.19463785275889117`}}]}}, {
     GeometricTransformationBox[
      InsetBox["\<\"5 GHz\"\>", \
{-0.19751082795783534, -0.11785360766395894}], {{{0.5124069898432999, 
       0.858742730251458}, {-0.858742730251458, 0.5124069898432999}}, 
       Center}], 
     {GrayLevel[0.5], 
      LineBox[{{0, 
        0}, {-0.1717485460502916, -0.10248139796865996`}}]}}}, {{}, {{}, 
     {RGBColor[0, 0, 1], PointSize[0.012833333333333334`], AbsoluteThickness[
      1.6], PointBox[{{0.08477605324131651, -0.00011581836317714863`}, {
       0.08427607099051454, -0.011559041977422555`}, {
       0.08278696645119116, -0.022982296039265174`}, {
       0.07280495199334679, -0.05517909350262086}, {
       0.042508039916870494`, -0.09651200951618677}, \
{-0.000020891052317532865`, -0.1210189223682857}, {-0.029865933383657235`, \
-0.12636728637889635`}, {-0.08198446733739752, -0.11620019782733004`}, \
{-0.11233689170037647`, -0.09628059101429445}, {-0.1294851243336782, \
-0.07726305033010077}, {-0.1524815493687142, -0.02267038574848135}, \
{-0.15442067099356413`, -0.000019589338874614196`}}]}, {}}, {}, {}, {{}, {}}}},
  AspectRatio->NCache[
    Rational[1, 2], 0.5],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{-0.25, 0},
  DisplayFunction->Identity,
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  LabelStyle->{},
  Method->{"ScalingFunctions" -> None},
  PlotRange->{{-0.25, 0.25}, {0, -0.25}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.9494587073195047`*^9, 3.94945873218014*^9}, {
   3.949459156041046*^9, 3.949459192800832*^9}, {3.9494592487511253`*^9, 
   3.949459258806593*^9}, {3.9494606040113907`*^9, 3.949460711585942*^9}, 
   3.9494607446921387`*^9, {3.9494608289666567`*^9, 3.949460867545129*^9}, 
   3.949461005123389*^9, 3.949464160051366*^9, {3.9495367678770304`*^9, 
   3.9495367866004095`*^9}, {3.949536821209803*^9, 3.949536924565692*^9}, 
   3.9495369632914553`*^9, 3.949537125614833*^9, {3.9495377997117863`*^9, 
   3.9495378364739313`*^9}, {3.9495397895383797`*^9, 3.949539792741542*^9}, 
   3.9495398841531067`*^9, 3.949546860395281*^9, 3.949622975572446*^9, 
   3.949623088952623*^9, {3.949623131328609*^9, 3.9496234018404694`*^9}, 
   3.9496309530246325`*^9, 3.9496315860222692`*^9, {3.9496316423818007`*^9, 
   3.949631651825671*^9}, {3.949631749758913*^9, 3.9496317613473587`*^9}, 
   3.9496317924172835`*^9, {3.949631822670971*^9, 3.9496318734383717`*^9}, 
   3.9496320694716043`*^9, 3.94963210150723*^9, 3.9499932134044075`*^9, {
   3.949993245889144*^9, 3.949993261274382*^9}, {3.949993303961584*^9, 
   3.949993310135541*^9}, {3.949993568944317*^9, 3.949993582104558*^9}, {
   3.9499940440926614`*^9, 3.949994053978371*^9}, {3.949994424339555*^9, 
   3.949994440126934*^9}, 3.9501731654320116`*^9, {3.9501733183488493`*^9, 
   3.950173331881497*^9}, 3.9501733633591833`*^9, 3.958455546258294*^9, 
   3.9584569748709173`*^9, {3.9584572052793894`*^9, 3.9584572249076586`*^9}, {
   3.9584573274892144`*^9, 3.9584573761279593`*^9}, {3.9584574565097494`*^9, 
   3.958457468562539*^9}, {3.9584576033712177`*^9, 3.958457608946665*^9}, {
   3.9584578416034756`*^9, 3.9584578574842873`*^9}, 3.958462056166958*^9, {
   3.9584621796725984`*^9, 3.958462186290132*^9}, {3.958462227837283*^9, 
   3.958462294210013*^9}, {3.9584623642656813`*^9, 3.9584623940192966`*^9}, 
   3.9584678150170097`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"datamineP", "=", 
     RowBox[{
      RowBox[{"Cases", "[", 
       RowBox[{"p1", ",", " ", 
        RowBox[{
         RowBox[{"Point", "[", "pts_", "]"}], "\[RuleDelayed]", "pts"}], ",", 
        " ", "Infinity"}], "]"}], " ", "//", " ", 
      RowBox[{
       RowBox[{"Flatten", "[", 
        RowBox[{"#", ",", "1"}], "]"}], "&"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"datamineL", "=", 
     RowBox[{
      RowBox[{"Cases", "[", 
       RowBox[{"p2", ",", 
        RowBox[{
         RowBox[{"Line", "[", "pts_", "]"}], "\[RuleDelayed]", "pts"}], ",", 
        " ", "Infinity"}], "]"}], " ", "//", " ", 
      RowBox[{
       RowBox[{"Flatten", "[", 
        RowBox[{"#", ",", "1"}], "]"}], "&"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{"\"\<plotData1.csv\>\"", ",", "datamineP", ",", "\"\<CSV\>\""}], 
    "]"}], "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.958466413207039*^9, 3.958466413861623*^9}, {
   3.9584664816875706`*^9, 3.958466505573609*^9}, 3.958466573331356*^9, {
   3.9584666281745424`*^9, 3.958466740071966*^9}, {3.9584668985195417`*^9, 
   3.9584669073493958`*^9}, {3.9584669726048346`*^9, 3.958466975369344*^9}, {
   3.958467046815484*^9, 3.958467084095557*^9}, {3.9584671700275*^9, 
   3.9584672918865223`*^9}, {3.9584673722204905`*^9, 3.958467407903513*^9}, {
   3.9584678320532045`*^9, 3.9584678322534103`*^9}, 3.9584678639596453`*^9}],

Cell[BoxData["\<\"plotData1.csv\"\>"], "Output",
 CellChangeTimes->{
  3.9584670852652583`*^9, {3.958467269994*^9, 3.9584672960678062`*^9}, 
   3.958467410964481*^9, {3.958467829276884*^9, 3.9584678349465675`*^9}, {
   3.9584678665238485`*^9, 3.9584678853639946`*^9}}]
}, Open  ]]
},
WindowSize->{922, 988},
WindowMargins->{{40, Automatic}, {Automatic, 5}},
FrontEndVersion->"11.0 for Microsoft Windows (64-bit) (September 21, 2016)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 3565, 60, 180, "Input",
 InitializationCell->True],
Cell[4148, 84, 2754, 40, 40, "Message"],
Cell[6905, 126, 2959, 42, 59, "Message"]
}, Open  ]],
Cell[9879, 171, 765, 25, 46, "Input",
 Evaluatable->False],
Cell[CellGroupData[{
Cell[10669, 200, 1429, 26, 30, "Input"],
Cell[12101, 228, 3228, 54, 32, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15366, 287, 4490, 101, 187, "Input"],
Cell[19859, 390, 3629, 64, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[23525, 459, 254, 6, 33, "Input"],
Cell[23782, 467, 1750, 53, 33, "Output"]
}, Open  ]],
Cell[25547, 523, 1646, 44, 59, "Input"],
Cell[27196, 569, 6167, 123, 250, "Input"],
Cell[CellGroupData[{
Cell[33388, 696, 1880, 37, 303, "Input"],
Cell[35271, 735, 1605, 32, 45, "Output"]
}, Open  ]],
Cell[36891, 770, 6005, 118, 466, "Input"],
Cell[CellGroupData[{
Cell[42921, 892, 6207, 141, 348, "Input"],
Cell[49131, 1035, 27174, 512, 506, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[76342, 1552, 1104, 29, 107, "Input"],
Cell[77449, 1583, 167, 2, 30, "Output"]
}, Open  ]],
Cell[77631, 1588, 2414, 49, 188, "Input"],
Cell[80048, 1639, 2295, 48, 165, "Input"],
Cell[82346, 1689, 2893, 65, 242, "Input"],
Cell[CellGroupData[{
Cell[85264, 1758, 307, 5, 30, "Input"],
Cell[85574, 1765, 12954, 222, 193, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[98565, 1992, 1520, 36, 107, "Input"],
Cell[100088, 2030, 268, 4, 30, "Output"]
}, Open  ]]
}
]
*)

