(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    152091,       3567]
NotebookOptionsPosition[    141251,       3403]
NotebookOutlinePosition[    141684,       3420]
CellTagsIndexPosition[    141641,       3417]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["WTMAD Fitting Analysis", "Title",
 CellChangeTimes->{{3.797879013542491*^9, 3.7978790202757607`*^9}, {
   3.8015052504625587`*^9, 3.801505252496401*^9}, {3.801512705184127*^9, 
   3.8015127059220877`*^9}, {3.8080725810932217`*^9, 3.80807258204629*^9}, {
   3.808637638029217*^9, 3.8086376426386304`*^9}, {3.808709680167038*^9, 
   3.808709684544276*^9}, {3.8087097351836815`*^9, 3.8087097435221834`*^9}, {
   3.814413717951748*^9, 3.814413718885742*^9}, {3.8147473738509254`*^9, 
   3.8147473768747416`*^9}, 3.8150446257955523`*^9, {3.816019237760411*^9, 
   3.8160192392785177`*^9}, {3.816020446217802*^9, 3.816020450903527*^9}, {
   3.818495939948073*^9, 3.818495941442936*^9}, {3.829636393240244*^9, 
   3.8296363982133584`*^9}, {3.829662167077368*^9, 3.829662168066966*^9}, {
   3.830290616723291*^9, 3.830290621962493*^9}, 3.830334093976343*^9, {
   3.83053142396451*^9, 3.830531424436616*^9}, {3.8320259040356393`*^9, 
   3.8320259064634714`*^9}, 3.832026057084034*^9, {3.832081441488149*^9, 
   3.832081445322814*^9}, 3.832198496278219*^9, {3.8323781961193967`*^9, 
   3.832378196259062*^9}, 3.8326341699756026`*^9, 3.8329780717686853`*^9, {
   3.8333837529399967`*^9, 3.8333837549576917`*^9}, {3.8333839574939947`*^9, 
   3.8333839710519953`*^9}, {3.833460774852479*^9, 3.833460780573769*^9}, {
   3.8335704629830327`*^9, 3.8335704806594667`*^9}, {3.8349506466891456`*^9, 
   3.8349506508790555`*^9}, {3.835047535057335*^9, 3.8350475726522255`*^9}, 
   3.8354017196073704`*^9, {3.8375709542180567`*^9, 3.8375709554214764`*^9}, 
   3.837738812080212*^9, 3.8378375733744793`*^9, {3.8576774091232057`*^9, 
   3.8576774153285923`*^9}, {3.858971769112599*^9, 3.8589717711240635`*^9}, {
   3.8624362841347213`*^9, 3.8624362859687243`*^9}, 3.862697945675531*^9, 
   3.8627615174878263`*^9, 3.8627898394358177`*^9, {3.863894156558298*^9, 
   3.8638941577752056`*^9}, 3.864495398419282*^9, {3.8645970053795815`*^9, 
   3.8645970068616467`*^9}, {3.865115755382537*^9, 3.8651157554156113`*^9}, 
   3.865270778381764*^9, {3.8653781551983757`*^9, 3.8653781574402432`*^9}, {
   3.879945728987928*^9, 3.8799457308838224`*^9}, 3.879948841259983*^9, {
   3.879954952621377*^9, 3.8799549540039387`*^9}, {3.9169945911057253`*^9, 
   3.916994600427992*^9}, {3.9464137497845078`*^9, 3.9464137831407957`*^9}, {
   3.9565816680566916`*^9, 3.9565816694261208`*^9}, {3.965663540759808*^9, 
   3.965663541357286*^9}, {3.966974101570672*^9, 
   3.9669741025348005`*^9}},ExpressionUUID->"e8b4790c-cfdb-4f8c-a2f6-\
82c285868c97"],

Cell["\<\
Determining relative weights of each subset in GMTKN55 for different parts of \
the fit set
Kyle Bryenton 2025-11-18\
\>", "Subtitle",
 CellChangeTimes->{{3.8259515367016363`*^9, 3.8259515481457295`*^9}, {
   3.8296363555235453`*^9, 3.829636363592561*^9}, 3.8296622389748163`*^9, {
   3.829662280794858*^9, 3.829662291249787*^9}, {3.830787820642953*^9, 
   3.830787834013277*^9}, {3.8313045708485894`*^9, 3.831304580009624*^9}, {
   3.8320953423709135`*^9, 3.832095354313024*^9}, 3.83228206786744*^9, {
   3.832378168691453*^9, 3.8323781801034994`*^9}, {3.8324441920909348`*^9, 
   3.832444201710229*^9}, {3.8324487586160955`*^9, 3.8324487591250944`*^9}, {
   3.8324644988930817`*^9, 3.8324644993412466`*^9}, {3.8326212074053016`*^9, 
   3.8326212493946753`*^9}, {3.8326213426871696`*^9, 
   3.8326213436157703`*^9}, {3.8327878865164766`*^9, 
   3.8327878970555696`*^9}, {3.8329857637093697`*^9, 
   3.8329857637743607`*^9}, {3.8330068116486444`*^9, 3.83300681212364*^9}, {
   3.835034974308427*^9, 3.8350349754651814`*^9}, {3.835401713050891*^9, 
   3.8354017168877573`*^9}, {3.8377452905678244`*^9, 3.837745290803586*^9}, 
   3.85767756001378*^9, {3.862761510851385*^9, 3.8627615386924253`*^9}, {
   3.8799549564790955`*^9, 3.879954978202243*^9}, {3.916994603904445*^9, 
   3.916994630403599*^9}, {3.9464137585300026`*^9, 3.946413779941535*^9}, 
   3.946479347959099*^9, {3.9467726285809956`*^9, 3.946772638944997*^9}, {
   3.946842340906331*^9, 3.946842344383188*^9}, {3.9474581585062914`*^9, 
   3.947458160548786*^9}, {3.9556481265778255`*^9, 3.9556481435472155`*^9}, {
   3.9560759693215837`*^9, 3.9560759761951356`*^9}, {3.95658167368425*^9, 
   3.956581718767006*^9}, 3.9566872289770308`*^9, {3.9573531296370845`*^9, 
   3.9573531299721603`*^9}, {3.9656626633708715`*^9, 
   3.9656626648178864`*^9}, {3.9657529525646725`*^9, 3.965752955198642*^9}, 
   3.966028444926873*^9, {3.966974104765448*^9, 3.9669741151207185`*^9}, {
   3.9701503318709393`*^9, 3.9701503326590486`*^9}, {3.970943982386749*^9, 
   3.9709439824431067`*^9}, {3.972232115127159*^9, 3.972232116304426*^9}, 
   3.9723874743880816`*^9, 
   3.972425604548357*^9},ExpressionUUID->"a0191fbe-e215-48a4-8c4f-\
f26ba47d6f9a"],

Cell[CellGroupData[{

Cell["Setup", "Section",
 CellChangeTimes->{{3.8159098859335394`*^9, 3.8159098936639137`*^9}, {
  3.816020473371563*^9, 3.8160204797198906`*^9}, {3.867287106187972*^9, 
  3.8672871084708767`*^9}, {3.9169979350764914`*^9, 3.9169979369826174`*^9}, {
  3.94641371084194*^9, 
  3.9464137468717747`*^9}},ExpressionUUID->"507e86bc-9f42-4233-b3d9-\
06883a36e4ae"],

Cell[CellGroupData[{

Cell["Preamble", "Subsection",
 CellChangeTimes->{{3.81602099620885*^9, 3.816021017466877*^9}, {
  3.817753674156437*^9, 3.8177536774024324`*^9}, {3.931883848284851*^9, 
  3.931883862152503*^9}, {3.931883956719234*^9, 
  3.9318839620598965`*^9}},ExpressionUUID->"d91f3b2c-0440-4cb2-8689-\
d2b2fefc28b1"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.881072780973341*^9, 3.8810727809817657`*^9}},
 CellLabel->
  "In[233]:=",ExpressionUUID->"868b0a4a-0a23-4b4d-8e6d-5e70e42b84a2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.8808316853232927`*^9, 3.880831694714588*^9}},
 CellLabel->
  "In[234]:=",ExpressionUUID->"12acc223-ce39-4b57-946d-7c24fa7087a0"],

Cell[BoxData[
 RowBox[{"<<", "MaTeX`"}]], "Input",
 CellChangeTimes->{{3.8374712078059144`*^9, 3.83747121171614*^9}},
 CellLabel->
  "In[235]:=",ExpressionUUID->"80403d44-4f07-4dd5-a191-c73917630ec8"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MaTeX`\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.8374729714354944`*^9, 3.8374729714424963`*^9}},
 CellLabel->
  "In[236]:=",ExpressionUUID->"58b1b704-9bb1-4e0e-ae8b-3f5f82a2e7e6"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Colours", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "6"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Colours", "[", 
    RowBox[{"[", "1", "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"RGBColor", "[", "\"\<#5A000F\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#7E0018\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#A40122\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#CD022D\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#F60239\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#FF6E3A\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#FFAC3B\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#FFDC3D\>\"", "]"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Colours", "[", 
    RowBox[{"[", "2", "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"RGBColor", "[", "\"\<#004002\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#005A01\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#007702\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#009503\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#00B408\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#00D302\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#00F407\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#AFFF2A\>\"", "]"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Colours", "[", 
    RowBox[{"[", "3", "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"RGBColor", "[", "\"\<#00306F\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#00489E\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#005FCC\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#0079FA\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#009FFA\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#00C2F9\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#00E5F8\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#7CFFFA\>\"", "]"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Colours", "[", 
    RowBox[{"[", "4", "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"RGBColor", "[", "\"\<#450270\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#65019F\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#8400CD\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#A700FC\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#DA00FD\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#FF3CFE\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#FF92FD\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#FFCCFE\>\"", "]"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Colours", "[", 
    RowBox[{"[", "5", "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"RGBColor", "[", "\"\<#560133\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#790149\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#940162\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#C7007C\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#EF0096\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#FF5AAF\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#FF9DC8\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#FFCFE2\>\"", "]"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Colours", "[", 
    RowBox[{"[", "6", "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"RGBColor", "[", "\"\<#003D30\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#005745\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#00735C\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#009175\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#00AF8E\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#00CBA7\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#00EBC1\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#86FFDE\>\"", "]"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Colour", "=", 
   RowBox[{"{", 
    RowBox[{
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0., 0.4745098039215686, 0.9803921568627451], 
           RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         DefaultBaseStyle->"ColorSwatchGraphics",
         Frame->True,
         FrameStyle->RGBColor[0., 0.31633986928104574`, 0.6535947712418301],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        StyleBox[
         RowBox[{"RGBColor", "[", 
           
           RowBox[{"0.`", ",", "0.4745098039215686`", ",", 
             "0.9803921568627451`"}], "]"}], NumberMarks -> False]],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = 
           RGBColor[0., 0.4745098039215686, 0.9803921568627451]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0., 0.4745098039215686, 0.9803921568627451],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[
           0.6431372549019608, 0.00392156862745098, 0.13333333333333333`], 
           RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         DefaultBaseStyle->"ColorSwatchGraphics",
         Frame->True,
         FrameStyle->RGBColor[
          0.42875816993464055`, 0.0026143790849673205`, 0.08888888888888889],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        StyleBox[
         RowBox[{"RGBColor", "[", 
           
           RowBox[{"0.6431372549019608`", ",", "0.00392156862745098`", ",", 
             "0.13333333333333333`"}], "]"}], NumberMarks -> False]],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = 
           RGBColor[
            0.6431372549019608, 0.00392156862745098, 0.13333333333333333`]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0.6431372549019608, 0.00392156862745098, 0.13333333333333333`],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0., 0.8274509803921568, 0.00784313725490196], 
           RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         DefaultBaseStyle->"ColorSwatchGraphics",
         Frame->True,
         FrameStyle->RGBColor[0., 0.5516339869281046, 0.005228758169934641],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        StyleBox[
         RowBox[{"RGBColor", "[", 
           
           RowBox[{"0.`", ",", "0.8274509803921568`", ",", 
             "0.00784313725490196`"}], "]"}], NumberMarks -> False]],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = 
           RGBColor[0., 0.8274509803921568, 0.00784313725490196]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0., 0.8274509803921568, 0.00784313725490196],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[
           0.27058823529411763`, 0.00784313725490196, 0.4392156862745098], 
           RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         DefaultBaseStyle->"ColorSwatchGraphics",
         Frame->True,
         FrameStyle->RGBColor[
          0.1803921568627451, 0.005228758169934641, 0.2928104575163399],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        StyleBox[
         RowBox[{"RGBColor", "[", 
           
           RowBox[{"0.27058823529411763`", ",", "0.00784313725490196`", ",", 
             "0.4392156862745098`"}], "]"}], NumberMarks -> False]],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = 
           RGBColor[
            0.27058823529411763`, 0.00784313725490196, 0.4392156862745098]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0.27058823529411763`, 0.00784313725490196, 0.4392156862745098],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0., 0.45098039215686275`, 0.3607843137254902], 
           RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         DefaultBaseStyle->"ColorSwatchGraphics",
         Frame->True,
         FrameStyle->RGBColor[0., 0.30065359477124187`, 0.24052287581699347`],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        StyleBox[
         RowBox[{"RGBColor", "[", 
           
           RowBox[{"0.`", ",", "0.45098039215686275`", ",", 
             "0.3607843137254902`"}], "]"}], NumberMarks -> False]],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = 
           RGBColor[0., 0.45098039215686275`, 0.3607843137254902]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0., 0.45098039215686275`, 0.3607843137254902],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1., 0.35294117647058826`, 0.6862745098039216], 
           RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         DefaultBaseStyle->"ColorSwatchGraphics",
         Frame->True,
         FrameStyle->RGBColor[
          0.6666666666666667, 0.23529411764705885`, 0.4575163398692811],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        StyleBox[
         RowBox[{"RGBColor", "[", 
           
           RowBox[{"1.`", ",", "0.35294117647058826`", ",", 
             "0.6862745098039216`"}], "]"}], NumberMarks -> False]],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = 
           RGBColor[1., 0.35294117647058826`, 0.6862745098039216]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1., 0.35294117647058826`, 0.6862745098039216],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1., 0.8627450980392157, 0.23921568627450981`], 
           RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         DefaultBaseStyle->"ColorSwatchGraphics",
         Frame->True,
         FrameStyle->RGBColor[
          0.6666666666666667, 0.5751633986928105, 0.15947712418300655`],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        StyleBox[
         RowBox[{"RGBColor", "[", 
           
           RowBox[{"1.`", ",", "0.8627450980392157`", ",", 
             "0.23921568627450981`"}], "]"}], NumberMarks -> False]],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = 
           RGBColor[1., 0.8627450980392157, 0.23921568627450981`]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1., 0.8627450980392157, 0.23921568627450981`],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0., 0.25098039215686274`, 0.00784313725490196], 
           RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         DefaultBaseStyle->"ColorSwatchGraphics",
         Frame->True,
         FrameStyle->RGBColor[0., 0.1673202614379085, 0.005228758169934641],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        StyleBox[
         RowBox[{"RGBColor", "[", 
           
           RowBox[{"0.`", ",", "0.25098039215686274`", ",", 
             "0.00784313725490196`"}], "]"}], NumberMarks -> False]],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = 
           RGBColor[0., 0.25098039215686274`, 0.00784313725490196]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0., 0.25098039215686274`, 0.00784313725490196],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0., 0.7607843137254902, 0.9764705882352941], 
           RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         DefaultBaseStyle->"ColorSwatchGraphics",
         Frame->True,
         FrameStyle->RGBColor[0., 0.5071895424836601, 0.6509803921568628],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        StyleBox[
         RowBox[{"RGBColor", "[", 
           
           RowBox[{"0.`", ",", "0.7607843137254902`", ",", 
             "0.9764705882352941`"}], "]"}], NumberMarks -> False]],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = 
           RGBColor[0., 0.7607843137254902, 0.9764705882352941]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0., 0.7607843137254902, 0.9764705882352941],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1., 0.8, 0.996078431372549], 
           RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         DefaultBaseStyle->"ColorSwatchGraphics",
         Frame->True,
         FrameStyle->RGBColor[
          0.6666666666666667, 0.5333333333333334, 0.6640522875816994],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        StyleBox[
         RowBox[{"RGBColor", "[", 
           RowBox[{"1.`", ",", "0.8`", ",", "0.996078431372549`"}], "]"}], 
         NumberMarks -> False]],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = 
           RGBColor[1., 0.8, 0.996078431372549]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1., 0.8, 0.996078431372549],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0.33725490196078434`, 0.00392156862745098, 0.2], 
           RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         DefaultBaseStyle->"ColorSwatchGraphics",
         Frame->True,
         FrameStyle->RGBColor[
          0.22483660130718958`, 0.0026143790849673205`, 0.13333333333333336`],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        StyleBox[
         RowBox[{"RGBColor", "[", 
           
           RowBox[{"0.33725490196078434`", ",", "0.00392156862745098`", ",", 
             "0.2`"}], "]"}], NumberMarks -> False]],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = 
           RGBColor[0.33725490196078434`, 0.00392156862745098, 0.2]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0.33725490196078434`, 0.00392156862745098, 0.2],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0.5254901960784314, 1., 0.8705882352941177], 
           RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         DefaultBaseStyle->"ColorSwatchGraphics",
         Frame->True,
         FrameStyle->RGBColor[
          0.35032679738562095`, 0.6666666666666667, 0.5803921568627451],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        StyleBox[
         RowBox[{"RGBColor", "[", 
           
           RowBox[{"0.5254901960784314`", ",", "1.`", ",", 
             "0.8705882352941177`"}], "]"}], NumberMarks -> False]],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = 
           RGBColor[0.5254901960784314, 1., 0.8705882352941177]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0.5254901960784314, 1., 0.8705882352941177],
      Editable->False,
      Selectable->False]}], "}"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.8599246348040857`*^9, 3.859924635591572*^9}, {
  3.8599246761099963`*^9, 3.85992468327722*^9}, {3.881709147033801*^9, 
  3.8817091501026683`*^9}, {3.9169945720697613`*^9, 3.916994574225131*^9}},
 CellLabel->
  "In[237]:=",ExpressionUUID->"c473ffd2-3bc3-43c0-9ec9-4c3420a42063"],

Cell[BoxData[
 RowBox[{
  RowBox[{"tickFunc", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Charting`ScaledTicks", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Identity", ",", "Identity"}], "}"}], ",", 
       RowBox[{"TicksLength", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{".02", ",", ".01"}], "}"}]}]}], "]"}], "[", "##", "]"}], 
    "&"}]}], ";"}]], "Input",
 CellLabel->
  "In[245]:=",ExpressionUUID->"6e1294b1-2f04-4d48-b2d4-8223398a74bf"],

Cell[BoxData[
 RowBox[{
  RowBox[{"rescale", "=", "2.0"}], ";"}]], "Input",
 CellLabel->
  "In[246]:=",ExpressionUUID->"7daf2119-60dd-464d-8c97-410f7c3fe130"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ExportPDF", "=", "True"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ExportPNG", "=", "True"}], ";"}]}], "Input",
 CellChangeTimes->{{3.9560789513094893`*^9, 3.9560789601423674`*^9}},
 CellLabel->
  "In[247]:=",ExpressionUUID->"83646cc2-e906-45ba-a0be-430f1b0c4ca2"],

Cell["\<\
Set the value to use for Mean[DeltaEBar]
False = Let it calculate Mean[DeltaEBar]
True = Use the fixed value entered on the following line\
\>", "Text",
 CellChangeTimes->{{3.9660259680032883`*^9, 3.966026005768263*^9}, {
  3.966026065395343*^9, 
  3.9660261408229403`*^9}},ExpressionUUID->"249fb4f0-36fe-464f-b3c7-\
f013db6da048"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"DEBfixed", "=", "True"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DEBfixedval", "=", "56.84"}], ";"}]}], "Input",
 CellChangeTimes->{{3.96602600814555*^9, 3.9660260491343393`*^9}, {
  3.966026087585389*^9, 3.966026153130679*^9}},
 CellLabel->
  "In[249]:=",ExpressionUUID->"5d50b979-e5fe-4a60-90a6-ae3230ea3697"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Data Import", "Section",
 CellChangeTimes->{{3.8159098859335394`*^9, 3.8159098936639137`*^9}, {
  3.816020473371563*^9, 3.8160204797198906`*^9}, {3.867287106187972*^9, 
  3.8672871084708767`*^9}, {3.9169979350764914`*^9, 3.9169979369826174`*^9}, {
  3.94641371084194*^9, 3.946413712127342*^9}, {3.955648158000458*^9, 
  3.9556481583871193`*^9}},ExpressionUUID->"c185520c-8497-43ef-aaa0-\
0a1ab0ee7af6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"inFiles", "=", 
    RowBox[{"FileNames", "[", 
     RowBox[{"{", "\"\<ProcessGMTKN55_DAT/ALL_115/*.dat\>\"", "}"}], "]"}]}], 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"inFiles", "=", 
    RowBox[{"FileNames", "[", 
     RowBox[{"{", "\"\<ProcessGMTKN55_DAT/D3_10/*.dat\>\"", "}"}], "]"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"inFiles", "=", 
     RowBox[{"{", 
      RowBox[{"inFiles", "[", 
       RowBox[{"[", "3", "]"}], "]"}], "}"}]}], "*)"}]}]}]], "Input",
 CellChangeTimes->{{3.955648162362415*^9, 3.9556481758935704`*^9}, {
   3.9657488552668695`*^9, 3.9657488787582955`*^9}, {3.965748925806166*^9, 
   3.96574892683398*^9}, {3.965749481827896*^9, 3.965749482546893*^9}, {
   3.9657497448016953`*^9, 3.9657497453852763`*^9}, {3.965750043930236*^9, 
   3.965750051602558*^9}, {3.9657529932203693`*^9, 3.9657529976124525`*^9}, {
   3.9660262362912416`*^9, 3.966026242106614*^9}, {3.9660284531788683`*^9, 
   3.966028458236166*^9}, {3.966283480622823*^9, 3.9662835093558674`*^9}, 
   3.9662848654954395`*^9, {3.9662861155930843`*^9, 3.9662861156266413`*^9}, {
   3.9663455107109365`*^9, 3.9663455215193872`*^9}, {3.9663456410064316`*^9, 
   3.9663456411064315`*^9}, {3.966353726356678*^9, 3.9663537541312885`*^9}, {
   3.9663537891113577`*^9, 3.966353794774789*^9}, {3.9663538284678664`*^9, 
   3.9663539411116314`*^9}, {3.9663551688797975`*^9, 
   3.9663551743580294`*^9}, {3.9663552062000923`*^9, 
   3.9663552075670943`*^9}, {3.966355460902878*^9, 3.9663555157576756`*^9}, {
   3.966355553875149*^9, 3.966355630064127*^9}, {3.9663599006838408`*^9, 
   3.966359902796789*^9}, {3.9663599378612394`*^9, 3.966359974174876*^9}, 
   3.96636585472791*^9, 3.966366268464685*^9, {3.9663663000406384`*^9, 
   3.9663663352231874`*^9}, 3.966366382296356*^9, {3.9663664274464073`*^9, 
   3.966366446618437*^9}, {3.9663665135970063`*^9, 3.9663665616814675`*^9}, {
   3.966974171237556*^9, 3.9669742309971743`*^9}, {3.9669754443589606`*^9, 
   3.966975482463748*^9}, {3.967206291247212*^9, 3.96720629331219*^9}, {
   3.9701503212939024`*^9, 3.9701503234350224`*^9}, {3.970151728289773*^9, 
   3.970151729974901*^9}, {3.970152754617752*^9, 3.970152756854456*^9}, {
   3.9701533772527895`*^9, 3.9701533787520537`*^9}, {3.9701557776787186`*^9, 
   3.970155782950649*^9}, {3.9701598043203473`*^9, 3.970159805957636*^9}, {
   3.9701602887418976`*^9, 3.970160292164002*^9}, {3.970943991794886*^9, 
   3.970943994101435*^9}, {3.970945710395856*^9, 3.970945712741489*^9}, {
   3.9709541518229647`*^9, 3.970954153467434*^9}, {3.9709989137028184`*^9, 
   3.9709989253863535`*^9}, {3.970999059307235*^9, 3.9709990617292337`*^9}, {
   3.9709993355181923`*^9, 3.9709993355905504`*^9}, {3.9710005567308073`*^9, 
   3.971000567256154*^9}, {3.9712592820690813`*^9, 3.97125928881884*^9}, {
   3.9722321231265726`*^9, 3.972232135527383*^9}, {3.9722330753983903`*^9, 
   3.972233097171316*^9}, {3.9722334463392453`*^9, 3.972233461749731*^9}, {
   3.9722382850405693`*^9, 3.972238300286025*^9}, {3.9724012639845495`*^9, 
   3.9724012817401905`*^9}, 3.9724256082471943`*^9, 
   3.972425655151818*^9},ExpressionUUID->"ed90bb2e-a068-4f77-8983-\
114504f99343"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"inData", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"Length", "[", "inFiles", "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Data", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"Length", "[", "inFiles", "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"For", "[", 
  RowBox[{
   RowBox[{"i", "=", "1"}], ",", 
   RowBox[{"i", "\[LessEqual]", 
    RowBox[{"Length", "[", "inFiles", "]"}]}], ",", 
   RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"inData", "[", 
      RowBox[{"[", "i", "]"}], "]"}], "=", 
     RowBox[{"Import", "[", 
      RowBox[{
       RowBox[{"inFiles", "[", 
        RowBox[{"[", "i", "]"}], "]"}], ",", "\"\<Table\>\"", ",", 
       RowBox[{"\"\<FieldSeparators\>\"", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\< \>\"", ",", "\"\<\\n\>\""}], "}"}]}]}], "]"}]}], 
    ";"}]}], "\[IndentingNewLine]", "]"}]}], "Input",
 CellChangeTimes->{{3.8088987603844748`*^9, 3.808898760389476*^9}, {
   3.8088987974616737`*^9, 3.808898797699171*^9}, {3.808898955298374*^9, 
   3.8088989745769978`*^9}, {3.8088990204361343`*^9, 
   3.8088990475452023`*^9}, {3.8088993432862167`*^9, 3.8088993488074837`*^9}, 
   3.8089132373770795`*^9, {3.8089133938577895`*^9, 3.8089133946065784`*^9}, {
   3.808914348105073*^9, 3.808914374119644*^9}, {3.8143883775545034`*^9, 
   3.8143883776975117`*^9}, {3.817745247522892*^9, 3.8177452499678764`*^9}, {
   3.818307132829943*^9, 3.8183071427258015`*^9}, {3.832184000310708*^9, 
   3.832184000476708*^9}, {3.832184785705651*^9, 3.8321848128556232`*^9}, {
   3.877375316157969*^9, 3.8773753720445166`*^9}, {3.8773754257529335`*^9, 
   3.877375425903227*^9}, {3.8773761048033004`*^9, 3.8773761243783264`*^9}, {
   3.880490835089597*^9, 3.8804908354891977`*^9}, {3.880491001144314*^9, 
   3.880491058196918*^9}, 3.880585036623171*^9, {3.8808316743775115`*^9, 
   3.8808316744975185`*^9}, {3.88083173553826*^9, 3.8808317548350506`*^9}, {
   3.880831861639245*^9, 3.8808318639946413`*^9}, {3.889702231245826*^9, 
   3.88970223777074*^9}, {3.8897024145049667`*^9, 3.8897025536689067`*^9}, {
   3.889702615469081*^9, 3.8897026188224983`*^9}, {3.889702865915352*^9, 
   3.8897028699672756`*^9}, {3.889702941728506*^9, 3.8897029444915085`*^9}, {
   3.88970298826377*^9, 3.889702999934156*^9}, {3.889703079839328*^9, 
   3.8897030824790154`*^9}, {3.8897031305551376`*^9, 
   3.8897031316048975`*^9}, {3.8897168509214096`*^9, 3.889716863026906*^9}, {
   3.889718077479236*^9, 3.889718102022805*^9}, {3.8939562645703554`*^9, 
   3.8939562652538166`*^9}, {3.9496753559836407`*^9, 
   3.9496754121934814`*^9}, {3.949675454212244*^9, 3.9496754568630953`*^9}, {
   3.9496773381143293`*^9, 3.9496773387519813`*^9}, 3.9496773867862864`*^9, {
   3.949677437142476*^9, 3.949677488351195*^9}, {3.949677540051149*^9, 
   3.949677548830299*^9}, {3.949933271121267*^9, 3.9499332712770205`*^9}, {
   3.951004015176592*^9, 3.9510040162198267`*^9}, {3.9523529248334885`*^9, 
   3.9523529249575167`*^9}, {3.952353188870604*^9, 3.9523531919893055`*^9}, 
   3.9527199394409933`*^9, {3.9657495327359934`*^9, 3.9657495435160108`*^9}, 
   3.9657497403493233`*^9},
 CellLabel->
  "In[252]:=",ExpressionUUID->"94823ce5-4b35-4f02-9bc2-98c3b8acc3a2"],

Cell["\<\
In the data:
The first MAD is one after the first data entry that starts a line with \
\[OpenCurlyDoubleQuote]Subset\[CloseCurlyDoubleQuote]
The last MAD row is 54 rows after that (for a benchmark of 55, tweak if \
necessary)\
\>", "Text",
 CellChangeTimes->{{3.9660252512862234`*^9, 3.966025355089263*^9}, {
  3.9660254555894165`*^9, 3.9660254569784174`*^9}, {3.9660259624472933`*^9, 
  3.966025962931363*^9}},ExpressionUUID->"ec72a229-5317-4662-9e91-\
dc243846cf0f"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"NumBench", "=", "55"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"MADRowi", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"FirstPosition", "[", 
      RowBox[{"inData", ",", "\"\<Subset\>\""}], "]"}], "[", 
     RowBox[{"[", "2", "]"}], "]"}], "+", "1"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"MADRowf", "=", 
   RowBox[{"MADRowi", "+", "NumBench", "-", "1"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.9660253565745077`*^9, 3.9660254127843504`*^9}, {
  3.9660258160189686`*^9, 3.966025839024019*^9}},
 CellLabel->
  "In[255]:=",ExpressionUUID->"6ab770a1-01ea-446b-9614-2d595ec31990"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Data Processing", "Section",
 CellChangeTimes->{{3.8159098859335394`*^9, 3.8159098936639137`*^9}, {
  3.816020473371563*^9, 3.8160204797198906`*^9}, {3.867287106187972*^9, 
  3.8672871084708767`*^9}, {3.9169979350764914`*^9, 3.9169979369826174`*^9}, {
  3.94641371084194*^9, 
  3.946413720636649*^9}},ExpressionUUID->"7f4f10e9-0978-4bf8-adf7-\
6fc4e0f89d6e"],

Cell[BoxData[
 RowBox[{"SystLabels", "=", 
  RowBox[{"inData", "[", 
   RowBox[{"[", 
    RowBox[{"1", ",", 
     RowBox[{"MADRowi", ";;", "MADRowf"}], ",", "1"}], "]"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.9556483296519117`*^9, 3.955648371515128*^9}, {
   3.9556484067417517`*^9, 3.9556484221422234`*^9}, 3.9556490102617936`*^9, {
   3.956076015954112*^9, 3.9560760161631594`*^9}, 3.9565819422816477`*^9, 
   3.9656628325006433`*^9, {3.965749496265916*^9, 3.9657494963989162`*^9}, {
   3.965749760216506*^9, 3.9657497602720904`*^9}, {3.9660258295839863`*^9, 
   3.9660258332930098`*^9}},
 CellLabel->
  "In[258]:=",ExpressionUUID->"4b84ff37-d71d-4a27-83e1-d8c51373881d"],

Cell[BoxData[
 RowBox[{"FuncLabels", "=", 
  RowBox[{"inData", "[", 
   RowBox[{"[", 
    RowBox[{"All", ",", 
     RowBox[{"MADRowi", "-", "1"}], ",", "5"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.955648431118119*^9, 3.9556484716243095`*^9}, 
   3.9556490067641335`*^9, {3.965662841622142*^9, 3.9656628416908064`*^9}, {
   3.9657495575734243`*^9, 3.9657495577080336`*^9}, {3.9660258470428934`*^9, 
   3.966025849591367*^9}, {3.9662862290238233`*^9, 3.9662862368618355`*^9}},
 CellLabel->
  "In[259]:=",ExpressionUUID->"29c7daa0-5949-4413-89fc-23b6e623598a"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"FuncLabels", "=", 
    RowBox[{"StringReplace", "[", 
     RowBox[{
      RowBox[{"ToString", "/@", "FuncLabels"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<B86bPBE-25\>\"", "\[Rule]", "\"\<B86bPBE0\>\""}], "}"}]}],
      "]"}]}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"FuncLabels", "=", 
     RowBox[{"StringReplace", "[", 
      RowBox[{
       RowBox[{"ToString", "/@", "FuncLabels"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
         "\"\<LC-whPBE\>\"", "\[Rule]", "\"\<LC\[Hyphen]\[Omega]PBEh\>\""}], 
         ",", 
         RowBox[{
         "\"\<LC-wPBE\>\"", "\[Rule]", "\"\<LC\[Hyphen]\[Omega]PBE\>\""}]}], 
        "}"}]}], "]"}]}], ";"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"FuncLabels", "=", 
     RowBox[{"StringReplace", "[", 
      RowBox[{
       RowBox[{"ToString", "/@", "FuncLabels"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\"\<-\>\"", "\[Rule]", "\"\<\[Hyphen]\>\""}], ",", 
         RowBox[{"\"\<\[Dash]\>\"", "\[Rule]", "\"\<\[Hyphen]\>\""}], ",", 
         RowBox[{"\"\<\[LongDash]\>\"", "\[Rule]", "\"\<\[Hyphen]\>\""}]}], 
        "}"}]}], "]"}]}], ";"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"SystLabels", "=", 
     RowBox[{"StringReplace", "[", 
      RowBox[{
       RowBox[{"ToString", "/@", "SystLabels"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\"\<-\>\"", "\[Rule]", "\"\<\[Hyphen]\>\""}], ",", 
         RowBox[{"\"\<\[Dash]\>\"", "\[Rule]", "\"\<\[Hyphen]\>\""}], ",", 
         RowBox[{"\"\<\[LongDash]\>\"", "\[Rule]", "\"\<\[Hyphen]\>\""}]}], 
        "}"}]}], "]"}]}], ";"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"SystLabels", "[", 
      RowBox[{"[", 
       RowBox[{"-", "2"}], "]"}], "]"}], "=", 
     RowBox[{"Style", "[", 
      RowBox[{"\"\<WTMAD\[Hyphen]1\>\"", ",", 
       RowBox[{"FontFamily", "\[Rule]", "\"\<Calibri\>\""}], ",", "Bold"}], 
      "]"}]}], ";"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"SystLabels", "[", 
      RowBox[{"[", 
       RowBox[{"-", "1"}], "]"}], "]"}], "=", 
     RowBox[{"Style", "[", 
      RowBox[{"\"\<WTMAD\[Hyphen]2\>\"", ",", 
       RowBox[{"FontFamily", "\[Rule]", "\"\<Calibri\>\""}], ",", "Bold"}], 
      "]"}]}], ";"}], "*)"}]}]}], "Input",
 CellChangeTimes->{{3.9556485783758965`*^9, 3.9556486956121125`*^9}, {
  3.955648801693203*^9, 3.955648879889615*^9}, {3.955648924685316*^9, 
  3.955649008063907*^9}, {3.955651432455698*^9, 3.955651441511552*^9}, {
  3.9560761572450104`*^9, 3.956076161194902*^9}, {3.956582763902437*^9, 
  3.9565827670430584`*^9}, {3.965662877913316*^9, 3.965662899973474*^9}, {
  3.9657489690237284`*^9, 3.9657490637883863`*^9}, {3.966345651507435*^9, 
  3.9663456683219213`*^9}, {3.9663548167930593`*^9, 3.9663548232013245`*^9}},
 CellLabel->
  "In[260]:=",ExpressionUUID->"dedf4a36-1d7c-43f2-8485-101296f0c64f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Data", "=", 
   RowBox[{"inData", "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", 
      RowBox[{"MADRowi", ";;", "MADRowf"}], ",", 
      RowBox[{"-", "1"}]}], "]"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.955648482441185*^9, 3.9556485161649666`*^9}, {
   3.955650356862707*^9, 3.955650364977623*^9}, {3.9560760020689774`*^9, 
   3.956076002181002*^9}, 3.956582153529072*^9, {3.9656629342301617`*^9, 
   3.9656629553778687`*^9}, {3.965749563029042*^9, 3.965749563535043*^9}, 
   3.9660258676760817`*^9, {3.9662943706070023`*^9, 3.966294372035325*^9}},
 CellLabel->
  "In[261]:=",ExpressionUUID->"ffcb47ad-7076-4ba7-a4b8-d6e3d3f01c70"],

Cell[BoxData[
 RowBox[{"DClabel", "=", 
  RowBox[{"StringReplace", "[", 
   RowBox[{
    RowBox[{"FileBaseName", "/@", "inFiles"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\"\<bj\>\"", "\[Rule]", "\"\<(BJ)\>\""}], ",", 
      RowBox[{"\"\<z\>\"", "\[Rule]", "\"\<(Z)\>\""}], ",", 
      RowBox[{"\"\<ProcessGMTKN55_\>\"", "\[Rule]", "\"\<\>\""}]}], "}"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.955649062290451*^9, 3.9556490693484697`*^9}, {
  3.955649106230855*^9, 3.955649122085611*^9}, {3.9556491875768585`*^9, 
  3.9556492409545608`*^9}, {3.9657496136820536`*^9, 3.965749616946109*^9}, {
  3.9657497883524694`*^9, 3.965749788541542*^9}, {3.9662943833347845`*^9, 
  3.966294394214982*^9}},
 CellLabel->
  "In[262]:=",ExpressionUUID->"06f67035-d852-4af8-917b-f4d5c279cee6"],

Cell[BoxData[
 RowBox[{"NSysts", "=", 
  RowBox[{"inData", "[", 
   RowBox[{"[", 
    RowBox[{"1", ",", 
     RowBox[{"MADRowi", ";;", "MADRowf"}], ",", "2"}], "]"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.9565823374180436`*^9, 3.956582365099651*^9}, 
   3.9656629706048784`*^9, {3.9657495647857285`*^9, 3.9657495649335704`*^9}, 
   3.9660258712380576`*^9},
 CellLabel->
  "In[263]:=",ExpressionUUID->"facbc342-edff-4602-a751-76a185644a2a"],

Cell[BoxData[
 RowBox[{"DeltEBi", "=", 
  RowBox[{"inData", "[", 
   RowBox[{"[", 
    RowBox[{"1", ",", 
     RowBox[{"MADRowi", ";;", "MADRowf"}], ",", "3"}], "]"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.9565823717894907`*^9, 3.9565823821017013`*^9}, 
   3.9656629758908873`*^9, {3.965749566363551*^9, 3.965749566515036*^9}, 
   3.966025873451207*^9},
 CellLabel->
  "In[264]:=",ExpressionUUID->"38b32406-490e-4614-bdbc-89bc04dabd99"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"GMTKN55info", "=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
    "\"\<AL2X6        6     35.88     1.0    0    3.27 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<ALK8         8     62.60     1.0    0    1.30 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<ALKBDE10    10    100.69     0.1    0    1.06 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<BH76RC      30     21.39     1.0    0    2.55 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<DC13        13     54.98     1.0    0    0.78 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<DIPCS10     10    654.26     0.1    0    1.65 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<FH51        51     31.01     1.0    0    2.39 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<G21EA       25     33.62     1.0    0    2.15 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<G21IP       36    257.61     0.1    0    1.63 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<G2RC        25     51.26     1.0    0    1.12 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<HEAVYSB11   11     58.02     1.0    0    2.73 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<NBPRC       12     27.71     1.0    0    2.32 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<PA26        26    189.05     0.1    0    1.98 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<RC21        21     35.70     1.0    0    1.45 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<SIE4x4      16     33.72     1.0    0    0.469\>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<TAUT15      15      3.05    10.0    0    5.80 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<W4-11      140    306.91     0.1    0    1.07 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<YBDE18      18     49.28     1.0    0    2.55 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<BSR36       36     16.20     1.0    1    2.03 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<C60ISO       9     98.25     0.1    1    1.19 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<CDIE20      20      4.06    10.0    1    5.75 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<DARC        14     32.47     1.0    1    1.44 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<ISO34       34     14.57     1.0    1    4.49 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<ISOL24      24     21.92     1.0    1    1.99 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<MB16-43     43    468.39     0.1    1    0.329\>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<PArel       20      4.63    10.0    1    5.51 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<RSE43       43      7.60     1.0    1    5.27 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<BH76        76     18.61     1.0    2    1.53 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<BHDIV10     10     45.33     1.0    2    1.66 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<BHPERI      26     20.87     1.0    2    2.29 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<BHROT27     27      6.27    10.0    2   11.0  \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<INV24       24     31.85     1.0    2    4.41 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<PX13        13     33.36     1.0    2    1.18 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<WCPT18      18     34.99     1.0    2    1.77 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<ADIM6        6      3.36    10.0    3   36.8  \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<AHB21       21     22.49     1.0    3    6.24 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<CARBHB12    12      6.04    10.0    3    5.50 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<CHB6         6     26.79     1.0    3    4.14 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<HAL59       59      4.59    10.0    3    9.63 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<HEAVY28     28      1.24    10.0    3   14.0  \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<IL16        16    109.04     0.1    3   11.5  \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<PNICO23     23      4.27    10.0    3    7.86 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<RG18        18      0.58    10.0    3   29.9  \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<S22         22      7.30    10.0    3   13.5  \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<S66         66      5.47    10.0    3   18.4  \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<WATER27     27     81.14     0.1    3    1.43 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<ACONF       15      1.83    10.0    4   61.2  \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<Amino20x4   80      2.44    10.0    4   22.6  \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<BUT14DIOL   64      2.80    10.0    4   30.0  \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<ICONF       17      3.27    10.0    4   20.0  \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<IDISP        6     14.22     1.0    4    2.50 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<MCONF       51      4.97    10.0    4   21.2  \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<PCONF21     18      1.62    10.0    4    8.66 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<SCONF       17      4.60    10.0    4   19.1  \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<UPU23       23      5.72    10.0    4   10.1  \>\""}], 
    "\[IndentingNewLine]", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"GMTKN55info", "=", 
   RowBox[{"StringSplit", "[", "GMTKN55info", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"GMTKN55info", "=", 
   RowBox[{"GMTKN55info", "/.", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "name_", ",", "a_", ",", "b_", ",", "c_", ",", "d_", ",", "e_"}], "}"}],
      "\[RuleDelayed]", 
     RowBox[{"{", 
      RowBox[{"name", ",", 
       RowBox[{"ToExpression", "[", "a", "]"}], ",", 
       RowBox[{"ToExpression", "[", "b", "]"}], ",", 
       RowBox[{"ToExpression", "[", "c", "]"}], ",", 
       RowBox[{"ToExpression", "[", "d", "]"}], ",", 
       RowBox[{"ToExpression", "[", "e", "]"}]}], "}"}]}]}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.9565873189531374`*^9, 3.9565873266898837`*^9}, {
   3.956587372565295*^9, 3.9565873776934524`*^9}, {3.9565874411591663`*^9, 
   3.9565874729943533`*^9}, {3.956587522226666*^9, 3.956587631645376*^9}, 
   3.956587663410554*^9, {3.9565879003272886`*^9, 3.9565879039691105`*^9}, {
   3.9565911144826508`*^9, 3.9565911371576414`*^9}, {3.956687863916028*^9, 
   3.956687904945864*^9}, 3.956688011693816*^9, 3.9566883069193892`*^9, {
   3.9567898267715673`*^9, 3.956789843776102*^9}, 3.956789929383156*^9, {
   3.9567899665067644`*^9, 3.9567900103933134`*^9}, {3.956790237022877*^9, 
   3.956790238922575*^9}, {3.9567904081272464`*^9, 3.956790409806177*^9}, {
   3.9656630999111185`*^9, 3.965663146123706*^9}, {3.9657528343601933`*^9, 
   3.96575287133625*^9}, {3.965752919476329*^9, 3.9657529438783674`*^9}, {
   3.9663455468975077`*^9, 3.966345556652259*^9}, {3.967232109463114*^9, 
   3.967232143047979*^9}, 3.9710325728510447`*^9, {3.972237233768402*^9, 
   3.9722372676730876`*^9}},
 CellLabel->
  "In[265]:=",ExpressionUUID->"9645ac04-2536-413a-8090-f8824ee42bcb"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Get MAEs", "Section",
 CellChangeTimes->{{3.8159098859335394`*^9, 3.8159098936639137`*^9}, {
   3.816020473371563*^9, 3.8160204797198906`*^9}, {3.867287106187972*^9, 
   3.8672871084708767`*^9}, {3.9169979350764914`*^9, 
   3.9169979369826174`*^9}, {3.94641371084194*^9, 3.9464137299645586`*^9}, 
   3.9556493624167347`*^9, {3.9556542149812284`*^9, 3.9556542185457573`*^9}, {
   3.9565872139918404`*^9, 3.9565872150360765`*^9}, {3.956587245363923*^9, 
   3.9565872461460996`*^9}, {3.9672063081302004`*^9, 3.967206310163213*^9}, {
   3.9672079534876547`*^9, 
   3.9672079536600285`*^9}},ExpressionUUID->"4da85bcb-f3a9-43a4-b946-\
5d7a514eed39"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MAEs", "=", "Data"}], ";"}]], "Input",
 CellChangeTimes->{{3.966294963077761*^9, 3.9662949635646753`*^9}, 
   3.9669742635469985`*^9},
 CellLabel->
  "In[268]:=",ExpressionUUID->"4f3f0d68-fed8-479e-9bfa-31712ef16600"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Get WTMAD-1", "Section",
 CellChangeTimes->{{3.8159098859335394`*^9, 3.8159098936639137`*^9}, {
   3.816020473371563*^9, 3.8160204797198906`*^9}, {3.867287106187972*^9, 
   3.8672871084708767`*^9}, {3.9169979350764914`*^9, 
   3.9169979369826174`*^9}, {3.94641371084194*^9, 3.9464137299645586`*^9}, 
   3.9556493624167347`*^9, {3.9556542149812284`*^9, 3.9556542185457573`*^9}, {
   3.9565872139918404`*^9, 3.9565872150360765`*^9}, {3.956587249155779*^9, 
   3.9565872620896993`*^9}},ExpressionUUID->"7871f13e-07da-4b6b-bf8e-\
7a783f37bea5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"WTMAD1Weights", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      FractionBox["1", 
       RowBox[{"Length", "[", "NSysts", "]"}]], "*", 
      RowBox[{"GMTKN55info", "[", 
       RowBox[{"[", 
        RowBox[{"i", ",", "4"}], "]"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", "NSysts", "]"}]}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.956582397267912*^9, 3.956582438034385*^9}, {
   3.95658260156394*^9, 3.95658263914332*^9}, {3.9565826784500456`*^9, 
   3.956582681283206*^9}, 3.9565871841791067`*^9, {3.9565872288221884`*^9, 
   3.9565872305245733`*^9}, 3.956587264467236*^9, {3.95658773590092*^9, 
   3.9565877457251377`*^9}, {3.956587778876622*^9, 3.95658778546511*^9}, {
   3.9565878342881346`*^9, 3.956587848723393*^9}, 3.956587915521719*^9, {
   3.956688730787898*^9, 3.9566887313465166`*^9}},
 CellLabel->
  "In[269]:=",ExpressionUUID->"bee6cb48-54d3-47d0-ad65-c8a20c618a7f"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"WTMAD1PercentWeights", "=", 
   FractionBox["WTMAD1Weights", 
    RowBox[{"Total", "[", "WTMAD1Weights", "]"}]]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Total", "[", "WTMAD1PercentWeights", "]"}]}], "Input",
 CellChangeTimes->{{3.956582716827536*^9, 3.9565827291707726`*^9}, {
  3.9565828231455297`*^9, 3.956582842626396*^9}, {3.9565828923101435`*^9, 
  3.956582897144931*^9}, {3.956584582500524*^9, 3.9565845911620855`*^9}, {
  3.9565871307570467`*^9, 3.956587161774049*^9}, {3.9565872074773693`*^9, 
  3.956587234966576*^9}, {3.9565877868734293`*^9, 3.9565878099726443`*^9}},
 CellLabel->
  "In[270]:=",ExpressionUUID->"ae5033bc-8804-4373-a9a2-c77bd6940b1b"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"WTMAD1PercentWeightsMAEs", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     FractionBox[
      RowBox[{"WTMAD1PercentWeights", "*", 
       RowBox[{"MAEs", "[", 
        RowBox[{"[", "i", "]"}], "]"}]}], 
      RowBox[{"Total", "[", 
       RowBox[{"WTMAD1PercentWeights", "*", 
        RowBox[{"MAEs", "[", 
         RowBox[{"[", "i", "]"}], "]"}]}], "]"}]], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", "FuncLabels", "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Total", "[", 
  RowBox[{"WTMAD1PercentWeightsMAEs", ",", "2"}], "]"}]}], "Input",
 CellChangeTimes->{{3.956582876066087*^9, 3.956582879514589*^9}, {
   3.9565829332007227`*^9, 3.956582938664235*^9}, {3.9565845617056475`*^9, 
   3.956584634096374*^9}, {3.956587138255739*^9, 3.9565871631413574`*^9}, 
   3.956587206969255*^9, {3.956587793205859*^9, 3.956587808022204*^9}, {
   3.96629501429468*^9, 3.966295027141844*^9}, {3.9662950737928753`*^9, 
   3.9662950816278787`*^9}, {3.9662951180950136`*^9, 3.9662951374309845`*^9}},
 CellLabel->
  "In[272]:=",ExpressionUUID->"b2ef92c2-ad03-47f9-812c-0a0716c604d7"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Get WTMAD-2", "Section",
 CellChangeTimes->{{3.8159098859335394`*^9, 3.8159098936639137`*^9}, {
   3.816020473371563*^9, 3.8160204797198906`*^9}, {3.867287106187972*^9, 
   3.8672871084708767`*^9}, {3.9169979350764914`*^9, 
   3.9169979369826174`*^9}, {3.94641371084194*^9, 3.9464137299645586`*^9}, 
   3.9556493624167347`*^9, {3.9556542149812284`*^9, 3.9556542185457573`*^9}, {
   3.9565872139918404`*^9, 3.9565872150360765`*^9}, {3.956587249155779*^9, 
   3.9565872505400915`*^9}},ExpressionUUID->"db70bf0f-cfe3-4afa-b44e-\
0a8f07be726e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"WTMAD2Weights", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      FractionBox[
       RowBox[{"NSysts", "[", 
        RowBox[{"[", "i", "]"}], "]"}], 
       RowBox[{"Total", "[", "NSysts", "]"}]], 
      FractionBox[
       RowBox[{"If", "[", 
        RowBox[{"DEBfixed", ",", "DEBfixedval", ",", 
         RowBox[{"Mean", "[", "DeltEBi", "]"}]}], "]"}], 
       RowBox[{"DeltEBi", "[", 
        RowBox[{"[", "i", "]"}], "]"}]]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", "NSysts", "]"}]}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.956582397267912*^9, 3.956582438034385*^9}, {
   3.95658260156394*^9, 3.95658263914332*^9}, {3.9565826784500456`*^9, 
   3.956582681283206*^9}, 3.9565871841791067`*^9, {3.9565872288221884`*^9, 
   3.9565872305245733`*^9}, {3.966026158853484*^9, 3.966026175263531*^9}},
 CellLabel->
  "In[274]:=",ExpressionUUID->"0a829db2-20ff-4a26-b2cd-761041946aa4"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"WTMAD2PercentWeights", "=", 
   FractionBox["WTMAD2Weights", 
    RowBox[{"Total", "[", "WTMAD2Weights", "]"}]]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Total", "[", "WTMAD2PercentWeights", "]"}]}], "Input",
 CellChangeTimes->{{3.956582716827536*^9, 3.9565827291707726`*^9}, {
   3.9565828231455297`*^9, 3.956582842626396*^9}, {3.9565828923101435`*^9, 
   3.956582897144931*^9}, {3.956584582500524*^9, 3.9565845911620855`*^9}, {
   3.9565871307570467`*^9, 3.956587161774049*^9}, {3.9565872074773693`*^9, 
   3.956587234966576*^9}, 3.956588064967461*^9},
 CellLabel->
  "In[275]:=",ExpressionUUID->"4aea3a86-1bf4-4735-a436-1b148255cae0"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"WTMAD2PercentWeightsMAEs", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"WTMAD2PercentWeights", "*", 
        RowBox[{"MAEs", "[", 
         RowBox[{"[", "i", "]"}], "]"}]}], ")"}], "/", 
      RowBox[{"Total", "[", 
       RowBox[{"WTMAD2PercentWeights", "*", 
        RowBox[{"MAEs", "[", 
         RowBox[{"[", "i", "]"}], "]"}]}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", "FuncLabels", "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Total", "[", 
  RowBox[{"WTMAD2PercentWeightsMAEs", ",", "2"}], "]"}]}], "Input",
 CellChangeTimes->{{3.956582876066087*^9, 3.956582879514589*^9}, {
   3.9565829332007227`*^9, 3.956582938664235*^9}, {3.9565845617056475`*^9, 
   3.956584634096374*^9}, {3.956587138255739*^9, 3.9565871631413574`*^9}, 
   3.956587206969255*^9, 3.9565880655655966`*^9, {3.966295158832013*^9, 
   3.9662952179790955`*^9}},
 CellLabel->
  "In[277]:=",ExpressionUUID->"92377b9b-434c-4da6-8dca-feb1dc87a8c3"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Get WTMAD-3", "Section",
 CellChangeTimes->{{3.8159098859335394`*^9, 3.8159098936639137`*^9}, {
   3.816020473371563*^9, 3.8160204797198906`*^9}, {3.867287106187972*^9, 
   3.8672871084708767`*^9}, {3.9169979350764914`*^9, 
   3.9169979369826174`*^9}, {3.94641371084194*^9, 3.9464137299645586`*^9}, 
   3.9556493624167347`*^9, {3.9556542149812284`*^9, 3.9556542185457573`*^9}, {
   3.9565872139918404`*^9, 3.9565872150360765`*^9}, {3.956587249155779*^9, 
   3.9565872505400915`*^9}, 
   3.9565880243893003`*^9},ExpressionUUID->"bf8b89bf-d531-412b-a195-\
6a08785e36a3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"WTMAD3Weights", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      FractionBox[
       RowBox[{"Min", "[", 
        RowBox[{
         RowBox[{"0.01", "*", 
          RowBox[{"Total", "[", "NSysts", "]"}]}], ",", 
         RowBox[{"NSysts", "[", 
          RowBox[{"[", "i", "]"}], "]"}]}], "]"}], 
       RowBox[{"Total", "[", "NSysts", "]"}]], 
      FractionBox[
       RowBox[{"If", "[", 
        RowBox[{"DEBfixed", ",", "DEBfixedval", ",", 
         RowBox[{"Mean", "[", "DeltEBi", "]"}]}], "]"}], 
       RowBox[{"DeltEBi", "[", 
        RowBox[{"[", "i", "]"}], "]"}]]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", "NSysts", "]"}]}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.956582397267912*^9, 3.956582438034385*^9}, {
   3.95658260156394*^9, 3.95658263914332*^9}, {3.9565826784500456`*^9, 
   3.956582681283206*^9}, 3.9565871841791067`*^9, {3.9565872288221884`*^9, 
   3.9565872305245733`*^9}, {3.956588029137372*^9, 3.9565880461362095`*^9}, 
   3.9660261854577026`*^9, {3.9723872309596076`*^9, 3.9723872313226805`*^9}},
 CellLabel->
  "In[279]:=",ExpressionUUID->"03ff58bc-fb1c-402c-95a5-21e2aee66941"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"WTMAD3PercentWeights", "=", 
   FractionBox["WTMAD3Weights", 
    RowBox[{"Total", "[", "WTMAD3Weights", "]"}]]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Total", "[", "WTMAD3PercentWeights", "]"}]}], "Input",
 CellChangeTimes->{{3.956582716827536*^9, 3.9565827291707726`*^9}, {
  3.9565828231455297`*^9, 3.956582842626396*^9}, {3.9565828923101435`*^9, 
  3.956582897144931*^9}, {3.956584582500524*^9, 3.9565845911620855`*^9}, {
  3.9565871307570467`*^9, 3.956587161774049*^9}, {3.9565872074773693`*^9, 
  3.956587234966576*^9}, {3.9565880487027893`*^9, 3.956588060774515*^9}},
 CellLabel->
  "In[280]:=",ExpressionUUID->"c25264a6-0f79-4b51-a3ee-c3ed9cb98b65"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"WTMAD3PercentWeightsMAEs", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     FractionBox[
      RowBox[{"WTMAD3PercentWeights", "*", 
       RowBox[{"MAEs", "[", 
        RowBox[{"[", "i", "]"}], "]"}]}], 
      RowBox[{"Total", "[", 
       RowBox[{"WTMAD3PercentWeights", "*", 
        RowBox[{"MAEs", "[", 
         RowBox[{"[", "i", "]"}], "]"}]}], "]"}]], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", "FuncLabels", "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Total", "[", 
  RowBox[{"WTMAD3PercentWeightsMAEs", ",", "2"}], "]"}]}], "Input",
 CellChangeTimes->{{3.956582876066087*^9, 3.956582879514589*^9}, {
   3.9565829332007227`*^9, 3.956582938664235*^9}, {3.9565845617056475`*^9, 
   3.956584634096374*^9}, {3.956587138255739*^9, 3.9565871631413574`*^9}, 
   3.956587206969255*^9, {3.956588053094781*^9, 3.9565880616957226`*^9}, {
   3.9662951627090225`*^9, 3.966295215798777*^9}},
 CellLabel->
  "In[282]:=",ExpressionUUID->"151d3dda-3e77-41e9-ba40-352cfcadff54"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Get WTMAD-4", "Section",
 CellChangeTimes->{{3.8159098859335394`*^9, 3.8159098936639137`*^9}, {
   3.816020473371563*^9, 3.8160204797198906`*^9}, {3.867287106187972*^9, 
   3.8672871084708767`*^9}, {3.9169979350764914`*^9, 
   3.9169979369826174`*^9}, {3.94641371084194*^9, 3.9464137299645586`*^9}, 
   3.9556493624167347`*^9, {3.9556542149812284`*^9, 3.9556542185457573`*^9}, {
   3.9565872139918404`*^9, 3.9565872150360765`*^9}, {3.956587249155779*^9, 
   3.9565872505400915`*^9}, {3.956599131692154*^9, 3.9565991428936825`*^9}, 
   3.956687277563732*^9, 
   3.9573531002514596`*^9},ExpressionUUID->"beab751f-fa93-4ffe-9246-\
6098248ae250"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"WTMAD4Weights", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       FractionBox["1", 
        RowBox[{"Length", "[", "NSysts", "]"}]], "*", 
       RowBox[{"GMTKN55info", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "6"}], "]"}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", 
        RowBox[{"Length", "[", "NSysts", "]"}]}], "}"}]}], "]"}]}], ";"}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.956582397267912*^9, 3.956582438034385*^9}, {
   3.95658260156394*^9, 3.95658263914332*^9}, {3.9565826784500456`*^9, 
   3.956582681283206*^9}, 3.9565871841791067`*^9, {3.9565872288221884`*^9, 
   3.9565872305245733`*^9}, {3.9565991365732555`*^9, 3.956599159425415*^9}, {
   3.9565991901565137`*^9, 3.956599190246534*^9}, {3.9565992799677896`*^9, 
   3.956599281119049*^9}, 3.956687280555092*^9, {3.9566879592102227`*^9, 
   3.9566879629032335`*^9}, 3.9566887485388823`*^9, 3.957353157706422*^9},
 CellLabel->
  "In[284]:=",ExpressionUUID->"802a77bc-483f-4113-8f89-d8eef16b0522"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"WTMAD4PercentWeights", "=", 
   FractionBox["WTMAD4Weights", 
    RowBox[{"Total", "[", "WTMAD4Weights", "]"}]]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Total", "[", 
  RowBox[{"WTMAD4PercentWeights", ",", "2"}], "]"}]}], "Input",
 CellChangeTimes->{{3.956582716827536*^9, 3.9565827291707726`*^9}, {
   3.9565828231455297`*^9, 3.956582842626396*^9}, {3.9565828923101435`*^9, 
   3.956582897144931*^9}, {3.956584582500524*^9, 3.9565845911620855`*^9}, {
   3.9565871307570467`*^9, 3.956587161774049*^9}, {3.9565872074773693`*^9, 
   3.956587234966576*^9}, 3.956588064967461*^9, {3.95659916157206*^9, 
   3.956599196107857*^9}, {3.9565992619077125`*^9, 3.9565992620587463`*^9}, {
   3.956599304720378*^9, 3.9565993063997574`*^9}, {3.956687282211628*^9, 
   3.956687291716204*^9}, {3.957353159609851*^9, 3.9573531758675313`*^9}, 
   3.9662952117730865`*^9},
 CellLabel->
  "In[285]:=",ExpressionUUID->"7911b51d-8ff0-42b7-ad82-ec5a5b82c588"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"WTMAD4PercentWeightsMAEs", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     FractionBox[
      RowBox[{"WTMAD4PercentWeights", "*", 
       RowBox[{"MAEs", "[", 
        RowBox[{"[", "i", "]"}], "]"}]}], 
      RowBox[{"Total", "[", 
       RowBox[{"WTMAD4PercentWeights", "*", 
        RowBox[{"MAEs", "[", 
         RowBox[{"[", "i", "]"}], "]"}]}], "]"}]], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", "FuncLabels", "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Total", "[", 
  RowBox[{"WTMAD4PercentWeightsMAEs", ",", "2"}], "]"}]}], "Input",
 CellChangeTimes->{{3.956582876066087*^9, 3.956582879514589*^9}, {
   3.9565829332007227`*^9, 3.956582938664235*^9}, {3.9565845617056475`*^9, 
   3.956584634096374*^9}, {3.956587138255739*^9, 3.9565871631413574`*^9}, 
   3.956587206969255*^9, 3.9565880655655966`*^9, {3.9565991686076484`*^9, 
   3.9565992025673156`*^9}, {3.956687284685731*^9, 3.956687288351381*^9}, {
   3.9573531642549095`*^9, 3.9573531709804277`*^9}, {3.96629517974104*^9, 
   3.966295209028248*^9}},
 CellLabel->
  "In[287]:=",ExpressionUUID->"ecc6d8f2-c788-4805-a289-49304b3578d7"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Get MAEs and Mean MAEs", "Section",
 CellChangeTimes->{{3.8159098859335394`*^9, 3.8159098936639137`*^9}, {
   3.816020473371563*^9, 3.8160204797198906`*^9}, {3.867287106187972*^9, 
   3.8672871084708767`*^9}, {3.9169979350764914`*^9, 
   3.9169979369826174`*^9}, {3.94641371084194*^9, 3.9464137299645586`*^9}, 
   3.9556493624167347`*^9, {3.9556542149812284`*^9, 3.9556542185457573`*^9}, {
   3.9565872139918404`*^9, 3.9565872150360765`*^9}, {3.956587245363923*^9, 
   3.9565872461460996`*^9}, {3.9672063081302004`*^9, 
   3.967206310163213*^9}},ExpressionUUID->"a0ea6ef2-656c-49f0-a703-\
67d30c1e7a1b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MeanMADs", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Mean", "[", 
      RowBox[{"MAEs", "[", 
       RowBox[{"[", 
        RowBox[{"All", ",", "i"}], "]"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Length", "[", "SystLabels", "]"}]}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.9672063884628363`*^9, 3.9672064428859386`*^9}, {
  3.967206604919346*^9, 3.9672066101081724`*^9}},
 CellLabel->
  "In[289]:=",ExpressionUUID->"e8936137-c0b4-4cd6-adc0-97eb788d5b67"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ScaleFactor", "=", "3.5"}], ";"}], 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "Can", " ", "be", " ", "played", " ", "with", " ", "to", " ", "give", " ",
      "results", " ", "for", " ", "WTMAD"}], "-", 
    RowBox[{"4", " ", "near", " ", "that", " ", "of", " ", "WTMAD"}], "-", 
    RowBox[{"2", " ", "for", " ", "help", " ", "with", " ", "familiarity"}]}],
    "*)"}]}]], "Input",
 CellChangeTimes->{{3.970155677001438*^9, 3.970155731707099*^9}, {
  3.970159780040058*^9, 3.9701597808251963`*^9}, {3.9722329581328087`*^9, 
  3.9722329594160995`*^9}},
 CellLabel->
  "In[290]:=",ExpressionUUID->"31a47b58-3b67-4a4e-be52-2a8efd9bb342"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"MeanMADTable", "=", "\[IndentingNewLine]", 
   RowBox[{"Prepend", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{"SystLabels", ",", "\[IndentingNewLine]", 
        RowBox[{"Round", "[", 
         RowBox[{"DeltEBi", ",", "0.0001"}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Round", "[", 
         RowBox[{"MeanMADs", ",", "0.0001"}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Nearest", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
            "0.5", ",", "1.0", ",", "2.5", ",", "5.0", ",", "10.0", ",", 
             "25.0", ",", "50.0"}], "}"}], ",", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"100.", "/", "55."}], ")"}], "/", "MeanMADs"}], "*", 
            "ScaleFactor"}]}], "]"}], "[", 
         RowBox[{"[", 
          RowBox[{"All", ",", "1"}], "]"}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"100.", "/", "55."}], ")"}], "/", "MeanMADs"}], "*", 
         "ScaleFactor"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"MeanMADs", "*", 
            RowBox[{
             RowBox[{
              RowBox[{"Nearest", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.5", ",", "1.0", ",", "2.5", ",", "5.0", ",", "10.0", ",", 
                  "25.0", ",", "50.0"}], "}"}], ",", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"100.", "/", "55."}], ")"}], "/", "MeanMADs"}], 
                 "*", "ScaleFactor"}]}], "]"}], "[", 
              RowBox[{"[", 
               RowBox[{"All", ",", "1"}], "]"}], "]"}], "/", 
             "ScaleFactor"}]}], ")"}], "/", 
          RowBox[{"Total", "[", 
           RowBox[{"MeanMADs", "*", 
            RowBox[{
             RowBox[{
              RowBox[{"Nearest", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.5", ",", "1.0", ",", "2.5", ",", "5.0", ",", "10.0", ",", 
                  "25.0", ",", "50.0"}], "}"}], ",", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"100.", "/", "55."}], ")"}], "/", "MeanMADs"}], 
                 "*", "ScaleFactor"}]}], "]"}], "[", 
              RowBox[{"[", 
               RowBox[{"All", ",", "1"}], "]"}], "]"}], "/", 
             "ScaleFactor"}]}], "]"}]}], "*", "100"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"MeanMADs", "*", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"100.", "/", "55."}], ")"}], "/", "MeanMADs"}], "*", 
            RowBox[{"ScaleFactor", "/", "ScaleFactor"}]}], ")"}], "/", 
          RowBox[{"Total", "[", 
           RowBox[{"MeanMADs", "*", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"100.", "/", "55."}], ")"}], "/", "MeanMADs"}], "*", 
            RowBox[{"ScaleFactor", "/", "ScaleFactor"}]}], "]"}]}], "*", 
         "100"}]}], "\[IndentingNewLine]", "}"}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
      "\"\<System\>\"", ",", "\"\<DeltaEBar\>\"", ",", "\"\<MeanMAD\>\"", 
       ",", "\"\<BinnedWeight\>\"", ",", "\"\<IdealWeight\>\"", ",", 
       "\"\<BW%cont.\>\"", ",", "\"\<IW%cont.\>\""}], "}"}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"TableForm", "[", 
   RowBox[{"MeanMADTable", ",", 
    RowBox[{"TableAlignments", "\[Rule]", "Right"}]}], "]"}], "//", 
  RowBox[{
   RowBox[{"NumberForm", "[", 
    RowBox[{"#", ",", 
     RowBox[{"{", 
      RowBox[{"Infinity", ",", "2"}], "}"}]}], "]"}], "&"}]}]}], "Input",
 CellChangeTimes->{{3.9669750910651455`*^9, 3.9669751653201256`*^9}, 
   3.9669752354727616`*^9, 3.966975266170786*^9, {3.967206592727512*^9, 
   3.9672066815133553`*^9}, {3.9672078928304787`*^9, 3.96720791614533*^9}, {
   3.9672079716381664`*^9, 3.9672079738525496`*^9}, {3.9701522749084053`*^9, 
   3.9701523040892286`*^9}, {3.9701523791970053`*^9, 3.970152406397627*^9}, {
   3.9701524766027746`*^9, 3.970152504008566*^9}, {3.97015258035201*^9, 
   3.9701527109036226`*^9}, {3.970153283185176*^9, 3.9701532906059866`*^9}, 
   3.9701533600147448`*^9, {3.9701555943868475`*^9, 3.970155693057774*^9}, {
   3.9701557345395994`*^9, 3.970155764822448*^9}, {3.9701597824554853`*^9, 
   3.9701597860741243`*^9}, {3.970160571383315*^9, 3.9701605779749784`*^9}, 
   3.970162251536539*^9, {3.970944063239688*^9, 3.970944105954877*^9}, {
   3.9709447754128675`*^9, 3.9709448087852383`*^9}, {3.9709462805615225`*^9, 
   3.970946290907538*^9}, {3.9709504544425817`*^9, 3.970950464942689*^9}, {
   3.970998733165704*^9, 3.970998741899225*^9}, {3.9709990406751995`*^9, 
   3.970999042073202*^9}, {3.9709993746350784`*^9, 3.970999388441417*^9}, {
   3.971000085583984*^9, 3.9710000948804493`*^9}, {3.971000159591378*^9, 
   3.97100024517264*^9}},
 CellLabel->
  "In[291]:=",ExpressionUUID->"2e776a5e-4705-4f21-b17e-2a8735bcbf9b"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Get WTMAD-4_bw", "Section",
 CellChangeTimes->{{3.8159098859335394`*^9, 3.8159098936639137`*^9}, {
   3.816020473371563*^9, 3.8160204797198906`*^9}, {3.867287106187972*^9, 
   3.8672871084708767`*^9}, {3.9169979350764914`*^9, 
   3.9169979369826174`*^9}, {3.94641371084194*^9, 3.9464137299645586`*^9}, 
   3.9556493624167347`*^9, {3.9556542149812284`*^9, 3.9556542185457573`*^9}, {
   3.9565872139918404`*^9, 3.9565872150360765`*^9}, {3.956587249155779*^9, 
   3.9565872505400915`*^9}, {3.956599131692154*^9, 3.9565991428936825`*^9}, 
   3.956687277563732*^9, 3.9573531002514596`*^9, {3.970944323485854*^9, 
   3.9709443241788535`*^9}},ExpressionUUID->"57ef0086-fa88-43ff-9c95-\
25ea55cc7849"],

Cell[BoxData[
 RowBox[{
  RowBox[{"WTMAD4bwWeights", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      FractionBox["1", 
       RowBox[{"Length", "[", "NSysts", "]"}]], "*", 
      RowBox[{"MeanMADTable", "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{"i", "+", "1"}], ",", "4"}], "]"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", "NSysts", "]"}]}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.956582397267912*^9, 3.956582438034385*^9}, {
   3.95658260156394*^9, 3.95658263914332*^9}, {3.9565826784500456`*^9, 
   3.956582681283206*^9}, 3.9565871841791067`*^9, {3.9565872288221884`*^9, 
   3.9565872305245733`*^9}, {3.9565991365732555`*^9, 3.956599159425415*^9}, {
   3.9565991901565137`*^9, 3.956599190246534*^9}, {3.9565992799677896`*^9, 
   3.956599281119049*^9}, 3.956687280555092*^9, {3.9566879592102227`*^9, 
   3.9566879629032335`*^9}, 3.9566887485388823`*^9, 3.957353157706422*^9, {
   3.970944442203769*^9, 3.9709444602223125`*^9}, {3.9709456402292805`*^9, 
   3.970945662710605*^9}, 3.971002708990577*^9},
 CellLabel->
  "In[293]:=",ExpressionUUID->"74a7e990-b832-4d9b-b2be-b0eb80297549"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"WTMAD4bwPercentWeights", "=", 
   FractionBox["WTMAD4bwWeights", 
    RowBox[{"Total", "[", "WTMAD4bwWeights", "]"}]]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Total", "[", 
  RowBox[{"WTMAD4bwPercentWeights", ",", "2"}], "]"}]}], "Input",
 CellChangeTimes->{{3.956582716827536*^9, 3.9565827291707726`*^9}, {
   3.9565828231455297`*^9, 3.956582842626396*^9}, {3.9565828923101435`*^9, 
   3.956582897144931*^9}, {3.956584582500524*^9, 3.9565845911620855`*^9}, {
   3.9565871307570467`*^9, 3.956587161774049*^9}, {3.9565872074773693`*^9, 
   3.956587234966576*^9}, 3.956588064967461*^9, {3.95659916157206*^9, 
   3.956599196107857*^9}, {3.9565992619077125`*^9, 3.9565992620587463`*^9}, {
   3.956599304720378*^9, 3.9565993063997574`*^9}, {3.956687282211628*^9, 
   3.956687291716204*^9}, {3.957353159609851*^9, 3.9573531758675313`*^9}, 
   3.9662952117730865`*^9, {3.9709444627836103`*^9, 3.970944467626441*^9}},
 CellLabel->
  "In[294]:=",ExpressionUUID->"4940d971-2e8b-4096-a69f-44ee471c6f81"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"WTMAD4bwPercentWeightsMAEs", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     FractionBox[
      RowBox[{"WTMAD4bwPercentWeights", "*", 
       RowBox[{"MAEs", "[", 
        RowBox[{"[", "i", "]"}], "]"}]}], 
      RowBox[{"Total", "[", 
       RowBox[{"WTMAD4bwPercentWeights", "*", 
        RowBox[{"MAEs", "[", 
         RowBox[{"[", "i", "]"}], "]"}]}], "]"}]], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", "FuncLabels", "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Total", "[", 
  RowBox[{"WTMAD4bwPercentWeightsMAEs", ",", "2"}], "]"}]}], "Input",
 CellChangeTimes->{{3.956582876066087*^9, 3.956582879514589*^9}, {
   3.9565829332007227`*^9, 3.956582938664235*^9}, {3.9565845617056475`*^9, 
   3.956584634096374*^9}, {3.956587138255739*^9, 3.9565871631413574`*^9}, 
   3.956587206969255*^9, 3.9565880655655966`*^9, {3.9565991686076484`*^9, 
   3.9565992025673156`*^9}, {3.956687284685731*^9, 3.956687288351381*^9}, {
   3.9573531642549095`*^9, 3.9573531709804277`*^9}, {3.96629517974104*^9, 
   3.966295209028248*^9}, {3.9709444697961855`*^9, 3.9709444732345066`*^9}},
 CellLabel->
  "In[296]:=",ExpressionUUID->"25295b73-2b6f-4471-9e0f-2f976645c311"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Get WTMAD-4_iw", "Section",
 CellChangeTimes->{{3.8159098859335394`*^9, 3.8159098936639137`*^9}, {
   3.816020473371563*^9, 3.8160204797198906`*^9}, {3.867287106187972*^9, 
   3.8672871084708767`*^9}, {3.9169979350764914`*^9, 
   3.9169979369826174`*^9}, {3.94641371084194*^9, 3.9464137299645586`*^9}, 
   3.9556493624167347`*^9, {3.9556542149812284`*^9, 3.9556542185457573`*^9}, {
   3.9565872139918404`*^9, 3.9565872150360765`*^9}, {3.956587249155779*^9, 
   3.9565872505400915`*^9}, {3.956599131692154*^9, 3.9565991428936825`*^9}, 
   3.956687277563732*^9, 3.9573531002514596`*^9, {3.970944323485854*^9, 
   3.970944329753518*^9}},ExpressionUUID->"7facfb5e-9fdc-4799-94d9-\
8889877db090"],

Cell[BoxData[
 RowBox[{
  RowBox[{"WTMAD4iwWeights", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      FractionBox["1", 
       RowBox[{"Length", "[", "NSysts", "]"}]], "*", 
      RowBox[{"MeanMADTable", "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{"i", "+", "1"}], ",", "5"}], "]"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", "NSysts", "]"}]}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.956582397267912*^9, 3.956582438034385*^9}, {
   3.95658260156394*^9, 3.95658263914332*^9}, {3.9565826784500456`*^9, 
   3.956582681283206*^9}, 3.9565871841791067`*^9, {3.9565872288221884`*^9, 
   3.9565872305245733`*^9}, {3.9565991365732555`*^9, 3.956599159425415*^9}, {
   3.9565991901565137`*^9, 3.956599190246534*^9}, {3.9565992799677896`*^9, 
   3.956599281119049*^9}, 3.956687280555092*^9, {3.9566879592102227`*^9, 
   3.9566879629032335`*^9}, 3.9566887485388823`*^9, 3.957353157706422*^9, {
   3.970944451279293*^9, 3.970944482298745*^9}, {3.9709452436652565`*^9, 
   3.9709452684345875`*^9}, {3.970945644451442*^9, 3.970945658697092*^9}, 
   3.971002707362911*^9},
 CellLabel->
  "In[298]:=",ExpressionUUID->"2d788915-6ce1-4328-bfae-696cc56a949c"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"WTMAD4iwPercentWeights", "=", 
   FractionBox["WTMAD4iwWeights", 
    RowBox[{"Total", "[", "WTMAD4iwWeights", "]"}]]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Total", "[", 
  RowBox[{"WTMAD4iwPercentWeights", ",", "2"}], "]"}]}], "Input",
 CellChangeTimes->{{3.956582716827536*^9, 3.9565827291707726`*^9}, {
   3.9565828231455297`*^9, 3.956582842626396*^9}, {3.9565828923101435`*^9, 
   3.956582897144931*^9}, {3.956584582500524*^9, 3.9565845911620855`*^9}, {
   3.9565871307570467`*^9, 3.956587161774049*^9}, {3.9565872074773693`*^9, 
   3.956587234966576*^9}, 3.956588064967461*^9, {3.95659916157206*^9, 
   3.956599196107857*^9}, {3.9565992619077125`*^9, 3.9565992620587463`*^9}, {
   3.956599304720378*^9, 3.9565993063997574`*^9}, {3.956687282211628*^9, 
   3.956687291716204*^9}, {3.957353159609851*^9, 3.9573531758675313`*^9}, 
   3.9662952117730865`*^9, {3.970944486590909*^9, 3.97094449090794*^9}},
 CellLabel->
  "In[299]:=",ExpressionUUID->"7bb1397b-600c-4c0e-84ee-23cb8da756d9"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"WTMAD4iwPercentWeightsMAEs", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     FractionBox[
      RowBox[{"WTMAD4iwPercentWeights", "*", 
       RowBox[{"MAEs", "[", 
        RowBox[{"[", "i", "]"}], "]"}]}], 
      RowBox[{"Total", "[", 
       RowBox[{"WTMAD4iwPercentWeights", "*", 
        RowBox[{"MAEs", "[", 
         RowBox[{"[", "i", "]"}], "]"}]}], "]"}]], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", "FuncLabels", "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Total", "[", 
  RowBox[{"WTMAD4iwPercentWeightsMAEs", ",", "2"}], "]"}]}], "Input",
 CellChangeTimes->{{3.956582876066087*^9, 3.956582879514589*^9}, {
   3.9565829332007227`*^9, 3.956582938664235*^9}, {3.9565845617056475`*^9, 
   3.956584634096374*^9}, {3.956587138255739*^9, 3.9565871631413574`*^9}, 
   3.956587206969255*^9, 3.9565880655655966`*^9, {3.9565991686076484`*^9, 
   3.9565992025673156`*^9}, {3.956687284685731*^9, 3.956687288351381*^9}, {
   3.9573531642549095`*^9, 3.9573531709804277`*^9}, {3.96629517974104*^9, 
   3.966295209028248*^9}, {3.9709444924512453`*^9, 3.970944496628789*^9}, {
   3.9709453310260515`*^9, 3.970945345561074*^9}, {3.9709465979720554`*^9, 
   3.9709466134774165`*^9}},
 CellLabel->
  "In[301]:=",ExpressionUUID->"3daaab03-e338-4349-a714-1453cd30eab8"],

Cell[" ", "Text",
 Editable->False,
 Selectable->False,
 CellFrame->{{0, 0}, {0, 3}},
 ShowCellBracket->False,
 CellMargins->{{0, 0}, {1, 1}},
 CellElementSpacings->{"CellMinHeight"->1},
 CellFrameMargins->0,
 CellFrameColor->RGBColor[0, 0, 1],
 CellSize->{
  Inherited, 5},ExpressionUUID->"6dfa2fe8-552e-4b3e-ab06-e01d23445460"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Analysis of WTMAD4 Ideal Weights", "Section",
 CellChangeTimes->{{3.9710037275732317`*^9, 3.9710037338623514`*^9}, {
  3.9710043154725285`*^9, 
  3.971004336262786*^9}},ExpressionUUID->"cd2794b2-c16f-4905-a905-\
ef8838efe782"],

Cell[TextData[{
 "Main issue: Mean of totals isn\[CloseCurlyQuote]t total of means for \
non-square matrices.\[LineSeparator]\n",
 Cell[BoxData[
  RowBox[{"(*", 
   RowBox[{"Basic", " ", 
    RowBox[{"Example", ":", " ", 
     RowBox[{
      RowBox[{"Total", " ", "of", " ", "column"}], "-", 
      RowBox[{"wise", " ", "mean"}]}]}]}], "*)"}]], "Input",
  CellChangeTimes->{{3.970953425984868*^9, 3.9709534283138633`*^9}},
  ExpressionUUID->"4da46970-c254-420c-b295-b9e8e538d55e"],
 "\n",
 Cell[BoxData[{
  RowBox[{"Total", "[", 
   RowBox[{"(", GridBox[{
      {"1.", "2.", "3."},
      {"4.", "5.", "6."},
      {"7.", "8.", "9."},
      {"10.", "11.", "12."}
     }], ")"}], "]"}], "\[IndentingNewLine]", 
  RowBox[{"Mean", "[", 
   RowBox[{"Total", "[", 
    RowBox[{"(", GridBox[{
       {"1.", "2.", "3."},
       {"4.", "5.", "6."},
       {"7.", "8.", "9."},
       {"10.", "11.", "12."}
      }], ")"}], "]"}], "]"}]}], "Input",
  CellChangeTimes->{{3.9709530558404946`*^9, 3.9709531614038*^9}, {
   3.9709532954361644`*^9, 3.9709533044464235`*^9}},ExpressionUUID->
  "ce3be3a9-f2dc-4a2a-b953-648c720cf9ab"],
 "\n",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"22.`", ",", "26.`", ",", "30.`"}], "}"}]], "Output",
  CellChangeTimes->{{3.970953083291609*^9, 3.9709531660774364`*^9}, 
    3.970953326828826*^9, 3.970954122616912*^9, 3.9709541599446144`*^9, 
    3.9709988047138724`*^9, {3.9709989073255653`*^9, 
    3.9709989321144514`*^9}, {3.9709990476433463`*^9, 3.9709990757733755`*^9},
     3.9709992411506343`*^9, 3.9709993423448257`*^9, 3.9710003230633593`*^9, 
    3.9710005710172873`*^9, 3.971003677297818*^9, 3.971004568720595*^9},
  ExpressionUUID->"bec749f7-b325-4640-bb6e-6a5083ce87b8"],
 "\n",
 Cell[BoxData["26.`"], "Output",
  CellChangeTimes->{{3.970953083291609*^9, 3.9709531660774364`*^9}, 
    3.970953326828826*^9, 3.970954122616912*^9, 3.9709541599446144`*^9, 
    3.9709988047138724`*^9, {3.9709989073255653`*^9, 
    3.9709989321144514`*^9}, {3.9709990476433463`*^9, 3.9709990757733755`*^9},
     3.9709992411506343`*^9, 3.9709993423448257`*^9, 3.9710003230633593`*^9, 
    3.9710005710172873`*^9, 3.971003677297818*^9, 3.9710045687255945`*^9},
  ExpressionUUID->"d67d511c-9929-4006-8bc5-3205acd1d309"],
 "\[LineSeparator]\n",
 Cell[BoxData[
  RowBox[{"(*", 
   RowBox[{"Basic", " ", 
    RowBox[{"Example", ":", " ", 
     RowBox[{
      RowBox[{"Mean", " ", "of", " ", "column"}], "-", 
      RowBox[{"wise", " ", "total"}]}]}]}], "*)"}]], "Input",
  CellChangeTimes->{3.9709534398298817`*^9},ExpressionUUID->
  "974f6554-5215-4d3f-a818-d5b789b52d15"],
 "\n",
 Cell[BoxData[{
  RowBox[{"Mean", "[", 
   RowBox[{"(", GridBox[{
      {"1.", "2.", "3."},
      {"4.", "5.", "6."},
      {"7.", "8.", "9."},
      {"10.", "11.", "12."}
     }], ")"}], "]"}], "\[IndentingNewLine]", 
  RowBox[{"Total", "[", 
   RowBox[{"Mean", "[", 
    RowBox[{"(", GridBox[{
       {"1.", "2.", "3."},
       {"4.", "5.", "6."},
       {"7.", "8.", "9."},
       {"10.", "11.", "12."}
      }], ")"}], "]"}], "]"}]}], "Input",
  CellChangeTimes->{{3.970953093218918*^9, 3.9709531650290337`*^9}, {
   3.9709532939046483`*^9, 3.9709532972281604`*^9}},ExpressionUUID->
  "52df709b-e034-4438-b06a-90f67f113003"],
 "\n",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"5.5`", ",", "6.5`", ",", "7.5`"}], "}"}]], "Output",
  CellChangeTimes->{{3.9709530964150543`*^9, 3.970953166762441*^9}, 
    3.9709533268888264`*^9, 3.9709541226689253`*^9, 3.970954159964615*^9, 
    3.970998804737879*^9, {3.970998907345566*^9, 3.9709989321344514`*^9}, {
    3.9709990476633463`*^9, 3.970999075793375*^9}, 3.970999241175635*^9, 
    3.970999342364826*^9, 3.9710003230835457`*^9, 3.971000571037287*^9, 
    3.971003677367819*^9, 3.9710045687747555`*^9},ExpressionUUID->
  "a884fc47-9df9-4fc4-ba36-dd33327d5596"],
 "\n",
 Cell[BoxData["19.5`"], "Output",
  CellChangeTimes->{{3.9709530964150543`*^9, 3.970953166762441*^9}, 
    3.9709533268888264`*^9, 3.9709541226689253`*^9, 3.970954159964615*^9, 
    3.970998804737879*^9, {3.970998907345566*^9, 3.9709989321344514`*^9}, {
    3.9709990476633463`*^9, 3.970999075793375*^9}, 3.970999241175635*^9, 
    3.970999342364826*^9, 3.9710003230835457`*^9, 3.971000571037287*^9, 
    3.971003677367819*^9, 3.971004568784755*^9},ExpressionUUID->
  "04dbc3d0-7a47-4632-a301-18c260ea135d"]
}], "Text",
 CellChangeTimes->{{3.9710046141795645`*^9, 3.971004640520691*^9}, {
  3.9710047503425026`*^9, 
  3.9710047602249002`*^9}},ExpressionUUID->"3be147b5-bf8c-45cc-adc0-\
ab17ff855162"],

Cell[CellGroupData[{

Cell["List of WTMAD4 Ideal Weights", "Subsubsection",
 CellChangeTimes->{{3.9710037275732317`*^9, 3.9710037338623514`*^9}, {
  3.9710043154725285`*^9, 
  3.971004318560376*^9}},ExpressionUUID->"84e1b095-6b84-4c2a-b947-\
ad292a716654"],

Cell[BoxData[
 RowBox[{"WTMAD4iwWeights", "=", 
  RowBox[{"MeanMADTable", "[", 
   RowBox[{"[", 
    RowBox[{
     RowBox[{"2", ";;"}], ",", "5"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.971003518520123*^9, 3.971003539451865*^9}},
 CellLabel->
  "In[303]:=",ExpressionUUID->"21706dae-47ee-4f0f-bf32-c633d3bb1a7c"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Generate table of \[Delta]WTMAD4. We sum these together (row-wise: 1 \
functional, all 55 benchmarks) to get the WTMAD4\
\>", "Subsubsection",
 CellChangeTimes->{{3.9710037275732317`*^9, 3.971003796334501*^9}, 
   3.971003928487012*^9},ExpressionUUID->"dbf9a895-0a9d-4973-939e-\
e19bc9e94b88"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"deltaWTMAD4s", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"WTMAD4iwWeights", "/", 
       RowBox[{"Length", "[", "NSysts", "]"}]}], "*", 
      RowBox[{"MAEs", "[", 
       RowBox[{"[", "i", "]"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", "FuncLabels", "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"TableForm", "[", 
  RowBox[{"Prepend", "[", 
   RowBox[{
    RowBox[{"MapThread", "[", 
     RowBox[{"Prepend", ",", 
      RowBox[{"{", 
       RowBox[{"deltaWTMAD4s", ",", "FuncLabels"}], "}"}]}], "]"}], ",", 
    RowBox[{"Prepend", "[", 
     RowBox[{"SystLabels", ",", "\"\<\[Delta]WTMAD4\>\""}], "]"}]}], "]"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9710021116169777`*^9, 3.9710021440932055`*^9}, {
   3.971002179922012*^9, 3.9710021838640995`*^9}, {3.9710022169697404`*^9, 
   3.971002225763091*^9}, {3.971002295834304*^9, 3.971002302821314*^9}, 
   3.9710027201395955`*^9, {3.9710031185382085`*^9, 3.971003133358905*^9}, {
   3.971003441909289*^9, 3.9710034890999193`*^9}, {3.9710035470240374`*^9, 
   3.97100355800404*^9}},
 CellLabel->
  "In[304]:=",ExpressionUUID->"dad215c5-06a1-4174-a886-274d1dcc7656"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Let\[CloseCurlyQuote]s sum these \[Delta]WTMAD4 values together to get the \
WTMAD4 for each functional.\
\>", "Subsubsection",
 CellChangeTimes->{{3.9710037275732317`*^9, 
  3.971003834658512*^9}},ExpressionUUID->"34cbaf0a-b8a3-4b66-b5e7-\
9c51b86c5062"],

Cell[BoxData[
 RowBox[{"WTMAD4s", "=", 
  RowBox[{"Total", "[", 
   RowBox[{"deltaWTMAD4s", ",", 
    RowBox[{"{", "2", "}"}]}], "]"}], 
  RowBox[{"(*", 
   RowBox[{
   "WTMAD4", " ", "Values", " ", "for", " ", "each", " ", "benchmark"}], 
   "*)"}]}]], "Input",
 CellChangeTimes->{{3.9710030696084394`*^9, 3.9710030714191985`*^9}, {
  3.9710034762226105`*^9, 3.9710034860007415`*^9}},
 CellLabel->
  "In[306]:=",ExpressionUUID->"adab1a58-2501-4d45-b860-14c98e31a2f6"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Now we look at the percent contributions of the \[Delta]WTMAD4 to *their \
respective* WTMAD4.\
\>", "Subsubsection",
 CellChangeTimes->{{3.9710037275732317`*^9, 
  3.971003865075925*^9}},ExpressionUUID->"49c5cc06-d934-4dd4-ba48-\
02964d06b36a"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"deltaWTMAD4Percents", "=", 
   RowBox[{"deltaWTMAD4s", "/", "WTMAD4s"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"TableForm", "[", 
  RowBox[{"Prepend", "[", 
   RowBox[{
    RowBox[{"MapThread", "[", 
     RowBox[{"Prepend", ",", 
      RowBox[{"{", 
       RowBox[{"deltaWTMAD4Percents", ",", "FuncLabels"}], "}"}]}], "]"}], 
    ",", 
    RowBox[{"Prepend", "[", 
     RowBox[{"SystLabels", ",", "\"\<\[Delta]WTMAD4%\>\""}], "]"}]}], "]"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9710021116169777`*^9, 3.9710021440932055`*^9}, {
  3.971002179922012*^9, 3.9710021838640995`*^9}, {3.9710022169697404`*^9, 
  3.971002225763091*^9}, {3.971002295834304*^9, 3.971002302821314*^9}, {
  3.971002564956135*^9, 3.971002605159018*^9}, {3.971002856856655*^9, 
  3.9710028580832047`*^9}, {3.9710030807572145`*^9, 3.9710030820942264`*^9}, {
  3.9710031397795234`*^9, 3.9710031435093703`*^9}, {3.971003482486908*^9, 
  3.971003485131651*^9}, {3.9710035814210815`*^9, 3.971003591532729*^9}},
 CellLabel->
  "In[307]:=",ExpressionUUID->"beef4b99-2308-4678-9287-15ad4f3ef01b"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
We take the means (column-wise: all 12 functionals, 1 benchmark) and we see \
these don\[CloseCurlyQuote]t give us perfectly 100/55=0.018181\
\>", "Subsubsection",
 CellChangeTimes->{{3.9710037275732317`*^9, 
  3.9710039500484447`*^9}},ExpressionUUID->"10ae4d5f-3cf0-4599-8547-\
4ff759742960"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Mean", "[", "deltaWTMAD4Percents", "]"}], 
  RowBox[{"(*", 
   RowBox[{
   "We", " ", "see", " ", "per", " ", "benchmark", " ", "these", " ", "are", 
    " ", "not", " ", "perfectly", " ", "0.01818181"}], "*)"}]}]], "Input",
 CellChangeTimes->{{3.9710033133654366`*^9, 3.9710033176119823`*^9}, {
   3.9710033706797132`*^9, 3.9710033976641345`*^9}, 3.971003596935413*^9},
 CellLabel->
  "In[309]:=",ExpressionUUID->"a15ebd50-47d6-4c82-878a-a832863e577b"],

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{"Prepend", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"Prepend", "[", 
      RowBox[{
       RowBox[{"Mean", "[", "deltaWTMAD4Percents", "]"}], ",", 
       "\"\<Fit Set\>\""}], "]"}], "}"}], ",", 
    RowBox[{"Prepend", "[", 
     RowBox[{"SystLabels", ",", "\"\<Mean[\[Delta]WTMAD4%]\>\""}], "]"}]}], 
   "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.9710043782519865`*^9, 3.971004401750883*^9}, {
  3.9710044515001*^9, 3.9710044516542397`*^9}, {3.971004493093688*^9, 
  3.971004498752698*^9}},
 CellLabel->
  "In[310]:=",ExpressionUUID->"31c46bcf-6fff-403b-a907-f10a7ff6f751"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
However, if we define the percentage contributions of the WTMAD4 to *the \
average* WTMAD4.\
\>", "Subsubsection",
 CellChangeTimes->{{3.9710037275732317`*^9, 3.971003960028549*^9}, {
  3.971004037218233*^9, 3.971004038474125*^9}, {3.9710041833151617`*^9, 
  3.9710042160995255`*^9}},ExpressionUUID->"91ea4b46-ff8d-483e-8e90-\
0df52ca55b91"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"deltaWTMAD4Percents2", "=", 
   RowBox[{"deltaWTMAD4s", "/", 
    RowBox[{"Mean", "[", "WTMAD4s", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"TableForm", "[", 
  RowBox[{"Prepend", "[", 
   RowBox[{
    RowBox[{"MapThread", "[", 
     RowBox[{"Prepend", ",", 
      RowBox[{"{", 
       RowBox[{"deltaWTMAD4Percents2", ",", "FuncLabels"}], "}"}]}], "]"}], 
    ",", 
    RowBox[{"Prepend", "[", 
     RowBox[{"SystLabels", ",", "\"\<\[Delta]WTMAD4%v2\>\""}], "]"}]}], "]"}],
   "]"}]}], "Input",
 CellChangeTimes->{{3.9710021116169777`*^9, 3.9710021440932055`*^9}, {
  3.971002179922012*^9, 3.9710021838640995`*^9}, {3.9710022169697404`*^9, 
  3.971002225763091*^9}, {3.971002295834304*^9, 3.971002302821314*^9}, {
  3.971002564956135*^9, 3.971002605159018*^9}, {3.971002856856655*^9, 
  3.9710028580832047`*^9}, {3.9710030807572145`*^9, 3.9710030820942264`*^9}, {
  3.9710031397795234`*^9, 3.9710031435093703`*^9}, {3.971003482486908*^9, 
  3.971003485131651*^9}, {3.9710035814210815`*^9, 3.971003591532729*^9}, {
  3.971004130465046*^9, 3.97100414298207*^9}, {3.971004173537516*^9, 
  3.9710041767147894`*^9}, {3.9710042222212057`*^9, 3.9710042341072264`*^9}},
 CellLabel->
  "In[311]:=",ExpressionUUID->"4c64fcab-55f2-4f8f-8eb0-ac8094e39f51"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Then the means (column-wise: all 12 functionals, 1 benchmark) DO give us \
perfectly 100/55=0.018181\
\>", "Subsubsection",
 CellChangeTimes->{{3.9710037275732317`*^9, 3.9710039500484447`*^9}, {
  3.9710042463977413`*^9, 3.9710042554074535`*^9}, {3.9710042906452975`*^9, 
  3.9710043049381423`*^9}},ExpressionUUID->"f0a58fae-093b-4eeb-bc45-\
21f1609d3810"],

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{"Prepend", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"Prepend", "[", 
      RowBox[{
       RowBox[{"Mean", "[", "deltaWTMAD4Percents2", "]"}], ",", 
       "\"\<Fit Set\>\""}], "]"}], "}"}], ",", 
    RowBox[{"Prepend", "[", 
     RowBox[{"SystLabels", ",", "\"\<Mean[\[Delta]WTMAD4%v2]\>\""}], "]"}]}], 
   "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.971004528193756*^9, 3.9710045310996428`*^9}},
 CellLabel->
  "In[313]:=",ExpressionUUID->"64e8d5cd-fc46-4d21-90c0-04e4a524c14f"],

Cell[" ", "Text",
 Editable->False,
 Selectable->False,
 CellFrame->{{0, 0}, {0, 3}},
 ShowCellBracket->False,
 CellMargins->{{0, 0}, {1, 1}},
 CellElementSpacings->{"CellMinHeight"->1},
 CellFrameMargins->0,
 CellFrameColor->RGBColor[0, 0, 1],
 CellSize->{
  Inherited, 5},ExpressionUUID->"2da552ca-0551-4474-bf31-607d294f0b8c"],

Cell[" ", "Text",
 Editable->False,
 Selectable->False,
 CellFrame->{{0, 0}, {0, 3}},
 ShowCellBracket->False,
 CellMargins->{{0, 0}, {1, 1}},
 CellElementSpacings->{"CellMinHeight"->1},
 CellFrameMargins->0,
 CellFrameColor->RGBColor[0, 0, 1],
 CellSize->{
  Inherited, 5},ExpressionUUID->"83ff1077-6eab-4455-82b1-bb5db3bae2cb"],

Cell[" ", "Text",
 Editable->False,
 Selectable->False,
 CellFrame->{{0, 0}, {0, 3}},
 ShowCellBracket->False,
 CellMargins->{{0, 0}, {1, 1}},
 CellElementSpacings->{"CellMinHeight"->1},
 CellFrameMargins->0,
 CellFrameColor->RGBColor[0, 0, 1],
 CellSize->{
  Inherited, 5},ExpressionUUID->"0985abee-ff52-4942-b200-e4a27d2e5df9"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"TempTable", "=", 
   RowBox[{"Prepend", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{"SystLabels", ",", "\[IndentingNewLine]", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"Round", "[", 
           RowBox[{
            RowBox[{"MeanMADs", "[", 
             RowBox[{"[", "i", "]"}], "]"}], ",", "0.0001"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "1", ",", 
            RowBox[{"Length", "[", "NSysts", "]"}]}], "}"}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"Round", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"MeanMADs", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "*", 
             RowBox[{"MeanMADTable", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"i", "+", "1"}], ",", "5"}], "]"}], "]"}]}], ",", 
            "0.0001"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "1", ",", 
            RowBox[{"Length", "[", "NSysts", "]"}]}], "}"}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"Round", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"MeanMADs", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "*", 
             RowBox[{
              RowBox[{"MeanMADTable", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"i", "+", "1"}], ",", "5"}], "]"}], "]"}], "/", 
              RowBox[{"Length", "[", "NSysts", "]"}]}]}], ",", "0.0001"}], 
           "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "1", ",", 
            RowBox[{"Length", "[", "NSysts", "]"}]}], "}"}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"Round", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"MeanMADs", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "*", 
             RowBox[{"WTMAD4iwPercentWeights", "[", 
              RowBox[{"[", "i", "]"}], "]"}]}], ",", "0.0001"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "1", ",", 
            RowBox[{"Length", "[", "NSysts", "]"}]}], "}"}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"Mean", "[", 
           RowBox[{"WTMAD4iwPercentWeightsMAEs", "[", 
            RowBox[{"[", 
             RowBox[{"All", ",", "i"}], "]"}], "]"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "1", ",", 
            RowBox[{"Length", "[", "NSysts", "]"}]}], "}"}]}], "]"}]}], 
       "\[IndentingNewLine]", "}"}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
      "\"\<Syst\>\"", ",", "\"\<MeanMAD\>\"", ",", "\"\<Col2*IW\>\"", ",", 
       "\"\<Col3/NBench\>\"", ",", "\"\<Col4/Total[WTMAD4iwWeights]\>\"", 
       ",", "\"\<Temp\>\""}], "}"}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"TableForm", "[", 
   RowBox[{"TempTable", ",", 
    RowBox[{"TableAlignments", "\[Rule]", "Right"}]}], "]"}], "//", 
  RowBox[{
   RowBox[{"NumberForm", "[", 
    RowBox[{"#", ",", 
     RowBox[{"{", 
      RowBox[{"Infinity", ",", "4"}], "}"}]}], "]"}], 
   "&"}]}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.9709478868550663`*^9, 3.9709479640674863`*^9}, {
  3.9709492599922466`*^9, 3.970949273959301*^9}, {3.9709499285103755`*^9, 
  3.9709499286924415`*^9}, {3.970949960306841*^9, 3.9709499890061417`*^9}, {
  3.970951467540333*^9, 3.970951590286406*^9}, {3.970951622653427*^9, 
  3.9709516730310545`*^9}, {3.970951908973448*^9, 3.970951916412306*^9}, {
  3.970952542515436*^9, 3.9709525545824556`*^9}},
 CellLabel->
  "In[314]:=",ExpressionUUID->"64d01119-966b-4469-ae29-0be1c0c0bd3d"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Results", "Section",
 CellChangeTimes->{{3.8159098859335394`*^9, 3.8159098936639137`*^9}, {
   3.816020473371563*^9, 3.8160204797198906`*^9}, {3.867287106187972*^9, 
   3.8672871084708767`*^9}, {3.9169979350764914`*^9, 
   3.9169979369826174`*^9}, {3.94641371084194*^9, 3.9464137299645586`*^9}, 
   3.9556493624167347`*^9, {3.9556542149812284`*^9, 3.9556542185457573`*^9}, {
   3.9565872139918404`*^9, 3.9565872150360765`*^9}, {3.956587249155779*^9, 
   3.9565872505400915`*^9}, 3.9565880243893003`*^9, {3.956591347165248*^9, 
   3.9565913480259705`*^9}, 3.956592883074552*^9, 3.9565935925167217`*^9, {
   3.9565954783134766`*^9, 3.9565954932755566`*^9}, {3.9565959389415627`*^9, 
   3.956595994510801*^9}, {3.956596082139065*^9, 
   3.95659608275187*^9}},ExpressionUUID->"b4c4a423-bbfe-463a-a517-\
31f584cfedf8"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ResTable", "=", 
   RowBox[{"Table", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Prepend", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Transpose", "[", 
        RowBox[{"{", 
         RowBox[{"SystLabels", ",", "\[IndentingNewLine]", 
          RowBox[{"Round", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"WTMAD1PercentWeightsMAEs", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "*", "100"}], ",", "0.0001"}], 
           "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"Round", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"WTMAD2PercentWeightsMAEs", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "*", "100"}], ",", "0.0001"}], 
           "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"Round", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"WTMAD3PercentWeightsMAEs", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "*", "100"}], ",", "0.0001"}], 
           "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"Round", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"WTMAD4PercentWeightsMAEs", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "*", "100"}], ",", "0.0001"}], 
           "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"Round", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"WTMAD4bwPercentWeightsMAEs", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "*", "100"}], ",", "0.0001"}], 
           "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"Round", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"WTMAD4iwPercentWeightsMAEs", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "*", "100"}], ",", "0.0001"}], 
           "]"}]}], "\[IndentingNewLine]", "}"}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FuncLabels", "[", 
          RowBox[{"[", "i", "]"}], "]"}], ",", "\"\<WTMAD-1\>\"", ",", 
         "\"\<WTMAD-2\>\"", ",", "\"\<WTMAD-3\>\"", ",", 
         "\"\<WTMAD-4_d310\>\"", ",", "\"\<WTMAD-4bw\>\"", ",", 
         "\"\<WTMAD-4iw\>\""}], "}"}]}], "\[IndentingNewLine]", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", "FuncLabels", "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TableForm", "[", 
    RowBox[{"ResTable", ",", 
     RowBox[{"TableAlignments", "\[Rule]", "Right"}]}], "]"}], "//", 
   RowBox[{
    RowBox[{"NumberForm", "[", 
     RowBox[{"#", ",", 
      RowBox[{"{", 
       RowBox[{"Infinity", ",", "2"}], "}"}]}], "]"}], "&"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.9565827384105268`*^9, 3.956582742580719*^9}, {
   3.956582782516405*^9, 3.9565827974328837`*^9}, {3.9565828849410334`*^9, 
   3.956582900517448*^9}, {3.9565829467435665`*^9, 3.9565829505903807`*^9}, {
   3.9565848176310835`*^9, 3.956584875278409*^9}, {3.9565849485485954`*^9, 
   3.9565849537016826`*^9}, {3.956586561459158*^9, 3.956586581947933*^9}, {
   3.95658716527884*^9, 3.956587167484338*^9}, {3.956588079471736*^9, 
   3.956588142791031*^9}, {3.956592982253495*^9, 3.9565930093948593`*^9}, {
   3.9565937274738035`*^9, 3.956593738805515*^9}, {3.9565960937635665`*^9, 
   3.956596197232184*^9}, {3.956597360427089*^9, 3.9565973604390917`*^9}, {
   3.956597457359976*^9, 3.9565974841904554`*^9}, {3.956597545632963*^9, 
   3.956597547845964*^9}, {3.9565986314094744`*^9, 3.956598692141187*^9}, {
   3.9565993186555243`*^9, 3.956599336365522*^9}, {3.956688543383193*^9, 
   3.956688587796133*^9}, {3.9573531814607844`*^9, 3.957353211752631*^9}, {
   3.965663438794732*^9, 3.9656634457137775`*^9}, {3.965749148709708*^9, 
   3.9657491642975445`*^9}, {3.9657492895783033`*^9, 3.965749352240179*^9}, {
   3.9662952455757456`*^9, 3.966295308407212*^9}, {3.9663648646422977`*^9, 
   3.966364866731721*^9}, 3.966975187468566*^9, {3.9709445078421106`*^9, 
   3.970944514482231*^9}, {3.9709445869032*^9, 3.9709445981351423`*^9}, {
   3.972401192100842*^9, 3.9724012014236345`*^9}},
 CellLabel->
  "In[316]:=",ExpressionUUID->"1d492bbb-519d-448e-8b4d-e35ae87113ec"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MeanResTableName", "=", 
   RowBox[{
    RowBox[{"StringSplit", "[", 
     RowBox[{
      RowBox[{"inFiles", "[", 
       RowBox[{"[", "1", "]"}], "]"}], ",", "\"\<\\\\\>\""}], "]"}], "[", 
    RowBox[{"[", "2", "]"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.9669752038262815`*^9, 3.9669752697848635`*^9}, {
  3.9672067251790953`*^9, 3.9672067276803684`*^9}},
 CellLabel->
  "In[318]:=",ExpressionUUID->"b556cd31-8a9a-4c83-8101-558e1d0c3bc5"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"MeanResTable", "=", "\[IndentingNewLine]", 
   RowBox[{"Prepend", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{"SystLabels", ",", "\[IndentingNewLine]", 
        RowBox[{"Round", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Mean", "[", "WTMAD1PercentWeightsMAEs", "]"}], "*", 
           "100"}], ",", "0.0001"}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Round", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Mean", "[", "WTMAD2PercentWeightsMAEs", "]"}], "*", 
           "100"}], ",", "0.0001"}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Round", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Mean", "[", "WTMAD3PercentWeightsMAEs", "]"}], "*", 
           "100"}], ",", "0.0001"}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Round", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Mean", "[", "WTMAD4PercentWeightsMAEs", "]"}], "*", 
           "100"}], ",", "0.0001"}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Round", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Mean", "[", "WTMAD4bwPercentWeightsMAEs", "]"}], "*", 
           "100"}], ",", "0.0001"}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Round", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Mean", "[", "WTMAD4iwPercentWeightsMAEs", "]"}], "*", 
           "100"}], ",", "0.0001"}], "]"}]}], "\[IndentingNewLine]", "}"}], 
      "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
      "MeanResTableName", ",", "\"\<WTMAD-1\>\"", ",", "\"\<WTMAD-2\>\"", 
       ",", "\"\<WTMAD-3\>\"", ",", "\"\<WTMAD-4d310\>\"", ",", 
       "\"\<WTMAD-4bw\>\"", ",", "\"\<WTMAD-4iw\>\""}], "}"}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"TableForm", "[", 
   RowBox[{"MeanResTable", ",", 
    RowBox[{"TableAlignments", "\[Rule]", "Right"}]}], "]"}], "//", 
  RowBox[{
   RowBox[{"NumberForm", "[", 
    RowBox[{"#", ",", 
     RowBox[{"{", 
      RowBox[{"Infinity", ",", "2"}], "}"}]}], "]"}], "&"}]}]}], "Input",
 CellChangeTimes->{{3.9669750910651455`*^9, 3.9669751653201256`*^9}, 
   3.9669752354727616`*^9, 3.966975266170786*^9, {3.9709446120929394`*^9, 
   3.970944618987955*^9}, {3.970945412176837*^9, 3.970945424348651*^9}, {
   3.9709469217235327`*^9, 3.970946926440541*^9}, {3.9712592293518143`*^9, 
   3.9712592307691045`*^9}, {3.97240121593996*^9, 3.9724012180675564`*^9}},
 CellLabel->
  "In[319]:=",ExpressionUUID->"5d8f053c-6016-411f-9700-de68f807d3db"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Scatterplot of DeltaEBar_i vs MAD_i", "Section",
 CellChangeTimes->{{3.9660295956517177`*^9, 3.966029629955721*^9}, {
  3.9672078381159196`*^9, 
  3.9672078448343973`*^9}},ExpressionUUID->"3c20ba57-ca78-4882-aef1-\
8c77fbca52a6"],

Cell[BoxData[
 RowBox[{"ListLogLogPlot", "[", 
  RowBox[{"Transpose", "[", 
   RowBox[{"{", 
    RowBox[{"DeltEBi", ",", "MeanMADs"}], "}"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.9672078469489455`*^9, 3.967207849232978*^9}, {
  3.9672080221932983`*^9, 3.9672080476654167`*^9}, {3.967208443897359*^9, 
  3.9672084484131737`*^9}, {3.96720856651707*^9, 3.967208568776095*^9}},
 CellLabel->
  "In[321]:=",ExpressionUUID->"48fd4b75-0cd8-4fc0-91e7-ab03b2387439"],

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Transpose", "[", 
   RowBox[{"{", 
    RowBox[{"DeltEBi", ",", "MeanMADs"}], "}"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{3.9672081551484203`*^9},
 CellLabel->
  "In[322]:=",ExpressionUUID->"0308a8d8-b7d5-4717-bd09-b7607819d232"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Export", "Section",
 CellChangeTimes->{{3.8159098859335394`*^9, 3.8159098936639137`*^9}, {
   3.816020473371563*^9, 3.8160204797198906`*^9}, {3.867287106187972*^9, 
   3.8672871084708767`*^9}, {3.9169979350764914`*^9, 
   3.9169979369826174`*^9}, {3.94641371084194*^9, 3.9464137299645586`*^9}, 
   3.9556493624167347`*^9, {3.9556542149812284`*^9, 3.9556542185457573`*^9}, {
   3.9565872139918404`*^9, 3.9565872150360765`*^9}, {3.956587245363923*^9, 
   3.9565872461460996`*^9}, {3.9672063081302004`*^9, 3.967206310163213*^9}, {
   3.967207964265088*^9, 
   3.9672079651823287`*^9}},ExpressionUUID->"6a36dda6-3a60-4b71-81f4-\
f4c66e6830b2"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"strLen", "=", 
   RowBox[{"Max", "[", 
    RowBox[{"13", ",", 
     RowBox[{
      RowBox[{"Max", "[", 
       RowBox[{"StringLength", "[", "FuncLabels", "]"}], "]"}], "+", "1"}]}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"formatEntry", "[", "e_", "]"}], ":=", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"NumberQ", "[", "e", "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"StringPadRight", "[", 
      RowBox[{
       RowBox[{"ToString", "[", 
        RowBox[{"NumberForm", "[", 
         RowBox[{
          RowBox[{"N", "[", "e", "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"6", ",", "4"}], "}"}]}], "]"}], "]"}], ",", "strLen"}], 
      "]"}], ",", 
     RowBox[{"(*", 
      RowBox[{
       RowBox[{"numbers", ":", 
        RowBox[{"2", " ", "decimals"}]}], ",", "padded"}], "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"StringPadRight", "[", 
      RowBox[{
       RowBox[{"ToString", "[", "e", "]"}], ",", "strLen"}], "]"}]}], 
    "                        ", 
    RowBox[{"(*", 
     RowBox[{"strings", " ", "padded"}], "*)"}], "\[IndentingNewLine]", 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"For", "[", 
  RowBox[{
   RowBox[{"i", "=", "1"}], ",", 
   RowBox[{"i", "\[LessEqual]", 
    RowBox[{"Length", "[", "FuncLabels", "]"}]}], ",", 
   RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"formattedTable", "=", 
     RowBox[{"StringRiffle", "[", 
      RowBox[{
       RowBox[{"Map", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"StringJoin", "@@", 
           RowBox[{"(", 
            RowBox[{"formatEntry", "/@", "#"}], ")"}]}], "&"}], ",", 
         RowBox[{"ResTable", "[", 
          RowBox[{"[", "i", "]"}], "]"}]}], "]"}], ",", "\"\<\\n\>\""}], 
      "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"filename", "=", 
     RowBox[{"\"\<Weights_\>\"", "<>", 
      RowBox[{"FuncLabels", "[", 
       RowBox[{"[", "i", "]"}], "]"}], "<>", "\"\<.txt\>\""}]}], ";"}]}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Export", "[", 
    RowBox[{"filename", ",", "formattedTable", ",", "\"\<Text\>\""}], "]"}], 
   "*)"}], "\[IndentingNewLine]", "]"}]}], "Input",
 CellChangeTimes->{{3.9565849939465494`*^9, 3.9565850780473433`*^9}, {
   3.956596340763183*^9, 3.956596343363929*^9}, 3.956598514032343*^9, 
   3.956598840479012*^9, 3.9566891136458855`*^9, {3.956790694105418*^9, 
   3.956790694346979*^9}, {3.9573534166888995`*^9, 3.957353417552085*^9}, {
   3.96574937507189*^9, 3.965749467678198*^9}, {3.9657500067391043`*^9, 
   3.965750031042365*^9}, {3.9662954007488623`*^9, 3.9662954031507874`*^9}, {
   3.9662954806974373`*^9, 3.966295562759544*^9}, {3.9663548700664177`*^9, 
   3.9663548701275234`*^9}, {3.966354904228454*^9, 3.966354917570512*^9}, {
   3.9663549518065805`*^9, 3.966354953974055*^9}, {3.966355020494075*^9, 
   3.966355070211819*^9}, {3.9663552610262003`*^9, 3.966355293195022*^9}, {
   3.9663553510643854`*^9, 3.9663553527303753`*^9}, {3.966364889674554*^9, 
   3.966364892061166*^9}, {3.966975404312511*^9, 3.966975406635338*^9}, 
   3.970998781965349*^9},
 CellLabel->
  "In[323]:=",ExpressionUUID->"c6f30dcf-3117-4f46-b8b9-923b043d3d14"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"strLen", "=", 
   RowBox[{"Max", "[", 
    RowBox[{"13", ",", 
     RowBox[{
      RowBox[{"Length", "[", "MeanResTableName", "]"}], "+", "1"}]}], "]"}]}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"formatEntry", "[", "e_", "]"}], ":=", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"NumberQ", "[", "e", "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"StringPadRight", "[", 
      RowBox[{
       RowBox[{"ToString", "[", 
        RowBox[{"NumberForm", "[", 
         RowBox[{
          RowBox[{"N", "[", "e", "]"}], ",", "3"}], "]"}], "]"}], ",", 
       "strLen"}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"StringPadRight", "[", 
      RowBox[{
       RowBox[{"ToString", "[", "e", "]"}], ",", "strLen"}], "]"}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"formattedTable", "=", 
   RowBox[{"StringRiffle", "[", 
    RowBox[{
     RowBox[{"Map", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"StringJoin", "@@", 
         RowBox[{"(", 
          RowBox[{"formatEntry", "/@", "#"}], ")"}]}], "&"}], ",", 
       "MeanResTable"}], "]"}], ",", "\"\<\\n\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"filename", "=", 
   RowBox[{
   "\"\<Weights_\>\"", "<>", "MeanResTableName", "<>", "\"\<.txt\>\""}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{"filename", ",", "formattedTable", ",", "\"\<Text\>\""}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9565849939465494`*^9, 3.9565850780473433`*^9}, {
   3.956596340763183*^9, 3.956596343363929*^9}, 3.956598514032343*^9, 
   3.956598840479012*^9, 3.9566891136458855`*^9, {3.956790694105418*^9, 
   3.956790694346979*^9}, {3.9573534166888995`*^9, 3.957353417552085*^9}, {
   3.96574937507189*^9, 3.965749467678198*^9}, {3.9657500067391043`*^9, 
   3.965750031042365*^9}, {3.9662954007488623`*^9, 3.9662954031507874`*^9}, {
   3.9662954806974373`*^9, 3.966295562759544*^9}, {3.9663548700664177`*^9, 
   3.9663548701275234`*^9}, {3.966354904228454*^9, 3.966354917570512*^9}, {
   3.9663549518065805`*^9, 3.966354953974055*^9}, {3.966355020494075*^9, 
   3.966355070211819*^9}, {3.9663552610262003`*^9, 3.966355293195022*^9}, {
   3.9663553510643854`*^9, 3.9663553527303753`*^9}, {3.966364889674554*^9, 
   3.966364892061166*^9}, {3.9669752885264416`*^9, 3.966975317473669*^9}, {
   3.966975397407832*^9, 3.9669754006702213`*^9}, 3.970998780608775*^9, {
   3.9722332905787735`*^9, 3.972233324914721*^9}, {3.9722333554706383`*^9, 
   3.9722333556676826`*^9}},
 CellLabel->
  "In[326]:=",ExpressionUUID->"4dfbd928-fcd4-4c54-a3e8-3859ce0f58f0"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"strLen", "=", 
   RowBox[{"Max", "[", 
    RowBox[{"13", ",", 
     RowBox[{
      RowBox[{"Length", "[", "MeanResTableName", "]"}], "+", "1"}]}], "]"}]}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"formatEntry", "[", "e_", "]"}], ":=", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"NumberQ", "[", "e", "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"StringPadRight", "[", 
      RowBox[{
       RowBox[{"ToString", "[", 
        RowBox[{"NumberForm", "[", 
         RowBox[{
          RowBox[{"N", "[", "e", "]"}], ",", "3"}], "]"}], "]"}], ",", 
       "strLen"}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"StringPadRight", "[", 
      RowBox[{
       RowBox[{"ToString", "[", "e", "]"}], ",", "strLen"}], "]"}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"formattedTable", "=", 
   RowBox[{"StringRiffle", "[", 
    RowBox[{
     RowBox[{"Map", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"StringJoin", "@@", 
         RowBox[{"(", 
          RowBox[{"formatEntry", "/@", "#"}], ")"}]}], "&"}], ",", 
       "MeanMADTable"}], "]"}], ",", "\"\<\\n\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"filename", "=", 
   RowBox[{
   "\"\<MeanMAD_\>\"", "<>", "MeanResTableName", "<>", "\"\<.txt\>\""}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{"filename", ",", "formattedTable", ",", "\"\<Text\>\""}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9565849939465494`*^9, 3.9565850780473433`*^9}, {
   3.956596340763183*^9, 3.956596343363929*^9}, 3.956598514032343*^9, 
   3.956598840479012*^9, 3.9566891136458855`*^9, {3.956790694105418*^9, 
   3.956790694346979*^9}, {3.9573534166888995`*^9, 3.957353417552085*^9}, {
   3.96574937507189*^9, 3.965749467678198*^9}, {3.9657500067391043`*^9, 
   3.965750031042365*^9}, {3.9662954007488623`*^9, 3.9662954031507874`*^9}, {
   3.9662954806974373`*^9, 3.966295562759544*^9}, {3.9663548700664177`*^9, 
   3.9663548701275234`*^9}, {3.966354904228454*^9, 3.966354917570512*^9}, {
   3.9663549518065805`*^9, 3.966354953974055*^9}, {3.966355020494075*^9, 
   3.966355070211819*^9}, {3.9663552610262003`*^9, 3.966355293195022*^9}, {
   3.9663553510643854`*^9, 3.9663553527303753`*^9}, {3.966364889674554*^9, 
   3.966364892061166*^9}, {3.9669752885264416`*^9, 3.966975317473669*^9}, {
   3.966975397407832*^9, 3.9669754006702213`*^9}, {3.9672067026319017`*^9, 
   3.967206713038506*^9}, {3.967206756978309*^9, 3.967206774460598*^9}, 
   3.9709987783377805`*^9, {3.972233301681445*^9, 3.9722333971280804`*^9}},
 CellLabel->
  "In[331]:=",ExpressionUUID->"b19cf5b1-ab27-4d16-9db9-d245d684e3db"],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.9722332287297626`*^9, 3.9722332462747297`*^9}, 
   3.9722332833251286`*^9},
 CellLabel->
  "In[336]:=",ExpressionUUID->"7e7b99b1-878a-4c9e-be75-b6267d9bff6e"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Analyzing % Weights from Weights_D3andXDM.txt, per category ", "Section",
 CellChangeTimes->{{3.9660295956517177`*^9, 
  3.966029629955721*^9}},ExpressionUUID->"4b0ee74b-08c7-4118-9b79-\
92208da9b289"],

Cell[BoxData[
 RowBox[{
  RowBox[{"NewData", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "\"\< AL2X6     \>\"", ",", "6", ",", "2.5", ",", "0.82", ",", "0.17", 
       ",", "0.41", ",", "1.21"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\< ALK8      \>\"", ",", "8", ",", "1.0", ",", "4.36", ",", "0.69", 
       ",", "1.25", ",", "2.55"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\< ALKBDE10  \>\"", ",", "10", ",", "1.0", ",", "0.31", ",", "0.38", 
       ",", "0.55", ",", "1.82"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\< BH76RC    \>\"", ",", "30", ",", "2.5", ",", "1.23", ",", "2.14", 
       ",", "2.06", ",", "1.80"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\< DC13      \>\"", ",", "13", ",", "0.5", ",", "4.22", ",", "1.24", 
       ",", "1.38", ",", "1.24"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\< DIPCS10   \>\"", ",", "10", ",", "1.0", ",", "0.19", ",", "0.04", 
       ",", "0.05", ",", "1.11"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\< FH51      \>\"", ",", "51", ",", "2.5", ",", "1.30", ",", "2.66", 
       ",", "2.55", ",", "1.91"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\< G21EA     \>\"", ",", "25", ",", "2.5", ",", "1.44", ",", "1.33", 
       ",", "1.28", ",", "2.11"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\< G21IP     \>\"", ",", "36", ",", "2.5", ",", "0.18", ",", "0.31", 
       ",", "0.30", ",", "2.64"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\< G2RC      \>\"", ",", "25", ",", "1.0", ",", "2.64", ",", "1.60", 
       ",", "1.54", ",", "1.55"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\< HEAVYSB11 \>\"", ",", "11", ",", "2.5", ",", "1.32", ",", "0.31", 
       ",", "0.41", ",", "1.94"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\< NBPRC     \>\"", ",", "12", ",", "2.5", ",", "1.17", ",", "0.63", 
       ",", "0.76", ",", "1.71"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\< PA26      \>\"", ",", "26", ",", "2.5", ",", "0.13", ",", "0.23", 
       ",", "0.22", ",", "1.95"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\< RC21      \>\"", ",", "21", ",", "1.0", ",", "2.10", ",", "1.54", 
       ",", "1.47", ",", "1.23"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\< SIE4x4    \>\"", ",", "16", ",", "0.5", ",", "6.62", ",", "3.90", 
       ",", "3.74", ",", "1.94"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\< TAUT15    \>\"", ",", "15", ",", "5.0", ",", "5.04", ",", "3.08", 
       ",", "2.96", ",", "1.48"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\< W4\[Hyphen]11     \>\"", ",", "140", ",", "1.0", ",", "0.40", ",",
        "2.29", ",", "2.20", ",", "2.37"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\< YBDE18    \>\"", ",", "18", ",", "2.5", ",", "1.59", ",", "0.72", 
       ",", "0.69", ",", "2.33"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\< BSR36     \>\"", ",", "36", ",", "2.5", ",", "1.30", ",", "3.58", 
       ",", "3.44", ",", "1.90"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\< C60ISO    \>\"", ",", "9", ",", "0.5", ",", "0.38", ",", "0.43", 
       ",", "0.70", ",", "1.12"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\< CDIE20    \>\"", ",", "20", ",", "5.0", ",", "5.10", ",", "3.12", 
       ",", "2.99", ",", "1.49"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\< DARC      \>\"", ",", "14", ",", "1.0", ",", "2.38", ",", "1.27", 
       ",", "1.31", ",", "1.39"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\< ISO34     \>\"", ",", "34", ",", "5.0", ",", "0.69", ",", "1.99", 
       ",", "1.91", ",", "2.01"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\< ISOL24    \>\"", ",", "24", ",", "2.5", ",", "1.73", ",", "2.35", 
       ",", "2.25", ",", "2.53"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\< MB16\[Hyphen]43   \>\"", ",", "43", ",", "0.5", ",", "0.94", ",", 
       "1.07", ",", "1.02", ",", "2.74"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\< PArel     \>\"", ",", "20", ",", "5.0", ",", "5.79", ",", "3.10", 
       ",", "2.98", ",", "1.69"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\< RSE43     \>\"", ",", "43", ",", "5.0", ",", "0.65", ",", "4.58", 
       ",", "4.40", ",", "1.91"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\< BH76      \>\"", ",", "76", ",", "2.5", ",", "2.15", ",", "10.90",
        ",", "10.45", ",", "3.15"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\< BHDIV10   \>\"", ",", "10", ",", "1.0", ",", "2.01", ",", "0.55", 
       ",", "0.79", ",", "1.18"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\< BHPERI    \>\"", ",", "26", ",", "2.5", ",", "1.59", ",", "2.46", 
       ",", "2.36", ",", "2.33"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\< BHROT27   \>\"", ",", "27", ",", "10.0", ",", "2.30", ",", "1.23",
        ",", "1.18", ",", "1.35"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\< INV24     \>\"", ",", "24", ",", "5.0", ",", "0.78", ",", "0.73", 
       ",", "0.70", ",", "2.28"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\< PX13      \>\"", ",", "13", ",", "1.0", ",", "2.65", ",", "1.28", 
       ",", "1.42", ",", "1.55"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\< WCPT18    \>\"", ",", "18", ",", "1.0", ",", "2.01", ",", "1.28", 
       ",", "1.23", ",", "1.18"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\< ADIM6     \>\"", ",", "6", ",", "25.0", ",", "0.73", ",", "0.16", 
       ",", "0.39", ",", "1.07"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\< AHB21     \>\"", ",", "21", ",", "5.0", ",", "0.46", ",", "0.54", 
       ",", "0.52", ",", "1.36"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\< CARBHB12  \>\"", ",", "12", ",", "5.0", ",", "4.87", ",", "1.20", 
       ",", "1.45", ",", "1.43"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\< CHB6      \>\"", ",", "6", ",", "5.0", ",", "0.65", ",", "0.18", 
       ",", "0.44", ",", "1.92"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\< HAL59     \>\"", ",", "59", ",", "10.0", ",", "2.75", ",", "4.38",
        ",", "4.21", ",", "1.61"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\< HEAVY28   \>\"", ",", "28", ",", "25.0", ",", "1.25", ",", "3.52",
        ",", "3.37", ",", "1.84"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\< IL16      \>\"", ",", "16", ",", "10.0", ",", "0.03", ",", "0.05",
        ",", "0.05", ",", "1.55"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\< PNICO23   \>\"", ",", "23", ",", "10.0", ",", "2.79", ",", "1.87",
        ",", "1.79", ",", "1.63"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\< RG18      \>\"", ",", "18", ",", "50.0", ",", "0.50", ",", "1.91",
        ",", "1.83", ",", "1.45"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\< S22       \>\"", ",", "22", ",", "25.0", ",", "1.82", ",", "0.68",
        ",", "0.65", ",", "2.67"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\< S66       \>\"", ",", "66", ",", "25.0", ",", "1.38", ",", "2.07",
        ",", "1.98", ",", "2.02"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\< WATER27   \>\"", ",", "27", ",", "2.5", ",", "0.20", ",", "0.82", 
       ",", "0.79", ",", "2.92"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\< ACONF     \>\"", ",", "15", ",", "50.0", ",", "0.54", ",", "0.55",
        ",", "0.52", ",", "1.57"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\< Amino20x4 \>\"", ",", "80", ",", "25.0", ",", "1.29", ",", "5.26",
        ",", "5.05", ",", "1.89"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\< BUT14DIOL \>\"", ",", "64", ",", "25.0", ",", "1.22", ",", "3.45",
        ",", "3.31", ",", "1.78"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\< ICONF     \>\"", ",", "17", ",", "25.0", ",", "1.49", ",", "0.96",
        ",", "0.92", ",", "2.18"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\< IDISP     \>\"", ",", "6", ",", "2.5", ",", "1.28", ",", "0.67", 
       ",", "1.62", ",", "1.88"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\< MCONF     \>\"", ",", "51", ",", "25.0", ",", "1.32", ",", "1.68",
        ",", "1.61", ",", "1.93"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\< PCONF21   \>\"", ",", "18", ",", "10.0", ",", "3.35", ",", "4.63",
        ",", "4.44", ",", "1.96"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\< SCONF     \>\"", ",", "17", ",", "10.0", ",", "2.00", ",", "0.92",
        ",", "0.88", ",", "1.17"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\< UPU23     \>\"", ",", "23", ",", "10.0", ",", "2.57", ",", "1.28",
        ",", "1.23", ",", "1.51"}], "}"}]}], "\n", "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.9660292309009633`*^9, 3.966029230910066*^9}, 
   3.9660292887880435`*^9, 3.966029399287481*^9, 3.966029581521983*^9},
 CellLabel->
  "In[337]:=",ExpressionUUID->"c3eccff9-be66-40ef-b7a8-78774f6139a4"],

Cell[BoxData[{
 RowBox[{"MatrixForm", "[", 
  RowBox[{"NewData", "[", 
   RowBox[{"[", 
    RowBox[{"1", ";;", "18"}], "]"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"NumberForm", "[", 
  RowBox[{
   RowBox[{"Total", "[", 
    RowBox[{"NewData", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"1", ";;", "18"}], ",", 
       RowBox[{"2", ";;"}]}], "]"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"Infinity", ",", "2"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.966029296225071*^9, 3.966029317745101*^9}, {
  3.966029541217003*^9, 3.96602954470542*^9}, {3.9660297498117113`*^9, 
  3.9660297607417927`*^9}},
 CellLabel->
  "In[338]:=",ExpressionUUID->"7d369e2b-9706-4f7a-9d78-c086d28bbbab"],

Cell[BoxData[{
 RowBox[{"MatrixForm", "[", 
  RowBox[{"NewData", "[", 
   RowBox[{"[", 
    RowBox[{"19", ";;", "27"}], "]"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"NumberForm", "[", 
  RowBox[{
   RowBox[{"Total", "[", 
    RowBox[{"NewData", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"19", ";;", "27"}], ",", 
       RowBox[{"2", ";;"}]}], "]"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"Infinity", ",", "2"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.966029323068847*^9, 3.966029335798108*^9}, {
  3.966029405183241*^9, 3.966029408322234*^9}, {3.9660295380475707`*^9, 
  3.966029556097375*^9}, {3.966029748526994*^9, 3.96602975944818*^9}},
 CellLabel->
  "In[340]:=",ExpressionUUID->"f5d07d7a-2b55-4d9e-9346-108e2b546018"],

Cell[BoxData[{
 RowBox[{"MatrixForm", "[", 
  RowBox[{"NewData", "[", 
   RowBox[{"[", 
    RowBox[{"28", ";;", "34"}], "]"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"NumberForm", "[", 
  RowBox[{
   RowBox[{"Total", "[", 
    RowBox[{"NewData", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"28", ";;", "34"}], ",", 
       RowBox[{"2", ";;"}]}], "]"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"Infinity", ",", "2"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.9660293441754513`*^9, 3.9660293470854654`*^9}, {
  3.9660294127309637`*^9, 3.9660294154317923`*^9}, {3.9660295468117666`*^9, 
  3.966029551797411*^9}, {3.9660297188786697`*^9, 3.96602974081446*^9}},
 CellLabel->
  "In[342]:=",ExpressionUUID->"421ad3d3-4812-46d6-a330-d1e9c27ddc6f"],

Cell[BoxData[{
 RowBox[{"MatrixForm", "[", 
  RowBox[{"NewData", "[", 
   RowBox[{"[", 
    RowBox[{"35", ";;", "46"}], "]"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"NumberForm", "[", 
  RowBox[{
   RowBox[{"Total", "[", 
    RowBox[{"NewData", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"35", ";;", "46"}], ",", 
       RowBox[{"2", ";;"}]}], "]"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"Infinity", ",", "2"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.9660293522705946`*^9, 3.9660293551151533`*^9}, {
  3.9660294202682447`*^9, 3.9660294276843524`*^9}, {3.9660295602353086`*^9, 
  3.9660295649074492`*^9}, {3.966029753286702*^9, 3.966029758024913*^9}},
 CellLabel->
  "In[344]:=",ExpressionUUID->"6ff8dbc2-6bee-4454-b7ff-bf610bc490f7"],

Cell[BoxData[{
 RowBox[{"MatrixForm", "[", 
  RowBox[{"NewData", "[", 
   RowBox[{"[", 
    RowBox[{"47", ";;", "55"}], "]"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"NumberForm", "[", 
  RowBox[{
   RowBox[{"Total", "[", 
    RowBox[{"NewData", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"47", ";;", "55"}], ",", 
       RowBox[{"2", ";;"}]}], "]"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"Infinity", ",", "2"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.9660293632381644`*^9, 3.966029367272662*^9}, {
  3.966029431380104*^9, 3.966029433839263*^9}, {3.966029566744452*^9, 
  3.966029570720458*^9}, {3.966029751695699*^9, 3.966029763174717*^9}},
 CellLabel->
  "In[346]:=",ExpressionUUID->"ee4f7cc0-8431-4a0b-a5d8-9df0ef1076cd"],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"NumberForm", "[", 
   RowBox[{
    RowBox[{"Total", "[", 
     RowBox[{"NewData", "[", 
      RowBox[{"[", 
       RowBox[{
        RowBox[{"1", ";;", "55"}], ",", 
        RowBox[{"2", ";;"}]}], "]"}], "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"Infinity", ",", "2"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.9660304024826612`*^9, 3.9660304065614867`*^9}},
 CellLabel->
  "In[348]:=",ExpressionUUID->"96d5d112-424a-4c43-bc70-ac50cfff4001"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{2544, 1341},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification:>1.4 Inherited,
FrontEndVersion->"12.1 for Microsoft Windows (64-bit) (June 19, 2020)",
StyleDefinitions->"ReverseColor.nb",
ExpressionUUID->"2a3c3ac9-52aa-4ee0-aa88-b17a04d014a3"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 2514, 34, 135, "Title",ExpressionUUID->"e8b4790c-cfdb-4f8c-a2f6-82c285868c97"],
Cell[3097, 58, 2203, 34, 117, "Subtitle",ExpressionUUID->"a0191fbe-e215-48a4-8c4f-f26ba47d6f9a"],
Cell[CellGroupData[{
Cell[5325, 96, 356, 6, 92, "Section",ExpressionUUID->"507e86bc-9f42-4233-b3d9-06883a36e4ae"],
Cell[CellGroupData[{
Cell[5706, 106, 303, 5, 75, "Subsection",ExpressionUUID->"d91f3b2c-0440-4cb2-8689-d2b2fefc28b1"],
Cell[6012, 113, 227, 4, 40, "Input",ExpressionUUID->"868b0a4a-0a23-4b4d-8e6d-5e70e42b84a2"],
Cell[6242, 119, 274, 6, 40, "Input",ExpressionUUID->"12acc223-ce39-4b57-946d-7c24fa7087a0"],
Cell[6519, 127, 200, 4, 40, "Input",ExpressionUUID->"80403d44-4f07-4dd5-a191-c73917630ec8"],
Cell[6722, 133, 224, 4, 40, "Input",ExpressionUUID->"58b1b704-9bb1-4e0e-ae8b-3f5f82a2e7e6"],
Cell[6949, 139, 27745, 690, 237, "Input",ExpressionUUID->"c473ffd2-3bc3-43c0-9ec9-4c3420a42063"],
Cell[34697, 831, 467, 14, 40, "Input",ExpressionUUID->"6e1294b1-2f04-4d48-b2d4-8223398a74bf"],
Cell[35167, 847, 158, 4, 40, "Input",ExpressionUUID->"7daf2119-60dd-464d-8c97-410f7c3fe130"],
Cell[35328, 853, 312, 7, 69, "Input",ExpressionUUID->"83646cc2-e906-45ba-a0be-430f1b0c4ca2"],
Cell[35643, 862, 341, 8, 99, "Text",ExpressionUUID->"249fb4f0-36fe-464f-b3c7-f013db6da048"],
Cell[35987, 872, 360, 8, 69, "Input",ExpressionUUID->"5d50b979-e5fe-4a60-90a6-ae3230ea3697"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[36396, 886, 408, 6, 92, "Section",ExpressionUUID->"c185520c-8497-43ef-aaa0-0a1ab0ee7af6"],
Cell[36807, 894, 3221, 53, 97, "Input",ExpressionUUID->"ed90bb2e-a068-4f77-8983-114504f99343"],
Cell[40031, 949, 3373, 65, 153, "Input",ExpressionUUID->"94823ce5-4b35-4f02-9bc2-98c3b8acc3a2"],
Cell[43407, 1016, 478, 10, 99, "Text",ExpressionUUID->"ec72a229-5317-4662-9e91-dc243846cf0f"],
Cell[43888, 1028, 647, 17, 97, "Input",ExpressionUUID->"6ab770a1-01ea-446b-9614-2d595ec31990"]
}, Open  ]],
Cell[CellGroupData[{
Cell[44572, 1050, 364, 6, 92, "Section",ExpressionUUID->"7f4f10e9-0978-4bf8-adf7-6fc4e0f89d6e"],
Cell[44939, 1058, 680, 14, 40, "Input",ExpressionUUID->"4b84ff37-d71d-4a27-83e1-d8c51373881d"],
Cell[45622, 1074, 567, 11, 40, "Input",ExpressionUUID->"29c7daa0-5949-4413-89fc-23b6e623598a"],
Cell[46192, 1087, 3073, 77, 181, "Input",ExpressionUUID->"dedf4a36-1d7c-43f2-8485-101296f0c64f"],
Cell[49268, 1166, 680, 14, 40, "Input",ExpressionUUID->"ffcb47ad-7076-4ba7-a4b8-d6e3d3f01c70"],
Cell[49951, 1182, 796, 17, 40, "Input",ExpressionUUID->"06f67035-d852-4af8-917b-f4d5c279cee6"],
Cell[50750, 1201, 446, 11, 40, "Input",ExpressionUUID->"facbc342-edff-4602-a751-76a185644a2a"],
Cell[51199, 1214, 443, 11, 40, "Input",ExpressionUUID->"38b32406-490e-4614-bdbc-89bc04dabd99"],
Cell[51645, 1227, 7320, 150, 1665, "Input",ExpressionUUID->"9645ac04-2536-413a-8090-f8824ee42bcb"]
}, Open  ]],
Cell[CellGroupData[{
Cell[59002, 1382, 649, 10, 92, "Section",ExpressionUUID->"4da85bcb-f3a9-43a4-b946-5d7a514eed39"],
Cell[59654, 1394, 252, 6, 40, "Input",ExpressionUUID->"4f3f0d68-fed8-479e-9bfa-31712ef16600"]
}, Open  ]],
Cell[CellGroupData[{
Cell[59943, 1405, 546, 8, 92, "Section",ExpressionUUID->"7871f13e-07da-4b6b-bf8e-7a783f37bea5"],
Cell[60492, 1415, 1010, 23, 69, "Input",ExpressionUUID->"bee6cb48-54d3-47d0-ad65-c8a20c618a7f"],
Cell[61505, 1440, 702, 13, 102, "Input",ExpressionUUID->"ae5033bc-8804-4373-a9a2-c77bd6940b1b"],
Cell[62210, 1455, 1179, 26, 102, "Input",ExpressionUUID->"b2ef92c2-ad03-47f9-812c-0a0716c604d7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[63426, 1486, 546, 8, 92, "Section",ExpressionUUID->"db70bf0f-cfe3-4afa-b44e-0a8f07be726e"],
Cell[63975, 1496, 1001, 25, 71, "Input",ExpressionUUID->"0a829db2-20ff-4a26-b2cd-761041946aa4"],
Cell[64979, 1523, 678, 13, 102, "Input",ExpressionUUID->"4aea3a86-1bf4-4735-a436-1b148255cae0"],
Cell[65660, 1538, 1088, 26, 69, "Input",ExpressionUUID->"92377b9b-434c-4da6-8dca-feb1dc87a8c3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[66785, 1569, 574, 9, 92, "Section",ExpressionUUID->"bf8b89bf-d531-412b-a195-6a08785e36a3"],
Cell[67362, 1580, 1227, 30, 71, "Input",ExpressionUUID->"03ff58bc-fb1c-402c-95a5-21e2aee66941"],
Cell[68592, 1612, 700, 13, 102, "Input",ExpressionUUID->"c25264a6-0f79-4b51-a3ee-c3ed9cb98b65"],
Cell[69295, 1627, 1080, 25, 102, "Input",ExpressionUUID->"151d3dda-3e77-41e9-ba40-352cfcadff54"]
}, Open  ]],
Cell[CellGroupData[{
Cell[70412, 1657, 648, 10, 92, "Section",ExpressionUUID->"beab751f-fa93-4ffe-9246-6098248ae250"],
Cell[71063, 1669, 1070, 24, 69, "Input",ExpressionUUID->"802a77bc-483f-4113-8f89-d8eef16b0522"],
Cell[72136, 1695, 978, 18, 102, "Input",ExpressionUUID->"7911b51d-8ff0-42b7-ad82-ec5a5b82c588"],
Cell[73117, 1715, 1207, 27, 102, "Input",ExpressionUUID->"ecc6d8f2-c788-4805-a289-49304b3578d7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[74361, 1747, 609, 9, 92, "Section",ExpressionUUID->"a0ea6ef2-656c-49f0-a703-67d30c1e7a1b"],
Cell[74973, 1758, 567, 16, 40, "Input",ExpressionUUID->"e8936137-c0b4-4cd6-adc0-97eb788d5b67"],
Cell[75543, 1776, 686, 16, 40, "Input",ExpressionUUID->"31a47b58-3b67-4a4e-be52-2a8efd9bb342"],
Cell[76232, 1794, 5290, 121, 405, "Input",ExpressionUUID->"2e776a5e-4705-4f21-b17e-2a8735bcbf9b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[81559, 1920, 699, 10, 92, "Section",ExpressionUUID->"57ef0086-fa88-43ff-9c95-25ea55cc7849"],
Cell[82261, 1932, 1199, 26, 69, "Input",ExpressionUUID->"74a7e990-b832-4d9b-b2be-b0eb80297549"],
Cell[83463, 1960, 1034, 18, 102, "Input",ExpressionUUID->"4940d971-2e8b-4096-a69f-44ee471c6f81"],
Cell[84500, 1980, 1265, 27, 102, "Input",ExpressionUUID->"25295b73-2b6f-4471-9e0f-2f976645c311"]
}, Open  ]],
Cell[CellGroupData[{
Cell[85802, 2012, 697, 10, 92, "Section",ExpressionUUID->"7facfb5e-9fdc-4799-94d9-8889877db090"],
Cell[86502, 2024, 1249, 27, 69, "Input",ExpressionUUID->"2d788915-6ce1-4328-bfae-696cc56a949c"],
Cell[87754, 2053, 1031, 18, 102, "Input",ExpressionUUID->"7bb1397b-600c-4c0e-84ee-23cb8da756d9"],
Cell[88788, 2073, 1369, 29, 102, "Input",ExpressionUUID->"3daaab03-e338-4349-a714-1453cd30eab8"],
Cell[90160, 2104, 329, 10, 13, "Text",ExpressionUUID->"6dfa2fe8-552e-4b3e-ab06-e01d23445460"]
}, Open  ]],
Cell[CellGroupData[{
Cell[90526, 2119, 232, 4, 92, "Section",ExpressionUUID->"cd2794b2-c16f-4905-a905-ef8838efe782"],
Cell[90761, 2125, 4508, 106, 637, "Text",ExpressionUUID->"3be147b5-bf8c-45cc-adc0-ab17ff855162"],
Cell[CellGroupData[{
Cell[95294, 2235, 234, 4, 62, "Subsubsection",ExpressionUUID->"84e1b095-6b84-4c2a-b947-ad292a716654"],
Cell[95531, 2241, 322, 8, 40, "Input",ExpressionUUID->"21706dae-47ee-4f0f-bf32-c633d3bb1a7c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[95890, 2254, 303, 6, 62, "Subsubsection",ExpressionUUID->"dbf9a895-0a9d-4973-939e-e19bc9e94b88"],
Cell[96196, 2262, 1267, 31, 69, "Input",ExpressionUUID->"dad215c5-06a1-4174-a886-274d1dcc7656"]
}, Open  ]],
Cell[CellGroupData[{
Cell[97500, 2298, 265, 6, 62, "Subsubsection",ExpressionUUID->"34cbaf0a-b8a3-4b66-b5e7-9c51b86c5062"],
Cell[97768, 2306, 468, 12, 40, "Input",ExpressionUUID->"adab1a58-2501-4d45-b860-14c98e31a2f6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[98273, 2323, 255, 6, 62, "Subsubsection",ExpressionUUID->"49c5cc06-d934-4dd4-ba48-02964d06b36a"],
Cell[98531, 2331, 1103, 23, 69, "Input",ExpressionUUID->"beef4b99-2308-4678-9287-15ad4f3ef01b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[99671, 2359, 303, 6, 62, "Subsubsection",ExpressionUUID->"10ae4d5f-3cf0-4599-8547-4ff759742960"],
Cell[99977, 2367, 488, 10, 40, "Input",ExpressionUUID->"a15ebd50-47d6-4c82-878a-a832863e577b"],
Cell[100468, 2379, 637, 16, 40, "Input",ExpressionUUID->"31c46bcf-6fff-403b-a907-f10a7ff6f751"]
}, Open  ]],
Cell[CellGroupData[{
Cell[101142, 2400, 351, 7, 62, "Subsubsection",ExpressionUUID->"91ea4b46-ff8d-483e-8e90-0df52ca55b91"],
Cell[101496, 2409, 1289, 26, 69, "Input",ExpressionUUID->"4c64fcab-55f2-4f8f-8eb0-ac8094e39f51"]
}, Open  ]],
Cell[CellGroupData[{
Cell[102822, 2440, 366, 7, 62, "Subsubsection",ExpressionUUID->"f0a58fae-093b-4eeb-bc45-21f1609d3810"],
Cell[103191, 2449, 542, 14, 40, "Input",ExpressionUUID->"64e8d5cd-fc46-4d21-90c0-04e4a524c14f"],
Cell[103736, 2465, 329, 10, 13, "Text",ExpressionUUID->"2da552ca-0551-4474-bf31-607d294f0b8c"],
Cell[104068, 2477, 329, 10, 13, "Text",ExpressionUUID->"83ff1077-6eab-4455-82b1-bb5db3bae2cb"],
Cell[104400, 2489, 329, 10, 13, "Text",ExpressionUUID->"0985abee-ff52-4942-b200-e4a27d2e5df9"],
Cell[104732, 2501, 3958, 98, 349, "Input",ExpressionUUID->"64d01119-966b-4469-ae29-0be1c0c0bd3d"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[108739, 2605, 819, 12, 92, "Section",ExpressionUUID->"b4c4a423-bbfe-463a-a517-31f584cfedf8"],
Cell[109561, 2619, 4187, 89, 377, "Input",ExpressionUUID->"1d492bbb-519d-448e-8b4d-e35ae87113ec"],
Cell[113751, 2710, 485, 12, 40, "Input",ExpressionUUID->"b556cd31-8a9a-4c83-8101-558e1d0c3bc5"],
Cell[114239, 2724, 2647, 60, 377, "Input",ExpressionUUID->"5d8f053c-6016-411f-9700-de68f807d3db"]
}, Open  ]],
Cell[CellGroupData[{
Cell[116923, 2789, 235, 4, 92, "Section",ExpressionUUID->"3c20ba57-ca78-4882-aef1-8c77fbca52a6"],
Cell[117161, 2795, 465, 9, 40, "Input",ExpressionUUID->"48fd4b75-0cd8-4fc0-91e7-ab03b2387439"],
Cell[117629, 2806, 286, 7, 40, "Input",ExpressionUUID->"0308a8d8-b7d5-4717-bd09-b7607819d232"]
}, Open  ]],
Cell[CellGroupData[{
Cell[117952, 2818, 645, 10, 92, "Section",ExpressionUUID->"6a36dda6-3a60-4b71-81f4-f4c66e6830b2"],
Cell[118600, 2830, 3239, 78, 293, "Input",ExpressionUUID->"c6f30dcf-3117-4f46-b8b9-923b043d3d14"],
Cell[121842, 2910, 2662, 61, 237, "Input",ExpressionUUID->"4dfbd928-fcd4-4c54-a3e8-3859ce0f58f0"],
Cell[124507, 2973, 2708, 61, 237, "Input",ExpressionUUID->"b19cf5b1-ab27-4d16-9db9-d245d684e3db"],
Cell[127218, 3036, 207, 4, 40, "Input",ExpressionUUID->"7e7b99b1-878a-4c9e-be75-b6267d9bff6e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[127462, 3045, 207, 3, 92, "Section",ExpressionUUID->"4b0ee74b-08c7-4118-9b79-92208da9b289"],
Cell[127672, 3050, 9216, 228, 433, "Input",ExpressionUUID->"c3eccff9-be66-40ef-b7a8-78774f6139a4"],
Cell[136891, 3280, 719, 19, 69, "Input",ExpressionUUID->"7d369e2b-9706-4f7a-9d78-c086d28bbbab"],
Cell[137613, 3301, 765, 19, 69, "Input",ExpressionUUID->"f5d07d7a-2b55-4d9e-9346-108e2b546018"],
Cell[138381, 3322, 775, 19, 69, "Input",ExpressionUUID->"421ad3d3-4812-46d6-a330-d1e9c27ddc6f"],
Cell[139159, 3343, 776, 19, 69, "Input",ExpressionUUID->"6ff8dbc2-6bee-4454-b7ff-bf610bc490f7"],
Cell[139938, 3364, 766, 19, 69, "Input",ExpressionUUID->"ee4f7cc0-8431-4a0b-a5d8-9df0ef1076cd"],
Cell[140707, 3385, 516, 14, 69, "Input",ExpressionUUID->"96d5d112-424a-4c43-bc70-ac50cfff4001"]
}, Open  ]]
}, Open  ]]
}
]
*)

