(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     87858,       2051]
NotebookOptionsPosition[     82300,       1964]
NotebookOutlinePosition[     82733,       1981]
CellTagsIndexPosition[     82690,       1978]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["GMTKN55_Weights_Generator", "Title",
 CellChangeTimes->{{3.797879013542491*^9, 3.7978790202757607`*^9}, {
   3.8015052504625587`*^9, 3.801505252496401*^9}, {3.801512705184127*^9, 
   3.8015127059220877`*^9}, {3.8080725810932217`*^9, 3.80807258204629*^9}, {
   3.808637638029217*^9, 3.8086376426386304`*^9}, {3.808709680167038*^9, 
   3.808709684544276*^9}, {3.8087097351836815`*^9, 3.8087097435221834`*^9}, {
   3.814413717951748*^9, 3.814413718885742*^9}, {3.8147473738509254`*^9, 
   3.8147473768747416`*^9}, 3.8150446257955523`*^9, {3.816019237760411*^9, 
   3.8160192392785177`*^9}, {3.816020446217802*^9, 3.816020450903527*^9}, {
   3.818495939948073*^9, 3.818495941442936*^9}, {3.829636393240244*^9, 
   3.8296363982133584`*^9}, {3.829662167077368*^9, 3.829662168066966*^9}, {
   3.830290616723291*^9, 3.830290621962493*^9}, 3.830334093976343*^9, {
   3.83053142396451*^9, 3.830531424436616*^9}, {3.8320259040356393`*^9, 
   3.8320259064634714`*^9}, 3.832026057084034*^9, {3.832081441488149*^9, 
   3.832081445322814*^9}, 3.832198496278219*^9, {3.8323781961193967`*^9, 
   3.832378196259062*^9}, 3.8326341699756026`*^9, 3.8329780717686853`*^9, {
   3.8333837529399967`*^9, 3.8333837549576917`*^9}, {3.8333839574939947`*^9, 
   3.8333839710519953`*^9}, {3.833460774852479*^9, 3.833460780573769*^9}, {
   3.8335704629830327`*^9, 3.8335704806594667`*^9}, {3.8349506466891456`*^9, 
   3.8349506508790555`*^9}, {3.835047535057335*^9, 3.8350475726522255`*^9}, 
   3.8354017196073704`*^9, {3.8375709542180567`*^9, 3.8375709554214764`*^9}, 
   3.837738812080212*^9, 3.8378375733744793`*^9, {3.8576774091232057`*^9, 
   3.8576774153285923`*^9}, {3.858971769112599*^9, 3.8589717711240635`*^9}, {
   3.8624362841347213`*^9, 3.8624362859687243`*^9}, 3.862697945675531*^9, 
   3.8627615174878263`*^9, 3.8627898394358177`*^9, {3.863894156558298*^9, 
   3.8638941577752056`*^9}, 3.864495398419282*^9, {3.8645970053795815`*^9, 
   3.8645970068616467`*^9}, {3.865115755382537*^9, 3.8651157554156113`*^9}, 
   3.865270778381764*^9, {3.8653781551983757`*^9, 3.8653781574402432`*^9}, {
   3.879945728987928*^9, 3.8799457308838224`*^9}, 3.879948841259983*^9, {
   3.879954952621377*^9, 3.8799549540039387`*^9}, {3.9169945911057253`*^9, 
   3.916994600427992*^9}, {3.9464137497845078`*^9, 3.9464137831407957`*^9}, {
   3.9565816680566916`*^9, 3.9565816694261208`*^9}, {3.965663540759808*^9, 
   3.965663541357286*^9}, {3.9672316583872604`*^9, 3.96723166088745*^9}, {
   3.967232864034952*^9, 
   3.9672328684566483`*^9}},ExpressionUUID->"e8b4790c-cfdb-4f8c-a2f6-\
82c285868c97"],

Cell["\<\
Determining relative weights of each subset in GMTKN55 for D3_10
Kyle Bryenton 2025-11-18
kyle.bryenton@dal.ca\
\>", "Subtitle",
 CellChangeTimes->{{3.8259515367016363`*^9, 3.8259515481457295`*^9}, {
   3.8296363555235453`*^9, 3.829636363592561*^9}, 3.8296622389748163`*^9, {
   3.829662280794858*^9, 3.829662291249787*^9}, {3.830787820642953*^9, 
   3.830787834013277*^9}, {3.8313045708485894`*^9, 3.831304580009624*^9}, {
   3.8320953423709135`*^9, 3.832095354313024*^9}, 3.83228206786744*^9, {
   3.832378168691453*^9, 3.8323781801034994`*^9}, {3.8324441920909348`*^9, 
   3.832444201710229*^9}, {3.8324487586160955`*^9, 3.8324487591250944`*^9}, {
   3.8324644988930817`*^9, 3.8324644993412466`*^9}, {3.8326212074053016`*^9, 
   3.8326212493946753`*^9}, {3.8326213426871696`*^9, 
   3.8326213436157703`*^9}, {3.8327878865164766`*^9, 
   3.8327878970555696`*^9}, {3.8329857637093697`*^9, 
   3.8329857637743607`*^9}, {3.8330068116486444`*^9, 3.83300681212364*^9}, {
   3.835034974308427*^9, 3.8350349754651814`*^9}, {3.835401713050891*^9, 
   3.8354017168877573`*^9}, {3.8377452905678244`*^9, 3.837745290803586*^9}, 
   3.85767756001378*^9, {3.862761510851385*^9, 3.8627615386924253`*^9}, {
   3.8799549564790955`*^9, 3.879954978202243*^9}, {3.916994603904445*^9, 
   3.916994630403599*^9}, {3.9464137585300026`*^9, 3.946413779941535*^9}, 
   3.946479347959099*^9, {3.9467726285809956`*^9, 3.946772638944997*^9}, {
   3.946842340906331*^9, 3.946842344383188*^9}, {3.9474581585062914`*^9, 
   3.947458160548786*^9}, {3.9556481265778255`*^9, 3.9556481435472155`*^9}, {
   3.9560759693215837`*^9, 3.9560759761951356`*^9}, {3.95658167368425*^9, 
   3.956581718767006*^9}, 3.9566872289770308`*^9, {3.9573531296370845`*^9, 
   3.9573531299721603`*^9}, {3.9656626633708715`*^9, 
   3.9656626648178864`*^9}, {3.9657529525646725`*^9, 3.965752955198642*^9}, 
   3.966028444926873*^9, {3.967231634009239*^9, 3.967231634068842*^9}, 
   3.967246865459241*^9, {3.971031240982812*^9, 3.9710312416429605`*^9}, {
   3.971031792880562*^9, 3.9710317951799974`*^9}, {3.97223639491713*^9, 
   3.972236397835792*^9}, {3.972395574888459*^9, 3.9723955749294686`*^9}, 
   3.9724267365930166`*^9},ExpressionUUID->"a0191fbe-e215-48a4-8c4f-\
f26ba47d6f9a"],

Cell[CellGroupData[{

Cell["Setup", "Section",
 CellChangeTimes->{{3.8159098859335394`*^9, 3.8159098936639137`*^9}, {
  3.816020473371563*^9, 3.8160204797198906`*^9}, {3.867287106187972*^9, 
  3.8672871084708767`*^9}, {3.9169979350764914`*^9, 3.9169979369826174`*^9}, {
  3.94641371084194*^9, 
  3.9464137468717747`*^9}},ExpressionUUID->"507e86bc-9f42-4233-b3d9-\
06883a36e4ae"],

Cell[CellGroupData[{

Cell["Preamble", "Subsection",
 CellChangeTimes->{{3.81602099620885*^9, 3.816021017466877*^9}, {
  3.817753674156437*^9, 3.8177536774024324`*^9}, {3.931883848284851*^9, 
  3.931883862152503*^9}, {3.931883956719234*^9, 
  3.9318839620598965`*^9}},ExpressionUUID->"d91f3b2c-0440-4cb2-8689-\
d2b2fefc28b1"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.881072780973341*^9, 3.8810727809817657`*^9}},
 CellLabel->
  "In[1056]:=",ExpressionUUID->"868b0a4a-0a23-4b4d-8e6d-5e70e42b84a2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.8808316853232927`*^9, 3.880831694714588*^9}},
 CellLabel->
  "In[1057]:=",ExpressionUUID->"12acc223-ce39-4b57-946d-7c24fa7087a0"],

Cell[BoxData[
 RowBox[{"<<", "MaTeX`"}]], "Input",
 CellChangeTimes->{{3.8374712078059144`*^9, 3.83747121171614*^9}},
 CellLabel->
  "In[1058]:=",ExpressionUUID->"80403d44-4f07-4dd5-a191-c73917630ec8"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MaTeX`\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.8374729714354944`*^9, 3.8374729714424963`*^9}},
 CellLabel->
  "In[1059]:=",ExpressionUUID->"58b1b704-9bb1-4e0e-ae8b-3f5f82a2e7e6"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Colours", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "6"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Colours", "[", 
    RowBox[{"[", "1", "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"RGBColor", "[", "\"\<#5A000F\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#7E0018\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#A40122\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#CD022D\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#F60239\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#FF6E3A\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#FFAC3B\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#FFDC3D\>\"", "]"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Colours", "[", 
    RowBox[{"[", "2", "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"RGBColor", "[", "\"\<#004002\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#005A01\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#007702\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#009503\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#00B408\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#00D302\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#00F407\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#AFFF2A\>\"", "]"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Colours", "[", 
    RowBox[{"[", "3", "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"RGBColor", "[", "\"\<#00306F\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#00489E\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#005FCC\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#0079FA\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#009FFA\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#00C2F9\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#00E5F8\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#7CFFFA\>\"", "]"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Colours", "[", 
    RowBox[{"[", "4", "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"RGBColor", "[", "\"\<#450270\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#65019F\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#8400CD\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#A700FC\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#DA00FD\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#FF3CFE\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#FF92FD\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#FFCCFE\>\"", "]"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Colours", "[", 
    RowBox[{"[", "5", "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"RGBColor", "[", "\"\<#560133\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#790149\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#940162\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#C7007C\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#EF0096\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#FF5AAF\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#FF9DC8\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#FFCFE2\>\"", "]"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Colours", "[", 
    RowBox[{"[", "6", "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"RGBColor", "[", "\"\<#003D30\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#005745\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#00735C\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#009175\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#00AF8E\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#00CBA7\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#00EBC1\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#86FFDE\>\"", "]"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Colour", "=", 
   RowBox[{"{", 
    RowBox[{
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0., 0.4745098039215686, 0.9803921568627451], 
           RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         DefaultBaseStyle->"ColorSwatchGraphics",
         Frame->True,
         FrameStyle->RGBColor[0., 0.31633986928104574`, 0.6535947712418301],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        StyleBox[
         RowBox[{"RGBColor", "[", 
           
           RowBox[{"0.`", ",", "0.4745098039215686`", ",", 
             "0.9803921568627451`"}], "]"}], NumberMarks -> False]],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = 
           RGBColor[0., 0.4745098039215686, 0.9803921568627451]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0., 0.4745098039215686, 0.9803921568627451],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[
           0.6431372549019608, 0.00392156862745098, 0.13333333333333333`], 
           RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         DefaultBaseStyle->"ColorSwatchGraphics",
         Frame->True,
         FrameStyle->RGBColor[
          0.42875816993464055`, 0.0026143790849673205`, 0.08888888888888889],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        StyleBox[
         RowBox[{"RGBColor", "[", 
           
           RowBox[{"0.6431372549019608`", ",", "0.00392156862745098`", ",", 
             "0.13333333333333333`"}], "]"}], NumberMarks -> False]],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = 
           RGBColor[
            0.6431372549019608, 0.00392156862745098, 0.13333333333333333`]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0.6431372549019608, 0.00392156862745098, 0.13333333333333333`],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0., 0.8274509803921568, 0.00784313725490196], 
           RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         DefaultBaseStyle->"ColorSwatchGraphics",
         Frame->True,
         FrameStyle->RGBColor[0., 0.5516339869281046, 0.005228758169934641],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        StyleBox[
         RowBox[{"RGBColor", "[", 
           
           RowBox[{"0.`", ",", "0.8274509803921568`", ",", 
             "0.00784313725490196`"}], "]"}], NumberMarks -> False]],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = 
           RGBColor[0., 0.8274509803921568, 0.00784313725490196]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0., 0.8274509803921568, 0.00784313725490196],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[
           0.27058823529411763`, 0.00784313725490196, 0.4392156862745098], 
           RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         DefaultBaseStyle->"ColorSwatchGraphics",
         Frame->True,
         FrameStyle->RGBColor[
          0.1803921568627451, 0.005228758169934641, 0.2928104575163399],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        StyleBox[
         RowBox[{"RGBColor", "[", 
           
           RowBox[{"0.27058823529411763`", ",", "0.00784313725490196`", ",", 
             "0.4392156862745098`"}], "]"}], NumberMarks -> False]],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = 
           RGBColor[
            0.27058823529411763`, 0.00784313725490196, 0.4392156862745098]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0.27058823529411763`, 0.00784313725490196, 0.4392156862745098],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0., 0.45098039215686275`, 0.3607843137254902], 
           RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         DefaultBaseStyle->"ColorSwatchGraphics",
         Frame->True,
         FrameStyle->RGBColor[0., 0.30065359477124187`, 0.24052287581699347`],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        StyleBox[
         RowBox[{"RGBColor", "[", 
           
           RowBox[{"0.`", ",", "0.45098039215686275`", ",", 
             "0.3607843137254902`"}], "]"}], NumberMarks -> False]],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = 
           RGBColor[0., 0.45098039215686275`, 0.3607843137254902]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0., 0.45098039215686275`, 0.3607843137254902],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1., 0.35294117647058826`, 0.6862745098039216], 
           RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         DefaultBaseStyle->"ColorSwatchGraphics",
         Frame->True,
         FrameStyle->RGBColor[
          0.6666666666666667, 0.23529411764705885`, 0.4575163398692811],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        StyleBox[
         RowBox[{"RGBColor", "[", 
           
           RowBox[{"1.`", ",", "0.35294117647058826`", ",", 
             "0.6862745098039216`"}], "]"}], NumberMarks -> False]],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = 
           RGBColor[1., 0.35294117647058826`, 0.6862745098039216]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1., 0.35294117647058826`, 0.6862745098039216],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1., 0.8627450980392157, 0.23921568627450981`], 
           RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         DefaultBaseStyle->"ColorSwatchGraphics",
         Frame->True,
         FrameStyle->RGBColor[
          0.6666666666666667, 0.5751633986928105, 0.15947712418300655`],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        StyleBox[
         RowBox[{"RGBColor", "[", 
           
           RowBox[{"1.`", ",", "0.8627450980392157`", ",", 
             "0.23921568627450981`"}], "]"}], NumberMarks -> False]],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = 
           RGBColor[1., 0.8627450980392157, 0.23921568627450981`]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1., 0.8627450980392157, 0.23921568627450981`],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0., 0.25098039215686274`, 0.00784313725490196], 
           RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         DefaultBaseStyle->"ColorSwatchGraphics",
         Frame->True,
         FrameStyle->RGBColor[0., 0.1673202614379085, 0.005228758169934641],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        StyleBox[
         RowBox[{"RGBColor", "[", 
           
           RowBox[{"0.`", ",", "0.25098039215686274`", ",", 
             "0.00784313725490196`"}], "]"}], NumberMarks -> False]],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = 
           RGBColor[0., 0.25098039215686274`, 0.00784313725490196]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0., 0.25098039215686274`, 0.00784313725490196],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0., 0.7607843137254902, 0.9764705882352941], 
           RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         DefaultBaseStyle->"ColorSwatchGraphics",
         Frame->True,
         FrameStyle->RGBColor[0., 0.5071895424836601, 0.6509803921568628],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        StyleBox[
         RowBox[{"RGBColor", "[", 
           
           RowBox[{"0.`", ",", "0.7607843137254902`", ",", 
             "0.9764705882352941`"}], "]"}], NumberMarks -> False]],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = 
           RGBColor[0., 0.7607843137254902, 0.9764705882352941]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0., 0.7607843137254902, 0.9764705882352941],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1., 0.8, 0.996078431372549], 
           RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         DefaultBaseStyle->"ColorSwatchGraphics",
         Frame->True,
         FrameStyle->RGBColor[
          0.6666666666666667, 0.5333333333333334, 0.6640522875816994],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        StyleBox[
         RowBox[{"RGBColor", "[", 
           RowBox[{"1.`", ",", "0.8`", ",", "0.996078431372549`"}], "]"}], 
         NumberMarks -> False]],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = 
           RGBColor[1., 0.8, 0.996078431372549]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1., 0.8, 0.996078431372549],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0.33725490196078434`, 0.00392156862745098, 0.2], 
           RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         DefaultBaseStyle->"ColorSwatchGraphics",
         Frame->True,
         FrameStyle->RGBColor[
          0.22483660130718958`, 0.0026143790849673205`, 0.13333333333333336`],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        StyleBox[
         RowBox[{"RGBColor", "[", 
           
           RowBox[{"0.33725490196078434`", ",", "0.00392156862745098`", ",", 
             "0.2`"}], "]"}], NumberMarks -> False]],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = 
           RGBColor[0.33725490196078434`, 0.00392156862745098, 0.2]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0.33725490196078434`, 0.00392156862745098, 0.2],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0.5254901960784314, 1., 0.8705882352941177], 
           RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         DefaultBaseStyle->"ColorSwatchGraphics",
         Frame->True,
         FrameStyle->RGBColor[
          0.35032679738562095`, 0.6666666666666667, 0.5803921568627451],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        StyleBox[
         RowBox[{"RGBColor", "[", 
           
           RowBox[{"0.5254901960784314`", ",", "1.`", ",", 
             "0.8705882352941177`"}], "]"}], NumberMarks -> False]],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = 
           RGBColor[0.5254901960784314, 1., 0.8705882352941177]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0.5254901960784314, 1., 0.8705882352941177],
      Editable->False,
      Selectable->False]}], "}"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.8599246348040857`*^9, 3.859924635591572*^9}, {
  3.8599246761099963`*^9, 3.85992468327722*^9}, {3.881709147033801*^9, 
  3.8817091501026683`*^9}, {3.9169945720697613`*^9, 3.916994574225131*^9}},
 CellLabel->
  "In[1060]:=",ExpressionUUID->"c473ffd2-3bc3-43c0-9ec9-4c3420a42063"],

Cell[BoxData[
 RowBox[{
  RowBox[{"tickFunc", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Charting`ScaledTicks", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Identity", ",", "Identity"}], "}"}], ",", 
       RowBox[{"TicksLength", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{".02", ",", ".01"}], "}"}]}]}], "]"}], "[", "##", "]"}], 
    "&"}]}], ";"}]], "Input",
 CellLabel->
  "In[1068]:=",ExpressionUUID->"6e1294b1-2f04-4d48-b2d4-8223398a74bf"],

Cell[BoxData[
 RowBox[{
  RowBox[{"rescale", "=", "2.0"}], ";"}]], "Input",
 CellLabel->
  "In[1069]:=",ExpressionUUID->"7daf2119-60dd-464d-8c97-410f7c3fe130"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ExportPDF", "=", "True"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ExportPNG", "=", "True"}], ";"}]}], "Input",
 CellChangeTimes->{{3.9560789513094893`*^9, 3.9560789601423674`*^9}},
 CellLabel->
  "In[1070]:=",ExpressionUUID->"83646cc2-e906-45ba-a0be-430f1b0c4ca2"],

Cell["\<\
Set the value to use for Mean[DeltaEBar]
False = Let it calculate Mean[DeltaEBar]
True = Use the fixed value entered on the following line\
\>", "Text",
 CellChangeTimes->{{3.9660259680032883`*^9, 3.966026005768263*^9}, {
  3.966026065395343*^9, 
  3.9660261408229403`*^9}},ExpressionUUID->"249fb4f0-36fe-464f-b3c7-\
f013db6da048"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"DEBfixed", "=", "True"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DEBfixedval", "=", "56.84"}], ";"}]}], "Input",
 CellChangeTimes->{{3.96602600814555*^9, 3.9660260491343393`*^9}, {
  3.966026087585389*^9, 3.966026153130679*^9}},
 CellLabel->
  "In[1072]:=",ExpressionUUID->"5d50b979-e5fe-4a60-90a6-ae3230ea3697"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Data Import", "Section",
 CellChangeTimes->{{3.8159098859335394`*^9, 3.8159098936639137`*^9}, {
  3.816020473371563*^9, 3.8160204797198906`*^9}, {3.867287106187972*^9, 
  3.8672871084708767`*^9}, {3.9169979350764914`*^9, 3.9169979369826174`*^9}, {
  3.94641371084194*^9, 3.946413712127342*^9}, {3.955648158000458*^9, 
  3.9556481583871193`*^9}},ExpressionUUID->"c185520c-8497-43ef-aaa0-\
0a1ab0ee7af6"],

Cell["\<\
DH24
r2SCANDH
xDSD
Zoo_Disp
Zoo_NoDisp\
\>", "Text",
 CellChangeTimes->{{3.9663554333366456`*^9, 3.9663554552572465`*^9}, {
   3.9710314695873423`*^9, 3.9710314703991656`*^9}, {3.972395910338113*^9, 
   3.97239591116129*^9}, 
   3.9724267417351727`*^9},ExpressionUUID->"5beff186-7c68-4284-bb22-\
bc532597d091"],

Cell[BoxData[{
 RowBox[{"inFiles", "=", 
  RowBox[{"FileNames", "[", 
   RowBox[{"{", "\"\<../04_GMTKN55_ANALYSIS_D3_10/DH24/DHyb/*.dat\>\"", "}"}],
    "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"inFiles", "=", 
    RowBox[{"{", 
     RowBox[{"inFiles", "[", 
      RowBox[{"[", "3", "]"}], "]"}], "}"}]}], "*)"}]}]}], "Input",
 CellChangeTimes->{{3.955648162362415*^9, 3.9556481758935704`*^9}, {
   3.9657488552668695`*^9, 3.9657488787582955`*^9}, {3.965748925806166*^9, 
   3.96574892683398*^9}, {3.965749481827896*^9, 3.965749482546893*^9}, {
   3.9657497448016953`*^9, 3.9657497453852763`*^9}, {3.965750043930236*^9, 
   3.965750051602558*^9}, {3.9657529932203693`*^9, 3.9657529976124525`*^9}, {
   3.9660262362912416`*^9, 3.966026242106614*^9}, {3.9660284531788683`*^9, 
   3.966028458236166*^9}, {3.966283480622823*^9, 3.9662835093558674`*^9}, 
   3.9662848654954395`*^9, {3.9662861155930843`*^9, 3.9662861156266413`*^9}, {
   3.9663455107109365`*^9, 3.9663455215193872`*^9}, {3.9663456410064316`*^9, 
   3.9663456411064315`*^9}, {3.966353726356678*^9, 3.9663537541312885`*^9}, {
   3.9663537891113577`*^9, 3.966353794774789*^9}, {3.9663538284678664`*^9, 
   3.9663539411116314`*^9}, {3.9663551688797975`*^9, 
   3.9663551743580294`*^9}, {3.9663552062000923`*^9, 
   3.9663552075670943`*^9}, {3.966355460902878*^9, 3.9663555157576756`*^9}, {
   3.966355553875149*^9, 3.966355630064127*^9}, {3.9663599006838408`*^9, 
   3.966359902796789*^9}, {3.9663599378612394`*^9, 3.966359974174876*^9}, 
   3.96636585472791*^9, 3.966366268464685*^9, {3.9663663000406384`*^9, 
   3.9663663352231874`*^9}, 3.966366382296356*^9, {3.9663664274464073`*^9, 
   3.966366446618437*^9}, {3.9663665135970063`*^9, 3.9663665616814675`*^9}, {
   3.9672318022968707`*^9, 3.967231842787638*^9}, {3.9672323116027746`*^9, 
   3.967232400307107*^9}, {3.967232443018357*^9, 3.9672325281925154`*^9}, {
   3.967246607538595*^9, 3.96724660804991*^9}, {3.971031355090175*^9, 
   3.9710313707160816`*^9}, {3.9710314755197315`*^9, 
   3.9710314870906534`*^9}, {3.9710318101688876`*^9, 3.971031812172656*^9}, {
   3.971031858010207*^9, 3.9710318717271805`*^9}, {3.971032034784433*^9, 
   3.971032163416096*^9}, 3.972236407584715*^9, {3.972236620551401*^9, 
   3.9722366423337307`*^9}, {3.9722367993888464`*^9, 3.972236965108321*^9}, 
   3.972395608996731*^9, {3.9723959466153364`*^9, 3.9723959916325407`*^9}, {
   3.972396242515995*^9, 3.9723962686679144`*^9}, {3.9723963018884544`*^9, 
   3.9723963435958986`*^9}, {3.972396387050749*^9, 
   3.9723965172582736`*^9}},ExpressionUUID->"ed90bb2e-a068-4f77-8983-\
114504f99343"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"inData", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"Length", "[", "inFiles", "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Data", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"Length", "[", "inFiles", "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"For", "[", 
  RowBox[{
   RowBox[{"i", "=", "1"}], ",", 
   RowBox[{"i", "\[LessEqual]", 
    RowBox[{"Length", "[", "inFiles", "]"}]}], ",", 
   RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"inData", "[", 
      RowBox[{"[", "i", "]"}], "]"}], "=", 
     RowBox[{"Import", "[", 
      RowBox[{
       RowBox[{"inFiles", "[", 
        RowBox[{"[", "i", "]"}], "]"}], ",", "\"\<Table\>\"", ",", 
       RowBox[{"\"\<FieldSeparators\>\"", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\< \>\"", ",", "\"\<\\n\>\""}], "}"}]}]}], "]"}]}], 
    ";"}]}], "\[IndentingNewLine]", "]"}]}], "Input",
 CellChangeTimes->{{3.8088987603844748`*^9, 3.808898760389476*^9}, {
   3.8088987974616737`*^9, 3.808898797699171*^9}, {3.808898955298374*^9, 
   3.8088989745769978`*^9}, {3.8088990204361343`*^9, 
   3.8088990475452023`*^9}, {3.8088993432862167`*^9, 3.8088993488074837`*^9}, 
   3.8089132373770795`*^9, {3.8089133938577895`*^9, 3.8089133946065784`*^9}, {
   3.808914348105073*^9, 3.808914374119644*^9}, {3.8143883775545034`*^9, 
   3.8143883776975117`*^9}, {3.817745247522892*^9, 3.8177452499678764`*^9}, {
   3.818307132829943*^9, 3.8183071427258015`*^9}, {3.832184000310708*^9, 
   3.832184000476708*^9}, {3.832184785705651*^9, 3.8321848128556232`*^9}, {
   3.877375316157969*^9, 3.8773753720445166`*^9}, {3.8773754257529335`*^9, 
   3.877375425903227*^9}, {3.8773761048033004`*^9, 3.8773761243783264`*^9}, {
   3.880490835089597*^9, 3.8804908354891977`*^9}, {3.880491001144314*^9, 
   3.880491058196918*^9}, 3.880585036623171*^9, {3.8808316743775115`*^9, 
   3.8808316744975185`*^9}, {3.88083173553826*^9, 3.8808317548350506`*^9}, {
   3.880831861639245*^9, 3.8808318639946413`*^9}, {3.889702231245826*^9, 
   3.88970223777074*^9}, {3.8897024145049667`*^9, 3.8897025536689067`*^9}, {
   3.889702615469081*^9, 3.8897026188224983`*^9}, {3.889702865915352*^9, 
   3.8897028699672756`*^9}, {3.889702941728506*^9, 3.8897029444915085`*^9}, {
   3.88970298826377*^9, 3.889702999934156*^9}, {3.889703079839328*^9, 
   3.8897030824790154`*^9}, {3.8897031305551376`*^9, 
   3.8897031316048975`*^9}, {3.8897168509214096`*^9, 3.889716863026906*^9}, {
   3.889718077479236*^9, 3.889718102022805*^9}, {3.8939562645703554`*^9, 
   3.8939562652538166`*^9}, {3.9496753559836407`*^9, 
   3.9496754121934814`*^9}, {3.949675454212244*^9, 3.9496754568630953`*^9}, {
   3.9496773381143293`*^9, 3.9496773387519813`*^9}, 3.9496773867862864`*^9, {
   3.949677437142476*^9, 3.949677488351195*^9}, {3.949677540051149*^9, 
   3.949677548830299*^9}, {3.949933271121267*^9, 3.9499332712770205`*^9}, {
   3.951004015176592*^9, 3.9510040162198267`*^9}, {3.9523529248334885`*^9, 
   3.9523529249575167`*^9}, {3.952353188870604*^9, 3.9523531919893055`*^9}, 
   3.9527199394409933`*^9, {3.9657495327359934`*^9, 3.9657495435160108`*^9}, 
   3.9657497403493233`*^9},
 CellLabel->
  "In[1075]:=",ExpressionUUID->"94823ce5-4b35-4f02-9bc2-98c3b8acc3a2"],

Cell["\<\
In the data:
The first MAD is one after the first data entry that starts a line with \
\[OpenCurlyDoubleQuote]Subset\[CloseCurlyDoubleQuote]
The last MAD row is 54 rows after that (for a benchmark of 55, tweak if \
necessary)\
\>", "Text",
 CellChangeTimes->{{3.9660252512862234`*^9, 3.966025355089263*^9}, {
  3.9660254555894165`*^9, 3.9660254569784174`*^9}, {3.9660259624472933`*^9, 
  3.966025962931363*^9}},ExpressionUUID->"ec72a229-5317-4662-9e91-\
dc243846cf0f"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"NumBench", "=", "55"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"MADRowi", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"FirstPosition", "[", 
      RowBox[{"inData", ",", "\"\<Subset\>\""}], "]"}], "[", 
     RowBox[{"[", "2", "]"}], "]"}], "+", "1"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"MADRowf", "=", 
   RowBox[{"MADRowi", "+", "NumBench", "-", "1"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.9660253565745077`*^9, 3.9660254127843504`*^9}, {
  3.9660258160189686`*^9, 3.966025839024019*^9}},
 CellLabel->
  "In[1078]:=",ExpressionUUID->"6ab770a1-01ea-446b-9614-2d595ec31990"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Data Processing", "Section",
 CellChangeTimes->{{3.8159098859335394`*^9, 3.8159098936639137`*^9}, {
  3.816020473371563*^9, 3.8160204797198906`*^9}, {3.867287106187972*^9, 
  3.8672871084708767`*^9}, {3.9169979350764914`*^9, 3.9169979369826174`*^9}, {
  3.94641371084194*^9, 
  3.946413720636649*^9}},ExpressionUUID->"7f4f10e9-0978-4bf8-adf7-\
6fc4e0f89d6e"],

Cell[BoxData[
 RowBox[{"SystLabels", "=", 
  RowBox[{"inData", "[", 
   RowBox[{"[", 
    RowBox[{"1", ",", 
     RowBox[{"MADRowi", ";;", "MADRowf"}], ",", "1"}], "]"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.9556483296519117`*^9, 3.955648371515128*^9}, {
   3.9556484067417517`*^9, 3.9556484221422234`*^9}, 3.9556490102617936`*^9, {
   3.956076015954112*^9, 3.9560760161631594`*^9}, 3.9565819422816477`*^9, 
   3.9656628325006433`*^9, {3.965749496265916*^9, 3.9657494963989162`*^9}, {
   3.965749760216506*^9, 3.9657497602720904`*^9}, {3.9660258295839863`*^9, 
   3.9660258332930098`*^9}},
 CellLabel->
  "In[1081]:=",ExpressionUUID->"4b84ff37-d71d-4a27-83e1-d8c51373881d"],

Cell[BoxData[
 RowBox[{"FuncLabels", "=", 
  RowBox[{"inData", "[", 
   RowBox[{"[", 
    RowBox[{"All", ",", 
     RowBox[{"MADRowi", "-", "1"}], ",", "5"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.955648431118119*^9, 3.9556484716243095`*^9}, 
   3.9556490067641335`*^9, {3.965662841622142*^9, 3.9656628416908064`*^9}, {
   3.9657495575734243`*^9, 3.9657495577080336`*^9}, {3.9660258470428934`*^9, 
   3.966025849591367*^9}, {3.9662862290238233`*^9, 3.9662862368618355`*^9}},
 CellLabel->
  "In[1082]:=",ExpressionUUID->"29c7daa0-5949-4413-89fc-23b6e623598a"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"FuncLabels", "=", 
    RowBox[{"StringReplace", "[", 
     RowBox[{
      RowBox[{"ToString", "/@", "FuncLabels"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<B86bPBE-25\>\"", "\[Rule]", "\"\<B86bPBE0\>\""}], "}"}]}],
      "]"}]}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"FuncLabels", "=", 
     RowBox[{"StringReplace", "[", 
      RowBox[{
       RowBox[{"ToString", "/@", "FuncLabels"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
         "\"\<LC-whPBE\>\"", "\[Rule]", "\"\<LC\[Hyphen]\[Omega]PBEh\>\""}], 
         ",", 
         RowBox[{
         "\"\<LC-wPBE\>\"", "\[Rule]", "\"\<LC\[Hyphen]\[Omega]PBE\>\""}]}], 
        "}"}]}], "]"}]}], ";"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"FuncLabels", "=", 
     RowBox[{"StringReplace", "[", 
      RowBox[{
       RowBox[{"ToString", "/@", "FuncLabels"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\"\<-\>\"", "\[Rule]", "\"\<\[Hyphen]\>\""}], ",", 
         RowBox[{"\"\<\[Dash]\>\"", "\[Rule]", "\"\<\[Hyphen]\>\""}], ",", 
         RowBox[{"\"\<\[LongDash]\>\"", "\[Rule]", "\"\<\[Hyphen]\>\""}]}], 
        "}"}]}], "]"}]}], ";"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"SystLabels", "=", 
     RowBox[{"StringReplace", "[", 
      RowBox[{
       RowBox[{"ToString", "/@", "SystLabels"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\"\<-\>\"", "\[Rule]", "\"\<\[Hyphen]\>\""}], ",", 
         RowBox[{"\"\<\[Dash]\>\"", "\[Rule]", "\"\<\[Hyphen]\>\""}], ",", 
         RowBox[{"\"\<\[LongDash]\>\"", "\[Rule]", "\"\<\[Hyphen]\>\""}]}], 
        "}"}]}], "]"}]}], ";"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"SystLabels", "[", 
      RowBox[{"[", 
       RowBox[{"-", "2"}], "]"}], "]"}], "=", 
     RowBox[{"Style", "[", 
      RowBox[{"\"\<WTMAD\[Hyphen]1\>\"", ",", 
       RowBox[{"FontFamily", "\[Rule]", "\"\<Calibri\>\""}], ",", "Bold"}], 
      "]"}]}], ";"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"SystLabels", "[", 
      RowBox[{"[", 
       RowBox[{"-", "1"}], "]"}], "]"}], "=", 
     RowBox[{"Style", "[", 
      RowBox[{"\"\<WTMAD\[Hyphen]2\>\"", ",", 
       RowBox[{"FontFamily", "\[Rule]", "\"\<Calibri\>\""}], ",", "Bold"}], 
      "]"}]}], ";"}], "*)"}]}]}], "Input",
 CellChangeTimes->{{3.9556485783758965`*^9, 3.9556486956121125`*^9}, {
  3.955648801693203*^9, 3.955648879889615*^9}, {3.955648924685316*^9, 
  3.955649008063907*^9}, {3.955651432455698*^9, 3.955651441511552*^9}, {
  3.9560761572450104`*^9, 3.956076161194902*^9}, {3.956582763902437*^9, 
  3.9565827670430584`*^9}, {3.965662877913316*^9, 3.965662899973474*^9}, {
  3.9657489690237284`*^9, 3.9657490637883863`*^9}, {3.966345651507435*^9, 
  3.9663456683219213`*^9}, {3.9663548167930593`*^9, 3.9663548232013245`*^9}},
 CellLabel->
  "In[1083]:=",ExpressionUUID->"dedf4a36-1d7c-43f2-8485-101296f0c64f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Data", "=", 
   RowBox[{"inData", "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", 
      RowBox[{"MADRowi", ";;", "MADRowf"}], ",", 
      RowBox[{"-", "1"}]}], "]"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.955648482441185*^9, 3.9556485161649666`*^9}, {
   3.955650356862707*^9, 3.955650364977623*^9}, {3.9560760020689774`*^9, 
   3.956076002181002*^9}, 3.956582153529072*^9, {3.9656629342301617`*^9, 
   3.9656629553778687`*^9}, {3.965749563029042*^9, 3.965749563535043*^9}, 
   3.9660258676760817`*^9, {3.9662943706070023`*^9, 3.966294372035325*^9}},
 CellLabel->
  "In[1084]:=",ExpressionUUID->"ffcb47ad-7076-4ba7-a4b8-d6e3d3f01c70"],

Cell[BoxData[
 RowBox[{"DClabel", "=", 
  RowBox[{"StringReplace", "[", 
   RowBox[{
    RowBox[{"FileBaseName", "/@", "inFiles"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\"\<bj\>\"", "\[Rule]", "\"\<(BJ)\>\""}], ",", 
      RowBox[{"\"\<z\>\"", "\[Rule]", "\"\<(Z)\>\""}], ",", 
      RowBox[{"\"\<ProcessGMTKN55_\>\"", "\[Rule]", "\"\<\>\""}]}], "}"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.955649062290451*^9, 3.9556490693484697`*^9}, {
  3.955649106230855*^9, 3.955649122085611*^9}, {3.9556491875768585`*^9, 
  3.9556492409545608`*^9}, {3.9657496136820536`*^9, 3.965749616946109*^9}, {
  3.9657497883524694`*^9, 3.965749788541542*^9}, {3.9662943833347845`*^9, 
  3.966294394214982*^9}},
 CellLabel->
  "In[1085]:=",ExpressionUUID->"06f67035-d852-4af8-917b-f4d5c279cee6"],

Cell[BoxData[
 RowBox[{"NSysts", "=", 
  RowBox[{"inData", "[", 
   RowBox[{"[", 
    RowBox[{"1", ",", 
     RowBox[{"MADRowi", ";;", "MADRowf"}], ",", "2"}], "]"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.9565823374180436`*^9, 3.956582365099651*^9}, 
   3.9656629706048784`*^9, {3.9657495647857285`*^9, 3.9657495649335704`*^9}, 
   3.9660258712380576`*^9},
 CellLabel->
  "In[1086]:=",ExpressionUUID->"facbc342-edff-4602-a751-76a185644a2a"],

Cell[BoxData[
 RowBox[{"DeltEBi", "=", 
  RowBox[{"inData", "[", 
   RowBox[{"[", 
    RowBox[{"1", ",", 
     RowBox[{"MADRowi", ";;", "MADRowf"}], ",", "3"}], "]"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.9565823717894907`*^9, 3.9565823821017013`*^9}, 
   3.9656629758908873`*^9, {3.965749566363551*^9, 3.965749566515036*^9}, 
   3.966025873451207*^9},
 CellLabel->
  "In[1087]:=",ExpressionUUID->"38b32406-490e-4614-bdbc-89bc04dabd99"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"GMTKN55info", "=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
    "\"\<AL2X6        6     35.88     1.0    0    3.27 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<ALK8         8     62.60     1.0    0    1.30 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<ALKBDE10    10    100.69     0.1    0    1.06 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<BH76RC      30     21.39     1.0    0    2.55 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<DC13        13     54.98     1.0    0    0.78 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<DIPCS10     10    654.26     0.1    0    1.65 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<FH51        51     31.01     1.0    0    2.39 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<G21EA       25     33.62     1.0    0    2.15 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<G21IP       36    257.61     0.1    0    1.63 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<G2RC        25     51.26     1.0    0    1.12 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<HEAVYSB11   11     58.02     1.0    0    2.73 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<NBPRC       12     27.71     1.0    0    2.32 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<PA26        26    189.05     0.1    0    1.98 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<RC21        21     35.70     1.0    0    1.45 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<SIE4x4      16     33.72     1.0    0    0.469\>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<TAUT15      15      3.05    10.0    0    5.80 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<W4-11      140    306.91     0.1    0    1.07 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<YBDE18      18     49.28     1.0    0    2.55 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<BSR36       36     16.20     1.0    1    2.03 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<C60ISO       9     98.25     0.1    1    1.19 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<CDIE20      20      4.06    10.0    1    5.75 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<DARC        14     32.47     1.0    1    1.44 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<ISO34       34     14.57     1.0    1    4.49 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<ISOL24      24     21.92     1.0    1    1.99 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<MB16-43     43    468.39     0.1    1    0.329\>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<PArel       20      4.63    10.0    1    5.51 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<RSE43       43      7.60     1.0    1    5.27 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<BH76        76     18.61     1.0    2    1.53 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<BHDIV10     10     45.33     1.0    2    1.66 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<BHPERI      26     20.87     1.0    2    2.29 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<BHROT27     27      6.27    10.0    2   11.0  \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<INV24       24     31.85     1.0    2    4.41 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<PX13        13     33.36     1.0    2    1.18 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<WCPT18      18     34.99     1.0    2    1.77 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<ADIM6        6      3.36    10.0    3   36.8  \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<AHB21       21     22.49     1.0    3    6.24 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<CARBHB12    12      6.04    10.0    3    5.50 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<CHB6         6     26.79     1.0    3    4.14 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<HAL59       59      4.59    10.0    3    9.63 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<HEAVY28     28      1.24    10.0    3   14.0  \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<IL16        16    109.04     0.1    3   11.5  \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<PNICO23     23      4.27    10.0    3    7.86 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<RG18        18      0.58    10.0    3   29.9  \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<S22         22      7.30    10.0    3   13.5  \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<S66         66      5.47    10.0    3   18.4  \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<WATER27     27     81.14     0.1    3    1.43 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<ACONF       15      1.83    10.0    4   61.2  \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<Amino20x4   80      2.44    10.0    4   22.6  \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<BUT14DIOL   64      2.80    10.0    4   30.0  \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<ICONF       17      3.27    10.0    4   20.0  \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<IDISP        6     14.22     1.0    4    2.50 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<MCONF       51      4.97    10.0    4   21.2  \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<PCONF21     18      1.62    10.0    4    8.66 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<SCONF       17      4.60    10.0    4   19.1  \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<UPU23       23      5.72    10.0    4   10.1  \>\""}], 
    "\[IndentingNewLine]", "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"GMTKN55info", "=", 
   RowBox[{"StringSplit", "[", "GMTKN55info", "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"GMTKN55info", "=", 
   RowBox[{"GMTKN55info", "/.", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "name_", ",", "a_", ",", "b_", ",", "c_", ",", "d_", ",", "e_"}], "}"}],
      "\[RuleDelayed]", 
     RowBox[{"{", 
      RowBox[{"name", ",", 
       RowBox[{"ToExpression", "[", "a", "]"}], ",", 
       RowBox[{"ToExpression", "[", "b", "]"}], ",", 
       RowBox[{"ToExpression", "[", "c", "]"}], ",", 
       RowBox[{"ToExpression", "[", "d", "]"}], ",", 
       RowBox[{"ToExpression", "[", "e", "]"}]}], "}"}]}]}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.9723961334012613`*^9, 3.9723961986470413`*^9}},
 CellLabel->
  "In[1088]:=",ExpressionUUID->"b135e6dc-c46c-4b82-a47c-f6fb95823eb0"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Get MAEs", "Section",
 CellChangeTimes->{{3.8159098859335394`*^9, 3.8159098936639137`*^9}, {
   3.816020473371563*^9, 3.8160204797198906`*^9}, {3.867287106187972*^9, 
   3.8672871084708767`*^9}, {3.9169979350764914`*^9, 
   3.9169979369826174`*^9}, {3.94641371084194*^9, 3.9464137299645586`*^9}, 
   3.9556493624167347`*^9, {3.9556542149812284`*^9, 3.9556542185457573`*^9}, {
   3.9565872139918404`*^9, 3.9565872150360765`*^9}, {3.956587245363923*^9, 
   3.9565872461460996`*^9}},ExpressionUUID->"4da85bcb-f3a9-43a4-b946-\
5d7a514eed39"],

Cell[BoxData[
 RowBox[{"(*", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Data", "[", 
      RowBox[{"[", 
       RowBox[{"All", ",", "1"}], "]"}], "]"}], ",", 
     RowBox[{"Mean", "[", 
      RowBox[{"Data", "[", 
       RowBox[{"[", 
        RowBox[{"All", ",", "1"}], "]"}], "]"}], "]"}]}], "}"}], ";", 
   "\[IndentingNewLine]", 
   RowBox[{"Length", "[", 
    RowBox[{"Mean", "[", 
     RowBox[{"Transpose", "[", 
      RowBox[{"Data", "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", ";;"}], "]"}], "]"}], "]"}], "]"}], "]"}], ";", 
   "\[IndentingNewLine]", 
   RowBox[{"DCMeans", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Mean", "[", 
       RowBox[{"Transpose", "[", 
        RowBox[{"Data", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", ";;"}], "]"}], "]"}], "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", 
        RowBox[{"Length", "[", "inFiles", "]"}]}], "}"}]}], "]"}]}], ";", 
   "\[IndentingNewLine]", 
   RowBox[{"NumberForm", "[", 
    RowBox[{
     RowBox[{"TableForm", "[", "DCMeans", "]"}], ",", "2"}], "]"}], ";", 
   "\[IndentingNewLine]", 
   RowBox[{"MAEs", "=", 
    RowBox[{"Mean", "[", "DCMeans", "]"}]}], ";", "\[IndentingNewLine]", 
   RowBox[{"NumberForm", "[", 
    RowBox[{
     RowBox[{"TableForm", "[", 
      RowBox[{"{", "MAEs", "}"}], "]"}], ",", "2"}], "]"}], ";", 
   "\[IndentingNewLine]", 
   RowBox[{"Groups", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Select", "[", 
       RowBox[{
        RowBox[{"MapThread", "[", 
         RowBox[{"Append", ",", 
          RowBox[{"{", 
           RowBox[{"GMTKN55info", ",", "MAEs"}], "}"}]}], "]"}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"#", "[", 
           RowBox[{"[", "5", "]"}], "]"}], "\[Equal]", "i"}], "&"}]}], "]"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "2", ",", "1", ",", "4", ",", "3"}], "}"}]}], 
       "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", "*)"}]], "Input",
 CellChangeTimes->{{3.9565818508109508`*^9, 3.9565818620021734`*^9}, {
   3.9565824688783684`*^9, 3.956582472780568*^9}, 3.956587202344208*^9, {
   3.965663171967272*^9, 3.9656631797392864`*^9}, {3.9657496427591505`*^9, 
   3.9657496482961626`*^9}, {3.9657496998433247`*^9, 3.965749699964259*^9}, {
   3.966294625616338*^9, 3.966294629617343*^9}, {3.9662949840466824`*^9, 
   3.9662950012226543`*^9}},
 CellLabel->
  "In[1091]:=",ExpressionUUID->"57e64dad-ab8d-4f8e-9aaf-55a0ff389b4a"],

Cell[BoxData[
 RowBox[{"MAEs", "=", "Data"}]], "Input",
 CellChangeTimes->{{3.966294963077761*^9, 3.9662949635646753`*^9}},
 CellLabel->
  "In[1092]:=",ExpressionUUID->"4f3f0d68-fed8-479e-9bfa-31712ef16600"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Get WTMAD-1", "Section",
 CellChangeTimes->{{3.8159098859335394`*^9, 3.8159098936639137`*^9}, {
   3.816020473371563*^9, 3.8160204797198906`*^9}, {3.867287106187972*^9, 
   3.8672871084708767`*^9}, {3.9169979350764914`*^9, 
   3.9169979369826174`*^9}, {3.94641371084194*^9, 3.9464137299645586`*^9}, 
   3.9556493624167347`*^9, {3.9556542149812284`*^9, 3.9556542185457573`*^9}, {
   3.9565872139918404`*^9, 3.9565872150360765`*^9}, {3.956587249155779*^9, 
   3.9565872620896993`*^9}},ExpressionUUID->"7871f13e-07da-4b6b-bf8e-\
7a783f37bea5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"WTMAD1Weights", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      FractionBox["1", 
       RowBox[{"Length", "[", "NSysts", "]"}]], "*", 
      RowBox[{"GMTKN55info", "[", 
       RowBox[{"[", 
        RowBox[{"i", ",", "4"}], "]"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", "NSysts", "]"}]}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.956582397267912*^9, 3.956582438034385*^9}, {
   3.95658260156394*^9, 3.95658263914332*^9}, {3.9565826784500456`*^9, 
   3.956582681283206*^9}, 3.9565871841791067`*^9, {3.9565872288221884`*^9, 
   3.9565872305245733`*^9}, 3.956587264467236*^9, {3.95658773590092*^9, 
   3.9565877457251377`*^9}, {3.956587778876622*^9, 3.95658778546511*^9}, {
   3.9565878342881346`*^9, 3.956587848723393*^9}, 3.956587915521719*^9, {
   3.956688730787898*^9, 3.9566887313465166`*^9}},
 CellLabel->
  "In[1093]:=",ExpressionUUID->"bee6cb48-54d3-47d0-ad65-c8a20c618a7f"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"WTMAD1PercentWeights", "=", 
   FractionBox["WTMAD1Weights", 
    RowBox[{"Total", "[", "WTMAD1Weights", "]"}]]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Total", "[", "WTMAD1PercentWeights", "]"}]}], "Input",
 CellChangeTimes->{{3.956582716827536*^9, 3.9565827291707726`*^9}, {
  3.9565828231455297`*^9, 3.956582842626396*^9}, {3.9565828923101435`*^9, 
  3.956582897144931*^9}, {3.956584582500524*^9, 3.9565845911620855`*^9}, {
  3.9565871307570467`*^9, 3.956587161774049*^9}, {3.9565872074773693`*^9, 
  3.956587234966576*^9}, {3.9565877868734293`*^9, 3.9565878099726443`*^9}},
 CellLabel->
  "In[1094]:=",ExpressionUUID->"ae5033bc-8804-4373-a9a2-c77bd6940b1b"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"WTMAD1PercentWeightsMAEs", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     FractionBox[
      RowBox[{"WTMAD1PercentWeights", "*", 
       RowBox[{"MAEs", "[", 
        RowBox[{"[", "i", "]"}], "]"}]}], 
      RowBox[{"Total", "[", 
       RowBox[{"WTMAD1PercentWeights", "*", 
        RowBox[{"MAEs", "[", 
         RowBox[{"[", "i", "]"}], "]"}]}], "]"}]], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", "FuncLabels", "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Total", "[", 
  RowBox[{"WTMAD1PercentWeightsMAEs", ",", "2"}], "]"}]}], "Input",
 CellChangeTimes->{{3.956582876066087*^9, 3.956582879514589*^9}, {
   3.9565829332007227`*^9, 3.956582938664235*^9}, {3.9565845617056475`*^9, 
   3.956584634096374*^9}, {3.956587138255739*^9, 3.9565871631413574`*^9}, 
   3.956587206969255*^9, {3.956587793205859*^9, 3.956587808022204*^9}, {
   3.96629501429468*^9, 3.966295027141844*^9}, {3.9662950737928753`*^9, 
   3.9662950816278787`*^9}, {3.9662951180950136`*^9, 3.9662951374309845`*^9}},
 CellLabel->
  "In[1096]:=",ExpressionUUID->"b2ef92c2-ad03-47f9-812c-0a0716c604d7"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Get WTMAD-2", "Section",
 CellChangeTimes->{{3.8159098859335394`*^9, 3.8159098936639137`*^9}, {
   3.816020473371563*^9, 3.8160204797198906`*^9}, {3.867287106187972*^9, 
   3.8672871084708767`*^9}, {3.9169979350764914`*^9, 
   3.9169979369826174`*^9}, {3.94641371084194*^9, 3.9464137299645586`*^9}, 
   3.9556493624167347`*^9, {3.9556542149812284`*^9, 3.9556542185457573`*^9}, {
   3.9565872139918404`*^9, 3.9565872150360765`*^9}, {3.956587249155779*^9, 
   3.9565872505400915`*^9}},ExpressionUUID->"db70bf0f-cfe3-4afa-b44e-\
0a8f07be726e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"WTMAD2Weights", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      FractionBox[
       RowBox[{"NSysts", "[", 
        RowBox[{"[", "i", "]"}], "]"}], 
       RowBox[{"Total", "[", "NSysts", "]"}]], 
      FractionBox[
       RowBox[{"If", "[", 
        RowBox[{"DEBfixed", ",", "DEBfixedval", ",", 
         RowBox[{"Mean", "[", "DeltEBi", "]"}]}], "]"}], 
       RowBox[{"DeltEBi", "[", 
        RowBox[{"[", "i", "]"}], "]"}]]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", "NSysts", "]"}]}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.956582397267912*^9, 3.956582438034385*^9}, {
   3.95658260156394*^9, 3.95658263914332*^9}, {3.9565826784500456`*^9, 
   3.956582681283206*^9}, 3.9565871841791067`*^9, {3.9565872288221884`*^9, 
   3.9565872305245733`*^9}, {3.966026158853484*^9, 3.966026175263531*^9}},
 CellLabel->
  "In[1098]:=",ExpressionUUID->"0a829db2-20ff-4a26-b2cd-761041946aa4"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"WTMAD2PercentWeights", "=", 
   FractionBox["WTMAD2Weights", 
    RowBox[{"Total", "[", "WTMAD2Weights", "]"}]]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Total", "[", "WTMAD2PercentWeights", "]"}]}], "Input",
 CellChangeTimes->{{3.956582716827536*^9, 3.9565827291707726`*^9}, {
   3.9565828231455297`*^9, 3.956582842626396*^9}, {3.9565828923101435`*^9, 
   3.956582897144931*^9}, {3.956584582500524*^9, 3.9565845911620855`*^9}, {
   3.9565871307570467`*^9, 3.956587161774049*^9}, {3.9565872074773693`*^9, 
   3.956587234966576*^9}, 3.956588064967461*^9},
 CellLabel->
  "In[1099]:=",ExpressionUUID->"4aea3a86-1bf4-4735-a436-1b148255cae0"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"WTMAD2PercentWeightsMAEs", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"WTMAD2PercentWeights", "*", 
        RowBox[{"MAEs", "[", 
         RowBox[{"[", "i", "]"}], "]"}]}], ")"}], "/", 
      RowBox[{"Total", "[", 
       RowBox[{"WTMAD2PercentWeights", "*", 
        RowBox[{"MAEs", "[", 
         RowBox[{"[", "i", "]"}], "]"}]}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", "FuncLabels", "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Total", "[", 
  RowBox[{"WTMAD2PercentWeightsMAEs", ",", "2"}], "]"}]}], "Input",
 CellChangeTimes->{{3.956582876066087*^9, 3.956582879514589*^9}, {
   3.9565829332007227`*^9, 3.956582938664235*^9}, {3.9565845617056475`*^9, 
   3.956584634096374*^9}, {3.956587138255739*^9, 3.9565871631413574`*^9}, 
   3.956587206969255*^9, 3.9565880655655966`*^9, {3.966295158832013*^9, 
   3.9662952179790955`*^9}},
 CellLabel->
  "In[1101]:=",ExpressionUUID->"92377b9b-434c-4da6-8dca-feb1dc87a8c3"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Get WTMAD-3", "Section",
 CellChangeTimes->{{3.8159098859335394`*^9, 3.8159098936639137`*^9}, {
   3.816020473371563*^9, 3.8160204797198906`*^9}, {3.867287106187972*^9, 
   3.8672871084708767`*^9}, {3.9169979350764914`*^9, 
   3.9169979369826174`*^9}, {3.94641371084194*^9, 3.9464137299645586`*^9}, 
   3.9556493624167347`*^9, {3.9556542149812284`*^9, 3.9556542185457573`*^9}, {
   3.9565872139918404`*^9, 3.9565872150360765`*^9}, {3.956587249155779*^9, 
   3.9565872505400915`*^9}, 
   3.9565880243893003`*^9},ExpressionUUID->"bf8b89bf-d531-412b-a195-\
6a08785e36a3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"WTMAD3Weights", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      FractionBox[
       RowBox[{"Min", "[", 
        RowBox[{
         RowBox[{"0.01", "*", 
          RowBox[{"Total", "[", "NSysts", "]"}]}], ",", 
         RowBox[{"NSysts", "[", 
          RowBox[{"[", "i", "]"}], "]"}]}], "]"}], 
       RowBox[{"Total", "[", "NSysts", "]"}]], 
      FractionBox[
       RowBox[{"If", "[", 
        RowBox[{"DEBfixed", ",", "DEBfixedval", ",", 
         RowBox[{"Mean", "[", "DeltEBi", "]"}]}], "]"}], 
       RowBox[{"DeltEBi", "[", 
        RowBox[{"[", "i", "]"}], "]"}]]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", "NSysts", "]"}]}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.956582397267912*^9, 3.956582438034385*^9}, {
   3.95658260156394*^9, 3.95658263914332*^9}, {3.9565826784500456`*^9, 
   3.956582681283206*^9}, 3.9565871841791067`*^9, {3.9565872288221884`*^9, 
   3.9565872305245733`*^9}, {3.956588029137372*^9, 3.9565880461362095`*^9}, 
   3.9660261854577026`*^9, {3.9723957659544916`*^9, 3.9723957660755186`*^9}},
 CellLabel->
  "In[1103]:=",ExpressionUUID->"03ff58bc-fb1c-402c-95a5-21e2aee66941"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"WTMAD3PercentWeights", "=", 
   FractionBox["WTMAD3Weights", 
    RowBox[{"Total", "[", "WTMAD3Weights", "]"}]]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Total", "[", "WTMAD3PercentWeights", "]"}]}], "Input",
 CellChangeTimes->{{3.956582716827536*^9, 3.9565827291707726`*^9}, {
  3.9565828231455297`*^9, 3.956582842626396*^9}, {3.9565828923101435`*^9, 
  3.956582897144931*^9}, {3.956584582500524*^9, 3.9565845911620855`*^9}, {
  3.9565871307570467`*^9, 3.956587161774049*^9}, {3.9565872074773693`*^9, 
  3.956587234966576*^9}, {3.9565880487027893`*^9, 3.956588060774515*^9}},
 CellLabel->
  "In[1104]:=",ExpressionUUID->"c25264a6-0f79-4b51-a3ee-c3ed9cb98b65"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"WTMAD3PercentWeightsMAEs", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     FractionBox[
      RowBox[{"WTMAD3PercentWeights", "*", 
       RowBox[{"MAEs", "[", 
        RowBox[{"[", "i", "]"}], "]"}]}], 
      RowBox[{"Total", "[", 
       RowBox[{"WTMAD3PercentWeights", "*", 
        RowBox[{"MAEs", "[", 
         RowBox[{"[", "i", "]"}], "]"}]}], "]"}]], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", "FuncLabels", "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Total", "[", 
  RowBox[{"WTMAD3PercentWeightsMAEs", ",", "2"}], "]"}]}], "Input",
 CellChangeTimes->{{3.956582876066087*^9, 3.956582879514589*^9}, {
   3.9565829332007227`*^9, 3.956582938664235*^9}, {3.9565845617056475`*^9, 
   3.956584634096374*^9}, {3.956587138255739*^9, 3.9565871631413574`*^9}, 
   3.956587206969255*^9, {3.956588053094781*^9, 3.9565880616957226`*^9}, {
   3.9662951627090225`*^9, 3.966295215798777*^9}},
 CellLabel->
  "In[1106]:=",ExpressionUUID->"151d3dda-3e77-41e9-ba40-352cfcadff54"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Get WTMAD-4", "Section",
 CellChangeTimes->{{3.8159098859335394`*^9, 3.8159098936639137`*^9}, {
   3.816020473371563*^9, 3.8160204797198906`*^9}, {3.867287106187972*^9, 
   3.8672871084708767`*^9}, {3.9169979350764914`*^9, 
   3.9169979369826174`*^9}, {3.94641371084194*^9, 3.9464137299645586`*^9}, 
   3.9556493624167347`*^9, {3.9556542149812284`*^9, 3.9556542185457573`*^9}, {
   3.9565872139918404`*^9, 3.9565872150360765`*^9}, {3.956587249155779*^9, 
   3.9565872505400915`*^9}, {3.956599131692154*^9, 3.9565991428936825`*^9}, 
   3.956687277563732*^9, 
   3.9573531002514596`*^9},ExpressionUUID->"beab751f-fa93-4ffe-9246-\
6098248ae250"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"WTMAD4Weights", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       FractionBox["1", 
        RowBox[{"Length", "[", "NSysts", "]"}]], "*", 
       RowBox[{"GMTKN55info", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "6"}], "]"}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", 
        RowBox[{"Length", "[", "NSysts", "]"}]}], "}"}]}], "]"}]}], ";"}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.956582397267912*^9, 3.956582438034385*^9}, {
   3.95658260156394*^9, 3.95658263914332*^9}, {3.9565826784500456`*^9, 
   3.956582681283206*^9}, 3.9565871841791067`*^9, {3.9565872288221884`*^9, 
   3.9565872305245733`*^9}, {3.9565991365732555`*^9, 3.956599159425415*^9}, {
   3.9565991901565137`*^9, 3.956599190246534*^9}, {3.9565992799677896`*^9, 
   3.956599281119049*^9}, 3.956687280555092*^9, {3.9566879592102227`*^9, 
   3.9566879629032335`*^9}, 3.9566887485388823`*^9, 3.957353157706422*^9},
 CellLabel->
  "In[1108]:=",ExpressionUUID->"802a77bc-483f-4113-8f89-d8eef16b0522"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"WTMAD4PercentWeights", "=", 
   FractionBox["WTMAD4Weights", 
    RowBox[{"Total", "[", "WTMAD4Weights", "]"}]]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Total", "[", 
  RowBox[{"WTMAD4PercentWeights", ",", "2"}], "]"}]}], "Input",
 CellChangeTimes->{{3.956582716827536*^9, 3.9565827291707726`*^9}, {
   3.9565828231455297`*^9, 3.956582842626396*^9}, {3.9565828923101435`*^9, 
   3.956582897144931*^9}, {3.956584582500524*^9, 3.9565845911620855`*^9}, {
   3.9565871307570467`*^9, 3.956587161774049*^9}, {3.9565872074773693`*^9, 
   3.956587234966576*^9}, 3.956588064967461*^9, {3.95659916157206*^9, 
   3.956599196107857*^9}, {3.9565992619077125`*^9, 3.9565992620587463`*^9}, {
   3.956599304720378*^9, 3.9565993063997574`*^9}, {3.956687282211628*^9, 
   3.956687291716204*^9}, {3.957353159609851*^9, 3.9573531758675313`*^9}, 
   3.9662952117730865`*^9},
 CellLabel->
  "In[1109]:=",ExpressionUUID->"7911b51d-8ff0-42b7-ad82-ec5a5b82c588"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"WTMAD4PercentWeightsMAEs", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     FractionBox[
      RowBox[{"WTMAD4PercentWeights", "*", 
       RowBox[{"MAEs", "[", 
        RowBox[{"[", "i", "]"}], "]"}]}], 
      RowBox[{"Total", "[", 
       RowBox[{"WTMAD4PercentWeights", "*", 
        RowBox[{"MAEs", "[", 
         RowBox[{"[", "i", "]"}], "]"}]}], "]"}]], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", "FuncLabels", "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Total", "[", 
  RowBox[{"WTMAD4PercentWeightsMAEs", ",", "2"}], "]"}]}], "Input",
 CellChangeTimes->{{3.956582876066087*^9, 3.956582879514589*^9}, {
   3.9565829332007227`*^9, 3.956582938664235*^9}, {3.9565845617056475`*^9, 
   3.956584634096374*^9}, {3.956587138255739*^9, 3.9565871631413574`*^9}, 
   3.956587206969255*^9, 3.9565880655655966`*^9, {3.9565991686076484`*^9, 
   3.9565992025673156`*^9}, {3.956687284685731*^9, 3.956687288351381*^9}, {
   3.9573531642549095`*^9, 3.9573531709804277`*^9}, {3.96629517974104*^9, 
   3.966295209028248*^9}},
 CellLabel->
  "In[1111]:=",ExpressionUUID->"ecc6d8f2-c788-4805-a289-49304b3578d7"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Results", "Section",
 CellChangeTimes->{{3.8159098859335394`*^9, 3.8159098936639137`*^9}, {
   3.816020473371563*^9, 3.8160204797198906`*^9}, {3.867287106187972*^9, 
   3.8672871084708767`*^9}, {3.9169979350764914`*^9, 
   3.9169979369826174`*^9}, {3.94641371084194*^9, 3.9464137299645586`*^9}, 
   3.9556493624167347`*^9, {3.9556542149812284`*^9, 3.9556542185457573`*^9}, {
   3.9565872139918404`*^9, 3.9565872150360765`*^9}, {3.956587249155779*^9, 
   3.9565872505400915`*^9}, 3.9565880243893003`*^9, {3.956591347165248*^9, 
   3.9565913480259705`*^9}, 3.956592883074552*^9, 3.9565935925167217`*^9, {
   3.9565954783134766`*^9, 3.9565954932755566`*^9}, {3.9565959389415627`*^9, 
   3.956595994510801*^9}, {3.956596082139065*^9, 
   3.95659608275187*^9}},ExpressionUUID->"b4c4a423-bbfe-463a-a517-\
31f584cfedf8"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ResTable", "=", 
   RowBox[{"Table", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Prepend", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Transpose", "[", 
        RowBox[{"{", 
         RowBox[{"SystLabels", ",", "\[IndentingNewLine]", 
          RowBox[{"Round", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"WTMAD1PercentWeightsMAEs", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "*", "100"}], ",", "0.0001"}], 
           "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"Round", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"WTMAD2PercentWeightsMAEs", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "*", "100"}], ",", "0.0001"}], 
           "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"Round", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"WTMAD3PercentWeightsMAEs", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "*", "100"}], ",", "0.0001"}], 
           "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"Round", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"WTMAD4PercentWeightsMAEs", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "*", "100"}], ",", "0.0001"}], 
           "]"}]}], "\[IndentingNewLine]", "}"}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FuncLabels", "[", 
          RowBox[{"[", "i", "]"}], "]"}], ",", "\"\<WTMAD-1\>\"", ",", 
         "\"\<WTMAD-2\>\"", ",", "\"\<WTMAD-3\>\"", ",", "\"\<WTMAD-4\>\""}], 
        "}"}]}], "\[IndentingNewLine]", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", "FuncLabels", "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"TableForm", "[", 
   RowBox[{"ResTable", ",", 
    RowBox[{"TableAlignments", "\[Rule]", "Right"}]}], "]"}], "//", 
  RowBox[{
   RowBox[{"NumberForm", "[", 
    RowBox[{"#", ",", 
     RowBox[{"{", 
      RowBox[{"Infinity", ",", "2"}], "}"}]}], "]"}], "&"}]}]}], "Input",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGCQAGIQzansqzW16q2jw9RLYDql7YI+iNa/tdYQRH+SmWcD
ot/3TbAD0T6nw11AdNqTS2D6mqGJ3jQgvetFhimIluibaAei9UvM7EF0zkY9
julAuiJ0HxeIdnqzIhhEb6p/D6bLJN4fBdEKATfPguhFMie0ZgHpDYt09EB0
mub7dhB9/FhkJ4hWzt+xfjaQ5s1bvgdEb1/F6zcHSHPx8oHpNy3aUSDaTKIt
FkTbOJqkgmhloWownSX19g2Int3S8gVE8/264jQXSEdv4nYF0XLOby6fAJlT
WXkTRO/fty6at+atY59oRTyILsq7Kfm8+62jy/VtUiD63dZpnwV63jrWtHZ+
BdFljUasgkC6Zz07L4huytk0U7r3reND9t6FIHpLr8gMWyDtlBUOpgF+0cNv

  "],
 CellLabel->
  "In[1113]:=",ExpressionUUID->"1d492bbb-519d-448e-8b4d-e35ae87113ec"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"strLen", "=", 
   RowBox[{"Max", "[", 
    RowBox[{"10", ",", 
     RowBox[{
      RowBox[{"Max", "[", 
       RowBox[{"StringLength", "[", "FuncLabels", "]"}], "]"}], "+", "1"}]}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"formatEntry", "[", "e_", "]"}], ":=", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"NumberQ", "[", "e", "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"StringPadRight", "[", 
      RowBox[{
       RowBox[{"ToString", "[", 
        RowBox[{"NumberForm", "[", 
         RowBox[{
          RowBox[{"N", "[", "e", "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"6", ",", "4"}], "}"}]}], "]"}], "]"}], ",", "strLen"}], 
      "]"}], ",", 
     RowBox[{"(*", 
      RowBox[{
       RowBox[{"numbers", ":", 
        RowBox[{"2", " ", "decimals"}]}], ",", "padded"}], "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"StringPadRight", "[", 
      RowBox[{
       RowBox[{"ToString", "[", "e", "]"}], ",", "strLen"}], "]"}]}], 
    "                        ", 
    RowBox[{"(*", 
     RowBox[{"strings", " ", "padded"}], "*)"}], "\[IndentingNewLine]", 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"For", "[", 
  RowBox[{
   RowBox[{"i", "=", "1"}], ",", 
   RowBox[{"i", "\[LessEqual]", 
    RowBox[{"Length", "[", "FuncLabels", "]"}]}], ",", 
   RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"formattedTable", "=", 
     RowBox[{"StringRiffle", "[", 
      RowBox[{
       RowBox[{"Map", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"StringJoin", "@@", 
           RowBox[{"(", 
            RowBox[{"formatEntry", "/@", "#"}], ")"}]}], "&"}], ",", 
         RowBox[{"ResTable", "[", 
          RowBox[{"[", "i", "]"}], "]"}]}], "]"}], ",", "\"\<\\n\>\""}], 
      "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"filename", "=", 
     RowBox[{"\"\<Weights_\>\"", "<>", 
      RowBox[{"FuncLabels", "[", 
       RowBox[{"[", "i", "]"}], "]"}], "<>", "\"\<.txt\>\""}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"Export", "[", 
     RowBox[{"filename", ",", "formattedTable", ",", "\"\<Text\>\""}], 
     "]"}]}]}], "\[IndentingNewLine]", "]"}]}], "Input",
 CellChangeTimes->{{3.9565849939465494`*^9, 3.9565850780473433`*^9}, {
   3.956596340763183*^9, 3.956596343363929*^9}, 3.956598514032343*^9, 
   3.956598840479012*^9, 3.9566891136458855`*^9, {3.956790694105418*^9, 
   3.956790694346979*^9}, {3.9573534166888995`*^9, 3.957353417552085*^9}, {
   3.96574937507189*^9, 3.965749467678198*^9}, {3.9657500067391043`*^9, 
   3.965750031042365*^9}, {3.9662954007488623`*^9, 3.9662954031507874`*^9}, {
   3.9662954806974373`*^9, 3.966295562759544*^9}, {3.9663548700664177`*^9, 
   3.9663548701275234`*^9}, {3.966354904228454*^9, 3.966354917570512*^9}, {
   3.9663549518065805`*^9, 3.966354953974055*^9}, {3.966355020494075*^9, 
   3.966355070211819*^9}, {3.9663552610262003`*^9, 3.966355293195022*^9}, {
   3.9663553510643854`*^9, 3.9663553527303753`*^9}, {3.966364889674554*^9, 
   3.966364892061166*^9}},
 CellLabel->
  "In[1115]:=",ExpressionUUID->"c6f30dcf-3117-4f46-b8b9-923b043d3d14"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1278, 1341},
WindowMargins->{{Automatic, 0}, {Automatic, 0}},
Magnification:>1.1 Inherited,
FrontEndVersion->"12.1 for Microsoft Windows (64-bit) (June 19, 2020)",
StyleDefinitions->"ReverseColor.nb",
ExpressionUUID->"2a3c3ac9-52aa-4ee0-aa88-b17a04d014a3"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 2568, 35, 107, "Title",ExpressionUUID->"e8b4790c-cfdb-4f8c-a2f6-82c285868c97"],
Cell[3151, 59, 2240, 34, 126, "Subtitle",ExpressionUUID->"a0191fbe-e215-48a4-8c4f-f26ba47d6f9a"],
Cell[CellGroupData[{
Cell[5416, 97, 356, 6, 73, "Section",ExpressionUUID->"507e86bc-9f42-4233-b3d9-06883a36e4ae"],
Cell[CellGroupData[{
Cell[5797, 107, 303, 5, 59, "Subsection",ExpressionUUID->"d91f3b2c-0440-4cb2-8689-d2b2fefc28b1"],
Cell[6103, 114, 228, 4, 32, "Input",ExpressionUUID->"868b0a4a-0a23-4b4d-8e6d-5e70e42b84a2"],
Cell[6334, 120, 275, 6, 32, "Input",ExpressionUUID->"12acc223-ce39-4b57-946d-7c24fa7087a0"],
Cell[6612, 128, 201, 4, 32, "Input",ExpressionUUID->"80403d44-4f07-4dd5-a191-c73917630ec8"],
Cell[6816, 134, 225, 4, 32, "Input",ExpressionUUID->"58b1b704-9bb1-4e0e-ae8b-3f5f82a2e7e6"],
Cell[7044, 140, 27746, 690, 319, "Input",ExpressionUUID->"c473ffd2-3bc3-43c0-9ec9-4c3420a42063"],
Cell[34793, 832, 468, 14, 32, "Input",ExpressionUUID->"6e1294b1-2f04-4d48-b2d4-8223398a74bf"],
Cell[35264, 848, 159, 4, 32, "Input",ExpressionUUID->"7daf2119-60dd-464d-8c97-410f7c3fe130"],
Cell[35426, 854, 313, 7, 55, "Input",ExpressionUUID->"83646cc2-e906-45ba-a0be-430f1b0c4ca2"],
Cell[35742, 863, 341, 8, 78, "Text",ExpressionUUID->"249fb4f0-36fe-464f-b3c7-f013db6da048"],
Cell[36086, 873, 361, 8, 55, "Input",ExpressionUUID->"5d50b979-e5fe-4a60-90a6-ae3230ea3697"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[36496, 887, 408, 6, 73, "Section",ExpressionUUID->"c185520c-8497-43ef-aaa0-0a1ab0ee7af6"],
Cell[36907, 895, 320, 11, 121, "Text",ExpressionUUID->"5beff186-7c68-4284-bb22-bc532597d091"],
Cell[37230, 908, 2620, 42, 55, "Input",ExpressionUUID->"ed90bb2e-a068-4f77-8983-114504f99343"],
Cell[39853, 952, 3374, 65, 121, "Input",ExpressionUUID->"94823ce5-4b35-4f02-9bc2-98c3b8acc3a2"],
Cell[43230, 1019, 478, 10, 78, "Text",ExpressionUUID->"ec72a229-5317-4662-9e91-dc243846cf0f"],
Cell[43711, 1031, 648, 17, 77, "Input",ExpressionUUID->"6ab770a1-01ea-446b-9614-2d595ec31990"]
}, Open  ]],
Cell[CellGroupData[{
Cell[44396, 1053, 364, 6, 73, "Section",ExpressionUUID->"7f4f10e9-0978-4bf8-adf7-6fc4e0f89d6e"],
Cell[44763, 1061, 681, 14, 32, "Input",ExpressionUUID->"4b84ff37-d71d-4a27-83e1-d8c51373881d"],
Cell[45447, 1077, 568, 11, 32, "Input",ExpressionUUID->"29c7daa0-5949-4413-89fc-23b6e623598a"],
Cell[46018, 1090, 3074, 77, 143, "Input",ExpressionUUID->"dedf4a36-1d7c-43f2-8485-101296f0c64f"],
Cell[49095, 1169, 681, 14, 32, "Input",ExpressionUUID->"ffcb47ad-7076-4ba7-a4b8-d6e3d3f01c70"],
Cell[49779, 1185, 797, 17, 32, "Input",ExpressionUUID->"06f67035-d852-4af8-917b-f4d5c279cee6"],
Cell[50579, 1204, 447, 11, 32, "Input",ExpressionUUID->"facbc342-edff-4602-a751-76a185644a2a"],
Cell[51029, 1217, 444, 11, 32, "Input",ExpressionUUID->"38b32406-490e-4614-bdbc-89bc04dabd99"],
Cell[51476, 1230, 6351, 136, 1331, "Input",ExpressionUUID->"b135e6dc-c46c-4b82-a47c-f6fb95823eb0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[57864, 1371, 543, 8, 73, "Section",ExpressionUUID->"4da85bcb-f3a9-43a4-b946-5d7a514eed39"],
Cell[58410, 1381, 2562, 69, 209, "Input",ExpressionUUID->"57e64dad-ab8d-4f8e-9aaf-55a0ff389b4a"],
Cell[60975, 1452, 207, 4, 32, "Input",ExpressionUUID->"4f3f0d68-fed8-479e-9bfa-31712ef16600"]
}, Open  ]],
Cell[CellGroupData[{
Cell[61219, 1461, 546, 8, 73, "Section",ExpressionUUID->"7871f13e-07da-4b6b-bf8e-7a783f37bea5"],
Cell[61768, 1471, 1011, 23, 52, "Input",ExpressionUUID->"bee6cb48-54d3-47d0-ad65-c8a20c618a7f"],
Cell[62782, 1496, 703, 13, 77, "Input",ExpressionUUID->"ae5033bc-8804-4373-a9a2-c77bd6940b1b"],
Cell[63488, 1511, 1180, 26, 77, "Input",ExpressionUUID->"b2ef92c2-ad03-47f9-812c-0a0716c604d7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[64705, 1542, 546, 8, 73, "Section",ExpressionUUID->"db70bf0f-cfe3-4afa-b44e-0a8f07be726e"],
Cell[65254, 1552, 1002, 25, 53, "Input",ExpressionUUID->"0a829db2-20ff-4a26-b2cd-761041946aa4"],
Cell[66259, 1579, 679, 13, 77, "Input",ExpressionUUID->"4aea3a86-1bf4-4735-a436-1b148255cae0"],
Cell[66941, 1594, 1089, 26, 55, "Input",ExpressionUUID->"92377b9b-434c-4da6-8dca-feb1dc87a8c3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[68067, 1625, 574, 9, 73, "Section",ExpressionUUID->"bf8b89bf-d531-412b-a195-6a08785e36a3"],
Cell[68644, 1636, 1228, 30, 53, "Input",ExpressionUUID->"03ff58bc-fb1c-402c-95a5-21e2aee66941"],
Cell[69875, 1668, 701, 13, 77, "Input",ExpressionUUID->"c25264a6-0f79-4b51-a3ee-c3ed9cb98b65"],
Cell[70579, 1683, 1081, 25, 77, "Input",ExpressionUUID->"151d3dda-3e77-41e9-ba40-352cfcadff54"]
}, Open  ]],
Cell[CellGroupData[{
Cell[71697, 1713, 648, 10, 73, "Section",ExpressionUUID->"beab751f-fa93-4ffe-9246-6098248ae250"],
Cell[72348, 1725, 1071, 24, 52, "Input",ExpressionUUID->"802a77bc-483f-4113-8f89-d8eef16b0522"],
Cell[73422, 1751, 979, 18, 77, "Input",ExpressionUUID->"7911b51d-8ff0-42b7-ad82-ec5a5b82c588"],
Cell[74404, 1771, 1208, 27, 77, "Input",ExpressionUUID->"ecc6d8f2-c788-4805-a289-49304b3578d7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[75649, 1803, 819, 12, 73, "Section",ExpressionUUID->"b4c4a423-bbfe-463a-a517-31f584cfedf8"],
Cell[76471, 1817, 2649, 65, 253, "Input",ExpressionUUID->"1d492bbb-519d-448e-8b4d-e35ae87113ec"],
Cell[79123, 1884, 3149, 76, 231, "Input",ExpressionUUID->"c6f30dcf-3117-4f46-b8b9-923b043d3d14"]
}, Open  ]]
}, Open  ]]
}
]
*)

