(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    132360,       3147]
NotebookOptionsPosition[    126475,       3057]
NotebookOutlinePosition[    126908,       3074]
CellTagsIndexPosition[    126865,       3071]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["GMTKN55 Weights (By Rung) Analysis", "Title",
 CellChangeTimes->{{3.797879013542491*^9, 3.7978790202757607`*^9}, {
   3.8015052504625587`*^9, 3.801505252496401*^9}, {3.801512705184127*^9, 
   3.8015127059220877`*^9}, {3.8080725810932217`*^9, 3.80807258204629*^9}, {
   3.808637638029217*^9, 3.8086376426386304`*^9}, {3.808709680167038*^9, 
   3.808709684544276*^9}, {3.8087097351836815`*^9, 3.8087097435221834`*^9}, {
   3.814413717951748*^9, 3.814413718885742*^9}, {3.8147473738509254`*^9, 
   3.8147473768747416`*^9}, 3.8150446257955523`*^9, {3.816019237760411*^9, 
   3.8160192392785177`*^9}, {3.816020446217802*^9, 3.816020450903527*^9}, {
   3.818495939948073*^9, 3.818495941442936*^9}, {3.829636393240244*^9, 
   3.8296363982133584`*^9}, {3.829662167077368*^9, 3.829662168066966*^9}, {
   3.830290616723291*^9, 3.830290621962493*^9}, 3.830334093976343*^9, {
   3.83053142396451*^9, 3.830531424436616*^9}, {3.8320259040356393`*^9, 
   3.8320259064634714`*^9}, 3.832026057084034*^9, {3.832081441488149*^9, 
   3.832081445322814*^9}, 3.832198496278219*^9, {3.8323781961193967`*^9, 
   3.832378196259062*^9}, 3.8326341699756026`*^9, 3.8329780717686853`*^9, {
   3.8333837529399967`*^9, 3.8333837549576917`*^9}, {3.8333839574939947`*^9, 
   3.8333839710519953`*^9}, {3.833460774852479*^9, 3.833460780573769*^9}, {
   3.8335704629830327`*^9, 3.8335704806594667`*^9}, {3.8349506466891456`*^9, 
   3.8349506508790555`*^9}, {3.835047535057335*^9, 3.8350475726522255`*^9}, 
   3.8354017196073704`*^9, {3.8375709542180567`*^9, 3.8375709554214764`*^9}, 
   3.837738812080212*^9, 3.8378375733744793`*^9, {3.8576774091232057`*^9, 
   3.8576774153285923`*^9}, {3.858971769112599*^9, 3.8589717711240635`*^9}, {
   3.8624362841347213`*^9, 3.8624362859687243`*^9}, 3.862697945675531*^9, 
   3.8627615174878263`*^9, 3.8627898394358177`*^9, {3.863894156558298*^9, 
   3.8638941577752056`*^9}, 3.864495398419282*^9, {3.8645970053795815`*^9, 
   3.8645970068616467`*^9}, {3.865115755382537*^9, 3.8651157554156113`*^9}, 
   3.865270778381764*^9, {3.8653781551983757`*^9, 3.8653781574402432`*^9}, {
   3.879945728987928*^9, 3.8799457308838224`*^9}, 3.879948841259983*^9, {
   3.879954952621377*^9, 3.8799549540039387`*^9}, {3.9169945911057253`*^9, 
   3.916994600427992*^9}, {3.9464137497845078`*^9, 3.9464137831407957`*^9}, {
   3.9565816680566916`*^9, 3.9565816694261208`*^9}, {3.965663540759808*^9, 
   3.965663541357286*^9}, {3.966372253938443*^9, 3.966372256647475*^9}, {
   3.966637481164386*^9, 3.9666374816391044`*^9}, {3.9672378741675205`*^9, 
   3.9672378804359837`*^9}},ExpressionUUID->"e8b4790c-cfdb-4f8c-a2f6-\
82c285868c97"],

Cell["\<\
For plotting and doing statistics for all 115 functionals, partitioned into \
Perdew\[CloseCurlyQuote]s Ladder Rungs, for GMTKN55 for ALL115
Kyle Bryenton 2025-11-18
kyle.bryenton@dal.ca\
\>", "Subtitle",
 CellChangeTimes->{{3.8259515367016363`*^9, 3.8259515481457295`*^9}, {
   3.8296363555235453`*^9, 3.829636363592561*^9}, 3.8296622389748163`*^9, {
   3.829662280794858*^9, 3.829662291249787*^9}, {3.830787820642953*^9, 
   3.830787834013277*^9}, {3.8313045708485894`*^9, 3.831304580009624*^9}, {
   3.8320953423709135`*^9, 3.832095354313024*^9}, 3.83228206786744*^9, {
   3.832378168691453*^9, 3.8323781801034994`*^9}, {3.8324441920909348`*^9, 
   3.832444201710229*^9}, {3.8324487586160955`*^9, 3.8324487591250944`*^9}, {
   3.8324644988930817`*^9, 3.8324644993412466`*^9}, {3.8326212074053016`*^9, 
   3.8326212493946753`*^9}, {3.8326213426871696`*^9, 
   3.8326213436157703`*^9}, {3.8327878865164766`*^9, 
   3.8327878970555696`*^9}, {3.8329857637093697`*^9, 
   3.8329857637743607`*^9}, {3.8330068116486444`*^9, 3.83300681212364*^9}, {
   3.835034974308427*^9, 3.8350349754651814`*^9}, {3.835401713050891*^9, 
   3.8354017168877573`*^9}, {3.8377452905678244`*^9, 3.837745290803586*^9}, 
   3.85767756001378*^9, {3.862761510851385*^9, 3.8627615386924253`*^9}, {
   3.8799549564790955`*^9, 3.879954978202243*^9}, {3.916994603904445*^9, 
   3.916994630403599*^9}, {3.9464137585300026`*^9, 3.946413779941535*^9}, 
   3.946479347959099*^9, {3.9467726285809956`*^9, 3.946772638944997*^9}, {
   3.946842340906331*^9, 3.946842344383188*^9}, {3.9474581585062914`*^9, 
   3.947458160548786*^9}, {3.9556481265778255`*^9, 3.9556481435472155`*^9}, {
   3.9560759693215837`*^9, 3.9560759761951356`*^9}, {3.95658167368425*^9, 
   3.956581718767006*^9}, 3.9566872289770308`*^9, {3.9573531296370845`*^9, 
   3.9573531299721603`*^9}, {3.9656626633708715`*^9, 
   3.9656626648178864`*^9}, {3.9657529525646725`*^9, 3.965752955198642*^9}, 
   3.966028444926873*^9, {3.9666374838333426`*^9, 3.966637483977331*^9}, {
   3.967237900838682*^9, 3.9672379110856223`*^9}, {3.967246809976381*^9, 
   3.9672468234227667`*^9}, {3.9710324548439884`*^9, 3.971032455591282*^9}, {
   3.9710326844066734`*^9, 3.9710326871773357`*^9}, {3.972397915069351*^9, 
   3.9723979151333656`*^9}, {3.9724268391386623`*^9, 
   3.9724268461468844`*^9}},ExpressionUUID->"a0191fbe-e215-48a4-8c4f-\
f26ba47d6f9a"],

Cell[CellGroupData[{

Cell["Setup", "Section",
 CellChangeTimes->{{3.8159098859335394`*^9, 3.8159098936639137`*^9}, {
  3.816020473371563*^9, 3.8160204797198906`*^9}, {3.867287106187972*^9, 
  3.8672871084708767`*^9}, {3.9169979350764914`*^9, 3.9169979369826174`*^9}, {
  3.94641371084194*^9, 
  3.9464137468717747`*^9}},ExpressionUUID->"507e86bc-9f42-4233-b3d9-\
06883a36e4ae"],

Cell[CellGroupData[{

Cell["Preamble", "Subsection",
 CellChangeTimes->{{3.81602099620885*^9, 3.816021017466877*^9}, {
  3.817753674156437*^9, 3.8177536774024324`*^9}, {3.931883848284851*^9, 
  3.931883862152503*^9}, {3.931883956719234*^9, 
  3.9318839620598965`*^9}},ExpressionUUID->"d91f3b2c-0440-4cb2-8689-\
d2b2fefc28b1"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.881072780973341*^9, 3.8810727809817657`*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"868b0a4a-0a23-4b4d-8e6d-5e70e42b84a2"],

Cell[BoxData[
 RowBox[{"SetDirectory", "[", 
  RowBox[{"NotebookDirectory", "[", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.8808316853232927`*^9, 3.880831694714588*^9}, 
   3.9666375378209023`*^9},
 CellLabel->"In[2]:=",ExpressionUUID->"12acc223-ce39-4b57-946d-7c24fa7087a0"],

Cell[BoxData[
 RowBox[{"<<", "MaTeX`"}]], "Input",
 CellChangeTimes->{{3.8374712078059144`*^9, 3.83747121171614*^9}},
 CellLabel->"In[3]:=",ExpressionUUID->"80403d44-4f07-4dd5-a191-c73917630ec8"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MaTeX`\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.8374729714354944`*^9, 3.8374729714424963`*^9}},
 CellLabel->"In[4]:=",ExpressionUUID->"58b1b704-9bb1-4e0e-ae8b-3f5f82a2e7e6"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Colours", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "6"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Colours", "[", 
    RowBox[{"[", "1", "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"RGBColor", "[", "\"\<#5A000F\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#7E0018\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#A40122\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#CD022D\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#F60239\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#FF6E3A\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#FFAC3B\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#FFDC3D\>\"", "]"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Colours", "[", 
    RowBox[{"[", "2", "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"RGBColor", "[", "\"\<#004002\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#005A01\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#007702\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#009503\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#00B408\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#00D302\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#00F407\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#AFFF2A\>\"", "]"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Colours", "[", 
    RowBox[{"[", "3", "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"RGBColor", "[", "\"\<#00306F\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#00489E\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#005FCC\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#0079FA\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#009FFA\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#00C2F9\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#00E5F8\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#7CFFFA\>\"", "]"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Colours", "[", 
    RowBox[{"[", "4", "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"RGBColor", "[", "\"\<#450270\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#65019F\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#8400CD\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#A700FC\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#DA00FD\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#FF3CFE\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#FF92FD\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#FFCCFE\>\"", "]"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Colours", "[", 
    RowBox[{"[", "5", "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"RGBColor", "[", "\"\<#560133\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#790149\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#940162\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#C7007C\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#EF0096\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#FF5AAF\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#FF9DC8\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#FFCFE2\>\"", "]"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Colours", "[", 
    RowBox[{"[", "6", "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"RGBColor", "[", "\"\<#003D30\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#005745\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#00735C\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#009175\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#00AF8E\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#00CBA7\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#00EBC1\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#86FFDE\>\"", "]"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Colour", "=", 
   RowBox[{"{", 
    RowBox[{
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0., 0.4745098039215686, 0.9803921568627451], 
           RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         DefaultBaseStyle->"ColorSwatchGraphics",
         Frame->True,
         FrameStyle->RGBColor[0., 0.31633986928104574`, 0.6535947712418301],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        StyleBox[
         RowBox[{"RGBColor", "[", 
           
           RowBox[{"0.`", ",", "0.4745098039215686`", ",", 
             "0.9803921568627451`"}], "]"}], NumberMarks -> False]],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = 
           RGBColor[0., 0.4745098039215686, 0.9803921568627451]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0., 0.4745098039215686, 0.9803921568627451],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[
           0.6431372549019608, 0.00392156862745098, 0.13333333333333333`], 
           RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         DefaultBaseStyle->"ColorSwatchGraphics",
         Frame->True,
         FrameStyle->RGBColor[
          0.42875816993464055`, 0.0026143790849673205`, 0.08888888888888889],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        StyleBox[
         RowBox[{"RGBColor", "[", 
           
           RowBox[{"0.6431372549019608`", ",", "0.00392156862745098`", ",", 
             "0.13333333333333333`"}], "]"}], NumberMarks -> False]],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = 
           RGBColor[
            0.6431372549019608, 0.00392156862745098, 0.13333333333333333`]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0.6431372549019608, 0.00392156862745098, 0.13333333333333333`],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0., 0.8274509803921568, 0.00784313725490196], 
           RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         DefaultBaseStyle->"ColorSwatchGraphics",
         Frame->True,
         FrameStyle->RGBColor[0., 0.5516339869281046, 0.005228758169934641],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        StyleBox[
         RowBox[{"RGBColor", "[", 
           
           RowBox[{"0.`", ",", "0.8274509803921568`", ",", 
             "0.00784313725490196`"}], "]"}], NumberMarks -> False]],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = 
           RGBColor[0., 0.8274509803921568, 0.00784313725490196]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0., 0.8274509803921568, 0.00784313725490196],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[
           0.27058823529411763`, 0.00784313725490196, 0.4392156862745098], 
           RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         DefaultBaseStyle->"ColorSwatchGraphics",
         Frame->True,
         FrameStyle->RGBColor[
          0.1803921568627451, 0.005228758169934641, 0.2928104575163399],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        StyleBox[
         RowBox[{"RGBColor", "[", 
           
           RowBox[{"0.27058823529411763`", ",", "0.00784313725490196`", ",", 
             "0.4392156862745098`"}], "]"}], NumberMarks -> False]],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = 
           RGBColor[
            0.27058823529411763`, 0.00784313725490196, 0.4392156862745098]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0.27058823529411763`, 0.00784313725490196, 0.4392156862745098],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0., 0.45098039215686275`, 0.3607843137254902], 
           RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         DefaultBaseStyle->"ColorSwatchGraphics",
         Frame->True,
         FrameStyle->RGBColor[0., 0.30065359477124187`, 0.24052287581699347`],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        StyleBox[
         RowBox[{"RGBColor", "[", 
           
           RowBox[{"0.`", ",", "0.45098039215686275`", ",", 
             "0.3607843137254902`"}], "]"}], NumberMarks -> False]],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = 
           RGBColor[0., 0.45098039215686275`, 0.3607843137254902]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0., 0.45098039215686275`, 0.3607843137254902],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1., 0.35294117647058826`, 0.6862745098039216], 
           RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         DefaultBaseStyle->"ColorSwatchGraphics",
         Frame->True,
         FrameStyle->RGBColor[
          0.6666666666666667, 0.23529411764705885`, 0.4575163398692811],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        StyleBox[
         RowBox[{"RGBColor", "[", 
           
           RowBox[{"1.`", ",", "0.35294117647058826`", ",", 
             "0.6862745098039216`"}], "]"}], NumberMarks -> False]],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = 
           RGBColor[1., 0.35294117647058826`, 0.6862745098039216]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1., 0.35294117647058826`, 0.6862745098039216],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1., 0.8627450980392157, 0.23921568627450981`], 
           RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         DefaultBaseStyle->"ColorSwatchGraphics",
         Frame->True,
         FrameStyle->RGBColor[
          0.6666666666666667, 0.5751633986928105, 0.15947712418300655`],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        StyleBox[
         RowBox[{"RGBColor", "[", 
           
           RowBox[{"1.`", ",", "0.8627450980392157`", ",", 
             "0.23921568627450981`"}], "]"}], NumberMarks -> False]],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = 
           RGBColor[1., 0.8627450980392157, 0.23921568627450981`]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1., 0.8627450980392157, 0.23921568627450981`],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0., 0.25098039215686274`, 0.00784313725490196], 
           RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         DefaultBaseStyle->"ColorSwatchGraphics",
         Frame->True,
         FrameStyle->RGBColor[0., 0.1673202614379085, 0.005228758169934641],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        StyleBox[
         RowBox[{"RGBColor", "[", 
           
           RowBox[{"0.`", ",", "0.25098039215686274`", ",", 
             "0.00784313725490196`"}], "]"}], NumberMarks -> False]],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = 
           RGBColor[0., 0.25098039215686274`, 0.00784313725490196]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0., 0.25098039215686274`, 0.00784313725490196],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0., 0.7607843137254902, 0.9764705882352941], 
           RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         DefaultBaseStyle->"ColorSwatchGraphics",
         Frame->True,
         FrameStyle->RGBColor[0., 0.5071895424836601, 0.6509803921568628],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        StyleBox[
         RowBox[{"RGBColor", "[", 
           
           RowBox[{"0.`", ",", "0.7607843137254902`", ",", 
             "0.9764705882352941`"}], "]"}], NumberMarks -> False]],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = 
           RGBColor[0., 0.7607843137254902, 0.9764705882352941]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0., 0.7607843137254902, 0.9764705882352941],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1., 0.8, 0.996078431372549], 
           RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         DefaultBaseStyle->"ColorSwatchGraphics",
         Frame->True,
         FrameStyle->RGBColor[
          0.6666666666666667, 0.5333333333333334, 0.6640522875816994],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        StyleBox[
         RowBox[{"RGBColor", "[", 
           RowBox[{"1.`", ",", "0.8`", ",", "0.996078431372549`"}], "]"}], 
         NumberMarks -> False]],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = 
           RGBColor[1., 0.8, 0.996078431372549]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1., 0.8, 0.996078431372549],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0.33725490196078434`, 0.00392156862745098, 0.2], 
           RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         DefaultBaseStyle->"ColorSwatchGraphics",
         Frame->True,
         FrameStyle->RGBColor[
          0.22483660130718958`, 0.0026143790849673205`, 0.13333333333333336`],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        StyleBox[
         RowBox[{"RGBColor", "[", 
           
           RowBox[{"0.33725490196078434`", ",", "0.00392156862745098`", ",", 
             "0.2`"}], "]"}], NumberMarks -> False]],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = 
           RGBColor[0.33725490196078434`, 0.00392156862745098, 0.2]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0.33725490196078434`, 0.00392156862745098, 0.2],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0.5254901960784314, 1., 0.8705882352941177], 
           RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         DefaultBaseStyle->"ColorSwatchGraphics",
         Frame->True,
         FrameStyle->RGBColor[
          0.35032679738562095`, 0.6666666666666667, 0.5803921568627451],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        StyleBox[
         RowBox[{"RGBColor", "[", 
           
           RowBox[{"0.5254901960784314`", ",", "1.`", ",", 
             "0.8705882352941177`"}], "]"}], NumberMarks -> False]],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = 
           RGBColor[0.5254901960784314, 1., 0.8705882352941177]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0.5254901960784314, 1., 0.8705882352941177],
      Editable->False,
      Selectable->False]}], "}"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.8599246348040857`*^9, 3.859924635591572*^9}, {
  3.8599246761099963`*^9, 3.85992468327722*^9}, {3.881709147033801*^9, 
  3.8817091501026683`*^9}, {3.9169945720697613`*^9, 3.916994574225131*^9}},
 CellLabel->"In[5]:=",ExpressionUUID->"c473ffd2-3bc3-43c0-9ec9-4c3420a42063"],

Cell[BoxData[
 RowBox[{
  RowBox[{"tickFunc", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Charting`ScaledTicks", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Identity", ",", "Identity"}], "}"}], ",", 
       RowBox[{"TicksLength", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{".02", ",", ".01"}], "}"}]}]}], "]"}], "[", "##", "]"}], 
    "&"}]}], ";"}]], "Input",
 CellLabel->"In[13]:=",ExpressionUUID->"6e1294b1-2f04-4d48-b2d4-8223398a74bf"],

Cell[BoxData[
 RowBox[{
  RowBox[{"rescale", "=", "2.0"}], ";"}]], "Input",
 CellLabel->"In[14]:=",ExpressionUUID->"7daf2119-60dd-464d-8c97-410f7c3fe130"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ExportPDF", "=", "True"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ExportPNG", "=", "True"}], ";"}]}], "Input",
 CellChangeTimes->{{3.9560789513094893`*^9, 3.9560789601423674`*^9}},
 CellLabel->"In[15]:=",ExpressionUUID->"83646cc2-e906-45ba-a0be-430f1b0c4ca2"],

Cell["\<\
Set the value to use for Mean[DeltaEBar]
False = Let it calculate Mean[DeltaEBar]
True = Use the fixed value entered on the following line\
\>", "Text",
 CellChangeTimes->{{3.9660259680032883`*^9, 3.966026005768263*^9}, {
  3.966026065395343*^9, 
  3.9660261408229403`*^9}},ExpressionUUID->"249fb4f0-36fe-464f-b3c7-\
f013db6da048"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"DEBfixed", "=", "True"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DEBfixedval", "=", "56.84"}], ";"}]}], "Input",
 CellChangeTimes->{{3.96602600814555*^9, 3.9660260491343393`*^9}, {
  3.966026087585389*^9, 3.966026153130679*^9}},
 CellLabel->"In[17]:=",ExpressionUUID->"5d50b979-e5fe-4a60-90a6-ae3230ea3697"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Data Import", "Section",
 CellChangeTimes->{{3.8159098859335394`*^9, 3.8159098936639137`*^9}, {
  3.816020473371563*^9, 3.8160204797198906`*^9}, {3.867287106187972*^9, 
  3.8672871084708767`*^9}, {3.9169979350764914`*^9, 3.9169979369826174`*^9}, {
  3.94641371084194*^9, 3.946413712127342*^9}, {3.955648158000458*^9, 
  3.9556481583871193`*^9}},ExpressionUUID->"c185520c-8497-43ef-aaa0-\
0a1ab0ee7af6"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"inFilesGGA", "=", 
   RowBox[{"Select", "[", 
    RowBox[{
     RowBox[{"FileNames", "[", 
      RowBox[{"{", "\"\<../06_WEIGHTS_ALL_115/*/GGA/*.txt\>\"", "}"}], "]"}], 
     ",", 
     RowBox[{
      RowBox[{"StringFreeQ", "[", 
       RowBox[{"#", ",", "\"\<NoDisp\>\""}], "]"}], "&"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"inFilesmGGA", "=", 
   RowBox[{"Select", "[", 
    RowBox[{
     RowBox[{"FileNames", "[", 
      RowBox[{"{", "\"\<../06_WEIGHTS_ALL_115/*/mGGA/*.txt\>\"", "}"}], "]"}],
      ",", 
     RowBox[{
      RowBox[{"StringFreeQ", "[", 
       RowBox[{"#", ",", "\"\<NoDisp\>\""}], "]"}], "&"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"inFilesHyb", "=", 
   RowBox[{"Select", "[", 
    RowBox[{
     RowBox[{"FileNames", "[", 
      RowBox[{"{", "\"\<../06_WEIGHTS_ALL_115/*/Hyb/*.txt\>\"", "}"}], "]"}], 
     ",", 
     RowBox[{
      RowBox[{"StringFreeQ", "[", 
       RowBox[{"#", ",", "\"\<NoDisp\>\""}], "]"}], "&"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"inFilesDHyb", "=", 
   RowBox[{"Select", "[", 
    RowBox[{
     RowBox[{"FileNames", "[", 
      RowBox[{"{", "\"\<../06_WEIGHTS_ALL_115/*/DHyb/*.txt\>\"", "}"}], "]"}],
      ",", 
     RowBox[{
      RowBox[{"StringFreeQ", "[", 
       RowBox[{"#", ",", "\"\<NoDisp\>\""}], "]"}], "&"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"inFiles", "=", 
  RowBox[{"Flatten", "[", 
   RowBox[{"{", 
    RowBox[{
    "inFilesGGA", ",", "inFilesmGGA", ",", "inFilesHyb", ",", "inFilesDHyb"}],
     "}"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.955648162362415*^9, 3.9556481758935704`*^9}, {
   3.9657488552668695`*^9, 3.9657488787582955`*^9}, {3.965748925806166*^9, 
   3.96574892683398*^9}, {3.965749481827896*^9, 3.965749482546893*^9}, {
   3.9657497448016953`*^9, 3.9657497453852763`*^9}, {3.965750043930236*^9, 
   3.965750051602558*^9}, {3.9657529932203693`*^9, 3.9657529976124525`*^9}, {
   3.9660262362912416`*^9, 3.966026242106614*^9}, {3.9660284531788683`*^9, 
   3.966028458236166*^9}, {3.966283480622823*^9, 3.9662835093558674`*^9}, 
   3.9662848654954395`*^9, {3.9662861155930843`*^9, 3.9662861156266413`*^9}, {
   3.9663455107109365`*^9, 3.9663455215193872`*^9}, {3.9663456410064316`*^9, 
   3.9663456411064315`*^9}, {3.966353726356678*^9, 3.9663537541312885`*^9}, {
   3.9663537891113577`*^9, 3.966353794774789*^9}, {3.9663538284678664`*^9, 
   3.9663539411116314`*^9}, {3.966354079117476*^9, 3.9663540801201854`*^9}, {
   3.966354123049181*^9, 3.966354162234268*^9}, {3.9663636692871313`*^9, 
   3.9663636727738237`*^9}, {3.966366816543003*^9, 3.966366816986003*^9}, {
   3.9663669023891478`*^9, 3.9663669372712765`*^9}, {3.9663797300591917`*^9, 
   3.966379745469041*^9}, {3.9665312496296425`*^9, 3.966531271530178*^9}, {
   3.9665334680073433`*^9, 3.9665334965262804`*^9}, {3.966533875599331*^9, 
   3.9665339015167475`*^9}, {3.96653407810522*^9, 3.9665340839117546`*^9}, {
   3.967237925203066*^9, 3.9672379278515015`*^9}, {3.9672400608548045`*^9, 
   3.96724006523556*^9}, {3.9672466313775053`*^9, 3.967246636741319*^9}, {
   3.9672467279391785`*^9, 3.967246730476493*^9}, {3.9710324661709447`*^9, 
   3.9710324717000628`*^9}, {3.9710326722104645`*^9, 3.971032682232871*^9}, {
   3.972426850420852*^9, 
   3.972426854503779*^9}},ExpressionUUID->"ed90bb2e-a068-4f77-8983-\
114504f99343"],

Cell[BoxData[
 RowBox[{"Indexes", "=", 
  RowBox[{"1", "+", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{"0", ",", "\[IndentingNewLine]", 
     RowBox[{"Length", "[", "inFilesGGA", "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Length", "[", "inFilesGGA", "]"}], "+", 
      RowBox[{"Length", "[", "inFilesmGGA", "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Length", "[", "inFilesGGA", "]"}], "+", 
      RowBox[{"Length", "[", "inFilesmGGA", "]"}], "+", 
      RowBox[{"Length", "[", "inFilesHyb", "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Length", "[", "inFilesGGA", "]"}], "+", 
      RowBox[{"Length", "[", "inFilesmGGA", "]"}], "+", 
      RowBox[{"Length", "[", "inFilesHyb", "]"}], "+", 
      RowBox[{"Length", "[", "inFilesDHyb", "]"}]}]}], "\[IndentingNewLine]", 
    "}"}]}]}]], "Input",
 CellChangeTimes->{{3.966533500270574*^9, 3.966533560440534*^9}, {
  3.9665335948775735`*^9, 3.966533661432993*^9}, {3.9665337091419683`*^9, 
  3.966533726555873*^9}, {3.966534118503809*^9, 3.96653422169734*^9}, {
  3.966534252844737*^9, 3.966534257079728*^9}},
 CellLabel->"In[24]:=",ExpressionUUID->"f7e0e6db-157c-445e-999d-211b6cf34df5"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"inData", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"Length", "[", "inFiles", "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Data", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"Length", "[", "inFiles", "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"For", "[", 
  RowBox[{
   RowBox[{"i", "=", "1"}], ",", 
   RowBox[{"i", "\[LessEqual]", 
    RowBox[{"Length", "[", "inFiles", "]"}]}], ",", 
   RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"inData", "[", 
      RowBox[{"[", "i", "]"}], "]"}], "=", 
     RowBox[{"Import", "[", 
      RowBox[{
       RowBox[{"inFiles", "[", 
        RowBox[{"[", "i", "]"}], "]"}], ",", "\"\<Table\>\"", ",", 
       RowBox[{"\"\<FieldSeparators\>\"", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\< \>\"", ",", "\"\<\\n\>\""}], "}"}]}]}], "]"}]}], 
    ";"}]}], "\[IndentingNewLine]", "]"}]}], "Input",
 CellChangeTimes->{{3.8088987603844748`*^9, 3.808898760389476*^9}, {
   3.8088987974616737`*^9, 3.808898797699171*^9}, {3.808898955298374*^9, 
   3.8088989745769978`*^9}, {3.8088990204361343`*^9, 
   3.8088990475452023`*^9}, {3.8088993432862167`*^9, 3.8088993488074837`*^9}, 
   3.8089132373770795`*^9, {3.8089133938577895`*^9, 3.8089133946065784`*^9}, {
   3.808914348105073*^9, 3.808914374119644*^9}, {3.8143883775545034`*^9, 
   3.8143883776975117`*^9}, {3.817745247522892*^9, 3.8177452499678764`*^9}, {
   3.818307132829943*^9, 3.8183071427258015`*^9}, {3.832184000310708*^9, 
   3.832184000476708*^9}, {3.832184785705651*^9, 3.8321848128556232`*^9}, {
   3.877375316157969*^9, 3.8773753720445166`*^9}, {3.8773754257529335`*^9, 
   3.877375425903227*^9}, {3.8773761048033004`*^9, 3.8773761243783264`*^9}, {
   3.880490835089597*^9, 3.8804908354891977`*^9}, {3.880491001144314*^9, 
   3.880491058196918*^9}, 3.880585036623171*^9, {3.8808316743775115`*^9, 
   3.8808316744975185`*^9}, {3.88083173553826*^9, 3.8808317548350506`*^9}, {
   3.880831861639245*^9, 3.8808318639946413`*^9}, {3.889702231245826*^9, 
   3.88970223777074*^9}, {3.8897024145049667`*^9, 3.8897025536689067`*^9}, {
   3.889702615469081*^9, 3.8897026188224983`*^9}, {3.889702865915352*^9, 
   3.8897028699672756`*^9}, {3.889702941728506*^9, 3.8897029444915085`*^9}, {
   3.88970298826377*^9, 3.889702999934156*^9}, {3.889703079839328*^9, 
   3.8897030824790154`*^9}, {3.8897031305551376`*^9, 
   3.8897031316048975`*^9}, {3.8897168509214096`*^9, 3.889716863026906*^9}, {
   3.889718077479236*^9, 3.889718102022805*^9}, {3.8939562645703554`*^9, 
   3.8939562652538166`*^9}, {3.9496753559836407`*^9, 
   3.9496754121934814`*^9}, {3.949675454212244*^9, 3.9496754568630953`*^9}, {
   3.9496773381143293`*^9, 3.9496773387519813`*^9}, 3.9496773867862864`*^9, {
   3.949677437142476*^9, 3.949677488351195*^9}, {3.949677540051149*^9, 
   3.949677548830299*^9}, {3.949933271121267*^9, 3.9499332712770205`*^9}, {
   3.951004015176592*^9, 3.9510040162198267`*^9}, {3.9523529248334885`*^9, 
   3.9523529249575167`*^9}, {3.952353188870604*^9, 3.9523531919893055`*^9}, 
   3.9527199394409933`*^9, {3.9657495327359934`*^9, 3.9657495435160108`*^9}, 
   3.9657497403493233`*^9, 3.966354242952199*^9, {3.966354380837802*^9, 
   3.9663543864565396`*^9}},
 CellLabel->"In[25]:=",ExpressionUUID->"94823ce5-4b35-4f02-9bc2-98c3b8acc3a2"],

Cell["\<\
In the data:
The first MAD is one after the first data entry that starts a line with \
\[OpenCurlyDoubleQuote]Subset\[CloseCurlyDoubleQuote]
The last MAD row is 54 rows after that (for a benchmark of 55, tweak if \
necessary)\
\>", "Text",
 CellChangeTimes->{{3.9660252512862234`*^9, 3.966025355089263*^9}, {
  3.9660254555894165`*^9, 3.9660254569784174`*^9}, {3.9660259624472933`*^9, 
  3.966025962931363*^9}},ExpressionUUID->"ec72a229-5317-4662-9e91-\
dc243846cf0f"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"NumBench", "=", "55"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"MADRowi", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"MADRowf", "=", 
   RowBox[{"MADRowi", "+", "NumBench", "-", "1"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.9660253565745077`*^9, 3.9660254127843504`*^9}, {
  3.9660258160189686`*^9, 3.966025839024019*^9}, {3.966354562124361*^9, 
  3.9663545700070486`*^9}},
 CellLabel->"In[28]:=",ExpressionUUID->"6ab770a1-01ea-446b-9614-2d595ec31990"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Data Processing", "Section",
 CellChangeTimes->{{3.8159098859335394`*^9, 3.8159098936639137`*^9}, {
  3.816020473371563*^9, 3.8160204797198906`*^9}, {3.867287106187972*^9, 
  3.8672871084708767`*^9}, {3.9169979350764914`*^9, 3.9169979369826174`*^9}, {
  3.94641371084194*^9, 
  3.946413720636649*^9}},ExpressionUUID->"7f4f10e9-0978-4bf8-adf7-\
6fc4e0f89d6e"],

Cell[BoxData[
 RowBox[{"SystLabels", "=", 
  RowBox[{"inData", "[", 
   RowBox[{"[", 
    RowBox[{"1", ",", 
     RowBox[{"MADRowi", ";;", "MADRowf"}], ",", "1"}], "]"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.9556483296519117`*^9, 3.955648371515128*^9}, {
   3.9556484067417517`*^9, 3.9556484221422234`*^9}, 3.9556490102617936`*^9, {
   3.956076015954112*^9, 3.9560760161631594`*^9}, 3.9565819422816477`*^9, 
   3.9656628325006433`*^9, {3.965749496265916*^9, 3.9657494963989162`*^9}, {
   3.965749760216506*^9, 3.9657497602720904`*^9}, {3.9660258295839863`*^9, 
   3.9660258332930098`*^9}},
 CellLabel->"In[31]:=",ExpressionUUID->"4b84ff37-d71d-4a27-83e1-d8c51373881d"],

Cell[BoxData[
 RowBox[{"FuncLabels", "=", 
  RowBox[{"inData", "[", 
   RowBox[{"[", 
    RowBox[{"All", ",", 
     RowBox[{"MADRowi", "-", "1"}], ",", "1"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.955648431118119*^9, 3.9556484716243095`*^9}, 
   3.9556490067641335`*^9, {3.965662841622142*^9, 3.9656628416908064`*^9}, {
   3.9657495575734243`*^9, 3.9657495577080336`*^9}, {3.9660258470428934`*^9, 
   3.966025849591367*^9}, {3.9662862290238233`*^9, 3.9662862368618355`*^9}, 
   3.966354597733873*^9},
 CellLabel->"In[32]:=",ExpressionUUID->"29c7daa0-5949-4413-89fc-23b6e623598a"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"FuncLabels", "=", 
    RowBox[{"StringReplace", "[", 
     RowBox[{
      RowBox[{"ToString", "/@", "FuncLabels"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<B86bPBE-25\>\"", "\[Rule]", "\"\<B86bPBE0\>\""}], "}"}]}],
      "]"}]}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"FuncLabels", "=", 
     RowBox[{"StringReplace", "[", 
      RowBox[{
       RowBox[{"ToString", "/@", "FuncLabels"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
         "\"\<LC-whPBE\>\"", "\[Rule]", "\"\<LC\[Hyphen]\[Omega]PBEh\>\""}], 
         ",", 
         RowBox[{
         "\"\<LC-wPBE\>\"", "\[Rule]", "\"\<LC\[Hyphen]\[Omega]PBE\>\""}]}], 
        "}"}]}], "]"}]}], ";"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"FuncLabels", "=", 
     RowBox[{"StringReplace", "[", 
      RowBox[{
       RowBox[{"ToString", "/@", "FuncLabels"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\"\<-\>\"", "\[Rule]", "\"\<\[Hyphen]\>\""}], ",", 
         RowBox[{"\"\<\[Dash]\>\"", "\[Rule]", "\"\<\[Hyphen]\>\""}], ",", 
         RowBox[{"\"\<\[LongDash]\>\"", "\[Rule]", "\"\<\[Hyphen]\>\""}], ",", 
         RowBox[{"\"\<\[AHat]\>\"", "\[Rule]", "\"\<\[Hyphen]\>\""}]}], 
        "}"}]}], "]"}]}], ";"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"SystLabels", "=", 
     RowBox[{"StringReplace", "[", 
      RowBox[{
       RowBox[{"ToString", "/@", "SystLabels"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\"\<-\>\"", "\[Rule]", "\"\<\[Hyphen]\>\""}], ",", 
         RowBox[{"\"\<\[Dash]\>\"", "\[Rule]", "\"\<\[Hyphen]\>\""}], ",", 
         RowBox[{"\"\<\[LongDash]\>\"", "\[Rule]", "\"\<\[Hyphen]\>\""}], ",", 
         RowBox[{"\"\<\[AHat]\>\"", "\[Rule]", "\"\<\[Hyphen]\>\""}]}], 
        "}"}]}], "]"}]}], ";"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"SystLabels", "[", 
      RowBox[{"[", 
       RowBox[{"-", "2"}], "]"}], "]"}], "=", 
     RowBox[{"Style", "[", 
      RowBox[{"\"\<WTMAD\[Hyphen]1\>\"", ",", 
       RowBox[{"FontFamily", "\[Rule]", "\"\<Calibri\>\""}], ",", "Bold"}], 
      "]"}]}], ";"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"SystLabels", "[", 
      RowBox[{"[", 
       RowBox[{"-", "1"}], "]"}], "]"}], "=", 
     RowBox[{"Style", "[", 
      RowBox[{"\"\<WTMAD\[Hyphen]2\>\"", ",", 
       RowBox[{"FontFamily", "\[Rule]", "\"\<Calibri\>\""}], ",", "Bold"}], 
      "]"}]}], ";"}], "*)"}]}]}], "Input",
 CellChangeTimes->{{3.9556485783758965`*^9, 3.9556486956121125`*^9}, {
   3.955648801693203*^9, 3.955648879889615*^9}, {3.955648924685316*^9, 
   3.955649008063907*^9}, {3.955651432455698*^9, 3.955651441511552*^9}, {
   3.9560761572450104`*^9, 3.956076161194902*^9}, {3.956582763902437*^9, 
   3.9565827670430584`*^9}, {3.965662877913316*^9, 3.965662899973474*^9}, {
   3.9657489690237284`*^9, 3.9657490637883863`*^9}, {3.966345651507435*^9, 
   3.9663456683219213`*^9}, {3.9663546560240793`*^9, 3.9663546706122055`*^9}, 
   3.9663547076395807`*^9, {3.96636369389456*^9, 3.966363698081045*^9}},
 CellLabel->"In[33]:=",ExpressionUUID->"dedf4a36-1d7c-43f2-8485-101296f0c64f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Data", "=", 
   RowBox[{"inData", "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", 
      RowBox[{"MADRowi", ";;", "MADRowf"}], ",", 
      RowBox[{"2", ";;"}]}], "]"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.955648482441185*^9, 3.9556485161649666`*^9}, {
   3.955650356862707*^9, 3.955650364977623*^9}, {3.9560760020689774`*^9, 
   3.956076002181002*^9}, 3.956582153529072*^9, {3.9656629342301617`*^9, 
   3.9656629553778687`*^9}, {3.965749563029042*^9, 3.965749563535043*^9}, 
   3.9660258676760817`*^9, {3.9662943706070023`*^9, 3.966294372035325*^9}, {
   3.966363847640196*^9, 3.9663638483964653`*^9}},
 CellLabel->"In[34]:=",ExpressionUUID->"ffcb47ad-7076-4ba7-a4b8-d6e3d3f01c70"],

Cell[BoxData[
 RowBox[{
  RowBox[{"DClabel", "=", 
   RowBox[{"StringReplace", "[", 
    RowBox[{
     RowBox[{"FileBaseName", "/@", "inFiles"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<bj\>\"", "\[Rule]", "\"\<(BJ)\>\""}], ",", 
       RowBox[{"\"\<z\>\"", "\[Rule]", "\"\<(Z)\>\""}], ",", 
       RowBox[{"\"\<ProcessGMTKN55_\>\"", "\[Rule]", "\"\<\>\""}]}], "}"}]}], 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.955649062290451*^9, 3.9556490693484697`*^9}, {
   3.955649106230855*^9, 3.955649122085611*^9}, {3.9556491875768585`*^9, 
   3.9556492409545608`*^9}, {3.9657496136820536`*^9, 3.965749616946109*^9}, {
   3.9657497883524694`*^9, 3.965749788541542*^9}, {3.9662943833347845`*^9, 
   3.966294394214982*^9}, 3.966363723964688*^9},
 CellLabel->"In[35]:=",ExpressionUUID->"06f67035-d852-4af8-917b-f4d5c279cee6"],

Cell[BoxData[
 RowBox[{"NSysts", "=", 
  RowBox[{"inData", "[", 
   RowBox[{"[", 
    RowBox[{"1", ",", 
     RowBox[{"MADRowi", ";;", "MADRowf"}], ",", "2"}], "]"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.9565823374180436`*^9, 3.956582365099651*^9}, 
   3.9656629706048784`*^9, {3.9657495647857285`*^9, 3.9657495649335704`*^9}, 
   3.9660258712380576`*^9},
 CellLabel->"In[36]:=",ExpressionUUID->"facbc342-edff-4602-a751-76a185644a2a"],

Cell[BoxData[
 RowBox[{"DeltEBi", "=", 
  RowBox[{"inData", "[", 
   RowBox[{"[", 
    RowBox[{"1", ",", 
     RowBox[{"MADRowi", ";;", "MADRowf"}], ",", "3"}], "]"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.9565823717894907`*^9, 3.9565823821017013`*^9}, 
   3.9656629758908873`*^9, {3.965749566363551*^9, 3.965749566515036*^9}, 
   3.966025873451207*^9},
 CellLabel->"In[37]:=",ExpressionUUID->"38b32406-490e-4614-bdbc-89bc04dabd99"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"GMTKN55info", "=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
    "\"\<AL2X6        6     35.88     1.0    0    2.67 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<ALK8         8     62.60     1.0    0    1.30 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<ALKBDE10    10    100.69     0.1    0    1.25 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<BH76RC      30     21.39     1.0    0    2.85 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<DC13        13     54.98     1.0    0    0.881\>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<DIPCS10     10    654.26     0.1    0    1.37 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<FH51        51     31.01     1.0    0    2.82 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<G21EA       25     33.62     1.0    0    2.37 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<G21IP       36    257.61     0.1    0    1.93 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<G2RC        25     51.26     1.0    0    1.42 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<HEAVYSB11   11     58.02     1.0    0    1.97 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<NBPRC       12     27.71     1.0    0    3.09 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<PA26        26    189.05     0.1    0    2.32 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<RC21        21     35.70     1.0    0    1.82 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<SIE4x4      16     33.72     1.0    0    0.486\>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<TAUT15      15      3.05    10.0    0    6.01 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<W4-11      140    306.91     0.1    0    1.12 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<YBDE18      18     49.28     1.0    0    2.26 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<BSR36       36     16.20     1.0    1    2.87 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<C60ISO       9     98.25     0.1    1    1.08 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<CDIE20      20      4.06    10.0    1    6.60 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<DARC        14     32.47     1.0    1    1.77 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<ISO34       34     14.57     1.0    1    5.04 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<ISOL24      24     21.92     1.0    1    2.02 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<MB16-43     43    468.39     0.1    1    0.299\>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<PArel       20      4.63    10.0    1    5.90 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<RSE43       43      7.60     1.0    1    4.45 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<BH76        76     18.61     1.0    2    1.56 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<BHDIV10     10     45.33     1.0    2    1.80 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<BHPERI      26     20.87     1.0    2    2.35 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<BHROT27     27      6.27    10.0    2   14.3  \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<INV24       24     31.85     1.0    2    4.47 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<PX13        13     33.36     1.0    2    1.38 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<WCPT18      18     34.99     1.0    2    1.93 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<ADIM6        6      3.36    10.0    3   17.4  \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<AHB21       21     22.49     1.0    3    8.15 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<CARBHB12    12      6.04    10.0    3    7.28 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<CHB6         6     26.79     1.0    3    4.18 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<HAL59       59      4.59    10.0    3    9.09 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<HEAVY28     28      1.24    10.0    3   14.6  \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<IL16        16    109.04     0.1    3    9.95 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<PNICO23     23      4.27    10.0    3    9.22 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<RG18        18      0.58    10.0    3   26.0  \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<S22         22      7.30    10.0    3   16.4  \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<S66         66      5.47    10.0    3   19.8  \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<WATER27     27     81.14     0.1    3    1.68 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<ACONF       15      1.83    10.0    4   44.0  \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<Amino20x4   80      2.44    10.0    4   23.2  \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<BUT14DIOL   64      2.80    10.0    4   25.8  \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<ICONF       17      3.27    10.0    4   22.2  \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<IDISP        6     14.22     1.0    4    2.55 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<MCONF       51      4.97    10.0    4   15.8  \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<PCONF21     18      1.62    10.0    4    8.98 \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<SCONF       17      4.60    10.0    4   15.8  \>\"", ",", 
     "\[IndentingNewLine]", 
     "\"\<UPU23       23      5.72    10.0    4   11.6  \>\""}], 
    "\[IndentingNewLine]", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"GMTKN55info", "=", 
   RowBox[{"StringSplit", "[", "GMTKN55info", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"GMTKN55info", "=", 
   RowBox[{"GMTKN55info", "/.", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "name_", ",", "a_", ",", "b_", ",", "c_", ",", "d_", ",", "e_"}], "}"}],
      "\[RuleDelayed]", 
     RowBox[{"{", 
      RowBox[{"name", ",", 
       RowBox[{"ToExpression", "[", "a", "]"}], ",", 
       RowBox[{"ToExpression", "[", "b", "]"}], ",", 
       RowBox[{"ToExpression", "[", "c", "]"}], ",", 
       RowBox[{"ToExpression", "[", "d", "]"}], ",", 
       RowBox[{"ToExpression", "[", "e", "]"}]}], "}"}]}]}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.9565873189531374`*^9, 3.9565873266898837`*^9}, {
   3.956587372565295*^9, 3.9565873776934524`*^9}, {3.9565874411591663`*^9, 
   3.9565874729943533`*^9}, {3.956587522226666*^9, 3.956587631645376*^9}, 
   3.956587663410554*^9, {3.9565879003272886`*^9, 3.9565879039691105`*^9}, {
   3.9565911144826508`*^9, 3.9565911371576414`*^9}, {3.956687863916028*^9, 
   3.956687904945864*^9}, 3.956688011693816*^9, 3.9566883069193892`*^9, {
   3.9567898267715673`*^9, 3.956789843776102*^9}, 3.956789929383156*^9, {
   3.9567899665067644`*^9, 3.9567900103933134`*^9}, {3.956790237022877*^9, 
   3.956790238922575*^9}, {3.9567904081272464`*^9, 3.956790409806177*^9}, {
   3.9656630999111185`*^9, 3.965663146123706*^9}, {3.9657528343601933`*^9, 
   3.96575287133625*^9}, {3.965752919476329*^9, 3.9657529438783674`*^9}, {
   3.9663455468975077`*^9, 3.966345556652259*^9}, {3.967232109463114*^9, 
   3.967232143047979*^9}, 3.9710325633330345`*^9, 3.9710327610523243`*^9},
 CellLabel->"In[38]:=",ExpressionUUID->"39d24e79-8b77-4991-adab-36f76815c090"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Calculate WTMAD Percentiles", "Section",
 CellChangeTimes->{{3.8159098859335394`*^9, 3.8159098936639137`*^9}, {
   3.816020473371563*^9, 3.8160204797198906`*^9}, {3.867287106187972*^9, 
   3.8672871084708767`*^9}, {3.9169979350764914`*^9, 
   3.9169979369826174`*^9}, {3.94641371084194*^9, 3.9464137299645586`*^9}, 
   3.9556493624167347`*^9, {3.9556542149812284`*^9, 3.9556542185457573`*^9}, {
   3.9565872139918404`*^9, 3.9565872150360765`*^9}, {3.956587245363923*^9, 
   3.9565872461460996`*^9}, {3.966374588928936*^9, 
   3.96637459278498*^9}},ExpressionUUID->"4da85bcb-f3a9-43a4-b946-\
5d7a514eed39"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"WTMAD1", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "4"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"WTMAD2", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "4"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"WTMAD3", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "4"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"WTMAD4", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "4"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"For", "[", 
  RowBox[{
   RowBox[{"i", "=", "1"}], ",", 
   RowBox[{"i", "\[LessEqual]", "4"}], ",", 
   RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"WTMAD1", "[", 
      RowBox[{"[", "i", "]"}], "]"}], "=", 
     RowBox[{"Flatten", "[", 
      RowBox[{"Data", "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{
          RowBox[{"Indexes", "[", 
           RowBox[{"[", "i", "]"}], "]"}], ";;", 
          RowBox[{
           RowBox[{"Indexes", "[", 
            RowBox[{"[", 
             RowBox[{"i", "+", "1"}], "]"}], "]"}], "-", "1"}]}], ",", "All", 
         ",", "1"}], "]"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"WTMAD2", "[", 
      RowBox[{"[", "i", "]"}], "]"}], "=", 
     RowBox[{"Flatten", "[", 
      RowBox[{"Data", "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{
          RowBox[{"Indexes", "[", 
           RowBox[{"[", "i", "]"}], "]"}], ";;", 
          RowBox[{
           RowBox[{"Indexes", "[", 
            RowBox[{"[", 
             RowBox[{"i", "+", "1"}], "]"}], "]"}], "-", "1"}]}], ",", "All", 
         ",", "2"}], "]"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"WTMAD3", "[", 
      RowBox[{"[", "i", "]"}], "]"}], "=", 
     RowBox[{"Flatten", "[", 
      RowBox[{"Data", "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{
          RowBox[{"Indexes", "[", 
           RowBox[{"[", "i", "]"}], "]"}], ";;", 
          RowBox[{
           RowBox[{"Indexes", "[", 
            RowBox[{"[", 
             RowBox[{"i", "+", "1"}], "]"}], "]"}], "-", "1"}]}], ",", "All", 
         ",", "3"}], "]"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"WTMAD4", "[", 
      RowBox[{"[", "i", "]"}], "]"}], "=", 
     RowBox[{"Flatten", "[", 
      RowBox[{"Data", "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{
          RowBox[{"Indexes", "[", 
           RowBox[{"[", "i", "]"}], "]"}], ";;", 
          RowBox[{
           RowBox[{"Indexes", "[", 
            RowBox[{"[", 
             RowBox[{"i", "+", "1"}], "]"}], "]"}], "-", "1"}]}], ",", "All", 
         ",", "4"}], "]"}], "]"}], "]"}]}], ";"}]}], "\[IndentingNewLine]", 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"WTMADs", "=", 
   RowBox[{"{", 
    RowBox[{"WTMAD1", ",", "WTMAD2", ",", "WTMAD3", ",", "WTMAD4"}], "}"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.966364312760062*^9, 3.966364339164132*^9}, {
  3.966367361701786*^9, 3.966367376175022*^9}, {3.966622644246907*^9, 
  3.966622691392867*^9}, {3.9666229177643337`*^9, 3.966622942086197*^9}, {
  3.9666251446734467`*^9, 3.966625238405157*^9}},
 CellLabel->"In[41]:=",ExpressionUUID->"3dce7b5b-311e-44db-9760-0b83e24a1702"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"BSFS", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "4"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"ResTable", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "4"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"For", "[", 
  RowBox[{
   RowBox[{"i", "=", "1"}], ",", 
   RowBox[{"i", "\[LessEqual]", "4"}], ",", 
   RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"BSFS", "[", 
      RowBox[{"[", "i", "]"}], "]"}], "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Quantile", "[", 
             RowBox[{"#", ",", "0.00"}], "]"}], ",", 
            RowBox[{"Quantile", "[", 
             RowBox[{"#", ",", "0.02"}], "]"}], ",", 
            RowBox[{"Quantile", "[", 
             RowBox[{"#", ",", "0.10"}], "]"}], ",", 
            RowBox[{"Quantile", "[", 
             RowBox[{"#", ",", "0.25"}], "]"}], ",", 
            RowBox[{"Quantile", "[", 
             RowBox[{"#", ",", "0.50"}], "]"}], ",", 
            RowBox[{"Quantile", "[", 
             RowBox[{"#", ",", "0.75"}], "]"}], ",", 
            RowBox[{"Quantile", "[", 
             RowBox[{"#", ",", "0.90"}], "]"}], ",", 
            RowBox[{"Quantile", "[", 
             RowBox[{"#", ",", "0.98"}], "]"}], ",", 
            RowBox[{"Quantile", "[", 
             RowBox[{"#", ",", "1.00"}], "]"}]}], "}"}], "&"}], ")"}], "[", 
        RowBox[{"WTMADs", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "j"}], "]"}], "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "1", ",", "4"}], "}"}]}], "]"}]}], ";", 
    RowBox[{
     RowBox[{"ResTable", "[", 
      RowBox[{"[", "i", "]"}], "]"}], "=", 
     RowBox[{"Prepend", "[", 
      RowBox[{
       RowBox[{"Transpose", "[", 
        RowBox[{"Prepend", "[", 
         RowBox[{
          RowBox[{"BSFS", "[", 
           RowBox[{"[", "i", "]"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{
           "\"\<0%\>\"", ",", "\"\<2%\>\"", ",", "\"\<10%\>\"", ",", 
            "\"\<25%\>\"", ",", "\"\<50%\>\"", ",", "\"\<75%\>\"", ",", 
            "\"\<90%\>\"", ",", "\"\<98%\>\"", ",", "\"\<100%\>\""}], "}"}]}],
          "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "\"\<Quantile\>\"", ",", "\"\<GGA\>\"", ",", "\"\<mGGA\>\"", ",", 
         "\"\<Hyb\>\"", ",", "\"\<D.Hyb\>\""}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "\"\<WTMAD-1\>\"", ",", "\"\<WTMAD-2\>\"", ",", "\"\<WTMAD-3\>\"", 
        ",", "\"\<WTMAD-4\>\""}], "}"}], "[", 
      RowBox[{"[", "i", "]"}], "]"}], "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Print", "[", 
     RowBox[{"NumberForm", "[", 
      RowBox[{
       RowBox[{"MatrixForm", "[", 
        RowBox[{"ResTable", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "2"}], "}"}]}], "]"}], "]"}]}]}], 
  "\[IndentingNewLine]", "]"}]}], "Input",
 CellChangeTimes->{{3.9663670394993477`*^9, 3.9663671708425245`*^9}, {
   3.96636722534833*^9, 3.9663672557496524`*^9}, {3.966367313890738*^9, 
   3.966367321125407*^9}, {3.966367353756894*^9, 3.966367390291856*^9}, {
   3.9663674655869837`*^9, 3.9663674666681614`*^9}, {3.9663675426145034`*^9, 
   3.9663675436315327`*^9}, {3.966367618678361*^9, 3.966367618917225*^9}, {
   3.9663676958136854`*^9, 3.966367841360792*^9}, {3.9663680022453227`*^9, 
   3.9663680221508484`*^9}, 3.966374097065096*^9, {3.966374147450289*^9, 
   3.9663741687789702`*^9}, {3.9663742071384788`*^9, 
   3.9663742579024534`*^9}, {3.9663743040311613`*^9, 3.966374332076585*^9}, {
   3.9666229062401667`*^9, 3.966622911728523*^9}, {3.9666256539916916`*^9, 
   3.9666257078900585`*^9}, {3.9666260095504103`*^9, 3.966626116126764*^9}, {
   3.9666261901810436`*^9, 3.9666261943689823`*^9}, {3.9666262245498257`*^9, 
   3.9666262247544575`*^9}, {3.966626463125222*^9, 3.9666264741189404`*^9}, {
   3.966626715126007*^9, 3.966626742418123*^9}, {3.9672395803520584`*^9, 
   3.9672395815413065`*^9}},
 CellLabel->"In[47]:=",ExpressionUUID->"97618960-d04f-43b3-bba5-4144e12ac459"]
}, Open  ]],

Cell[CellGroupData[{

Cell["WTMAD-1 Plots", "Section",
 CellChangeTimes->{{3.8159098859335394`*^9, 3.8159098936639137`*^9}, {
   3.816020473371563*^9, 3.8160204797198906`*^9}, {3.867287106187972*^9, 
   3.8672871084708767`*^9}, {3.9169979350764914`*^9, 
   3.9169979369826174`*^9}, {3.94641371084194*^9, 3.9464137299645586`*^9}, 
   3.9556493624167347`*^9, {3.9556542149812284`*^9, 3.9556542185457573`*^9}, {
   3.9565872139918404`*^9, 3.9565872150360765`*^9}, {3.956587245363923*^9, 
   3.9565872461460996`*^9}, {3.966374588928936*^9, 3.966374598259987*^9}, 
   3.9663779608470335`*^9, {3.966632679186081*^9, 3.9666326992270985`*^9}, {
   3.9666327484395742`*^9, 3.966632759252195*^9}, {3.966632798287071*^9, 
   3.9666327988042307`*^9}, 
   3.9666328484416695`*^9},ExpressionUUID->"bb7e17d6-8818-48e6-95b9-\
03fdef2485be"],

Cell[BoxData[
 RowBox[{"binwidth", "=", "0.5"}]], "Input",
 CellChangeTimes->{{3.9666329987149324`*^9, 3.966633002479533*^9}, {
  3.966633038480692*^9, 3.96663306708177*^9}},
 CellLabel->"In[50]:=",ExpressionUUID->"4cb68737-6fd7-4d6d-96d2-75bbb75c0bd3"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"binWidth1", "=", "binwidth"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xVals1", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"i", "*", "binWidth1"}], "-", 
      RowBox[{"binWidth1", "/", "2"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{
        RowBox[{"Ceiling", "[", 
         RowBox[{
          RowBox[{"Max", "[", "WTMAD1", "]"}], ",", "binWidth1"}], "]"}], "/",
         "binWidth1"}]}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"RoundedWTMADs1", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Ceiling", "[", 
      RowBox[{
       RowBox[{"WTMAD1", "[", 
        RowBox[{"[", "i", "]"}], "]"}], ",", "binWidth1"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "4"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"CountedWTMADs1", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Count", "[", 
        RowBox[{
         RowBox[{"RoundedWTMADs1", "[", 
          RowBox[{"[", "i", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"xVals1", "[", 
           RowBox[{"[", "j", "]"}], "]"}], "+", 
          RowBox[{"binWidth1", "/", "2"}]}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "1", ",", 
         RowBox[{"Length", "[", "xVals1", "]"}]}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "4"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"yVals1", "=", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"CountedWTMADs1", "/", 
      RowBox[{"Total", "[", 
       RowBox[{"CountedWTMADs1", ",", 
        RowBox[{"{", "2", "}"}]}], "]"}]}], "/", "binWidth1"}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.966377797788622*^9, 3.966377829161189*^9}, {
   3.966377871680254*^9, 3.96637793324448*^9}, {3.9663780085505075`*^9, 
   3.9663780319381084`*^9}, {3.9663780700848136`*^9, 
   3.9663781537028627`*^9}, {3.9663782083885593`*^9, 
   3.9663782120822954`*^9}, {3.9663784295958996`*^9, 3.966378437622893*^9}, 
   3.9666216530485907`*^9, {3.9666279380097704`*^9, 3.966627938573854*^9}, {
   3.966632305840418*^9, 3.9666323865060234`*^9}, {3.9666324487957425`*^9, 
   3.966632458592132*^9}, {3.966632707602121*^9, 3.9666328903638954`*^9}, 
   3.9666330066977053`*^9},
 CellLabel->"In[51]:=",ExpressionUUID->"534a3aa5-7d18-440b-afbb-61287f72b1c5"],

Cell[BoxData[
 RowBox[{"WTMAD1RungHistogram", "=", 
  RowBox[{"ListPlot", "[", 
   RowBox[{
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Transpose", "[", 
       RowBox[{"{", 
        RowBox[{"xVals1", ",", 
         RowBox[{"yVals1", "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], "}"}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Transpose", "[", 
       RowBox[{"{", 
        RowBox[{"xVals1", ",", 
         RowBox[{"yVals1", "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], "}"}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Transpose", "[", 
       RowBox[{"{", 
        RowBox[{"xVals1", ",", 
         RowBox[{"yVals1", "[", 
          RowBox[{"[", "3", "]"}], "]"}]}], "}"}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Transpose", "[", 
       RowBox[{"{", 
        RowBox[{"xVals1", ",", 
         RowBox[{"yVals1", "[", 
          RowBox[{"[", "4", "]"}], "]"}]}], "}"}], "]"}]}], 
     "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
    RowBox[{"InterpolationOrder", "\[Rule]", "3"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Colours", "[", 
          RowBox[{"[", 
           RowBox[{"3", ",", "1"}], "]"}], "]"}], ",", 
         RowBox[{"Thickness", "[", "0.01", "]"}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Colours", "[", 
          RowBox[{"[", 
           RowBox[{"3", ",", "3"}], "]"}], "]"}], ",", 
         RowBox[{"Thickness", "[", "0.01", "]"}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Colours", "[", 
          RowBox[{"[", 
           RowBox[{"3", ",", "6"}], "]"}], "]"}], ",", 
         RowBox[{"Thickness", "[", "0.01", "]"}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Colours", "[", 
          RowBox[{"[", 
           RowBox[{"3", ",", "8"}], "]"}], "]"}], ",", 
         RowBox[{"Thickness", "[", "0.01", "]"}]}], "}"}]}], 
      "\[IndentingNewLine]", "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"binWidth1", "-", 
          RowBox[{"binWidth1", "/", "2"}]}], ",", "6.07"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0.72"}], "}"}]}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"Filling", "\[Rule]", "Axis"}], ",", "\[IndentingNewLine]", 
    RowBox[{"Frame", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"True", ",", "True"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"True", ",", "True"}], "}"}]}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"FrameLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
      "\"\<WTMAD-1 Contribution (%)\>\"", ",", 
       "\"\<Smoothed Occurence Density\>\""}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"FrameTicks", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"tickFunc", ",", "tickFunc"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"tickFunc", ",", "tickFunc"}], "}"}]}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"FrameTicksStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", "}"}], ",", 
         RowBox[{"Directive", "[", 
          RowBox[{
           RowBox[{"FontOpacity", "\[Rule]", "0"}], ",", 
           RowBox[{"FontSize", "\[Rule]", "0"}]}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", "}"}], ",", 
         RowBox[{"Directive", "[", 
          RowBox[{
           RowBox[{"FontOpacity", "\[Rule]", "0"}], ",", 
           RowBox[{"FontSize", "\[Rule]", "0"}]}], "]"}]}], "}"}]}], "}"}]}], 
    ",", "\[IndentingNewLine]", 
    RowBox[{"FrameStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Black", ",", 
       RowBox[{"FontSize", "\[Rule]", "24"}], ",", 
       RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}], ",", 
       RowBox[{"AbsoluteThickness", "[", "2.5", "]"}]}], "]"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}], ",", "22"}], 
      "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"ImageSize", "\[Rule]", 
     RowBox[{"Automatic", "\[Rule]", "500"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"Background", "\[Rule]", "White"}], ",", "\[IndentingNewLine]", 
    RowBox[{"PlotLegends", "\[Rule]", 
     RowBox[{"Placed", "[", 
      RowBox[{
       RowBox[{"LineLegend", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Directive", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Colours", "[", 
               RowBox[{"[", 
                RowBox[{"3", ",", "1"}], "]"}], "]"}], ",", 
              RowBox[{"Thickness", "[", "0.02", "]"}]}], "}"}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Directive", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Colours", "[", 
               RowBox[{"[", 
                RowBox[{"3", ",", "3"}], "]"}], "]"}], ",", 
              RowBox[{"Thickness", "[", "0.02", "]"}]}], "}"}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Directive", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Colours", "[", 
               RowBox[{"[", 
                RowBox[{"3", ",", "6"}], "]"}], "]"}], ",", 
              RowBox[{"Thickness", "[", "0.02", "]"}]}], "}"}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Directive", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Colours", "[", 
               RowBox[{"[", 
                RowBox[{"3", ",", "8"}], "]"}], "]"}], ",", 
              RowBox[{"Thickness", "[", "0.02", "]"}]}], "}"}], "]"}]}], 
          "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
          "\"\<GGA\>\"", ",", "\"\<meta-GGA\>\"", ",", "\"\<Hybrid\>\"", ",", 
           "\"\<Double Hybrid\>\""}], "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Spacings", "\[Rule]", "0.3"}], ",", "\[IndentingNewLine]", 
         RowBox[{"LabelStyle", "\[Rule]", " ", 
          RowBox[{"{", 
           RowBox[{"Black", ",", 
            RowBox[{"FontSize", "\[Rule]", "22"}], ",", 
            RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}], ",", 
            RowBox[{"AbsoluteThickness", "[", "0.01", "]"}]}], "}"}]}]}], 
        "\[IndentingNewLine]", "]"}], ",", 
       RowBox[{"ImageScaled", "[", 
        RowBox[{"{", 
         RowBox[{"0.82", ",", "0.75"}], "}"}], "]"}]}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellChangeTimes->{{3.966376028481183*^9, 3.966376058217229*^9}, {
   3.9663761345293517`*^9, 3.9663762384414883`*^9}, {3.9663762746169033`*^9, 
   3.9663763369886684`*^9}, {3.966376466023944*^9, 3.9663765119663277`*^9}, {
   3.9663766888301907`*^9, 3.96637683515719*^9}, {3.966377022768714*^9, 
   3.9663770285706635`*^9}, {3.966377836092952*^9, 3.9663778476545725`*^9}, {
   3.9663782534347057`*^9, 3.9663783139427233`*^9}, {3.9663783565656815`*^9, 
   3.9663783847037773`*^9}, {3.966378454244919*^9, 3.966378458518938*^9}, 
   3.966378930805218*^9, {3.966378969184052*^9, 3.9663789716737413`*^9}, {
   3.9666199482408924`*^9, 3.966620023724921*^9}, {3.9666200828465853`*^9, 
   3.966620093094146*^9}, {3.966632486239854*^9, 3.966632510174824*^9}, {
   3.966632549477291*^9, 3.9666326532900476`*^9}, {3.9666327370679417`*^9, 
   3.966632742803191*^9}, {3.9666327855582323`*^9, 3.9666328692333307`*^9}, {
   3.9666329053799987`*^9, 3.96663292371955*^9}, {3.966633132621153*^9, 
   3.9666332063287816`*^9}, {3.9666332417323055`*^9, 3.9666332586336174`*^9}, 
   3.9666374747113714`*^9, {3.966638278926343*^9, 3.966638286148353*^9}, {
   3.97103439887036*^9, 3.971034398936374*^9}},
 CellLabel->"In[56]:=",ExpressionUUID->"6de23389-3c0b-4f8b-adcb-2d4e35c1cc26"]
}, Open  ]],

Cell[CellGroupData[{

Cell["WTMAD-2 Plots", "Section",
 CellChangeTimes->{{3.8159098859335394`*^9, 3.8159098936639137`*^9}, {
   3.816020473371563*^9, 3.8160204797198906`*^9}, {3.867287106187972*^9, 
   3.8672871084708767`*^9}, {3.9169979350764914`*^9, 
   3.9169979369826174`*^9}, {3.94641371084194*^9, 3.9464137299645586`*^9}, 
   3.9556493624167347`*^9, {3.9556542149812284`*^9, 3.9556542185457573`*^9}, {
   3.9565872139918404`*^9, 3.9565872150360765`*^9}, {3.956587245363923*^9, 
   3.9565872461460996`*^9}, {3.966374588928936*^9, 3.966374598259987*^9}, 
   3.9663779608470335`*^9, {3.966632679186081*^9, 3.9666326992270985`*^9}, {
   3.9666327484395742`*^9, 
   3.9666327484751606`*^9}},ExpressionUUID->"274f35f8-6615-4399-99b8-\
969b92fd92c2"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"binWidth2", "=", "binwidth"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xVals2", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"i", "*", "binWidth2"}], "-", 
      RowBox[{"binWidth2", "/", "2"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{
        RowBox[{"Ceiling", "[", 
         RowBox[{
          RowBox[{"Max", "[", "WTMAD2", "]"}], ",", "binWidth2"}], "]"}], "/",
         "binWidth2"}]}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"RoundedWTMADs2", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Ceiling", "[", 
      RowBox[{
       RowBox[{"WTMAD2", "[", 
        RowBox[{"[", "i", "]"}], "]"}], ",", "binWidth2"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "4"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"CountedWTMADs2", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Count", "[", 
        RowBox[{
         RowBox[{"RoundedWTMADs2", "[", 
          RowBox[{"[", "i", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"xVals2", "[", 
           RowBox[{"[", "j", "]"}], "]"}], "+", 
          RowBox[{"binWidth2", "/", "2"}]}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "1", ",", 
         RowBox[{"Length", "[", "xVals2", "]"}]}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "4"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"yVals2", "=", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"CountedWTMADs2", "/", 
      RowBox[{"Total", "[", 
       RowBox[{"CountedWTMADs2", ",", 
        RowBox[{"{", "2", "}"}]}], "]"}]}], "/", "binWidth2"}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.966377797788622*^9, 3.966377829161189*^9}, {
   3.966377871680254*^9, 3.96637793324448*^9}, {3.9663780085505075`*^9, 
   3.9663780319381084`*^9}, {3.9663780700848136`*^9, 
   3.9663781537028627`*^9}, {3.9663782083885593`*^9, 
   3.9663782120822954`*^9}, {3.9663784295958996`*^9, 3.966378437622893*^9}, 
   3.9666216530485907`*^9, {3.9666279380097704`*^9, 3.966627938573854*^9}, {
   3.966632305840418*^9, 3.9666323865060234`*^9}, {3.9666324487957425`*^9, 
   3.966632458592132*^9}, {3.966632707602121*^9, 3.966632733727148*^9}, {
   3.9666329947415223`*^9, 3.966633009693368*^9}},
 CellLabel->"In[57]:=",ExpressionUUID->"f70d1f92-bc05-428f-866e-f1a7c20eb8a9"],

Cell[BoxData[
 RowBox[{"WTMAD2RungHistogram", "=", 
  RowBox[{"ListPlot", "[", 
   RowBox[{
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Transpose", "[", 
       RowBox[{"{", 
        RowBox[{"xVals2", ",", 
         RowBox[{"yVals2", "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], "}"}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Transpose", "[", 
       RowBox[{"{", 
        RowBox[{"xVals2", ",", 
         RowBox[{"yVals2", "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], "}"}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Transpose", "[", 
       RowBox[{"{", 
        RowBox[{"xVals2", ",", 
         RowBox[{"yVals2", "[", 
          RowBox[{"[", "3", "]"}], "]"}]}], "}"}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Transpose", "[", 
       RowBox[{"{", 
        RowBox[{"xVals2", ",", 
         RowBox[{"yVals2", "[", 
          RowBox[{"[", "4", "]"}], "]"}]}], "}"}], "]"}]}], 
     "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
    RowBox[{"InterpolationOrder", "\[Rule]", "3"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Colours", "[", 
          RowBox[{"[", 
           RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", 
         RowBox[{"Thickness", "[", "0.01", "]"}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Colours", "[", 
          RowBox[{"[", 
           RowBox[{"1", ",", "3"}], "]"}], "]"}], ",", 
         RowBox[{"Thickness", "[", "0.01", "]"}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Colours", "[", 
          RowBox[{"[", 
           RowBox[{"1", ",", "6"}], "]"}], "]"}], ",", 
         RowBox[{"Thickness", "[", "0.01", "]"}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Colours", "[", 
          RowBox[{"[", 
           RowBox[{"1", ",", "8"}], "]"}], "]"}], ",", 
         RowBox[{"Thickness", "[", "0.01", "]"}]}], "}"}]}], 
      "\[IndentingNewLine]", "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"binWidth2", "-", 
          RowBox[{"binWidth2", "/", "2"}]}], ",", "6.07"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0.72"}], "}"}]}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"Filling", "\[Rule]", "Axis"}], ",", "\[IndentingNewLine]", 
    RowBox[{"Frame", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"True", ",", "True"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"True", ",", "True"}], "}"}]}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"FrameLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
      "\"\<WTMAD-2 Contribution (%)\>\"", ",", 
       "\"\<Smoothed Occurence Density\>\""}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"FrameTicks", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"tickFunc", ",", "tickFunc"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"tickFunc", ",", "tickFunc"}], "}"}]}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"FrameTicksStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", "}"}], ",", 
         RowBox[{"Directive", "[", 
          RowBox[{
           RowBox[{"FontOpacity", "\[Rule]", "0"}], ",", 
           RowBox[{"FontSize", "\[Rule]", "0"}]}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", "}"}], ",", 
         RowBox[{"Directive", "[", 
          RowBox[{
           RowBox[{"FontOpacity", "\[Rule]", "0"}], ",", 
           RowBox[{"FontSize", "\[Rule]", "0"}]}], "]"}]}], "}"}]}], "}"}]}], 
    ",", "\[IndentingNewLine]", 
    RowBox[{"FrameStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Black", ",", 
       RowBox[{"FontSize", "\[Rule]", "24"}], ",", 
       RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}], ",", 
       RowBox[{"AbsoluteThickness", "[", "2.5", "]"}]}], "]"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}], ",", "22"}], 
      "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"ImageSize", "\[Rule]", 
     RowBox[{"Automatic", "\[Rule]", "500"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"Background", "\[Rule]", "White"}], ",", "\[IndentingNewLine]", 
    RowBox[{"PlotLegends", "\[Rule]", 
     RowBox[{"Placed", "[", 
      RowBox[{
       RowBox[{"LineLegend", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Directive", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Colours", "[", 
               RowBox[{"[", 
                RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", 
              RowBox[{"Thickness", "[", "0.02", "]"}]}], "}"}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Directive", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Colours", "[", 
               RowBox[{"[", 
                RowBox[{"1", ",", "3"}], "]"}], "]"}], ",", 
              RowBox[{"Thickness", "[", "0.02", "]"}]}], "}"}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Directive", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Colours", "[", 
               RowBox[{"[", 
                RowBox[{"1", ",", "6"}], "]"}], "]"}], ",", 
              RowBox[{"Thickness", "[", "0.02", "]"}]}], "}"}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Directive", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Colours", "[", 
               RowBox[{"[", 
                RowBox[{"1", ",", "8"}], "]"}], "]"}], ",", 
              RowBox[{"Thickness", "[", "0.02", "]"}]}], "}"}], "]"}]}], 
          "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
          "\"\<GGA\>\"", ",", "\"\<meta-GGA\>\"", ",", "\"\<Hybrid\>\"", ",", 
           "\"\<Double Hybrid\>\""}], "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Spacings", "\[Rule]", "0.3"}], ",", "\[IndentingNewLine]", 
         RowBox[{"LabelStyle", "\[Rule]", " ", 
          RowBox[{"{", 
           RowBox[{"Black", ",", 
            RowBox[{"FontSize", "\[Rule]", "22"}], ",", 
            RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}], ",", 
            RowBox[{"AbsoluteThickness", "[", "0.01", "]"}]}], "}"}]}]}], 
        "\[IndentingNewLine]", "]"}], ",", 
       RowBox[{"ImageScaled", "[", 
        RowBox[{"{", 
         RowBox[{"0.82", ",", "0.75"}], "}"}], "]"}]}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellChangeTimes->{{3.966376028481183*^9, 3.966376058217229*^9}, {
   3.9663761345293517`*^9, 3.9663762384414883`*^9}, {3.9663762746169033`*^9, 
   3.9663763369886684`*^9}, {3.966376466023944*^9, 3.9663765119663277`*^9}, {
   3.9663766888301907`*^9, 3.96637683515719*^9}, {3.966377022768714*^9, 
   3.9663770285706635`*^9}, {3.966377836092952*^9, 3.9663778476545725`*^9}, {
   3.9663782534347057`*^9, 3.9663783139427233`*^9}, {3.9663783565656815`*^9, 
   3.9663783847037773`*^9}, {3.966378454244919*^9, 3.966378458518938*^9}, 
   3.966378930805218*^9, {3.966378969184052*^9, 3.9663789716737413`*^9}, {
   3.9666199482408924`*^9, 3.966620023724921*^9}, {3.9666200828465853`*^9, 
   3.966620093094146*^9}, {3.966632486239854*^9, 3.966632510174824*^9}, {
   3.966632549477291*^9, 3.9666326532900476`*^9}, {3.9666327370679417`*^9, 
   3.966632742803191*^9}, {3.966632926771472*^9, 3.966632927662749*^9}, {
   3.966633273537888*^9, 3.966633279927269*^9}, {3.966633316466926*^9, 
   3.9666333370606995`*^9}, 3.9666374722305365`*^9, {3.966638291152855*^9, 
   3.966638298340049*^9}, {3.971034396374614*^9, 3.9710343964348855`*^9}},
 CellLabel->"In[62]:=",ExpressionUUID->"e61cc7c6-02f4-48f4-bfb7-50b856da1368"]
}, Open  ]],

Cell[CellGroupData[{

Cell["WTMAD-3 Plots", "Section",
 CellChangeTimes->{{3.8159098859335394`*^9, 3.8159098936639137`*^9}, {
   3.816020473371563*^9, 3.8160204797198906`*^9}, {3.867287106187972*^9, 
   3.8672871084708767`*^9}, {3.9169979350764914`*^9, 
   3.9169979369826174`*^9}, {3.94641371084194*^9, 3.9464137299645586`*^9}, 
   3.9556493624167347`*^9, {3.9556542149812284`*^9, 3.9556542185457573`*^9}, {
   3.9565872139918404`*^9, 3.9565872150360765`*^9}, {3.956587245363923*^9, 
   3.9565872461460996`*^9}, {3.966374588928936*^9, 3.966374598259987*^9}, 
   3.9663779608470335`*^9, {3.966632679186081*^9, 3.9666326992270985`*^9}, {
   3.9666327484395742`*^9, 3.966632759252195*^9}, {3.966632798287071*^9, 
   3.9666327988042307`*^9}},ExpressionUUID->"82274e56-2d07-431f-8227-\
52e710efb8e6"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"binWidth3", "=", "binwidth"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xVals3", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"i", "*", "binWidth3"}], "-", 
      RowBox[{"binWidth3", "/", "2"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{
        RowBox[{"Ceiling", "[", 
         RowBox[{
          RowBox[{"Max", "[", "WTMAD3", "]"}], ",", "binWidth3"}], "]"}], "/",
         "binWidth3"}]}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"RoundedWTMADs3", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Ceiling", "[", 
      RowBox[{
       RowBox[{"WTMAD3", "[", 
        RowBox[{"[", "i", "]"}], "]"}], ",", "binWidth3"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "4"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"CountedWTMADs3", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Count", "[", 
        RowBox[{
         RowBox[{"RoundedWTMADs3", "[", 
          RowBox[{"[", "i", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"xVals3", "[", 
           RowBox[{"[", "j", "]"}], "]"}], "+", 
          RowBox[{"binWidth3", "/", "2"}]}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "1", ",", 
         RowBox[{"Length", "[", "xVals3", "]"}]}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "4"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"yVals3", "=", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"CountedWTMADs3", "/", 
      RowBox[{"Total", "[", 
       RowBox[{"CountedWTMADs3", ",", 
        RowBox[{"{", "2", "}"}]}], "]"}]}], "/", "binWidth3"}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.966377797788622*^9, 3.966377829161189*^9}, {
   3.966377871680254*^9, 3.96637793324448*^9}, {3.9663780085505075`*^9, 
   3.9663780319381084`*^9}, {3.9663780700848136`*^9, 
   3.9663781537028627`*^9}, {3.9663782083885593`*^9, 
   3.9663782120822954`*^9}, {3.9663784295958996`*^9, 3.966378437622893*^9}, 
   3.9666216530485907`*^9, {3.9666279380097704`*^9, 3.966627938573854*^9}, {
   3.966632305840418*^9, 3.9666323865060234`*^9}, {3.9666324487957425`*^9, 
   3.966632458592132*^9}, {3.966632707602121*^9, 3.96663283111429*^9}, {
   3.9666329925791593`*^9, 3.966633013289616*^9}},
 CellLabel->"In[63]:=",ExpressionUUID->"65f82456-d232-4098-819f-44f60a392a33"],

Cell[BoxData[
 RowBox[{"WTMAD3RungHistogram", "=", 
  RowBox[{"ListPlot", "[", 
   RowBox[{
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Transpose", "[", 
       RowBox[{"{", 
        RowBox[{"xVals3", ",", 
         RowBox[{"yVals3", "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], "}"}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Transpose", "[", 
       RowBox[{"{", 
        RowBox[{"xVals3", ",", 
         RowBox[{"yVals3", "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], "}"}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Transpose", "[", 
       RowBox[{"{", 
        RowBox[{"xVals3", ",", 
         RowBox[{"yVals3", "[", 
          RowBox[{"[", "3", "]"}], "]"}]}], "}"}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Transpose", "[", 
       RowBox[{"{", 
        RowBox[{"xVals3", ",", 
         RowBox[{"yVals3", "[", 
          RowBox[{"[", "4", "]"}], "]"}]}], "}"}], "]"}]}], 
     "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
    RowBox[{"InterpolationOrder", "\[Rule]", "3"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Colours", "[", 
          RowBox[{"[", 
           RowBox[{"2", ",", "1"}], "]"}], "]"}], ",", 
         RowBox[{"Thickness", "[", "0.01", "]"}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Colours", "[", 
          RowBox[{"[", 
           RowBox[{"2", ",", "3"}], "]"}], "]"}], ",", 
         RowBox[{"Thickness", "[", "0.01", "]"}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Colours", "[", 
          RowBox[{"[", 
           RowBox[{"2", ",", "6"}], "]"}], "]"}], ",", 
         RowBox[{"Thickness", "[", "0.01", "]"}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Colours", "[", 
          RowBox[{"[", 
           RowBox[{"2", ",", "8"}], "]"}], "]"}], ",", 
         RowBox[{"Thickness", "[", "0.01", "]"}]}], "}"}]}], 
      "\[IndentingNewLine]", "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"binWidth3", "-", 
          RowBox[{"binWidth3", "/", "2"}]}], ",", "6.07"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0.72"}], "}"}]}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"Filling", "\[Rule]", "Axis"}], ",", "\[IndentingNewLine]", 
    RowBox[{"Frame", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"True", ",", "True"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"True", ",", "True"}], "}"}]}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"FrameLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
      "\"\<WTMAD-3 Contribution (%)\>\"", ",", 
       "\"\<Smoothed Occurence Density\>\""}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"FrameTicks", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"tickFunc", ",", "tickFunc"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"tickFunc", ",", "tickFunc"}], "}"}]}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"FrameTicksStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", "}"}], ",", 
         RowBox[{"Directive", "[", 
          RowBox[{
           RowBox[{"FontOpacity", "\[Rule]", "0"}], ",", 
           RowBox[{"FontSize", "\[Rule]", "0"}]}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", "}"}], ",", 
         RowBox[{"Directive", "[", 
          RowBox[{
           RowBox[{"FontOpacity", "\[Rule]", "0"}], ",", 
           RowBox[{"FontSize", "\[Rule]", "0"}]}], "]"}]}], "}"}]}], "}"}]}], 
    ",", "\[IndentingNewLine]", 
    RowBox[{"FrameStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Black", ",", 
       RowBox[{"FontSize", "\[Rule]", "24"}], ",", 
       RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}], ",", 
       RowBox[{"AbsoluteThickness", "[", "2.5", "]"}]}], "]"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}], ",", "22"}], 
      "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"ImageSize", "\[Rule]", 
     RowBox[{"Automatic", "\[Rule]", "500"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"Background", "\[Rule]", "White"}], ",", "\[IndentingNewLine]", 
    RowBox[{"PlotLegends", "\[Rule]", 
     RowBox[{"Placed", "[", 
      RowBox[{
       RowBox[{"LineLegend", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Directive", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Colours", "[", 
               RowBox[{"[", 
                RowBox[{"2", ",", "1"}], "]"}], "]"}], ",", 
              RowBox[{"Thickness", "[", "0.02", "]"}]}], "}"}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Directive", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Colours", "[", 
               RowBox[{"[", 
                RowBox[{"2", ",", "3"}], "]"}], "]"}], ",", 
              RowBox[{"Thickness", "[", "0.02", "]"}]}], "}"}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Directive", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Colours", "[", 
               RowBox[{"[", 
                RowBox[{"2", ",", "6"}], "]"}], "]"}], ",", 
              RowBox[{"Thickness", "[", "0.02", "]"}]}], "}"}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Directive", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Colours", "[", 
               RowBox[{"[", 
                RowBox[{"2", ",", "8"}], "]"}], "]"}], ",", 
              RowBox[{"Thickness", "[", "0.02", "]"}]}], "}"}], "]"}]}], 
          "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
          "\"\<GGA\>\"", ",", "\"\<meta-GGA\>\"", ",", "\"\<Hybrid\>\"", ",", 
           "\"\<Double Hybrid\>\""}], "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Spacings", "\[Rule]", "0.3"}], ",", "\[IndentingNewLine]", 
         RowBox[{"LabelStyle", "\[Rule]", " ", 
          RowBox[{"{", 
           RowBox[{"Black", ",", 
            RowBox[{"FontSize", "\[Rule]", "22"}], ",", 
            RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}], ",", 
            RowBox[{"AbsoluteThickness", "[", "0.01", "]"}]}], "}"}]}]}], 
        "\[IndentingNewLine]", "]"}], ",", 
       RowBox[{"ImageScaled", "[", 
        RowBox[{"{", 
         RowBox[{"0.82", ",", "0.75"}], "}"}], "]"}]}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellChangeTimes->{{3.966376028481183*^9, 3.966376058217229*^9}, {
   3.9663761345293517`*^9, 3.9663762384414883`*^9}, {3.9663762746169033`*^9, 
   3.9663763369886684`*^9}, {3.966376466023944*^9, 3.9663765119663277`*^9}, {
   3.9663766888301907`*^9, 3.96637683515719*^9}, {3.966377022768714*^9, 
   3.9663770285706635`*^9}, {3.966377836092952*^9, 3.9663778476545725`*^9}, {
   3.9663782534347057`*^9, 3.9663783139427233`*^9}, {3.9663783565656815`*^9, 
   3.9663783847037773`*^9}, {3.966378454244919*^9, 3.966378458518938*^9}, 
   3.966378930805218*^9, {3.966378969184052*^9, 3.9663789716737413`*^9}, {
   3.9666199482408924`*^9, 3.966620023724921*^9}, {3.9666200828465853`*^9, 
   3.966620093094146*^9}, {3.966632486239854*^9, 3.966632510174824*^9}, {
   3.966632549477291*^9, 3.9666326532900476`*^9}, {3.9666327370679417`*^9, 
   3.966632742803191*^9}, {3.9666327855582323`*^9, 3.966632841735311*^9}, {
   3.966632901756921*^9, 3.966632931803755*^9}, {3.9666332834231963`*^9, 
   3.966633287528062*^9}, {3.966633319341948*^9, 3.9666333315714273`*^9}, 
   3.966637469749589*^9, {3.9666383019794655`*^9, 3.966638309215034*^9}, {
   3.9710343935077677`*^9, 3.971034393585786*^9}},
 CellLabel->"In[68]:=",ExpressionUUID->"461a4ea8-2f5d-40ef-aba9-0e9f563704d7"]
}, Open  ]],

Cell[CellGroupData[{

Cell["WTMAD-4 Plots", "Section",
 CellChangeTimes->{{3.8159098859335394`*^9, 3.8159098936639137`*^9}, {
   3.816020473371563*^9, 3.8160204797198906`*^9}, {3.867287106187972*^9, 
   3.8672871084708767`*^9}, {3.9169979350764914`*^9, 
   3.9169979369826174`*^9}, {3.94641371084194*^9, 3.9464137299645586`*^9}, 
   3.9556493624167347`*^9, {3.9556542149812284`*^9, 3.9556542185457573`*^9}, {
   3.9565872139918404`*^9, 3.9565872150360765`*^9}, {3.956587245363923*^9, 
   3.9565872461460996`*^9}, {3.966374588928936*^9, 3.966374598259987*^9}, 
   3.9663779608470335`*^9, {3.966632679186081*^9, 3.9666326992270985`*^9}, {
   3.9666327484395742`*^9, 
   3.966632759252195*^9}},ExpressionUUID->"8ec980a5-04e9-4463-a37e-\
a4407cdf51f4"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"binWidth4", "=", "binwidth"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xVals4", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"i", "*", "binWidth4"}], "-", 
      RowBox[{"binWidth4", "/", "2"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{
        RowBox[{"Ceiling", "[", 
         RowBox[{
          RowBox[{"Max", "[", "WTMAD4", "]"}], ",", "binWidth4"}], "]"}], "/",
         "binWidth4"}]}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"RoundedWTMADs4", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Ceiling", "[", 
      RowBox[{
       RowBox[{"WTMAD4", "[", 
        RowBox[{"[", "i", "]"}], "]"}], ",", "binWidth4"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "4"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"CountedWTMADs4", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Count", "[", 
        RowBox[{
         RowBox[{"RoundedWTMADs4", "[", 
          RowBox[{"[", "i", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"xVals4", "[", 
           RowBox[{"[", "j", "]"}], "]"}], "+", 
          RowBox[{"binWidth4", "/", "2"}]}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "1", ",", 
         RowBox[{"Length", "[", "xVals4", "]"}]}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "4"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"yVals4", "=", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"CountedWTMADs4", "/", 
      RowBox[{"Total", "[", 
       RowBox[{"CountedWTMADs4", ",", 
        RowBox[{"{", "2", "}"}]}], "]"}]}], "/", "binWidth4"}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.966377797788622*^9, 3.966377829161189*^9}, {
   3.966377871680254*^9, 3.96637793324448*^9}, {3.9663780085505075`*^9, 
   3.9663780319381084`*^9}, {3.9663780700848136`*^9, 
   3.9663781537028627`*^9}, {3.9663782083885593`*^9, 
   3.9663782120822954`*^9}, {3.9663784295958996`*^9, 3.966378437622893*^9}, 
   3.9666216530485907`*^9, {3.9666279380097704`*^9, 3.966627938573854*^9}, {
   3.966632305840418*^9, 3.9666323865060234`*^9}, {3.9666324487957425`*^9, 
   3.966632458592132*^9}, {3.966632707602121*^9, 3.9666327837085648`*^9}, {
   3.9666329904734983`*^9, 3.9666330181235533`*^9}},
 CellLabel->"In[69]:=",ExpressionUUID->"4ccb7c8c-231b-4fdd-b21c-956c33ca1884"],

Cell[BoxData[
 RowBox[{"WTMAD4RungHistogram", "=", 
  RowBox[{"ListPlot", "[", 
   RowBox[{
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Transpose", "[", 
       RowBox[{"{", 
        RowBox[{"xVals4", ",", 
         RowBox[{"yVals4", "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], "}"}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Transpose", "[", 
       RowBox[{"{", 
        RowBox[{"xVals4", ",", 
         RowBox[{"yVals4", "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], "}"}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Transpose", "[", 
       RowBox[{"{", 
        RowBox[{"xVals4", ",", 
         RowBox[{"yVals4", "[", 
          RowBox[{"[", "3", "]"}], "]"}]}], "}"}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Transpose", "[", 
       RowBox[{"{", 
        RowBox[{"xVals4", ",", 
         RowBox[{"yVals4", "[", 
          RowBox[{"[", "4", "]"}], "]"}]}], "}"}], "]"}]}], 
     "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
    RowBox[{"InterpolationOrder", "\[Rule]", "3"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Colours", "[", 
          RowBox[{"[", 
           RowBox[{"4", ",", "1"}], "]"}], "]"}], ",", 
         RowBox[{"Thickness", "[", "0.01", "]"}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Colours", "[", 
          RowBox[{"[", 
           RowBox[{"4", ",", "3"}], "]"}], "]"}], ",", 
         RowBox[{"Thickness", "[", "0.01", "]"}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Colours", "[", 
          RowBox[{"[", 
           RowBox[{"4", ",", "6"}], "]"}], "]"}], ",", 
         RowBox[{"Thickness", "[", "0.01", "]"}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Colours", "[", 
          RowBox[{"[", 
           RowBox[{"4", ",", "8"}], "]"}], "]"}], ",", 
         RowBox[{"Thickness", "[", "0.01", "]"}]}], "}"}]}], 
      "\[IndentingNewLine]", "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"binWidth4", "-", 
          RowBox[{"binWidth4", "/", "2"}]}], ",", "6.07"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0.72"}], "}"}]}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"Filling", "\[Rule]", "Axis"}], ",", "\[IndentingNewLine]", 
    RowBox[{"Frame", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"True", ",", "True"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"True", ",", "True"}], "}"}]}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"FrameLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
      "\"\<WTMAD-4 Contribution (%)\>\"", ",", 
       "\"\<Smoothed Occurence Density\>\""}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"FrameTicks", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"tickFunc", ",", "tickFunc"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"tickFunc", ",", "tickFunc"}], "}"}]}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"FrameTicksStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", "}"}], ",", 
         RowBox[{"Directive", "[", 
          RowBox[{
           RowBox[{"FontOpacity", "\[Rule]", "0"}], ",", 
           RowBox[{"FontSize", "\[Rule]", "0"}]}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", "}"}], ",", 
         RowBox[{"Directive", "[", 
          RowBox[{
           RowBox[{"FontOpacity", "\[Rule]", "0"}], ",", 
           RowBox[{"FontSize", "\[Rule]", "0"}]}], "]"}]}], "}"}]}], "}"}]}], 
    ",", "\[IndentingNewLine]", 
    RowBox[{"FrameStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Black", ",", 
       RowBox[{"FontSize", "\[Rule]", "24"}], ",", 
       RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}], ",", 
       RowBox[{"AbsoluteThickness", "[", "2.5", "]"}]}], "]"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}], ",", "22"}], 
      "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"ImageSize", "\[Rule]", 
     RowBox[{"Automatic", "\[Rule]", "500"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"Background", "\[Rule]", "White"}], ",", "\[IndentingNewLine]", 
    RowBox[{"PlotLegends", "\[Rule]", 
     RowBox[{"Placed", "[", 
      RowBox[{
       RowBox[{"LineLegend", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Directive", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Colours", "[", 
               RowBox[{"[", 
                RowBox[{"4", ",", "1"}], "]"}], "]"}], ",", 
              RowBox[{"Thickness", "[", "0.02", "]"}]}], "}"}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Directive", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Colours", "[", 
               RowBox[{"[", 
                RowBox[{"4", ",", "3"}], "]"}], "]"}], ",", 
              RowBox[{"Thickness", "[", "0.02", "]"}]}], "}"}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Directive", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Colours", "[", 
               RowBox[{"[", 
                RowBox[{"4", ",", "6"}], "]"}], "]"}], ",", 
              RowBox[{"Thickness", "[", "0.02", "]"}]}], "}"}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Directive", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Colours", "[", 
               RowBox[{"[", 
                RowBox[{"4", ",", "8"}], "]"}], "]"}], ",", 
              RowBox[{"Thickness", "[", "0.02", "]"}]}], "}"}], "]"}]}], 
          "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
          "\"\<GGA\>\"", ",", "\"\<meta-GGA\>\"", ",", "\"\<Hybrid\>\"", ",", 
           "\"\<Double Hybrid\>\""}], "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Spacings", "\[Rule]", "0.3"}], ",", "\[IndentingNewLine]", 
         RowBox[{"LabelStyle", "\[Rule]", " ", 
          RowBox[{"{", 
           RowBox[{"Black", ",", 
            RowBox[{"FontSize", "\[Rule]", "22"}], ",", 
            RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}], ",", 
            RowBox[{"AbsoluteThickness", "[", "0.01", "]"}]}], "}"}]}]}], 
        "\[IndentingNewLine]", "]"}], ",", 
       RowBox[{"ImageScaled", "[", 
        RowBox[{"{", 
         RowBox[{"0.82", ",", "0.75"}], "}"}], "]"}]}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellChangeTimes->{{3.966376028481183*^9, 3.966376058217229*^9}, {
   3.9663761345293517`*^9, 3.9663762384414883`*^9}, {3.9663762746169033`*^9, 
   3.9663763369886684`*^9}, {3.966376466023944*^9, 3.9663765119663277`*^9}, {
   3.9663766888301907`*^9, 3.96637683515719*^9}, {3.966377022768714*^9, 
   3.9663770285706635`*^9}, {3.966377836092952*^9, 3.9663778476545725`*^9}, {
   3.9663782534347057`*^9, 3.9663783139427233`*^9}, {3.9663783565656815`*^9, 
   3.9663783847037773`*^9}, {3.966378454244919*^9, 3.966378458518938*^9}, 
   3.966378930805218*^9, {3.966378969184052*^9, 3.9663789716737413`*^9}, {
   3.9666199482408924`*^9, 3.966620023724921*^9}, {3.9666200828465853`*^9, 
   3.966620093094146*^9}, {3.966632486239854*^9, 3.966632510174824*^9}, {
   3.966632549477291*^9, 3.9666326532900476`*^9}, {3.9666327370679417`*^9, 
   3.966632742803191*^9}, {3.9666327855582323`*^9, 3.9666328160235815`*^9}, 
   3.9666328993211985`*^9, {3.9666329343367567`*^9, 3.9666329352314415`*^9}, {
   3.966633290998914*^9, 3.966633325868957*^9}, 3.9666374669565687`*^9, {
   3.9710343905238895`*^9, 3.9710343905919065`*^9}},
 CellLabel->"In[74]:=",ExpressionUUID->"a5b21174-ca1b-4418-ad3b-6d4228f6ecdd"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exports", "Section",
 CellChangeTimes->{{3.8159098859335394`*^9, 3.8159098936639137`*^9}, {
   3.816020473371563*^9, 3.8160204797198906`*^9}, {3.867287106187972*^9, 
   3.8672871084708767`*^9}, {3.9169979350764914`*^9, 
   3.9169979369826174`*^9}, {3.94641371084194*^9, 3.9464137299645586`*^9}, 
   3.9556493624167347`*^9, {3.9556542149812284`*^9, 3.9556542185457573`*^9}, {
   3.9565872139918404`*^9, 3.9565872150360765`*^9}, {3.956587245363923*^9, 
   3.9565872461460996`*^9}, {3.966374588928936*^9, 
   3.9663746185440164`*^9}},ExpressionUUID->"fd461c48-5d7a-4e69-8e8b-\
b14f19e83f99"],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<WTMAD1RungHistogram.pdf\>\"", ",", 
   RowBox[{"Rasterize", "[", 
    RowBox[{"WTMAD1RungHistogram", ",", 
     RowBox[{"ImageResolution", "\[Rule]", "900"}]}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.9663785498420687`*^9, {3.966378681423541*^9, 3.966378694079651*^9}, {
   3.966637426444252*^9, 3.966637450804302*^9}},
 CellLabel->"In[75]:=",ExpressionUUID->"1974bdf0-4ff3-4fcd-ad48-a9913c7909f1"],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<WTMAD2RungHistogram.pdf\>\"", ",", 
   RowBox[{"Rasterize", "[", 
    RowBox[{"WTMAD2RungHistogram", ",", 
     RowBox[{"ImageResolution", "\[Rule]", "900"}]}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.966637434952282*^9, 3.9666374564254503`*^9}},
 CellLabel->"In[76]:=",ExpressionUUID->"fb0941ef-65b2-41fd-8a3d-c2ad2f7ebffa"],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<WTMAD3RungHistogram.pdf\>\"", ",", 
   RowBox[{"Rasterize", "[", 
    RowBox[{"WTMAD3RungHistogram", ",", 
     RowBox[{"ImageResolution", "\[Rule]", "900"}]}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.9666374368172846`*^9, 3.9666374597833138`*^9}},
 CellLabel->"In[77]:=",ExpressionUUID->"b743a75b-ee17-4b4e-b99e-e35c0c0b8583"],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<WTMAD4RungHistogram.pdf\>\"", ",", 
   RowBox[{"Rasterize", "[", 
    RowBox[{"WTMAD4RungHistogram", ",", 
     RowBox[{"ImageResolution", "\[Rule]", "900"}]}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.966637437863635*^9, 3.9666374627213*^9}},
 CellLabel->"In[78]:=",ExpressionUUID->"2eb7d6b7-1c99-41b3-b6ac-f50ff0ad3d68"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"strLen", "=", "15"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"formatEntry", "[", "e_", "]"}], ":=", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"NumberQ", "[", "e", "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"StringPadRight", "[", 
      RowBox[{
       RowBox[{"ToString", "[", 
        RowBox[{"NumberForm", "[", 
         RowBox[{
          RowBox[{"N", "[", "e", "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"4", ",", "2"}], "}"}]}], "]"}], "]"}], ",", "strLen"}], 
      "]"}], ",", 
     RowBox[{"(*", 
      RowBox[{
       RowBox[{"numbers", ":", 
        RowBox[{"2", " ", "decimals"}]}], ",", "padded"}], "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"StringPadRight", "[", 
      RowBox[{
       RowBox[{"ToString", "[", "e", "]"}], ",", "strLen"}], "]"}]}], 
    "                        ", 
    RowBox[{"(*", 
     RowBox[{"strings", " ", "padded"}], "*)"}], "\[IndentingNewLine]", 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"formattedTable", "=", 
   RowBox[{"StringRiffle", "[", 
    RowBox[{
     RowBox[{"Map", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"StringJoin", "@@", 
         RowBox[{"(", 
          RowBox[{"formatEntry", "/@", "#"}], ")"}]}], "&"}], ",", 
       RowBox[{"ResTable", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], "]"}], ",", "\"\<\\n\>\""}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"filename", "=", "\"\<Quantile_WTMAD1.txt\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{"filename", ",", "formattedTable", ",", "\"\<Text\>\""}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.966374376289008*^9, 3.9663743989738054`*^9}, {
   3.966374434665557*^9, 3.9663744594089413`*^9}, {3.9672396319988956`*^9, 
   3.9672396358144464`*^9}, {3.9672397025105658`*^9, 3.9672397246620893`*^9}, 
   3.971037022082913*^9},
 CellLabel->"In[79]:=",ExpressionUUID->"092fef03-c6f4-472d-89dc-549c4164a1d9"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"strLen", "=", "15"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"formatEntry", "[", "e_", "]"}], ":=", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"NumberQ", "[", "e", "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"StringPadRight", "[", 
      RowBox[{
       RowBox[{"ToString", "[", 
        RowBox[{"NumberForm", "[", 
         RowBox[{
          RowBox[{"N", "[", "e", "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"4", ",", "2"}], "}"}]}], "]"}], "]"}], ",", "strLen"}], 
      "]"}], ",", 
     RowBox[{"(*", 
      RowBox[{
       RowBox[{"numbers", ":", 
        RowBox[{"2", " ", "decimals"}]}], ",", "padded"}], "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"StringPadRight", "[", 
      RowBox[{
       RowBox[{"ToString", "[", "e", "]"}], ",", "strLen"}], "]"}]}], 
    "                        ", 
    RowBox[{"(*", 
     RowBox[{"strings", " ", "padded"}], "*)"}], "\[IndentingNewLine]", 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"formattedTable", "=", 
   RowBox[{"StringRiffle", "[", 
    RowBox[{
     RowBox[{"Map", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"StringJoin", "@@", 
         RowBox[{"(", 
          RowBox[{"formatEntry", "/@", "#"}], ")"}]}], "&"}], ",", 
       RowBox[{"ResTable", "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], "]"}], ",", "\"\<\\n\>\""}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"filename", "=", "\"\<Quantile_WTMAD2.txt\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{"filename", ",", "formattedTable", ",", "\"\<Text\>\""}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.966374376289008*^9, 3.9663743989738054`*^9}, {
   3.966374434665557*^9, 3.9663744594089413`*^9}, {3.9672396319988956`*^9, 
   3.9672396358144464`*^9}, {3.9672397080713506`*^9, 3.9672397219957*^9}, 
   3.9710370232228823`*^9},
 CellLabel->"In[84]:=",ExpressionUUID->"e13b07fb-dd2b-4df9-8ff6-eff5278f2071"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"strLen", "=", "15"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"formatEntry", "[", "e_", "]"}], ":=", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"NumberQ", "[", "e", "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"StringPadRight", "[", 
      RowBox[{
       RowBox[{"ToString", "[", 
        RowBox[{"NumberForm", "[", 
         RowBox[{
          RowBox[{"N", "[", "e", "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"4", ",", "2"}], "}"}]}], "]"}], "]"}], ",", "strLen"}], 
      "]"}], ",", 
     RowBox[{"(*", 
      RowBox[{
       RowBox[{"numbers", ":", 
        RowBox[{"2", " ", "decimals"}]}], ",", "padded"}], "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"StringPadRight", "[", 
      RowBox[{
       RowBox[{"ToString", "[", "e", "]"}], ",", "strLen"}], "]"}]}], 
    "                        ", 
    RowBox[{"(*", 
     RowBox[{"strings", " ", "padded"}], "*)"}], "\[IndentingNewLine]", 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"formattedTable", "=", 
   RowBox[{"StringRiffle", "[", 
    RowBox[{
     RowBox[{"Map", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"StringJoin", "@@", 
         RowBox[{"(", 
          RowBox[{"formatEntry", "/@", "#"}], ")"}]}], "&"}], ",", 
       RowBox[{"ResTable", "[", 
        RowBox[{"[", "3", "]"}], "]"}]}], "]"}], ",", "\"\<\\n\>\""}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"filename", "=", "\"\<Quantile_WTMAD3.txt\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{"filename", ",", "formattedTable", ",", "\"\<Text\>\""}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.966374376289008*^9, 3.9663743989738054`*^9}, {
   3.966374434665557*^9, 3.9663744594089413`*^9}, {3.9672396319988956`*^9, 
   3.9672396358144464`*^9}, {3.967239710432987*^9, 3.9672397195002832`*^9}, 
   3.97103702422962*^9},
 CellLabel->"In[89]:=",ExpressionUUID->"7432bca1-ae47-48ed-8de6-bf6d2d832a77"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"strLen", "=", "15"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"formatEntry", "[", "e_", "]"}], ":=", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"NumberQ", "[", "e", "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"StringPadRight", "[", 
      RowBox[{
       RowBox[{"ToString", "[", 
        RowBox[{"NumberForm", "[", 
         RowBox[{
          RowBox[{"N", "[", "e", "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"4", ",", "2"}], "}"}]}], "]"}], "]"}], ",", "strLen"}], 
      "]"}], ",", 
     RowBox[{"(*", 
      RowBox[{
       RowBox[{"numbers", ":", 
        RowBox[{"2", " ", "decimals"}]}], ",", "padded"}], "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"StringPadRight", "[", 
      RowBox[{
       RowBox[{"ToString", "[", "e", "]"}], ",", "strLen"}], "]"}]}], 
    "                        ", 
    RowBox[{"(*", 
     RowBox[{"strings", " ", "padded"}], "*)"}], "\[IndentingNewLine]", 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"formattedTable", "=", 
   RowBox[{"StringRiffle", "[", 
    RowBox[{
     RowBox[{"Map", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"StringJoin", "@@", 
         RowBox[{"(", 
          RowBox[{"formatEntry", "/@", "#"}], ")"}]}], "&"}], ",", 
       RowBox[{"ResTable", "[", 
        RowBox[{"[", "4", "]"}], "]"}]}], "]"}], ",", "\"\<\\n\>\""}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"filename", "=", "\"\<Quantile_WTMAD4.txt\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{"filename", ",", "formattedTable", ",", "\"\<Text\>\""}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.966374376289008*^9, 3.9663743989738054`*^9}, {
   3.966374434665557*^9, 3.9663744594089413`*^9}, {3.9672396319988956`*^9, 
   3.9672396358144464`*^9}, {3.967239713004263*^9, 3.9672397164310923`*^9}, 
   3.971037026517545*^9},
 CellLabel->"In[94]:=",ExpressionUUID->"ac076506-c8d9-4d20-971f-a39c959ec966"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{2544, 1349},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification:>1.5 Inherited,
FrontEndVersion->"12.1 for Microsoft Windows (64-bit) (June 19, 2020)",
StyleDefinitions->"ReverseColor.nb",
ExpressionUUID->"bf841a30-7870-42e1-be3c-b105f5f42b87"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 2626, 35, 146, "Title",ExpressionUUID->"e8b4790c-cfdb-4f8c-a2f6-82c285868c97"],
Cell[3209, 59, 2379, 36, 171, "Subtitle",ExpressionUUID->"a0191fbe-e215-48a4-8c4f-f26ba47d6f9a"],
Cell[CellGroupData[{
Cell[5613, 99, 356, 6, 99, "Section",ExpressionUUID->"507e86bc-9f42-4233-b3d9-06883a36e4ae"],
Cell[CellGroupData[{
Cell[5994, 109, 303, 5, 80, "Subsection",ExpressionUUID->"d91f3b2c-0440-4cb2-8689-d2b2fefc28b1"],
Cell[6300, 116, 222, 3, 43, "Input",ExpressionUUID->"868b0a4a-0a23-4b4d-8e6d-5e70e42b84a2"],
Cell[6525, 121, 278, 5, 43, "Input",ExpressionUUID->"12acc223-ce39-4b57-946d-7c24fa7087a0"],
Cell[6806, 128, 195, 3, 43, "Input",ExpressionUUID->"80403d44-4f07-4dd5-a191-c73917630ec8"],
Cell[7004, 133, 219, 3, 43, "Input",ExpressionUUID->"58b1b704-9bb1-4e0e-ae8b-3f5f82a2e7e6"],
Cell[7226, 138, 27740, 689, 247, "Input",ExpressionUUID->"c473ffd2-3bc3-43c0-9ec9-4c3420a42063"],
Cell[34969, 829, 463, 13, 43, "Input",ExpressionUUID->"6e1294b1-2f04-4d48-b2d4-8223398a74bf"],
Cell[35435, 844, 154, 3, 43, "Input",ExpressionUUID->"7daf2119-60dd-464d-8c97-410f7c3fe130"],
Cell[35592, 849, 308, 6, 73, "Input",ExpressionUUID->"83646cc2-e906-45ba-a0be-430f1b0c4ca2"],
Cell[35903, 857, 341, 8, 107, "Text",ExpressionUUID->"249fb4f0-36fe-464f-b3c7-f013db6da048"],
Cell[36247, 867, 356, 7, 73, "Input",ExpressionUUID->"5d50b979-e5fe-4a60-90a6-ae3230ea3697"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[36652, 880, 408, 6, 99, "Section",ExpressionUUID->"c185520c-8497-43ef-aaa0-0a1ab0ee7af6"],
Cell[37063, 888, 3416, 75, 160, "Input",ExpressionUUID->"ed90bb2e-a068-4f77-8983-114504f99343"],
Cell[40482, 965, 1224, 25, 218, "Input",ExpressionUUID->"f7e0e6db-157c-445e-999d-211b6cf34df5"],
Cell[41709, 992, 3443, 65, 160, "Input",ExpressionUUID->"94823ce5-4b35-4f02-9bc2-98c3b8acc3a2"],
Cell[45155, 1059, 478, 10, 107, "Text",ExpressionUUID->"ec72a229-5317-4662-9e91-dc243846cf0f"],
Cell[45636, 1071, 523, 11, 102, "Input",ExpressionUUID->"6ab770a1-01ea-446b-9614-2d595ec31990"]
}, Open  ]],
Cell[CellGroupData[{
Cell[46196, 1087, 364, 6, 99, "Section",ExpressionUUID->"7f4f10e9-0978-4bf8-adf7-6fc4e0f89d6e"],
Cell[46563, 1095, 676, 13, 43, "Input",ExpressionUUID->"4b84ff37-d71d-4a27-83e1-d8c51373881d"],
Cell[47242, 1110, 589, 11, 43, "Input",ExpressionUUID->"29c7daa0-5949-4413-89fc-23b6e623598a"],
Cell[47834, 1123, 3300, 79, 189, "Input",ExpressionUUID->"dedf4a36-1d7c-43f2-8485-101296f0c64f"],
Cell[51137, 1204, 729, 14, 43, "Input",ExpressionUUID->"ffcb47ad-7076-4ba7-a4b8-d6e3d3f01c70"],
Cell[51869, 1220, 845, 17, 43, "Input",ExpressionUUID->"06f67035-d852-4af8-917b-f4d5c279cee6"],
Cell[52717, 1239, 442, 10, 43, "Input",ExpressionUUID->"facbc342-edff-4602-a751-76a185644a2a"],
Cell[53162, 1251, 439, 10, 43, "Input",ExpressionUUID->"38b32406-490e-4614-bdbc-89bc04dabd99"],
Cell[53604, 1263, 7288, 148, 1726, "Input",ExpressionUUID->"39d24e79-8b77-4991-adab-36f76815c090"]
}, Open  ]],
Cell[CellGroupData[{
Cell[60929, 1416, 611, 9, 99, "Section",ExpressionUUID->"4da85bcb-f3a9-43a4-b946-5d7a514eed39"],
Cell[61543, 1427, 3402, 97, 334, "Input",ExpressionUUID->"3dce7b5b-311e-44db-9760-0b83e24a1702"],
Cell[64948, 1526, 4311, 102, 276, "Input",ExpressionUUID->"97618960-d04f-43b3-bba5-4144e12ac459"]
}, Open  ]],
Cell[CellGroupData[{
Cell[69296, 1633, 802, 12, 99, "Section",ExpressionUUID->"bb7e17d6-8818-48e6-95b9-03fdef2485be"],
Cell[70101, 1647, 253, 4, 43, "Input",ExpressionUUID->"4cb68737-6fd7-4d6d-96d2-75bbb75c0bd3"],
Cell[70357, 1653, 2493, 66, 160, "Input",ExpressionUUID->"534a3aa5-7d18-440b-afbb-61287f72b1c5"],
Cell[72853, 1721, 8389, 201, 1059, "Input",ExpressionUUID->"6de23389-3c0b-4f8b-adcb-2d4e35c1cc26"]
}, Open  ]],
Cell[CellGroupData[{
Cell[81279, 1927, 728, 11, 99, "Section",ExpressionUUID->"274f35f8-6615-4399-99b8-969b92fd92c2"],
Cell[82010, 1940, 2515, 66, 160, "Input",ExpressionUUID->"f70d1f92-bc05-428f-866e-f1a7c20eb8a9"],
Cell[84528, 2008, 8333, 200, 1059, "Input",ExpressionUUID->"e61cc7c6-02f4-48f4-bfb7-50b856da1368"]
}, Open  ]],
Cell[CellGroupData[{
Cell[92898, 2213, 774, 11, 99, "Section",ExpressionUUID->"82274e56-2d07-431f-8227-52e710efb8e6"],
Cell[93675, 2226, 2514, 66, 160, "Input",ExpressionUUID->"65f82456-d232-4098-819f-44f60a392a33"],
Cell[96192, 2294, 8387, 201, 1059, "Input",ExpressionUUID->"461a4ea8-2f5d-40ef-aba9-0e9f563704d7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[104616, 2500, 726, 11, 99, "Section",ExpressionUUID->"8ec980a5-04e9-4463-a37e-a4407cdf51f4"],
Cell[105345, 2513, 2519, 66, 160, "Input",ExpressionUUID->"4ccb7c8c-231b-4fdd-b21c-956c33ca1884"],
Cell[107867, 2581, 8319, 200, 1059, "Input",ExpressionUUID->"a5b21174-ca1b-4418-ad3b-6d4228f6ecdd"]
}, Open  ]],
Cell[CellGroupData[{
Cell[116223, 2786, 594, 9, 99, "Section",ExpressionUUID->"fd461c48-5d7a-4e69-8e8b-b14f19e83f99"],
Cell[116820, 2797, 462, 9, 43, "Input",ExpressionUUID->"1974bdf0-4ff3-4fcd-ad48-a9913c7909f1"],
Cell[117285, 2808, 387, 7, 43, "Input",ExpressionUUID->"fb0941ef-65b2-41fd-8a3d-c2ad2f7ebffa"],
Cell[117675, 2817, 389, 7, 43, "Input",ExpressionUUID->"b743a75b-ee17-4b4e-b99e-e35c0c0b8583"],
Cell[118067, 2826, 383, 7, 43, "Input",ExpressionUUID->"2eb7d6b7-1c99-41b3-b6ac-f50ff0ad3d68"],
Cell[118453, 2835, 1998, 53, 247, "Input",ExpressionUUID->"092fef03-c6f4-472d-89dc-549c4164a1d9"],
Cell[120454, 2890, 1996, 53, 247, "Input",ExpressionUUID->"e13b07fb-dd2b-4df9-8ff6-eff5278f2071"],
Cell[122453, 2945, 1995, 53, 247, "Input",ExpressionUUID->"7432bca1-ae47-48ed-8de6-bf6d2d832a77"],
Cell[124451, 3000, 1996, 53, 247, "Input",ExpressionUUID->"ac076506-c8d9-4d20-971f-a39c959ec966"]
}, Open  ]]
}, Open  ]]
}
]
*)

