(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     57741,       1385]
NotebookOptionsPosition[     54951,       1335]
NotebookOutlinePosition[     55384,       1352]
CellTagsIndexPosition[     55341,       1349]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["GMTKN55 Rung Ranker", "Title",
 CellChangeTimes->{{3.797879013542491*^9, 3.7978790202757607`*^9}, {
   3.8015052504625587`*^9, 3.801505252496401*^9}, {3.801512705184127*^9, 
   3.8015127059220877`*^9}, {3.8080725810932217`*^9, 3.80807258204629*^9}, {
   3.808637638029217*^9, 3.8086376426386304`*^9}, {3.808709680167038*^9, 
   3.808709684544276*^9}, {3.8087097351836815`*^9, 3.8087097435221834`*^9}, {
   3.814413717951748*^9, 3.814413718885742*^9}, {3.8147473738509254`*^9, 
   3.8147473768747416`*^9}, 3.8150446257955523`*^9, {3.816019237760411*^9, 
   3.8160192392785177`*^9}, {3.816020446217802*^9, 3.816020450903527*^9}, {
   3.818495939948073*^9, 3.818495941442936*^9}, {3.829636393240244*^9, 
   3.8296363982133584`*^9}, {3.829662167077368*^9, 3.829662168066966*^9}, {
   3.830290616723291*^9, 3.830290621962493*^9}, 3.830334093976343*^9, {
   3.83053142396451*^9, 3.830531424436616*^9}, {3.8320259040356393`*^9, 
   3.8320259064634714`*^9}, 3.832026057084034*^9, {3.832081441488149*^9, 
   3.832081445322814*^9}, 3.832198496278219*^9, {3.8323781961193967`*^9, 
   3.832378196259062*^9}, 3.8326341699756026`*^9, 3.8329780717686853`*^9, {
   3.8333837529399967`*^9, 3.8333837549576917`*^9}, {3.8333839574939947`*^9, 
   3.8333839710519953`*^9}, {3.833460774852479*^9, 3.833460780573769*^9}, {
   3.8335704629830327`*^9, 3.8335704806594667`*^9}, {3.8349506466891456`*^9, 
   3.8349506508790555`*^9}, {3.835047535057335*^9, 3.8350475726522255`*^9}, 
   3.8354017196073704`*^9, {3.8375709542180567`*^9, 3.8375709554214764`*^9}, 
   3.837738812080212*^9, 3.8378375733744793`*^9, {3.8576774091232057`*^9, 
   3.8576774153285923`*^9}, {3.858971769112599*^9, 3.8589717711240635`*^9}, {
   3.8624362841347213`*^9, 3.8624362859687243`*^9}, 3.862697945675531*^9, 
   3.8627615174878263`*^9, 3.8627898394358177`*^9, {3.863894156558298*^9, 
   3.8638941577752056`*^9}, 3.864495398419282*^9, {3.8645970053795815`*^9, 
   3.8645970068616467`*^9}, {3.865115755382537*^9, 3.8651157554156113`*^9}, 
   3.865270778381764*^9, {3.8653781551983757`*^9, 3.8653781574402432`*^9}, {
   3.879945728987928*^9, 3.8799457308838224`*^9}, 3.879948841259983*^9, {
   3.879954952621377*^9, 3.8799549540039387`*^9}, {3.9169945911057253`*^9, 
   3.916994600427992*^9}, {3.9464137497845078`*^9, 3.9464137831407957`*^9}, {
   3.9565816680566916`*^9, 3.9565816694261208`*^9}, {3.965663540759808*^9, 
   3.965663541357286*^9}, {3.966372253938443*^9, 3.966372256647475*^9}, {
   3.966637481164386*^9, 3.9666374816391044`*^9}, {3.966882547839106*^9, 
   3.9668825492824945`*^9}, {3.9672315177454033`*^9, 
   3.967231522041397*^9}},ExpressionUUID->"e8b4790c-cfdb-4f8c-a2f6-\
82c285868c97"],

Cell["\<\
Determining best functionals at each rung for D3_10
Kyle Bryenton 2025-11-18
kyle.bryenton@dal.ca\
\>", "Subtitle",
 CellChangeTimes->{{3.8259515367016363`*^9, 3.8259515481457295`*^9}, {
   3.8296363555235453`*^9, 3.829636363592561*^9}, 3.8296622389748163`*^9, {
   3.829662280794858*^9, 3.829662291249787*^9}, {3.830787820642953*^9, 
   3.830787834013277*^9}, {3.8313045708485894`*^9, 3.831304580009624*^9}, {
   3.8320953423709135`*^9, 3.832095354313024*^9}, 3.83228206786744*^9, {
   3.832378168691453*^9, 3.8323781801034994`*^9}, {3.8324441920909348`*^9, 
   3.832444201710229*^9}, {3.8324487586160955`*^9, 3.8324487591250944`*^9}, {
   3.8324644988930817`*^9, 3.8324644993412466`*^9}, {3.8326212074053016`*^9, 
   3.8326212493946753`*^9}, {3.8326213426871696`*^9, 
   3.8326213436157703`*^9}, {3.8327878865164766`*^9, 
   3.8327878970555696`*^9}, {3.8329857637093697`*^9, 
   3.8329857637743607`*^9}, {3.8330068116486444`*^9, 3.83300681212364*^9}, {
   3.835034974308427*^9, 3.8350349754651814`*^9}, {3.835401713050891*^9, 
   3.8354017168877573`*^9}, {3.8377452905678244`*^9, 3.837745290803586*^9}, 
   3.85767756001378*^9, {3.862761510851385*^9, 3.8627615386924253`*^9}, {
   3.8799549564790955`*^9, 3.879954978202243*^9}, {3.916994603904445*^9, 
   3.916994630403599*^9}, {3.9464137585300026`*^9, 3.946413779941535*^9}, 
   3.946479347959099*^9, {3.9467726285809956`*^9, 3.946772638944997*^9}, {
   3.946842340906331*^9, 3.946842344383188*^9}, {3.9474581585062914`*^9, 
   3.947458160548786*^9}, {3.9556481265778255`*^9, 3.9556481435472155`*^9}, {
   3.9560759693215837`*^9, 3.9560759761951356`*^9}, {3.95658167368425*^9, 
   3.956581718767006*^9}, 3.9566872289770308`*^9, {3.9573531296370845`*^9, 
   3.9573531299721603`*^9}, {3.9656626633708715`*^9, 
   3.9656626648178864`*^9}, {3.9657529525646725`*^9, 3.965752955198642*^9}, 
   3.966028444926873*^9, {3.9666374838333426`*^9, 3.966637483977331*^9}, {
   3.9668825530420275`*^9, 3.9668825640298014`*^9}, 3.967231117733392*^9, 
   3.9672468460120225`*^9, {3.971032426941448*^9, 3.9710324276031046`*^9}, 
   3.9710328093065524`*^9, {3.972237072877211*^9, 3.972237074946111*^9}, 
   3.972397598967959*^9, 
   3.972426890277314*^9},ExpressionUUID->"a0191fbe-e215-48a4-8c4f-\
f26ba47d6f9a"],

Cell[CellGroupData[{

Cell["Setup", "Section",
 CellChangeTimes->{{3.8159098859335394`*^9, 3.8159098936639137`*^9}, {
  3.816020473371563*^9, 3.8160204797198906`*^9}, {3.867287106187972*^9, 
  3.8672871084708767`*^9}, {3.9169979350764914`*^9, 3.9169979369826174`*^9}, {
  3.94641371084194*^9, 
  3.9464137468717747`*^9}},ExpressionUUID->"507e86bc-9f42-4233-b3d9-\
06883a36e4ae"],

Cell[CellGroupData[{

Cell["Preamble", "Subsection",
 CellChangeTimes->{{3.81602099620885*^9, 3.816021017466877*^9}, {
  3.817753674156437*^9, 3.8177536774024324`*^9}, {3.931883848284851*^9, 
  3.931883862152503*^9}, {3.931883956719234*^9, 
  3.9318839620598965`*^9}},ExpressionUUID->"d91f3b2c-0440-4cb2-8689-\
d2b2fefc28b1"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.881072780973341*^9, 3.8810727809817657`*^9}},
 CellLabel->
  "In[142]:=",ExpressionUUID->"868b0a4a-0a23-4b4d-8e6d-5e70e42b84a2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.8808316853232927`*^9, 3.880831694714588*^9}, 
   3.9666375378209023`*^9, 3.967246773940048*^9},
 CellLabel->
  "In[143]:=",ExpressionUUID->"12acc223-ce39-4b57-946d-7c24fa7087a0"],

Cell[BoxData[
 RowBox[{"<<", "MaTeX`"}]], "Input",
 CellChangeTimes->{{3.8374712078059144`*^9, 3.83747121171614*^9}},
 CellLabel->
  "In[144]:=",ExpressionUUID->"80403d44-4f07-4dd5-a191-c73917630ec8"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MaTeX`\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.8374729714354944`*^9, 3.8374729714424963`*^9}},
 CellLabel->
  "In[145]:=",ExpressionUUID->"58b1b704-9bb1-4e0e-ae8b-3f5f82a2e7e6"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Colours", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "6"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Colours", "[", 
    RowBox[{"[", "1", "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"RGBColor", "[", "\"\<#5A000F\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#7E0018\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#A40122\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#CD022D\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#F60239\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#FF6E3A\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#FFAC3B\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#FFDC3D\>\"", "]"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Colours", "[", 
    RowBox[{"[", "2", "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"RGBColor", "[", "\"\<#004002\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#005A01\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#007702\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#009503\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#00B408\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#00D302\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#00F407\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#AFFF2A\>\"", "]"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Colours", "[", 
    RowBox[{"[", "3", "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"RGBColor", "[", "\"\<#00306F\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#00489E\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#005FCC\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#0079FA\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#009FFA\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#00C2F9\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#00E5F8\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#7CFFFA\>\"", "]"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Colours", "[", 
    RowBox[{"[", "4", "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"RGBColor", "[", "\"\<#450270\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#65019F\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#8400CD\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#A700FC\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#DA00FD\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#FF3CFE\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#FF92FD\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#FFCCFE\>\"", "]"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Colours", "[", 
    RowBox[{"[", "5", "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"RGBColor", "[", "\"\<#560133\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#790149\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#940162\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#C7007C\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#EF0096\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#FF5AAF\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#FF9DC8\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#FFCFE2\>\"", "]"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Colours", "[", 
    RowBox[{"[", "6", "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"RGBColor", "[", "\"\<#003D30\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#005745\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#00735C\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#009175\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#00AF8E\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#00CBA7\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#00EBC1\>\"", "]"}], ",", 
     RowBox[{"RGBColor", "[", "\"\<#86FFDE\>\"", "]"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Colour", "=", 
   RowBox[{"{", 
    RowBox[{
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0., 0.4745098039215686, 0.9803921568627451], 
           RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         DefaultBaseStyle->"ColorSwatchGraphics",
         Frame->True,
         FrameStyle->RGBColor[0., 0.31633986928104574`, 0.6535947712418301],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        StyleBox[
         RowBox[{"RGBColor", "[", 
           
           RowBox[{"0.`", ",", "0.4745098039215686`", ",", 
             "0.9803921568627451`"}], "]"}], NumberMarks -> False]],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = 
           RGBColor[0., 0.4745098039215686, 0.9803921568627451]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0., 0.4745098039215686, 0.9803921568627451],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[
           0.6431372549019608, 0.00392156862745098, 0.13333333333333333`], 
           RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         DefaultBaseStyle->"ColorSwatchGraphics",
         Frame->True,
         FrameStyle->RGBColor[
          0.42875816993464055`, 0.0026143790849673205`, 0.08888888888888889],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        StyleBox[
         RowBox[{"RGBColor", "[", 
           
           RowBox[{"0.6431372549019608`", ",", "0.00392156862745098`", ",", 
             "0.13333333333333333`"}], "]"}], NumberMarks -> False]],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = 
           RGBColor[
            0.6431372549019608, 0.00392156862745098, 0.13333333333333333`]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0.6431372549019608, 0.00392156862745098, 0.13333333333333333`],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0., 0.8274509803921568, 0.00784313725490196], 
           RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         DefaultBaseStyle->"ColorSwatchGraphics",
         Frame->True,
         FrameStyle->RGBColor[0., 0.5516339869281046, 0.005228758169934641],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        StyleBox[
         RowBox[{"RGBColor", "[", 
           
           RowBox[{"0.`", ",", "0.8274509803921568`", ",", 
             "0.00784313725490196`"}], "]"}], NumberMarks -> False]],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = 
           RGBColor[0., 0.8274509803921568, 0.00784313725490196]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0., 0.8274509803921568, 0.00784313725490196],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[
           0.27058823529411763`, 0.00784313725490196, 0.4392156862745098], 
           RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         DefaultBaseStyle->"ColorSwatchGraphics",
         Frame->True,
         FrameStyle->RGBColor[
          0.1803921568627451, 0.005228758169934641, 0.2928104575163399],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        StyleBox[
         RowBox[{"RGBColor", "[", 
           
           RowBox[{"0.27058823529411763`", ",", "0.00784313725490196`", ",", 
             "0.4392156862745098`"}], "]"}], NumberMarks -> False]],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = 
           RGBColor[
            0.27058823529411763`, 0.00784313725490196, 0.4392156862745098]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0.27058823529411763`, 0.00784313725490196, 0.4392156862745098],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0., 0.45098039215686275`, 0.3607843137254902], 
           RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         DefaultBaseStyle->"ColorSwatchGraphics",
         Frame->True,
         FrameStyle->RGBColor[0., 0.30065359477124187`, 0.24052287581699347`],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        StyleBox[
         RowBox[{"RGBColor", "[", 
           
           RowBox[{"0.`", ",", "0.45098039215686275`", ",", 
             "0.3607843137254902`"}], "]"}], NumberMarks -> False]],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = 
           RGBColor[0., 0.45098039215686275`, 0.3607843137254902]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0., 0.45098039215686275`, 0.3607843137254902],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1., 0.35294117647058826`, 0.6862745098039216], 
           RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         DefaultBaseStyle->"ColorSwatchGraphics",
         Frame->True,
         FrameStyle->RGBColor[
          0.6666666666666667, 0.23529411764705885`, 0.4575163398692811],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        StyleBox[
         RowBox[{"RGBColor", "[", 
           
           RowBox[{"1.`", ",", "0.35294117647058826`", ",", 
             "0.6862745098039216`"}], "]"}], NumberMarks -> False]],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = 
           RGBColor[1., 0.35294117647058826`, 0.6862745098039216]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1., 0.35294117647058826`, 0.6862745098039216],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1., 0.8627450980392157, 0.23921568627450981`], 
           RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         DefaultBaseStyle->"ColorSwatchGraphics",
         Frame->True,
         FrameStyle->RGBColor[
          0.6666666666666667, 0.5751633986928105, 0.15947712418300655`],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        StyleBox[
         RowBox[{"RGBColor", "[", 
           
           RowBox[{"1.`", ",", "0.8627450980392157`", ",", 
             "0.23921568627450981`"}], "]"}], NumberMarks -> False]],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = 
           RGBColor[1., 0.8627450980392157, 0.23921568627450981`]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1., 0.8627450980392157, 0.23921568627450981`],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0., 0.25098039215686274`, 0.00784313725490196], 
           RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         DefaultBaseStyle->"ColorSwatchGraphics",
         Frame->True,
         FrameStyle->RGBColor[0., 0.1673202614379085, 0.005228758169934641],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        StyleBox[
         RowBox[{"RGBColor", "[", 
           
           RowBox[{"0.`", ",", "0.25098039215686274`", ",", 
             "0.00784313725490196`"}], "]"}], NumberMarks -> False]],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = 
           RGBColor[0., 0.25098039215686274`, 0.00784313725490196]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0., 0.25098039215686274`, 0.00784313725490196],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0., 0.7607843137254902, 0.9764705882352941], 
           RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         DefaultBaseStyle->"ColorSwatchGraphics",
         Frame->True,
         FrameStyle->RGBColor[0., 0.5071895424836601, 0.6509803921568628],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        StyleBox[
         RowBox[{"RGBColor", "[", 
           
           RowBox[{"0.`", ",", "0.7607843137254902`", ",", 
             "0.9764705882352941`"}], "]"}], NumberMarks -> False]],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = 
           RGBColor[0., 0.7607843137254902, 0.9764705882352941]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0., 0.7607843137254902, 0.9764705882352941],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1., 0.8, 0.996078431372549], 
           RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         DefaultBaseStyle->"ColorSwatchGraphics",
         Frame->True,
         FrameStyle->RGBColor[
          0.6666666666666667, 0.5333333333333334, 0.6640522875816994],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        StyleBox[
         RowBox[{"RGBColor", "[", 
           RowBox[{"1.`", ",", "0.8`", ",", "0.996078431372549`"}], "]"}], 
         NumberMarks -> False]],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = 
           RGBColor[1., 0.8, 0.996078431372549]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1., 0.8, 0.996078431372549],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0.33725490196078434`, 0.00392156862745098, 0.2], 
           RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         DefaultBaseStyle->"ColorSwatchGraphics",
         Frame->True,
         FrameStyle->RGBColor[
          0.22483660130718958`, 0.0026143790849673205`, 0.13333333333333336`],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        StyleBox[
         RowBox[{"RGBColor", "[", 
           
           RowBox[{"0.33725490196078434`", ",", "0.00392156862745098`", ",", 
             "0.2`"}], "]"}], NumberMarks -> False]],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = 
           RGBColor[0.33725490196078434`, 0.00392156862745098, 0.2]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0.33725490196078434`, 0.00392156862745098, 0.2],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0.5254901960784314, 1., 0.8705882352941177], 
           RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         DefaultBaseStyle->"ColorSwatchGraphics",
         Frame->True,
         FrameStyle->RGBColor[
          0.35032679738562095`, 0.6666666666666667, 0.5803921568627451],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        StyleBox[
         RowBox[{"RGBColor", "[", 
           
           RowBox[{"0.5254901960784314`", ",", "1.`", ",", 
             "0.8705882352941177`"}], "]"}], NumberMarks -> False]],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = 
           RGBColor[0.5254901960784314, 1., 0.8705882352941177]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0.5254901960784314, 1., 0.8705882352941177],
      Editable->False,
      Selectable->False]}], "}"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.8599246348040857`*^9, 3.859924635591572*^9}, {
  3.8599246761099963`*^9, 3.85992468327722*^9}, {3.881709147033801*^9, 
  3.8817091501026683`*^9}, {3.9169945720697613`*^9, 3.916994574225131*^9}},
 CellLabel->
  "In[146]:=",ExpressionUUID->"c473ffd2-3bc3-43c0-9ec9-4c3420a42063"],

Cell[BoxData[
 RowBox[{
  RowBox[{"tickFunc", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Charting`ScaledTicks", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Identity", ",", "Identity"}], "}"}], ",", 
       RowBox[{"TicksLength", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{".02", ",", ".01"}], "}"}]}]}], "]"}], "[", "##", "]"}], 
    "&"}]}], ";"}]], "Input",
 CellLabel->
  "In[154]:=",ExpressionUUID->"6e1294b1-2f04-4d48-b2d4-8223398a74bf"],

Cell[BoxData[
 RowBox[{
  RowBox[{"rescale", "=", "2.0"}], ";"}]], "Input",
 CellLabel->
  "In[155]:=",ExpressionUUID->"7daf2119-60dd-464d-8c97-410f7c3fe130"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ExportPDF", "=", "True"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ExportPNG", "=", "True"}], ";"}]}], "Input",
 CellChangeTimes->{{3.9560789513094893`*^9, 3.9560789601423674`*^9}},
 CellLabel->
  "In[156]:=",ExpressionUUID->"83646cc2-e906-45ba-a0be-430f1b0c4ca2"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Data Import", "Section",
 CellChangeTimes->{{3.8159098859335394`*^9, 3.8159098936639137`*^9}, {
  3.816020473371563*^9, 3.8160204797198906`*^9}, {3.867287106187972*^9, 
  3.8672871084708767`*^9}, {3.9169979350764914`*^9, 3.9169979369826174`*^9}, {
  3.94641371084194*^9, 3.946413712127342*^9}, {3.955648158000458*^9, 
  3.9556481583871193`*^9}},ExpressionUUID->"c185520c-8497-43ef-aaa0-\
0a1ab0ee7af6"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"inFilesGGA", "=", 
   RowBox[{"Select", "[", 
    RowBox[{
     RowBox[{"FileNames", "[", 
      RowBox[{"{", "\"\<../04_GMTKN55_ANALYSIS_D3_10/*/GGA/*.dat\>\"", "}"}], 
      "]"}], ",", 
     RowBox[{
      RowBox[{"StringFreeQ", "[", 
       RowBox[{"#", ",", "\"\<NoDisp\>\""}], "]"}], "&"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"inFilesmGGA", "=", 
   RowBox[{"Select", "[", 
    RowBox[{
     RowBox[{"FileNames", "[", 
      RowBox[{"{", "\"\<../04_GMTKN55_ANALYSIS_D3_10/*/mGGA/*.dat\>\"", "}"}],
       "]"}], ",", 
     RowBox[{
      RowBox[{"StringFreeQ", "[", 
       RowBox[{"#", ",", "\"\<NoDisp\>\""}], "]"}], "&"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"inFilesHyb", "=", 
   RowBox[{"Select", "[", 
    RowBox[{
     RowBox[{"FileNames", "[", 
      RowBox[{"{", "\"\<../04_GMTKN55_ANALYSIS_D3_10/*/Hyb/*.dat\>\"", "}"}], 
      "]"}], ",", 
     RowBox[{
      RowBox[{"StringFreeQ", "[", 
       RowBox[{"#", ",", "\"\<NoDisp\>\""}], "]"}], "&"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"inFilesDHyb", "=", 
   RowBox[{"Select", "[", 
    RowBox[{
     RowBox[{"FileNames", "[", 
      RowBox[{"{", "\"\<../04_GMTKN55_ANALYSIS_D3_10/*/DHyb/*.dat\>\"", "}"}],
       "]"}], ",", 
     RowBox[{
      RowBox[{"StringFreeQ", "[", 
       RowBox[{"#", ",", "\"\<NoDisp\>\""}], "]"}], "&"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"inFiles", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{"{", 
     RowBox[{
     "inFilesGGA", ",", "inFilesmGGA", ",", "inFilesHyb", ",", 
      "inFilesDHyb"}], "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"inFiles", "=", "inFilesDHyb"}], ";"}], "*)"}]}]}], "Input",
 CellChangeTimes->{{3.955648162362415*^9, 3.9556481758935704`*^9}, {
   3.9657488552668695`*^9, 3.9657488787582955`*^9}, {3.965748925806166*^9, 
   3.96574892683398*^9}, {3.965749481827896*^9, 3.965749482546893*^9}, {
   3.9657497448016953`*^9, 3.9657497453852763`*^9}, {3.965750043930236*^9, 
   3.965750051602558*^9}, {3.9657529932203693`*^9, 3.9657529976124525`*^9}, {
   3.9660262362912416`*^9, 3.966026242106614*^9}, {3.9660284531788683`*^9, 
   3.966028458236166*^9}, {3.966283480622823*^9, 3.9662835093558674`*^9}, 
   3.9662848654954395`*^9, {3.9662861155930843`*^9, 3.9662861156266413`*^9}, {
   3.9663455107109365`*^9, 3.9663455215193872`*^9}, {3.9663456410064316`*^9, 
   3.9663456411064315`*^9}, {3.966353726356678*^9, 3.9663537541312885`*^9}, {
   3.9663537891113577`*^9, 3.966353794774789*^9}, {3.9663538284678664`*^9, 
   3.9663539411116314`*^9}, {3.966354079117476*^9, 3.9663540801201854`*^9}, {
   3.966354123049181*^9, 3.966354162234268*^9}, {3.9663636692871313`*^9, 
   3.9663636727738237`*^9}, {3.966366816543003*^9, 3.966366816986003*^9}, {
   3.9663669023891478`*^9, 3.9663669372712765`*^9}, {3.9663797300591917`*^9, 
   3.966379745469041*^9}, {3.9665312496296425`*^9, 3.966531271530178*^9}, {
   3.9665334680073433`*^9, 3.9665334965262804`*^9}, {3.966533875599331*^9, 
   3.9665339015167475`*^9}, {3.96653407810522*^9, 3.9665340839117546`*^9}, {
   3.9668825778312817`*^9, 3.9668825832415047`*^9}, {3.9668826149240646`*^9, 
   3.966882682955189*^9}, 3.966883635270401*^9, {3.966884196563286*^9, 
   3.966884246867936*^9}, {3.9668844346185317`*^9, 3.966884461599704*^9}, {
   3.967231162590311*^9, 3.9672311787966604`*^9}, {3.9672312290421915`*^9, 
   3.967231296023551*^9}, {3.967231371513477*^9, 3.96723141870621*^9}, {
   3.967246699690158*^9, 3.967246704965901*^9}, {3.9710324860528116`*^9, 
   3.9710324884259768`*^9}, {3.971032873289857*^9, 3.9710329075116425`*^9}, {
   3.9710329410496454`*^9, 3.971032942970271*^9}, {3.9710335905793877`*^9, 
   3.9710336217084165`*^9}, {3.972237088256653*^9, 3.9722370909072533`*^9}, {
   3.972237554202352*^9, 3.972237555201579*^9}, {3.9722375886411595`*^9, 
   3.9722376152291856`*^9}},ExpressionUUID->"ed90bb2e-a068-4f77-8983-\
114504f99343"],

Cell[BoxData[
 RowBox[{
  RowBox[{"OutputName", "=", "\"\<All\>\""}], ";"}]], "Input",
 CellChangeTimes->{{3.966883572802007*^9, 3.9668835798532944`*^9}, {
  3.9668836238964443`*^9, 3.96688363066175*^9}, {3.966884195918073*^9, 
  3.966884247855447*^9}, {3.9668844367702007`*^9, 3.966884463093897*^9}, {
  3.9672311616547985`*^9, 3.9672311797590075`*^9}, {3.967231249002288*^9, 
  3.9672312640466633`*^9}, {3.967231372094726*^9, 3.9672313824574685`*^9}, {
  3.967231416198678*^9, 3.967231416709158*^9}, {3.9710328818980513`*^9, 
  3.971032908391361*^9}, {3.9710329446496506`*^9, 3.971032945530624*^9}, {
  3.9710335926574855`*^9, 3.9710336239862304`*^9}, {3.972237556699919*^9, 
  3.9722375569629784`*^9}, {3.9722375902725196`*^9, 
  3.972237617520706*^9}},ExpressionUUID->"81ed498d-a020-47db-a7e1-\
0484dc511f56"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"inData", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"Length", "[", "inFiles", "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Data", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"Length", "[", "inFiles", "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"For", "[", 
  RowBox[{
   RowBox[{"i", "=", "1"}], ",", 
   RowBox[{"i", "\[LessEqual]", 
    RowBox[{"Length", "[", "inFiles", "]"}]}], ",", 
   RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"inData", "[", 
      RowBox[{"[", "i", "]"}], "]"}], "=", 
     RowBox[{"Import", "[", 
      RowBox[{
       RowBox[{"inFiles", "[", 
        RowBox[{"[", "i", "]"}], "]"}], ",", "\"\<Table\>\"", ",", 
       RowBox[{"\"\<FieldSeparators\>\"", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\< \>\"", ",", "\"\<\\n\>\""}], "}"}]}]}], "]"}]}], 
    ";"}]}], "\[IndentingNewLine]", "]"}]}], "Input",
 CellChangeTimes->{{3.8088987603844748`*^9, 3.808898760389476*^9}, {
   3.8088987974616737`*^9, 3.808898797699171*^9}, {3.808898955298374*^9, 
   3.8088989745769978`*^9}, {3.8088990204361343`*^9, 
   3.8088990475452023`*^9}, {3.8088993432862167`*^9, 3.8088993488074837`*^9}, 
   3.8089132373770795`*^9, {3.8089133938577895`*^9, 3.8089133946065784`*^9}, {
   3.808914348105073*^9, 3.808914374119644*^9}, {3.8143883775545034`*^9, 
   3.8143883776975117`*^9}, {3.817745247522892*^9, 3.8177452499678764`*^9}, {
   3.818307132829943*^9, 3.8183071427258015`*^9}, {3.832184000310708*^9, 
   3.832184000476708*^9}, {3.832184785705651*^9, 3.8321848128556232`*^9}, {
   3.877375316157969*^9, 3.8773753720445166`*^9}, {3.8773754257529335`*^9, 
   3.877375425903227*^9}, {3.8773761048033004`*^9, 3.8773761243783264`*^9}, {
   3.880490835089597*^9, 3.8804908354891977`*^9}, {3.880491001144314*^9, 
   3.880491058196918*^9}, 3.880585036623171*^9, {3.8808316743775115`*^9, 
   3.8808316744975185`*^9}, {3.88083173553826*^9, 3.8808317548350506`*^9}, {
   3.880831861639245*^9, 3.8808318639946413`*^9}, {3.889702231245826*^9, 
   3.88970223777074*^9}, {3.8897024145049667`*^9, 3.8897025536689067`*^9}, {
   3.889702615469081*^9, 3.8897026188224983`*^9}, {3.889702865915352*^9, 
   3.8897028699672756`*^9}, {3.889702941728506*^9, 3.8897029444915085`*^9}, {
   3.88970298826377*^9, 3.889702999934156*^9}, {3.889703079839328*^9, 
   3.8897030824790154`*^9}, {3.8897031305551376`*^9, 
   3.8897031316048975`*^9}, {3.8897168509214096`*^9, 3.889716863026906*^9}, {
   3.889718077479236*^9, 3.889718102022805*^9}, {3.8939562645703554`*^9, 
   3.8939562652538166`*^9}, {3.9496753559836407`*^9, 
   3.9496754121934814`*^9}, {3.949675454212244*^9, 3.9496754568630953`*^9}, {
   3.9496773381143293`*^9, 3.9496773387519813`*^9}, 3.9496773867862864`*^9, {
   3.949677437142476*^9, 3.949677488351195*^9}, {3.949677540051149*^9, 
   3.949677548830299*^9}, {3.949933271121267*^9, 3.9499332712770205`*^9}, {
   3.951004015176592*^9, 3.9510040162198267`*^9}, {3.9523529248334885`*^9, 
   3.9523529249575167`*^9}, {3.952353188870604*^9, 3.9523531919893055`*^9}, 
   3.9527199394409933`*^9, {3.9657495327359934`*^9, 3.9657495435160108`*^9}, 
   3.9657497403493233`*^9, 3.966354242952199*^9, {3.966354380837802*^9, 
   3.9663543864565396`*^9}},
 CellLabel->
  "In[165]:=",ExpressionUUID->"94823ce5-4b35-4f02-9bc2-98c3b8acc3a2"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"FuncNameRow", "=", 
   RowBox[{"-", "6"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"WTMAD1row", "=", 
   RowBox[{"-", "5"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"WTMAD2row", "=", 
   RowBox[{"-", "4"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"WTMAD3row", "=", 
   RowBox[{"-", "3"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"WTMAD4row", "=", 
   RowBox[{"-", "2"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.9668828884658785`*^9, 3.9668829046427836`*^9}, {
  3.966883012721449*^9, 3.9668830437513585`*^9}, {3.9668841427573586`*^9, 
  3.9668841499869013`*^9}},
 CellLabel->
  "In[168]:=",ExpressionUUID->"59b75a32-63d2-487e-9853-04c195d368d7"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Data Processing", "Section",
 CellChangeTimes->{{3.8159098859335394`*^9, 3.8159098936639137`*^9}, {
  3.816020473371563*^9, 3.8160204797198906`*^9}, {3.867287106187972*^9, 
  3.8672871084708767`*^9}, {3.9169979350764914`*^9, 3.9169979369826174`*^9}, {
  3.94641371084194*^9, 
  3.946413720636649*^9}},ExpressionUUID->"7f4f10e9-0978-4bf8-adf7-\
6fc4e0f89d6e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ResTable", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"inData", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "FuncNameRow", ",", 
          RowBox[{"-", "1"}]}], "]"}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"NumberForm", "[", 
        RowBox[{
         RowBox[{"inData", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "WTMAD1row", ",", 
            RowBox[{"-", "1"}]}], "]"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", "2"}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"NumberForm", "[", 
        RowBox[{
         RowBox[{"inData", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "WTMAD2row", ",", 
            RowBox[{"-", "1"}]}], "]"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", "2"}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"NumberForm", "[", 
        RowBox[{
         RowBox[{"inData", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "WTMAD3row", ",", 
            RowBox[{"-", "1"}]}], "]"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", "2"}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"NumberForm", "[", 
        RowBox[{
         RowBox[{"inData", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "WTMAD4row", ",", 
            RowBox[{"-", "1"}]}], "]"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", "2"}], "}"}]}], "]"}]}], "\[IndentingNewLine]", 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", "inData", "]"}]}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.9668830658543806`*^9, 3.9668831511360683`*^9}, {
  3.9668832029875803`*^9, 3.966883218003999*^9}, {3.9668841352147026`*^9, 
  3.966884138845236*^9}},
 CellLabel->
  "In[173]:=",ExpressionUUID->"bd4e163a-32f7-4024-b97c-9255e86fff07"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"WTMAD1Rank", "=", 
   RowBox[{"Prepend", "[", 
    RowBox[{
     RowBox[{"SortBy", "[", 
      RowBox[{"ResTable", ",", 
       RowBox[{
        RowBox[{"#", "[", 
         RowBox[{"[", "2", "]"}], "]"}], "&"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\<Func.\>\"", ",", "\"\<WTMAD-1(Sorted)\>\"", ",", "\"\<WTMAD-2\>\"",
        ",", "\"\<WTMAD-3\>\"", ",", "\"\<WTMAD-4\>\""}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"WTMAD2Rank", "=", 
   RowBox[{"Prepend", "[", 
    RowBox[{
     RowBox[{"SortBy", "[", 
      RowBox[{"ResTable", ",", 
       RowBox[{
        RowBox[{"#", "[", 
         RowBox[{"[", "3", "]"}], "]"}], "&"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\<Func.\>\"", ",", "\"\<WTMAD-1\>\"", ",", "\"\<WTMAD-2(Sorted)\>\"",
        ",", "\"\<WTMAD-3\>\"", ",", "\"\<WTMAD-4\>\""}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"WTMAD3Rank", "=", 
   RowBox[{"Prepend", "[", 
    RowBox[{
     RowBox[{"SortBy", "[", 
      RowBox[{"ResTable", ",", 
       RowBox[{
        RowBox[{"#", "[", 
         RowBox[{"[", "4", "]"}], "]"}], "&"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\<Func.\>\"", ",", "\"\<WTMAD-1\>\"", ",", "\"\<WTMAD-2\>\"", ",", 
       "\"\<WTMAD-3(Sorted)\>\"", ",", "\"\<WTMAD-4\>\""}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"WTMAD4Rank", "=", 
   RowBox[{"Prepend", "[", 
    RowBox[{
     RowBox[{"SortBy", "[", 
      RowBox[{"ResTable", ",", 
       RowBox[{
        RowBox[{"#", "[", 
         RowBox[{"[", "5", "]"}], "]"}], "&"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\<Func.\>\"", ",", "\"\<WTMAD-1\>\"", ",", "\"\<WTMAD-2\>\"", ",", 
       "\"\<WTMAD-3\>\"", ",", "\"\<WTMAD-4(Sorted)\>\""}], "}"}]}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.9668832473797193`*^9, 3.9668832779726815`*^9}, {
  3.966883309508891*^9, 3.966883340351612*^9}, {3.966883444189048*^9, 
  3.9668834770010414`*^9}, {3.966883518149585*^9, 3.96688355234167*^9}, {
  3.9668838853160515`*^9, 3.966883920572279*^9}, {3.9668840784130383`*^9, 
  3.9668841311173587`*^9}},
 CellLabel->
  "In[174]:=",ExpressionUUID->"0631ace8-d220-4c46-9721-51a58277fe40"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exports", "Section",
 CellChangeTimes->{{3.8159098859335394`*^9, 3.8159098936639137`*^9}, {
   3.816020473371563*^9, 3.8160204797198906`*^9}, {3.867287106187972*^9, 
   3.8672871084708767`*^9}, {3.9169979350764914`*^9, 
   3.9169979369826174`*^9}, {3.94641371084194*^9, 3.9464137299645586`*^9}, 
   3.9556493624167347`*^9, {3.9556542149812284`*^9, 3.9556542185457573`*^9}, {
   3.9565872139918404`*^9, 3.9565872150360765`*^9}, {3.956587245363923*^9, 
   3.9565872461460996`*^9}, {3.966374588928936*^9, 
   3.9663746185440164`*^9}},ExpressionUUID->"fd461c48-5d7a-4e69-8e8b-\
b14f19e83f99"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"strLen", "=", "25"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"formatEntry", "[", "e_", "]"}], ":=", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"NumberQ", "[", "e", "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"StringPadRight", "[", 
      RowBox[{
       RowBox[{"ToString", "[", 
        RowBox[{"NumberForm", "[", 
         RowBox[{
          RowBox[{"N", "[", "e", "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"4", ",", "2"}], "}"}]}], "]"}], "]"}], ",", "strLen"}], 
      "]"}], ",", 
     RowBox[{"(*", 
      RowBox[{
       RowBox[{"numbers", ":", 
        RowBox[{"2", " ", "decimals"}]}], ",", "padded"}], "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"StringPadRight", "[", 
      RowBox[{
       RowBox[{"ToString", "[", "e", "]"}], ",", "strLen"}], "]"}]}], 
    "                        ", 
    RowBox[{"(*", 
     RowBox[{"strings", " ", "padded"}], "*)"}], "\[IndentingNewLine]", 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"WTMAD1RankFormatted", "=", 
   RowBox[{"StringRiffle", "[", 
    RowBox[{
     RowBox[{"Map", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"StringJoin", "@@", 
         RowBox[{"(", 
          RowBox[{"formatEntry", "/@", "#"}], ")"}]}], "&"}], ",", 
       "WTMAD1Rank"}], "]"}], ",", "\"\<\\n\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"WTMAD2RankFormatted", "=", 
   RowBox[{"StringRiffle", "[", 
    RowBox[{
     RowBox[{"Map", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"StringJoin", "@@", 
         RowBox[{"(", 
          RowBox[{"formatEntry", "/@", "#"}], ")"}]}], "&"}], ",", 
       "WTMAD2Rank"}], "]"}], ",", "\"\<\\n\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"WTMAD3RankFormatted", "=", 
   RowBox[{"StringRiffle", "[", 
    RowBox[{
     RowBox[{"Map", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"StringJoin", "@@", 
         RowBox[{"(", 
          RowBox[{"formatEntry", "/@", "#"}], ")"}]}], "&"}], ",", 
       "WTMAD3Rank"}], "]"}], ",", "\"\<\\n\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"WTMAD4RankFormatted", "=", 
   RowBox[{"StringRiffle", "[", 
    RowBox[{
     RowBox[{"Map", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"StringJoin", "@@", 
         RowBox[{"(", 
          RowBox[{"formatEntry", "/@", "#"}], ")"}]}], "&"}], ",", 
       "WTMAD4Rank"}], "]"}], ",", "\"\<\\n\>\""}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.966374376289008*^9, 3.9663743989738054`*^9}, {
   3.966374434665557*^9, 3.9663744594089413`*^9}, {3.96688380056036*^9, 
   3.966883851447335*^9}, 3.9668838934675226`*^9, {3.9668840682279725`*^9, 
   3.966884075416961*^9}, 3.9668844144046965`*^9},
 CellLabel->
  "In[178]:=",ExpressionUUID->"037d00a3-d776-401c-afa9-a42eb0b746eb"],

Cell[BoxData[""], "Input",
 CellChangeTimes->{
  3.9663785498420687`*^9, {3.966378681423541*^9, 3.966378694079651*^9}, {
   3.966637426444252*^9, 3.966637450804302*^9}, {3.966883646742405*^9, 
   3.9668836797518125`*^9}, 3.9668838568405905`*^9, 3.9668840523700476`*^9},
 CellLabel->
  "In[184]:=",ExpressionUUID->"1974bdf0-4ff3-4fcd-ad48-a9913c7909f1"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{
    RowBox[{"OutputName", "<>", "\"\<_WTMAD1_Rank.dat\>\""}], ",", 
    "WTMAD1RankFormatted"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{
    RowBox[{"OutputName", "<>", "\"\<_WTMAD2_Rank.dat\>\""}], ",", 
    "WTMAD2RankFormatted"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{
    RowBox[{"OutputName", "<>", "\"\<_WTMAD3_Rank.dat\>\""}], ",", 
    "WTMAD3RankFormatted"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{
    RowBox[{"OutputName", "<>", "\"\<_WTMAD4_Rank.dat\>\""}], ",", 
    "WTMAD4RankFormatted"}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.9668836836421824`*^9, 3.966883684944732*^9}, 
   3.966883857638495*^9, {3.966884053491786*^9, 3.966884065746668*^9}, {
   3.966884156375389*^9, 3.966884157594946*^9}},
 CellLabel->
  "In[185]:=",ExpressionUUID->"d5f21961-6929-4a78-84c1-4909bed08d0f"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{2544, 1341},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification:>1.5 Inherited,
FrontEndVersion->"12.1 for Microsoft Windows (64-bit) (June 19, 2020)",
StyleDefinitions->"ReverseColor.nb",
ExpressionUUID->"bf841a30-7870-42e1-be3c-b105f5f42b87"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 2661, 36, 146, "Title",ExpressionUUID->"e8b4790c-cfdb-4f8c-a2f6-82c285868c97"],
Cell[3244, 60, 2256, 35, 171, "Subtitle",ExpressionUUID->"a0191fbe-e215-48a4-8c4f-f26ba47d6f9a"],
Cell[CellGroupData[{
Cell[5525, 99, 356, 6, 99, "Section",ExpressionUUID->"507e86bc-9f42-4233-b3d9-06883a36e4ae"],
Cell[CellGroupData[{
Cell[5906, 109, 303, 5, 80, "Subsection",ExpressionUUID->"d91f3b2c-0440-4cb2-8689-d2b2fefc28b1"],
Cell[6212, 116, 227, 4, 43, "Input",ExpressionUUID->"868b0a4a-0a23-4b4d-8e6d-5e70e42b84a2"],
Cell[6442, 122, 324, 7, 43, "Input",ExpressionUUID->"12acc223-ce39-4b57-946d-7c24fa7087a0"],
Cell[6769, 131, 200, 4, 43, "Input",ExpressionUUID->"80403d44-4f07-4dd5-a191-c73917630ec8"],
Cell[6972, 137, 224, 4, 43, "Input",ExpressionUUID->"58b1b704-9bb1-4e0e-ae8b-3f5f82a2e7e6"],
Cell[7199, 143, 27745, 690, 247, "Input",ExpressionUUID->"c473ffd2-3bc3-43c0-9ec9-4c3420a42063"],
Cell[34947, 835, 467, 14, 43, "Input",ExpressionUUID->"6e1294b1-2f04-4d48-b2d4-8223398a74bf"],
Cell[35417, 851, 158, 4, 43, "Input",ExpressionUUID->"7daf2119-60dd-464d-8c97-410f7c3fe130"],
Cell[35578, 857, 312, 7, 73, "Input",ExpressionUUID->"83646cc2-e906-45ba-a0be-430f1b0c4ca2"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[35939, 870, 408, 6, 99, "Section",ExpressionUUID->"c185520c-8497-43ef-aaa0-0a1ab0ee7af6"],
Cell[36350, 878, 4023, 85, 189, "Input",ExpressionUUID->"ed90bb2e-a068-4f77-8983-114504f99343"],
Cell[40376, 965, 813, 13, 43, "Input",ExpressionUUID->"81ed498d-a020-47db-a7e1-0484dc511f56"],
Cell[41192, 980, 3447, 66, 160, "Input",ExpressionUUID->"94823ce5-4b35-4f02-9bc2-98c3b8acc3a2"],
Cell[44642, 1048, 735, 20, 160, "Input",ExpressionUUID->"59b75a32-63d2-487e-9853-04c195d368d7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[45414, 1073, 364, 6, 99, "Section",ExpressionUUID->"7f4f10e9-0978-4bf8-adf7-6fc4e0f89d6e"],
Cell[45781, 1081, 1991, 52, 218, "Input",ExpressionUUID->"bd4e163a-32f7-4024-b97c-9255e86fff07"],
Cell[47775, 1135, 2287, 63, 131, "Input",ExpressionUUID->"0631ace8-d220-4c46-9721-51a58277fe40"]
}, Open  ]],
Cell[CellGroupData[{
Cell[50099, 1203, 594, 9, 99, "Section",ExpressionUUID->"fd461c48-5d7a-4e69-8e8b-b14f19e83f99"],
Cell[50696, 1214, 2863, 82, 276, "Input",ExpressionUUID->"037d00a3-d776-401c-afa9-a42eb0b746eb"],
Cell[53562, 1298, 352, 6, 43, "Input",ExpressionUUID->"1974bdf0-4ff3-4fcd-ad48-a9913c7909f1"],
Cell[53917, 1306, 1006, 25, 131, "Input",ExpressionUUID->"d5f21961-6929-4a78-84c1-4909bed08d0f"]
}, Open  ]]
}, Open  ]]
}
]
*)

