import os
import subprocess
import tempfile
import shutil
import hashlib
import base64

try :
    from rdkit import Chem
except :
    pass

def get_hash(input_string):
    # return  hashlib.md5(input_string.encode()).hexdigest()
    hash_md5 = hashlib.md5(input_string.encode()).digest()
    base64_hash = base64.urlsafe_b64encode(hash_md5).decode('utf-8').rstrip('=')
    return base64_hash


def writexyz(mol, filen="ligand.xyz", numConfs=1, minimize=True, max_energy_threshold=1000):
    global useminGauss_only
    if False and useminGauss_only :
        if  not validate_molecule(mol):
            print("Invalid molecule structure for Gaussian Input. Aborting minimization.")
            return False
        else :    
            print ("Not ready to use writexyzG")
            exit()     
            # return writexyzG(mol,filen=filen,useGmethod="AM1")
    nmaded = True
    ok = True
    min_energy = float('inf')  # To track the lowest energy
    conformer_selected = None
    failed = 0
    maxattempts=4
    # Validate the molecule structure before starting
    if False : # not validate_molecule(mol):
        print("Invalid molecule structure. Aborting minimization.")
        return False

    # Try generating multiple conformers with attempts to find the best one
    for attempt in range(maxattempts):  # Allow up to 10 attempts
        try:
            conformers = AllChem.EmbedMultipleConfs(mol, numConfs=numConfs)            
            if not minimize:  
                AllChem.UFFOptimizeMolecule(mol)                                
            for conformer_id in range(numConfs):
                conformer = mol.GetConformer(conformer_id)

                if minimize:
                    # Try MMFF94 first, fallback to UFF if MMFF fails
                    try:
                        forcefield = AllChem.MMFFGetMoleculeForceField(mol, confId=conformer.GetId())
                    except:
                        print("MMFF failed, switching to UFF")
                        forcefield = AllChem.UFFGetMoleculeForceField(mol, confId=conformer.GetId())
                    
                    forcefield.Initialize()
                    forcefield.Minimize()

                    # Get the minimized energy
                    energy = forcefield.CalcEnergy()
                    print(f"Conformer {conformer_id}, Energy: {energy}")

                    # Keep track of the lowest energy conformer
                    if energy < min_energy:
                        min_energy = energy
                        conformer_selected = conformer
                

            if min_energy < max_energy_threshold or not minimize:
                nmaded = False
                if not minimize:                     
                    conformer_selected = conformer
                break
        except Exception as e:
            print("Conformer generation or minimization failed. Retrying...", e)
            failed+=1
            continue

    # If no valid conformer is found after several attempts, return False
    if (min_energy >= max_energy_threshold or conformer_selected is None) and  minimize:
        print("Failed to find a valid minimized conformation with acceptable energy.")
        return False
    if maxattempts==failed : 
        print("Failed to find a maxttempts ")
        return False
    # Add the best conformer to the molecule
    mol.AddConformer(conformer_selected)

    # Save the structure to XYZ format
    xyzmol = Chem.MolToXYZBlock(mol)
    with open(filen, 'w') as f:
        f.write(xyzmol)
    print(f"Minimized structure written to {filen} with energy {min_energy}")

    return True

def find_java():
    """Attempts to find the Java executable path."""
    # Try finding Java in the PATH first
    java_path = shutil.which("java")
    
    # Check common installation paths if not found in PATH
    if not java_path:
        common_paths = [
            "C:\\Program Files\\Java",
            "C:\\Program Files (x86)\\Java"
        ]
        
        for base_path in common_paths:
            for folder in os.listdir(base_path):
                potential_path = os.path.join(base_path, folder, "bin", "java.exe")
                if os.path.isfile(potential_path):
                    return potential_path
    return java_path

def find_jmol(start_dir="C:\\"):
    """Attempts to find the Jmol .jar file by searching from a given start directory."""
    for root, _, files in os.walk(start_dir):
        for file in files:
            if file.lower().endswith("jmol.jar"):
                return os.path.join(root, file)
    return None

def open_jmol_script(script_filename):
    """
    Opens Jmol with the given SMILES string, attempting to auto-detect Java and Jmol paths.
    """
    java_path = find_java()
    print("java_path",java_path)
    # jmol_path="C:\jmol-14.30.1\Jmol.jar"
    jmol_path = find_jmol()
    print("Jmol_path",jmol_path)
    
    if not java_path:
        raise FileNotFoundError("Java executable not found. Please install Java or add it to the PATH.")
    if not jmol_path:
        raise FileNotFoundError("Jmol .jar file not found. Please ensure Jmol is installed.")

    # Call Jmol using the detected Java path and Jmol path
    subprocess.Popen([java_path, "-jar", jmol_path, "-s", script_filename])

def open_jmol_with_smiles(smiles,script=None):
    """
    Opens Jmol with the given SMILES string, attempting to auto-detect Java and Jmol paths.
    """
    java_path = find_java()
    print("java_path",java_path)
    # jmol_path="C:\jmol-14.30.1\Jmol.jar"
    jmol_path = find_jmol()
    print("jmol_path",jmol_path)
    
    if not java_path:
        raise FileNotFoundError("Java executable not found. Please install Java or add it to the PATH.")
    if not jmol_path:
        raise FileNotFoundError("Jmol .jar file not found. Please ensure Jmol is installed.")

    # Create a temporary script file with the necessary commands
    spt_file="test.spt"
    unique_dir = str(abs(hash(smiles)))
    # unique_dir = get_hash(smiles)
    with open(spt_file, 'w') as script_file:
        # Write the Jmol script to load the SMILES string
        if script!=None:
            script_file.write(f"load ${smiles};\n")
            # script_file.write(f"load smiles {smiles};\n")
            script_file.write("display;hide none;")
        else :            
            script_file.write("background white;\n")
            script_file.write(f"proteinPath = './{unique_dir}/protein.pdb';\n")
            script_file.write(f"ligandPath = './{unique_dir}/pose_1.xyz';\n")
            script_file.write("load @proteinPath;\n")
            script_file.write("load append @ligandPath;\n model1=1.1 \n model2=2.1; \n x= contact ({model =@model1} {model =@model2});\n define contacs1  x and model =@model1 \n define contacs2  x and model =@model2;\n select {model = @model1};\n draw off \n cpk off;\n cartoons off;\n  wireframe 0.15; \n")
            script_file.write("background white;\n proteinPath = './protein.pdb';\n ligandPath = '{unique_dir}./pose_1.xyz';\n load @proteinPath;\n load append @ligandPath;\n model1=1.1 \n model2=2.1; \n x= contact ({model =@model1} {model =@model2});\n define contacs1  x and model =@model1 \n define contacs2  x and model =@model2;\n select {model = @model1};\n draw off \n cpk off;\n cartoons off;\n  wireframe 0.15; \n")
            script_file.write("for (var i in {contacs1}) {\n") 
            script_file.write("select i;\n") 
            script_file.write("xi =contact ({selected}[1] {contacs2});\n") 
            script_file.write("define contacs2a  xi  and model =@model2;\n") 
            script_file.write("for (var j in {contacs2a}) {\n") 
            script_file.write("select i or j;\n") 
            script_file.write("measure {selected}[1] {selected}[2]}};\n") 
            script_file.write("contact {model =@model1} {model =@model2};\n") 
            script_file.write("select {model = @model1} and not {contacs1};\n")
            script_file.write("color {selected} translucent 200;\n")
            script_file.write("zoom {model = @model2};\n")
            script_file.write("model @model1 @model2;\n")
            script_file.write("contact ID HBO {model =@model1} {model =@model2} hbond;\n")                    
        # Save the filename to pass it to Jmol
        script_filename = script_file.name
    # Call Jmol using the detected Java path and Jmol path
    subprocess.Popen([java_path, "-jar", jmol_path, "-s", script_filename])



def open_jmol_with_smiles_from_file(filename, delimiter=","):
    """
    Reads SMILES strings from the 5th column of a file and opens each molecule in Jmol.
    
    Parameters:
        filename (str): The path to the file containing SMILES strings in the 5th column.
        jmol_path (str): The path to the Jmol executable.
        delimiter (str): The delimiter used in the file (default is comma for CSV).
    """
    spt_file="test.spt"
    smiles=[]
    script_file = open(spt_file, 'w') 

    with open(filename, "r") as file:
        for line in file:
            columns = line.strip().split(delimiter)
            if len(columns) >= 5:
                smiles.append(columns[4])  # 5th column
                script_file.write(f"load append smiles {smiles[-1]};\n")                
        script_file.write("display;hide none;")
        
        # Save the filename to pass it to Jmol
        open_jmol_script(script_file.name)

# Path to Jmol executable
# jmol_path = "/opt2/jmol-14.32.81/jmol.sh"
# 
# Open a single SMILES in Jmol
if __name__=="__main__":
    open_jmol_with_smiles("CC(COC#COF)ON")

# Open multiple SMILES from a file
# filename = "smiles_list.txt"
# open_jmol_with_smiles_from_file(filename, delimiter=" ")
