useminEnergy=True           # use RDkit for minimazation
useminGauss_only=False      # use Gaussina for minimazation
usepHprot=True              # enreach stracture at acid and basic pH  
usetautom=False             # enreach stracture finding tautomers
useAD4 = False              # if true use AD4 if False use autodock Vina
check3rings=False           # check for 3 member rings

# quantum calculations 
useGaussian=True           # use Gaussian 16 
useUV=True                  # if true use Gaussian 16 to estimate UV spectrum
useUV_Bond_order_beake=False                  # if true use Gaussian 16 to estimate UV spectrum and the barkage of bonds
useIR=False                 # if true use Gaussian 16 to estimate IR spectrum
useNMR = False              # if true use Gaussian 16 to estimate NMR spectrum

Samp_Msize=15  # number of explored local minima 
nnaib = 6 
maxsteps = 6
Target=290.  # None  # for minimazation 
if useUV_Bond_order_beake :  Target =[Target,1] 
# initsmiles = "CNCC(N)(NO)C(F)C(=O)N"
initsmiles ="CO"
# initsmiles ="C1=C2NC(O1)O2"
# initsmiles ="C1=CNOC1"
# initsmiles ="C=C(O)ONC"    # brackes proubly upon uv 
# smiles = "C"
# initsmiles ="N#COS"
# initsmiles ="OCC(O)=CBr"
# initsmiles ='CC#N'
# initsmiles ="CC(C)CBr"
# initsmiles = "CC(C)=CCC1=C2OC(C)(C)C=CC2=C3OC=C(C(=O)C3=C1O)C4=CC=C(O)C=C4"

storeOBJ=False
showPLOTS=False
makeplot=True
viewlast=False

if useUV_Bond_order_beake : useUV = True
if useUV or useIR or useNMR : useGaussian = True 

from copy import deepcopy
import time
import re
try :
	from mpi4py import MPI
	mpiuse=True
except :
	print("MPI Failed")
	mpiuse=False
from molpher.core.morphing import Molpher
from molpher.core import MolpherMol
from isomerstates import sample_pH, pH_then_st, tautomers,stan_then_pH
from rdkit.Chem.Draw import IPythonConsole
IPythonConsole.ipython_useSVG = False
from molpher.core.morphing.operators import AddAtom, RemoveAtom, MutateAtom,AddBond,RemoveBond,ContractBond, InterlayAtom, RerouteBond
import random
from PIL import Image
import numpy as np
from rdkit import Chem
from rdkit.Chem import Descriptors, Lipinski, AllChem
import networkx as nx
import matplotlib.pyplot as plt
from queue import PriorityQueue
from ExtMorphing import AddFragment, DelFragment
import sys
import multiprocessing
import pickle
import requests  # for retriving upac names
from PIL import Image, ImageDraw, ImageFont
from openbabel import openbabel as ob
# from openbabel import obGetPluginPath 
import subprocess
import os
import shutil
from state_sampler import Sate_Sampler
import hashlib
import base64

from rdkit import Chem
from extract_bond_orders import extract_bond_orders

def get_hash(input_string):
    # return  hashlib.md5(input_string.encode()).hexdigest()
    hash_md5 = hashlib.md5(input_string.encode()).digest()
    base64_hash = base64.urlsafe_b64encode(hash_md5).decode('utf-8').rstrip('=')
    return base64_hash

def identify_fragments(smiles):
    """
    Identifies if a given SMILES corresponds to a single molecule or multiple fragments.
    
    Args:
        smiles (str): The SMILES representation of the molecule.

    Returns:
        tuple: A boolean indicating if the SMILES represents a single molecule (True) or not (False),
               and a list of SMILES strings for each fragment if there are multiple fragments.
    """
    # Convert SMILES to RDKit molecule object
    molecule = Chem.MolFromSmiles(smiles)
    
    # Check if the molecule is valid
    if molecule is None:
        return False, []

    # Use RDKit to identify the number of fragments
    fragments = Chem.GetMolFrags(molecule, asMols=True)
    
    # If there is only one fragment, it's a single molecule
    if len(fragments) == 1:
        return True, [smiles]
    else:
        # Convert each fragment back to a SMILES string
        fragment_smiles = [Chem.MolToSmiles(frag) for frag in fragments]
        return False, fragment_smiles


deb_f = open("debugF.txt", "w")

def makeGplot(graph,path,goal,node_prop):
    plt.figure()
    G = nx.DiGraph()
    edge_labels = {}
    node_label={}
    node_colors={}

    for node in graph:
        G.add_node(node)
        node_colors[node] ='red'
        try :
            node_label[node]=str(float("%.3f" %  node_prop[node] ))
        except :
            node_label[node]="Failed"

    node_colors[goal] = 'green'
    node_colors[path[0]] = 'gray'

    add_edges_from_dict(G,graph,color_edges="blue")                 

    for ist in range(1,len(path)):
        try :
            w = graph[path[ist-1]][path[ist]]
            G.add_edge(path[ist-1], path[ist], weight=w,color="red")
            edge_labels[(path[ist-1], path[ist])] = float("%.3f" %graph[path[ist-1]][path[ist]])
        except :
            pass
        # node_colors[neighbor] = 'orange'
    # self.edge_colors = [self.G[u][v]['color'] for u, v in self.G.edges()]
    try :
        # pos = nx.planar_layout(G)
        pos = nx.kamada_kawai_layout(G)
        # pos = nx.spectral_layout(self.G)
        # pos = nx.fruchterman_reingold_layout(self.G)
        nx.draw(G, pos, with_labels=False, arrows=True)
        nx.draw_networkx_nodes(G, pos, node_color=node_colors.values())
        # nx.draw_networkx_edges(self.G, pos, edge_color=self.edge_colors)
        nx.draw_networkx_edge_labels(G, pos, edge_labels=edge_labels)
        nx.draw_networkx_labels(G, pos,labels=node_label)
        try :
           if showPLOTS:  plt.show()
        except :
           pass 
#          plt.savefig("graph.png")
    except :
        pass

def Viewlast():      
    global showPLOTS
    showPLOTS=True 
    oldgraph1=load_obj("18outp_graph.pk")
    minv=10e10
    oldpath1 = load_obj("19outp_path.pk")
    oldnode_prop1=load_obj("19outp_node.pk")
    for k in oldnode_prop1.keys() :
        print(k,oldnode_prop1[k])
        minv=min(minv,oldnode_prop1[k])
    print(minv)

    drawpath(oldpath1)
    plot_path_val(path=oldpath1,node_prop=oldnode_prop1)
    try :
        oldG1=load_obj("outp_G.pk")
    except :
        pass
    makeGplot(graph=oldgraph1,path=oldpath1,goal=oldpath1[-1],node_prop=oldnode_prop1)

    return oldgraph1 , oldpath1, oldnode_prop1  

def split_list(lst, size):
    # Calculate the number of full sublists and the remainder
    n = len(lst)
    full_sublists_count = n // size
    remainder = n % size

    # Create the 2D list with evenly distributed elements
    result = []
    start = 0
    for i in range(size):
        end = start + full_sublists_count + (1 if i < remainder else 0)
        result.append(lst[start:end])
        start = end

    return result

def plot_path_val(path=[],node_prop={}):
    plt.figure()
    props=[]
    for ist in path :
        try :
            pro1 = node_prop[ist]
            props.append(pro1)
        except :
            print( node_prop.keys())
#        pro =myChemS.calculate_properties(ist)
#        print("Path Free Energy",pro," ",pro1)
    plt.plot(props)
    plt.savefig("pathout.png")
    if showPLOTS: plt.show()

def atomic_number_to_xyz_atom(atomic_number):
    # Dictionary mapping atomic numbers to element symbols
    element_symbols = {
        1: 'H',   # Hydrogen
        2: 'He',  # Helium
        3: 'Li',  # Lithium
        4: 'Be',  # Beryllium
        5: 'B',   # Boron
        6: 'C',   # Carbon
        7: 'N',   # Nitrogen
        8: 'O',   # Oxygen
        9: 'F',   # Fluorine
        10: 'Ne', # Neon
        11: 'Na', # Sodium
        12: 'Mg', # Magnesium
        13: 'Al', # Aluminum
        14: 'Si', # Silicon
        15: 'P',  # Phosphorus
        16: 'S',  # Sulfur
        17: 'Cl', # Chlorine
        18: 'Ar', # Argon
        19: 'K',  # Potassium
        20: 'Ca', # Calcium
        21: 'Sc', # Scandium
        22: 'Ti', # Titanium
        23: 'V',  # Vanadium
        24: 'Cr', # Chromium
        25: 'Mn', # Manganese
        26: 'Fe', # Iron
        27: 'Co', # Cobalt
        28: 'Ni', # Nickel
        29: 'Cu', # Copper
        30: 'Zn', # Zinc
        # Add more elements as needed
    }

    # Check if the atomic number is in the dictionary
    if atomic_number in element_symbols:
        return element_symbols[atomic_number]
    else:
        return "Unknown element"

def find_max_absorption(wavelengths, oscillator_strengths):
    # Find the index of the maximum oscillator strength
    max_index = oscillator_strengths.index(max(oscillator_strengths))
    
    # Retrieve the wavelength and oscillator strength corresponding to the max value
    max_wavelength = wavelengths[max_index]
    max_oscillator_strength = oscillator_strengths[max_index]
    
    # print(f"Maximum absorption peak at wavelength: {max_wavelength} nm with oscillator strength: {max_oscillator_strength}")    
    return max_wavelength, max_oscillator_strength

def Molfermol_smiles(smiles = "c1ccccc1"):
    # Define benzene SMILES
#    smiles = "c1ccccc1"
    # Generate RDKit molecule object from SMILES
    mol = MolpherMol(smiles)
    return mol

def mol_smiles(smiles = "c1ccccc1"):
    # Define benzene SMILES
#    smiles = "c1ccccc1"
    # Generate RDKit molecule object from SMILES
    mol = Chem.MolFromSmiles(smiles)
# Add explicit hydrogens
    mol = Chem.AddHs(mol)
    # for atom in mol.GetAtoms():
    # Visualize the molecule
        # mol.AddHs()
    return mol

def setPh_smiles(smiles = "c1ccccc1",Ph=[7.]):
    outSmiles =[]
    for iPh in Ph :
        mol2 = ob.OBMol()
        obConversion = ob.OBConversion()
        # obConversion.AddOption("p", obConversion.GENOPTIONS, "3.0")
        obConversion.SetInAndOutFormats("smi", "mol") # SetOutFormat("smi")  # Set output format to SMILES
        obConversion.ReadString(mol2,smiles)
        mol2.DeleteHydrogens()
        # mol2.AddHydrogens(False, True, iPh)
        mol2.CorrectForPH(iPh)
        obConversion2 = ob.OBConversion()
        obConversion2.SetOutFormat("smi")  # Set output format to SMILES
# Convert OBMol to SMILES
        smiles = obConversion2.WriteString(mol2).strip()   
        outSmiles.append(smiles)
    return outSmiles     


def molxyz(smiles = "c1ccccc1"):
    # Define benzene SMILES
#    smiles = "c1ccccc1"
    # Generate RDKit molecule object from SMILES
    mol = Chem.MolFromSmiles(smiles)
# Add explicit hydrogens
    mol = Chem.AddHs(mol)

    # Generate 3D coordinates
    AllChem.Compute2DCoords(mol)  # Compute 2D coordinates first
    AllChem.EmbedMolecule(mol, randomSeed=42)  # Embed 3D coordinates

    # Print the 3D coordinates
    for atom in mol.GetAtoms():
        pos = mol.GetConformer().GetAtomPosition(atom.GetIdx())
        print('Atom {atom.GetIdx() + 1}: {pos.x}, {pos.y}, {pos.z}')

    # Visualize the molecule
#o    draw_pyscf_molecule(mol)
        mol.AddHs()
        conv = ob.OBConversion()
        conv.WriteFile(mol)
    global useminEnergy
    ok = writexyz(mol,minimize=useminEnergy)
    return mol

def minenergy(mol,conformer_i):
    forcefield = AllChem.UFFGetMoleculeForceField  # UFF
    # forcefield = AllChem.MMFFGetMoleculeForceField  # MMFF94 or MMFF94s
    ff = forcefield(mol, confId=conformer_i.GetId())
    ff.Initialize()  # Initialize force field
    # energie1 = forcefield(mol, confId=conformer_i.GetId()).CalcEnergy()
    ff.Minimize()  # Minimize energy

    # Get energies of minimized conformers
    energie = forcefield(mol, confId=conformer_i.GetId()).CalcEnergy()
    return energie

def get_all_geometry(gaussian_output_file, xyz_output_file):
    with open(gaussian_output_file, 'r') as infile:
        lines = infile.readlines()
    Loptimized_coords=[]
    optimized_coords = []
    Latom_count =[]
    atom_count = 0
    reading_geometry = False

    for line in lines:
        if "Standard orientation" in line:
            reading_geometry = True
            count_= 0
            continue
        if reading_geometry:
            if "---" in line:  # End of geometry section
                count_=count_+1
                if count_==3 :  
                    Loptimized_coords.append(optimized_coords)
                    optimized_coords=[]
                    reading_geometry = False
                    Latom_count.append(atom_count)
                    atom_count=0
                    # break
            parts = line.split()
            if len(parts) >= 4 and (parts[0]!="Center") and (parts[0]!="Number") :
                atom_count += 1
                if atom_count > 2 :
                    atom_type = atomic_number_to_xyz_atom(int(parts[1]))
                else :
                    atom_type = parts[1]
                
                x = parts[3]
                y = parts[4]
                z = parts[5]
                optimized_coords.append(f"{atom_type} {x} {y} {z}")

    # Write to XYZ file
    for iter in range(len(Latom_count)):
        with open(str(iter)+xyz_output_file, 'w') as outfile:
            outfile.write(f"{Latom_count[iter]}\n")
            outfile.write("Optimized geometry from Gaussian\n")
            outfile.write("\n".join(Loptimized_coords[iter]) + "\n")



def get_optimized_geometry(gaussian_output_file, xyz_output_file):
    with open(gaussian_output_file, 'r') as infile:
        lines = infile.readlines()
    Loptimized_coords=[]
    optimized_coords = []
    Latom_count =[]
    atom_count = 0
    reading_geometry = False

    for line in lines:
        if "Standard orientation" in line:
            reading_geometry = True
            count_= 0
            continue
        if reading_geometry:
            if "---" in line:  # End of geometry section
                count_=count_+1
                if count_==3 :  
                    Loptimized_coords.append(optimized_coords)
                    optimized_coords=[]
                    reading_geometry = False
                    Latom_count.append(atom_count)
                    atom_count=0
                    # break
            parts = line.split()
            if len(parts) >= 4 and (parts[0]!="Center") and (parts[0]!="Number") :
                atom_count += 1
                if atom_count > 2 :
                    atom_type = atomic_number_to_xyz_atom(int(parts[1]))
                else :
                    atom_type = parts[1]
                
                x = parts[3]
                y = parts[4]
                z = parts[5]
                optimized_coords.append(f"{atom_type} {x} {y} {z}")

    # Write to XYZ file
    with open(xyz_output_file, 'w') as outfile:
        outfile.write(f"{Latom_count[-1]}\n")
        outfile.write("Optimized geometry from Gaussian\n")
        outfile.write("\n".join(Loptimized_coords[-1]) + "\n")

# Example usage
# extract_optimized_geometry('output.log', 'optimized_coordinates.xyz')

def validate_molecule(mol):
    try:
        Chem.SanitizeMol(mol)  # Sanitize the molecule to check for structural issues
        # if has_three_member_ringR(mol) :
        if is_improbable_moleculeR(mol) :             
            return False 
        return True
    except Exception as e:
        print("Molecule validation failed:", e)
        return False


def has_large_non_aromatic_ringR(mol, max_ring_size=8):
    """
    Checks if a molecule has any large non-aromatic rings (e.g., more than `max_ring_size` atoms).
    
    Parameters:
        mol (RDkir mol): the molecule.
        max_ring_size (int): The maximum size of a ring allowed.
        
    Returns:
        bool: True if the molecule has a large non-aromatic ring, False otherwise.
    """
    # mol = Chem.MolFromSmiles(smiles)
    if mol is None:
        raise ValueError("Invalid SMILES string")

    # Loop through each ring in the molecule
    for ring in mol.GetRingInfo().AtomRings():
        # Check if the ring size exceeds the allowed max size
        if len(ring) > max_ring_size:
            # Check if all atoms in the ring are non-aromatic
            if not all(mol.GetAtomWithIdx(idx).GetIsAromatic() for idx in ring):
                return True  # Large, non-aromatic ring found

    return False  # No large, non-aromatic rings found


def has_three_member_ringR(mol):
    """
    Checks if the molecule represented by a SMILES string contains any three-membered rings.
    
    Parameters:
        smiles (str): SMILES string of the molecule.
        
    Returns:
        bool: True if the molecule has a three-membered ring, False otherwise.
    """
    # mol = Chem.MolFromSmiles(smiles)
    if mol is None:
        raise ValueError("Invalid SMILES string")

    # Check ring sizes
    for ring in mol.GetRingInfo().AtomRings():
        if len(ring) == 3:
            return True  # Three-membered ring found

    return False  # No three-membered ring found

def has_three_member_ringS(smiles):
    """
    Checks if the molecule represented by a SMILES string contains any three-membered rings.
    
    Parameters:
        smiles (str): SMILES string of the molecule.
        
    Returns:
        bool: True if the molecule has a three-membered ring, False otherwise.
    """
    mol = Chem.MolFromSmiles(smiles)
    if mol is None:
        raise ValueError("Invalid SMILES string")

    # Check ring sizes
    for ring in mol.GetRingInfo().AtomRings():
        if len(ring) == 3:
            return True  # Three-membered ring found

    return False  # No three-membered ring found


def is_antiaromaticR(mol):
    """
    Checks if the molecule represented by a Rdkit mol contains any anti-aromatic rings.
    
    Parameters:
        mol (RDkit mol).
        
    Returns:
        bool: True if the molecule has anti-aromatic characteristics, False otherwise.
    """
    # mol = Chem.MolFromSmiles(smiles)
    if mol is None:
        raise ValueError("Invalid SMILES string")
    
    # Aromatic rings information
    aromatic_rings = [ring for ring in mol.GetRingInfo().AtomRings() if all(mol.GetAtomWithIdx(idx).GetIsAromatic() for idx in ring)]
    
    for ring in aromatic_rings:
        # Count π-electrons (2 electrons per double bond)
        pi_electrons = sum(2 for idx in ring if mol.GetAtomWithIdx(idx).GetIsAromatic())
        
        # Apply the 4n rule for anti-aromaticity
        if pi_electrons % 4 == 0:  # Indicates potential anti-aromaticity
            return True
    return False

def is_improbable_moleculeR(mol):
    """
    Checks if the molecule is improbable due to three-membered rings, anti-aromaticity, or valency issues.
    
    Parameters:
        mol (RDkit mol).
        
    Returns:
        bool: True if the molecule is improbable, False otherwise.
    """
    try:
        if check3rings : 
            if has_three_member_ringR(mol):
                return True
        if has_large_non_aromatic_ringR(mol):
            return True
        # if is_antiaromaticR(mol):
        #     return True
        
        # Additional RDKit checks (e.g., valency) can be applied here
        mol = Chem.MolFromSmiles(smiles)
        Chem.SanitizeMol(mol)  # Will raise an error for valency or other issues
    except:
        return True  # If there's any issue with sanitization, mark as improbable

    return False
    

def writexyz(mol, filen="ligand.xyz", numConfs=1, minimize=True, max_energy_threshold=1000):
    global useminGauss_only
    if useminGauss_only :
        if not validate_molecule(mol):
            print("Invalid molecule structure for Gaussian Input. Aborting minimization.")
            return False
        else :         
            return writexyzG(mol,filen=filen,useGmethod="AM1")
    nmaded = True
    ok = True
    min_energy = float('inf')  # To track the lowest energy
    conformer_selected = None
    failed = 0
    maxattempts=4
    # Validate the molecule structure before starting
    if not validate_molecule(mol):
        print("Invalid molecule structure. Aborting minimization.")
        return False

    # Try generating multiple conformers with attempts to find the best one
    for attempt in range(maxattempts):  # Allow up to 10 attempts
        try:
            conformers = AllChem.EmbedMultipleConfs(mol, numConfs=numConfs)            
            if not minimize:  
                AllChem.UFFOptimizeMolecule(mol)                                
            for conformer_id in range(numConfs):
                conformer = mol.GetConformer(conformer_id)

                if minimize:
                    # Try MMFF94 first, fallback to UFF if MMFF fails
                    try:
                        forcefield = AllChem.MMFFGetMoleculeForceField(mol, confId=conformer.GetId())
                    except:
                        print("MMFF failed, switching to UFF")
                        forcefield = AllChem.UFFGetMoleculeForceField(mol, confId=conformer.GetId())
                    
                    forcefield.Initialize()
                    forcefield.Minimize()

                    # Get the minimized energy
                    energy = forcefield.CalcEnergy()
                    print(f"Conformer {conformer_id}, Energy: {energy}")

                    # Keep track of the lowest energy conformer
                    if energy < min_energy:
                        min_energy = energy
                        conformer_selected = conformer
                

            if min_energy < max_energy_threshold or not minimize:
                nmaded = False
                if not minimize:                     
                    conformer_selected = conformer
                break
        except Exception as e:
            print("Conformer generation or minimization failed. Retrying...", e)
            failed+=1
            continue

    # If no valid conformer is found after several attempts, return False
    if (min_energy >= max_energy_threshold or conformer_selected is None) and  minimize:
        print("Failed to find a valid minimized conformation with acceptable energy.")
        return False
    if maxattempts==failed : 
        print("Failed to find a maxttempts ")
        return False
    # Add the best conformer to the molecule
    mol.AddConformer(conformer_selected)

    # Save the structure to XYZ format
    xyzmol = Chem.MolToXYZBlock(mol)
    with open(filen, 'w') as f:
        f.write(xyzmol)
    print(f"Minimized structure written to {filen} with energy {min_energy}")

    return True


def objfunc1(x2,x1):
    return x2-x1 

def writexyzG(mol,fileG="molecule.xyz",filen="ligand.xyz",useGmethod=None):
    if useGmethod == None :
        calculate_propertiesL5(mol,ligfn=filen[:-4],gaussian_options='#opt',saveonly=True)
    else :
        calculate_propertiesL5(mol,ligfn=filen[:-4],fileG=fileG,gaussian_options='#opt '+useGmethod,saveonly=True)

    return True

def writexyz1(mol,filen="ligand.xyz",numConfs=1,minimize=True):
#    Chem.rdmolfiles.MolToXYZFile(mol,filen)
    nmaded=True
    ok=True
    while nmaded :
        try :
            conformers = AllChem.EmbedMultipleConfs(mol, numConfs=numConfs)
            # AllChem.MMFFOptimizeMolecule(mol)
            conformer_i = mol.GetConformer(0)
            if minimize :
                energie =minenergy(mol,conformer_i) 
                print("Write conformaton ",numConfs,"Energy ",energie)
            else :
                print("Write conformaton ",numConfs)                    
            nmaded = False
        except :
            numConfs+=1
            if numConfs > 2 :
                nmaded = False
                ok =False
                print("Fails conformaton ")
                return ok
    mol.AddConformer(conformer_i)
    xyzmol= Chem.MolToXYZBlock(mol)
    # print(xyzmol)
    with open(filen, 'w') as f:
       f.write(xyzmol)
    f.close()
    return ok
    


def objfunc1(x2,x1):
    return x2-x1 

def calculate_propertiesL5(smiles, ligfn="molecule",fileG="molecule", gaussian_options='# opt b3lyp/cc-pVDZ freq', gaussian_path="/usr/bin/sg16", dirname=None,savexyz=True,saveonly=False,Spect=None,matr=1,gaussian_options2=""):
    ''' Calculate properties using Gaussian 16' or perform minimaziation'''
    print("\nC pro : ",smiles)
    deb_f.write("\nC pro : "+smiles)
    # unique_dir = str(abs(hash(smiles)))
    unique_dir = get_hash(smiles)
    
    if dirname is None:
        dirname = unique_dir
    
    if not os.path.exists(dirname):
        global useminGauss_only
        if not useminGauss_only : 
            os.makedirs(dirname)
    output_file=ligfn+".com"
    if not saveonly : os.chdir(dirname)
    itr=0
    while (itr < matr):
        itr+=1
        ok = smiles_to_gaussian_input(smiles=smiles,gaussian_options=gaussian_options,output_file=output_file,Spec=Spect,gaussian_options2=gaussian_options2)
        if not ok :
            os.chdir("..")
            shutil.rmtree(dirname)
            if useUV_Bond_order_beake : return [1000000000.,1000000000.]             
            return 1000000000.
        # Copy the protein file to the directory
        # shutil.copy(output_file, os.path.join(dirname, output_file))
            
        # Build the command with the correct argument structure
        command = [
            gaussian_path,
                ligfn
        ]    
        # if grid_center:
        #     command.extend(["--grid_center"] + [str(coord) for coord in grid_center])
        # Set up the environment variables for the subprocess

        # env = os.environ.copy()
        # if py2 is not None:
        #     env["AUTODOCKTOOLS_PY2_PATH"] = py2
        # if utils_path is not None:
        #     env["AUTODOCKTOOLS_UTILS_PATH"] = utils_path
        
        # Execute the command and capture the output
    
        # subprocess.call(command, env=env)
        subprocess.call(command)
        if False :
            try:
                proc = subprocess.Popen(command,stdout=subprocess.PIPE, stderr=subprocess.PIPE)
                proc.wait()
                (stdout, stderr) = proc.communicate()
                if proc.returncode != 0:
                        # Decode stderr from bytes to string for printing
                        print("Error occurred: " + stderr.decode())
                # else:
                #     print("Command output: " + stdout.decode())
            except subprocess.SubprocessError as e:
                # Catch subprocess-specific errors (e.g., problems starting the process)
                print(f"Subprocess error occurred: {e}")
            except Exception as e:
                # Catch other types of exceptions
                print(f"An unexpected error occurred: {e}")

    if saveonly :
        # get_optimized_geometry(ligfn+".log",ligfn+".xyz")
        get_optimized_geometry(ligfn+".log","ligand.xyz")
    # Change back to the original directory and remove the temporary directory
        # os.chdir("..")
        # shutil.rmtree(dirname)
        if useUV_Bond_order_beake : return [1000000000.,1000000000.]             
        return  100000000.
    # Change back to the original directory and remove the temporary directory
    else :
        # enthalpy, free_energy =  extract_thermodynamic_data(ligfn+".log")
        if Spect == None :
            res =  extract_thermodynamic_data(ligfn+".log")
            enthalpy=res["Enth"]
            free_energy=res["FRE"]
            deb_f.write("\nFree Energy of Binding "+smiles+" "+str( enthalpy) + " "+str( free_energy) )
            print("\n Enthalpy ", enthalpy)        
        else :
            UV_wavelengths , UV_oscillator_strengths=extract_uv_spectrum(ligfn+".log")
            deb_f.write("\n"+smiles)
            for iw in range(len(UV_wavelengths)):
                deb_f.write("\nWavelengths (nm): "+ str(UV_wavelengths[iw]))
                deb_f.write(" Oscillator strengths: "+ str(UV_oscillator_strengths[iw]))
            
    # exprtact IR 
        # [IR_frequencies,IR_intensities ]=res["IR"]
    # extract NMR 
        # chemical_shifts =res["NMR"]
        
        if savexyz :            
            get_optimized_geometry(ligfn+".log",ligfn+".xyz")
        os.chdir("..")
        shutil.rmtree(dirname)
        if Spect==None : 
            return enthalpy if enthalpy != float('inf') else None
        if Spect=="UV" :
            if  len(UV_wavelengths)>0 :
                max_wave,maxos = find_max_absorption(UV_wavelengths,UV_oscillator_strengths)
                return max_wave if max_wave != float('inf') else None
            else:
                if useUV_Bond_order_beake : return [1000000000.,1000000000.]                             
                return 100000000.    

        if Spect=="IR" : 
            max_wave,maxos = find_max_absorption(IR_frequencies,IR_intensities)
            return max_wave if max_wave != float('inf') else None
        if Spect=="NMR" : 
            max_wave,maxos = find_max_absorption(IR_frequencies,IR_intensities)
            return max_wave if max_wave != float('inf') else None
        


def calculate_propertiesL6(smiles, ligfn="molecule",fileG="molecule", gaussian_options='# opt b3lyp/cc-pVDZ freq', gaussian_path="/usr/bin/sg16", dirname=None,savexyz=True,saveonly=False,Spect=None,matr=1,gaussian_options2=""):
    ''' Calculate properties using Gaussian 16' or perform minimaziation'''
    print("\nC pro : ",smiles)
    deb_f.write("\nC pro : "+smiles)
    # unique_dir = str(abs(hash(smiles)))
    unique_dir = get_hash(smiles)
    
    if dirname is None:
        dirname = unique_dir
    
    if not os.path.exists(dirname):
        global useminGauss_only
        if not useminGauss_only : 
            os.makedirs(dirname)
    output_file=ligfn+".com"
    if not saveonly : os.chdir(dirname)
    itr=0
    while (itr < matr):
        itr+=1
        ok = smiles_to_gaussian_input(smiles=smiles,gaussian_options=gaussian_options,output_file=output_file,Spec=Spect,gaussian_options2=gaussian_options2)
        if not ok :
            os.chdir("..")
            shutil.rmtree(dirname)
            if useUV_Bond_order_beake : return [1000000000.,1000000000.]             
            return 1000000000.
        # Copy the protein file to the directory
        # shutil.copy(output_file, os.path.join(dirname, output_file))
            
        # Build the command with the correct argument structure
        command = [
            gaussian_path,
                ligfn
        ]    
        # if grid_center:
        #     command.extend(["--grid_center"] + [str(coord) for coord in grid_center])
        # Set up the environment variables for the subprocess

        # env = os.environ.copy()
        # if py2 is not None:
        #     env["AUTODOCKTOOLS_PY2_PATH"] = py2
        # if utils_path is not None:
        #     env["AUTODOCKTOOLS_UTILS_PATH"] = utils_path
        
        # Execute the command and capture the output
    
        # subprocess.call(command, env=env)
        subprocess.call(command)
    if saveonly :
        get_optimized_geometry(ligfn+".log","ligand.xyz")
    # Change back to the original directory and remove the temporary directory
        # os.chdir("..")
        # shutil.rmtree(dirname)
        if useUV_Bond_order_beake : return [1000000000.,1000000000.]                     
        return  100000000.
    # Change back to the original directory and remove the temporary directory
    else :
        # enthalpy, free_energy =  extract_thermodynamic_data(ligfn+".log")
        if Spect == None :
            res =  extract_thermodynamic_data(ligfn+".log")
            enthalpy=res["Enth"]
            free_energy=res["FRE"]
            deb_f.write("\nFree Energy of Binding "+smiles+" "+str( enthalpy) + " "+str( free_energy) )
            print("\n Enthalpy ", enthalpy)        
        else :
            UV_wavelengths , UV_oscillator_strengths=extract_uv_spectrum(ligfn+".log")
            deb_f.write("\n"+smiles)
            for iw in range(len(UV_wavelengths)):
                deb_f.write("\nWavelengths (nm): "+ str(UV_wavelengths[iw]))
                deb_f.write(" Oscillator strengths: "+ str(UV_oscillator_strengths[iw]))
            d_anti_occupancy = extract_bond_orders(ligfn+".log")                    
        if savexyz :            
            get_optimized_geometry(ligfn+".log",ligfn+".xyz")
        os.chdir("..")
        shutil.rmtree(dirname)
        if Spect==None : 
            return enthalpy if enthalpy != float('inf') else None
        if Spect=="UV" :
            if  len(UV_wavelengths)>0 :
                max_wave,maxos = find_max_absorption(UV_wavelengths,UV_oscillator_strengths)
                return [max_wave,d_anti_occupancy]if max_wave != float('inf') else None
            else:
                if useUV_Bond_order_beake : return [1000000000.,1000000000.]                             
                return 100000000.    



def calculate_propertiesL3(smiles, propT="G", protf="protein.xyz", ligf="ligand.xyz", grid_center=None, grid_size=None, grid_spacing=None, ad4_path=None, dirname=None, seed=None, n_poses=10, py2=None, utils_path=None, result_dlg="result_protein_ligand.dlg"):
    # Create a unique directory name based on the SMILES string using the built-in hash function
    print("\nC pro : ",smiles)
    deb_f.write("\nC pro : "+smiles)
    # unique_dir = str(abs(get_hash(smiles)))
    unique_dir = get_hash(smiles)
    
    if dirname is None:
        dirname = unique_dir
    
    if not os.path.exists(dirname):
        os.makedirs(dirname)
    
    # Copy the protein file to the directory
    shutil.copy(protf, os.path.join(dirname, protf))
    
    # Change to the directory
    os.chdir(dirname)

    mol = Chem.MolFromSmiles(smiles)
    mol = Chem.AddHs(mol)
    global useminEnergy
    ok = writexyz(mol, ligf,minimize=useminEnergy)
    if not ok:
        os.chdir("..")
        try :
            shutil.rmtree(dirname)
        except:
            pass
        if useUV_Bond_order_beake : return [1000000000.,1000000000.]             
        return 10000000000.
    
    # Build the command with the correct argument structure
    command = [
        ad4_path,
        "--protein", protf,
        "--ligand", ligf
    ]
    
    if grid_center:
        command.extend(["--grid_center"] + [str(coord) for coord in grid_center])
    
    if grid_size:
        # Assume grid_size can be either a single number or three numbers
        if isinstance(grid_size, (list, tuple)):
            command.extend(["--gridsize"] + [str(size) for size in grid_size])
        else:
            command.extend(["--gridsize", str(grid_size)])

    if grid_spacing is not None:
        command.extend(["--gridspacing"] + [str(grid_spacing)])

    if seed is not None:
        command.extend(["--seed", str(seed[0]), str(seed[1])])
    
    command.extend(["--n_poses", str(n_poses)])
    # Set up the environment variables for the subprocess
    env = os.environ.copy()
    if py2 is not None:
        env["AUTODOCKTOOLS_PY2_PATH"] = py2
    if utils_path is not None:
        env["AUTODOCKTOOLS_UTILS_PATH"] = utils_path
    
    # Execute the command and capture the output
    subprocess.call(command, env=env)
    # try:
    #     # Run the command with the modified environment
    #     proc = subprocess.Popen(command, stdout=subprocess.PIPE, stderr=subprocess.PIPE, env=env)
    #     proc.wait()
    #     stdout, stderr = proc.communicate()
    #     if proc.returncode != 0:
    #         print("Error occurred: " + stderr.decode())
    #     # else:
    #     #     print("Command output: " + stdout.decode())
    # except subprocess.SubprocessError as e:
    #     print(f"Subprocess error occurred: {e}")
    # except Exception as e:
    #     print(f"An unexpected error occurred: {e}")
    
    E_Free_Energy = float('inf')
    with open(result_dlg, 'r') as file:
        lines = file.readlines()
        # Find the summary section
        in_summary_section = False
        for line in lines:
            if "Clus | Lowest    | Run | Mean      | Num | Histogram" in line:
                in_summary_section = True
                continue

            if in_summary_section:
                if line.strip() == "":
                    break  # End of summary section
                # Parse the binding energy from the summary
                parts = line.split('|')
                if len(parts) > 1:
                    try:
                        energy = float(parts[1].strip())
                        if energy < E_Free_Energy:
                            E_Free_Energy = energy
                    except ValueError:
                        pass
    deb_f.write("\nFree Energy of Binding "+smiles+" "+str( E_Free_Energy))
    print("\nFree Energy of Binding", E_Free_Energy)
    
    # Change back to the original directory and remove the temporary directory
    os.chdir("..")
    shutil.rmtree(dirname)
    
    return E_Free_Energy if E_Free_Energy != float('inf') else None

def calculate_propertiesL4(smiles, propT="G", protf="protein.xyz", ligf="ligand.xyz", grid_center=None, grid_size=None, grid_spacing=None, vina_path=None, dirname=None, seed=None, n_poses=9, py2=None, utils_path=None):
    is_single, fragments = identify_fragments(smiles)
    if is_single:
        pass
    else:
        print(f"The SMILES '{smiles}' represents multiple fragments: {fragments}")
        if fragments ==[]: 
            if useUV_Bond_order_beake : return [1000000000.,1000000000.]             
            return 10000000000.
        else :
            smiles=random.choice(fragments)
    
    # Create a unique directory name based on the SMILES string using the built-in hash function
    # unique_dir = str(abs(hash(smiles)))
    unique_dir = get_hash(smiles)
    
    
    if dirname is None:
        dirname = unique_dir
    
    if not os.path.exists(dirname):
        os.makedirs(dirname)
    
    # Copy the protein file to the directory
    shutil.copy(protf, os.path.join(dirname, protf))
    
    # Change to the directory
    os.chdir(dirname)

    mol = Chem.MolFromSmiles(smiles)
    mol = Chem.AddHs(mol)
    global useminEnergy
    global useminGauss_only
    if useminGauss_only : 
        if not validate_molecule(mol):
            print("Invalid molecule structure for Gaussian Input. Aborting minimization.")
            ok= False
        else :
            ok= writexyzG(smiles,fileG="molecule.xyz",filen=ligf,useGmethod="AM1")
    else :
        ok = writexyz(mol, ligf,minimize=useminEnergy)
    if not ok:
        os.chdir("..")
        try : 
            shutil.rmtree(dirname)
        except: 
            pass
        if useUV_Bond_order_beake : return [1000000000.,1000000000.]                     
        return 10000000000.
    
    # Build the command with the correct argument structure
    command = [
        vina_path,
        "--protein", protf,
        "--ligand", ligf
    ]
    
    if grid_center:
        command.extend(["--grid_center"] + [str(coord) for coord in grid_center])
    
    if grid_size:
        command.extend(["--gridsize"] + [str(size) for size in grid_size])
    
    if grid_spacing is not None:
        command.extend(["--gridspacing", str(grid_spacing)])
    
    if seed is not None:
        command.extend(["--seed", str(seed)])
    
    command.extend(["--n_poses", str(n_poses)])
    
    # Set up the environment variables for the subprocess
    env = os.environ.copy()
    if py2 is not None:
        env["AUTODOCKTOOLS_PY2_PATH"] = py2
    if utils_path is not None:
        env["AUTODOCKTOOLS_UTILS_PATH"] = utils_path
    # babel_libdir  = obGetPluginPath()
    # os.environ["BABEL_LIBDIR"] = babel_libdir
    
    # Execute the command and capture the output
    # madeit= subprocess.call(command, env=env)
    # if madeit != 0 :        
    #     print("FAILD IN ",smiles)
    try:
        # Run the command with the modified environment
        proc = subprocess.Popen(command, stdout=subprocess.PIPE, stderr=subprocess.PIPE, env=env)
        proc.wait()
        stdout, stderr = proc.communicate()
        if proc.returncode != 0:
            print("Error occurred: " + stderr.decode())
        # else:
        #     print("Command output: " + stdout.decode())
    except subprocess.SubprocessError as e:
        print(f"Subprocess error occurred: {e}")
    except Exception as e:
        print(f"An unexpected error occurred: {e}")
         
    E_Free_Energy = float('inf')
    model_found = False
    with open("output.pdbqt", 'r') as file:
        lines = file.readlines()
        for line in lines:
            if line.strip().startswith("MODEL 1"):
                model_found = True
            if model_found and line.strip().startswith("REMARK VINA RESULT:"):
                parts = line.split()
                try:
                    energy = float(parts[3])
                    if energy < E_Free_Energy:
                        E_Free_Energy = energy
                    break  # Stop after reading the energy for MODEL 1
                except ValueError:
                    pass

    print("\n1Free Energy of Binding", E_Free_Energy)
    deb_f.write("\nFree Energy of Binding "+smiles+" "+str( E_Free_Energy))
    
    # Change back to the original directory and remove the temporary directory
    # shutil.copy("output.pdbqt", "../"+unique_dir+".pdbqt")
    try :
        shutil.copy("pose_1.xyz", "../"+unique_dir+".xyz")
    except :
        pass
    
    os.chdir("..")
    shutil.rmtree(dirname)
    return E_Free_Energy if E_Free_Energy != float('inf') else None


def calculate_propertiesL(smiles,propT="LogP"):
    # Create a molecule object from SMILES
    mol = Chem.MolFromSmiles(smiles)
    if mol is None:
        return "Invalid SMILES"
    # Calculate properties
    mw = Descriptors.MolWt(mol)
    logp = Descriptors.MolLogP(mol)
    hbd = Lipinski.NumHDonors(mol)
    hba = Lipinski.NumHAcceptors(mol)
    violations = Lipinski.NumHAcceptors(mol)
    # Check Lipinski's Rule of 5
    rule_of_5_pass = all([
        mw <= 500,
        logp <= 5,
        hbd <= 5,
        hba <= 10
    ])
    result = {
        "MolecularWeight": mw,
        "LogP": logp,
        "NumHDonors": hbd,
        "NumHAcceptors": hba,
        "LipinskiRuleOf5": rule_of_5_pass,
        "NumViolations": violations
    }
    return result[propT]

def calculate_propertiesL2(smiles,propT="MolecularWeight"):
    # Create a molecule object from SMILES
    mol = Chem.MolFromSmiles(smiles)
    if mol is None:
        return "Invalid SMILES"
    # Calculate properties
    mw = Descriptors.MolWt(mol)
    logp = Descriptors.MolLogP(mol)
    hbd = Lipinski.NumHDonors(mol)
    hba = Lipinski.NumHAcceptors(mol)
    violations = Lipinski.NumHAcceptors(mol)
    # Check Lipinski's Rule of 5
    rule_of_5_pass = all([
        mw <= 500,
        logp <= 5,
        hbd <= 5,
        hba <= 10
    ])
    result = {
        "MolecularWeight": mw,
        "LogP": logp,
        "NumHDonors": hbd,
        "NumHAcceptors": hba,
        "LipinskiRuleOf5": rule_of_5_pass,
        "NumViolations": violations
    }
    return result[propT]

def myheuristic(a, b,Bias):
    # (x1, y1) =Bias[a]
    # (x2, y2) =Bias[b]
    # return abs(x1 - x2) + abs(y1 - y2)
    return 0

def drawpath(path, fechiupac=False, label_filename="labels.txt"):
    figmols = []
    legim = []

    for ismiles in path:
        # Use MolpherMol to process the input SMILES
        mol = MolpherMol(ismiles)
        figmols.append(mol.asRDMol())  # Convert to RDKit Mol object for drawing

        if fechiupac:
            try:
                upacna = iupacname(ismiles)
            except:
                upacna = ismiles
        else:
            upacna = ismiles

        # Append the original isomeric SMILES or IUPAC name
        legim.append(ismiles if not fechiupac else upacna)

    molsPerRow = 4
    img = Chem.Draw.MolsToGridImage(figmols, molsPerRow=molsPerRow, subImgSize=(200, 200), returnPNG=False)

    try:
        img_width, img_height = img.size
        legend_height = len(legim) * 20  # Adjust the total height for all labels
        total_height = img_height + legend_height  # Total height including space for legends

        # Create a new image with extra space for the legends at the bottom
        new_img = Image.new("RGB", (img_width, total_height), "white")
        new_img.paste(img, (0, 0))  # Paste the original image at the top

        # Create a drawing context for the new image
        draw = ImageDraw.Draw(new_img)

        # Load the font for the numbers and legends
        font = ImageFont.load_default()

        # Add numbers above each molecule in the grid
        for i in range(len(figmols)):
            x = (i % molsPerRow) * 200 + 10  # Adjust x position based on grid
            y = (i // molsPerRow) * 200 + 10  # Adjust y position above the molecule
            draw.text((x, y), str(i + 1), fill="black", font=font)  # Draw the number above each molecule

    except Exception as e:
        print("Error during image creation or drawing context:", e)
        pass

    # Save the labels to a text file
    try:
        with open(label_filename, "w") as label_file:
            for i, legend_text in enumerate(legim):
                label_file.write(f"{i + 1}: {legend_text}\n")
    except Exception as e:
        print("Error during label file writing:", e)
        pass

    try:
        # Position the legends at the bottom left
        legend_y_start = img_height + 10  # Start just below the molecule grid
        legend_x_start = 10  # Start on the left

        # Add legends to the new image, ensuring enough space
        for i, legend_text in enumerate(legim):
            y = legend_y_start + i * 20  # Adjust y position for each label
            draw.text((legend_x_start, y), f"{i + 1}: {legend_text}", fill="black", font=font)

    except Exception as e:
        print("Error during text drawing:", e)
        pass

    # Save the final image with the legends
    try:
        new_img.save("outputmol.png")
        plt.figure()
        plt.imshow(new_img)
        plt.axis('off')  # Turn off axis
        # plt.show()
    except Exception as e:
        print("Error during image saving:", e)

def drawpath1(path,fechiupac=False):
    figmols=[]
    legim=[]
    for ismiles in path :    
        mol = MolpherMol(ismiles)
        figmols.append(mol.asRDMol())
        if fechiupac :
            try :
                upacna = iupacname(ismiles)
            except :
                upacna = ismiles
        else : upacna = ismiles
        legim.append(upacna)
    molsPerRow=4
    img = Chem.Draw.MolsToGridImage(figmols, molsPerRow=molsPerRow, subImgSize=(200, 200),returnPNG=False)
    img.save("outputmol.png")
# Create a drawing context
    try :
       draw = ImageDraw.Draw(img)
    except :
       pass

# Define the font for the legend text
    font = ImageFont.load_default()  # You can also specify a custom font if needed

# Add legends to the image
    for i, legend_text in enumerate(legim):
        x = (i % molsPerRow) * 200  # Adjust the position based on the grid layout
        y = (i // molsPerRow) * 200  # Adjust the position based on the grid layout
        draw.text((x, y), legend_text, fill="black", font=font)

    # Display the image
    try :
       img.show()

    
       plt.figure()
       plt.imshow(img)
       plt.axis('off')  # Turn off axis
       if showPLOTS: plt.show()
    except :
       pass

def extract_uv_spectrum(filename):
    wavelengths = []
    oscillator_strengths = []
    
    # Regex patterns to match the required lines in the Gaussian output
    excited_state_pattern = re.compile(r"Excited State\s+\d+:\s+\S+\s+([0-9.]+) eV\s+([0-9.]+) nm\s+f=([0-9.]+)")
    energy_iteration_pattern = re.compile(r"Total Energy, E\(TD-HF/TD-DFT\)")
    try :
        with open(filename, 'r') as file:
            lines = file.readlines()
    except :
        return [10000000.], [1.]    

    # Track sections of excited states and capture the last occurrence
    last_excited_states = []
    capture = False
    okend = False
    for line in lines:
        # Start capturing when we reach a new "Total Energy, E(TD-HF/TD-DFT)" line (new iteration)
        if "Normal termination of Gaussian" in line:
            okend = True                
            # Check for segmentation fault
        if "segmentation violation" in line.lower() or "segmentation fault" in line.lower():
            return [10000000.], [1.]    

            # Check for other errors
        if "Error termination" in line:
            return [10000000.], [1.]    

        if energy_iteration_pattern.search(line):
            last_excited_states = []
            capture = True

        # Capture excited states until a new iteration starts
        if capture:
            match = excited_state_pattern.search(line)
            if match:
                energy_ev = float(match.group(1))
                wavelength_nm = float(match.group(2))
                oscillator_strength = float(match.group(3))
                last_excited_states.append((wavelength_nm, oscillator_strength))

    # Unpack the last set of excited states for plotting
    wavelengths = [state[0] for state in last_excited_states]
    oscillator_strengths = [state[1] for state in last_excited_states]

    return wavelengths, oscillator_strengths

def extract_thermodynamic_data(log_file):
    '''Extract information from Gaussian output  '''

    enthalpy = None
    free_energy = None
    
    #extract UV-Vis data:
    # exprtact IR 
    IR_frequencies = []
    IR_intensities = []
    # extract NMR 
    chemical_shifts = []
    
    # Open the Gaussian log file and read the lines
    with open(log_file, 'r') as file:
        for line in file:
            # Check for the enthalpy line
            if 'Sum of electronic and thermal Enthalpies' in line:
                enthalpy = float(line.split()[-1])
            
            # Check for the free energy line
            if 'Sum of electronic and thermal Free Energies' in line:
                free_energy = float(line.split()[-1])
            
                # extract IR 
                if "Frequencies" in line:
                    freqs = [float(f) for f in line.split()[2:]]
                    IR_frequencies.extend(freqs)
                if "IR Inten" in line:
                    intens = [float(i) for i in line.split()[2:]]
                    IR_intensities.extend(intens)
                # extract NMR 
                if "Isotropic" in line:
                    shifts = [float(s) for s in line.split()[2:]]
                    chemical_shifts.extend(shifts)    

    res={}
    # Display the results
    if enthalpy is not None:
        print(f"Enthalpy (thermal correction): {enthalpy} Hartree")
        res["Enth"]=627.509474*enthalpy
    else:
        res["Enth"]=None
        print("Enthalpy not found in the log file.")

    if free_energy is not None:
        print(f"Free Energy (thermal correction): {free_energy} Hartree")
        res["FRE"]=627.509474*free_energy
    else:
        print("Free energy not found in the log file.")
        res["FRE"]=None
    # exprtact IR 
    res["IR"]= [IR_frequencies,IR_intensities ]
    # extract NMR 
    res["NMR"]= chemical_shifts     

    return res # 627.509474*enthalpy , 627.509474*free_energy

# Example usage
    
def smiles_to_gaussian_input(smiles, gaussian_options='# opt b3lyp/cc-pVDZ freq', output_file='molecule.com',Spec=None,gaussian_options2=""):
    # Step 1: Convert SMILES to 3D coordinates using RDKit
    mol = Chem.MolFromSmiles(smiles)
    mol = Chem.AddHs(mol)  # Add hydrogens to the molecule
    if not validate_molecule(mol):
        print("not validate_molecule")
        return False
    itra = 0
    notmadeit = True  
    # AllChem.EmbedMolecule(mol,randomSeed=-1)  # Generate 3D coordinates
    while notmadeit and itra < 5 : 
        try : 
            AllChem.EmbedMolecule(mol,randomSeed=1243)  # Generate 3D coordinates
            AllChem.UFFOptimizeMolecule(mol)  # Optimize the 3D geometry
            itra = itra +1
            notmadeit = False
        except :
            print ("FAILED buid molecule")
            return False
    # Step 2: Convert RDKit molecule to Open Babel format
    obConversion = ob.OBConversion()
    # obConversion.SetInAndOutFormats("mol", "zmat")  # Intermediate conversion to XYZ format
    obConversion.SetInAndOutFormats("mol", "xyz")  # Intermediate conversion to XYZ format


    obMol = ob.OBMol()
    obConversion.ReadString(obMol, Chem.MolToMolBlock(mol))
    blockf=Chem.MolToMolBlock(mol)
    # Step 3: Write the Gaussian input file with options
    with open(output_file, 'w') as f:
        # Write Gaussian options to the first line
        if Spec !=None :
            if gaussian_options2 !="" :
                f.write("%chk=combined.chk\n")
            f.write("%NProcShared=4\n")
            f.write("%Mem=8GB\n")
        f.write(f"{gaussian_options}\n\n")
        f.write("Title Section\n")

        # f.write(f"{gaussian_options}\n\n")
        # f.write("Title Section\n\n")
        # f.write("0 1\n")  # Assuming a neutral molecule with a singlet spin state

        # Convert Open Babel molecule to XYZ format and write atomic coordinates
        xyz_conversion = ob.OBConversion()
        # xyz_conversion.SetOutFormat("xyz")
        xyz_conversion.SetOutFormat("gzmat")
        xyz_string = xyz_conversion.WriteString(obMol)

        # Write the atomic coordinates to the Gaussian file
        xyz_lines = xyz_string.strip().splitlines()[4:]  # Skip the first two XYZ header lines
        for line in xyz_lines:
            f.write(line + "\n")
        f.write("\n")
        if gaussian_options2 !="" :
            f.write(gaussian_options2)
    print(f"Gaussian input file saved as {output_file}")
    return True   
    
def add_edges_from_dict(graph, edges_dict,color_edges):
    for source, neighbors in edges_dict.items():
        for target, weight in neighbors.items():
            if not graph.has_node(source) :
                graph.add_node(source)
            if not graph.has_node(target):
                graph.add_node(target)
            if not graph.has_edge(source, target):
                graph.add_edge(source, target, weight=weight,color=color_edges)


# Save the state of the random number generator to a file
def save_random_state(filename):
    with open(filename, 'wb') as f:
        state = random.getstate()
        pickle.dump(state, f)

# Load the state of the random number generator from a file
def load_random_state(filename):
    with open(filename, 'rb') as f:
        state = pickle.load(f)
        random.setstate(state)

def save_obj(filename,obj):
    with open(filename, 'wb') as f:
        pickle.dump(obj, f)

def load_obj(filename):
    with open(filename, 'rb') as f:
        obj = pickle.load(f)
    return obj

# using "https://cactus.nci.nih.gov/chemical/structure/{0}/iupac_name"

def iupacname(smiles):
    response = requests.get("https://cactus.nci.nih.gov/chemical/structure/{0}/iupac_name".format(smiles))
    response.raise_for_status()
    return response.text

        
heuristic=myheuristic

class ChemSampling:
    def __init__(self,mol="O=C(O)[C@H]1N(C(=O)[C@H](C)CS)CCC1",makeplot = True,Xtarget=None,comm=[]) :
        if mpiuse :
            if comm ==[] :
                self.comm = MPI.COMM_WORLD
            else :
                self.comm = comm
            self.size = self.comm.Get_size()
            self.irank = self.comm.Get_rank()
            self.fcomm=MPI.COMM_WORLD.py2f()
            global deb_f 
            deb_f.close()
            deb_f = open("debugF"+str(self.irank)+".txt", "w")


        self.initmol=mol        
        self.mol=mol        
        self.makeplot = makeplot
        self.Xtarget =  Xtarget
        if Xtarget == None :
            self.objfunc=objfunc1
        else :
            self.objfunc=self.objfunc2
        self.accure =1e-3 
        self.smiles_list = [
        'c1ccccc1',     # Benzolio
        'CCO',          # Ethanol
        'CC(=O)O',      # Acetic acid
        'CC(C)N',       # N,N-Dimethylamine
        'CCNC',         # Methylamine
        'CCOC',         # Dimethyl ether
        'CC#N',         # Acetonitrile
        'CCOC(=O)C',    # Methyl acetate
        'O',            # Water
        'N',            # Ammonia
        'Nc1ncnc2c1ncn2C1OC(COP(=O)(O)OP(=O)(O)OP(=O)(O)O)C(O)C1O',  # ATP
        'Nc1ncnc2c1ncn2C1OC(COP(=O)(O)OP(=O)(O)O)C(O)C1O',            # ADP
        'OP(=O)(O)O',   # Phosphoric acid
        'N(=O)(=O)O',   # Nitric acid
        'CC(=O)C',      # Acetone
        'C=O'           # Formaldehyde
        ]
    
    def makemolpher(self,mol,attem=1):
        self.molpher = Molpher(mol, [AddAtom(), RemoveAtom(), MutateAtom(), AddBond()
                , RemoveBond()
                , ContractBond()
                , InterlayAtom()
                , RerouteBond()
        ] 
            , attempts = attem
            , threads = 2
        )    
        return self.molpher

    def run_Molpher(self,Smol,nnaib,probmove=[0.,0.]):
        # Run the problematic code here using the input_value
        selm = random.random()
        if selm < probmove[0] :
            mol = MolpherMol(Smol)
            Sfrag = random.choice(self.smiles_list)
            frag = Chem.MolFromSmiles(Sfrag)
            # isel = random.choice(range(len(mol.atoms)))
            # add_frag = AddFragment(frag,[isel+1], "Add Fragment "+Sfrag)
            add_frag = AddFragment(frag,[1], "Add Fragment "+Sfrag)
            add_frag.setOriginal(mol)
            Smol = mol.smiles
            nnaib=nnaib-1
            returnlist=[add_frag.morph()]
        else: 
            if selm < probmove[1] :
                mol = MolpherMol(Smol)
                Rmol = Chem.MolFromSmiles(Smol)
                # isel = random.choice(range(len(mol.atoms)))
                # add_frag = AddFragment(frag,[isel+1], "Add Fragment "+Sfrag)
                onbits = {}
                mf = AllChem.GetMorganFingerprintAsBitVect(Rmol, 3, nBits=2048, bitInfo=onbits)
                all_fragments = [(Rmol, x, onbits) for x in mf.GetOnBits()]
                add_frag = DelFragment( onbits, "delete Fragment ")
                add_frag.setOriginal(mol)
                nnaib=nnaib-1
                returnlist=add_frag.morph()
            else :
                returnlist=[]
            if nnaib>0 :
                molpher = self.makemolpher(MolpherMol(Smol), attem = nnaib)
                molpher() 
                returnlist.extend(molpher.morphs)      
            return returnlist
    
    def method_to_run_in_process(self,Smol,nnaib,result_queue):
        morphs=self.run_Molpher(Smol,nnaib)
        pickled_result = pickle.dumps([im.smiles for im in  morphs])
        result_queue.put(pickled_result)
        
    def find_new(self,Smol,nnaib=1):
        maxitr=10
        itr =0
        founds=0
        while founds ==0 and itr < maxitr:
            # molpher = self.makemolpher(MolpherMol(Smol), attem = nnaib)
            notuse_queues = True
            if notuse_queues :
                try :
                    Mmorphs=self.run_Molpher(Smol,nnaib)
                    morphs= [im.smiles for im in  Mmorphs]
                    founds = len(morphs)
                except:
                    print("The process did not produce any result.",itr)
                    result = None
                    founds =0
                    itr=itr+1
                    morphs=None                        
            else :                
                result_queue = multiprocessing.Queue()
                process = multiprocessing.Process(target=self.method_to_run_in_process, args=(Smol,nnaib, result_queue,))
                process.start()
                process.join()  # Wait for the process to finish
                if process.is_alive():
                    print("The process is still running. Terminating...")
                    process.terminate()
                else:
            # Process has finished
                    if not result_queue.empty():
                        pickled_result = result_queue.get()
                        result = pickle.loads(pickled_result)
                        morphs= result
                        founds = len(morphs)
                        # Now, continue with the result or handle the failure as needed
                    else:
                        print("The process did not produce any result.",itr)
                        result = None
                        founds =0
                        itr=itr+1
                        morphs=None                        
                # molpher()
                # morphs = molpher.morphs
        unique_union=list(set(morphs))
        if usepHprot and not usetautom : 
            for ismiles in morphs:
                Lsmiles=sample_pH(ismiles)
                unique_union = set(unique_union) | set(Lsmiles)
            morphs= list(unique_union)
        if usetautom and not usepHprot: 
            for ismiles in morphs:
                Lsmiles=tautomers(ismiles)
                unique_union = set(unique_union) | set(Lsmiles)
            if nnaib < len(unique_union):
                morphs= [im.smiles for im in  Mmorphs]
                iter = 0
                while (len(morphs) < min(2*nnaib,len(unique_union) )and iter < 2*nnaib) :
                    iter=iter+1
                    tmol = random.choice(list(unique_union))
                    if tmol not in morphs : 
                        morphs.append(tmol)
                    else :
                        iter=iter+1

            # morphs= list(unique_union)
        if usetautom and  usepHprot: 
            for ismiles in morphs:
                Lsmiles=stan_then_pH(ismiles)
                unique_union = set(unique_union) | set(Lsmiles)
            if nnaib < len(unique_union):
                morphs= [im.smiles for im in  Mmorphs]
                iter = 0
                while (len(morphs) < min(2*nnaib,len(unique_union) )and iter < 2*nnaib) :
                    iter=iter+1
                    tmol = random.choice(list(unique_union))
                    if tmol not in morphs : 
                        morphs.append(tmol)
                    else :
                        iter=iter+1
        return morphs

    def mpicomuteprop(self,Smol):
        my_N = 1
        N = my_N * self.size
        if self.irank == 0:
            Lprop = np.zeros(N, dtype=np.float64)
        else:
            Lprop = np.empty(N, dtype=np.float64)
        prop=self.calculate_properties(Smol)
        self.comm.Gather([prop,MPI.DOUBLE], [Lprop, MPI.DOUBLE] )
        return sum(Lprop)

    def init_graph(self,mol,repet=1,nsteps = 0,nlearfs = 10,calculate_properties=calculate_propertiesL):
        maxitr=10
        self.graph={}
        self.graph.update({mol.smiles:{}})
        if  hasattr(self, 'node_prop') :
            if mol.smiles in self.node_prop.keys() : 
                self.node_prop={mol.smiles:self.node_prop[mol.smiles]}
            else :
                self.node_prop={}
        else :
                self.node_prop={}            
        self.calculate_properties=calculate_properties
        for irepit in range(repet):
            lear_tree=[]
            Smol=mol.smiles
            if Smol in S_node_prop.keys():
                prop=S_node_prop[Smol]
            else :
                if self.irank==0 :
                    prop=self.calculate_properties(Smol)
                else :
                    if type(self.Xtarget) ==type([]):
                        prop =[]
                        for it in range(len(self.Xtarget)) :
                            prop.append( 100000000000. ) #  one has to call the calculate_properties in defferent dir to activet the option to perrom additional calculations from the rest of the prosesors.                  
                    else :
                        prop = 100000000000.  #  one has to call the calculate_properties in defferent dir to activet the option to perrom additional calculations from the rest of the prosesors.                  
            if mpiuse  :    
                D_prop={Smol:prop}
                all_dicts = comm.allgather(D_prop)
                D_prop = {}
                for d in all_dicts:
                    D_prop.update(d)
                for d in D_prop:                            
                    prop2=D_prop[d]
                    prop=min(prop,prop2)                

            self.node_prop.update({Smol:prop})
            for itray in range(nsteps):
                itr =0
                founds=0                
                while founds ==0 and itr < maxitr:
                    result_queue = multiprocessing.Queue()
                    process = multiprocessing.Process(target=self.method_to_run_in_process, args=(Smol,nlearfs, result_queue,))
                    process.start()
                    process.join()  # Wait for the process to finish
                    if process.is_alive():
                        print("The process is still running. Terminating...")
                        process.terminate()
                    else:
                # Process has finished
                        if not result_queue.empty():
                            pickled_result = result_queue.get()
                            result = pickle.loads(pickled_result)
                            morphs= result
                            founds = len(morphs)
                            # Now, continue with the result or handle the failure as needed
                        else:
                            print("The process did not produce any result.",itr)
                            result = None
                            founds =0
                            itr=itr+1
                            morphs=None                        
                    # molpher = self.makemolpher(mol, attem = nlearfs)
                    # molpher()
                    # morphs = molpher.morphs
                founds = len(morphs)                
                for imorf in morphs  :
                    prop2=self.calculate_properties(imorf)
                    objf = self.objfunc(prop2,prop)
                    self.graph[mol.smiles].update({imorf:objf})
                    self.node_prop.update({imorf:prop2})
                    # self.graph[mol.smiles].update({imorf:prop2[propT]-prop[propT]})
                    if imorf not in self.graph.keys():  
                        self.graph[imorf]={}     
                lear_tree.append([imorf for imorf in morphs])
                mol = MolpherMol(random.choice(morphs))
                # mol.asRDMol()
                print(mol.smiles)
                # print(self.calculate_properties(mol.smiles))
        return self.graph

    def makeGplot(self,dicorder,path,goal):
        self.G = nx.DiGraph()
        self.edge_labels = {}
        self.node_label={}

        for node in self.graph:
            self.G.add_node(node)
            self.node_colors[node] ='red'
            try :
#                node_label[node]=str(float("%.3f" %  self.calculate_properties(node) ))+": "+str(dicorder[node] )
                self.node_label[node]=str(float("%.3f" %  self.node_prop[node] ))+": "+str(dicorder[node][-1] )
            except :
                self.node_label[node]="Failed"

        self.node_colors[goal] = 'green'
        self.node_colors[path[0]] = 'gray'

        add_edges_from_dict(self.G,self.graph,color_edges="blue")                 

        for ist in range(1,len(path)):
            try :
                w = self.graph[path[ist-1]][path[ist]]
                self.G.add_edge(path[ist-1], path[ist], weight=w,color="red")
                self.edge_labels[(path[ist-1], path[ist])] = float("%.3f" %self.graph[path[ist-1]][path[ist]])
            except :
                pass
            # node_colors[neighbor] = 'orange'
        # self.edge_colors = [self.G[u][v]['color'] for u, v in self.G.edges()]
        try :
            self.Draw_G()
        except :
            pass

    def Draw_G(self,G=None,edge_colors=None,node_label=None,node_colors=None,edge_labels=None):
        if G==None: 
            G=self.G
            self.edge_colors = [self.G[u][v]['color'] for u, v in self.G.edges()]
            node_label=self.node_label
            node_colors=self.node_colors
            edge_labels=self.edge_labels
        else :
            self.edge_colors=edge_colors
            self.node_label=node_label

        # Create graph visualization
        # pos = nx.spring_layout(self.G)
        pos = nx.planar_layout(G)
        # pos = nx.kamada_kawai_layout(self.G)
        # pos = nx.spectral_layout(self.G)
        # pos = nx.fruchterman_reingold_layout(self.G)
        nx.draw(G, pos, with_labels=False, edge_color=self.edge_colors, arrows=True)
        nx.draw_networkx_nodes(G, pos, node_color=node_colors.values())
        # nx.draw_networkx_edges(self.G, pos, edge_color=self.edge_colors)
        nx.draw_networkx_edge_labels(G, pos, edge_labels=edge_labels)
        nx.draw_networkx_labels(G, pos,labels=node_label)
        try :
           if showPLOTS:plt.show()
           plt.savefig("graph.png")
        except :
           pass 
#          plt.savefig("graph.png")
        
    def make_astar_NetX(self,nnaib=2,maxsteps=10):
        # self.G = nx.DiGraph()
        self.edge_labels = {}        
        self.node_colors = {}
        # node_label={}
        Bias=[]
        start=self.initmol.smiles
        goal = None 
        istep=0
        frontier = PriorityQueue()
        frontier.put((0,start))
        dicpriority={}
        dicpriority[start]=[0]
        came_from = {}
        cost_so_far = {}
        came_from[start] = None
        cost_so_far[start] = 0
        self.node_colors[start]='blue'
        dicorder={}
        order=0
        dicorder[start]=[order]
        while not frontier.empty():
            prio,current = frontier.get()
            print(current)
            istep+= 1
            if current == goal or istep > maxsteps :
                goal = min(cost_so_far, key=cost_so_far.get)
                self.node_colors[goal] = 'yellow'
                break
            if self.Xtarget!=None :
                if current in self.node_prop.keys():
                    prop=self.node_prop[current]
                else :
                    if  current in S_node_prop.keys():
                        prop=S_node_prop[current]
                    else :
                        prop=self.calculate_properties(current)
                self.node_prop.update({current:prop})
                if np.linalg.norm(np.array(prop)-np.array(self.Xtarget))< self.accure  :
                    goal = min(cost_so_far, key=cost_so_far.get)
                    self.node_colors[goal] = 'yellow'
                    break
                          
                
            if len(self.graph[current])<1 :
                if self.irank == 0 : 
                    morphsS = self.find_new(current,nnaib=nnaib)
                else :
                    morphsS = None
                morphsS= comm.bcast(morphsS,root=0)
                                        
                if morphsS!=None :                    
                    if current in self.node_prop.keys():
                        prop = self.node_prop[current]
                    else :
                        if  current in S_node_prop.keys():
                            prop=S_node_prop[current]
                        else :
                            prop=self.calculate_properties(current)
                if mpiuse : 
                    SmorphsS = split_list(morphsS,self.size)
                    D_prop={}
                    for imorf in morphsS  :
                        if imorf in SmorphsS[self.irank] :
                                if imorf in self.node_prop.keys() :
                                    prop2=self.node_prop[imorf]                                    
                                else :                                    
                                    prop2=self.calculate_properties(imorf)
                                D_prop.update({imorf:prop2})
                    all_dicts = comm.allgather(D_prop)
                    D_prop = {}
                    for d in all_dicts:
                        D_prop.update(d)
                    for d in D_prop:                            
                        prop2=D_prop[d]
                        imorf=d
                        objf=self.objfunc(prop2,prop)
                        self.graph[current].update({imorf:objf})
                        self.node_prop.update({imorf:prop2})
                        if imorf not in self.graph.keys():  
                            self.graph[imorf]={}                        
#                        mpicomuteprop(imorf)
                else :
                    for imorf in morphsS  :
                        prop2=self.calculate_properties(imorf)
                        objf=self.objfunc(prop2,prop)
                        self.graph[current].update({imorf:objf})
                        self.node_prop.update({imorf:prop2})
                        if imorf not in self.graph.keys():  
                            self.graph[imorf]={}
            order=order+1
            for neighbor in self.graph[current]:
                new_cost = cost_so_far[current] + self.graph[current][neighbor]
                if neighbor not in cost_so_far or new_cost < cost_so_far[neighbor]:
                    if neighbor not in came_from :
                        came_from[neighbor] =[]
                    if came_from[neighbor] ==None : came_from[neighbor] =[] 
                    if neighbor not in dicorder :
                        dicorder[neighbor] =[]
                    if neighbor not in dicpriority :
                        dicpriority[neighbor] =[]
                        
                    cost_so_far[neighbor] = new_cost
                    priority = new_cost + heuristic(goal, neighbor,Bias)
                    frontier.put((priority, neighbor))
                    dicpriority[neighbor].append(priority)
                    
                    dicorder[neighbor].append(order)
                    came_from[neighbor].append(current)
                    if self.makeplot :
                    # Add edge to the graph
                        # self.G.add_edge(current, neighbor, weight=graph[current][neighbor])
                        self.edge_labels[(current, neighbor)] = float("%.3f" %graph[current][neighbor])
                        self.node_colors[neighbor] = 'orange'
                    else :
                        print("ELSE ?")
                        print(neighbor)
                        print ( cost_so_far )
                        print (new_cost) 
                        print (cost_so_far[neighbor])
                        if neighbor not in came_from :
                            came_from[neighbor] =[]
                        came_from[neighbor].append(current)
                        exit(0)
            
            # Color current node as explored
        # if False :                
        path = [goal]
        current = goal
        Tcame_from= deepcopy(came_from)
        while current != start:
            current = Tcame_from[current][0]
            # del(Tcame_from[current][-1])
            path.append(current)
        path.reverse()

        if self.makeplot :   
            if mpiuse : 
                if self.irank == 0:self.makeGplot(dicorder,path,goal)
            else :
                self.makeGplot(dicorder,path,goal)
        return path

    def objfunc2(self,x2,x1):
        if type(self.Xtarget)==type([]):
            fun=0.
            for ixT in range(len(self.Xtarget)) :
                if abs(self.Xtarget[ixT])>1.e-10 :
                    fun=fun+((self.Xtarget[ixT]-x2[ixT])/self.Xtarget[ixT] )**2- ((self.Xtarget[ixT]-x1[ixT])/self.Xtarget[ixT]) **2
                else : 
                    fun=fun+(self.Xtarget[ixT]-x2[ixT])**2-(self.Xtarget[ixT]-x1[ixT])**2
            return fun
        else :
            return (self.Xtarget-x2)**2-(self.Xtarget-x1)**2
            

    def myheuristic2(self,x2,x1):
        ''' in order to test the use of a heuristic function '''
        return (self.Xtarget-x2)**2-(self.Xtarget-x1)**2

    def Viewlast(self):       
       oldG1=load_obj("outp_G.pk")
       oldgraph1=load_obj("outp_graph.pk")
       minv=10e10
       oldpath1 = load_obj("outp_path.pk")
       oldnode_prop1=load_obj("outp_node.pk")
       for k in oldnode_prop1.keys() :
        print(k,oldnode_prop1[k])
        minv=min(minv,oldnode_prop1[k])
       print(minv)

       drawpath(oldpath1)
       plot_path_val(path=oldpath1,node_prop=oldnode_prop1)
       return oldgraph1 , oldpath1, oldnode_prop1  

def expand_method(s):
    return {s}

if __name__=="__main__":
    st = time.time()
    # global useminEnergy
    # global Samp_Msize  # number of explored local minima 
    # global nnaib  
    # global maxsteps
    # global viewlast
    
    CONT_LAST = False  # continue from  old pat
    
    
    CONT_LAST_END = True    #   # continue from the first (if false) of the Last (if true) smiles of the old path
    # useAD4 = False
    # useGaussian=False
    mySampler = Sate_Sampler(dictionary={},Samp_Msize=Samp_Msize) 
    if mpiuse :
        comm = MPI.COMM_WORLD
        rank = comm.Get_rank()
    else :
        rank =0
    protf = "protein.xyz"
    ligf = "ligand.xyz"
    grid_center = ("80.904", "64.305", "55.636")
    grid_size = [23.976, 23.976, 23.976]
    grid_spacing = str(0.333)
    seed = 12324 # None # Example seed value
    n_poses = 9 # Example number of poses
    vina_path = os.path.abspath("./Vina_dock")
    ad4_path = os.path.abspath("./Ad4_dock")
    py2_path = "/opt2/intel/oneapi/intelpython/latest/envs/py2/bin/python"
    utils_path = "/opt2/intel/oneapi/intelpython/python3.9/envs/py2/MGLToolsPckgs/AutoDockTools/Utilities24"
    if useGaussian : 
        ligfn ="molecule"
        useminGauss_only = False

    # # smiles = "C"
    # smiles = "CC(C)=CCC1=C2OC(C)(C)C=CC2=C3OC=C(C(=O)C3=C1O)C4=CC=C(O)C=C4"
    smiles=initsmiles
    # RUNLAST = False
    # if RUNLAST : load_random_state('random_state.pkl')
    # save_random_state('random_state.pkl')        
    if viewlast :
       oldgraph1 , oldpath1, oldnode_prop1  =Viewlast()    
       exit()

    if CONT_LAST :
        oldpath = load_obj("outp_path.pk")
        oldgraph=load_obj("outp_graph.pk")
        oldnode_prop=load_obj("outp_node.pk")
        
        if CONT_LAST_END :
            mol = MolpherMol(oldpath[-1])  # continue from the last smiles of the old path
        else :
            mol = MolpherMol(oldpath[0])  # continue from the first smiles of the old path
    else :
        mol = MolpherMol(smiles)
        # mol = MolpherMol("C=CC(=O)C(C)OC=O")
    if useGaussian :
        if useUV :
            if useUV_Bond_order_beake : 
                Lcalculate_properties=lambda s: calculate_propertiesL6(
                s,
                gaussian_options="#p b3lyp sto-3G opt Int=UltraFine pop=NBO",               # working 1        
                gaussian_options2="--Link1--\n%chk=combined.chk\n#p td(nstates=3) b3lyp/sto-3G guess=read geom=check int=ultrafine\n\nTD-DFT calculation for UV-Vis spectrum pop=NBO\n\n0 1\n",           
                # gaussian_options="#p mn15 cc-pVDZ opt Int=UltraFine pop=NBO",               # working 1        
                # gaussian_options2="--Link1--\n%chk=combined.chk\n#p td(nstates=3) mn15/cc-pVDZ guess=read geom=check int=ultrafine\n\nTD-DFT calculation for UV-Vis spectrum pop=NBO\n\n0 1\n",           
                Spect="UV",
                savexyz=False,
                ligfn=ligfn)
            else :
                Lcalculate_properties=lambda s: calculate_propertiesL5(
                s,
                # gaussian_options="#p b3lyp sto-3G opt Int=UltraFine",
                # gaussian_options="#p b3lyp cc-pVDZ opt Int=UltraFine",
                gaussian_options="#p mn15 cc-pVDZ opt Int=UltraFine",               # working 1        
                # gaussian_options="#p td(nstates=3, conver=3) b3lyp sto-3G opt Int=UltraFine",
                # gaussian_options="#p td(nstates=3) b3lyp sto-3G opt",
                # gaussian_options="#p td(nstates=3, conver=3) b3lyp sto-3G opt Int=UltraFine",
                # gaussian_options="#p b3lyp sto-3G opt Int=UltraFine",
                # gaussian_options="#p td(nstates=3) b3lyp def2svp opt",
                # gaussian_options="#p td(b3lyp,nstates=3) 6-31G(d) scrf=(solvent=water) opt Int=UltraFine",
                # gaussian_options2="--Link1--\n%chk=combined.chk\n#p td(nstates=3) b3lyp/sto-3G guess=read geom=check int=ultrafine\n\nTD-DFT calculation for UV-Vis spectrum\n\n0 1\n",
                # gaussian_options2="--Link1--\n%chk=combined.chk\n#p td(nstates=3, conver=6) b3lyp/cc-pVDZ guess=read geom=check int=ultrafine\n\nTD-DFT calculation for UV-Vis spectrum\n\n0 1\n",
                # gaussian_options2="--Link1--\n%chk=combined.chk\n#p td(nstates=3) b3lyp/cc-pVDZ guess=read geom=check int=ultrafine\n\nTD-DFT calculation for UV-Vis spectrum\n\n0 1\n",           # working 1
                gaussian_options2="--Link1--\n%chk=combined.chk\n#p td(nstates=3) mn15/cc-pVDZ guess=read geom=check int=ultrafine\n\nTD-DFT calculation for UV-Vis spectrum\n\n0 1\n",           
                Spect="UV",
                savexyz=False,
                ligfn=ligfn)
        else :  
            if useIR :
                Lcalculate_properties=lambda s: calculate_propertiesL5(
                s,
                gaussian_options="#p freq b3lyp/6-31G(d) opt",
                Spect="IR",
                ligfn=ligfn)
            else :  
                if useNMR :
                    Lcalculate_properties=lambda s: calculate_propertiesL5(
                    s,
                    gaussian_options="#p nmr=giao b3lyp/6-31G(d) opt",
                    Spect="NMR",
                    ligfn=ligfn)
                else :  
                    Lcalculate_properties=lambda s: calculate_propertiesL5(
                    s,
                    ligfn=ligfn)

    if useAD4:
        Lcalculate_properties=lambda s: calculate_propertiesL3(
                s,
                protf=protf,
                ligf=ligf,
                grid_center=grid_center,
                grid_size=grid_size,
                grid_spacing=grid_spacing,
                ad4_path=ad4_path,
                seed=seed,  # Pass the seed
                n_poses=n_poses,  # Pass the number of poses
                py2=py2_path,  # Pass the Python 2 path
                utils_path=utils_path  # Pass the Utilities24 path
            )
    else : 
        if not useGaussian :
            Lcalculate_properties=lambda s: calculate_propertiesL4(
                s,
                protf=protf,
                ligf=ligf,
                grid_center=grid_center,
                grid_size=grid_size,
                grid_spacing=grid_spacing,
                vina_path=vina_path,
                seed=seed,  # Pass the seed
                n_poses=n_poses,  # Pass the number of poses
                py2=py2_path,  # Pass the Python 2 path
                utils_path=utils_path  # Pass the Utilities24 path
            )
    Finished = False 
    mySampler = Sate_Sampler(dictionary={mol.smiles:mol},Samp_Msize=Samp_Msize) 
    initmol=mol
    ibase=0
    
    if storeOBJ :
        S_paths=[]
        S_G=nx.DiGraph()
        S_graph={}
        global S_node_prop
        S_node_prop={}
        S_edge_colors=[]
        S_node_label={}
        S_node_colors={}
        S_edge_labels={}
    else :
        S_node_prop={}        

    while not Finished : 
        sampled_key = mySampler.sample_key()
        mol = mySampler.dictionary[sampled_key]
        if not isinstance(mol, MolpherMol):
            print("!!!!!The object is not of type MolpherMol.",mol)
            continue    
        if Target != None :
            myChemS=ChemSampling(mol,makeplot=makeplot,Xtarget=Target)
        else :
            myChemS=ChemSampling(mol,makeplot=makeplot)
                    
        graph = myChemS.init_graph(mol,calculate_properties=Lcalculate_properties)
        path=myChemS.make_astar_NetX(nnaib=nnaib,maxsteps=maxsteps)
        if myChemS.makeplot :   
            if mpiuse : 
                if rank==0 :
                    save_obj("outp_graph.pk",myChemS.graph)
                    save_obj("outp_G.pk",myChemS.G)
                    save_obj("outp_node.pk",myChemS.node_prop)
            else :
                save_obj("outp_graph.pk",myChemS.graph)
                save_obj("outp_G.pk",myChemS.G)
                save_obj("outp_node.pk",myChemS.node_prop)
            
        ibase+=1        
        if rank==0 :
            save_obj(str(ibase)+"outp_path.pk",path)
            save_obj(str(ibase)+"outp_graph.pk",myChemS.graph)
            if makeplot :
                save_obj(str(ibase)+"outp_G.pk",myChemS.G)
                save_obj(str(ibase)+"outp_node.pk",myChemS.node_prop)
        Finished = mySampler.expand_dictionary(expand_method,path[-1])
        if len(path) > 1 :  mySampler.add_value(key=path[-1],value=Molfermol_smiles(path[-1]))
        if rank == 0 and storeOBJ :
            S_G=nx.compose(S_G,myChemS.G)
            S_paths.extend(path)
            S_edge_colors.extend(myChemS.edge_colors)
            S_graph.update(graph)
            S_node_prop.update(myChemS.node_prop)
            S_node_label.update(myChemS.node_label)
            S_node_colors.update(myChemS.node_colors)        
            S_edge_labels.update(myChemS.edge_labels)
        else :
            S_node_prop.update(myChemS.node_prop)
            
        et1 = time.time()
    # get the execution time
        elapsed_time = et1 - st
        print('Pros:',rank,' Execution time base' ,ibase," :", elapsed_time, 'seconds')
        deb_f.write('Pros:'+str(rank)+' Execution time base'+str(ibase)+" :"+str(elapsed_time)+'seconds')
    print(" Find ALL PATHS END !!!")
    if storeOBJ :    
        myChemS.Draw_G(G=S_G,edge_colors=S_edge_colors,node_label=S_node_label,node_colors=S_node_colors,edge_labels=S_edge_labels)

    deb_f.write("\n END")
    if storeOBJ : 
        path=S_paths
        graph=S_graph
        node_prop=S_node_prop
    else :
        node_prop=S_node_prop        
    if CONT_LAST :
        oldpath.extend(path)
        oldgraph.update(graph)
        oldnode_prop.update(myChemS.node_prop)
        path=oldpath
        graph=oldgraph
        node_prop=oldnode_prop

    plt.figure()

    props=[]
    for ist in path :
        try :
            pro1 = node_prop[ist]
            props.append(pro1)
        except :
            print( myChemS.node_prop.keys())
#        pro =myChemS.calculate_properties(ist)
#        print("Path Free Energy",pro," ",pro1)
    plt.plot(props)

    et = time.time()
    # get the execution time
    elapsed_time = et - st
    print('Pros:',rank,' Execution time:', elapsed_time, 'seconds')

    try :
        if showPLOTS: plt.show()
    except :
        pass
    if mpiuse :
        if rank==0 :
            save_obj("outp_path.pk",path)
            save_obj("outp_graph.pk",myChemS.graph)
            if makeplot :
                save_obj("outp_G.pk",myChemS.G)            
                save_obj("outp_node.pk",myChemS.node_prop)
    else :            
        save_obj("outp_path.pk",path)
        save_obj("outp_graph.pk",myChemS.graph)
        if makeplot :        
            save_obj("outp_G.pk",myChemS.G)
            save_obj("outp_node.pk",myChemS.node_prop)
    
    try :
        if mpiuse :
            if rank == 0 : drawpath(path)
        else :
            drawpath(path)
        deb_f.close()
    except :
        pass
#print(morphs[1:3])
#print(molpher.morphs)

