import os
import hashlib
import base64

def get_hash(input_string):
    hash_md5 = hashlib.md5(input_string.encode()).digest()
    base64_hash = base64.urlsafe_b64encode(hash_md5).decode('utf-8').rstrip('=')
    return base64_hash

def scan_and_process(root_folder):
    for root, dirs, files in os.walk(root_folder):
        if "labels.txt" in files and "nettools_nodeprop.txt" in files:
            label_path = os.path.join(root, "labels.txt")
            prop_path = os.path.join(root, "nettools_nodeprop.txt")

            with open(label_path, 'r') as f:
                lines = f.readlines()
            if not lines or ':' not in lines[-1]:
                continue

            _, smiles = lines[-1].strip().split(':', 1)
            smiles = smiles.strip()
            unique_dir = f"dir_{get_hash(smiles)}"
            full_path = os.path.join(root, unique_dir)

            affinity = None
            with open(prop_path, 'r') as f:
                for line in f:
                    line_smiles = line.strip().split(':')[0]
                    if line_smiles == smiles:
                        _, value = line.split(':', 1)
                        affinity = value.strip()
                        break

            print(f"{smiles}\n{unique_dir}\n{full_path}\n{affinity}\n")

# Call the function with your root folder
scan_and_process("/home/kbaitsi/Ligands_2/11a/ph_f_taut_t")
