from pathlib import Path
import textwrap

# Prepare script for downloading and installing MGLTools
install_script = Path("vina_project_setup/screpts/install_mgltools.sh")
install_script.write_text(textwrap.dedent("""\
    #!/bin/bash

    echo "⚙️  MGLTools Installer (for Python 2.7 Environment)"
    echo "---------------------------------------------------"
    echo "This script will download and install MGLTools (if not already present)."

    read -p "❓ Do you want to download and install MGLTools automatically? (y/n): " choice

    if [[ "$choice" != "y" && "$choice" != "Y" ]]; then
        echo "❌ Skipping MGLTools installation."
        exit 0
    fi

    echo "📥 Downloading MGLTools (Linux 64-bit build)..."
    URL="http://mgltools.scripps.edu/downloads"
    FILE="mgltools_i86Linux2_1.5.7.tar.gz"
    wget -O $FILE https://ccsb.scripps.edu/download/532/ --content-disposition

    if [[ ! -f "$FILE" ]]; then
        echo "❌ Failed to download $FILE"
        exit 1
    fi

    echo "📦 Extracting $FILE..."
    tar -xzf $FILE
    cd mgltools*

    echo "🚀 Installing MGLTools..."
    ./install.sh

    echo "✅ MGLTools installation complete."
    echo "Make sure to export the following:"
    echo "  export AUTODOCKTOOLS_PY2_PATH=$(pwd)/bin/python"
    echo "  export AUTODOCKTOOLS_UTILS_PATH=$(pwd)/MGLToolsPckgs/AutoDockTools/Utilities24"
"""))
install_script.chmod(0o755)

install_script.resolve()

