import random

class Sate_Sampler:
    def __init__(self, dictionary=None,Samp_Msize=10000,iso_map={}):
        """
        Initialize the sampler with an optional initial dictionary.
        """
        self.dictionary = dictionary if dictionary else {}
        self.selection_counts = {key: 0 for key in self.dictionary}  # Track the selection count for each key
        self.maxsize=Samp_Msize
        self.iso_map=iso_map
        
    def _calculate_weights(self):
        """
        Calculate weights for sampling based on the inverse of the selection counts.
        """
        total_selections = sum(self.selection_counts.values()) + 1  # Avoid division by zero
        weights = {}
        for key, count in self.selection_counts.items():
            # Weight is inverse of (selection count + 1) to avoid division by zero and give more weight to less selected keys
            weights[key] = (total_selections / (count + 1))
        return weights

    def sample_key(self):
        """
        Stochastically sample a key from the dictionary using the weights.
        """
        weights = self._calculate_weights()
        total_weight = sum(weights.values())
        normalized_weights = {key: weight / total_weight for key, weight in weights.items()}
        
        keys = list(self.dictionary.keys())
        probabilities = [normalized_weights[key] for key in keys]
        
        # Choose a key based on the calculated probabilities
        chosen_key = random.choices(keys, weights=probabilities, k=1)[0]
        
        # Update selection count
        self.selection_counts[chosen_key] += 1
        
        return chosen_key

    def add_keys(self, new_keys):
        """
        Add new keys to the dictionary and initialize their selection count.
        """
        for key in new_keys:
            if key not in self.dictionary:
                self.dictionary[key] = None  # Assuming new keys have no value initially
                self.selection_counts[key] = 0

    def add_value(self, key,value):
        """
        Add new keys to the dictionary and initialize their selection count.
        """
        if key not in self.dictionary:
            self.dictionary[key] = None  # Assuming new keys have no value initially
            self.selection_counts[key] = 0
        else :
            self.dictionary[key]=value

    def expand_dictionary(self, external_method,key):
        """
        Expand the dictionary using an external method that provides new keys.
        """
        new_keys = external_method(key)  # Assume this method returns a list of new keys
        self.add_keys(new_keys)
        weights = self._calculate_weights()
        total_weight = sum(weights.values())
        Uptpno=sum(self.selection_counts.values())
        if self.maxsize< Uptpno+1 : 
            return True
        else :
            return False

    def get_selection_counts(self):
        """
        Return the selection counts for each key.
        """
        return self.selection_counts

def external_method(key):
    return [key]

if __name__=="__main__":
    mySampler = Sate_Sampler(dictionary={},Samp_Msize=1000) 
    Finished = mySampler.expand_dictionary(external_method)
    for i in range(1000):
        sampled_key = mySampler.sample_key()
        print(f"Sampled Key: {sampled_key}")
        newkey=random.randrange(1,10)
        Finished = mySampler.expand_dictionary(external_method,newkey)
        print("Selection Counts:", mySampler.get_selection_counts())

