#!/bin/bash
cd Vina_dock/
echo "Creating Python 2.7 environment for MGLTools..."
conda create -n mgltools_env python=2.7 -y
python install_mg.py
echo " Alternatively activate the MGLTools environment and install MGLTools manually:"
echo "  conda activate mgltools_env"
echo "  tar -xvzf mgltools_x.x.tar.gz"
echo "  cd mgltools_x.x"
echo "  ./install.sh"
echo "Remember to set:"
echo "  export AUTODOCKTOOLS_PY2_PATH=/path/to/mgltools_env/bin/python"
echo "  export AUTODOCKTOOLS_UTILS_PATH=/path/to/MGLToolsPckgs/AutoDockTools/Utilities24"

echo ""
echo "Creating Python 3.10 environment for docking tools..."
conda create -n vina_env python=3.10 -y
conda activate vina_env

echo "Installing docking dependencies..."
conda install -n vina_env -c conda-forge openbabel rdkit numpy -y
conda run -n vina_env pip install vina pyinstaller

echo "Setup complete."
cd vina_project_setup/src/
./buld_exe.sh 
