database(
    thermoLibraries=[
    ],
    reactionLibraries=['primaryNitrogenLibrary'],
    kineticsDepositories=['training'],
    kineticsFamilies=[
        '1+2_Cycloaddition',
        '1,2-Birad_to_alkene',
        '1,2_Insertion_CO',
        '1,2_Insertion_carbene',
        '1,2_shiftS',
        '1,3_Insertion_CO2',
        '1,3_Insertion_ROR',
        '1,3_Insertion_RSR',
        '1,4_Cyclic_birad_scission',
        '1,4_Linear_birad_scission',
        '2+2_cycloaddition',
        'Birad_recombination',
        'CO_Disproportionation',
        'Birad_R_Recombination',
        'Cyclic_Ether_Formation',
        'Cyclic_Thioether_Formation',
        'Diels_alder_addition',
        'Diels_alder_addition_Aromatic',
        'Disproportionation',
        'HO2_Elimination_from_PeroxyRadical',
        'H_Abstraction',
        'Intra_Retro_Diels_alder_bicyclic',
        'Intra_Disproportionation',
        'Intra_R_Add_Endocyclic',
        'Intra_R_Add_Exocyclic',
        'R_Addition_COm',
        'R_Addition_MultipleBond',
        'R_Recombination',
        'intra_H_migration',
        'intra_NO2_ONO_conversion',
        'intra_OH_migration',
        'intra_substitutionCS_cyclization',
        'intra_substitutionCS_isomerization',
        'intra_substitutionS_cyclization',
        'intra_substitutionS_isomerization',
        '1,3_sigmatropic_rearrangement',
        'Singlet_Carbene_Intra_Disproportionation',
        'Singlet_Val6_to_triplet',
        'Intra_5_membered_conjugated_C=C_C=C_addition',
        'Intra_Diels_alder_monocyclic',
        'Concerted_Intra_Diels_alder_monocyclic_1,2_shiftH',
        'Intra_2+2_cycloaddition_Cd',
        'Intra_ene_reaction',
        'Cyclopentadiene_scission',
        '6_membered_central_C-C_shift',
        'Intra_R_Add_Exo_scission',
        '1,2_shiftC',
        '1,2_NH3_elimination',
        '1,3_NH3_elimination',
        'Retroene',
        'Ketoenol',
    ],
    kineticsEstimator='rate rules',
    transportLibraries=['PrimaryTransportLibrary', 'OneDMinN2', 'NOx2018', 'GRI-Mech', 'NIST_Fluorine']
)

frequencyScaleFactor = 1.0

etm = SingleExponentialDown(
    alpha0=(100, "cm^-1"),
    T0=(298, "K"),
    n=0.85
)

species(
    "N2",
    E0=(0, 'kcal/mol'),
    modes=[
        IdealGasTranslation(mass=(28.0, 'amu')),
        LinearRotor(
            inertia=(0.1180312, 'amu*angstrom^2'),
            symmetry=1,
        ),
        HarmonicOscillator(frequencies=([2738.8], 'cm^-1')),
    ],
    structure=SMILES("N#N"),
    energyTransferModel=etm,
    spinMultiplicity=1,
    collisionModel=TransportData(shapeIndex=1, epsilon=(810.913, 'J/mol'), sigma=(3.621, 'angstroms'), dipoleMoment=(0, 'C*m'), polarizability=(1.76, 'angstroms^3'), rotrelaxcollnum=4.0, comment="""GRI-Mech""")
)

species(
    "H",
    E0=(0, 'kcal/mol'),
    modes=[
        IdealGasTranslation(mass=(1.0, 'amu')),
    ],
    structure=SMILES("[H]"),
    energyTransferModel=etm,
    spinMultiplicity=2,
    collisionModel=TransportData(shapeIndex=0, epsilon=(1205.6, 'J/mol'), sigma=(2.05, 'angstroms'), dipoleMoment=(0, 'C*m'), polarizability=(0, 'angstroms^3'), rotrelaxcollnum=0.0, comment="GRI-Mech")
)

species(
    "H2",
    E0=(0, 'kcal/mol'),
    modes=[
        IdealGasTranslation(mass=(2.0, 'amu')),
        LinearRotor(
            inertia=(0.27701200000000004, 'amu*angstrom^2'),
            symmetry=1,
        ),
        HarmonicOscillator(frequencies=([4401.31], 'cm^-1')),
    ],
    structure=SMILES("[H][H]"),
    energyTransferModel=etm,
    spinMultiplicity=1,
    collisionModel=TransportData(shapeIndex=1, epsilon=(315.951, 'J/mol'), sigma=(2.92, 'angstroms'), dipoleMoment=(0, 'C*m'), polarizability=(0.79, 'angstroms^3'), rotrelaxcollnum=280.0, comment="GRI-Mech")
)

species(
    "H2NO",
    modes=[
        IdealGasTranslation(mass=(32.02952, 'amu')),
        NonlinearRotor(
            inertia=([1.56793782, 14.85604557, 16.33925121], 'amu*angstrom^2'),
            symmetry=2,
        ),
        HarmonicOscillator(frequencies=([379.96, 1266.35, 1365.52, 1660.91, 3451.01, 3590.22], 'cm^-1')),
    ],
    E0=(15.3, 'kcal/mol'),
    structure=SMILES("N[O]"),
    energyTransferModel=etm,
    spinMultiplicity=2,
    collisionModel=TransportData(shapeIndex=2, epsilon=(970.302, 'J/mol'), sigma=(3.492, 'angstroms'), dipoleMoment=(0, 'C*m'), polarizability=(0, 'angstroms^3'), rotrelaxcollnum=1.0, comment="GRI-Mech")
)

species(
    "HNO",
    modes=[
        IdealGasTranslation(mass=(31.02952, 'amu')),
        NonlinearRotor(
            inertia=([0.89426161, 12.02394472, 12.91820633], 'amu*angstrom^2'),
            symmetry=1,
        ),
        HarmonicOscillator(frequencies=([1531.36, 1588.86, 2946.80], 'cm^-1')),
    ],
    E0=(-27.3, 'kcal/mol'),
    structure=SMILES("N=O"),
    energyTransferModel=etm,
    spinMultiplicity=1,
    collisionModel=TransportData(shapeIndex=2, epsilon=(970.302, 'J/mol'), sigma=(3.492, 'angstroms'), dipoleMoment=(0, 'C*m'), polarizability=(0, 'angstroms^3'), rotrelaxcollnum=1.0, comment="GRI-Mech")
)

species(
    "NH2OH",
    modes=[
        IdealGasTranslation(mass=(33.02952, 'amu')),
        NonlinearRotor(
            inertia=([22.19, 21.9629, 2.663], 'amu*angstrom^2'),
            symmetry=1,
        ),
        HarmonicOscillator(frequencies=([3619, 3495, 2742, 1568, 1223, 1024, 993, 703], 'cm^-1')),
    ],
    E0=(-61.7, 'kcal/mol'),
    structure=SMILES("NO"),
    energyTransferModel=etm,
    spinMultiplicity=1,
    collisionModel=TransportData(shapeIndex=2, epsilon=(970.299, 'J/mol'), sigma=(3.492, 'angstroms'), dipoleMoment=(0, 'De'), polarizability=(0, 'angstroms^3'), rotrelaxcollnum=1.0, comment="NOx2018")
)

species(
    "NH3O",
    modes=[
        IdealGasTranslation(mass=(33.02952, 'amu')),
        NonlinearRotor(
            inertia=([2.72428273, 18.9828243, 18.9828243], 'amu*angstrom^2'),
            symmetry=3,
        ),
        HarmonicOscillator(frequencies=([948.46, 1131.62, 1131.83, 1507.60, 1668.35, 1668.53, 3294.98, 3356.08, 3356.13], 'cm^-1')),
    ],
    E0=(-36.6, 'kcal/mol'),
    structure=SMILES("[NH3+][O-]"),
    energyTransferModel=etm,
    spinMultiplicity=1,
    collisionModel=TransportData(shapeIndex=2, epsilon=(920.412, 'J/mol'), sigma=(4.443e-10, 'm'), dipoleMoment=(0, 'C*m'), polarizability=(0, 'angstroms^3'), rotrelaxcollnum=0, comment="""Epsilon & sigma estimated with fixed Lennard Jones Parameters. This is the fallback method! Try improving transport databases!""")
)

species(
    "NH2",
    E0=(0, 'kcal/mol'),
    modes=[
        IdealGasTranslation(mass=(16.0, 'amu')),
        NonlinearRotor(
            inertia=([0.71827686, 1.29071403, 2.00899088], 'amu*angstrom^2'),
            symmetry=1,
        ),
        HarmonicOscillator(frequencies=([1540.00, 3359.68, 3453.42], 'cm^-1')),
    ],
    structure=SMILES("[NH2]"),
    energyTransferModel=etm,
    spinMultiplicity=2,
    collisionModel=TransportData(shapeIndex=2, epsilon=(665.16, 'J/mol'), sigma=(2.65, 'angstroms'), dipoleMoment=(0, 'C*m'), polarizability=(2.26, 'angstroms^3'), rotrelaxcollnum=4.0, comment="GRI-Mech")
)

species(
    "OH",
    modes=[
        IdealGasTranslation(mass=(17.0, 'amu')),
        LinearRotor(
            inertia=(0.89166156, 'amu*angstrom^2'),
            symmetry=1,
        ),
        HarmonicOscillator(frequencies=([3717.38], 'cm^-1')),
    ],
    E0=(0, 'kcal/mol'),
    structure=SMILES("[OH]"),
    spinMultiplicity=2,
    energyTransferModel=etm,
    collisionModel=TransportData(shapeIndex=1, epsilon=(665.16, 'J/mol'), sigma=(2.75, 'angstroms'), dipoleMoment=(0, 'C*m'), polarizability=(0, 'angstroms^3'), rotrelaxcollnum=0.0, comment="GRI-Mech")
)

transitionState(
    "TS1",
    E0=(-12.5, 'kcal/mol'),
    modes=[
        IdealGasTranslation(mass=(33.02952, 'amu')),
        NonlinearRotor(
            inertia=([22.1944, 21.9629, 2.66333], 'amu*angstrom^2'),
            symmetry=1,
        ),
        HarmonicOscillator(frequencies=([3619, 3495, 2742, 1568, 1223, 1024, 993, 703], 'cm^-1')),
    ],
    spinMultiplicity=1,
    opticalIsomers=1,
    frequency=(1635, 'cm^-1')
)

transitionState(
    "TS2",
    E0=(12.37, 'kcal/mol'),
    modes=[
        IdealGasTranslation(mass=(33.02952, 'amu')),
        NonlinearRotor(
            inertia=([3.60911863, 17.99428078, 19.46436553], 'amu*angstrom^2'),
            symmetry=1,
        ),
        HarmonicOscillator(frequencies=([3192.61, 2449.23, 1574.55, 1429.12, 1286.87, 1045.76, 743.45, 638.67], 'cm^-1')),
    ],
    spinMultiplicity=1,
    opticalIsomers=1,
    frequency=(1257.89, 'cm^-1')
)

transitionState("TS3", E0=(15.3, 'kcal/mol'))
transitionState("TS4", E0=(15.3, 'kcal/mol'))
transitionState("TS5", E0=(0, 'kcal/mol'))

reaction(
    "H + H2NO <=> NH2OH",
    reactants=["H", "H2NO"],
    products=["NH2OH"],
    kinetics=Arrhenius(
        A=(1.44E9, 'cm^3/(mol*s)'),
        n=1.25235,
        Ea=(2.075, 'kJ/mol'),
        T0=(1, 'K'),
        Tmin=(300, 'K'),
        Tmax=(2000, 'K'),
        comment="""Fitted to 35 data points; dA = *|/ 1.17496, dn = +|- 0.0207886, dEa = +|- 0.129354 kJ/mol"""
    ),
    transitionState="TS3"
)

reaction(
    "H + H2NO <=> NH3O",
    reactants=["H", "H2NO"],
    products=["NH3O"],
    kinetics=Arrhenius(
        A=(2.13E10, 'cm^3/(mol*s)'),
        n=0.88225,
        Ea=(3.514, 'kJ/mol'),
        T0=(1, 'K'),
        Tmin=(300, 'K'),
        Tmax=(2000, 'K'),
        comment="""Fitted to 35 data points; dA = *|/ 1.35914, dn = +|- 0.0395638, dEa = +|- 0.246179 kJ/mol"""
    ),
    transitionState="TS4"
)

reaction(
    "NH2OH <=> NH2 + OH",
    reactants=["NH2OH"],
    products=["NH2", "OH"],
    kinetics=Arrhenius(
        A=(1.4e20, 's^-1'),
        n=-1.31,
        Ea=(268.1265, 'kJ/mol')
    ),
    transitionState="TS5"
)

reaction(
    "NH2OH <=> NH3O",
    reactants=["NH2OH"],
    products=["NH3O"],
    transitionState="TS1",
    tunneling="Eckart"
)

reaction(
    "NH3O <=> H2 + HNO",
    reactants=["NH3O"],
    products=["H2", "HNO"],
    transitionState="TS2",
    tunneling="Eckart"
)

kinetics("NH2OH <=> NH3O")
kinetics("NH3O <=> H2 + HNO")

network(
    label='NH2OH_network',
    isomers=[
        "NH2OH",
        "NH3O"
    ],
    reactants=[
        ('H', 'H2NO'),
    ],
    products=[
        ('NH2', 'OH'),
        ('H2', 'HNO')
    ],
    bathGas={
        'N2': 1.0,
    },
    pathReactions=[
        "H + H2NO <=> NH2OH",
        "H + H2NO <=> NH3O",
        "NH2OH <=> NH2 + OH",
        "NH2OH <=> NH3O",
        "NH3O <=> H2 + HNO",
    ]
)

pressureDependence(
    label='NH2OH_network',
    Tmin=(300.0, 'K'), Tmax=(2000.0, 'K'), Tcount=12,
    Pmin=(0.01, 'bar'), Pmax=(100.0, 'bar'), Pcount=5,
    maximumGrainSize=(1.0, 'kcal/mol'),
    minimumGrainCount=250,
    method='modified strong collision',
    interpolationModel=('pdeparrhenius'),
    activeJRotor=True,
    sensitivity_conditions=[[(1000, 'K'), (1, 'bar')], [(1500, 'K'), (10, 'bar')]]
)
