#   ======= =========== =========== =========== ===============
#   Temp.   k (TST)     Tunneling   k (TST+T)   Units
#   ======= =========== =========== =========== ===============
#    2500 K   2.605e+09     1.04263   2.716e+09 s^-1
#    2172.4 K   5.085e+08     1.05597   5.369e+08 s^-1
#    1920.71 K   1.010e+08     1.07133   1.082e+08 s^-1
#    1721.28 K   2.032e+07     1.08879   2.213e+07 s^-1
#    1559.38 K   4.135e+06      1.1085   4.584e+06 s^-1
#    1425.31 K   8.489e+05     1.13057   9.598e+05 s^-1
#    1312.47 K   1.756e+05     1.15519   2.028e+05 s^-1
#    1216.18 K   3.654e+04     1.18254   4.321e+04 s^-1
#    1133.06 K   7.646e+03     1.21283   9.274e+03 s^-1
#    1060.58 K   1.607e+03     1.24631   2.003e+03 s^-1
#    996.805 K   3.393e+02     1.28327   4.354e+02 s^-1
#    940.269 K   7.189e+01     1.32403   9.518e+01 s^-1
#    889.802 K   1.528e+01     1.36897   2.092e+01 s^-1
#    844.476 K   3.257e+00     1.41853   4.620e+00 s^-1
#    803.544 K   6.961e-01      1.4732   1.025e+00 s^-1
#    766.397 K   1.491e-01     1.53357   2.287e-01 s^-1
#    732.532 K   3.201e-02     1.60031   5.123e-02 s^-1
#    701.534 K   6.885e-03     1.67419   1.153e-02 s^-1
#    673.052 K   1.484e-03     1.75615   2.605e-03 s^-1
#    646.793 K   3.202e-04     1.84726   5.915e-04 s^-1
#    622.506 K   6.922e-05      1.9488   1.349e-04 s^-1
#    599.977 K   1.498e-05     2.06226   3.090e-05 s^-1
#    579.022 K   3.248e-06     2.18946   7.111e-06 s^-1
#    559.481 K   7.049e-07     2.33254   1.644e-06 s^-1
#    541.216 K   1.531e-07     2.49411   3.820e-07 s^-1
#    524.106 K   3.331e-08     2.67731   8.918e-08 s^-1
#    508.044 K   7.252e-09       2.886   2.093e-08 s^-1
#    492.938 K   1.580e-09     3.12488   4.938e-09 s^-1
#    478.704 K   3.447e-10     3.39981   1.172e-09 s^-1
#    465.269 K   7.524e-11     3.71808   2.798e-10 s^-1
#    452.568 K   1.644e-11     4.08883   6.721e-11 s^-1
#    440.541 K   3.594e-12     4.52365   1.626e-11 s^-1
#    429.137 K   7.863e-13     5.03734   3.961e-12 s^-1
#    418.309 K   1.721e-13     5.64898   9.725e-13 s^-1
#    408.014 K   3.771e-14     6.38333   2.407e-13 s^-1
#    398.213 K   8.267e-15     7.27291   6.012e-14 s^-1
#    388.872 K   1.813e-15     8.36078   1.516e-14 s^-1
#    379.96 K   3.979e-16     9.70454   3.861e-15 s^-1
#    371.446 K   8.737e-17      11.382   9.944e-16 s^-1
#    363.306 K   1.919e-17     13.4993   2.591e-16 s^-1
#    355.515 K   4.218e-18     16.2029   6.835e-17 s^-1
#    348.051 K   9.275e-19     19.6968   1.827e-17 s^-1
#    340.894 K   2.040e-19     24.2681   4.951e-18 s^-1
#    334.026 K   4.490e-20     30.3253   1.362e-18 s^-1
#    327.428 K   9.886e-21     38.4557   3.802e-19 s^-1
#    321.087 K   2.177e-21     49.5125   1.078e-19 s^-1
#    314.986 K   4.797e-22     64.7475   3.106e-20 s^-1
#    309.113 K   1.057e-22     86.0169   9.095e-21 s^-1
#    303.455 K   2.331e-23       116.1   2.707e-21 s^-1
#     298 K   5.142e-24       159.2   8.186e-22 s^-1
#   ======= =========== =========== =========== ===============


#   ======= ============ =========== ============ ============= =========
#   Temp.    Kc (eq)        Units     k_rev (TST) k_rev (TST+T)   Units
#   ======= ============ =========== ============ ============= =========
#    2500 K   1.634e-03              1.595e+12     1.663e+12      s^-1
#    2172.4 K   7.274e-04              6.991e+11     7.382e+11      s^-1
#    1920.71 K   3.285e-04              3.074e+11     3.293e+11      s^-1
#    1721.28 K   1.499e-04              1.356e+11     1.476e+11      s^-1
#    1559.38 K   6.893e-05              6.000e+10     6.651e+10      s^-1
#    1425.31 K   3.188e-05              2.663e+10     3.010e+10      s^-1
#    1312.47 K   1.482e-05              1.185e+10     1.369e+10      s^-1
#    1216.18 K   6.908e-06              5.290e+09     6.256e+09      s^-1
#    1133.06 K   3.229e-06              2.368e+09     2.872e+09      s^-1
#    1060.58 K   1.513e-06              1.063e+09     1.324e+09      s^-1
#    996.805 K   7.098e-07              4.781e+08     6.135e+08      s^-1
#    940.269 K   3.334e-07              2.156e+08     2.855e+08      s^-1
#    889.802 K   1.567e-07              9.749e+07     1.335e+08      s^-1
#    844.476 K   7.372e-08              4.418e+07     6.267e+07      s^-1
#    803.544 K   3.469e-08              2.006e+07     2.956e+07      s^-1
#    766.397 K   1.633e-08              9.130e+06     1.400e+07      s^-1
#    732.532 K   7.688e-09              4.163e+06     6.663e+06      s^-1
#    701.534 K   3.620e-09              1.902e+06     3.185e+06      s^-1
#    673.052 K   1.704e-09              8.706e+05     1.529e+06      s^-1
#    646.793 K   8.022e-10              3.992e+05     7.374e+05      s^-1
#    622.506 K   3.776e-10              1.833e+05     3.573e+05      s^-1
#    599.977 K   1.777e-10              8.434e+04     1.739e+05      s^-1
#    579.022 K   8.358e-11              3.886e+04     8.508e+04      s^-1
#    559.481 K   3.931e-11              1.793e+04     4.182e+04      s^-1
#    541.216 K   1.849e-11              8.284e+03     2.066e+04      s^-1
#    524.106 K   8.691e-12              3.833e+03     1.026e+04      s^-1
#    508.044 K   4.084e-12              1.776e+03     5.124e+03      s^-1
#    492.938 K   1.919e-12              8.235e+02     2.573e+03      s^-1
#    478.704 K   9.014e-13              3.824e+02     1.300e+03      s^-1
#    465.269 K   4.233e-13              1.778e+02     6.610e+02      s^-1
#    452.568 K   1.987e-13              8.273e+01     3.383e+02      s^-1
#    440.541 K   9.326e-14              3.854e+01     1.743e+02      s^-1
#    429.137 K   4.376e-14              1.797e+01     9.052e+01      s^-1
#    418.309 K   2.053e-14              8.387e+00     4.738e+01      s^-1
#    408.014 K   9.626e-15              3.918e+00     2.501e+01      s^-1
#    398.213 K   4.513e-15              1.832e+00     1.332e+01      s^-1
#    388.872 K   2.116e-15              8.571e-01     7.166e+00      s^-1
#    379.96 K   9.915e-16              4.013e-01     3.895e+00      s^-1
#    371.446 K   4.645e-16              1.881e-01     2.141e+00      s^-1
#    363.306 K   2.176e-16              8.819e-02     1.191e+00      s^-1
#    355.515 K   1.019e-16              4.138e-02     6.706e-01      s^-1
#    348.051 K   4.773e-17              1.943e-02     3.828e-01      s^-1
#    340.894 K   2.235e-17              9.130e-03     2.216e-01      s^-1
#    334.026 K   1.046e-17              4.292e-03     1.302e-01      s^-1
#    327.428 K   4.896e-18              2.019e-03     7.764e-02      s^-1
#    321.087 K   2.291e-18              9.503e-04     4.705e-02      s^-1
#    314.986 K   1.072e-18              4.475e-04     2.897e-02      s^-1
#    309.113 K   5.016e-19              2.108e-04     1.813e-02      s^-1
#    303.455 K   2.346e-19              9.937e-05     1.154e-02      s^-1
#     298 K   1.097e-19              4.686e-05     7.460e-03      s^-1
#   ======= ============ =========== ============ ============= =========


# k_rev (TST) = Arrhenius(A=(2.2174e+11,'s^-1'), n=0.890258, Ea=(102.086,'kJ/mol'), T0=(1,'K'), Tmin=(298,'K'), Tmax=(2500,'K'), comment="""Fitted to 50 data points; dA = *|/ 1.19615, dn = +|- 0.0235312, dEa = +|- 0.128056 kJ/mol""") 
# k_rev (TST+T) = Arrhenius(A=(21.9047,'s^-1'), n=3.74259, Ea=(74.6581,'kJ/mol'), T0=(1,'K'), Tmin=(298,'K'), Tmax=(2500,'K'), comment="""Fitted to 50 data points; dA = *|/ 9.38072, dn = +|- 0.294115, dEa = +|- 1.60056 kJ/mol""") 

# kinetics fitted using the modified three-parameter Arrhenius equation k = A * (T/T0)^n * exp(-Ea/RT) 
kinetics(
    label = 'NH2OH <=> NH3O',
    kinetics = Arrhenius(
        A = (2.05868, 's^-1'),
        n = 3.85233,
        Ea = (178.425, 'kJ/mol'),
        T0 = (1, 'K'),
        Tmin = (298, 'K'),
        Tmax = (2500, 'K'),
        comment = 'Fitted to 50 data points; dA = *|/ 8.03768, dn = +|- 0.273815, dEa = +|- 1.49009 kJ/mol',
    ),
)

#   ======= =========== =========== =========== ===============
#   Temp.   k (TST)     Tunneling   k (TST+T)   Units
#   ======= =========== =========== =========== ===============
#    2500 K   2.285e+10     1.02458   2.341e+10 s^-1
#    2172.4 K   4.391e+09     1.03227   4.533e+09 s^-1
#    1920.71 K   8.522e+08     1.04107   8.872e+08 s^-1
#    1721.28 K   1.669e+08     1.05102   1.755e+08 s^-1
#    1559.38 K   3.299e+07     1.06216   3.504e+07 s^-1
#    1425.31 K   6.574e+06     1.07453   7.064e+06 s^-1
#    1312.47 K   1.320e+06      1.0882   1.436e+06 s^-1
#    1216.18 K   2.668e+05     1.10321   2.944e+05 s^-1
#    1133.06 K   5.431e+04     1.11965   6.080e+04 s^-1
#    1060.58 K   1.112e+04     1.13758   1.265e+04 s^-1
#    996.805 K   2.289e+03     1.15708   2.649e+03 s^-1
#    940.269 K   4.737e+02     1.17826   5.581e+02 s^-1
#    889.802 K   9.849e+01     1.20123   1.183e+02 s^-1
#    844.476 K   2.057e+01     1.22609   2.522e+01 s^-1
#    803.544 K   4.313e+00     1.25298   5.404e+00 s^-1
#    766.397 K   9.076e-01     1.28205   1.164e+00 s^-1
#    732.532 K   1.917e-01     1.31346   2.518e-01 s^-1
#    701.534 K   4.061e-02     1.34741   5.472e-02 s^-1
#    673.052 K   8.631e-03     1.38408   1.195e-02 s^-1
#    646.793 K   1.839e-03     1.42373   2.619e-03 s^-1
#    622.506 K   3.930e-04     1.46661   5.763e-04 s^-1
#    599.977 K   8.417e-05     1.51301   1.273e-04 s^-1
#    579.022 K   1.807e-05     1.56328   2.824e-05 s^-1
#    559.481 K   3.887e-06     1.61778   6.288e-06 s^-1
#    541.216 K   8.378e-07     1.67696   1.405e-06 s^-1
#    524.106 K   1.809e-07      1.7413   3.151e-07 s^-1
#    508.044 K   3.914e-08     1.81137   7.090e-08 s^-1
#    492.938 K   8.482e-09     1.88781   1.601e-08 s^-1
#    478.704 K   1.841e-09     1.97137   3.629e-09 s^-1
#    465.269 K   4.001e-10     2.06291   8.254e-10 s^-1
#    452.568 K   8.709e-11     2.16344   1.884e-10 s^-1
#    440.541 K   1.898e-11     2.27413   4.317e-11 s^-1
#    429.137 K   4.142e-12     2.39636   9.927e-12 s^-1
#    418.309 K   9.050e-13     2.53176   2.291e-12 s^-1
#    408.014 K   1.980e-13     2.68224   5.310e-13 s^-1
#    398.213 K   4.334e-14     2.85013   1.235e-13 s^-1
#    388.872 K   9.500e-15     3.03817   2.886e-14 s^-1
#    379.96 K   2.084e-15     3.24972   6.773e-15 s^-1
#    371.446 K   4.577e-16     3.48883   1.597e-15 s^-1
#    363.306 K   1.006e-16     3.76052   3.783e-16 s^-1
#    355.515 K   2.213e-17     4.07093   9.008e-17 s^-1
#    348.051 K   4.871e-18     4.42776   2.157e-17 s^-1
#    340.894 K   1.073e-18     4.84066   5.195e-18 s^-1
#    334.026 K   2.366e-19      5.3219   1.259e-18 s^-1
#    327.428 K   5.220e-20     5.88714   3.073e-19 s^-1
#    321.087 K   1.152e-20     6.55668   7.555e-20 s^-1
#    314.986 K   2.546e-21     7.35702   1.873e-20 s^-1
#    309.113 K   5.626e-22     8.32319   4.683e-21 s^-1
#    303.455 K   1.244e-22     9.50195   1.182e-21 s^-1
#     298 K   2.753e-23     10.9565   3.017e-22 s^-1
#   ======= =========== =========== =========== ===============


#   ======= ============ =========== ============ ============= =========
#   Temp.    Kc (eq)        Units     k_rev (TST) k_rev (TST+T)   Units
#   ======= ============ =========== ============ ============= =========
#    2500 K   2.464e+01   mol/cm^3    9.274e+08     9.502e+08      cm^3/(mol*s)
#    2172.4 K   2.003e+01   mol/cm^3    2.192e+08     2.262e+08      cm^3/(mol*s)
#    1920.71 K   1.572e+01   mol/cm^3    5.421e+07     5.644e+07      cm^3/(mol*s)
#    1721.28 K   1.201e+01   mol/cm^3    1.390e+07     1.460e+07      cm^3/(mol*s)
#    1559.38 K   9.004e+00   mol/cm^3    3.664e+06     3.892e+06      cm^3/(mol*s)
#    1425.31 K   6.649e+00   mol/cm^3    9.886e+05     1.062e+06      cm^3/(mol*s)
#    1312.47 K   4.855e+00   mol/cm^3    2.719e+05     2.958e+05      cm^3/(mol*s)
#    1216.18 K   3.514e+00   mol/cm^3    7.594e+04     8.378e+04      cm^3/(mol*s)
#    1133.06 K   2.526e+00   mol/cm^3    2.150e+04     2.407e+04      cm^3/(mol*s)
#    1060.58 K   1.807e+00   mol/cm^3    6.152e+03     6.999e+03      cm^3/(mol*s)
#    996.805 K   1.288e+00   mol/cm^3    1.778e+03     2.057e+03      cm^3/(mol*s)
#    940.269 K   9.147e-01   mol/cm^3    5.179e+02     6.102e+02      cm^3/(mol*s)
#    889.802 K   6.484e-01   mol/cm^3    1.519e+02     1.825e+02      cm^3/(mol*s)
#    844.476 K   4.588e-01   mol/cm^3    4.482e+01     5.496e+01      cm^3/(mol*s)
#    803.544 K   3.244e-01   mol/cm^3    1.330e+01     1.666e+01      cm^3/(mol*s)
#    766.397 K   2.291e-01   mol/cm^3    3.961e+00     5.079e+00      cm^3/(mol*s)
#    732.532 K   1.618e-01   mol/cm^3    1.185e+00     1.556e+00      cm^3/(mol*s)
#    701.534 K   1.142e-01   mol/cm^3    3.556e-01     4.792e-01      cm^3/(mol*s)
#    673.052 K   8.062e-02   mol/cm^3    1.071e-01     1.482e-01      cm^3/(mol*s)
#    646.793 K   5.693e-02   mol/cm^3    3.231e-02     4.600e-02      cm^3/(mol*s)
#    622.506 K   4.021e-02   mol/cm^3    9.772e-03     1.433e-02      cm^3/(mol*s)
#    599.977 K   2.842e-02   mol/cm^3    2.962e-03     4.481e-03      cm^3/(mol*s)
#    579.022 K   2.009e-02   mol/cm^3    8.991e-04     1.406e-03      cm^3/(mol*s)
#    559.481 K   1.422e-02   mol/cm^3    2.734e-04     4.423e-04      cm^3/(mol*s)
#    541.216 K   1.007e-02   mol/cm^3    8.323e-05     1.396e-04      cm^3/(mol*s)
#    524.106 K   7.132e-03   mol/cm^3    2.537e-05     4.418e-05      cm^3/(mol*s)
#    508.044 K   5.057e-03   mol/cm^3    7.741e-06     1.402e-05      cm^3/(mol*s)
#    492.938 K   3.588e-03   mol/cm^3    2.364e-06     4.462e-06      cm^3/(mol*s)
#    478.704 K   2.548e-03   mol/cm^3    7.224e-07     1.424e-06      cm^3/(mol*s)
#    465.269 K   1.811e-03   mol/cm^3    2.209e-07     4.557e-07      cm^3/(mol*s)
#    452.568 K   1.288e-03   mol/cm^3    6.760e-08     1.462e-07      cm^3/(mol*s)
#    440.541 K   9.173e-04   mol/cm^3    2.069e-08     4.706e-08      cm^3/(mol*s)
#    429.137 K   6.537e-04   mol/cm^3    6.337e-09     1.519e-08      cm^3/(mol*s)
#    418.309 K   4.662e-04   mol/cm^3    1.941e-09     4.915e-09      cm^3/(mol*s)
#    408.014 K   3.327e-04   mol/cm^3    5.949e-10     1.596e-09      cm^3/(mol*s)
#    398.213 K   2.377e-04   mol/cm^3    1.823e-10     5.197e-10      cm^3/(mol*s)
#    388.872 K   1.699e-04   mol/cm^3    5.590e-11     1.698e-10      cm^3/(mol*s)
#    379.96 K   1.216e-04   mol/cm^3    1.714e-11     5.570e-11      cm^3/(mol*s)
#    371.446 K   8.708e-05   mol/cm^3    5.256e-12     1.834e-11      cm^3/(mol*s)
#    363.306 K   6.241e-05   mol/cm^3    1.612e-12     6.061e-12      cm^3/(mol*s)
#    355.515 K   4.477e-05   mol/cm^3    4.943e-13     2.012e-12      cm^3/(mol*s)
#    348.051 K   3.213e-05   mol/cm^3    1.516e-13     6.712e-13      cm^3/(mol*s)
#    340.894 K   2.308e-05   mol/cm^3    4.649e-14     2.250e-13      cm^3/(mol*s)
#    334.026 K   1.660e-05   mol/cm^3    1.426e-14     7.587e-14      cm^3/(mol*s)
#    327.428 K   1.194e-05   mol/cm^3    4.372e-15     2.574e-14      cm^3/(mol*s)
#    321.087 K   8.596e-06   mol/cm^3    1.341e-15     8.790e-15      cm^3/(mol*s)
#    314.986 K   6.193e-06   mol/cm^3    4.110e-16     3.024e-15      cm^3/(mol*s)
#    309.113 K   4.465e-06   mol/cm^3    1.260e-16     1.049e-15      cm^3/(mol*s)
#    303.455 K   3.221e-06   mol/cm^3    3.863e-17     3.671e-16      cm^3/(mol*s)
#     298 K   2.325e-06   mol/cm^3    1.184e-17     1.297e-16      cm^3/(mol*s)
#   ======= ============ =========== ============ ============= =========


# k_rev (TST) = Arrhenius(A=(1.92504e+06,'cm^3/(mol*s)'), n=1.73533, Ea=(156.695,'kJ/mol'), T0=(1,'K'), Tmin=(298,'K'), Tmax=(2500,'K'), comment="""Fitted to 50 data points; dA = *|/ 1.42911, dn = +|- 0.0469091, dEa = +|- 0.255278 kJ/mol""") 
# k_rev (TST+T) = Arrhenius(A=(111.755,'cm^3/(mol*s)'), n=2.93735, Ea=(144.344,'kJ/mol'), T0=(1,'K'), Tmin=(298,'K'), Tmax=(2500,'K'), comment="""Fitted to 50 data points; dA = *|/ 1.62943, dn = +|- 0.0641435, dEa = +|- 0.349067 kJ/mol""") 

# kinetics fitted using the modified three-parameter Arrhenius equation k = A * (T/T0)^n * exp(-Ea/RT) 
kinetics(
    label = 'NH3O <=> H2 + HNO',
    kinetics = Arrhenius(
        A = (220617, 's^-1'),
        n = 2.69894,
        Ea = (192.2, 'kJ/mol'),
        T0 = (1, 'K'),
        Tmin = (298, 'K'),
        Tmax = (2500, 'K'),
        comment = 'Fitted to 50 data points; dA = *|/ 2.49948, dn = +|- 0.120355, dEa = +|- 0.654967 kJ/mol',
    ),
)

#Thermo used:  

#Path Reactions used:  
#H + H2NO <=> NH2OH
#Fitted to 35 data points; dA = *|/ 1.17496, dn = +|- 0.0207886, dEa = +|- 0.129354 kJ/mol
#H + H2NO <=> NH3O
#Fitted to 35 data points; dA = *|/ 1.35914, dn = +|- 0.0395638, dEa = +|- 0.246179 kJ/mol
#NH2OH <=> OH + NH2
#
#NH2OH <=> NH3O
#Fitted to 50 data points; dA = *|/ 8.03768, dn = +|- 0.273815, dEa = +|- 1.49009 kJ/mol
#NH3O <=> HNO + H2
#Fitted to 50 data points; dA = *|/ 2.49948, dn = +|- 0.120355, dEa = +|- 0.654967 kJ/mol

#   =========== =========== =========== =========== =========== =========== 
#         T / P   1.000e-02   1.000e-01   1.000e+00   1.000e+01   1.000e+02
#   =========== =========== =========== =========== =========== =========== 
#          2000   4.092e+06   3.554e+07   3.002e+08   2.381e+09   1.587e+10
#          1320   8.729e+05   6.449e+06   4.604e+07   3.069e+08   1.667e+09
#       985.075   1.283e+05   7.780e+05   4.529e+06   2.456e+07   1.081e+08
#       785.714   1.777e+04   8.753e+04   4.107e+05   1.790e+06   6.361e+06
#       653.465   2.589e+03   1.031e+04   3.883e+04   1.351e+05   3.834e+05
#       559.322   3.527e+02   1.140e+03   3.462e+03   9.688e+03   2.247e+04
#       488.889   4.876e+01   1.286e+02   3.165e+02   7.174e+02   1.376e+03
#       434.211   7.707e+00   1.655e+01   3.301e+01   6.047e+01   9.476e+01
#       390.533   1.106e+00   1.980e+00   3.286e+00   5.032e+00   6.826e+00
#       354.839   1.817e-01   2.734e-01   3.825e-01   4.977e-01   5.905e-01
#       325.123   3.130e-02   4.082e-02   4.991e-02   5.759e-02   6.261e-02
#           300   6.059e-03   7.071e-03   7.847e-03   8.373e-03   8.652e-03
#   =========== =========== =========== =========== =========== =========== 
pdepreaction(
    reactants = ['NH3O'],
    products = ['NH2OH'],
    kinetics = PDepArrhenius(
        pressures = ([0.01, 0.1, 1, 10, 100], 'bar'),
        arrhenius = [
            Arrhenius(
                A = (5.69246e+07, 's^-1'),
                n = 0.156748,
                Ea = (60.1489, 'kJ/mol'),
                T0 = (1, 'K'),
                Tmin = (300, 'K'),
                Tmax = (2000, 'K'),
                comment = 'Fitted to 12 data points; dA = *|/ 12.7702, dn = +|- 0.335734, dEa = +|- 1.78161 kJ/mol',
            ),
            Arrhenius(
                A = (2.28618e+08, 's^-1'),
                n = 0.306412,
                Ea = (65.5391, 'kJ/mol'),
                T0 = (1, 'K'),
                Tmin = (300, 'K'),
                Tmax = (2000, 'K'),
                comment = 'Fitted to 12 data points; dA = *|/ 23.4582, dn = +|- 0.415889, dEa = +|- 2.20696 kJ/mol',
            ),
            Arrhenius(
                A = (5.89548e+08, 's^-1'),
                n = 0.510305,
                Ea = (70.7569, 'kJ/mol'),
                T0 = (1, 'K'),
                Tmin = (300, 'K'),
                Tmax = (2000, 'K'),
                comment = 'Fitted to 12 data points; dA = *|/ 48.868, dn = +|- 0.512625, dEa = +|- 2.7203 kJ/mol',
            ),
            Arrhenius(
                A = (8.62382e+08, 's^-1'),
                n = 0.778591,
                Ea = (75.6107, 'kJ/mol'),
                T0 = (1, 'K'),
                Tmin = (300, 'K'),
                Tmax = (2000, 'K'),
                comment = 'Fitted to 12 data points; dA = *|/ 116.044, dn = +|- 0.62662, dEa = +|- 3.32522 kJ/mol',
            ),
            Arrhenius(
                A = (2.3264e+08, 's^-1'),
                n = 1.2354,
                Ea = (79.0158, 'kJ/mol'),
                T0 = (1, 'K'),
                Tmin = (300, 'K'),
                Tmax = (2000, 'K'),
                comment = 'Fitted to 12 data points; dA = *|/ 291.406, dn = +|- 0.747983, dEa = +|- 3.96925 kJ/mol',
            ),
        ],
    ),
)

#   =========== =========== =========== =========== =========== =========== 
#         T / P   1.000e-02   1.000e-01   1.000e+00   1.000e+01   1.000e+02
#   =========== =========== =========== =========== =========== =========== 
#          2000   1.277e+06   1.277e+07   1.277e+08   1.277e+09   1.272e+10
#          1320   1.489e+06   1.489e+07   1.489e+08   1.488e+09   1.483e+10
#       985.075   1.740e+06   1.740e+07   1.740e+08   1.739e+09   1.733e+10
#       785.714   1.707e+06   1.707e+07   1.707e+08   1.706e+09   1.699e+10
#       653.465   1.608e+06   1.608e+07   1.608e+08   1.607e+09   1.600e+10
#       559.322   1.314e+06   1.314e+07   1.314e+08   1.314e+09   1.308e+10
#       488.889   1.193e+06   1.193e+07   1.193e+08   1.193e+09   1.187e+10
#       434.211   8.692e+05   8.692e+06   8.692e+07   8.687e+08   8.645e+09
#       390.533   8.462e+05   8.461e+06   8.461e+07   8.457e+08   8.413e+09
#       354.839   7.084e+05   7.084e+06   7.084e+07   7.080e+08   7.041e+09
#       325.123   4.682e+05   4.682e+06   4.682e+07   4.680e+08   4.658e+09
#           300   3.960e+05   3.960e+06   3.959e+07   3.958e+08   3.939e+09
#   =========== =========== =========== =========== =========== =========== 
pdepreaction(
    reactants = ['H', 'H2NO'],
    products = ['NH2OH'],
    kinetics = PDepArrhenius(
        pressures = ([0.01, 0.1, 1, 10, 100], 'bar'),
        arrhenius = [
            Arrhenius(
                A = (1.9327e+11, 'cm^3/(mol*s)'),
                n = -1.48222,
                Ea = (11.5631, 'kJ/mol'),
                T0 = (1, 'K'),
                Tmin = (300, 'K'),
                Tmax = (2000, 'K'),
                comment = 'Fitted to 12 data points; dA = *|/ 2.88206, dn = +|- 0.139521, dEa = +|- 0.740384 kJ/mol',
            ),
            Arrhenius(
                A = (1.93268e+12, 'cm^3/(mol*s)'),
                n = -1.48222,
                Ea = (11.5631, 'kJ/mol'),
                T0 = (1, 'K'),
                Tmin = (300, 'K'),
                Tmax = (2000, 'K'),
                comment = 'Fitted to 12 data points; dA = *|/ 2.88205, dn = +|- 0.139521, dEa = +|- 0.740382 kJ/mol',
            ),
            Arrhenius(
                A = (1.93249e+13, 'cm^3/(mol*s)'),
                n = -1.48221,
                Ea = (11.5631, 'kJ/mol'),
                T0 = (1, 'K'),
                Tmin = (300, 'K'),
                Tmax = (2000, 'K'),
                comment = 'Fitted to 12 data points; dA = *|/ 2.88195, dn = +|- 0.139516, dEa = +|- 0.740359 kJ/mol',
            ),
            Arrhenius(
                A = (1.93053e+14, 'cm^3/(mol*s)'),
                n = -1.48212,
                Ea = (11.5631, 'kJ/mol'),
                T0 = (1, 'K'),
                Tmin = (300, 'K'),
                Tmax = (2000, 'K'),
                comment = 'Fitted to 12 data points; dA = *|/ 2.881, dn = +|- 0.139473, dEa = +|- 0.740128 kJ/mol',
            ),
            Arrhenius(
                A = (1.91087e+15, 'cm^3/(mol*s)'),
                n = -1.4812,
                Ea = (11.5633, 'kJ/mol'),
                T0 = (1, 'K'),
                Tmin = (300, 'K'),
                Tmax = (2000, 'K'),
                comment = 'Fitted to 12 data points; dA = *|/ 2.87162, dn = +|- 0.139043, dEa = +|- 0.737846 kJ/mol',
            ),
        ],
    ),
)

#   =========== =========== =========== =========== =========== =========== 
#         T / P   1.000e-02   1.000e-01   1.000e+00   1.000e+01   1.000e+02
#   =========== =========== =========== =========== =========== =========== 
#          2000   1.762e+03   1.530e+04   1.293e+05   1.025e+06   6.835e+06
#          1320   1.366e+01   1.010e+02   7.208e+02   4.805e+03   2.609e+04
#       985.075   7.837e-02   4.754e-01   2.768e+00   1.501e+01   6.608e+01
#       785.714   4.332e-04   2.134e-03   1.001e-02   4.365e-02   1.551e-01
#       653.465   2.529e-06   1.008e-05   3.794e-05   1.320e-04   3.746e-04
#       559.322   1.378e-08   4.455e-08   1.352e-07   3.785e-07   8.780e-07
#       488.889   7.581e-11   1.999e-10   4.921e-10   1.115e-09   2.140e-09
#       434.211   4.745e-13   1.019e-12   2.033e-12   3.723e-12   5.835e-12
#       390.533   2.684e-15   4.805e-15   7.974e-15   1.221e-14   1.657e-14
#       354.839   1.731e-17   2.605e-17   3.644e-17   4.742e-17   5.627e-17
#       325.123   1.167e-19   1.522e-19   1.861e-19   2.147e-19   2.334e-19
#           300   8.815e-22   1.029e-21   1.142e-21   1.218e-21   1.259e-21
#   =========== =========== =========== =========== =========== =========== 
#   pdepreaction(
#       reactants = ['NH2OH'],
#       products = ['NH3O'],
#       kinetics = PDepArrhenius(
#           pressures = ([0.01, 0.1, 1, 10, 100], 'bar'),
#           arrhenius = [
#               Arrhenius(
#                   A = (6.99479e+06, 's^-1'),
#                   n = 0.230929,
#                   Ea = (164.099, 'kJ/mol'),
#                   T0 = (1, 'K'),
#                   Tmin = (300, 'K'),
#                   Tmax = (2000, 'K'),
#                   comment = 'Fitted to 12 data points; dA = *|/ 9.02561, dn = +|- 0.28999, dEa = +|- 1.53886 kJ/mol',
#               ),
#               Arrhenius(
#                   A = (2.80922e+07, 's^-1'),
#                   n = 0.380593,
#                   Ea = (169.49, 'kJ/mol'),
#                   T0 = (1, 'K'),
#                   Tmin = (300, 'K'),
#                   Tmax = (2000, 'K'),
#                   comment = 'Fitted to 12 data points; dA = *|/ 16.6185, dn = +|- 0.370454, dEa = +|- 1.96585 kJ/mol',
#               ),
#               Arrhenius(
#                   A = (7.24425e+07, 's^-1'),
#                   n = 0.584486,
#                   Ea = (174.707, 'kJ/mol'),
#                   T0 = (1, 'K'),
#                   Tmin = (300, 'K'),
#                   Tmax = (2000, 'K'),
#                   comment = 'Fitted to 12 data points; dA = *|/ 34.7214, dn = +|- 0.467576, dEa = +|- 2.48124 kJ/mol',
#               ),
#               Arrhenius(
#                   A = (1.05968e+08, 's^-1'),
#                   n = 0.852771,
#                   Ea = (179.561, 'kJ/mol'),
#                   T0 = (1, 'K'),
#                   Tmin = (300, 'K'),
#                   Tmax = (2000, 'K'),
#                   comment = 'Fitted to 12 data points; dA = *|/ 82.6937, dn = +|- 0.581959, dEa = +|- 3.08823 kJ/mol',
#               ),
#               Arrhenius(
#                   A = (2.85864e+07, 's^-1'),
#                   n = 1.30958,
#                   Ea = (182.966, 'kJ/mol'),
#                   T0 = (1, 'K'),
#                   Tmin = (300, 'K'),
#                   Tmax = (2000, 'K'),
#                   comment = 'Fitted to 12 data points; dA = *|/ 208.026, dn = +|- 0.703556, dEa = +|- 3.7335 kJ/mol',
#               ),
#           ],
#       ),
#   )
#   
#   #   =========== =========== =========== =========== =========== =========== 
#         T / P   1.000e-02   1.000e-01   1.000e+00   1.000e+01   1.000e+02
#   =========== =========== =========== =========== =========== =========== 
#          2000   6.239e+06   6.239e+07   6.238e+08   6.235e+09   6.205e+10
#          1320   3.374e+06   3.374e+07   3.374e+08   3.372e+09   3.359e+10
#       985.075   2.098e+06   2.098e+07   2.098e+08   2.098e+09   2.091e+10
#       785.714   1.470e+06   1.470e+07   1.469e+08   1.469e+09   1.464e+10
#       653.465   1.233e+06   1.233e+07   1.232e+08   1.232e+09   1.228e+10
#       559.322   9.645e+05   9.645e+06   9.645e+07   9.641e+08   9.609e+09
#       488.889   7.727e+05   7.727e+06   7.727e+07   7.724e+08   7.698e+09
#       434.211   8.245e+05   8.245e+06   8.244e+07   8.241e+08   8.204e+09
#       390.533   6.159e+05   6.159e+06   6.158e+07   6.156e+08   6.131e+09
#       354.839   5.991e+05   5.991e+06   5.991e+07   5.988e+08   5.960e+09
#       325.123   4.759e+05   4.759e+06   4.758e+07   4.756e+08   4.735e+09
#           300   3.989e+05   3.989e+06   3.989e+07   3.987e+08   3.969e+09
#   =========== =========== =========== =========== =========== =========== 
pdepreaction(
    reactants = ['H', 'H2NO'],
    products = ['NH3O'],
    kinetics = PDepArrhenius(
        pressures = ([0.01, 0.1, 1, 10, 100], 'bar'),
        arrhenius = [
            Arrhenius(
                A = (56.1346, 'cm^3/(mol*s)'),
                n = 1.51933,
                Ea = (
                    -0.753697,
                    'kJ/mol',
                ),
                T0 = (1, 'K'),
                Tmin = (300, 'K'),
                Tmax = (2000, 'K'),
                comment = 'Fitted to 12 data points; dA = *|/ 3.36573, dn = +|- 0.15997, dEa = +|- 0.848899 kJ/mol',
            ),
            Arrhenius(
                A = (561.357, 'cm^3/(mol*s)'),
                n = 1.51933,
                Ea = (
                    -0.753679,
                    'kJ/mol',
                ),
                T0 = (1, 'K'),
                Tmin = (300, 'K'),
                Tmax = (2000, 'K'),
                comment = 'Fitted to 12 data points; dA = *|/ 3.36571, dn = +|- 0.15997, dEa = +|- 0.848895 kJ/mol',
            ),
            Arrhenius(
                A = (5614.73, 'cm^3/(mol*s)'),
                n = 1.51929,
                Ea = (
                    -0.753493,
                    'kJ/mol',
                ),
                T0 = (1, 'K'),
                Tmin = (300, 'K'),
                Tmax = (2000, 'K'),
                comment = 'Fitted to 12 data points; dA = *|/ 3.36555, dn = +|- 0.159963, dEa = +|- 0.848862 kJ/mol',
            ),
            Arrhenius(
                A = (56262.9, 'cm^3/(mol*s)'),
                n = 1.51898,
                Ea = (
                    -0.751641,
                    'kJ/mol',
                ),
                T0 = (1, 'K'),
                Tmin = (300, 'K'),
                Tmax = (2000, 'K'),
                comment = 'Fitted to 12 data points; dA = *|/ 3.36396, dn = +|- 0.159901, dEa = +|- 0.84853 kJ/mol',
            ),
            Arrhenius(
                A = (574240, 'cm^3/(mol*s)'),
                n = 1.51582,
                Ea = (
                    -0.733227,
                    'kJ/mol',
                ),
                T0 = (1, 'K'),
                Tmin = (300, 'K'),
                Tmax = (2000, 'K'),
                comment = 'Fitted to 12 data points; dA = *|/ 3.34812, dn = +|- 0.159279, dEa = +|- 0.84523 kJ/mol',
            ),
        ],
    ),
)

#   =========== =========== =========== =========== =========== =========== 
#         T / P   1.000e-02   1.000e-01   1.000e+00   1.000e+01   1.000e+02
#   =========== =========== =========== =========== =========== =========== 
#          2000   8.131e-02   8.130e-01   8.130e+00   8.127e+01   8.098e+02
#          1320   3.371e-06   3.371e-05   3.371e-04   3.370e-03   3.359e-02
#       985.075   1.403e-10   1.403e-09   1.403e-08   1.403e-07   1.398e-06
#       785.714   4.984e-15   4.984e-14   4.984e-13   4.982e-12   4.963e-11
#       653.465   1.733e-19   1.732e-18   1.732e-17   1.732e-16   1.724e-15
#       559.322   5.318e-24   5.318e-23   5.318e-22   5.316e-21   5.292e-20
#       488.889   1.843e-28   1.843e-27   1.843e-26   1.842e-25   1.833e-24
#       434.211   5.197e-33   5.197e-32   5.197e-31   5.194e-30   5.168e-29
#       390.533   1.985e-37   1.985e-36   1.984e-35   1.983e-34   1.973e-33
#       354.839   6.596e-42   6.596e-41   6.596e-40   6.592e-39   6.556e-38
#       325.123   1.750e-46   1.750e-45   1.750e-44   1.749e-43   1.741e-42
#           300   5.998e-51   5.998e-50   5.997e-49   5.995e-48   5.967e-47
#   =========== =========== =========== =========== =========== =========== 
#   pdepreaction(
#       reactants = ['NH2OH'],
#       products = ['H', 'H2NO'],
#       kinetics = PDepArrhenius(
#           pressures = ([0.01, 0.1, 1, 10, 100], 'bar'),
#           arrhenius = [
#               Arrhenius(
#                   A = (8.50619e+10, 's^-1'),
#                   n = -0.971144,
#                   Ea = (337.465, 'kJ/mol'),
#                   T0 = (1, 'K'),
#                   Tmin = (300, 'K'),
#                   Tmax = (2000, 'K'),
#                   comment = 'Fitted to 12 data points; dA = *|/ 2.8619, dn = +|- 0.138596, dEa = +|- 0.735475 kJ/mol',
#               ),
#               Arrhenius(
#                   A = (8.5061e+11, 's^-1'),
#                   n = -0.971143,
#                   Ea = (337.465, 'kJ/mol'),
#                   T0 = (1, 'K'),
#                   Tmin = (300, 'K'),
#                   Tmax = (2000, 'K'),
#                   comment = 'Fitted to 12 data points; dA = *|/ 2.8619, dn = +|- 0.138596, dEa = +|- 0.735474 kJ/mol',
#               ),
#               Arrhenius(
#                   A = (8.50524e+12, 's^-1'),
#                   n = -0.971134,
#                   Ea = (337.465, 'kJ/mol'),
#                   T0 = (1, 'K'),
#                   Tmin = (300, 'K'),
#                   Tmax = (2000, 'K'),
#                   comment = 'Fitted to 12 data points; dA = *|/ 2.86186, dn = +|- 0.138594, dEa = +|- 0.735464 kJ/mol',
#               ),
#               Arrhenius(
#                   A = (8.49662e+13, 's^-1'),
#                   n = -0.971043,
#                   Ea = (337.465, 'kJ/mol'),
#                   T0 = (1, 'K'),
#                   Tmin = (300, 'K'),
#                   Tmax = (2000, 'K'),
#                   comment = 'Fitted to 12 data points; dA = *|/ 2.86146, dn = +|- 0.138576, dEa = +|- 0.735368 kJ/mol',
#               ),
#               Arrhenius(
#                   A = (8.41008e+14, 's^-1'),
#                   n = -0.970122,
#                   Ea = (337.466, 'kJ/mol'),
#                   T0 = (1, 'K'),
#                   Tmin = (300, 'K'),
#                   Tmax = (2000, 'K'),
#                   comment = 'Fitted to 12 data points; dA = *|/ 2.85759, dn = +|- 0.138397, dEa = +|- 0.73442 kJ/mol',
#               ),
#           ],
#       ),
#   )
#   
#   #   =========== =========== =========== =========== =========== =========== 
#         T / P   1.000e-02   1.000e-01   1.000e+00   1.000e+01   1.000e+02
#   =========== =========== =========== =========== =========== =========== 
#          2000   9.223e+02   9.223e+03   9.222e+04   9.218e+05   9.174e+06
#          1320   4.880e-01   4.880e+00   4.880e+01   4.878e+02   4.859e+03
#       985.075   2.770e-04   2.770e-03   2.770e-02   2.769e-01   2.759e+00
#       785.714   1.760e-07   1.760e-06   1.760e-05   1.760e-04   1.754e-03
#       653.465   1.359e-10   1.359e-09   1.359e-08   1.359e-07   1.354e-06
#       559.322   9.991e-14   9.991e-13   9.991e-12   9.987e-11   9.953e-10
#       488.889   7.675e-17   7.675e-16   7.674e-15   7.672e-14   7.646e-13
#       434.211   8.006e-20   8.006e-19   8.006e-18   8.002e-17   7.967e-16
#       390.533   5.952e-23   5.952e-22   5.951e-21   5.949e-20   5.925e-19
#       354.839   5.855e-26   5.855e-25   5.855e-24   5.852e-23   5.824e-22
#       325.123   4.770e-29   4.770e-28   4.770e-27   4.768e-26   4.746e-25
#           300   4.154e-32   4.154e-31   4.154e-30   4.152e-29   4.133e-28
#   =========== =========== =========== =========== =========== =========== 
#   pdepreaction(
#       reactants = ['NH3O'],
#       products = ['H', 'H2NO'],
#       kinetics = PDepArrhenius(
#           pressures = ([0.01, 0.1, 1, 10, 100], 'bar'),
#           arrhenius = [
#               Arrhenius(
#                   A = (201.06, 's^-1'),
#                   n = 1.95623,
#                   Ea = (221.198, 'kJ/mol'),
#                   T0 = (1, 'K'),
#                   Tmin = (300, 'K'),
#                   Tmax = (2000, 'K'),
#                   comment = 'Fitted to 12 data points; dA = *|/ 2.98998, dn = +|- 0.144367, dEa = +|- 0.766097 kJ/mol',
#               ),
#               Arrhenius(
#                   A = (2010.64, 's^-1'),
#                   n = 1.95622,
#                   Ea = (221.198, 'kJ/mol'),
#                   T0 = (1, 'K'),
#                   Tmin = (300, 'K'),
#                   Tmax = (2000, 'K'),
#                   comment = 'Fitted to 12 data points; dA = *|/ 2.98997, dn = +|- 0.144366, dEa = +|- 0.766095 kJ/mol',
#               ),
#               Arrhenius(
#                   A = (20110.6, 's^-1'),
#                   n = 1.95619,
#                   Ea = (221.198, 'kJ/mol'),
#                   T0 = (1, 'K'),
#                   Tmin = (300, 'K'),
#                   Tmax = (2000, 'K'),
#                   comment = 'Fitted to 12 data points; dA = *|/ 2.98987, dn = +|- 0.144362, dEa = +|- 0.766071 kJ/mol',
#               ),
#               Arrhenius(
#                   A = (201520, 's^-1'),
#                   n = 1.95587,
#                   Ea = (221.2, 'kJ/mol'),
#                   T0 = (1, 'K'),
#                   Tmin = (300, 'K'),
#                   Tmax = (2000, 'K'),
#                   comment = 'Fitted to 12 data points; dA = *|/ 2.98887, dn = +|- 0.144318, dEa = +|- 0.765838 kJ/mol',
#               ),
#               Arrhenius(
#                   A = (2.05679e+06, 's^-1'),
#                   n = 1.95272,
#                   Ea = (221.218, 'kJ/mol'),
#                   T0 = (1, 'K'),
#                   Tmin = (300, 'K'),
#                   Tmax = (2000, 'K'),
#                   comment = 'Fitted to 12 data points; dA = *|/ 2.97895, dn = +|- 0.14388, dEa = +|- 0.763513 kJ/mol',
#               ),
#           ],
#       ),
#   )
#   
#   #   =========== =========== =========== =========== =========== =========== 
#         T / P   1.000e-02   1.000e-01   1.000e+00   1.000e+01   1.000e+02
#   =========== =========== =========== =========== =========== =========== 
#          2000   1.091e+03   1.091e+04   1.088e+05   1.065e+06   9.100e+06
#          1320   1.600e+00   1.599e+01   1.595e+02   1.554e+03   1.270e+04
#       985.075   1.304e-03   1.304e-02   1.299e-01   1.256e+00   9.722e+00
#       785.714   6.298e-07   6.296e-06   6.274e-05   6.060e-04   4.624e-03
#       653.465   2.906e-10   2.905e-09   2.892e-08   2.773e-07   2.011e-06
#       559.322   9.081e-14   9.077e-13   9.042e-12   8.708e-11   6.458e-10
#       488.889   3.419e-17   3.417e-16   3.402e-15   3.256e-14   2.313e-13
#       434.211   7.810e-21   7.808e-20   7.782e-19   7.532e-18   5.747e-17
#       390.533   3.058e-24   3.057e-23   3.043e-22   2.916e-21   2.077e-20
#       354.839   8.651e-28   8.647e-27   8.610e-26   8.258e-25   5.912e-24
#       325.123   1.768e-31   1.767e-30   1.762e-29   1.709e-28   1.325e-27
#           300   4.957e-35   4.956e-34   4.941e-33   4.795e-32   3.714e-31
#   =========== =========== =========== =========== =========== =========== 
pdepreaction(
    reactants = ['NH2OH'],
    products = ['OH', 'NH2'],
    kinetics = PDepArrhenius(
        pressures = ([0.01, 0.1, 1, 10, 100], 'bar'),
        arrhenius = [
            Arrhenius(
                A = (3.9637e+27, 's^-1'),
                n = -5.20863,
                Ea = (281.511, 'kJ/mol'),
                T0 = (1, 'K'),
                Tmin = (300, 'K'),
                Tmax = (2000, 'K'),
                comment = 'Fitted to 12 data points; dA = *|/ 5.59762, dn = +|- 0.227022, dEa = +|- 1.20471 kJ/mol',
            ),
            Arrhenius(
                A = (3.95143e+28, 's^-1'),
                n = -5.20826,
                Ea = (281.509, 'kJ/mol'),
                T0 = (1, 'K'),
                Tmin = (300, 'K'),
                Tmax = (2000, 'K'),
                comment = 'Fitted to 12 data points; dA = *|/ 5.59454, dn = +|- 0.226949, dEa = +|- 1.20433 kJ/mol',
            ),
            Arrhenius(
                A = (3.83122e+29, 's^-1'),
                n = -5.20459,
                Ea = (281.492, 'kJ/mol'),
                T0 = (1, 'K'),
                Tmin = (300, 'K'),
                Tmax = (2000, 'K'),
                comment = 'Fitted to 12 data points; dA = *|/ 5.56398, dn = +|- 0.226227, dEa = +|- 1.2005 kJ/mol',
            ),
            Arrhenius(
                A = (2.84223e+30, 's^-1'),
                n = -5.16907,
                Ea = (281.333, 'kJ/mol'),
                T0 = (1, 'K'),
                Tmin = (300, 'K'),
                Tmax = (2000, 'K'),
                comment = 'Fitted to 12 data points; dA = *|/ 5.28532, dn = +|- 0.219455, dEa = +|- 1.16456 kJ/mol',
            ),
            Arrhenius(
                A = (2.97237e+30, 's^-1'),
                n = -4.89945,
                Ea = (280.213, 'kJ/mol'),
                T0 = (1, 'K'),
                Tmin = (300, 'K'),
                Tmax = (2000, 'K'),
                comment = 'Fitted to 12 data points; dA = *|/ 3.9095, dn = +|- 0.179711, dEa = +|- 0.953655 kJ/mol',
            ),
        ],
    ),
)

#   =========== =========== =========== =========== =========== =========== 
#         T / P   1.000e-02   1.000e-01   1.000e+00   1.000e+01   1.000e+02
#   =========== =========== =========== =========== =========== =========== 
#          2000   8.001e+05   7.999e+06   7.982e+07   7.822e+08   6.707e+09
#          1320   1.132e+04   1.132e+05   1.129e+06   1.100e+07   8.990e+07
#       985.075   1.032e+02   1.031e+03   1.028e+04   9.943e+04   7.690e+05
#       785.714   7.436e-01   7.433e+00   7.406e+01   7.154e+02   5.442e+03
#       653.465   6.646e-03   6.643e-02   6.614e-01   6.340e+00   4.569e+01
#       559.322   4.081e-05   4.079e-04   4.063e-03   3.910e-02   2.876e-01
#       488.889   3.139e-07   3.138e-06   3.124e-05   2.987e-04   2.103e-03
#       434.211   2.077e-09   2.076e-08   2.069e-07   1.999e-06   1.502e-05
#       390.533   1.615e-11   1.615e-10   1.607e-09   1.538e-08   1.080e-07
#       354.839   1.221e-13   1.221e-12   1.215e-11   1.163e-10   8.180e-10
#       325.123   5.815e-16   5.813e-15   5.794e-14   5.612e-13   4.270e-12
#           300   3.843e-18   3.842e-17   3.830e-16   3.709e-15   2.820e-14
#   =========== =========== =========== =========== =========== =========== 
pdepreaction(
    reactants = ['NH3O'],
    products = ['OH', 'NH2'],
    kinetics = PDepArrhenius(
        pressures = ([0.01, 0.1, 1, 10, 100], 'bar'),
        arrhenius = [
            Arrhenius(
                A = (3.12482e+16, 's^-1'),
                n = -1.87087,
                Ea = (168.013, 'kJ/mol'),
                T0 = (1, 'K'),
                Tmin = (300, 'K'),
                Tmax = (2000, 'K'),
                comment = 'Fitted to 12 data points; dA = *|/ 5.62548, dn = +|- 0.227676, dEa = +|- 1.20819 kJ/mol',
            ),
            Arrhenius(
                A = (3.11494e+17, 's^-1'),
                n = -1.87049,
                Ea = (168.011, 'kJ/mol'),
                T0 = (1, 'K'),
                Tmin = (300, 'K'),
                Tmax = (2000, 'K'),
                comment = 'Fitted to 12 data points; dA = *|/ 5.62317, dn = +|- 0.227622, dEa = +|- 1.2079 kJ/mol',
            ),
            Arrhenius(
                A = (3.01822e+18, 's^-1'),
                n = -1.86672,
                Ea = (167.995, 'kJ/mol'),
                T0 = (1, 'K'),
                Tmin = (300, 'K'),
                Tmax = (2000, 'K'),
                comment = 'Fitted to 12 data points; dA = *|/ 5.60035, dn = +|- 0.227086, dEa = +|- 1.20505 kJ/mol',
            ),
            Arrhenius(
                A = (2.22631e+19, 's^-1'),
                n = -1.83026,
                Ea = (167.84, 'kJ/mol'),
                T0 = (1, 'K'),
                Tmin = (300, 'K'),
                Tmax = (2000, 'K'),
                comment = 'Fitted to 12 data points; dA = *|/ 5.39244, dn = +|- 0.222099, dEa = +|- 1.17859 kJ/mol',
            ),
            Arrhenius(
                A = (2.29927e+19, 's^-1'),
                n = -1.55806,
                Ea = (166.776, 'kJ/mol'),
                T0 = (1, 'K'),
                Tmin = (300, 'K'),
                Tmax = (2000, 'K'),
                comment = 'Fitted to 12 data points; dA = *|/ 4.39352, dn = +|- 0.195096, dEa = +|- 1.0353 kJ/mol',
            ),
        ],
    ),
)

#   =========== =========== =========== =========== =========== =========== 
#         T / P   1.000e-02   1.000e-01   1.000e+00   1.000e+01   1.000e+02
#   =========== =========== =========== =========== =========== =========== 
#          2000   2.838e+13   2.838e+13   2.838e+13   2.838e+13   2.831e+13
#          1320   1.770e+13   1.770e+13   1.770e+13   1.769e+13   1.765e+13
#       985.075   1.213e+13   1.213e+13   1.213e+13   1.212e+13   1.209e+13
#       785.714   8.810e+12   8.810e+12   8.810e+12   8.807e+12   8.779e+12
#       653.465   6.662e+12   6.662e+12   6.662e+12   6.659e+12   6.634e+12
#       559.322   5.185e+12   5.185e+12   5.185e+12   5.183e+12   5.162e+12
#       488.889   4.123e+12   4.123e+12   4.123e+12   4.121e+12   4.103e+12
#       434.211   3.334e+12   3.333e+12   3.333e+12   3.332e+12   3.317e+12
#       390.533   2.731e+12   2.731e+12   2.731e+12   2.729e+12   2.716e+12
#       354.839   2.261e+12   2.261e+12   2.261e+12   2.260e+12   2.248e+12
#       325.123   1.889e+12   1.889e+12   1.888e+12   1.888e+12   1.879e+12
#           300   1.590e+12   1.590e+12   1.590e+12   1.589e+12   1.582e+12
#   =========== =========== =========== =========== =========== =========== 
pdepreaction(
    reactants = ['H', 'H2NO'],
    products = ['OH', 'NH2'],
    kinetics = PDepArrhenius(
        pressures = ([0.01, 0.1, 1, 10, 100], 'bar'),
        arrhenius = [
            Arrhenius(
                A = (2.71254e+10, 'cm^3/(mol*s)'),
                n = 0.941925,
                Ea = (3.26428, 'kJ/mol'),
                T0 = (1, 'K'),
                Tmin = (300, 'K'),
                Tmax = (2000, 'K'),
                comment = 'Fitted to 12 data points; dA = *|/ 1.11277, dn = +|- 0.014084, dEa = +|- 0.0747383 kJ/mol',
            ),
            Arrhenius(
                A = (2.7125e+10, 'cm^3/(mol*s)'),
                n = 0.941927,
                Ea = (3.26428, 'kJ/mol'),
                T0 = (1, 'K'),
                Tmin = (300, 'K'),
                Tmax = (2000, 'K'),
                comment = 'Fitted to 12 data points; dA = *|/ 1.11277, dn = +|- 0.0140845, dEa = +|- 0.0747407 kJ/mol',
            ),
            Arrhenius(
                A = (2.71207e+10, 'cm^3/(mol*s)'),
                n = 0.941945,
                Ea = (3.26427, 'kJ/mol'),
                T0 = (1, 'K'),
                Tmin = (300, 'K'),
                Tmax = (2000, 'K'),
                comment = 'Fitted to 12 data points; dA = *|/ 1.11281, dn = +|- 0.0140891, dEa = +|- 0.0747652 kJ/mol',
            ),
            Arrhenius(
                A = (2.70779e+10, 'cm^3/(mol*s)'),
                n = 0.942128,
                Ea = (3.26414, 'kJ/mol'),
                T0 = (1, 'K'),
                Tmin = (300, 'K'),
                Tmax = (2000, 'K'),
                comment = 'Fitted to 12 data points; dA = *|/ 1.1132, dn = +|- 0.0141352, dEa = +|- 0.0750101 kJ/mol',
            ),
            Arrhenius(
                A = (2.6653e+10, 'cm^3/(mol*s)'),
                n = 0.943954,
                Ea = (3.26287, 'kJ/mol'),
                T0 = (1, 'K'),
                Tmin = (300, 'K'),
                Tmax = (2000, 'K'),
                comment = 'Fitted to 12 data points; dA = *|/ 1.11715, dn = +|- 0.0146018, dEa = +|- 0.0774859 kJ/mol',
            ),
        ],
    ),
)

#   =========== =========== =========== =========== =========== =========== 
#         T / P   1.000e-02   1.000e-01   1.000e+00   1.000e+01   1.000e+02
#   =========== =========== =========== =========== =========== =========== 
#          2000   6.209e-02   6.207e-01   6.206e+00   6.199e+01   6.124e+02
#          1320   5.858e-06   5.837e-05   5.834e-04   5.827e-03   5.757e-02
#       985.075   5.510e-10   5.340e-09   5.322e-08   5.314e-07   5.243e-06
#       785.714   5.560e-14   4.348e-13   4.226e-12   4.207e-11   4.144e-10
#       653.465   8.014e-18   3.808e-17   3.387e-16   3.338e-15   3.274e-14
#       559.322   2.538e-21   4.741e-21   2.677e-20   2.465e-19   2.395e-18
#       488.889   7.169e-25   9.033e-25   2.768e-24   2.135e-23   2.018e-22
#       434.211   3.177e-28   3.314e-28   4.685e-28   1.833e-27   1.498e-26
#       390.533   8.665e-32   8.817e-32   1.033e-31   2.536e-31   1.668e-30
#       354.839   2.980e-35   2.997e-35   3.162e-35   4.797e-35   1.969e-34
#       325.123   1.152e-38   1.154e-38   1.171e-38   1.339e-38   2.845e-38
#           300   3.907e-42   3.909e-42   3.935e-42   4.183e-42   6.325e-42
#   =========== =========== =========== =========== =========== =========== 
pdepreaction(
    reactants = ['NH2OH'],
    products = ['HNO', 'H2'],
    kinetics = PDepArrhenius(
        pressures = ([0.01, 0.1, 1, 10, 100], 'bar'),
        arrhenius = [
            Arrhenius(
                A = (1.60252e-16, 's^-1'),
                n = 6.33348,
                Ea = (237.046, 'kJ/mol'),
                T0 = (1, 'K'),
                Tmin = (300, 'K'),
                Tmax = (2000, 'K'),
                comment = 'Fitted to 12 data points; dA = *|/ 63.6124, dn = +|- 0.547381, dEa = +|- 2.90473 kJ/mol',
            ),
            Arrhenius(
                A = (1.49349e-17, 's^-1'),
                n = 7.03638,
                Ea = (242.128, 'kJ/mol'),
                T0 = (1, 'K'),
                Tmin = (300, 'K'),
                Tmax = (2000, 'K'),
                comment = 'Fitted to 12 data points; dA = *|/ 2405.64, dn = +|- 1.02621, dEa = +|- 5.44572 kJ/mol',
            ),
            Arrhenius(
                A = (8.07471e-13, 's^-1'),
                n = 6.02982,
                Ea = (256.13, 'kJ/mol'),
                T0 = (1, 'K'),
                Tmin = (300, 'K'),
                Tmax = (2000, 'K'),
                comment = 'Fitted to 12 data points; dA = *|/ 36482, dn = +|- 1.38461, dEa = +|- 7.34756 kJ/mol',
            ),
            Arrhenius(
                A = (0.000231518, 's^-1'),
                n = 3.89615,
                Ea = (274.677, 'kJ/mol'),
                T0 = (1, 'K'),
                Tmin = (300, 'K'),
                Tmax = (2000, 'K'),
                comment = 'Fitted to 12 data points; dA = *|/ 17857.7, dn = +|- 1.29044, dEa = +|- 6.84787 kJ/mol',
            ),
            Arrhenius(
                A = (16752, 's^-1'),
                n = 1.90434,
                Ea = (289.778, 'kJ/mol'),
                T0 = (1, 'K'),
                Tmin = (300, 'K'),
                Tmax = (2000, 'K'),
                comment = 'Fitted to 12 data points; dA = *|/ 496.638, dn = +|- 0.818257, dEa = +|- 4.34217 kJ/mol',
            ),
        ],
    ),
)

#   =========== =========== =========== =========== =========== =========== 
#         T / P   1.000e-02   1.000e-01   1.000e+00   1.000e+01   1.000e+02
#   =========== =========== =========== =========== =========== =========== 
#          2000   9.083e+02   9.083e+03   9.083e+04   9.076e+05   9.009e+06
#          1320   9.281e-01   9.280e+00   9.279e+01   9.273e+02   9.213e+03
#       985.075   1.050e-03   1.049e-02   1.049e-01   1.048e+00   1.042e+01
#       785.714   1.405e-06   1.393e-05   1.391e-04   1.390e-03   1.383e-02
#       653.465   2.409e-09   2.324e-08   2.315e-07   2.313e-06   2.299e-05
#       559.322   4.692e-12   3.866e-11   3.784e-10   3.773e-09   3.748e-08
#       488.889   1.234e-14   7.195e-14   6.681e-13   6.625e-12   6.575e-11
#       434.211   9.163e-17   2.394e-16   1.717e-15   1.648e-14   1.627e-13
#       390.533   4.378e-19   7.133e-19   3.468e-18   3.099e-17   3.033e-16
#       354.839   3.804e-21   4.539e-21   1.188e-20   8.521e-20   8.082e-19
#       325.123   3.338e-23   3.528e-23   5.428e-23   2.439e-22   2.110e-21
#           300   2.618e-25   2.680e-25   3.296e-25   9.437e-25   6.951e-24
#   =========== =========== =========== =========== =========== =========== 
pdepreaction(
    reactants = ['NH3O'],
    products = ['HNO', 'H2'],
    kinetics = PDepArrhenius(
        pressures = ([0.01, 0.1, 1, 10, 100], 'bar'),
        arrhenius = [
            Arrhenius(
                A = (1.18941e-24, 's^-1'),
                n = 9.32973,
                Ea = (137.767, 'kJ/mol'),
                T0 = (1, 'K'),
                Tmin = (300, 'K'),
                Tmax = (2000, 'K'),
                comment = 'Fitted to 12 data points; dA = *|/ 7935.71, dn = +|- 1.18354, dEa = +|- 6.28057 kJ/mol',
            ),
            Arrhenius(
                A = (3.16604e-17, 's^-1'),
                n = 7.51346,
                Ea = (155.382, 'kJ/mol'),
                T0 = (1, 'K'),
                Tmin = (300, 'K'),
                Tmax = (2000, 'K'),
                comment = 'Fitted to 12 data points; dA = *|/ 13272.6, dn = +|- 1.25133, dEa = +|- 6.64032 kJ/mol',
            ),
            Arrhenius(
                A = (1.96815e-08, 's^-1'),
                n = 5.25974,
                Ea = (173.037, 'kJ/mol'),
                T0 = (1, 'K'),
                Tmin = (300, 'K'),
                Tmax = (2000, 'K'),
                comment = 'Fitted to 12 data points; dA = *|/ 680.965, dn = +|- 0.859863, dEa = +|- 4.56295 kJ/mol',
            ),
            Arrhenius(
                A = (0.00441817, 's^-1'),
                n = 3.99196,
                Ea = (182.248, 'kJ/mol'),
                T0 = (1, 'K'),
                Tmin = (300, 'K'),
                Tmax = (2000, 'K'),
                comment = 'Fitted to 12 data points; dA = *|/ 32.827, dn = +|- 0.460181, dEa = +|- 2.442 kJ/mol',
            ),
            Arrhenius(
                A = (0.406614, 's^-1'),
                n = 3.7097,
                Ea = (184.256, 'kJ/mol'),
                T0 = (1, 'K'),
                Tmin = (300, 'K'),
                Tmax = (2000, 'K'),
                comment = 'Fitted to 12 data points; dA = *|/ 15.492, dn = +|- 0.361202, dEa = +|- 1.91676 kJ/mol',
            ),
        ],
    ),
)

#   =========== =========== =========== =========== =========== =========== 
#         T / P   1.000e-02   1.000e-01   1.000e+00   1.000e+01   1.000e+02
#   =========== =========== =========== =========== =========== =========== 
#          2000   8.069e+11   8.069e+11   8.069e+11   8.067e+11   8.045e+11
#          1320   2.033e+11   2.033e+11   2.033e+11   2.033e+11   2.028e+11
#       985.075   6.847e+10   6.847e+10   6.847e+10   6.845e+10   6.829e+10
#       785.714   2.890e+10   2.890e+10   2.890e+10   2.889e+10   2.882e+10
#       653.465   1.435e+10   1.435e+10   1.435e+10   1.435e+10   1.431e+10
#       559.322   7.982e+09   7.982e+09   7.982e+09   7.980e+09   7.957e+09
#       488.889   4.868e+09   4.868e+09   4.868e+09   4.867e+09   4.852e+09
#       434.211   3.126e+09   3.126e+09   3.126e+09   3.125e+09   3.113e+09
#       390.533   2.131e+09   2.131e+09   2.131e+09   2.130e+09   2.122e+09
#       354.839   1.492e+09   1.492e+09   1.492e+09   1.492e+09   1.485e+09
#       325.123   1.263e+09   1.263e+09   1.263e+09   1.263e+09   1.258e+09
#           300   9.448e+08   9.448e+08   9.447e+08   9.443e+08   9.403e+08
#   =========== =========== =========== =========== =========== =========== 
pdepreaction(
    reactants = ['H', 'H2NO'],
    products = ['HNO', 'H2'],
    kinetics = PDepArrhenius(
        pressures = ([0.01, 0.1, 1, 10, 100], 'bar'),
        arrhenius = [
            Arrhenius(
                A = (0.365693, 'cm^3/(mol*s)'),
                n = 3.74522,
                Ea = (
                    -0.618442,
                    'kJ/mol',
                ),
                T0 = (1, 'K'),
                Tmin = (300, 'K'),
                Tmax = (2000, 'K'),
                comment = 'Fitted to 12 data points; dA = *|/ 2.70952, dn = +|- 0.131384, dEa = +|- 0.697205 kJ/mol',
            ),
            Arrhenius(
                A = (0.365695, 'cm^3/(mol*s)'),
                n = 3.74522,
                Ea = (
                    -0.618429,
                    'kJ/mol',
                ),
                T0 = (1, 'K'),
                Tmin = (300, 'K'),
                Tmax = (2000, 'K'),
                comment = 'Fitted to 12 data points; dA = *|/ 2.70953, dn = +|- 0.131385, dEa = +|- 0.697206 kJ/mol',
            ),
            Arrhenius(
                A = (0.365724, 'cm^3/(mol*s)'),
                n = 3.7452,
                Ea = (
                    -0.6183,
                    'kJ/mol',
                ),
                T0 = (1, 'K'),
                Tmin = (300, 'K'),
                Tmax = (2000, 'K'),
                comment = 'Fitted to 12 data points; dA = *|/ 2.70958, dn = +|- 0.131387, dEa = +|- 0.69722 kJ/mol',
            ),
            Arrhenius(
                A = (0.366006, 'cm^3/(mol*s)'),
                n = 3.74508,
                Ea = (
                    -0.617006,
                    'kJ/mol',
                ),
                T0 = (1, 'K'),
                Tmin = (300, 'K'),
                Tmax = (2000, 'K'),
                comment = 'Fitted to 12 data points; dA = *|/ 2.71013, dn = +|- 0.131414, dEa = +|- 0.697362 kJ/mol',
            ),
            Arrhenius(
                A = (0.368821, 'cm^3/(mol*s)'),
                n = 3.74383,
                Ea = (
                    -0.604127,
                    'kJ/mol',
                ),
                T0 = (1, 'K'),
                Tmin = (300, 'K'),
                Tmax = (2000, 'K'),
                comment = 'Fitted to 12 data points; dA = *|/ 2.71562, dn = +|- 0.131681, dEa = +|- 0.698777 kJ/mol',
            ),
        ],
    ),
)

