#!/bin/bash
#SBATCH --partition=small
#SBATCH --nodes=1
#SBATCH --ntasks-per-node=15
#SBATCH --account=project_2000770
#SBATCH --time=00:30:00 # time as hh:mm:ss
#SBATCH --gres=nvme:45 # requested local disk space in GB
#SBATCH --mem-per-cpu=3000 #MB

module purge
module load gcc/11.3.0 openmpi/4.1.4 intel-oneapi-mkl/2022.1.0
export ORCADIR=/projappl/project_2000770/orca_6_0_1_linux_x86-64_shared_openmpi416
export LD_LIBRARY_PATH=${ORCADIR}:${LD_LIBRARY_PATH}

# create a mpirun script that executes srun
echo exec 'srun $(echo "${@}" | sed 's/^-np/-n/')' >./mpirun
chmod +x ./mpirun
export PATH=${SLURM_SUBMIT_DIR}:${PATH}
touch Jobid_is_$SLURM_JOB_ID 

#Set $ORCA_TMPDIR to point to the local disk
export ORCA_TMPDIR=$LOCAL_SCRATCH
# Copy only necessary files to $ORCA_TMPDIR
cp $SLURM_SUBMIT_DIR/vdwb.com $ORCA_TMPDIR/
cp $SLURM_SUBMIT_DIR/vdwbInp.gbw $ORCA_TMPDIR/
# cp $SLURM_SUBMIT_DIR/vdwb.hess $ORCA_TMPDIR/
# Move to $ORCA_TMPDIR
cd $ORCA_TMPDIR

$ORCADIR/orca vdwb.com > ${SLURM_SUBMIT_DIR}/vdwb.log
$ORCADIR/orca_2mkl vdwb -molden
$ORCADIR/orca_2mkl vdwb_job2 -molden
rm -f  ${SLURM_SUBMIT_DIR}/mpirun
# Copy all output to submit directory
cp -r $ORCA_TMPDIR $SLURM_SUBMIT_DIR














































































