module fragment_and_potential_input
include("parameters.jl")
include("statistical_mechanics.jl")
using .parameters
using StaticArrays
using LinearAlgebra

export n, ge, σ, μ, Ia, Ib, Ic, Vtr, F, compute_moments_of_inertia, ZYZRotationMatrix, F1

#Note: in case one or both fragments are not non-linear rotors, the fragment with more non-zero principal moments of inertia must be the designated as fragment 1.
#   Fragment 1           Fragment 2             n
#   linear rotor         atom                   4
#   non-linear rotor     atom                   5
#   linear rotor         linear rotor           6
#   non-linear rotor     linear rotor           7
#   non-linear rotor     non-linear rotor       8

const n = 5
const ge = 1.0 / 4.0           #ratio of TS and reactant electronic partition functions. 
const σ = 1.0                  #ratio of TS and reactant symmetry numbers. 2.0 if the two reactants are indistuingshable, otherwise 1.0. 

const fragment1_masses = SVector(masses["N"], masses["O"], masses["H"], masses["H"])
const fragment2_masses = SVector(masses["H"])
const μ = sum(fragment1_masses) * sum(fragment2_masses) / (sum(fragment1_masses) + sum(fragment2_masses))

const global Ia, Ib, Ic = 10400.666779139436, 97971.29356034465, 108110.48065752382



function F(ϕ, θ, RC)

    #return RC

    #Fragment1Coordinates = transpose(@SMatrix [                                 #These are in centre-of-mass-principal-moment-of-inertia frame
    #    0.0385960603	0	1.1567269194;
    #    -0.0094155091	0	-1.2769175308;
    #    -0.1934181093	1.6718213531	2.0968194331;
    #    -0.1934181093	-1.6718213532	2.0968194331
    #])

    lobeDistance = 0.5

    α1 = atan(0.0385960603 / 1.1567269194)
    d1 = (0.0385960603^2 + 1.1567269194^2)^0.5
    β1 = atan(lobeDistance / d1)
    r1 = (d1^2 + lobeDistance^2)^0.5

    zN1 = cos(β1 + α1) * r1
    xN1 = sin(β1 + α1) * r1
    zN2 = cos(β1 - α1) * r1
    xN2 = -sin(β1 - α1) * r1

    α2 = atan(0.0094155091 / 1.2769175308)
    d2 = (0.0094155091^2 + 1.2769175308^2)^0.5
    β2 = atan(lobeDistance / d1)
    r2 = (d2^2 + lobeDistance^2)^0.5

    zO1 = -cos(β2 + α2) * r2
    xO1 = -sin(β2 + α2) * r2
    zO2 = -cos(β2 - α2) * r2
    xO2 = sin(β2 - α2) * r2

    Fragment1Pivots = (
        SVector(xN1, 0.0, zN1),          #N-atom pivot
        SVector(xN2, 0.0, zN2),          #N-atom pivot
        SVector(xO1, 0.0, zO1),          #O-atom pivot
        SVector(xO2, 0.0, zO2)           #O-atom pivot    
    )

    Fragment2Pivots = (
        SVector(0.0, 0.0, 0.0),      #H-atom pivot  
    )

    RCcm = 0.0
    species = 0
    for i = 1:length(Fragment1Pivots)
        for j = 1:length(Fragment2Pivots)
            pivot1 = ZYZRotationMatrix(ϕ, θ, 0.0, Fragment1Pivots[i])
            pivot2 = Fragment2Pivots[j]

            d1 = norm(pivot1)
            d2 = norm(pivot2)
            if d1 + d2 > RC
                println("d1 + d2 < RC)")
                exit()
            end
            d21 = dot(pivot2, pivot1)
            d2_minus_d1 = -(pivot2[3] - pivot1[3])
            R = -d2_minus_d1 + (d2_minus_d1^2 + 2 * d21 + RC^2 - d1^2 - d2^2)^0.5
            if R > RCcm
                RCcm = R
                if i == 1 || i == 2
                    species = 2
                else
                    species = 1
                end
            end
        end
    end
    return (RCcm, species)

end

function ZYZRotationMatrix(ϕ::Real, θ::Real, χ::Real, Cartesians::SVector{})
    Cϕ, Cθ, Cχ = cos(ϕ), cos(θ), cos(χ)
    Sϕ, Sθ, Sχ = sin(ϕ), sin(θ), sin(χ)
    ZYZ = @SMatrix [Cϕ*Cθ*Cχ-Sϕ*Sχ Sϕ*Cθ*Cχ+Cϕ*Sχ -Sθ*Cχ; -Cϕ*Cθ*Sχ-Sϕ*Cχ -Sϕ*Cθ*Sχ+Cϕ*Cχ Sθ*Sχ; Cϕ*Sθ Sϕ*Sθ Cθ]

    return ZYZ * Cartesians
end

end





