module parameters
export amu, Å, h, ħ, kB, Na, c, masses, a0, timeUnit, ϵ_0

#Physical constants in atomic units. 
const Å = 1.0e-10 / 5.29177210903e-11                #[au]
const amu = 1.66053906660e-27 / 9.1093837015e-31     #[au]    
const Eh = 4.3597447222071e-18                       #[J]
const ħ = 1                                          #[au]
const h = 2π * ħ                                     #[au]
const kB = 1.380649e-23 / Eh                         #[au]
const Na = 6.02214076e23                             #[1/mol]
const c = 137.035999177                              #[au]

const a0 = 5.29177210903e-11  #[m]
const timeUnit = 6.62607015e-34 / (2π * Eh)

const ϵ_0 = 1.00e-100

#Masses of most common isotope in amus. 
#reference page http://pntpm.ulb.ac.be/private/divers.htm
#Copied from MESMER's unitsConversion.cpp file. 
const masses = Dict(
    "H" => 1.007825032amu,
    "D" => 2.014101778amu,
    "T" => 3.016049268amu,
    "C" => 12.000000000amu,
    "13C" => 13.003354838amu,
    "14C" => 14.003241991amu,
    "13N" => 13.005738584amu,
    "N" => 14.003074007amu,
    "15O" => 15.003065460amu,
    "O" => 15.994914620amu,
    "17O" => 16.999131501amu,
    "F" => 18.998403220amu,
    "S" => 31.972071000amu,
    "Cl" => 34.968852680amu,
    "B" => 10.81amu,
    "Na" => 22.990amu,
    "Mg" => 24.305amu,
    "Al" => 26.982amu,
    "Si" => 28.085amu,
    "P" => 30.974amu,
    "K" => 39.098amu,
    "Ca" => 40.078amu,
    "Sc" => 44.956amu,
    "Ti" => 47.867amu,
    "V" => 50.942amu,
    "Cr" => 51.996amu,
    "Mn" => 54.938amu,
    "Fe" => 55.845amu,
    "Co" => 58.933amu,
    "Ni" => 58.693amu,
    "Cu" => 63.546amu,
    "Zn" => 65.38amu,
    "Ga" => 69.723amu,
    "Ge" => 72.63amu,
    "As" => 74.922amu,
    "Se" => 78.96amu,
    "Br" => 79.904amu,
    "Rb" => 85.468amu,
    "Sr" => 87.62amu,
    "Y" => 88.906amu,
    "Zr" => 91.224amu,
    "Nb" => 92.906amu,
    "Mo" => 95.96amu,
    "Tc" => 97.91amu,
    "Ru" => 101.07amu,
    "Rh" => 102.91amu,
    "Pd" => 106.43amu,
    "Ag" => 107.87amu,
    "Cd" => 112.41amu,
    "Ln" => 114.82amu,
    "Sn" => 118.71amu,
    "Sb" => 121.76amu,
    "Te" => 127.60amu,
    "I" => 126.9amu)

end
