/* Kronecker delta function */
int delta(int i, int j)
{
  if(i != j)
    return 0;
  else
    return 1;
}

/* Square matrix M (dim x dim) times vector v */
void prod(real * M, real * v, real * Mv, int dim) {
  /* Clear result vector Mv */
  for(int i = 0; i < dim; ++i) Mv[i] = 0;

  /* Matrix multiplication */
  for(int i = 0; i < dim; ++i)
    for(int j = 0; j < dim; ++j)
      Mv[i] += M[dim*i + j]*v[j];

  return;
}

void triangular(real * A, int n)
{
  for(int i = 0; i < n; ++i) {
    if(A[n*i + i] == 0) { /* Pivot when A[i,i] = 0 */
      int j = i + 1;
      while(A[n*j + i] == 0 && j < n) ++j;
      if(j == n) return;
      for(int k = 0; k < n; ++k) {
        real swap = A[n*j + k];
        A[n*j + k] = A[n*i + k];
        A[n*i + k] = swap;
      }
    }

    for(int j = i + 1; j < n; ++j)
      for(int k = n - 1; k >= i; --k)
        A[n*j + k] -= A[n*j + i]*A[n*i + k]/A[n*i + i];
  }

  return;
}

real det(real * A, int n)
{
  triangular(A, n);
  real detA = 1.0;
  for(int i = 0; i < n; ++i) detA *= A[n*i + i];
  return detA;
}

/*** Cholesky decomposition ***/
void Cholesky(real * M, real * B, int n)
{
  int i, j, k; /* Indices */
  float tmpsum; /* Temporary variable */

  /* Clear B matrix */
  for(i = 0; i < n; i++)
    for(j = 0; j < n; j++)
      B[n*i + j] = 0;

  for(i = 0; i < n; i++) {
    for(j = 0; j < n; j++) {
      tmpsum = 0;
      if(i > j) {
        for(k = 0; k < i; k++)
          tmpsum += B[n*i + k]*B[n*j + k];

        B[n* i + j] = (M[n*i + j] - tmpsum)/B[n*j + j];
      }
      else if(i == j) {
        for(k = 0; k < i; k++)
          tmpsum += B[n* i + k]*B[n*i + k];
        B[n*i + i] = sqrt(M[n*i + i] - tmpsum);

        if(M[n*i + i] < tmpsum) {
          fprintf(stderr, "\n" LOG_ERROR "Cholesky decomposition: "
                                         "matrix not positive definite.\n");

          fprintf(stderr, LOG_EMPTY "det(M) = %e\n", det(M, n));

          exit(-1);
        }
      }
    }
  }

  return;
}
