/* pbc.h: periodic boundary conditions */
# ifndef _PBC_H_
# define _PBC_H_

/* No periodic boundary conditions */
void applyPBC_none(real * r, real * L, int dim)
{
  return;
}

/* Rectangular periodic boundary conditions */
void applyPBC_rectangular(real * r, real * L, int dim)
{
  for(int l = 0; l < dim; ++l)
    r[l] -= L[l]*floor(r[l]/L[l] + 0.5);

  return;
}

/* Default choice */
__attribute__((weak,alias("applyPBC_rectangular"))) void applyPBC();

# endif
