from MyScripts.generic_funcs import *
import numpy as np

@np_array_decorator
def normalize_vector(vector):
    norm = np.linalg.norm(vector)
    return vector / norm

@np_array_decorator
def line_vector(point1, point2):
    return point2 - point1

@np_array_decorator
def plane_vector(point1, point2, point3):
    line1 = line_vector(point1, point2)
    line2 = line_vector(point1, point3)
    return np.cross(line1, line2)

@np_array_decorator
def distance(point1, point2):
    return np.linalg.norm(point2 - point1)

@np_array_decorator
def angle(point1, point2, point3):
    vector1 = line_vector(point1, point2)
    vector2 = line_vector(point2, point3)
    dot_product = np.dot(vector1, vector2)
    norm_product = np.linalg.norm(vector1) * np.linalg.norm(vector2)
    argument = dot_product / norm_product
    argument = np.clip(argument, -1, 1)  # Limit argument to the valid range
    return np.degrees(np.arccos(argument))

@np_array_decorator
def dihedral(point1, point2, point3, point4):
    plane1 = plane_vector(point1, point2, point3)
    plane2 = plane_vector(point2, point3, point4)
    dot_product = np.dot(plane1, plane2)
    norm_product = np.linalg.norm(plane1) * np.linalg.norm(plane2)
    argument = dot_product / norm_product
    argument = np.clip(argument, -1, 1)  # Limit argument to the valid range
    return np.degrees(np.arccos(argument))
