#!/bin/bash

for i in 2*/; do
    i="${i%/}"

    ii="3${i}_normal"

    echo "Making directory ${ii}/ref"
    mkdir -p "${ii}/ref"

    echo "Copying xyz files from ${i}/results_extracted to ${ii}"
    cp "./${i}/results_extracted/"*.xyz "./${ii}/"

    echo "Going to ${ii}/ref"
    cd "${ii}/ref"

    echo "Copying xyz files from parent directory"
    cp ../*.xyz .

    echo "Running parse_conf.py with split level 1"
    parse_conf.py *.xyz --split-level 1

    echo "Removing files without '_1.xyz'"
    ls | grep -v '_1.xyz' | xargs rm

    echo "Renaming *_1.xyz files to *_ref.xyz"
    for iii in *.xyz; do
        mv "$iii" "${iii/_1.xyz/_ref.xyz}"
    done

    cd ..

    echo "Copying xyz files from ref back to ${ii}"
    cp ref/*.xyz .

    echo "Running cjobs crest command"
    cjobs crest --container xtb651 --mode=array -j *ref.xyz -c 2 -m 4000 -t 96 \
        -f "--cregen \"\${job_input/ref/confs}\" --notopo --cluster normal -T 2" \
        --send-files "\"\${job_input/ref/confs}\""
	
	echo "Submitting Job"
	sbatch sbatch cjobs*.sh
	squeue -u u759234
	
	echo "Returning to original directory"
    cd ..
done
