#!/usr/bin/env python3

import argparse
import os

parser = argparse.ArgumentParser(description='None')

parser.add_argument('files', nargs='+', help='None')
parser.add_argument('--flags', type=str, default='# hf/3-21g geom=connectivity' ,help='None')
parser.add_argument('--charge', type=int, default=0, help='None')
parser.add_argument('--uhf', type=int, default=1, help='None')
parser.add_argument('--mem', type=int, default=0, help='None')
parser.add_argument('--proc', type=int, default=0, help='None')

args = parser.parse_args()

for file in args.files:
    name = os.path.split(file)[-1].split('.')[0]
    with open(file) as xyz, open(f'{os.path.splitext(file)[0]}.com', 'w') as com:
        coords = [line for line in xyz]
        

        if args.mem:
            com.write(f'%mem={args.mem}GB')
            com.write('\n')
        if args.proc:
            com.write(f'%nprocs={args.proc}')
            com.write('\n')
        com.write(args.flags.strip())
        com.write('\n')
        com.write('\n')
        com.write(name)
        com.write('\n')
        com.write('\n')
        com.write(f'{args.charge} {args.uhf}')
        com.write('\n')
        for c in coords[2:]:
            com.write(f' {c}')
        com.write('\n')

