#!/usr/bin/env python3

import argparse
import os

parser = argparse.ArgumentParser(description='None')

parser.add_argument('files', nargs='+', help='None')
parser.add_argument('--flags', type=str, default='# hf/3-21g geom=connectivity' ,help='None')
parser.add_argument('--charge', type=int, default=0, help='None')
parser.add_argument('--uhf', type=int, default=1, help='None')
parser.add_argument('--mem', type=int, default=0, help='None')
parser.add_argument('--proc', type=int, default=0, help='None')

args = parser.parse_args()

for file in args.files:
    name = os.path.split(file)[-1].split('.')[0]
    with open(file) as xyz, open(f'{os.path.splitext(file)[0]}.inp', 'w') as inp:
        coords = [line for line in xyz]
        if args.proc:
            inp.write(f'! pal{args.proc}\n')
        inp.write(f'! {args.flags}\n\n')
        if args.mem:
            inp.write(f'%maxcore {args.mem}\n\n')
        inp.write(f'* xyz {args.charge} {args.uhf}\n')
        for c in coords[2:]:
            inp.write(f' {c}')
        inp.write('*\n')
