#!/usr/bin/env python3

import argparse
import os

parser = argparse.ArgumentParser(description='None yet')

parser.add_argument('files', nargs='+', help='Files for clusterization')
parser.add_argument('--split-char', default='_', help='character where file name will be splited')
parser.add_argument('--split-level', default=1, type=int, help='list index for file name after beeing splited')
parser.add_argument('--min-confs', default=0, type=int, help='def minimum amount of confermers needed to perform clusterization')

args = parser.parse_args()

def count_conf(file):
    confs = 0
    with open(file) as handle:
        for line in handle:
            if line.strip().split()[0].isdigit():
                confs += 1
    return confs

os.mkdir('not_for_cluster')
for file in args.files:
    base_name = file.rsplit(args.split_char, args.split_level)[0]
    if args.min_confs:
        if count_conf(file) > args.min_confs:
            os.system(f'obabel -ixyz {file} -oxyz -m -O {base_name}_.xyz')
        else:
            os.system(f'mv {file} ./not_for_cluster')
    else:
        os.system(f'obabel -ixyz {file} -oxyz -m -O {base_name}_.xyz')

try:
    os.rmdir('not_for_cluster')
except:
    pass
