import re, os, time
from datetime import datetime
from MyScripts.generic_funcs import *
import MyScripts.gaussian_tags as tags
from MyScripts.analitic_geometry_funcs import *

@arg_file_handler
def termination(file_path, prt=False):
    # initiate variables
    occ_count = 0
    
    with open(file_path) as handle:
        for line in handle:
            if line.strip().startswith('Normal termination'):
                occ_count += 1
    if prt:
        if occ_count:
            print(f'<{file_path}> had {occ_count} normal terminations')
        else:
            print(f'<{file_path}> did not terminate normally')
    return occ_count

@arg_file_handler
def molecular(file_path, select, conv=False, const=627.503):
    # initiate variables
    out = None
    
    # gets the first occurrence from a tag
    if tags.mol_tags[select][0] == 'last':
        with open(file_path) as handle:
            for line in handle:
                if line.strip().startswith(tags.mol_tags[select][1]) or line.strip().endswith(tags.mol_tags[select][1]):
                    values = re.findall(tags.float_regex, line)
                    out = float(values[-1])
    
    # gets the first occurrence from a tag
    elif tags.mol_tags[select][0] == 'first':
        with open(file_path) as handle:
            for line in handle:
                if line.strip().startswith(tags.mol_tags[select][1]) or line.strip().endswith(tags.mol_tags[select][1]):
                    values = re.findall(tags.float_regex, line)
                    out = float(values[0])
                    break
    
    # searches for a specifc occurrence from a tag
    elif tags.mol_tags[select][0] == 'search':
        with open(file_path) as handle:
            occ_count = 0
            for line in handle:
                if line.strip().startswith(tags.mol_tags[select][1]) or line.strip().endswith(tags.mol_tags[select][1]):
                    occ_count += 1
                    if occ_count == tags.mol_tags[select][3]:
                        values = re.findall(tags.float_regex, line)
                        out = float(values[tags.mol_tags[select][2]-1])
    
    if conv and out:
        return out*const # returns converted output/constant can be manually changed for the desired units
    return out

@arg_file_handler
def mulliken(file_path, atom_idx, select, frac=False, print_out=False):
    # initiate variables
    printout = list()
    out = None
    heavy_atoms = 0
    
    # open file for search:
    with open(file_path) as handle:
        printout.append('\n###############  NEW INPUT ###############\n')
        printout.append(f'Reading file: <{file_path}> {datetime.now().strftime("%b-%d-%Y %H:%M:%S")}\n')
        for line in handle:
            if line.strip().startswith(tags.mulliken_tags[select][0]):
                printout.append(line)
                # Jumps the headline of output table
                next(handle)
                while True:
                    line = next(handle)
                    # Stops iteration on Mullinken table of results
                    if not line.strip()[0].isdigit():
                        break
                    # Matches the atom and get the selected value
                    if line.strip().split()[0] == str(atom_idx):
                        printout.append(line)
                        values = re.findall(tags.float_regex, line)
                        out = float(values[tags.mulliken_tags[select][1]])
                        if line.strip().split()[1] != 'H':
                            heavy_atoms += (abs(float(values[tags.mulliken_tags[select][1]])))
                    else:
                        if line.strip().split()[1] != 'H':
                            values = re.findall(tags.float_regex, line)
                            heavy_atoms += (abs(float(values[tags.mulliken_tags[select][1]])))
    
    # printout is a suport of this function used mainly to debugging
    if print_out:
        with open(f'{os.path.split(file_path)[0]}\\Mulliken.debugg', 'a') as file:
            for log in printout:
                print(log)
                file.write(log)
            file.write('\n\n')
    
    if frac:
        return abs(out)/heavy_atoms
    return out



@arg_file_handler
def npa(file_path, atom_idx, select, print_out=False):
    # initiate variables
    printout = list()
    out = None
    
    # open file for search:
    with open(file_path) as handle:
        printout.append('\n###############  NEW INPUT ###############\n')
        printout.append(f'Reading file: <{file_path}> {datetime.now().strftime("%b-%d-%Y %H:%M:%S")}\n')
        occ_count = 0
        for line in handle:
            if line.strip().startswith('Summary of Natural Population Analysis:'):
                printout.append(line)
                occ_count += 1
                if occ_count == tags.npa_tags[select][0]:
                    # Jumps the headline of output table
                    for _ in range(5):
                            next(handle)
                    while True:
                        line = next(handle)
                        # Stops iteration on NPA table of results
                        if line.strip()[0] == '=':
                            break
                        if atom_idx < 100:
                            if line.strip().split()[1] == str(atom_idx):
                                printout.append(line)
                                values = re.findall(tags.float_regex, line)
                                out = float(values[tags.npa_tags[select][1]])
                                break
                        else:
                            if line.strip().split()[0][1:] == str(atom_idx):
                                printout.append(line)
                                values = re.findall(tags.float_regex, line)
                                out = float(values[tags.npa_tags[select][1]])
                                break
                    break
    
    # printout is a suport of this function used mainly to debugging
    if print_out:
        with open(f'{os.path.split(file_path)[0]}\\NPA.debugg', 'a') as file:
            for log in printout:
                print(log)
                file.write(log)
            file.write('\n\n')
    
    return out

@arg_file_handler
def nbo(file_path, atom_idx, select, orbital, order, print_out=False):
    # initiate variables
    printout = list()
    out = None
    
    # open file for search:
    with open(file_path) as handle:
        printout.append('\n###############  NEW INPUT ###############\n')
        printout.append(f'Reading file: <{file_path}> {datetime.now().strftime("%b-%d-%Y %H:%M:%S")}\n')
        occ_count = 0
        for line in handle:
            if line.strip().startswith(tags.nbo_tags[select]):
                printout.append(line)
                while not line.strip().startswith('NATURAL BOND ORBITALS (Summary):'):
                    line = next(handle)
                while True:
                    line = next(handle)
                    # Break loop
                    if line.strip().startswith('Charge unit'):
                        for _ in range(2):
                            line = next(handle)
                        if not line.strip() or line.strip().startswith('$CHOOSE'):
                            break
                    
                    # Search pattern for atom centered descriptors
                    if tags.nbo_orbitals[orbital] == 'atom':
                        decode = line.strip().replace('(', ' ').replace(')', ' ').replace('-', ' ').split()[1:5]
                        if decode:
                            if decode[0] == orbital:
                                if int(decode[1]) == order and int(decode[3]) == atom_idx:
                                    printout.append(line)
                                    values = re.findall(tags.float_regex, line)
                                    out = float(values[1])
                    
                    # Search pattern for bond centered descriptors
                    if tags.nbo_orbitals[orbital] == 'bond':
                        decode = line.strip().replace('(', ' ').replace(')', ' ').replace('-', ' ').split()[1:7]
                        if decode:
                            if decode[0] == orbital:
                                if int(decode[1]) == order and int(decode[3]) in atom_idx and int(decode[5]) in atom_idx:
                                    printout.append(line)
                                    values = re.findall(tags.float_regex, line)
                                    out = float(values[1])
                break
    
    # printout is a suport of this function used mainly to debugging
    if print_out:
        with open(f'{os.path.split(file_path)[0]}\\NBO.debugg', 'a') as file:
            for log in printout:
                print(log)
                file.write(log)
            file.write('\n\n')
    
    return out # Returns the last found output


@arg_file_handler
def xyz_coordinates(file_path, convert=False):
    # initiate variables
    atoms = list()
    coordinates = list()
    with open(file_path) as handle:
        for line in handle:
            if line.strip().startswith('Symbolic Z-matrix:'):
                next(handle)
                while True:
                    line = next(handle)
                    if not line.strip():
                        break
                    else:
                        values = line.strip().split()
                        atoms.append(values[0])
                        coordinates.append([float(v) for v in values[1:]])
                break
    
    if convert:
        new_file = file_path.rsplit(".", 1)[0] + '.xyz'
        with open(new_file, 'w') as handle:
            handle.write(f'{len(atoms)}\n')
            handle.write(f'{get_name(new_file)}\n')
            for a, c in zip(atoms, coordinates):
                handle.write(format_xyz(a, c))
    return (atoms, coordinates)


@arg_file_handler
def geometric(file_path, atoms, select):
    atomic_matrix, coordinates = xyz_coordinates(file_path)
    if select == 'Distance':
        return distance(coordinates[atoms[0]-1], coordinates[atoms[1]-1])
    elif select == 'Angle':
        return angle(coordinates[atoms[0]-1], coordinates[atoms[1]-1], coordinates[atoms[2]-1])
    elif select == 'Dihedral':
        return dihedral(coordinates[atoms[0]-1], coordinates[atoms[1]-1], coordinates[atoms[2]-1], coordinates[atoms[3]-1])


