salicyl_reference = '[#1]~O(c1c(C(=O)([#1]))c([*])c([*])c([*])c1([*]))'
salicyl_index = ['H1', 'O1', 'C1', 'C6', 'C7', 'O2', 'H2', 'C5', 'R4', 'C4', 'R3', 'C3', 'R2', 'C2', 'R1']

general_position = {
    'ortho': 'c1([OH])[c!H]cccc1[CH](=O)', #Ok
    'meta1': 'c1([OH])c[c!H]ccc1[CH](=O)', #Ok
    'para': 'c1([OH])cc[c!H]cc1[CH](=O)', #Ok
    'meta2': 'c1([OH])ccc[c!H]c1[CH](=O)', #Ok
}

detailed_position = {
    'no_sub': 'c1([OH])[cH][cH][cH][cH]c1[CH](=O)', #Ok
    'ortho': 'c1([OH])[c!H][cH][cH][cH]c1[CH](=O)', #Ok
    'meta1': 'c1([OH])[cH][c!H][cH][cH]c1[CH](=O)', #Ok
    'para': 'c1([OH])[cH][cH][c!H][cH]c1[CH](=O)', #Ok
    'meta2': 'c1([OH])[cH][cH][cH][c!H]c1[CH](=O)', #Ok
    'ortho_meta1': 'c1([OH])[c!H][c!H][cH][cH]c1[CH](=O)', #Ok
    'ortho_para': 'c1([OH])[c!H][cH][c!H][cH]c1[CH](=O)', #Ok
    'ortho_meta2': 'c1([OH])[c!H][cH][cH][c!H]c1[CH](=O)', #Ok
    'meta1_para': 'c1([OH])[cH][c!H][c!H][cH]c1[CH](=O)', #Ok
    'meta1_meta2': 'c1([OH])[cH][c!H][cH][c!H]c1[CH](=O)', #Ok
    'para_meta2': 'c1([OH])[cH][cH][c!H][c!H]c1[CH](=O)', #Ok
    'ortho_meta1_para': 'c1([OH])[c!H][c!H][c!H][cH]c1[CH](=O)', #Ok
    'ortho_meta1_meta2': 'c1([OH])[c!H][c!H][cH][c!H]c1[CH](=O)', #Ok
    'ortho_para_meta2': 'c1([OH])[c!H][cH][c!H][c!H]c1[CH](=O)', #Ok
    'meta1_meta2_para': 'c1([OH])[cH][c!H][c!H][c!H]c1[CH](=O)', #Ok
    'ortho_meta1_para_meta2': 'c1([OH])[c!H][c!H][c!H][c!H]c1[CH](=O)' #Ok
}

incompatible_species = {
    'GT_2_OH_donors': '[#8!H0].[#8!H0]', #Ok
    'GT_2_aldehydes': '[CH1](=O).[CH1](=O)', #Also removes formic acid derivatives (not a problem)
    'Polyethylene_glycol': '[O!H!R][CX4!R][CX4!R][O!H!R]' #Ok
}

reactive_species = {
    #'OH_donors': '[#8!H0]', #Ok
    'NH_donors': '[#7!H0]', #Ok
    #'Carbocation': '[v3#6+]', #None_found
    #'Carbanion': '[v3#6-]', #None_found
    #'Carbon_radicals': '[v3#6!-!+]', #None_found
    #'Carbene': '[v2#6!-!+]', #None_found
    'Oxygen_radicals': '[v1#8!-!+]', #Ok
    #'Nitrogen_radicals': '[v2#7!-!+]', #None_found
    #'Alcoxides': 'C[O-]', #None_found
    #'Alkylamide': 'C[N-]', #None_found
    'Phenolates': 'c[O-]', #Ok
    #'Phenylamides': 'c[N-]', #None_found
    #'Hydronium_ions': '[O+X3]', #None_found
    #'Oxonium_ions': 'C=[O+]', #None_found
    #'Acylium_ions': 'C#[O+]', #None_found
    #'Amonium_ions': '[N+X4]', #None_found
    #'Iminium_ions': 'C=[N+]', #None_found
    #'Nitrilium_ions': 'C#[N+]' #None_found
}

alcohol_level_func = {
    #'Alcohols': '[CX4][OH]',
    #'Phenols': 'c[OH]',
    #'Eters': '[CX4][O!R3][CX4]',
    #'Primary_amines': '[CX4][NH2!R3]',
    #'Secondary_amines': '[CX4][NH!R3][CX4]',
    #'Tertiary_amines': '[CX4][N!R3]([CX4])[CX4]',
    #'Anilines': '', #Problema com Aminas pq não faz distinção entre aromáticos... talvez isolar de carbonilas 
    'Double_bonds': 'C=C', #Ok
}

aldehyde_level_func = {
    'Ketal_derivatives':'[CX4](O)(O)', #Ok
    'Hemiaminal_derivatives':'[CX4](N)(O)', #Ok
    'Aminal_derivatives':'[CX4](N)(N)', #Ok
}

carboxylic_acid_func = {
    #carboxilic acid
    #ester
    #amide
    #anhydrides
    #acyl halides
}

carbonate_level_func = {
    'Carbonate_derivatives': 'C(=O)(O)(O)', #Ok
    'Carbamate_derivatives': 'C(=O)(N)(O)', #Ok
    'Urea_derivatives': 'C(=O)(N)(N)', #Ok
    #'Carbonimidate_derivatives': 'C(=N)(O)(O)', #None_Found
    #'Carbamimidate': 'C(=N)(O)(N)', #None_Found
    'Guanidine_derivatives': 'C(=N)(N)(N)', #Ok
    #'Cyanate': 'OC#N', #None_Found
    #'Isocyanate': 'N=C=O', #None_Found
    #'Cyanamide': 'NC#N', #None_Found
    #'Methanediimine': 'N=C=N' #None_Found
}

halides = {
    #'Alkyl_halide': '[A!$(A=O)][CX4][Cl,Br,I]',
    #'Benzyl_halide': 'a[CX4][Cl,Br,I]',
    #'Vinyl_halide': 'C=C[Cl,Br,I]',
    #'Aryl_halide': 'A[Cl,Br,I]',
    #'Acyl_halide': 'C(=O)[Cl,Br,I]',
    #'Alpha_haloketone': 'C(=O)C[Cl,Br,I]',
    #'Sulfonyl_halide': 'S(=O)(=O)([Cl,Br,I])'
}

aliphatic_filters = {
    #'all_aliphatic_carbon_chains': '[C!R]',
    #'GT_1_aliphatic_carbon_chains': '[C!R][C!R]',
    #'GT_2_aliphatic_carbon_chains': '[C!R][C!R][C!R]',
    #'GT_3_aliphatic_carbon_chains': '[C!R][C!R][C!R][C!R]',
    #'GT_4_aliphatic_carbon_chains': '[C!R][C!R][C!R][C!R][C!R]',
    'GT_5_aliphatic_carbon_chains': '[C!R][C!R][C!R][C!R][C!R][C!R]',
    #'GT_6_aliphatic_carbon_chains': '[C!R][C!R][C!R][C!R][C!R][C!R][C!R]',
    #'GT_7_aliphatic_carbon_chains': '[C!R][C!R][C!R][C!R][C!R][C!R][C!R][C!R]',
    #'GT_8_aliphatic_carbon_chains': '[C!R][C!R][C!R][C!R][C!R][C!R][C!R][C!R][C!R]',
    #'GT_9_aliphatic_carbon_chains': '[C!R][C!R][C!R][C!R][C!R][C!R][C!R][C!R][C!R][C!R]'
}

alicyclic_filters = {
    #'ciclos de 3 membros': '[r3A]',
    #'ciclos de 4 membros': '[r4A]',
    #'ciclos de 5 membros': '[r5A]',
    #'ciclos de 6 membros': '[r6A]',
    #'ciclos de 7 membros': '[r7A]',
    #'ciclos de 8 membros': '[r8A]',
    #'spiro': '[R2X4x4]', #Ok
    #'bridged': '[R3]' #Error
}

aromatic_filters = {
    # None
}

heterocyclic_filters = {
    #'aliphatic heterocycles': '[NR,OR]',
    'Epoxides': '[r3O]', #Ok
    'Aziridines': '[r3N]', #Ok
}

heteroaromatic_filters = {
    'pirrol': 'n1cccc1',
    'pirazol': 'n1nccc1',
    'imidazol': 'n1cncc1',
    '123-triazol': 'n1nncc1',
    '124-triazol': 'n1ncnc1',
    'tetrazol': 'n1nnnc1',
    'piridina': 'n1ccccc1',
    'piridazina': 'n1ncccc1',
    'pirimidina': 'n1cnccc1',
    'pirazina': 'n1ccncc1',
    '123-triazina': 'n1nnccc1',
    '124-triazina': 'n1ncncc1',
    '135-triazina': 'n1cncnc1',
    '1234-tetrazina': 'n1nnncc1',
    '1235-tetrazina': 'n1nncnc1',
    'pentazina': 'n1nnnnc1',
    'furano': 'o1cccc1',
    '12-oxazol': 'o1nccc1',
    '13-oxazol': 'o1cncc1',
    '123-oxadiazol': 'o1nncc1',
    '124-oxadiazol': 'o1ncnc1',
    '125-oxadiazol': 'o1nccn1',
    '134-oxadiazol': 'o1cnnc1',
    '1234-oxatriazol': 'o1nnnc1',
    '1235-oxatriazol': 'o1nncn1'
}

macro_molecules = {
    'cyclic_hexoses': 'C1([O])C([O])C([O])C([O])OC1(C[O])' #Ok
}

custum_filters = {
    #'Ketal_derivatives_keeping_13benzodioxole': '[CX4]([O&$(O-c);r5])([O&$(O-c);r5])', #Ok
    'weird_bridge': '[R3X3;$(cC=O)]', #Ok
    #'fused_3': '[aR2].[aR2].[aR2]'
}

improve_later = {
    'Alkyl_halide': '[CX4][Cl,Br,I]',
    'Acyl_halide': 'C(=O)[Cl,Br,I]',
    'Alpha_haloketone': 'C(=O)C[Cl,Br,I]',
    'Imine_derivatives': 'C(=N)', #Pouco específico mas funcional
    'Diazo_derivatives': 'N~N', #Pouco específico mas funcional
    'Anhydride_derivatives': 'C(=O)[O,N]C(=O)', #Pouco específico mas funcional
    'Nitroso_derivatives': '[N!+](=O)',
    'Nitrate_derivatives': '[N+](=O)(O)[O-]',
    'Quinone_derivatives': 'O=[#6]([#6]~[#6]1)[#6]~[#6][#6]1=O',
    '13-diketones': 'O=[#6][#6][#6]=O'
}