package ec.app.ThinFilmTransistors.OTFT.P3HT_ZnO_Hybrid.P3HT_10mg_ml_5000rpm;

import ec.EvolutionState;
import ec.Individual;
import ec.Problem;
import ec.evolutionary_extraction_procedure.models.draincurrentmodel.MarinovJimenezTejada.Subthreshold;
import ec.multiobjective.MultiObjectiveFitness;
import ec.simple.SimpleProblemForm;
import ec.util.Parameter;
import ec.vector.ThinFilmTransistors.OTFT.P3HT_ZnO_Hybrid.P3HT_10mg_ml_5000rpm.OFET_FULL_P3HT_10mg_ml_5000rpm_L_10_OtftVectorIndividual;

public class Full_OFET_L_10um extends Problem implements SimpleProblemForm {

    private static final long serialVersionUID = 1L;

    public static double W = 1;  //(cm) width
    public static double L = 0.001; // (cm) length
    public static double Cox = 15e-09; // Ci = 15nFcm−2
    public static final double[][] IVexp_outputCharacteristics = {
            {0.000000E+00, 0.000000E+00, 0.000000E+00, 0.000000E+00, 0.000000E+00, 0.000000E+00, 0.000000E+00},
            {3.304000E-08, 3.881000E-08, 4.472000E-08, 5.120000E-08, 5.854000E-08, 6.668000E-08, 7.548000E-08},
            {6.452000E-08, 7.844000E-08, 9.115000E-08, 1.053100E-07, 1.207200E-07, 1.376900E-07, 1.560200E-07},
            {9.460000E-08, 1.164500E-07, 1.356300E-07, 1.560900E-07, 1.789900E-07, 2.041600E-07, 2.313800E-07},
            {1.238200E-07, 1.522700E-07, 1.776000E-07, 2.047500E-07, 2.346900E-07, 2.675600E-07, 3.031000E-07},
            {1.511900E-07, 1.868200E-07, 2.181200E-07, 2.514900E-07, 2.880900E-07, 3.282400E-07, 3.716900E-07},
            {1.776600E-07, 2.200500E-07, 2.571800E-07, 2.965000E-07, 3.395000E-07, 3.865800E-07, 4.375200E-07},
            {2.031600E-07, 2.521000E-07, 2.949200E-07, 3.400300E-07, 3.891400E-07, 4.428200E-07, 5.009100E-07},
            {2.277400E-07, 2.830100E-07, 3.314600E-07, 3.821900E-07, 4.371800E-07, 4.972100E-07, 5.621600E-07},
            {2.514600E-07, 3.128500E-07, 3.668600E-07, 4.230900E-07, 4.838300E-07, 5.499600E-07, 6.214700E-07},
            {2.744100E-07, 3.417200E-07, 4.012100E-07, 4.628500E-07, 5.291600E-07, 6.011600E-07, 6.790100E-07},
            {2.966400E-07, 3.696100E-07, 4.346000E-07, 5.015700E-07, 5.732800E-07, 6.510300E-07, 7.349700E-07},
            {3.181900E-07, 3.966200E-07, 4.670400E-07, 5.392600E-07, 6.163400E-07, 6.996500E-07, 7.894900E-07},
            {3.391200E-07, 4.227800E-07, 4.985800E-07, 5.760400E-07, 6.583600E-07, 7.471100E-07, 8.426600E-07},
            {3.594800E-07, 4.481500E-07, 5.292400E-07, 6.119300E-07, 6.994600E-07, 7.934900E-07, 8.946400E-07},
            {3.792400E-07, 4.727400E-07, 5.590600E-07, 6.469300E-07, 7.396200E-07, 8.389100E-07, 9.455000E-07},
            {3.984300E-07, 4.966700E-07, 5.880900E-07, 6.811400E-07, 7.789800E-07, 8.833800E-07, 9.952900E-07},
            {4.169900E-07, 5.199300E-07, 6.163200E-07, 7.145400E-07, 8.174800E-07, 9.269700E-07, 1.044190E-06},
            {4.349600E-07, 5.425500E-07, 6.438100E-07, 7.471600E-07, 8.552000E-07, 9.697300E-07, 1.092060E-06},
            {4.523200E-07, 5.645600E-07, 6.705700E-07, 7.789800E-07, 8.921300E-07, 1.011830E-06, 1.139100E-06},
            {4.690400E-07, 5.859600E-07, 6.966400E-07, 8.100400E-07, 9.283000E-07, 1.052920E-06, 1.185360E-06},
            {4.851200E-07, 6.068000E-07, 7.221000E-07, 8.404900E-07, 9.638200E-07, 1.093450E-06, 1.230880E-06},
            {5.005000E-07, 6.269600E-07, 7.468400E-07, 8.700600E-07, 9.984600E-07, 1.133140E-06, 1.275550E-06},
            {5.151700E-07, 6.464700E-07, 7.709500E-07, 8.989300E-07, 1.032530E-06, 1.172050E-06, 1.319430E-06},
            {5.291700E-07, 6.653600E-07, 7.945200E-07, 9.273600E-07, 1.065640E-06, 1.210440E-06, 1.362750E-06},
            {5.424600E-07, 6.835200E-07, 8.173700E-07, 9.554400E-07, 1.098090E-06, 1.247880E-06, 1.405170E-06},
            {5.550200E-07, 7.009100E-07, 8.396000E-07, 9.819500E-07, 1.129770E-06, 1.284620E-06, 1.446830E-06},
            {5.668800E-07, 7.175500E-07, 8.611500E-07, 1.008110E-06, 1.160760E-06, 1.320600E-06, 1.487830E-06},
            {5.781100E-07, 7.334300E-07, 8.820300E-07, 1.033380E-06, 1.191000E-06, 1.355850E-06, 1.528040E-06},
            {5.887200E-07, 7.485500E-07, 9.021900E-07, 1.058180E-06, 1.220530E-06, 1.390350E-06, 1.567560E-06},
            {5.988000E-07, 7.628700E-07, 9.216500E-07, 1.082440E-06, 1.249540E-06, 1.424220E-06, 1.606460E-06},
            {6.083600E-07, 7.763900E-07, 9.403000E-07, 1.105940E-06, 1.277710E-06, 1.457270E-06, 1.644420E-06},
            {6.174900E-07, 7.891500E-07, 9.581500E-07, 1.128700E-06, 1.305250E-06, 1.489580E-06, 1.681740E-06},
            {6.261600E-07, 8.011300E-07, 9.751500E-07, 1.150750E-06, 1.332080E-06, 1.521250E-06, 1.718190E-06},
            {6.345400E-07, 8.124900E-07, 9.913500E-07, 1.172040E-06, 1.358190E-06, 1.552090E-06, 1.753940E-06},
            {6.426200E-07, 8.232300E-07, 1.007140E-06, 1.192490E-06, 1.383580E-06, 1.582290E-06, 1.788970E-06},
            {6.503900E-07, 8.334700E-07, 1.021330E-06, 1.212280E-06, 1.408330E-06, 1.611790E-06, 1.823350E-06},
            {6.579400E-07, 8.432300E-07, 1.035200E-06, 1.231170E-06, 1.432330E-06, 1.640550E-06, 1.856890E-06},
            {6.652300E-07, 8.525700E-07, 1.048340E-06, 1.249230E-06, 1.455430E-06, 1.668510E-06, 1.889610E-06},
            {6.722900E-07, 8.615100E-07, 1.060790E-06, 1.266450E-06, 1.477720E-06, 1.695760E-06, 1.921660E-06},
            {6.792400E-07, 8.701900E-07, 1.072680E-06, 1.282910E-06, 1.499290E-06, 1.722230E-06, 1.952930E-06}
    };

    public static final double[] VDS_outputCharacteristics = {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40};
    public static final double[] VGS_outputCharacteristics = {0, 4, 8, 12, 16, 20, 24};
    public static final double[] IAA = {1.0e-07, 1.0e-07, 1.0e-07, 1.0e-07, 1.0e-07, 1.0e-07, 1.0e-07};

    public static final double[][] IVexp_transferCharacteristics = {
            {2.5053000000E-07, 3.3639000000E-07},
            {2.5626000000E-07, 3.3897000000E-07},
            {2.6268000000E-07, 3.4159000000E-07},
            {2.6819000000E-07, 3.4419000000E-07},
            {2.7355000000E-07, 3.4681000000E-07},
            {2.7872000000E-07, 3.4945000000E-07},
            {2.8370000000E-07, 3.5207000000E-07},
            {2.8852000000E-07, 3.5471000000E-07},
            {2.9326000000E-07, 3.5737000000E-07},
            {2.9791000000E-07, 3.6004000000E-07},
            {3.0246000000E-07, 3.6271000000E-07},
            {3.0699000000E-07, 3.6538000000E-07},
            {3.1145000000E-07, 3.6807000000E-07},
            {3.1587000000E-07, 3.7078000000E-07},
            {3.2027000000E-07, 3.7349000000E-07},
            {3.2463000000E-07, 3.7621000000E-07},
            {3.2897000000E-07, 3.7895000000E-07},
            {3.3330000000E-07, 3.8169000000E-07},
            {3.3759000000E-07, 3.8444000000E-07},
            {3.4187000000E-07, 3.8719000000E-07},
            {3.4616000000E-07, 3.8996000000E-07},
            {3.5043000000E-07, 3.9275000000E-07},
            {3.5466000000E-07, 3.9551000000E-07},
            {3.5893000000E-07, 3.9831000000E-07},
            {3.6317000000E-07, 4.0112000000E-07},
            {3.6738000000E-07, 4.0392000000E-07},
            {3.7161000000E-07, 4.0673000000E-07},
            {3.7583000000E-07, 4.0957000000E-07},
            {3.8004000000E-07, 4.1240000000E-07},
            {3.8425000000E-07, 4.1525000000E-07},
            {3.8845000000E-07, 4.1811000000E-07},
            {3.9262000000E-07, 4.2096000000E-07},
            {3.9683000000E-07, 4.2384000000E-07},
            {4.0104000000E-07, 4.2673000000E-07},
            {4.0521000000E-07, 4.2960000000E-07},
            {4.0941000000E-07, 4.3251000000E-07},
            {4.1359000000E-07, 4.3539000000E-07},
            {4.1775000000E-07, 4.3834000000E-07},
            {4.2195000000E-07, 4.4127000000E-07},
            {4.2613000000E-07, 4.4422000000E-07},
            {4.3025000000E-07, 4.4714000000E-07},
            {4.3444000000E-07, 4.5010000000E-07},
            {4.3862000000E-07, 4.5309000000E-07},
            {4.4277000000E-07, 4.5606000000E-07},
            {4.4696000000E-07, 4.5904000000E-07},
            {4.5112000000E-07, 4.6200000000E-07},
            {4.5527000000E-07, 4.6500000000E-07},
            {4.5943000000E-07, 4.6800000000E-07},
            {4.6359000000E-07, 4.7101000000E-07},
            {4.6772000000E-07, 4.7401000000E-07},
            {4.7189000000E-07, 4.7704000000E-07},
            {4.7605000000E-07, 4.8010000000E-07},
            {4.8018000000E-07, 4.8314000000E-07},
            {4.8433000000E-07, 4.8621000000E-07},
            {4.8850000000E-07, 4.8929000000E-07},
            {4.9262000000E-07, 4.9235000000E-07},
            {4.9677000000E-07, 4.9542000000E-07},
            {5.0093000000E-07, 4.9851000000E-07},
            {5.0504000000E-07, 5.0162000000E-07},
            {5.0917000000E-07, 5.0474000000E-07},
            {5.1330000000E-07, 5.0788000000E-07},
            {5.1740000000E-07, 5.1100000000E-07},
            {5.2153000000E-07, 5.1416000000E-07},
            {5.2566000000E-07, 5.1729000000E-07},
            {5.2978000000E-07, 5.2040000000E-07},
            {5.3390000000E-07, 5.2360000000E-07},
            {5.3800000000E-07, 5.2675000000E-07},
            {5.4207000000E-07, 5.2993000000E-07},
            {5.4618000000E-07, 5.3312000000E-07},
            {5.5026000000E-07, 5.3631000000E-07},
            {5.5432000000E-07, 5.3950000000E-07},
            {5.5840000000E-07, 5.4272000000E-07},
            {5.6253000000E-07, 5.4595000000E-07},
            {5.6660000000E-07, 5.4918000000E-07},
            {5.7069000000E-07, 5.5242000000E-07},
            {5.7476000000E-07, 5.5565000000E-07},
            {5.7882000000E-07, 5.5890000000E-07},
            {5.8290000000E-07, 5.6214000000E-07},
            {5.8696000000E-07, 5.6542000000E-07},
            {5.9102000000E-07, 5.6874000000E-07},
            {5.9508000000E-07, 5.7201000000E-07},
            {5.9916000000E-07, 5.7529000000E-07},
            {6.0318000000E-07, 5.7858000000E-07},
            {6.0725000000E-07, 5.8189000000E-07},
            {6.1130000000E-07, 5.8522000000E-07},
            {6.1531000000E-07, 5.8853000000E-07},
            {6.1937000000E-07, 5.9188000000E-07},
            {6.2339000000E-07, 5.9518000000E-07},
            {6.2741000000E-07, 5.9854000000E-07},
            {6.3143000000E-07, 6.0191000000E-07},
            {6.3545000000E-07, 6.0527000000E-07},
            {6.3944000000E-07, 6.0863000000E-07},
            {6.4346000000E-07, 6.1202000000E-07},
            {6.4745000000E-07, 6.1540000000E-07},
            {6.5144000000E-07, 6.1880000000E-07},
            {6.5544000000E-07, 6.2220000000E-07},
            {6.5946000000E-07, 6.2563000000E-07},
            {6.6343000000E-07, 6.2905000000E-07},
            {6.6741000000E-07, 6.3247000000E-07},
            {6.7141000000E-07, 6.3589000000E-07},
            {6.7541000000E-07, 6.3936000000E-07},
            {6.7938000000E-07, 6.4279000000E-07},
            {6.8335000000E-07, 6.4624000000E-07},
            {6.8731000000E-07, 6.4969000000E-07},
            {6.9131000000E-07, 6.5315000000E-07},
            {6.9525000000E-07, 6.5667000000E-07},
            {6.9922000000E-07, 6.6015000000E-07},
            {7.0318000000E-07, 6.6365000000E-07},
            {7.0716000000E-07, 6.6717000000E-07},
            {7.1113000000E-07, 6.7072000000E-07},
            {7.1510000000E-07, 6.7431000000E-07},
            {7.1903000000E-07, 6.7704000000E-07},
            {7.2299000000E-07, 6.8057000000E-07},
            {7.2692000000E-07, 6.8408000000E-07},
            {7.3085000000E-07, 6.8761000000E-07},
            {7.3478000000E-07, 6.9110000000E-07},
            {7.3873000000E-07, 6.9465000000E-07},
            {7.4270000000E-07, 6.9820000000E-07},
            {7.4667000000E-07, 7.0175000000E-07},
            {7.5061000000E-07, 7.0531000000E-07},
            {7.5457000000E-07, 7.0887000000E-07},
            {7.5851000000E-07, 7.1244000000E-07},
            {7.6247000000E-07, 7.1600000000E-07},
            {7.6642000000E-07, 7.1958000000E-07},
            {7.7036000000E-07, 7.2317000000E-07},
            {7.7425000000E-07, 7.2674000000E-07},
            {7.7822000000E-07, 7.3031000000E-07},
            {7.8213000000E-07, 7.3395000000E-07},
            {7.8605000000E-07, 7.3756000000E-07},
            {7.8998000000E-07, 7.4114000000E-07},
            {7.9392000000E-07, 7.4478000000E-07},
            {7.9786000000E-07, 7.4845000000E-07},
            {8.0176000000E-07, 7.5205000000E-07},
            {8.0568000000E-07, 7.5572000000E-07},
            {8.0960000000E-07, 7.5936000000E-07},
            {8.1354000000E-07, 7.6299000000E-07},
            {8.1743000000E-07, 7.6667000000E-07},
            {8.2136000000E-07, 7.7034000000E-07},
            {8.2527000000E-07, 7.7400000000E-07},
            {8.2918000000E-07, 7.7770000000E-07},
            {8.3310000000E-07, 7.8140000000E-07},
            {8.3704000000E-07, 7.8512000000E-07},
            {8.4092000000E-07, 7.8877000000E-07},
            {8.4489000000E-07, 7.9249000000E-07},
            {8.4880000000E-07, 7.9619000000E-07},
            {8.5270000000E-07, 7.9991000000E-07},
            {8.5665000000E-07, 8.0367000000E-07},
            {8.6057000000E-07, 8.0737000000E-07},
            {8.6451000000E-07, 8.1112000000E-07},
            {8.6842000000E-07, 8.1487000000E-07},
            {8.7237000000E-07, 8.1861000000E-07},
            {8.7559000000E-07, 8.2240000000E-07},
            {8.7963000000E-07, 8.2617000000E-07},
            {8.8365000000E-07, 8.2995000000E-07},
            {8.8763000000E-07, 8.3375000000E-07},
            {8.9160000000E-07, 8.3754000000E-07},
            {8.9558000000E-07, 8.4132000000E-07},
            {8.9955000000E-07, 8.4509000000E-07},
            {9.0349000000E-07, 8.4896000000E-07},
            {9.0748000000E-07, 8.5277000000E-07},
            {9.1143000000E-07, 8.5658000000E-07},
            {9.1543000000E-07, 8.6047000000E-07},
            {9.1936000000E-07, 8.6431000000E-07},
            {9.2337000000E-07, 8.6820000000E-07},
            {9.2735000000E-07, 8.7206000000E-07},
            {9.3135000000E-07, 8.7592000000E-07},
            {9.3531000000E-07, 8.7983000000E-07},
            {9.3932000000E-07, 8.8372000000E-07},
            {9.4328000000E-07, 8.8760000000E-07},
            {9.4726000000E-07, 8.9151000000E-07},
            {9.5125000000E-07, 8.9545000000E-07},
            {9.5524000000E-07, 8.9936000000E-07},
            {9.5922000000E-07, 9.0326000000E-07},
            {9.6321000000E-07, 9.0724000000E-07},
            {9.6721000000E-07, 9.1119000000E-07},
            {9.7121000000E-07, 9.1515000000E-07},
            {9.7516000000E-07, 9.1912000000E-07},
            {9.7916000000E-07, 9.2308000000E-07},
            {9.8321000000E-07, 9.2707000000E-07},
            {9.8721000000E-07, 9.3107000000E-07},
            {9.9120000000E-07, 9.3507000000E-07},
            {9.9524000000E-07, 9.3912000000E-07},
            {9.9924000000E-07, 9.4313000000E-07},
            {1.0031000000E-06, 9.4716000000E-07},
            {1.0073200000E-06, 9.5121000000E-07},
            {1.0113700000E-06, 9.5528000000E-07},
            {1.0154000000E-06, 9.5933000000E-07},
            {1.0194900000E-06, 9.6341000000E-07},
            {1.0235900000E-06, 9.6755000000E-07},
            {1.0276100000E-06, 9.7160000000E-07},
            {1.0316700000E-06, 9.7570000000E-07},
            {1.0357200000E-06, 9.7983000000E-07},
            {1.0397800000E-06, 9.8399000000E-07},
            {1.0438900000E-06, 9.8816000000E-07},
            {1.0479800000E-06, 9.9231000000E-07},
            {1.0520400000E-06, 9.9659000000E-07},
            {1.0561400000E-06, 1.0006600000E-06},
            {1.0602600000E-06, 1.0048700000E-06},
            {1.0643500000E-06, 1.0090600000E-06},
            {1.0684600000E-06, 1.0132500000E-06},
            {1.0725700000E-06, 1.0174800000E-06},
            {1.0766700000E-06, 1.0217500000E-06},
            {1.0808100000E-06, 1.0260100000E-06},
            {1.0849500000E-06, 1.0302600000E-06},
            {1.0890800000E-06, 1.0345400000E-06},
            {1.0932400000E-06, 1.0388100000E-06},
            {1.0974500000E-06, 1.0431800000E-06},
            {1.1015400000E-06, 1.0474600000E-06},
            {1.1057600000E-06, 1.0518000000E-06},
            {1.1099300000E-06, 1.0561500000E-06},
            {1.1140500000E-06, 1.0604600000E-06},
            {1.1182900000E-06, 1.0648700000E-06},
            {1.1225200000E-06, 1.0692800000E-06},
            {1.1267000000E-06, 1.0737200000E-06},
            {1.1309000000E-06, 1.0781600000E-06},
            {1.1351400000E-06, 1.0826500000E-06},
            {1.1393700000E-06, 1.0870700000E-06},
            {1.1436300000E-06, 1.0915400000E-06},
            {1.1478300000E-06, 1.0960400000E-06},
            {1.1520200000E-06, 1.1005100000E-06},
            {1.1562800000E-06, 1.1050200000E-06},
            {1.1605600000E-06, 1.1095800000E-06},
            {1.1647500000E-06, 1.1141100000E-06},
            {1.1690400000E-06, 1.1186900000E-06},
            {1.1733200000E-06, 1.1232800000E-06},
            {1.1775500000E-06, 1.1278200000E-06},
            {1.1819000000E-06, 1.1324200000E-06},
            {1.1862000000E-06, 1.1370400000E-06},
            {1.1904900000E-06, 1.1417000000E-06},
            {1.1948000000E-06, 1.1463800000E-06},
            {1.1991100000E-06, 1.1510700000E-06},
            {1.2034300000E-06, 1.1557800000E-06},
            {1.2077800000E-06, 1.1605200000E-06},
            {1.2121200000E-06, 1.1653200000E-06},
            {1.2164600000E-06, 1.1700600000E-06},
            {1.2208300000E-06, 1.1748000000E-06},
            {1.2252100000E-06, 1.1796400000E-06},
            {1.2295900000E-06, 1.1844300000E-06},
            {1.2339700000E-06, 1.1892700000E-06},
            {1.2383700000E-06, 1.1941400000E-06},
            {1.2427200000E-06, 1.1990600000E-06},
            {1.2471300000E-06, 1.2039700000E-06},
            {1.2515800000E-06, 1.2089000000E-06},
            {1.2559600000E-06, 1.2138600000E-06},
            {1.2604100000E-06, 1.2188200000E-06},
            {1.2648000000E-06, 1.2238200000E-06},
            {1.2692700000E-06, 1.2288700000E-06},
            {1.2737000000E-06, 1.2339100000E-06},
            {1.2782500000E-06, 1.2390000000E-06},
            {1.2826500000E-06, 1.2441100000E-06},
            {1.2871200000E-06, 1.2492300000E-06},
            {1.2915800000E-06, 1.2544200000E-06},
            {1.2960200000E-06, 1.2596200000E-06},
            {1.3005000000E-06, 1.2648400000E-06},
            {1.3049800000E-06, 1.2701100000E-06},
            {1.3094800000E-06, 1.2753700000E-06},
            {1.3140100000E-06, 1.2807000000E-06},
            {1.3185300000E-06, 1.2860600000E-06},
            {1.3230800000E-06, 1.2914900000E-06},
            {1.3276300000E-06, 1.2969000000E-06},
            {1.3321300000E-06, 1.3024300000E-06},
            {1.3367100000E-06, 1.3078100000E-06},
            {1.3412900000E-06, 1.3133400000E-06},
            {1.3458800000E-06, 1.3189100000E-06},
            {1.3503900000E-06, 1.3245000000E-06},
            {1.3549700000E-06, 1.3302100000E-06},
            {1.3596200000E-06, 1.3358800000E-06},
            {1.3642100000E-06, 1.3416100000E-06},
            {1.3688400000E-06, 1.3474300000E-06},
            {1.3734900000E-06, 1.3532700000E-06},
            {1.3781000000E-06, 1.3592000000E-06},
            {1.3828000000E-06, 1.3651900000E-06},
            {1.3874400000E-06, 1.3712600000E-06},
            {1.3920900000E-06, 1.3774300000E-06},
            {1.3967500000E-06, 1.3836700000E-06},
            {1.4014400000E-06, 1.3899800000E-06},
            {1.4061000000E-06, 1.3964100000E-06},
            {1.4108000000E-06, 1.4029300000E-06},
            {1.4155100000E-06, 1.4096300000E-06},
            {1.4202000000E-06, 1.4164500000E-06},
            {1.4249100000E-06, 1.4236200000E-06}
    };

    public static final double[] VGS_transferCharacteristics = {-10, -9.9, -9.8, -9.7, -9.6, -9.5, -9.4, -9.3, -9.2, -9.1, -9, -8.9, -8.8, -8.7, -8.6, -8.5, -8.4, -8.3, -8.2, -8.1, -8, -7.9, -7.8, -7.7, -7.6, -7.5, -7.4, -7.3, -7.2, -7.1, -7, -6.9, -6.8, -6.7, -6.6, -6.5, -6.4, -6.3, -6.2, -6.1, -6, -5.9, -5.8, -5.7, -5.6, -5.5, -5.4, -5.3, -5.2, -5.1, -5, -4.9, -4.8, -4.7, -4.6, -4.5, -4.4, -4.3, -4.2, -4.1, -4, -3.9, -3.8, -3.7, -3.6, -3.5, -3.4, -3.3, -3.2, -3.1, -3, -2.9, -2.8, -2.7, -2.6, -2.5, -2.4, -2.3, -2.2, -2.1, -2, -1.9, -1.8, -1.7, -1.6, -1.5, -1.4, -1.3, -1.2, -1.1, -1, -0.9, -0.8, -0.7, -0.6, -0.5, -0.4, -0.3, -0.2, -0.1, 0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1, 1.1, 1.2, 1.3, 1.4, 1.5, 1.6, 1.7, 1.8, 1.9, 2, 2.1, 2.2, 2.3, 2.4, 2.5, 2.6, 2.7, 2.8, 2.9, 3, 3.1, 3.2, 3.3, 3.4, 3.5, 3.6, 3.7, 3.8, 3.9, 4, 4.1, 4.2, 4.3, 4.4, 4.5, 4.6, 4.7, 4.8, 4.9, 5, 5.1, 5.2, 5.3, 5.4, 5.5, 5.6, 5.7, 5.8, 5.9, 6, 6.1, 6.2, 6.3, 6.4, 6.5, 6.6, 6.7, 6.8, 6.9, 7, 7.1, 7.2, 7.3, 7.4, 7.5, 7.6, 7.7, 7.8, 7.9, 8, 8.1, 8.2, 8.3, 8.4, 8.5, 8.6, 8.7, 8.8, 8.9, 9, 9.1, 9.2, 9.3, 9.4, 9.5, 9.6, 9.7, 9.8, 9.9, 10, 10.1, 10.2, 10.3, 10.4, 10.5, 10.6, 10.7, 10.8, 10.9, 11, 11.1, 11.2, 11.3, 11.4, 11.5, 11.6, 11.7, 11.8, 11.9, 12, 12.1, 12.2, 12.3, 12.4, 12.5, 12.6, 12.7, 12.8, 12.9, 13, 13.1, 13.2, 13.3, 13.4, 13.5, 13.6, 13.7, 13.8, 13.9, 14, 14.1, 14.2, 14.3, 14.4, 14.5, 14.6, 14.7, 14.8, 14.9, 15, 15.1, 15.2, 15.3, 15.4, 15.5, 15.6, 15.7, 15.8, 15.9, 16, 16.1, 16.2, 16.3, 16.4, 16.5, 16.6, 16.7, 16.8, 16.9, 17, 17.1, 17.2, 17.3, 17.4, 17.5, 17.6, 17.7, 17.8, 17.9, 18};
    public static final double VDS_transferCharacteristics = 30;
    public static final double[] IAA_transferCharacteristics = {1.0e-10, 1.0e-05};

    public static final double[] Ioff_IdVg = {7.7143E-07, 1.15488E-06};

    public static double tmeasure = 0.1; // 0.1V/100ms // Id-Vd, Id-Vg

    public static double trap_duration_time = 7;

    @Override
    public void setup(final EvolutionState state, final Parameter base) {
        super.setup(state, base);
    }

    @Override
    public void evaluate(final EvolutionState state, final Individual ind, final int subpopulation, final int thread) {

        // The individual is already evaluated
        if (ind.evaluated) {
            return;
        }

        if (!(ind instanceof OFET_FULL_P3HT_10mg_ml_5000rpm_L_10_OtftVectorIndividual)) {
            state.output.fatal("The individuals for this problem should be OFET_FULL_P3HT_10mg_ml_5000rpm_L_10_OtftVectorIndividual.");
        }

        OFET_FULL_P3HT_10mg_ml_5000rpm_L_10_OtftVectorIndividual temp = (OFET_FULL_P3HT_10mg_ml_5000rpm_L_10_OtftVectorIndividual) ind;
        double[] genome = temp.genome;
        int numDecisionVars = genome.length;
        double[] objectives = ((MultiObjectiveFitness) ind.fitness).getObjectives();
        double numObjectives = objectives.length;
        double mu0, gamma, vt, vss, ms, va_prima, tao, Ms;
        double[] beta_IdVg = new double[2];
        double[] Ms_IdVd = new double[IVexp_outputCharacteristics.length];

        int numsets, incurvas;
        double vt0_IdVg_ini, vt0_IdVg_fin, tao2;
        numsets = IVexp_transferCharacteristics[0].length;
        incurvas = IVexp_transferCharacteristics.length;
        double[][] Ms_IdVg = new double[incurvas][numsets];

        /* considering two traps */

        if (numDecisionVars == 12) {

            mu0 = genome[0];
            gamma = genome[1];
            vt = genome[2];
            vss = genome[3];
            ms = genome[4];
            Ms = genome[5];
            va_prima = genome[6];
            tao = genome[7];
            beta_IdVg[0] = genome[8];
            beta_IdVg[1] = genome[9];
            vt0_IdVg_ini = genome[10];
            tao2 = genome[11];

        } else {

            mu0 = 3.0e-05;
            gamma = 0.25;
            tao = 2.0;
            tao2 = 1.3;
            vt = genome[0];
            vss = genome[1];
            ms = genome[2];
            Ms = genome[3];
            va_prima = genome[4];
            beta_IdVg[0] = genome[5];
            beta_IdVg[1] = genome[6];
            vt0_IdVg_ini = genome[7];
        }

        vt0_IdVg_fin = vt;

        for (int i = 0; i < IVexp_outputCharacteristics.length; i++)
        {
            Ms_IdVd[i] = Ms;
        }

        for (int i = 0; i < incurvas; i++)
        {
            for (int j = 0; j < numsets; j++)
            {
                Ms_IdVg[i][j] = Ms;
            }
        }


        /* considering two traps */
        objectives[0] = Subthreshold.outputCharacteristics(IVexp_outputCharacteristics, IAA, VGS_outputCharacteristics, VDS_outputCharacteristics, vt, vss, ms, Ms_IdVd, gamma, mu0, Cox, W, L, va_prima);
        objectives[1] = ec.evolutionary_extraction_procedure.models.draincurrentmodel.Hysteresis.Subthreshold.IdVg(IVexp_transferCharacteristics, IAA_transferCharacteristics, VGS_transferCharacteristics, VDS_transferCharacteristics, vt0_IdVg_ini, vt0_IdVg_fin, vss, Ms_IdVg, ms, gamma,  mu0, Cox, W, L, va_prima, tao, beta_IdVg, Ioff_IdVg, 0.0, tmeasure, trap_duration_time, tao2);

        // objective values assignment
        ((MultiObjectiveFitness) ind.fitness).setObjectives(state, objectives);
        ind.evaluated = true;
    }
}
