package ec.app.ThinFilmTransistors.OTFT.P3HT_ZnO_Hybrid.P3HT_10mg_ml_5000rpm;

import ec.EvolutionState;
import ec.Individual;
import ec.Problem;
import ec.evolutionary_extraction_procedure.models.draincurrentmodel.MarinovJimenezTejada.Subthreshold;
import ec.multiobjective.MultiObjectiveFitness;
import ec.simple.SimpleProblemForm;
import ec.util.Parameter;
import ec.vector.ThinFilmTransistors.OTFT.P3HT_ZnO_Hybrid.P3HT_10mg_ml_5000rpm.OFET_FULL_P3HT_10mg_ml_5000rpm_L_20_OtftVectorIndividual;

public class Full_OFET_L_20um extends Problem implements SimpleProblemForm {

    private static final long serialVersionUID = 1L;

    public static double W = 1;  //(cm) width
    public static double L = 0.002; // (cm) length
    public static double Cox = 15e-09; // Ci = 15nFcm−2

    public static final double[][] IVexp_outputCharacteristics = {
            {0.00E+00, 0.00E+00, 0.00E+00, 0.00E+00, 0.00E+00, 0.00E+00, 0.00E+00},
            {1.82E-08, 2.09E-08, 2.38E-08, 2.71E-08, 3.07E-08, 3.45E-08, 3.84E-08},
            {3.56E-08, 4.27E-08, 4.90E-08, 5.58E-08, 6.32E-08, 7.08E-08, 7.86E-08},
            {5.22E-08, 6.34E-08, 7.29E-08, 8.28E-08, 9.37E-08, 1.05E-07, 1.16E-07},
            {6.81E-08, 8.31E-08, 9.56E-08, 1.09E-07, 1.23E-07, 1.37E-07, 1.52E-07},
            {8.32E-08, 1.02E-07, 1.18E-07, 1.34E-07, 1.51E-07, 1.68E-07, 1.86E-07},
            {9.77E-08, 1.20E-07, 1.39E-07, 1.57E-07, 1.78E-07, 1.98E-07, 2.19E-07},
            {1.12E-07, 1.38E-07, 1.59E-07, 1.81E-07, 2.03E-07, 2.27E-07, 2.51E-07},
            {1.25E-07, 1.54E-07, 1.79E-07, 2.03E-07, 2.28E-07, 2.55E-07, 2.81E-07},
            {1.37E-07, 1.71E-07, 1.97E-07, 2.24E-07, 2.53E-07, 2.81E-07, 3.11E-07},
            {1.49E-07, 1.86E-07, 2.16E-07, 2.45E-07, 2.76E-07, 3.07E-07, 3.39E-07},
            {1.61E-07, 2.01E-07, 2.33E-07, 2.65E-07, 2.99E-07, 3.33E-07, 3.67E-07},
            {1.71E-07, 2.15E-07, 2.50E-07, 2.85E-07, 3.21E-07, 3.57E-07, 3.94E-07},
            {1.82E-07, 2.28E-07, 2.66E-07, 3.04E-07, 3.42E-07, 3.81E-07, 4.20E-07},
            {1.92E-07, 2.41E-07, 2.82E-07, 3.22E-07, 3.63E-07, 4.04E-07, 4.45E-07},
            {2.01E-07, 2.53E-07, 2.97E-07, 3.40E-07, 3.83E-07, 4.26E-07, 4.70E-07},
            {2.10E-07, 2.65E-07, 3.12E-07, 3.57E-07, 4.02E-07, 4.48E-07, 4.94E-07},
            {2.18E-07, 2.76E-07, 3.26E-07, 3.74E-07, 4.21E-07, 4.69E-07, 5.17E-07},
            {2.26E-07, 2.87E-07, 3.39E-07, 3.90E-07, 4.40E-07, 4.90E-07, 5.40E-07},
            {2.34E-07, 2.97E-07, 3.52E-07, 4.05E-07, 4.58E-07, 5.10E-07, 5.62E-07},
            {2.41E-07, 3.06E-07, 3.64E-07, 4.20E-07, 4.75E-07, 5.29E-07, 5.83E-07},
            {2.47E-07, 3.16E-07, 3.76E-07, 4.34E-07, 4.92E-07, 5.48E-07, 6.04E-07},
            {2.53E-07, 3.24E-07, 3.87E-07, 4.48E-07, 5.08E-07, 5.67E-07, 6.25E-07},
            {2.59E-07, 3.33E-07, 3.98E-07, 4.61E-07, 5.24E-07, 5.85E-07, 6.45E-07},
            {2.64E-07, 3.41E-07, 4.08E-07, 4.74E-07, 5.39E-07, 6.02E-07, 6.65E-07},
            {2.69E-07, 3.48E-07, 4.18E-07, 4.86E-07, 5.54E-07, 6.19E-07, 6.84E-07},
            {2.73E-07, 3.55E-07, 4.27E-07, 4.98E-07, 5.68E-07, 6.35E-07, 7.02E-07},
            {2.77E-07, 3.61E-07, 4.36E-07, 5.09E-07, 5.82E-07, 6.51E-07, 7.20E-07},
            {2.81E-07, 3.67E-07, 4.44E-07, 5.20E-07, 5.94E-07, 6.67E-07, 7.37E-07},
            {2.85E-07, 3.72E-07, 4.52E-07, 5.30E-07, 6.07E-07, 6.81E-07, 7.54E-07},
            {2.88E-07, 3.77E-07, 4.60E-07, 5.40E-07, 6.19E-07, 6.96E-07, 7.71E-07},
            {2.91E-07, 3.81E-07, 4.67E-07, 5.50E-07, 6.31E-07, 7.10E-07, 7.87E-07},
            {2.94E-07, 3.85E-07, 4.73E-07, 5.58E-07, 6.42E-07, 7.23E-07, 8.02E-07},
            {2.96E-07, 3.89E-07, 4.79E-07, 5.67E-07, 6.53E-07, 7.36E-07, 8.17E-07},
            {2.99E-07, 3.92E-07, 4.85E-07, 5.75E-07, 6.63E-07, 7.48E-07, 8.31E-07},
            {3.01E-07, 3.96E-07, 4.90E-07, 5.83E-07, 6.73E-07, 7.60E-07, 8.45E-07},
            {3.04E-07, 3.98E-07, 4.94E-07, 5.90E-07, 6.82E-07, 7.72E-07, 8.59E-07},
            {3.06E-07, 4.01E-07, 4.99E-07, 5.96E-07, 6.91E-07, 7.83E-07, 8.72E-07},
            {3.08E-07, 4.04E-07, 5.03E-07, 6.02E-07, 6.99E-07, 7.93E-07, 8.84E-07},
            {3.10E-07, 4.06E-07, 5.06E-07, 6.08E-07, 7.07E-07, 8.03E-07, 8.97E-07},
            {3.12E-07, 4.09E-07, 5.10E-07, 6.13E-07, 7.15E-07, 8.13E-07, 9.08E-07}
    };

    public static final double[] VDS_outputCharacteristics = {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40};
    public static final double[] VGS_outputCharacteristics = {0, 4, 8, 12, 16, 20, 24};
    public static final double[] IAA = {1.0e-06, 1.0e-06, 1.0e-06, 1.0e-06, 1.0e-06, 1.0e-06, 1.0e-06};

    public static final double[][] IVexp_transferCharacteristics = {
            {1.3762000000E-07, 1.5550000000E-07},
            {1.4007000000E-07, 1.5696000000E-07},
            {1.4283000000E-07, 1.5842000000E-07},
            {1.4526000000E-07, 1.5987000000E-07},
            {1.4781000000E-07, 1.6133000000E-07},
            {1.5030000000E-07, 1.6281000000E-07},
            {1.5274000000E-07, 1.6428000000E-07},
            {1.5513000000E-07, 1.6578000000E-07},
            {1.5746000000E-07, 1.6727000000E-07},
            {1.5979000000E-07, 1.6877000000E-07},
            {1.6207000000E-07, 1.7029000000E-07},
            {1.6431000000E-07, 1.7178000000E-07},
            {1.6656000000E-07, 1.7327000000E-07},
            {1.6878000000E-07, 1.7480000000E-07},
            {1.7098000000E-07, 1.7632000000E-07},
            {1.7319000000E-07, 1.7807000000E-07},
            {1.7539000000E-07, 1.7938000000E-07},
            {1.7758000000E-07, 1.8090000000E-07},
            {1.7977000000E-07, 1.8244000000E-07},
            {1.8195000000E-07, 1.8401000000E-07},
            {1.8411000000E-07, 1.8559000000E-07},
            {1.8629000000E-07, 1.8718000000E-07},
            {1.8846000000E-07, 1.8875000000E-07},
            {1.9061000000E-07, 1.9034000000E-07},
            {1.9279000000E-07, 1.9191000000E-07},
            {1.9496000000E-07, 1.9351000000E-07},
            {1.9708000000E-07, 1.9510000000E-07},
            {1.9927000000E-07, 1.9669000000E-07},
            {2.0144000000E-07, 1.9832000000E-07},
            {2.0359000000E-07, 1.9991000000E-07},
            {2.0577000000E-07, 2.0152000000E-07},
            {2.0794000000E-07, 2.0316000000E-07},
            {2.1010000000E-07, 2.0478000000E-07},
            {2.1227000000E-07, 2.0640000000E-07},
            {2.1444000000E-07, 2.0806000000E-07},
            {2.1661000000E-07, 2.0971000000E-07},
            {2.1879000000E-07, 2.1134000000E-07},
            {2.2095000000E-07, 2.1298000000E-07},
            {2.2312000000E-07, 2.1461000000E-07},
            {2.2530000000E-07, 2.1628000000E-07},
            {2.2747000000E-07, 2.1795000000E-07},
            {2.2964000000E-07, 2.1961000000E-07},
            {2.3182000000E-07, 2.2126000000E-07},
            {2.3400000000E-07, 2.2297000000E-07},
            {2.3616000000E-07, 2.2467000000E-07},
            {2.3835000000E-07, 2.2636000000E-07},
            {2.4054000000E-07, 2.2809000000E-07},
            {2.4269000000E-07, 2.2979000000E-07},
            {2.4489000000E-07, 2.3149000000E-07},
            {2.4706000000E-07, 2.3323000000E-07},
            {2.4924000000E-07, 2.3496000000E-07},
            {2.5144000000E-07, 2.3670000000E-07},
            {2.5362000000E-07, 2.3845000000E-07},
            {2.5579000000E-07, 2.4022000000E-07},
            {2.5798000000E-07, 2.4198000000E-07},
            {2.6018000000E-07, 2.4373000000E-07},
            {2.6236000000E-07, 2.4549000000E-07},
            {2.6457000000E-07, 2.4728000000E-07},
            {2.6678000000E-07, 2.4907000000E-07},
            {2.6897000000E-07, 2.5084000000E-07},
            {2.7119000000E-07, 2.5262000000E-07},
            {2.7339000000E-07, 2.5442000000E-07},
            {2.7559000000E-07, 2.5623000000E-07},
            {2.7781000000E-07, 2.5804000000E-07},
            {2.8001000000E-07, 2.5987000000E-07},
            {2.8220000000E-07, 2.6170000000E-07},
            {2.8440000000E-07, 2.6351000000E-07},
            {2.8660000000E-07, 2.6534000000E-07},
            {2.8880000000E-07, 2.6716000000E-07},
            {2.9101000000E-07, 2.6899000000E-07},
            {2.9322000000E-07, 2.7085000000E-07},
            {2.9541000000E-07, 2.7268000000E-07},
            {2.9761000000E-07, 2.7452000000E-07},
            {2.9983000000E-07, 2.7639000000E-07},
            {3.0202000000E-07, 2.7825000000E-07},
            {3.0422000000E-07, 2.8012000000E-07},
            {3.0645000000E-07, 2.8202000000E-07},
            {3.0864000000E-07, 2.8390000000E-07},
            {3.1085000000E-07, 2.8577000000E-07},
            {3.1308000000E-07, 2.8770000000E-07},
            {3.1529000000E-07, 2.8961000000E-07},
            {3.1749000000E-07, 2.9151000000E-07},
            {3.1972000000E-07, 2.9344000000E-07},
            {3.2192000000E-07, 2.9534000000E-07},
            {3.2414000000E-07, 2.9726000000E-07},
            {3.2637000000E-07, 2.9921000000E-07},
            {3.2857000000E-07, 3.0113000000E-07},
            {3.3077000000E-07, 3.0304000000E-07},
            {3.3300000000E-07, 3.0499000000E-07},
            {3.3522000000E-07, 3.0692000000E-07},
            {3.3743000000E-07, 3.0885000000E-07},
            {3.3965000000E-07, 3.1083000000E-07},
            {3.4186000000E-07, 3.1280000000E-07},
            {3.4407000000E-07, 3.1475000000E-07},
            {3.4628000000E-07, 3.1673000000E-07},
            {3.4849000000E-07, 3.1871000000E-07},
            {3.5069000000E-07, 3.2069000000E-07},
            {3.5290000000E-07, 3.2267000000E-07},
            {3.5511000000E-07, 3.2464000000E-07},
            {3.5730000000E-07, 3.2662000000E-07},
            {3.5953000000E-07, 3.2860000000E-07},
            {3.6173000000E-07, 3.3062000000E-07},
            {3.6394000000E-07, 3.3262000000E-07},
            {3.6617000000E-07, 3.3465000000E-07},
            {3.6837000000E-07, 3.3667000000E-07},
            {3.7058000000E-07, 3.3869000000E-07},
            {3.7282000000E-07, 3.4076000000E-07},
            {3.7500000000E-07, 3.4281000000E-07},
            {3.7721000000E-07, 3.4485000000E-07},
            {3.7942000000E-07, 3.4693000000E-07},
            {3.8162000000E-07, 3.4900000000E-07},
            {3.8381000000E-07, 3.5067000000E-07},
            {3.8599000000E-07, 3.5267000000E-07},
            {3.8820000000E-07, 3.5475000000E-07},
            {3.9037000000E-07, 3.5679000000E-07},
            {3.9257000000E-07, 3.5882000000E-07},
            {3.9475000000E-07, 3.6081000000E-07},
            {3.9695000000E-07, 3.6286000000E-07},
            {3.9915000000E-07, 3.6490000000E-07},
            {4.0134000000E-07, 3.6697000000E-07},
            {4.0351000000E-07, 3.6904000000E-07},
            {4.0571000000E-07, 3.7109000000E-07},
            {4.0790000000E-07, 3.7316000000E-07},
            {4.1009000000E-07, 3.7523000000E-07},
            {4.1228000000E-07, 3.7726000000E-07},
            {4.1448000000E-07, 3.7928000000E-07},
            {4.1664000000E-07, 3.8134000000E-07},
            {4.1883000000E-07, 3.8341000000E-07},
            {4.2100000000E-07, 3.8548000000E-07},
            {4.2318000000E-07, 3.8754000000E-07},
            {4.2535000000E-07, 3.8956000000E-07},
            {4.2754000000E-07, 3.9165000000E-07},
            {4.2972000000E-07, 3.9375000000E-07},
            {4.3190000000E-07, 3.9586000000E-07},
            {4.3407000000E-07, 3.9796000000E-07},
            {4.3623000000E-07, 4.0005000000E-07},
            {4.3841000000E-07, 4.0216000000E-07},
            {4.4057000000E-07, 4.0424000000E-07},
            {4.4275000000E-07, 4.0636000000E-07},
            {4.4491000000E-07, 4.0846000000E-07},
            {4.4706000000E-07, 4.1057000000E-07},
            {4.4923000000E-07, 4.1271000000E-07},
            {4.5142000000E-07, 4.1481000000E-07},
            {4.5358000000E-07, 4.1691000000E-07},
            {4.5575000000E-07, 4.1901000000E-07},
            {4.5792000000E-07, 4.2106000000E-07},
            {4.6009000000E-07, 4.2319000000E-07},
            {4.6223000000E-07, 4.2532000000E-07},
            {4.6442000000E-07, 4.2746000000E-07},
            {4.6658000000E-07, 4.2957000000E-07},
            {4.6874000000E-07, 4.3171000000E-07},
            {4.7052000000E-07, 4.3384000000E-07},
            {4.7271000000E-07, 4.3597000000E-07},
            {4.7492000000E-07, 4.3813000000E-07},
            {4.7710000000E-07, 4.4023000000E-07},
            {4.7926000000E-07, 4.4234000000E-07},
            {4.8143000000E-07, 4.4448000000E-07},
            {4.8359000000E-07, 4.4664000000E-07},
            {4.8575000000E-07, 4.4879000000E-07},
            {4.8791000000E-07, 4.5094000000E-07},
            {4.9007000000E-07, 4.5308000000E-07},
            {4.9224000000E-07, 4.5523000000E-07},
            {4.9441000000E-07, 4.5740000000E-07},
            {4.9659000000E-07, 4.5956000000E-07},
            {4.9872000000E-07, 4.6168000000E-07},
            {5.0091000000E-07, 4.6384000000E-07},
            {5.0306000000E-07, 4.6597000000E-07},
            {5.0521000000E-07, 4.6809000000E-07},
            {5.0737000000E-07, 4.7027000000E-07},
            {5.0951000000E-07, 4.7244000000E-07},
            {5.1166000000E-07, 4.7461000000E-07},
            {5.1383000000E-07, 4.7681000000E-07},
            {5.1601000000E-07, 4.7899000000E-07},
            {5.1816000000E-07, 4.8119000000E-07},
            {5.2034000000E-07, 4.8339000000E-07},
            {5.2251000000E-07, 4.8557000000E-07},
            {5.2468000000E-07, 4.8776000000E-07},
            {5.2685000000E-07, 4.8996000000E-07},
            {5.2904000000E-07, 4.9215000000E-07},
            {5.3118000000E-07, 4.9436000000E-07},
            {5.3335000000E-07, 4.9658000000E-07},
            {5.3550000000E-07, 4.9879000000E-07},
            {5.3765000000E-07, 5.0099000000E-07},
            {5.3981000000E-07, 5.0325000000E-07},
            {5.4197000000E-07, 5.0548000000E-07},
            {5.4413000000E-07, 5.0770000000E-07},
            {5.4632000000E-07, 5.0997000000E-07},
            {5.4849000000E-07, 5.1220000000E-07},
            {5.5064000000E-07, 5.1442000000E-07},
            {5.5282000000E-07, 5.1674000000E-07},
            {5.5498000000E-07, 5.1889000000E-07},
            {5.5714000000E-07, 5.2114000000E-07},
            {5.5933000000E-07, 5.2341000000E-07},
            {5.6150000000E-07, 5.2569000000E-07},
            {5.6366000000E-07, 5.2794000000E-07},
            {5.6579000000E-07, 5.3023000000E-07},
            {5.6797000000E-07, 5.3248000000E-07},
            {5.7013000000E-07, 5.3475000000E-07},
            {5.7231000000E-07, 5.3704000000E-07},
            {5.7447000000E-07, 5.3931000000E-07},
            {5.7661000000E-07, 5.4156000000E-07},
            {5.7878000000E-07, 5.4386000000E-07},
            {5.8094000000E-07, 5.4614000000E-07},
            {5.8308000000E-07, 5.4842000000E-07},
            {5.8526000000E-07, 5.5072000000E-07},
            {5.8741000000E-07, 5.5302000000E-07},
            {5.8955000000E-07, 5.5534000000E-07},
            {5.9174000000E-07, 5.5769000000E-07},
            {5.9391000000E-07, 5.6003000000E-07},
            {5.9607000000E-07, 5.6234000000E-07},
            {5.9824000000E-07, 5.6468000000E-07},
            {6.0042000000E-07, 5.6702000000E-07},
            {6.0257000000E-07, 5.6934000000E-07},
            {6.0477000000E-07, 5.7172000000E-07},
            {6.0695000000E-07, 5.7406000000E-07},
            {6.0910000000E-07, 5.7636000000E-07},
            {6.1130000000E-07, 5.7876000000E-07},
            {6.1348000000E-07, 5.8111000000E-07},
            {6.1566000000E-07, 5.8346000000E-07},
            {6.1786000000E-07, 5.8586000000E-07},
            {6.2004000000E-07, 5.8825000000E-07},
            {6.2221000000E-07, 5.9062000000E-07},
            {6.2440000000E-07, 5.9303000000E-07},
            {6.2659000000E-07, 5.9542000000E-07},
            {6.2877000000E-07, 5.9782000000E-07},
            {6.3097000000E-07, 6.0024000000E-07},
            {6.3319000000E-07, 6.0270000000E-07},
            {6.3539000000E-07, 6.0512000000E-07},
            {6.3760000000E-07, 6.0758000000E-07},
            {6.3980000000E-07, 6.1002000000E-07},
            {6.4197000000E-07, 6.1248000000E-07},
            {6.4421000000E-07, 6.1495000000E-07},
            {6.4639000000E-07, 6.1742000000E-07},
            {6.4857000000E-07, 6.1993000000E-07},
            {6.5077000000E-07, 6.2240000000E-07},
            {6.5299000000E-07, 6.2488000000E-07},
            {6.5520000000E-07, 6.2737000000E-07},
            {6.5743000000E-07, 6.2989000000E-07},
            {6.5965000000E-07, 6.3239000000E-07},
            {6.6185000000E-07, 6.3488000000E-07},
            {6.6409000000E-07, 6.3741000000E-07},
            {6.6630000000E-07, 6.3995000000E-07},
            {6.6849000000E-07, 6.4250000000E-07},
            {6.7072000000E-07, 6.4507000000E-07},
            {6.7294000000E-07, 6.4763000000E-07},
            {6.7517000000E-07, 6.5018000000E-07},
            {6.7743000000E-07, 6.5277000000E-07},
            {6.7965000000E-07, 6.5534000000E-07},
            {6.8186000000E-07, 6.5791000000E-07},
            {6.8407000000E-07, 6.6049000000E-07},
            {6.8630000000E-07, 6.6309000000E-07},
            {6.8852000000E-07, 6.6569000000E-07},
            {6.9076000000E-07, 6.6838000000E-07},
            {6.9299000000E-07, 6.7108000000E-07},
            {6.9521000000E-07, 6.7379000000E-07},
            {6.9743000000E-07, 6.7651000000E-07},
            {6.9968000000E-07, 6.7924000000E-07},
            {7.0191000000E-07, 6.8197000000E-07},
            {7.0414000000E-07, 6.8476000000E-07},
            {7.0638000000E-07, 6.8757000000E-07},
            {7.0859000000E-07, 6.9040000000E-07},
            {7.1085000000E-07, 6.9318000000E-07},
            {7.1311000000E-07, 6.9600000000E-07},
            {7.1538000000E-07, 6.9889000000E-07},
            {7.1764000000E-07, 7.0179000000E-07},
            {7.1991000000E-07, 7.0471000000E-07},
            {7.2215000000E-07, 7.0767000000E-07},
            {7.2446000000E-07, 7.1064000000E-07},
            {7.2674000000E-07, 7.1363000000E-07},
            {7.2901000000E-07, 7.1668000000E-07},
            {7.3130000000E-07, 7.1974000000E-07},
            {7.3357000000E-07, 7.2284000000E-07},
            {7.3583000000E-07, 7.2598000000E-07},
            {7.3812000000E-07, 7.2919000000E-07},
            {7.4039000000E-07, 7.3240000000E-07},
            {7.4263000000E-07, 7.3568000000E-07},
            {7.4491000000E-07, 7.3904000000E-07},
            {7.4721000000E-07, 7.4243000000E-07},
            {7.4950000000E-07, 7.4596000000E-07},
            {7.5181000000E-07, 7.4956000000E-07},
            {7.5410000000E-07, 7.5332000000E-07}
    };

    public static final double[] VGS_transferCharacteristics = {-10, -9.9, -9.8, -9.7, -9.6, -9.5, -9.4, -9.3, -9.2, -9.1, -9, -8.9, -8.8, -8.7, -8.6, -8.5, -8.4, -8.3, -8.2, -8.1, -8, -7.9, -7.8, -7.7, -7.6, -7.5, -7.4, -7.3, -7.2, -7.1, -7, -6.9, -6.8, -6.7, -6.6, -6.5, -6.4, -6.3, -6.2, -6.1, -6, -5.9, -5.8, -5.7, -5.6, -5.5, -5.4, -5.3, -5.2, -5.1, -5, -4.9, -4.8, -4.7, -4.6, -4.5, -4.4, -4.3, -4.2, -4.1, -4, -3.9, -3.8, -3.7, -3.6, -3.5, -3.4, -3.3, -3.2, -3.1, -3, -2.9, -2.8, -2.7, -2.6, -2.5, -2.4, -2.3, -2.2, -2.1, -2, -1.9, -1.8, -1.7, -1.6, -1.5, -1.4, -1.3, -1.2, -1.1, -1, -0.9, -0.8, -0.7, -0.6, -0.5, -0.4, -0.3, -0.2, -0.1, 0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1, 1.1, 1.2, 1.3, 1.4, 1.5, 1.6, 1.7, 1.8, 1.9, 2, 2.1, 2.2, 2.3, 2.4, 2.5, 2.6, 2.7, 2.8, 2.9, 3, 3.1, 3.2, 3.3, 3.4, 3.5, 3.6, 3.7, 3.8, 3.9, 4, 4.1, 4.2, 4.3, 4.4, 4.5, 4.6, 4.7, 4.8, 4.9, 5, 5.1, 5.2, 5.3, 5.4, 5.5, 5.6, 5.7, 5.8, 5.9, 6, 6.1, 6.2, 6.3, 6.4, 6.5, 6.6, 6.7, 6.8, 6.9, 7, 7.1, 7.2, 7.3, 7.4, 7.5, 7.6, 7.7, 7.8, 7.9, 8, 8.1, 8.2, 8.3, 8.4, 8.5, 8.6, 8.7, 8.8, 8.9, 9, 9.1, 9.2, 9.3, 9.4, 9.5, 9.6, 9.7, 9.8, 9.9, 10, 10.1, 10.2, 10.3, 10.4, 10.5, 10.6, 10.7, 10.8, 10.9, 11, 11.1, 11.2, 11.3, 11.4, 11.5, 11.6, 11.7, 11.8, 11.9, 12, 12.1, 12.2, 12.3, 12.4, 12.5, 12.6, 12.7, 12.8, 12.9, 13, 13.1, 13.2, 13.3, 13.4, 13.5, 13.6, 13.7, 13.8, 13.9, 14, 14.1, 14.2, 14.3, 14.4, 14.5, 14.6, 14.7, 14.8, 14.9, 15, 15.1, 15.2, 15.3, 15.4, 15.5, 15.6, 15.7, 15.8, 15.9, 16, 16.1, 16.2, 16.3, 16.4, 16.5, 16.6, 16.7, 16.8, 16.9, 17, 17.1, 17.2, 17.3, 17.4, 17.5, 17.6, 17.7, 17.8, 17.9, 18};
    public static final double VDS_transferCharacteristics = 30;
    public static final double[] IAA_transferCharacteristics = {1.0e-10, 1.0e-05};

    public static final double[] Ioff_IdVg = {7.7143E-07, 1.15488E-06};

    public static double tmeasure = 0.1; // 0.1V/100ms // Id-Vd, Id-Vg

    public static double trap_duration_time = 7;

    @Override
    public void setup(final EvolutionState state, final Parameter base) {
        super.setup(state, base);
    }

    @Override
    public void evaluate(final EvolutionState state, final Individual ind, final int subpopulation, final int thread) {

        // The individual is already evaluated
        if (ind.evaluated) {
            return;
        }

        if (!(ind instanceof OFET_FULL_P3HT_10mg_ml_5000rpm_L_20_OtftVectorIndividual)) {
            state.output.fatal("The individuals for this problem should be OFET_FULL_P3HT_10mg_ml_5000rpm_L_20_OtftVectorIndividual.");
        }

        OFET_FULL_P3HT_10mg_ml_5000rpm_L_20_OtftVectorIndividual temp = (OFET_FULL_P3HT_10mg_ml_5000rpm_L_20_OtftVectorIndividual) ind;
        double[] genome = temp.genome;
        int numDecisionVars = genome.length;
        double[] objectives = ((MultiObjectiveFitness) ind.fitness).getObjectives();
        double numObjectives = objectives.length;
        double mu0, gamma, vt, vss, ms, va_prima, tao, Ms;
        double[] beta_IdVg = new double[2];
        double[] Ms_IdVd = new double[IVexp_outputCharacteristics.length];

        int numsets, incurvas;
        double vt0_IdVg_ini, vt0_IdVg_fin, tao2;
        numsets = IVexp_transferCharacteristics[0].length;
        incurvas = IVexp_transferCharacteristics.length;
        double[][] Ms_IdVg = new double[incurvas][numsets];

        if (numDecisionVars == 12) {

            mu0 = genome[0];
            gamma = genome[1];
            vt = genome[2];
            vss = genome[3];
            ms = genome[4];
            Ms = genome[5];
            va_prima = genome[6];
            tao = genome[7];
            beta_IdVg[0] = genome[8];
            beta_IdVg[1] = genome[9];
            vt0_IdVg_ini = genome[10];
            tao2 = genome[11];

        } else {
            mu0 = 3.0e-05;
            gamma = 0.25;
            tao = 2.0;
            tao2 = 1.3;
            vt = genome[0];
            vss = genome[1];
            ms = genome[2];
            Ms = genome[3];
            va_prima = genome[4];
            beta_IdVg[0] = genome[5];
            beta_IdVg[1] = genome[6];
            vt0_IdVg_ini = genome[7];
        }

        vt0_IdVg_fin = vt;

        for (int i = 0; i < IVexp_outputCharacteristics.length; i++)
        {
            Ms_IdVd[i] = Ms;
        }

        for (int i = 0; i < incurvas; i++)
        {
            for (int j = 0; j < numsets; j++)
            {
                Ms_IdVg[i][j] = Ms;
            }
        }


        /* considering two traps */
        objectives[0] = Subthreshold.outputCharacteristics(IVexp_outputCharacteristics, IAA, VGS_outputCharacteristics, VDS_outputCharacteristics, vt, vss, ms, Ms_IdVd, gamma, mu0, Cox, W, L, va_prima);
        objectives[1] = ec.evolutionary_extraction_procedure.models.draincurrentmodel.Hysteresis.Subthreshold.IdVg(IVexp_transferCharacteristics, IAA_transferCharacteristics, VGS_transferCharacteristics, VDS_transferCharacteristics, vt0_IdVg_ini, vt0_IdVg_fin, vss, Ms_IdVg, ms, gamma,  mu0, Cox, W, L, va_prima, tao, beta_IdVg, Ioff_IdVg, 0.0, tmeasure, trap_duration_time, tao2);

        // objective values assignment
        ((MultiObjectiveFitness) ind.fitness).setObjectives(state, objectives);
        ind.evaluated = true;
    }
}
