package ec.app.ThinFilmTransistors.OTFT.P3HT_ZnO_Hybrid.P3HT_10mg_ml_5000rpm;

import ec.EvolutionState;
import ec.Individual;
import ec.Problem;
import ec.evolutionary_extraction_procedure.models.draincurrentmodel.MarinovJimenezTejada.Subthreshold;
import ec.multiobjective.MultiObjectiveFitness;
import ec.simple.SimpleProblemForm;
import ec.util.Parameter;
import ec.vector.ThinFilmTransistors.OTFT.P3HT_ZnO_Hybrid.P3HT_10mg_ml_5000rpm.OFET_FULL_L_2_5um_OtftVectorIndividual;

public class Full_OFET_L_2_5um extends Problem implements SimpleProblemForm {

    private static final long serialVersionUID = 1L;

    public static double W = 1;  //(cm) width
    public static double L = 0.00025; // (cm) length
    public static double Cox = 15e-09; // Ci = 15nFcm−2

    public static final double[][] IVexp_outputCharacteristics = {
            {0.00E+00, 0.00E+00, 0.00E+00, 0.00E+00, 0.00E+00, 0.00E+00, 0.00E+00},
            {1.51E-07, 1.85E-07, 2.14E-07, 2.45E-07, 2.78E-07, 3.13E-07, 3.50E-07},
            {2.99E-07, 3.68E-07, 4.25E-07, 4.86E-07, 5.51E-07, 6.21E-07, 6.93E-07},
            {4.48E-07, 5.50E-07, 6.35E-07, 7.25E-07, 8.22E-07, 9.25E-07, 1.03E-06},
            {6.00E-07, 7.35E-07, 8.47E-07, 9.67E-07, 1.09E-06, 1.23E-06, 1.37E-06},
            {7.56E-07, 9.23E-07, 1.06E-06, 1.21E-06, 1.37E-06, 1.54E-06, 1.72E-06},
            {9.16E-07, 1.12E-06, 1.29E-06, 1.46E-06, 1.66E-06, 1.86E-06, 2.07E-06},
            {1.08E-06, 1.32E-06, 1.51E-06, 1.72E-06, 1.95E-06, 2.18E-06, 2.43E-06},
            {1.25E-06, 1.52E-06, 1.75E-06, 1.99E-06, 2.24E-06, 2.52E-06, 2.80E-06},
            {1.42E-06, 1.73E-06, 1.99E-06, 2.26E-06, 2.55E-06, 2.86E-06, 3.18E-06},
            {1.60E-06, 1.94E-06, 2.23E-06, 2.54E-06, 2.86E-06, 3.21E-06, 3.57E-06},
            {1.78E-06, 2.16E-06, 2.49E-06, 2.82E-06, 3.18E-06, 3.56E-06, 3.96E-06},
            {1.97E-06, 2.38E-06, 2.74E-06, 3.12E-06, 3.51E-06, 3.93E-06, 4.37E-06},
            {2.15E-06, 2.61E-06, 3.01E-06, 3.41E-06, 3.85E-06, 4.30E-06, 4.78E-06},
            {2.34E-06, 2.84E-06, 3.27E-06, 3.72E-06, 4.19E-06, 4.69E-06, 5.21E-06},
            {2.54E-06, 3.07E-06, 3.54E-06, 4.03E-06, 4.54E-06, 5.07E-06, 5.64E-06},
            {2.73E-06, 3.31E-06, 3.82E-06, 4.34E-06, 4.89E-06, 5.47E-06, 6.08E-06},
            {2.93E-06, 3.55E-06, 4.10E-06, 4.66E-06, 5.25E-06, 5.87E-06, 6.53E-06},
            {3.12E-06, 3.79E-06, 4.38E-06, 4.98E-06, 5.62E-06, 6.28E-06, 6.98E-06},
            {3.32E-06, 4.03E-06, 4.66E-06, 5.31E-06, 5.99E-06, 6.70E-06, 7.44E-06},
            {3.52E-06, 4.27E-06, 4.95E-06, 5.64E-06, 6.36E-06, 7.12E-06, 7.91E-06},
            {3.72E-06, 4.52E-06, 5.24E-06, 5.97E-06, 6.74E-06, 7.55E-06, 8.39E-06},
            {3.92E-06, 4.76E-06, 5.52E-06, 6.31E-06, 7.13E-06, 7.98E-06, 8.87E-06},
            {4.12E-06, 5.01E-06, 5.82E-06, 6.65E-06, 7.51E-06, 8.42E-06, 9.36E-06},
            {4.32E-06, 5.25E-06, 6.11E-06, 6.99E-06, 7.90E-06, 8.86E-06, 9.86E-06},
            {4.53E-06, 5.50E-06, 6.40E-06, 7.34E-06, 8.29E-06, 9.30E-06, 1.04E-05},
            {4.73E-06, 5.74E-06, 6.69E-06, 7.68E-06, 8.69E-06, 9.75E-06, 1.09E-05},
            {4.93E-06, 5.99E-06, 6.99E-06, 8.02E-06, 9.08E-06, 1.02E-05, 1.14E-05},
            {5.13E-06, 6.23E-06, 7.28E-06, 8.36E-06, 9.48E-06, 1.07E-05, 1.19E-05},
            {5.33E-06, 6.48E-06, 7.57E-06, 8.70E-06, 9.88E-06, 1.11E-05, 1.24E-05},
            {5.54E-06, 6.72E-06, 7.87E-06, 9.05E-06, 1.03E-05, 1.16E-05, 1.29E-05},
            {5.74E-06, 6.97E-06, 8.16E-06, 9.40E-06, 1.07E-05, 1.20E-05, 1.34E-05},
            {5.94E-06, 7.21E-06, 8.46E-06, 9.75E-06, 1.11E-05, 1.25E-05, 1.40E-05},
            {6.15E-06, 7.45E-06, 8.75E-06, 1.01E-05, 1.15E-05, 1.30E-05, 1.45E-05},
            {6.35E-06, 7.70E-06, 9.05E-06, 1.05E-05, 1.19E-05, 1.34E-05, 1.50E-05},
            {6.56E-06, 7.94E-06, 9.34E-06, 1.08E-05, 1.23E-05, 1.39E-05, 1.56E-05},
            {6.77E-06, 8.19E-06, 9.64E-06, 1.12E-05, 1.27E-05, 1.44E-05, 1.61E-05},
            {6.97E-06, 8.43E-06, 9.93E-06, 1.15E-05, 1.31E-05, 1.49E-05, 1.66E-05},
            {7.18E-06, 8.68E-06, 1.02E-05, 1.19E-05, 1.36E-05, 1.53E-05, 1.72E-05},
            {7.39E-06, 8.93E-06, 1.05E-05, 1.22E-05, 1.40E-05, 1.58E-05, 1.77E-05},
            {7.61E-06, 9.18E-06, 1.08E-05, 1.26E-05, 1.44E-05, 1.63E-05, 1.83E-05}
    };


    public static final double[][] IVexp_transferCharacteristics = {
            {3.06287E-06, 4.0663E-06},
            {3.1627E-06, 4.08371E-06},
            {3.22479E-06, 4.10116E-06},
            {3.27928E-06, 4.11855E-06},
            {3.33043E-06, 4.13594E-06},
            {3.37798E-06, 4.15367E-06},
            {3.42356E-06, 4.17083E-06},
            {3.46723E-06, 4.18844E-06},
            {3.50926E-06, 4.20664E-06},
            {3.55066E-06, 4.22471E-06},
            {3.59057E-06, 4.24295E-06},
            {3.6298E-06, 4.26041E-06},
            {3.66837E-06, 4.27858E-06},
            {3.70644E-06, 4.29725E-06},
            {3.74344E-06, 4.31521E-06},
            {3.78011E-06, 4.33366E-06},
            {3.81589E-06, 4.35206E-06},
            {3.85117E-06, 4.3707E-06},
            {3.88626E-06, 4.38904E-06},
            {3.92114E-06, 4.40766E-06},
            {3.95572E-06, 4.42661E-06},
            {3.98969E-06, 4.44532E-06},
            {4.02352E-06, 4.46368E-06},
            {4.05679E-06, 4.48219E-06},
            {4.08991E-06, 4.5011E-06},
            {4.12266E-06, 4.52034E-06},
            {4.15559E-06, 4.5392E-06},
            {4.18855E-06, 4.55859E-06},
            {4.22045E-06, 4.57759E-06},
            {4.25198E-06, 4.59678E-06},
            {4.28433E-06, 4.61617E-06},
            {4.31597E-06, 4.63576E-06},
            {4.34759E-06, 4.65487E-06},
            {4.37929E-06, 4.67421E-06},
            {4.41084E-06, 4.6938E-06},
            {4.44217E-06, 4.71378E-06},
            {4.47319E-06, 4.73273E-06},
            {4.50429E-06, 4.75228E-06},
            {4.53537E-06, 4.77198E-06},
            {4.56551E-06, 0.000004791},
            {4.59603E-06, 4.81034E-06},
            {4.6262E-06, 4.83043E-06},
            {4.65702E-06, 4.85006E-06},
            {4.68677E-06, 4.87016E-06},
            {4.71647E-06, 4.89022E-06},
            {4.74633E-06, 4.91027E-06},
            {4.77628E-06, 4.93032E-06},
            {4.80589E-06, 4.95054E-06},
            {4.83575E-06, 4.97067E-06},
            {4.86551E-06, 4.99129E-06},
            {4.89513E-06, 5.0114E-06},
            {4.92453E-06, 5.03141E-06},
            {4.95405E-06, 5.05181E-06},
            {4.98362E-06, 5.07161E-06},
            {5.01213E-06, 5.09179E-06},
            {5.04142E-06, 5.11204E-06},
            {5.07045E-06, 5.13258E-06},
            {5.09953E-06, 5.1535E-06},
            {5.12837E-06, 5.17414E-06},
            {5.15695E-06, 5.19482E-06},
            {5.18613E-06, 5.2157E-06},
            {5.21472E-06, 5.23665E-06},
            {5.24367E-06, 5.25749E-06},
            {5.27261E-06, 5.27827E-06},
            {5.30152E-06, 5.29883E-06},
            {5.33022E-06, 5.31996E-06},
            {5.3584E-06, 5.34123E-06},
            {5.38692E-06, 5.36281E-06},
            {5.4156E-06, 5.38417E-06},
            {5.44379E-06, 5.4052E-06},
            {5.47206E-06, 5.42655E-06},
            {5.5005E-06, 5.44783E-06},
            {5.52911E-06, 5.46938E-06},
            {5.55744E-06, 5.49139E-06},
            {5.58572E-06, 5.51311E-06},
            {5.61372E-06, 5.53424E-06},
            {5.64169E-06, 5.55569E-06},
            {5.66965E-06, 5.57683E-06},
            {5.69816E-06, 5.59861E-06},
            {5.72612E-06, 5.61967E-06},
            {5.75466E-06, 5.64152E-06},
            {5.78302E-06, 5.66395E-06},
            {5.81102E-06, 5.68582E-06},
            {5.83913E-06, 5.70767E-06},
            {5.86665E-06, 5.73002E-06},
            {5.89454E-06, 5.75269E-06},
            {5.92238E-06, 5.77469E-06},
            {5.95045E-06, 5.79702E-06},
            {5.97847E-06, 5.8189E-06},
            {6.00649E-06, 5.8414E-06},
            {6.03438E-06, 5.86398E-06},
            {6.06258E-06, 5.88636E-06},
            {6.09044E-06, 5.90912E-06},
            {6.11871E-06, 5.93208E-06},
            {6.14713E-06, 5.95483E-06},
            {6.17547E-06, 5.97787E-06},
            {6.20357E-06, 6.00083E-06},
            {6.23132E-06, 6.0231E-06},
            {6.25922E-06, 6.04611E-06},
            {6.28703E-06, 6.06935E-06},
            {6.31486E-06, 6.09252E-06},
            {6.34249E-06, 6.11597E-06},
            {6.37077E-06, 6.13957E-06},
            {6.3989E-06, 6.16295E-06},
            {6.42713E-06, 6.18641E-06},
            {6.45537E-06, 6.21002E-06},
            {6.48294E-06, 6.23419E-06},
            {6.51069E-06, 6.25822E-06},
            {6.53825E-06, 6.28186E-06},
            {6.56633E-06, 6.30598E-06},
            {6.5938E-06, 6.33026E-06},
            {6.62183E-06, 6.34774E-06},
            {6.65008E-06, 6.36961E-06},
            {6.6781E-06, 6.39346E-06},
            {6.70591E-06, 6.41685E-06},
            {6.73416E-06, 6.44025E-06},
            {6.76187E-06, 6.46404E-06},
            {6.7898E-06, 6.48811E-06},
            {6.81804E-06, 6.51199E-06},
            {6.84668E-06, 6.5361E-06},
            {6.87482E-06, 6.55968E-06},
            {6.90367E-06, 6.58378E-06},
            {6.93235E-06, 6.60773E-06},
            {6.96113E-06, 6.63239E-06},
            {6.9888E-06, 6.65718E-06},
            {7.01702E-06, 6.68107E-06},
            {7.04485E-06, 6.70602E-06},
            {7.07299E-06, 6.73029E-06},
            {7.10163E-06, 6.7548E-06},
            {7.1297E-06, 6.77964E-06},
            {7.15742E-06, 6.80526E-06},
            {7.18558E-06, 6.82988E-06},
            {7.21332E-06, 6.8546E-06},
            {7.24217E-06, 6.87923E-06},
            {7.27065E-06, 6.90412E-06},
            {7.29919E-06, 6.92929E-06},
            {7.32712E-06, 6.95477E-06},
            {7.35529E-06, 6.98016E-06},
            {7.38426E-06, 7.0056E-06},
            {7.41259E-06, 7.0308E-06},
            {7.44135E-06, 7.05666E-06},
            {7.46999E-06, 7.0823E-06},
            {7.49894E-06, 7.10868E-06},
            {7.52739E-06, 7.13386E-06},
            {7.55588E-06, 7.16013E-06},
            {7.58499E-06, 7.18586E-06},
            {7.61431E-06, 7.21201E-06},
            {7.64244E-06, 7.2384E-06},
            {7.67168E-06, 7.26448E-06},
            {7.70025E-06, 7.29051E-06},
            {7.72769E-06, 7.31685E-06},
            {7.75265E-06, 7.34325E-06},
            {7.78192E-06, 7.36905E-06},
            {7.81193E-06, 7.39579E-06},
            {7.84169E-06, 0.000007423},
            {7.87083E-06, 7.45009E-06},
            {7.89997E-06, 7.47756E-06},
            {7.9298E-06, 7.50462E-06},
            {7.95953E-06, 7.53127E-06},
            {7.98842E-06, 7.5581E-06},
            {8.01813E-06, 7.58467E-06},
            {8.0475E-06, 7.61139E-06},
            {8.07701E-06, 7.63856E-06},
            {8.10741E-06, 7.66529E-06},
            {8.13669E-06, 7.69326E-06},
            {8.16632E-06, 7.72082E-06},
            {8.19642E-06, 7.74915E-06},
            {8.22635E-06, 7.77723E-06},
            {8.25673E-06, 7.80539E-06},
            {8.28691E-06, 7.83311E-06},
            {8.31648E-06, 7.8611E-06},
            {8.34687E-06, 7.88933E-06},
            {8.37674E-06, 7.91742E-06},
            {8.40704E-06, 7.94513E-06},
            {8.43603E-06, 7.9729E-06},
            {8.46552E-06, 8.00126E-06},
            {8.49615E-06, 8.02926E-06},
            {8.5268E-06, 8.05808E-06},
            {8.55676E-06, 8.08673E-06},
            {8.58688E-06, 8.11593E-06},
            {8.61773E-06, 8.14547E-06},
            {8.64794E-06, 8.17483E-06},
            {8.67902E-06, 8.20435E-06},
            {8.70933E-06, 8.23378E-06},
            {8.73921E-06, 8.26297E-06},
            {8.76947E-06, 8.29288E-06},
            {8.80034E-06, 8.32258E-06},
            {8.8309E-06, 8.35191E-06},
            {8.8619E-06, 8.38113E-06},
            {8.89241E-06, 8.41109E-06},
            {8.92336E-06, 8.4412E-06},
            {8.95396E-06, 8.47152E-06},
            {8.98479E-06, 8.50113E-06},
            {9.01612E-06, 8.53157E-06},
            {9.04699E-06, 8.5626E-06},
            {9.07796E-06, 8.59281E-06},
            {9.10969E-06, 8.6238E-06},
            {9.14134E-06, 8.65482E-06},
            {9.1727E-06, 8.68569E-06},
            {9.20427E-06, 8.71726E-06},
            {9.23571E-06, 8.74905E-06},
            {9.26698E-06, 8.78054E-06},
            {9.29835E-06, 8.81204E-06},
            {9.33015E-06, 8.84333E-06},
            {9.36154E-06, 8.87496E-06},
            {9.39299E-06, 8.90668E-06},
            {9.42486E-06, 8.93962E-06},
            {9.45641E-06, 8.97197E-06},
            {9.48856E-06, 9.00448E-06},
            {9.52004E-06, 9.03773E-06},
            {9.55229E-06, 9.07017E-06},
            {9.58424E-06, 9.10282E-06},
            {9.61639E-06, 9.13626E-06},
            {9.64853E-06, 9.16971E-06},
            {9.68066E-06, 9.20296E-06},
            {9.71259E-06, 9.23607E-06},
            {9.74542E-06, 9.27099E-06},
            {9.77774E-06, 9.30437E-06},
            {9.81002E-06, 9.3386E-06},
            {9.8422E-06, 9.37218E-06},
            {9.87439E-06, 9.40636E-06},
            {9.9075E-06, 9.44109E-06},
            {9.94033E-06, 9.47579E-06},
            {9.97388E-06, 9.51027E-06},
            {1.00098E-05, 9.54561E-06},
            {1.00455E-05, 9.58046E-06},
            {1.00778E-05, 9.6163E-06},
            {1.01117E-05, 9.65119E-06},
            {1.01444E-05, 9.68658E-06},
            {1.01771E-05, 9.72203E-06},
            {1.02111E-05, 9.75794E-06},
            {1.02445E-05, 9.79335E-06},
            {1.02772E-05, 9.82963E-06},
            {1.03104E-05, 9.86649E-06},
            {1.03443E-05, 9.90291E-06},
            {1.03779E-05, 9.9396E-06},
            {1.04122E-05, 9.97758E-06},
            {1.04458E-05, 1.00202E-05},
            {1.04792E-05, 1.00571E-05},
            {1.05127E-05, 0.000010094},
            {1.05471E-05, 1.01331E-05},
            {1.05802E-05, 1.01707E-05},
            {1.06136E-05, 1.02086E-05},
            {1.06477E-05, 1.02474E-05},
            {1.06807E-05, 1.02865E-05},
            {0.000010715, 1.03243E-05},
            {1.07491E-05, 1.03641E-05},
            {1.07847E-05, 1.04044E-05},
            {1.08185E-05, 1.04434E-05},
            {1.08531E-05, 1.04847E-05},
            {1.08868E-05, 1.05252E-05},
            {1.09217E-05, 1.05661E-05},
            {1.09564E-05, 1.06082E-05},
            {1.09907E-05, 1.06497E-05},
            {1.10249E-05, 1.06907E-05},
            {1.10606E-05, 1.07332E-05},
            {0.000011095, 1.07761E-05},
            {1.11294E-05, 1.08173E-05},
            {1.11654E-05, 1.08611E-05},
            {1.11989E-05, 0.000010905},
            {1.12337E-05, 1.09481E-05},
            {1.12692E-05, 1.09904E-05},
            {1.13038E-05, 1.10336E-05},
            {1.13394E-05, 1.10777E-05},
            {1.13759E-05, 1.11228E-05},
            {1.14112E-05, 1.11669E-05},
            {1.14473E-05, 1.12132E-05},
            {1.14826E-05, 1.12598E-05},
            {1.15182E-05, 1.13063E-05},
            {1.15526E-05, 1.13541E-05},
            {1.15887E-05, 1.14025E-05},
            {1.16246E-05, 1.14519E-05},
            {1.16609E-05, 1.15014E-05},
            {1.16964E-05, 1.15519E-05},
            {1.17315E-05, 0.000011602},
            {0.000011768, 1.16548E-05},
            {1.18049E-05, 0.000011708},
            {1.18402E-05, 1.17628E-05},
            {1.18766E-05, 1.18189E-05},
            {1.19137E-05, 1.18767E-05},
            {0.00001195, 1.19362E-05}
    };

    public static final double[] VDS_outputCharacteristics = {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40};
    public static final double[] VGS_outputCharacteristics = {0, 4, 8, 12, 16, 20, 24};
    public static final double[] IAA = {1.0e-04, 1.0e-04, 1.0e-04, 1.0e-04, 1.0e-04, 1.0e-04, 1.0e-04};

    public static final double[] VGS_transferCharacteristics = {-10, -9.9, -9.8, -9.7, -9.6, -9.5, -9.4, -9.3, -9.2, -9.1, -9, -8.9, -8.8, -8.7, -8.6, -8.5, -8.4, -8.3, -8.2, -8.1, -8, -7.9, -7.8, -7.7, -7.6, -7.5, -7.4, -7.3, -7.2, -7.1, -7, -6.9, -6.8, -6.7, -6.6, -6.5, -6.4, -6.3, -6.2, -6.1, -6, -5.9, -5.8, -5.7, -5.6, -5.5, -5.4, -5.3, -5.2, -5.1, -5, -4.9, -4.8, -4.7, -4.6, -4.5, -4.4, -4.3, -4.2, -4.1, -4, -3.9, -3.8, -3.7, -3.6, -3.5, -3.4, -3.3, -3.2, -3.1, -3, -2.9, -2.8, -2.7, -2.6, -2.5, -2.4, -2.3, -2.2, -2.1, -2, -1.9, -1.8, -1.7, -1.6, -1.5, -1.4, -1.3, -1.2, -1.1, -1, -0.9, -0.8, -0.7, -0.6, -0.5, -0.4, -0.3, -0.2, -0.1, 0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1, 1.1, 1.2, 1.3, 1.4, 1.5, 1.6, 1.7, 1.8, 1.9, 2, 2.1, 2.2, 2.3, 2.4, 2.5, 2.6, 2.7, 2.8, 2.9, 3, 3.1, 3.2, 3.3, 3.4, 3.5, 3.6, 3.7, 3.8, 3.9, 4, 4.1, 4.2, 4.3, 4.4, 4.5, 4.6, 4.7, 4.8, 4.9, 5, 5.1, 5.2, 5.3, 5.4, 5.5, 5.6, 5.7, 5.8, 5.9, 6, 6.1, 6.2, 6.3, 6.4, 6.5, 6.6, 6.7, 6.8, 6.9, 7, 7.1, 7.2, 7.3, 7.4, 7.5, 7.6, 7.7, 7.8, 7.9, 8, 8.1, 8.2, 8.3, 8.4, 8.5, 8.6, 8.7, 8.8, 8.9, 9, 9.1, 9.2, 9.3, 9.4, 9.5, 9.6, 9.7, 9.8, 9.9, 10, 10.1, 10.2, 10.3, 10.4, 10.5, 10.6, 10.7, 10.8, 10.9, 11, 11.1, 11.2, 11.3, 11.4, 11.5, 11.6, 11.7, 11.8, 11.9, 12, 12.1, 12.2, 12.3, 12.4, 12.5, 12.6, 12.7, 12.8, 12.9, 13, 13.1, 13.2, 13.3, 13.4, 13.5, 13.6, 13.7, 13.8, 13.9, 14, 14.1, 14.2, 14.3, 14.4, 14.5, 14.6, 14.7, 14.8, 14.9, 15, 15.1, 15.2, 15.3, 15.4, 15.5, 15.6, 15.7, 15.8, 15.9, 16, 16.1, 16.2, 16.3, 16.4, 16.5, 16.6, 16.7, 16.8, 16.9, 17, 17.1, 17.2, 17.3, 17.4, 17.5, 17.6, 17.7, 17.8, 17.9, 18};
    public static final double VDS_transferCharacteristics = 30;
    public static final double[] IAA_transferCharacteristics = {1.0e-06, 1.0e-05};

    public static final double[] Ioff_IdVg = {7.7143E-07, 1.15488E-06};

    public static double tmeasure = 0.1; // 0.1V/100ms // Id-Vd, Id-Vg

    public static double trap_duration_time = 7;

    @Override
    public void setup(final EvolutionState state, final Parameter base) {
        super.setup(state, base);
    }

    @Override
    public void evaluate(final EvolutionState state, final Individual ind, final int subpopulation, final int thread) {

        // The individual is already evaluated
        if (ind.evaluated) {
            return;
        }

        if (!(ind instanceof OFET_FULL_L_2_5um_OtftVectorIndividual)) {
            state.output.fatal("The individuals for this problem should be OFET_L_5um_OtftVectorIndividual.");
        }

        OFET_FULL_L_2_5um_OtftVectorIndividual temp = (OFET_FULL_L_2_5um_OtftVectorIndividual) ind;
        double[] genome = temp.genome;
        int numDecisionVars = genome.length;
        double[] objectives = ((MultiObjectiveFitness) ind.fitness).getObjectives();
        double numObjectives = objectives.length;
        double mu0, gamma, vt, vss, ms, alpha, va_prima, tao, Ms, m2;
        double[] beta_IdVg = new double[2];
        double[] Ms_IdVd = new double[IVexp_outputCharacteristics.length];

        int numsets, incurvas;
        double vt0_IdVg_ini, vt0_IdVg_fin, tao2;
        numsets = IVexp_transferCharacteristics[0].length;
        incurvas = IVexp_transferCharacteristics.length;
        double[][] Ms_IdVg = new double[incurvas][numsets];

        /* considering two traps */

        if (numDecisionVars == 12) {

            mu0 = genome[0];
            gamma = genome[1];
            vt = genome[2];
            vss = genome[3];
            ms = genome[4];
            Ms = genome[5];
            va_prima = genome[6];
            tao = genome[7];
            beta_IdVg[0] = genome[8];
            beta_IdVg[1] = genome[9];
            vt0_IdVg_ini = genome[10];
            tao2 = genome[11];

        } else {

            mu0 = 3.0e-05;
            gamma = 0.25;
            tao = 2.0;
            tao2 = 1.3;
            vt = genome[0];
            vss = genome[1];
            ms = genome[2];
            Ms = genome[3];
            va_prima = genome[4];
            beta_IdVg[0] = genome[5];
            beta_IdVg[1] = genome[6];
            vt0_IdVg_ini = genome[7];
        }

        vt0_IdVg_fin = vt;

        for (int i = 0; i < IVexp_outputCharacteristics.length; i++)
        {
            Ms_IdVd[i] = Ms;
        }

        for (int i = 0; i < incurvas; i++)
        {
            for (int j = 0; j < numsets; j++)
            {
                Ms_IdVg[i][j] = Ms;
            }
        }


        /* considering two traps */
        objectives[0] = Subthreshold.outputCharacteristics(IVexp_outputCharacteristics, IAA, VGS_outputCharacteristics, VDS_outputCharacteristics, vt, vss, ms, Ms_IdVd, gamma, mu0, Cox, W, L, va_prima);
        objectives[1] = ec.evolutionary_extraction_procedure.models.draincurrentmodel.Hysteresis.Subthreshold.IdVg(IVexp_transferCharacteristics, IAA_transferCharacteristics, VGS_transferCharacteristics, VDS_transferCharacteristics, vt0_IdVg_ini, vt0_IdVg_fin, vss, Ms_IdVg, ms, gamma,  mu0, Cox, W, L, va_prima, tao, beta_IdVg, Ioff_IdVg, 0.0, tmeasure, trap_duration_time, tao2);

        // objective values assignment
        ((MultiObjectiveFitness) ind.fitness).setObjectives(state, objectives);
        ind.evaluated = true;
    }
}
