package ec.app.ThinFilmTransistors.OTFT.P3HT_ZnO_Hybrid.P3HT_10mg_ml_5000rpm;

import ec.EvolutionState;
import ec.Individual;
import ec.Problem;
import ec.evolutionary_extraction_procedure.models.draincurrentmodel.MarinovJimenezTejada.Subthreshold;
import ec.multiobjective.MultiObjectiveFitness;
import ec.simple.SimpleProblemForm;
import ec.util.Parameter;
import ec.vector.ThinFilmTransistors.OTFT.P3HT_ZnO_Hybrid.P3HT_10mg_ml_5000rpm.OFET_FULL_P3HT_10mg_ml_5000rpm_L_5_OtftVectorIndividual;

public class Full_OFET_L_5um extends Problem implements SimpleProblemForm {

    private static final long serialVersionUID = 1L;

    public static double W = 1;  //(cm) width
    public static double L = 0.0005; // (cm) length
    public static double Cox = 15e-09; // Ci = 15nFcm−2

    public static final double[][] IVexp_outputCharacteristics = {
            {0.00E+00, 0.00E+00, 0.00E+00, 0.00E+00, 0.00E+00, 0.00E+00, 0.00E+00},
            {6.28E-08, 7.58E-08, 8.71E-08, 9.93E-08, 1.13E-07, 1.28E-07, 1.44E-07},
            {1.24E-07, 1.51E-07, 1.74E-07, 1.99E-07, 2.25E-07, 2.55E-07, 2.88E-07},
            {1.82E-07, 2.23E-07, 2.58E-07, 2.94E-07, 3.34E-07, 3.78E-07, 4.25E-07},
            {2.40E-07, 2.94E-07, 3.39E-07, 3.87E-07, 4.39E-07, 4.96E-07, 5.58E-07},
            {2.96E-07, 3.64E-07, 4.20E-07, 4.78E-07, 5.42E-07, 6.12E-07, 6.88E-07},
            {3.52E-07, 4.33E-07, 4.99E-07, 5.68E-07, 6.43E-07, 7.26E-07, 8.16E-07},
            {4.08E-07, 5.01E-07, 5.77E-07, 6.57E-07, 7.44E-07, 8.39E-07, 9.42E-07},
            {4.64E-07, 5.68E-07, 6.56E-07, 7.46E-07, 8.43E-07, 9.50E-07, 1.07E-06},
            {5.19E-07, 6.36E-07, 7.34E-07, 8.34E-07, 9.42E-07, 1.06E-06, 1.19E-06},
            {5.74E-07, 7.03E-07, 8.11E-07, 9.22E-07, 1.04E-06, 1.17E-06, 1.31E-06},
            {6.29E-07, 7.70E-07, 8.89E-07, 1.01E-06, 1.14E-06, 1.28E-06, 1.43E-06},
            {6.85E-07, 8.36E-07, 9.66E-07, 1.10E-06, 1.24E-06, 1.39E-06, 1.56E-06},
            {7.40E-07, 9.03E-07, 1.04E-06, 1.19E-06, 1.34E-06, 1.50E-06, 1.68E-06},
            {7.95E-07, 9.69E-07, 1.12E-06, 1.27E-06, 1.44E-06, 1.61E-06, 1.80E-06},
            {8.50E-07, 1.04E-06, 1.20E-06, 1.36E-06, 1.53E-06, 1.72E-06, 1.92E-06},
            {9.04E-07, 1.10E-06, 1.27E-06, 1.45E-06, 1.63E-06, 1.83E-06, 2.04E-06},
            {9.58E-07, 1.17E-06, 1.35E-06, 1.54E-06, 1.73E-06, 1.94E-06, 2.16E-06},
            {1.01E-06, 1.23E-06, 1.43E-06, 1.62E-06, 1.83E-06, 2.05E-06, 2.29E-06},
            {1.07E-06, 1.30E-06, 1.50E-06, 1.71E-06, 1.93E-06, 2.16E-06, 2.41E-06},
            {1.12E-06, 1.36E-06, 1.58E-06, 1.80E-06, 2.03E-06, 2.27E-06, 2.53E-06},
            {1.17E-06, 1.43E-06, 1.65E-06, 1.88E-06, 2.13E-06, 2.38E-06, 2.65E-06},
            {1.22E-06, 1.49E-06, 1.73E-06, 1.97E-06, 2.22E-06, 2.49E-06, 2.77E-06},
            {1.27E-06, 1.55E-06, 1.80E-06, 2.06E-06, 2.32E-06, 2.60E-06, 2.89E-06},
            {1.32E-06, 1.61E-06, 1.88E-06, 2.14E-06, 2.42E-06, 2.71E-06, 3.02E-06},
            {1.37E-06, 1.67E-06, 1.95E-06, 2.23E-06, 2.51E-06, 2.82E-06, 3.14E-06},
            {1.41E-06, 1.73E-06, 2.02E-06, 2.31E-06, 2.61E-06, 2.93E-06, 3.26E-06},
            {1.46E-06, 1.79E-06, 2.09E-06, 2.39E-06, 2.70E-06, 3.03E-06, 3.38E-06},
            {1.50E-06, 1.85E-06, 2.16E-06, 2.47E-06, 2.80E-06, 3.14E-06, 3.50E-06},
            {1.55E-06, 1.91E-06, 2.23E-06, 2.56E-06, 2.89E-06, 3.25E-06, 3.62E-06},
            {1.59E-06, 1.96E-06, 2.30E-06, 2.64E-06, 2.99E-06, 3.35E-06, 3.73E-06},
            {1.63E-06, 2.01E-06, 2.37E-06, 2.72E-06, 3.08E-06, 3.46E-06, 3.85E-06},
            {1.67E-06, 2.07E-06, 2.43E-06, 2.79E-06, 3.17E-06, 3.56E-06, 3.97E-06},
            {1.71E-06, 2.12E-06, 2.49E-06, 2.87E-06, 3.26E-06, 3.66E-06, 4.08E-06},
            {1.75E-06, 2.17E-06, 2.56E-06, 2.95E-06, 3.35E-06, 3.76E-06, 4.20E-06},
            {1.79E-06, 2.21E-06, 2.62E-06, 3.02E-06, 3.43E-06, 3.86E-06, 4.31E-06},
            {1.83E-06, 2.26E-06, 2.68E-06, 3.10E-06, 3.52E-06, 3.96E-06, 4.43E-06},
            {1.87E-06, 2.31E-06, 2.74E-06, 3.17E-06, 3.61E-06, 4.06E-06, 4.54E-06},
            {1.91E-06, 2.35E-06, 2.80E-06, 3.24E-06, 3.69E-06, 4.16E-06, 4.65E-06},
            {1.94E-06, 2.40E-06, 2.85E-06, 3.31E-06, 3.77E-06, 4.26E-06, 4.76E-06},
            {1.98E-06, 2.44E-06, 2.91E-06, 3.38E-06, 3.86E-06, 4.35E-06, 4.87E-06}
    };

    public static final double[] VDS_outputCharacteristics = {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40};
    public static final double[] VGS_outputCharacteristics = {0, 4, 8, 12, 16, 20, 24};
    public static final double[] IAA = {1.0e-06, 1.0e-06, 1.0e-06, 1.0e-06, 1.0e-06, 1.0e-06, 1.0e-06};

    public static final double[][] IVexp_transferCharacteristics = {
        {7.7143E-07, 1.15488E-06},
        {7.9986E-07, 1.1605E-06},
        {8.2114E-07, 1.16613E-06},
        {8.405E-07, 1.17178E-06},
        {8.588E-07, 1.17745E-06},
        {8.7646E-07, 1.18323E-06},
        {8.931E-07, 1.18887E-06},
        {9.0932E-07, 1.19452E-06},
        {9.2507E-07, 1.20031E-06},
        {9.4051E-07, 1.20607E-06},
        {9.5568E-07, 1.21192E-06},
        {9.7059E-07, 1.21777E-06},
        {9.8517E-07, 1.22365E-06},
        {9.9959E-07, 1.22956E-06},
        {1.01486E-06, 1.23546E-06},
        {1.02776E-06, 1.24131E-06},
        {1.04161E-06, 1.24729E-06},
        {1.0552E-06, 1.25328E-06},
        {1.06869E-06, 1.25928E-06},
        {1.08203E-06, 1.26526E-06},
        {1.09513E-06, 1.27126E-06},
        {1.10824E-06, 1.27735E-06},
        {1.12106E-06, 1.28345E-06},
        {1.13388E-06, 1.28957E-06},
        {1.1465E-06, 1.29562E-06},
        {1.15901E-06, 1.30178E-06},
        {1.17135E-06, 1.30795E-06},
        {1.18362E-06, 1.3141E-06},
        {1.19577E-06, 1.32033E-06},
        {1.20784E-06, 1.3265E-06},
        {1.21982E-06, 1.33272E-06},
        {1.23152E-06, 0.000001339},
        {1.24327E-06, 1.3453E-06},
        {1.25488E-06, 1.35157E-06},
        {1.26636E-06, 1.35794E-06},
        {1.27773E-06, 1.36425E-06},
        {1.28917E-06, 1.37051E-06},
        {1.30036E-06, 1.37695E-06},
        {1.31148E-06, 1.38327E-06},
        {1.32249E-06, 1.38965E-06},
        {1.33339E-06, 1.39606E-06},
        {1.34428E-06, 1.40242E-06},
        {1.35501E-06, 1.40892E-06},
        {1.36579E-06, 1.4154E-06},
        {1.37633E-06, 1.42187E-06},
        {1.38686E-06, 1.42843E-06},
        {1.39741E-06, 1.43493E-06},
        {1.40776E-06, 1.44146E-06},
        {1.41801E-06, 1.44795E-06},
        {1.42831E-06, 1.45451E-06},
        {1.43847E-06, 1.46107E-06},
        {1.44859E-06, 1.46765E-06},
        {1.45856E-06, 1.47429E-06},
        {1.46847E-06, 1.48075E-06},
        {1.47845E-06, 1.48744E-06},
        {1.48826E-06, 1.49407E-06},
        {1.49808E-06, 1.50072E-06},
        {1.5079E-06, 1.50731E-06},
        {1.51747E-06, 1.51399E-06},
        {1.52708E-06, 1.52066E-06},
        {1.53667E-06, 1.52744E-06},
        {1.5461E-06, 1.53411E-06},
        {1.5556E-06, 1.54087E-06},
        {1.56503E-06, 1.54762E-06},
        {1.57442E-06, 1.55441E-06},
        {1.58371E-06, 1.56115E-06},
        {1.59307E-06, 1.56791E-06},
        {1.60232E-06, 1.57473E-06},
        {1.61148E-06, 1.58156E-06},
        {1.62061E-06, 1.58823E-06},
        {1.62984E-06, 1.59509E-06},
        {1.63893E-06, 0.000001602},
        {1.64799E-06, 1.60885E-06},
        {1.65706E-06, 1.61579E-06},
        {1.66599E-06, 1.62259E-06},
        {0.000001675, 1.62951E-06},
        {1.68392E-06, 1.63637E-06},
        {1.69282E-06, 1.64334E-06},
        {1.70168E-06, 1.65025E-06},
        {1.71053E-06, 1.65723E-06},
        {1.71941E-06, 1.66419E-06},
        {1.72818E-06, 1.67113E-06},
        {1.7369E-06, 1.67808E-06},
        {1.74571E-06, 1.6851E-06},
        {1.75438E-06, 1.69202E-06},
        {1.76308E-06, 1.69912E-06},
        {1.77171E-06, 1.70619E-06},
        {1.78049E-06, 1.7132E-06},
        {1.78908E-06, 1.72026E-06},
        {1.79775E-06, 1.72729E-06},
        {1.80629E-06, 1.7343E-06},
        {1.81484E-06, 1.74142E-06},
        {1.82332E-06, 1.74852E-06},
        {1.83189E-06, 1.75553E-06},
        {1.84041E-06, 1.76275E-06},
        {1.84882E-06, 1.76992E-06},
        {1.85738E-06, 1.77708E-06},
        {1.86585E-06, 1.78426E-06},
        {1.87429E-06, 1.79148E-06},
        {1.88276E-06, 1.79866E-06},
        {1.89112E-06, 1.80604E-06},
        {1.89951E-06, 1.81318E-06},
        {1.90787E-06, 1.82047E-06},
        {1.91618E-06, 1.82762E-06},
        {1.92465E-06, 1.83491E-06},
        {1.93302E-06, 1.84225E-06},
        {1.9413E-06, 1.84968E-06},
        {1.9496E-06, 1.85701E-06},
        {1.95795E-06, 1.86432E-06},
        {1.96616E-06, 1.87178E-06},
        {1.97442E-06, 1.87921E-06},
        {1.98274E-06, 1.88504E-06},
        {1.99105E-06, 1.89186E-06},
        {1.99926E-06, 1.89924E-06},
        {2.00743E-06, 1.90656E-06},
        {2.01574E-06, 1.91392E-06},
        {2.02398E-06, 1.92119E-06},
        {2.03218E-06, 1.92864E-06},
        {2.04039E-06, 1.93594E-06},
        {2.0485E-06, 1.94349E-06},
        {2.05664E-06, 1.95075E-06},
        {2.06488E-06, 1.95814E-06},
        {2.07302E-06, 1.96565E-06},
        {2.08113E-06, 1.97311E-06},
        {2.08941E-06, 1.98055E-06},
        {2.09758E-06, 1.98799E-06},
        {2.10569E-06, 1.99543E-06},
        {2.11369E-06, 2.00297E-06},
        {2.12189E-06, 2.01055E-06},
        {2.13011E-06, 2.01807E-06},
        {2.1382E-06, 2.0255E-06},
        {2.14628E-06, 2.03305E-06},
        {2.1544E-06, 2.0406E-06},
        {2.1625E-06, 2.04816E-06},
        {2.17057E-06, 2.05576E-06},
        {2.1787E-06, 2.06331E-06},
        {2.18688E-06, 2.07089E-06},
        {2.1949E-06, 2.07855E-06},
        {2.20302E-06, 2.08624E-06},
        {2.21106E-06, 2.09385E-06},
        {2.2191E-06, 2.10138E-06},
        {2.22722E-06, 2.10914E-06},
        {2.23528E-06, 2.11685E-06},
        {2.24332E-06, 2.12448E-06},
        {2.25148E-06, 2.13224E-06},
        {2.25951E-06, 2.13996E-06},
        {2.26762E-06, 2.14774E-06},
        {2.27567E-06, 2.15544E-06},
        {2.28385E-06, 2.16323E-06},
        {2.2919E-06, 2.1709E-06},
        {2.2996E-06, 2.17867E-06},
        {2.3063E-06, 2.18653E-06},
        {2.3147E-06, 2.19439E-06},
        {2.32318E-06, 2.20226E-06},
        {2.33137E-06, 2.21013E-06},
        {2.33961E-06, 2.21803E-06},
        {2.34781E-06, 0.000002226},
        {0.000002356, 2.23393E-06},
        {2.36419E-06, 2.24186E-06},
        {2.37235E-06, 2.24982E-06},
        {2.38061E-06, 2.25768E-06},
        {2.38885E-06, 2.26569E-06},
        {2.39702E-06, 2.2738E-06},
        {2.40522E-06, 2.28189E-06},
        {2.41336E-06, 2.28997E-06},
        {2.42165E-06, 2.29796E-06},
        {2.42988E-06, 2.30617E-06},
        {2.4382E-06, 2.31421E-06},
        {2.44649E-06, 2.32235E-06},
        {2.45467E-06, 2.33051E-06},
        {2.46294E-06, 2.33875E-06},
        {2.47129E-06, 2.34687E-06},
        {2.47954E-06, 2.35509E-06},
        {2.48772E-06, 2.36333E-06},
        {2.49601E-06, 2.37157E-06},
        {2.50435E-06, 2.37979E-06},
        {2.51264E-06, 2.38814E-06},
        {2.52112E-06, 2.39655E-06},
        {2.52942E-06, 2.40485E-06},
        {2.53776E-06, 2.41309E-06},
        {2.5462E-06, 2.4214E-06},
        {2.55447E-06, 2.42994E-06},
        {2.56284E-06, 2.43843E-06},
        {2.57121E-06, 2.44691E-06},
        {2.57962E-06, 2.45552E-06},
        {2.58791E-06, 2.46388E-06},
        {2.59649E-06, 2.47241E-06},
        {2.60488E-06, 2.48086E-06},
        {2.61336E-06, 2.48946E-06},
        {2.62175E-06, 0.000002498},
        {2.63038E-06, 2.50674E-06},
        {2.63881E-06, 2.51533E-06},
        {2.64723E-06, 2.52402E-06},
        {2.65577E-06, 2.53273E-06},
        {2.66434E-06, 2.54138E-06},
        {2.67281E-06, 2.55004E-06},
        {2.68138E-06, 2.55891E-06},
        {2.68988E-06, 2.56758E-06},
        {2.69854E-06, 2.57653E-06},
        {2.70695E-06, 2.58544E-06},
        {2.71567E-06, 2.59421E-06},
        {2.72439E-06, 2.60321E-06},
        {2.73294E-06, 2.61205E-06},
        {2.74166E-06, 2.62108E-06},
        {2.75026E-06, 2.63009E-06},
        {2.75887E-06, 2.63909E-06},
        {2.76749E-06, 2.64812E-06},
        {2.77612E-06, 2.65718E-06},
        {2.78489E-06, 2.66631E-06},
        {2.7936E-06, 2.67539E-06},
        {2.80223E-06, 2.68454E-06},
        {2.81101E-06, 2.69374E-06},
        {2.81973E-06, 2.70288E-06},
        {2.82858E-06, 2.71226E-06},
        {2.83732E-06, 2.72151E-06},
        {2.84605E-06, 2.73075E-06},
        {2.85488E-06, 2.74019E-06},
        {2.86364E-06, 2.7497E-06},
        {2.87253E-06, 2.75895E-06},
        {2.88137E-06, 2.76839E-06},
        {2.89035E-06, 2.77791E-06},
        {2.89913E-06, 2.78741E-06},
        {2.9081E-06, 2.7969E-06},
        {2.91694E-06, 2.80657E-06},
        {2.92594E-06, 2.81614E-06},
        {2.93491E-06, 2.82572E-06},
        {2.94385E-06, 2.83552E-06},
        {2.95272E-06, 2.8451E-06},
        {2.96179E-06, 2.85483E-06},
        {2.97072E-06, 2.8646E-06},
        {2.97973E-06, 2.87436E-06},
        {2.98884E-06, 2.88429E-06},
        {2.99786E-06, 2.89416E-06},
        {3.00702E-06, 2.90419E-06},
        {3.01601E-06, 2.91411E-06},
        {3.02523E-06, 2.92412E-06},
        {3.03426E-06, 2.93433E-06},
        {3.04342E-06, 2.94432E-06},
        {3.05271E-06, 2.95462E-06},
        {3.06181E-06, 2.9647E-06},
        {3.07087E-06, 2.97492E-06},
        {3.08003E-06, 2.98525E-06},
        {3.0893E-06, 2.99547E-06},
        {3.09851E-06, 3.00602E-06},
        {3.10777E-06, 3.01638E-06},
        {3.11693E-06, 3.02696E-06},
        {3.12629E-06, 3.03755E-06},
        {3.13566E-06, 3.04817E-06},
        {3.14495E-06, 3.05891E-06},
        {3.15429E-06, 3.06947E-06},
        {3.16365E-06, 3.08038E-06},
        {3.17305E-06, 3.09129E-06},
        {3.18241E-06, 3.10204E-06},
        {3.19186E-06, 3.11312E-06},
        {3.20122E-06, 3.12402E-06},
        {3.21059E-06, 3.13522E-06},
        {3.2202E-06, 3.1464E-06},
        {3.22957E-06, 3.15773E-06},
        {3.23914E-06, 3.16921E-06},
        {3.24858E-06, 3.18075E-06},
        {3.25823E-06, 3.19245E-06},
        {3.26773E-06, 3.20368E-06},
        {3.27725E-06, 3.2152E-06},
        {3.28709E-06, 3.22704E-06},
        {3.29652E-06, 3.2388E-06},
        {3.30605E-06, 3.25068E-06},
        {3.31574E-06, 3.26281E-06},
        {3.32538E-06, 3.27495E-06},
        {3.33515E-06, 3.28727E-06},
        {3.34479E-06, 3.29959E-06},
        {3.35463E-06, 3.31211E-06},
        {3.36437E-06, 3.32493E-06},
        {3.37415E-06, 3.33771E-06},
        {3.38388E-06, 3.35073E-06},
        {3.39363E-06, 3.36399E-06},
        {3.40345E-06, 3.37747E-06},
        {3.41328E-06, 3.3912E-06},
        {3.42308E-06, 3.40505E-06},
        {3.43317E-06, 3.41962E-06},
        {3.44285E-06, 3.43433E-06},
        {3.45279E-06, 3.45279E-06}
    };

    public static final double[] VGS_transferCharacteristics = {-10, -9.9, -9.8, -9.7, -9.6, -9.5, -9.4, -9.3, -9.2, -9.1, -9, -8.9, -8.8, -8.7, -8.6, -8.5, -8.4, -8.3, -8.2, -8.1, -8, -7.9, -7.8, -7.7, -7.6, -7.5, -7.4, -7.3, -7.2, -7.1, -7, -6.9, -6.8, -6.7, -6.6, -6.5, -6.4, -6.3, -6.2, -6.1, -6, -5.9, -5.8, -5.7, -5.6, -5.5, -5.4, -5.3, -5.2, -5.1, -5, -4.9, -4.8, -4.7, -4.6, -4.5, -4.4, -4.3, -4.2, -4.1, -4, -3.9, -3.8, -3.7, -3.6, -3.5, -3.4, -3.3, -3.2, -3.1, -3, -2.9, -2.8, -2.7, -2.6, -2.5, -2.4, -2.3, -2.2, -2.1, -2, -1.9, -1.8, -1.7, -1.6, -1.5, -1.4, -1.3, -1.2, -1.1, -1, -0.9, -0.8, -0.7, -0.6, -0.5, -0.4, -0.3, -0.2, -0.1, 0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1, 1.1, 1.2, 1.3, 1.4, 1.5, 1.6, 1.7, 1.8, 1.9, 2, 2.1, 2.2, 2.3, 2.4, 2.5, 2.6, 2.7, 2.8, 2.9, 3, 3.1, 3.2, 3.3, 3.4, 3.5, 3.6, 3.7, 3.8, 3.9, 4, 4.1, 4.2, 4.3, 4.4, 4.5, 4.6, 4.7, 4.8, 4.9, 5, 5.1, 5.2, 5.3, 5.4, 5.5, 5.6, 5.7, 5.8, 5.9, 6, 6.1, 6.2, 6.3, 6.4, 6.5, 6.6, 6.7, 6.8, 6.9, 7, 7.1, 7.2, 7.3, 7.4, 7.5, 7.6, 7.7, 7.8, 7.9, 8, 8.1, 8.2, 8.3, 8.4, 8.5, 8.6, 8.7, 8.8, 8.9, 9, 9.1, 9.2, 9.3, 9.4, 9.5, 9.6, 9.7, 9.8, 9.9, 10, 10.1, 10.2, 10.3, 10.4, 10.5, 10.6, 10.7, 10.8, 10.9, 11, 11.1, 11.2, 11.3, 11.4, 11.5, 11.6, 11.7, 11.8, 11.9, 12, 12.1, 12.2, 12.3, 12.4, 12.5, 12.6, 12.7, 12.8, 12.9, 13, 13.1, 13.2, 13.3, 13.4, 13.5, 13.6, 13.7, 13.8, 13.9, 14, 14.1, 14.2, 14.3, 14.4, 14.5, 14.6, 14.7, 14.8, 14.9, 15, 15.1, 15.2, 15.3, 15.4, 15.5, 15.6, 15.7, 15.8, 15.9, 16, 16.1, 16.2, 16.3, 16.4, 16.5, 16.6, 16.7, 16.8, 16.9, 17, 17.1, 17.2, 17.3, 17.4, 17.5, 17.6, 17.7, 17.8, 17.9, 18};
    public static final double VDS_transferCharacteristics = 30;
    public static final double[] IAA_transferCharacteristics = {1.0e-10, 1.0e-05};

    public static final double[] Ioff_IdVg = {7.7143E-07, 1.15488E-06};

    public static double tmeasure = 0.1; // 0.1V/100ms // Id-Vd, Id-Vg

    public static double trap_duration_time = 7;

    @Override
    public void setup(final EvolutionState state, final Parameter base) {
        super.setup(state, base);
    }

    @Override
    public void evaluate(final EvolutionState state, final Individual ind, final int subpopulation, final int thread) {

        // The individual is already evaluated
        if (ind.evaluated) {
            return;
        }

        if (!(ind instanceof OFET_FULL_P3HT_10mg_ml_5000rpm_L_5_OtftVectorIndividual)) {
            state.output.fatal("The individuals for this problem should be OFET_FULL_P3HT_10mg_ml_5000rpm_L_5_OtftVectorIndividual.");
        }

        OFET_FULL_P3HT_10mg_ml_5000rpm_L_5_OtftVectorIndividual temp = (OFET_FULL_P3HT_10mg_ml_5000rpm_L_5_OtftVectorIndividual) ind;
        double[] genome = temp.genome;
        int numDecisionVars = genome.length;
        double[] objectives = ((MultiObjectiveFitness) ind.fitness).getObjectives();
        double numObjectives = objectives.length;
        double mu0, gamma, vt, vss, ms, va_prima, tao, Ms;
        double[] beta_IdVg = new double[2];
        double[] Ms_IdVd = new double[IVexp_outputCharacteristics.length];

        int numsets, incurvas;
        double vt0_IdVg_ini, vt0_IdVg_fin, tao2;
        numsets = IVexp_transferCharacteristics[0].length;
        incurvas = IVexp_transferCharacteristics.length;
        double[][] Ms_IdVg = new double[incurvas][numsets];

        /* considering two traps */
        if (numDecisionVars == 12) {

            mu0 = genome[0];
            gamma = genome[1];
            vt = genome[2];
            vss = genome[3];
            ms = genome[4];
            Ms = genome[5];
            va_prima = genome[6];
            tao = genome[7];
            beta_IdVg[0] = genome[8];
            beta_IdVg[1] = genome[9];
            vt0_IdVg_ini = genome[10];
            tao2 = genome[11];

        } else {

            mu0 = 3.0e-05;
            gamma = 0.25;
            tao = 2.0;
            tao2 = 1.3;
            vt = genome[0];
            vss = genome[1];
            ms = genome[2];
            Ms = genome[3];
            va_prima = genome[4];
            beta_IdVg[0] = genome[5];
            beta_IdVg[1] = genome[6];
            vt0_IdVg_ini = genome[7];
        }

        vt0_IdVg_fin = vt;

        for (int i = 0; i < IVexp_outputCharacteristics.length; i++)
        {
            Ms_IdVd[i] = Ms;
        }

        for (int i = 0; i < incurvas; i++)
        {
            for (int j = 0; j < numsets; j++)
            {
                Ms_IdVg[i][j] = Ms;
            }
        }

        /* considering two traps */
        objectives[0] = Subthreshold.outputCharacteristics(IVexp_outputCharacteristics, IAA, VGS_outputCharacteristics, VDS_outputCharacteristics, vt, vss, ms, Ms_IdVd, gamma, mu0, Cox, W, L, va_prima);
        objectives[1] = ec.evolutionary_extraction_procedure.models.draincurrentmodel.Hysteresis.Subthreshold.IdVg(IVexp_transferCharacteristics, IAA_transferCharacteristics, VGS_transferCharacteristics, VDS_transferCharacteristics, vt0_IdVg_ini, vt0_IdVg_fin, vss, Ms_IdVg, ms, gamma,  mu0, Cox, W, L, va_prima, tao, beta_IdVg, Ioff_IdVg, 0.0, tmeasure, trap_duration_time, tao2);

        // objective values assignment
        ((MultiObjectiveFitness) ind.fitness).setObjectives(state, objectives);
        ind.evaluated = true;
    }
}
