package ec.app.ThinFilmTransistors.OTFT.P3HT_ZnO_Hybrid.P3HT_10mg_ml_5000rpm;

import ec.EvolutionState;
import ec.Individual;
import ec.Problem;
import ec.evolutionary_extraction_procedure.models.draincurrentmodel.MarinovJimenezTejada.Subthreshold;
import ec.multiobjective.MultiObjectiveFitness;
import ec.simple.SimpleProblemForm;
import ec.util.Parameter;
import ec.vector.ThinFilmTransistors.OTFT.P3HT_ZnO_Hybrid.P3HT_10mg_ml_5000rpm.OFET_L_10um_OtftVectorIndividual;

public class OFET_L_10um extends Problem implements SimpleProblemForm {

    private static final long serialVersionUID = 1L;

    public static double W = 1;  //(cm) width
    public static double L = 0.001; // (cm) length
    public static double Cox = 15e-09; // Ci = 15nFcm−2
    public static final double[][] IVexp_outputCharacteristics = {
            {0,00E+00, 0,00E+00, 0,00E+00, 0,00E+00, 0,00E+00, 0,00E+00, 0,00E+00},
            {3,30E-08, 3,88E-08, 4,47E-08, 5,12E-08, 5,85E-08, 6,67E-08, 7,55E-08},
            {6,45E-08, 7,84E-08, 9,12E-08, 1,05E-07, 1,21E-07, 1,38E-07, 1,56E-07},
            {9,46E-08, 1,16E-07, 1,36E-07, 1,56E-07, 1,79E-07, 2,04E-07, 2,31E-07},
            {1,24E-07, 1,52E-07, 1,78E-07, 2,05E-07, 2,35E-07, 2,68E-07, 3,03E-07},
            {1,51E-07, 1,87E-07, 2,18E-07, 2,51E-07, 2,88E-07, 3,28E-07, 3,72E-07},
            {1,78E-07, 2,20E-07, 2,57E-07, 2,97E-07, 3,40E-07, 3,87E-07, 4,38E-07},
            {2,03E-07, 2,52E-07, 2,95E-07, 3,40E-07, 3,89E-07, 4,43E-07, 5,01E-07},
            {2,28E-07, 2,83E-07, 3,31E-07, 3,82E-07, 4,37E-07, 4,97E-07, 5,62E-07},
            {2,51E-07, 3,13E-07, 3,67E-07, 4,23E-07, 4,84E-07, 5,50E-07, 6,21E-07},
            {2,74E-07, 3,42E-07, 4,01E-07, 4,63E-07, 5,29E-07, 6,01E-07, 6,79E-07},
            {2,97E-07, 3,70E-07, 4,35E-07, 5,02E-07, 5,73E-07, 6,51E-07, 7,35E-07},
            {3,18E-07, 3,97E-07, 4,67E-07, 5,39E-07, 6,16E-07, 7,00E-07, 7,89E-07},
            {3,39E-07, 4,23E-07, 4,99E-07, 5,76E-07, 6,58E-07, 7,47E-07, 8,43E-07},
            {3,59E-07, 4,48E-07, 5,29E-07, 6,12E-07, 6,99E-07, 7,93E-07, 8,95E-07},
            {3,79E-07, 4,73E-07, 5,59E-07, 6,47E-07, 7,40E-07, 8,39E-07, 9,46E-07},
            {3,98E-07, 4,97E-07, 5,88E-07, 6,81E-07, 7,79E-07, 8,83E-07, 9,95E-07},
            {4,17E-07, 5,20E-07, 6,16E-07, 7,15E-07, 8,17E-07, 9,27E-07, 1,04E-06},
            {4,35E-07, 5,43E-07, 6,44E-07, 7,47E-07, 8,55E-07, 9,70E-07, 1,09E-06},
            {4,52E-07, 5,65E-07, 6,71E-07, 7,79E-07, 8,92E-07, 1,01E-06, 1,14E-06},
            {4,69E-07, 5,86E-07, 6,97E-07, 8,10E-07, 9,28E-07, 1,05E-06, 1,19E-06},
            {4,85E-07, 6,07E-07, 7,22E-07, 8,40E-07, 9,64E-07, 1,09E-06, 1,23E-06},
            {5,01E-07, 6,27E-07, 7,47E-07, 8,70E-07, 9,98E-07, 1,13E-06, 1,28E-06},
            {5,15E-07, 6,46E-07, 7,71E-07, 8,99E-07, 1,03E-06, 1,17E-06, 1,32E-06},
            {5,29E-07, 6,65E-07, 7,95E-07, 9,27E-07, 1,07E-06, 1,21E-06, 1,36E-06},
            {5,42E-07, 6,84E-07, 8,17E-07, 9,55E-07, 1,10E-06, 1,25E-06, 1,41E-06},
            {5,55E-07, 7,01E-07, 8,40E-07, 9,82E-07, 1,13E-06, 1,28E-06, 1,45E-06},
            {5,67E-07, 7,18E-07, 8,61E-07, 1,01E-06, 1,16E-06, 1,32E-06, 1,49E-06},
            {5,78E-07, 7,33E-07, 8,82E-07, 1,03E-06, 1,19E-06, 1,36E-06, 1,53E-06},
            {5,89E-07, 7,49E-07, 9,02E-07, 1,06E-06, 1,22E-06, 1,39E-06, 1,57E-06},
            {5,99E-07, 7,63E-07, 9,22E-07, 1,08E-06, 1,25E-06, 1,42E-06, 1,61E-06},
            {6,08E-07, 7,76E-07, 9,40E-07, 1,11E-06, 1,28E-06, 1,46E-06, 1,64E-06},
            {6,17E-07, 7,89E-07, 9,58E-07, 1,13E-06, 1,31E-06, 1,49E-06, 1,68E-06},
            {6,26E-07, 8,01E-07, 9,75E-07, 1,15E-06, 1,33E-06, 1,52E-06, 1,72E-06},
            {6,35E-07, 8,12E-07, 9,91E-07, 1,17E-06, 1,36E-06, 1,55E-06, 1,75E-06},
            {6,43E-07, 8,23E-07, 1,01E-06, 1,19E-06, 1,38E-06, 1,58E-06, 1,79E-06},
            {6,50E-07, 8,33E-07, 1,02E-06, 1,21E-06, 1,41E-06, 1,61E-06, 1,82E-06},
            {6,58E-07, 8,43E-07, 1,04E-06, 1,23E-06, 1,43E-06, 1,64E-06, 1,86E-06},
            {6,65E-07, 8,53E-07, 1,05E-06, 1,25E-06, 1,46E-06, 1,67E-06, 1,89E-06},
            {6,72E-07, 8,62E-07, 1,06E-06, 1,27E-06, 1,48E-06, 1,70E-06, 1,92E-06},
            {6,79E-07, 8,70E-07, 1,07E-06, 1,28E-06, 1,50E-06, 1,72E-06, 1,95E-06}
    };

    /*
    public static final double[][] IVexp_transferCharacteristics_2_5um = {
            {9.69E-10, 4.62E-09},
            {9.57E-10, 4.49E-09},
            {9.43E-10, 4.37E-09},
            {9.29E-10, 4.26E-09},
            {9.18E-10, 4.15E-09},
            {9.16E-10, 4.06E-09},
            {9.22E-10, 3.97E-09},
            {9.41E-10, 3.90E-09},
            {9.75E-10, 3.83E-09},
            {1.06E-09, 3.80E-09},
            {1.27E-09, 3.77E-09},
            {1.64E-09, 3.77E-09},
            {2.24E-09, 3.82E-09},
            {3.07E-09, 3.94E-09},
            {4.13E-09, 4.21E-09},
            {5.38E-09, 4.80E-09},
            {6.78E-09, 5.99E-09},
            {8.24E-09, 7.65E-09},
            {9.68E-09, 9.71E-09},
            {1.12E-08, 1.22E-08},
            {1.27E-08, 1.52E-08},
            {1.42E-08, 1.87E-08},
            {1.57E-08, 2.26E-08},
            {1.71E-08, 2.71E-08},
            {1.84E-08, 3.21E-08},
            {1.97E-08, 3.78E-08},
            {2.09E-08, 4.20E-08},
            {2.21E-08, 4.80E-08},
            {2.32E-08, 5.43E-08},
            {2.42E-08, 6.10E-08},
            {2.51E-08, 6.79E-08},
            {2.60E-08, 7.52E-08},
            {2.68E-08, 8.27E-08},
            {2.75E-08, 9.04E-08},
            {2.82E-08, 9.82E-08},
            {2.88E-08, 1.06E-07},
            {2.93E-08, 1.14E-07},
            {2.97E-08, 1.22E-07},
            {3.01E-08, 1.30E-07},
            {3.04E-08, 1.38E-07},
            {3.07E-08, 1.46E-07},
            {3.09E-08, 1.54E-07},
            {3.10E-08, 1.62E-07},
            {3.11E-08, 1.69E-07},
            {3.12E-08, 1.77E-07},
            {3.12E-08, 1.83E-07},
            {3.12E-08, 1.90E-07},
            {3.11E-08, 1.96E-07},
            {3.10E-08, 2.02E-07},
            {3.08E-08, 2.08E-07},
            {3.07E-08, 2.13E-07},
            {3.04E-08, 2.18E-07},
            {3.02E-08, 2.22E-07},
            {3.00E-08, 2.26E-07},
            {2.97E-08, 2.30E-07},
            {2.94E-08, 2.33E-07},
            {2.90E-08, 2.36E-07},
            {2.87E-08, 2.39E-07},
            {2.83E-08, 2.41E-07},
            {2.79E-08, 2.43E-07},
            {2.75E-08, 2.44E-07},
            {2.71E-08, 2.45E-07},
            {2.66E-08, 2.46E-07},
            {2.61E-08, 2.47E-07},
            {2.56E-08, 2.47E-07},
            {2.51E-08, 2.47E-07},
            {2.46E-08, 2.47E-07},
            {2.43E-08, 2.47E-07},
            {2.32E-08, 2.47E-07},
            {2.31E-08, 2.47E-07},
            {2.30E-08, 2.47E-07}
    };

    public static final double[] VGS_transferCharacteristics = {-30, -29, -28, -27, -26, -25, -24, -23, -22, -21, -20, -19, -18, -17, -16, -15, -14, -13, -12, -11, -10, -9, -8, -7, -6, -5, -4, -3, -2, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40};
    public static final double[] VDS_transferCharacteristics = {5, 40};
    
*/
    public static final double[] VDS_outputCharacteristics = {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40};
    public static final double[] VGS_outputCharacteristics = {0, 4, 8, 12, 16, 20, 24};
    public static final double[] IAA = {1.0e-06, 1.0e-06, 1.0e-06, 1.0e-06, 1.0e-06, 1.0e-06, 1.0e-06};

    @Override
    public void setup(final EvolutionState state, final Parameter base) {
        super.setup(state, base);
    }

    @Override
    public void evaluate(final EvolutionState state, final Individual ind, final int subpopulation, final int thread) {

        // The individual is already evaluated
        if (ind.evaluated) {
            return;
        }

        if (!(ind instanceof OFET_L_10um_OtftVectorIndividual)) {
            state.output.fatal("The individuals for this problem should be OFET_L_10um_OtftVectorIndividual.");
        }

        OFET_L_10um_OtftVectorIndividual temp = (OFET_L_10um_OtftVectorIndividual) ind;
        double[] genome = temp.genome;
        int numDecisionVars = genome.length;
        double[] objectives = ((MultiObjectiveFitness) ind.fitness).getObjectives();
        double numObjectives = objectives.length;

        double k, gamma, Vt, Vss, mk, alpha;
        double[] MC = new double[VGS_outputCharacteristics.length];


        k = genome[0];
        gamma = genome[1];
        Vt = genome[2];
        Vss = genome[3];
        mk = genome[4];
        alpha = genome[5];

/*
        k = 8.114767528826653E-13;
        gamma = 0.22408350767185742;
        Vt =-34.7485295503103;
        Vss = 0.5082948068335149;
        mk = 1.0;
        alpha = 6.253329440967365E-10;
*/

        if (numDecisionVars > 6) {

            for (int i = 0; i < VGS_outputCharacteristics.length; i++) {
                MC[i] = genome[5 + i];
            }

            objectives[0] = Subthreshold.outputCharacteristics(IVexp_outputCharacteristics, VGS_outputCharacteristics, VDS_outputCharacteristics, IAA, W, L, k, gamma, MC, Vt, Vss, mk, 2);
            objectives[1] = Subthreshold.contactEffects(IVexp_outputCharacteristics, VGS_outputCharacteristics, VDS_outputCharacteristics, W, L, k, gamma, MC, Vt, Vss, mk, 2);

        }
        else {

            objectives[0] = Subthreshold.outputCharacteristics(IVexp_outputCharacteristics, VGS_outputCharacteristics, VDS_outputCharacteristics, IAA, W, L, k, gamma, alpha, Vt, Vss, mk, 2);
            objectives[1] = Subthreshold.contactEffects(IVexp_outputCharacteristics, VGS_outputCharacteristics, VDS_outputCharacteristics, W, L, k, gamma, alpha, Vt, Vss, mk, 2);
        }

        //objectives[2] = Subthreshold.outputCharacteristics(IVexp_outputCharacteristics_2_5um, VGS_outputCharacteristics, VDS_outputCharacteristics, IAA, W, L_L800,  k, gamma, MC, Vt, Vss, mk, 2);
        
        /*
        if(numObjectives>3) {
            objectives[3] = JimenezTejada.resistancesTrend(MC, gamma, VGS_outputCharacteristics);
            if (objectives[3] < 1.0e-02) {
                objectives[3] = 0.0;
            }
            // Difference between VT' y VT
            objectives[4] = JimenezTejada.VGaxisCross(MC, gamma, VGS_outputCharacteristics, Vt);
            if (objectives[4] < 1.0e-02) {
                objectives[4] = 0.0;
            }
        }
        */
        // objective values assignment
        ((MultiObjectiveFitness) ind.fitness).setObjectives(state, objectives);
        ind.evaluated = true;
    }
}
