package ec.app.ThinFilmTransistors.OTFT.P3HT_ZnO_Hybrid.P3HT_10mg_ml_5000rpm;

import ec.EvolutionState;
import ec.Individual;
import ec.Problem;
import ec.evolutionary_extraction_procedure.models.draincurrentmodel.MarinovJimenezTejada.Subthreshold;
import ec.multiobjective.MultiObjectiveFitness;
import ec.simple.SimpleProblemForm;
import ec.util.Parameter;
import ec.vector.ThinFilmTransistors.OTFT.P3HT_ZnO_Hybrid.P3HT_10mg_ml_5000rpm.OFET_L_20um_OtftVectorIndividual;

public class OFET_L_20um extends Problem implements SimpleProblemForm {

    private static final long serialVersionUID = 1L;

    public static double W = 1;  //(cm) width
    public static double L = 0.002; // (cm) length
    public static double Cox = 15e-09; // Ci = 15nFcm−2

    public static final double[][] IVexp_outputCharacteristics = {
            {0.00E+00, 0.00E+00, 0.00E+00, 0.00E+00, 0.00E+00, 0.00E+00, 0.00E+00},
            {1.82E-08, 2.09E-08, 2.38E-08, 2.71E-08, 3.07E-08, 3.45E-08, 3.84E-08},
            {3.56E-08, 4.27E-08, 4.90E-08, 5.58E-08, 6.32E-08, 7.08E-08, 7.86E-08},
            {5.22E-08, 6.34E-08, 7.29E-08, 8.28E-08, 9.37E-08, 1.05E-07, 1.16E-07},
            {6.81E-08, 8.31E-08, 9.56E-08, 1.09E-07, 1.23E-07, 1.37E-07, 1.52E-07},
            {8.32E-08, 1.02E-07, 1.18E-07, 1.34E-07, 1.51E-07, 1.68E-07, 1.86E-07},
            {9.77E-08, 1.20E-07, 1.39E-07, 1.57E-07, 1.78E-07, 1.98E-07, 2.19E-07},
            {1.12E-07, 1.38E-07, 1.59E-07, 1.81E-07, 2.03E-07, 2.27E-07, 2.51E-07},
            {1.25E-07, 1.54E-07, 1.79E-07, 2.03E-07, 2.28E-07, 2.55E-07, 2.81E-07},
            {1.37E-07, 1.71E-07, 1.97E-07, 2.24E-07, 2.53E-07, 2.81E-07, 3.11E-07},
            {1.49E-07, 1.86E-07, 2.16E-07, 2.45E-07, 2.76E-07, 3.07E-07, 3.39E-07},
            {1.61E-07, 2.01E-07, 2.33E-07, 2.65E-07, 2.99E-07, 3.33E-07, 3.67E-07},
            {1.71E-07, 2.15E-07, 2.50E-07, 2.85E-07, 3.21E-07, 3.57E-07, 3.94E-07},
            {1.82E-07, 2.28E-07, 2.66E-07, 3.04E-07, 3.42E-07, 3.81E-07, 4.20E-07},
            {1.92E-07, 2.41E-07, 2.82E-07, 3.22E-07, 3.63E-07, 4.04E-07, 4.45E-07},
            {2.01E-07, 2.53E-07, 2.97E-07, 3.40E-07, 3.83E-07, 4.26E-07, 4.70E-07},
            {2.10E-07, 2.65E-07, 3.12E-07, 3.57E-07, 4.02E-07, 4.48E-07, 4.94E-07},
            {2.18E-07, 2.76E-07, 3.26E-07, 3.74E-07, 4.21E-07, 4.69E-07, 5.17E-07},
            {2.26E-07, 2.87E-07, 3.39E-07, 3.90E-07, 4.40E-07, 4.90E-07, 5.40E-07},
            {2.34E-07, 2.97E-07, 3.52E-07, 4.05E-07, 4.58E-07, 5.10E-07, 5.62E-07},
            {2.41E-07, 3.06E-07, 3.64E-07, 4.20E-07, 4.75E-07, 5.29E-07, 5.83E-07},
            {2.47E-07, 3.16E-07, 3.76E-07, 4.34E-07, 4.92E-07, 5.48E-07, 6.04E-07},
            {2.53E-07, 3.24E-07, 3.87E-07, 4.48E-07, 5.08E-07, 5.67E-07, 6.25E-07},
            {2.59E-07, 3.33E-07, 3.98E-07, 4.61E-07, 5.24E-07, 5.85E-07, 6.45E-07},
            {2.64E-07, 3.41E-07, 4.08E-07, 4.74E-07, 5.39E-07, 6.02E-07, 6.65E-07},
            {2.69E-07, 3.48E-07, 4.18E-07, 4.86E-07, 5.54E-07, 6.19E-07, 6.84E-07},
            {2.73E-07, 3.55E-07, 4.27E-07, 4.98E-07, 5.68E-07, 6.35E-07, 7.02E-07},
            {2.77E-07, 3.61E-07, 4.36E-07, 5.09E-07, 5.82E-07, 6.51E-07, 7.20E-07},
            {2.81E-07, 3.67E-07, 4.44E-07, 5.20E-07, 5.94E-07, 6.67E-07, 7.37E-07},
            {2.85E-07, 3.72E-07, 4.52E-07, 5.30E-07, 6.07E-07, 6.81E-07, 7.54E-07},
            {2.88E-07, 3.77E-07, 4.60E-07, 5.40E-07, 6.19E-07, 6.96E-07, 7.71E-07},
            {2.91E-07, 3.81E-07, 4.67E-07, 5.50E-07, 6.31E-07, 7.10E-07, 7.87E-07},
            {2.94E-07, 3.85E-07, 4.73E-07, 5.58E-07, 6.42E-07, 7.23E-07, 8.02E-07},
            {2.96E-07, 3.89E-07, 4.79E-07, 5.67E-07, 6.53E-07, 7.36E-07, 8.17E-07},
            {2.99E-07, 3.92E-07, 4.85E-07, 5.75E-07, 6.63E-07, 7.48E-07, 8.31E-07},
            {3.01E-07, 3.96E-07, 4.90E-07, 5.83E-07, 6.73E-07, 7.60E-07, 8.45E-07},
            {3.04E-07, 3.98E-07, 4.94E-07, 5.90E-07, 6.82E-07, 7.72E-07, 8.59E-07},
            {3.06E-07, 4.01E-07, 4.99E-07, 5.96E-07, 6.91E-07, 7.83E-07, 8.72E-07},
            {3.08E-07, 4.04E-07, 5.03E-07, 6.02E-07, 6.99E-07, 7.93E-07, 8.84E-07},
            {3.10E-07, 4.06E-07, 5.06E-07, 6.08E-07, 7.07E-07, 8.03E-07, 8.97E-07},
            {3.12E-07, 4.09E-07, 5.10E-07, 6.13E-07, 7.15E-07, 8.13E-07, 9.08E-07}
    };

    /*
    public static final double[][] IVexp_transferCharacteristics_2_5um = {
            {9.69E-10, 4.62E-09},
            {9.57E-10, 4.49E-09},
            {9.43E-10, 4.37E-09},
            {9.29E-10, 4.26E-09},
            {9.18E-10, 4.15E-09},
            {9.16E-10, 4.06E-09},
            {9.22E-10, 3.97E-09},
            {9.41E-10, 3.90E-09},
            {9.75E-10, 3.83E-09},
            {1.06E-09, 3.80E-09},
            {1.27E-09, 3.77E-09},
            {1.64E-09, 3.77E-09},
            {2.24E-09, 3.82E-09},
            {3.07E-09, 3.94E-09},
            {4.13E-09, 4.21E-09},
            {5.38E-09, 4.80E-09},
            {6.78E-09, 5.99E-09},
            {8.24E-09, 7.65E-09},
            {9.68E-09, 9.71E-09},
            {1.12E-08, 1.22E-08},
            {1.27E-08, 1.52E-08},
            {1.42E-08, 1.87E-08},
            {1.57E-08, 2.26E-08},
            {1.71E-08, 2.71E-08},
            {1.84E-08, 3.21E-08},
            {1.97E-08, 3.78E-08},
            {2.09E-08, 4.20E-08},
            {2.21E-08, 4.80E-08},
            {2.32E-08, 5.43E-08},
            {2.42E-08, 6.10E-08},
            {2.51E-08, 6.79E-08},
            {2.60E-08, 7.52E-08},
            {2.68E-08, 8.27E-08},
            {2.75E-08, 9.04E-08},
            {2.82E-08, 9.82E-08},
            {2.88E-08, 1.06E-07},
            {2.93E-08, 1.14E-07},
            {2.97E-08, 1.22E-07},
            {3.01E-08, 1.30E-07},
            {3.04E-08, 1.38E-07},
            {3.07E-08, 1.46E-07},
            {3.09E-08, 1.54E-07},
            {3.10E-08, 1.62E-07},
            {3.11E-08, 1.69E-07},
            {3.12E-08, 1.77E-07},
            {3.12E-08, 1.83E-07},
            {3.12E-08, 1.90E-07},
            {3.11E-08, 1.96E-07},
            {3.10E-08, 2.02E-07},
            {3.08E-08, 2.08E-07},
            {3.07E-08, 2.13E-07},
            {3.04E-08, 2.18E-07},
            {3.02E-08, 2.22E-07},
            {3.00E-08, 2.26E-07},
            {2.97E-08, 2.30E-07},
            {2.94E-08, 2.33E-07},
            {2.90E-08, 2.36E-07},
            {2.87E-08, 2.39E-07},
            {2.83E-08, 2.41E-07},
            {2.79E-08, 2.43E-07},
            {2.75E-08, 2.44E-07},
            {2.71E-08, 2.45E-07},
            {2.66E-08, 2.46E-07},
            {2.61E-08, 2.47E-07},
            {2.56E-08, 2.47E-07},
            {2.51E-08, 2.47E-07},
            {2.46E-08, 2.47E-07},
            {2.43E-08, 2.47E-07},
            {2.32E-08, 2.47E-07},
            {2.31E-08, 2.47E-07},
            {2.30E-08, 2.47E-07}
    };

    public static final double[] VGS_transferCharacteristics = {-30, -29, -28, -27, -26, -25, -24, -23, -22, -21, -20, -19, -18, -17, -16, -15, -14, -13, -12, -11, -10, -9, -8, -7, -6, -5, -4, -3, -2, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40};
    public static final double[] VDS_transferCharacteristics = {5, 40};
    
*/
    public static final double[] VDS_outputCharacteristics = {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40};
    public static final double[] VGS_outputCharacteristics = {0, 4, 8, 12, 16, 20, 24};
    public static final double[] IAA = {1.0e-06, 1.0e-06, 1.0e-06, 1.0e-06, 1.0e-06, 1.0e-06, 1.0e-06};

    @Override
    public void setup(final EvolutionState state, final Parameter base) {
        super.setup(state, base);
    }

    @Override
    public void evaluate(final EvolutionState state, final Individual ind, final int subpopulation, final int thread) {

        // The individual is already evaluated
        if (ind.evaluated) {
            return;
        }

        if (!(ind instanceof OFET_L_20um_OtftVectorIndividual)) {
            state.output.fatal("The individuals for this problem should be OFET_L_20um_OtftVectorIndividual.");
        }

        OFET_L_20um_OtftVectorIndividual temp = (OFET_L_20um_OtftVectorIndividual) ind;
        double[] genome = temp.genome;
        int numDecisionVars = genome.length;
        double[] objectives = ((MultiObjectiveFitness) ind.fitness).getObjectives();
        double numObjectives = objectives.length;

        double k, gamma, Vt, Vss, mk, alpha;
        double[] MC = new double[VGS_outputCharacteristics.length];


        k = genome[0];
        gamma = genome[1];
        Vt = genome[2];
        Vss = genome[3];
        mk = genome[4];
        alpha = genome[5];

        if (numDecisionVars > 6) {

            for (int i = 0; i < VGS_outputCharacteristics.length; i++) {
                MC[i] = genome[5 + i];
            }

            objectives[0] = Subthreshold.outputCharacteristics(IVexp_outputCharacteristics, VGS_outputCharacteristics, VDS_outputCharacteristics, IAA, W, L, k, gamma, MC, Vt, Vss, mk, 2);
            objectives[1] = Subthreshold.contactEffects(IVexp_outputCharacteristics, VGS_outputCharacteristics, VDS_outputCharacteristics, W, L, k, gamma, MC, Vt, Vss, mk, 2);

        }
        else {

            objectives[0] = Subthreshold.outputCharacteristics(IVexp_outputCharacteristics, VGS_outputCharacteristics, VDS_outputCharacteristics, IAA, W, L, k, gamma, alpha, Vt, Vss, mk, 2);
            objectives[1] = Subthreshold.contactEffects(IVexp_outputCharacteristics, VGS_outputCharacteristics, VDS_outputCharacteristics, W, L, k, gamma, alpha, Vt, Vss, mk, 2);
        }

        //objectives[2] = Subthreshold.outputCharacteristics(IVexp_outputCharacteristics_2_5um, VGS_outputCharacteristics, VDS_outputCharacteristics, IAA, W, L_L800,  k, gamma, MC, Vt, Vss, mk, 2);
        
        /*
        if(numObjectives>3) {
            objectives[3] = JimenezTejada.resistancesTrend(MC, gamma, VGS_outputCharacteristics);
            if (objectives[3] < 1.0e-02) {
                objectives[3] = 0.0;
            }
            // Difference between VT' y VT
            objectives[4] = JimenezTejada.VGaxisCross(MC, gamma, VGS_outputCharacteristics, Vt);
            if (objectives[4] < 1.0e-02) {
                objectives[4] = 0.0;
            }
        }
        */
        // objective values assignment
        ((MultiObjectiveFitness) ind.fitness).setObjectives(state, objectives);
        ind.evaluated = true;
    }
}
