package ec.app.ThinFilmTransistors.OTFT.P3HT_ZnO_Hybrid.P3HT_10mg_ml_5000rpm;

import ec.EvolutionState;
import ec.Individual;
import ec.Problem;
import ec.simple.SimpleFitness;
import ec.simple.SimpleProblemForm;
import ec.util.Parameter;
import ec.evolutionary_extraction_procedure.models.draincurrentmodel.MarinovJimenezTejada.Subthreshold;

import ec.vector.ThinFilmTransistors.OTFT.P3HT_ZnO_Hybrid.P3HT_10mg_ml_5000rpm.OFET_L_5um_NoContacts_OtftVectorIndividual;

public class OFET_L_5um_NoContacts extends Problem implements SimpleProblemForm {

    private static final long serialVersionUID = 1L;

    public static double W = 1;  //(cm) width
    public static double L = 0.0005; // (cm) length
    public static double Cox = 15e-09; // Ci = 15nFcm−2
    public static final double[][] IVexp_outputCharacteristics = {
            {0.00E+00, 0.00E+00, 0.00E+00, 0.00E+00, 0.00E+00, 0.00E+00, 0.00E+00},
            {6.28E-08, 7.58E-08, 8.71E-08, 9.93E-08, 1.13E-07, 1.28E-07, 1.44E-07},
            {1.24E-07, 1.51E-07, 1.74E-07, 1.99E-07, 2.25E-07, 2.55E-07, 2.88E-07},
            {1.82E-07, 2.23E-07, 2.58E-07, 2.94E-07, 3.34E-07, 3.78E-07, 4.25E-07},
            {2.40E-07, 2.94E-07, 3.39E-07, 3.87E-07, 4.39E-07, 4.96E-07, 5.58E-07},
            {2.96E-07, 3.64E-07, 4.20E-07, 4.78E-07, 5.42E-07, 6.12E-07, 6.88E-07},
            {3.52E-07, 4.33E-07, 4.99E-07, 5.68E-07, 6.43E-07, 7.26E-07, 8.16E-07},
            {4.08E-07, 5.01E-07, 5.77E-07, 6.57E-07, 7.44E-07, 8.39E-07, 9.42E-07},
            {4.64E-07, 5.68E-07, 6.56E-07, 7.46E-07, 8.43E-07, 9.50E-07, 1.07E-06},
            {5.19E-07, 6.36E-07, 7.34E-07, 8.34E-07, 9.42E-07, 1.06E-06, 1.19E-06},
            {5.74E-07, 7.03E-07, 8.11E-07, 9.22E-07, 1.04E-06, 1.17E-06, 1.31E-06},
            {6.29E-07, 7.70E-07, 8.89E-07, 1.01E-06, 1.14E-06, 1.28E-06, 1.43E-06},
            {6.85E-07, 8.36E-07, 9.66E-07, 1.10E-06, 1.24E-06, 1.39E-06, 1.56E-06},
            {7.40E-07, 9.03E-07, 1.04E-06, 1.19E-06, 1.34E-06, 1.50E-06, 1.68E-06},
            {7.95E-07, 9.69E-07, 1.12E-06, 1.27E-06, 1.44E-06, 1.61E-06, 1.80E-06},
            {8.50E-07, 1.04E-06, 1.20E-06, 1.36E-06, 1.53E-06, 1.72E-06, 1.92E-06},
            {9.04E-07, 1.10E-06, 1.27E-06, 1.45E-06, 1.63E-06, 1.83E-06, 2.04E-06},
            {9.58E-07, 1.17E-06, 1.35E-06, 1.54E-06, 1.73E-06, 1.94E-06, 2.16E-06},
            {1.01E-06, 1.23E-06, 1.43E-06, 1.62E-06, 1.83E-06, 2.05E-06, 2.29E-06},
            {1.07E-06, 1.30E-06, 1.50E-06, 1.71E-06, 1.93E-06, 2.16E-06, 2.41E-06},
            {1.12E-06, 1.36E-06, 1.58E-06, 1.80E-06, 2.03E-06, 2.27E-06, 2.53E-06},
            {1.17E-06, 1.43E-06, 1.65E-06, 1.88E-06, 2.13E-06, 2.38E-06, 2.65E-06},
            {1.22E-06, 1.49E-06, 1.73E-06, 1.97E-06, 2.22E-06, 2.49E-06, 2.77E-06},
            {1.27E-06, 1.55E-06, 1.80E-06, 2.06E-06, 2.32E-06, 2.60E-06, 2.89E-06},
            {1.32E-06, 1.61E-06, 1.88E-06, 2.14E-06, 2.42E-06, 2.71E-06, 3.02E-06},
            {1.37E-06, 1.67E-06, 1.95E-06, 2.23E-06, 2.51E-06, 2.82E-06, 3.14E-06},
            {1.41E-06, 1.73E-06, 2.02E-06, 2.31E-06, 2.61E-06, 2.93E-06, 3.26E-06},
            {1.46E-06, 1.79E-06, 2.09E-06, 2.39E-06, 2.70E-06, 3.03E-06, 3.38E-06},
            {1.50E-06, 1.85E-06, 2.16E-06, 2.47E-06, 2.80E-06, 3.14E-06, 3.50E-06},
            {1.55E-06, 1.91E-06, 2.23E-06, 2.56E-06, 2.89E-06, 3.25E-06, 3.62E-06},
            {1.59E-06, 1.96E-06, 2.30E-06, 2.64E-06, 2.99E-06, 3.35E-06, 3.73E-06},
            {1.63E-06, 2.01E-06, 2.37E-06, 2.72E-06, 3.08E-06, 3.46E-06, 3.85E-06},
            {1.67E-06, 2.07E-06, 2.43E-06, 2.79E-06, 3.17E-06, 3.56E-06, 3.97E-06},
            {1.71E-06, 2.12E-06, 2.49E-06, 2.87E-06, 3.26E-06, 3.66E-06, 4.08E-06},
            {1.75E-06, 2.17E-06, 2.56E-06, 2.95E-06, 3.35E-06, 3.76E-06, 4.20E-06},
            {1.79E-06, 2.21E-06, 2.62E-06, 3.02E-06, 3.43E-06, 3.86E-06, 4.31E-06},
            {1.83E-06, 2.26E-06, 2.68E-06, 3.10E-06, 3.52E-06, 3.96E-06, 4.43E-06},
            {1.87E-06, 2.31E-06, 2.74E-06, 3.17E-06, 3.61E-06, 4.06E-06, 4.54E-06},
            {1.91E-06, 2.35E-06, 2.80E-06, 3.24E-06, 3.69E-06, 4.16E-06, 4.65E-06},
            {1.94E-06, 2.40E-06, 2.85E-06, 3.31E-06, 3.77E-06, 4.26E-06, 4.76E-06},
            {1.98E-06, 2.44E-06, 2.91E-06, 3.38E-06, 3.86E-06, 4.35E-06, 4.87E-06}
    };

    /*
    public static final double[][] IVexp_transferCharacteristics_2_5um = {
            {9.69E-10, 4.62E-09},
            {9.57E-10, 4.49E-09},
            {9.43E-10, 4.37E-09},
            {9.29E-10, 4.26E-09},
            {9.18E-10, 4.15E-09},
            {9.16E-10, 4.06E-09},
            {9.22E-10, 3.97E-09},
            {9.41E-10, 3.90E-09},
            {9.75E-10, 3.83E-09},
            {1.06E-09, 3.80E-09},
            {1.27E-09, 3.77E-09},
            {1.64E-09, 3.77E-09},
            {2.24E-09, 3.82E-09},
            {3.07E-09, 3.94E-09},
            {4.13E-09, 4.21E-09},
            {5.38E-09, 4.80E-09},
            {6.78E-09, 5.99E-09},
            {8.24E-09, 7.65E-09},
            {9.68E-09, 9.71E-09},
            {1.12E-08, 1.22E-08},
            {1.27E-08, 1.52E-08},
            {1.42E-08, 1.87E-08},
            {1.57E-08, 2.26E-08},
            {1.71E-08, 2.71E-08},
            {1.84E-08, 3.21E-08},
            {1.97E-08, 3.78E-08},
            {2.09E-08, 4.20E-08},
            {2.21E-08, 4.80E-08},
            {2.32E-08, 5.43E-08},
            {2.42E-08, 6.10E-08},
            {2.51E-08, 6.79E-08},
            {2.60E-08, 7.52E-08},
            {2.68E-08, 8.27E-08},
            {2.75E-08, 9.04E-08},
            {2.82E-08, 9.82E-08},
            {2.88E-08, 1.06E-07},
            {2.93E-08, 1.14E-07},
            {2.97E-08, 1.22E-07},
            {3.01E-08, 1.30E-07},
            {3.04E-08, 1.38E-07},
            {3.07E-08, 1.46E-07},
            {3.09E-08, 1.54E-07},
            {3.10E-08, 1.62E-07},
            {3.11E-08, 1.69E-07},
            {3.12E-08, 1.77E-07},
            {3.12E-08, 1.83E-07},
            {3.12E-08, 1.90E-07},
            {3.11E-08, 1.96E-07},
            {3.10E-08, 2.02E-07},
            {3.08E-08, 2.08E-07},
            {3.07E-08, 2.13E-07},
            {3.04E-08, 2.18E-07},
            {3.02E-08, 2.22E-07},
            {3.00E-08, 2.26E-07},
            {2.97E-08, 2.30E-07},
            {2.94E-08, 2.33E-07},
            {2.90E-08, 2.36E-07},
            {2.87E-08, 2.39E-07},
            {2.83E-08, 2.41E-07},
            {2.79E-08, 2.43E-07},
            {2.75E-08, 2.44E-07},
            {2.71E-08, 2.45E-07},
            {2.66E-08, 2.46E-07},
            {2.61E-08, 2.47E-07},
            {2.56E-08, 2.47E-07},
            {2.51E-08, 2.47E-07},
            {2.46E-08, 2.47E-07},
            {2.43E-08, 2.47E-07},
            {2.32E-08, 2.47E-07},
            {2.31E-08, 2.47E-07},
            {2.30E-08, 2.47E-07}
    };

    public static final double[] VGS_transferCharacteristics = {-30, -29, -28, -27, -26, -25, -24, -23, -22, -21, -20, -19, -18, -17, -16, -15, -14, -13, -12, -11, -10, -9, -8, -7, -6, -5, -4, -3, -2, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40};
    public static final double[] VDS_transferCharacteristics = {5, 40};
    
*/
    public static final double[] VDS_outputCharacteristics = {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40};
    public static final double[] VGS_outputCharacteristics = {0, 4, 8, 12, 16, 20, 24};
    public static final double[] IAA = {1.0e-06, 1.0e-06, 1.0e-06, 1.0e-06, 1.0e-06, 1.0e-06, 1.0e-06};

    @Override
    public void setup(final EvolutionState state, final Parameter base) {
        super.setup(state, base);
    }

    @Override
    public void evaluate(final EvolutionState state, final Individual ind, final int subpopulation, final int thread) {

        // The individual is already evaluated
        if (ind.evaluated) {
            return;
        }

        if (!(ind instanceof OFET_L_5um_NoContacts_OtftVectorIndividual)) {
            state.output.fatal("The individuals for this problem should be OFET_L_5um_NoContacts_OtftVectorIndividual.");
        }

        OFET_L_5um_NoContacts_OtftVectorIndividual temp = (OFET_L_5um_NoContacts_OtftVectorIndividual) ind;
        double[] genome = temp.genome;
        int numDecisionVars = genome.length;
        double fitness;

        double mu0, gamma, vt, vss, ms, alpha, va_prima;

        mu0 = genome[0];
        gamma = genome[1];
        vt = genome[2];
        vss = genome[3];
        ms = genome[4];
        va_prima = genome[5];

        alpha = Double.POSITIVE_INFINITY;


        fitness = (-1) * Subthreshold.outputCharacteristics(IVexp_outputCharacteristics, IAA, VGS_outputCharacteristics, VDS_outputCharacteristics, vt, vss, alpha, ms, gamma, mu0, Cox, W, L, va_prima);


        ((SimpleFitness) ind.fitness).setFitness(state, fitness, fitness == Double.POSITIVE_INFINITY);
        ind.evaluated = true;
    }
}
