package ec.evolutionary_extraction_procedure.models.draincurrentmodel.MarinovJimenezTejada;

import ec.evolutionary_extraction_procedure.exception.*;
import static ec.evolutionary_extraction_procedure.constraints.ContactVoltage.*;
import ec.evolutionary_extraction_procedure.fitness.Fitness;

/**
 * @author Adrián Romero <adrianromerocaceres @ gmail.com>
 * @version 1.0 (current version number of program)
 * @since 26 (the version of the package this class was first added to)
 */
public class Subthreshold {

    public static double contactConductance(double alfa, double VSS, double VG, double VT, double gamma) {
        double MC;

        MC = alfa * Math.pow(VSS * Math.log(1 + Math.exp((VG - VT) / VSS)), 1 + gamma);

        return MC;
    }
    public static double genericContactConductance(double alfa, double VG, double VT, double gamma) {
        double MC;

        MC = alfa * Math.pow(VG - VT , 1 + gamma);

        return MC;
    }

    public static double fIV(double ID, double MM, double VGS, double VT, double VDS, double gamma, double k, double W, double L, int ilinear, double mk, double VSS) throws fIVnoSolution {

        // Variables
        double VS, y;
        double Veosr, Veodr;

        // check the trend
        switch (ilinear) {

            case 0:
                VS = Math.pow(ID / MM, 1 / 2);
                break;
            case 1:
                VS = ID * MM;
                break;
            case 2:
                VS = Math.pow(ID / MM, 1 / mk);
                break;
            default:
                throw new fIVnoSolution("fIV: NaN value for individual");
        }

        Veosr = VSS * Math.log(1 + Math.exp(((VGS - VT - VS)) / VSS));
        Veodr = VSS * Math.log(1 + Math.exp(((VGS - VT - VDS)) / VSS));

        // Compute ID
        //if ((VGS-VT) >= VDS) {
        y = ((k) * (W / L) * (Math.pow(Veosr, gamma + 2) - Math.pow(Veodr, gamma + 2)) / (gamma + 2)) - ID;
        //}else{
        //	y=((k)*(W/L_2_5um)*(Math.pow(Veosr, ghamma+2)/(ghamma+2)))-ID;
        //}

        // If the solution is NaN means that we do not have a valid solution
        if (Double.isNaN(y) || Double.isInfinite(y)) {
            throw new fIVnoSolution("fIV: NaN value for individual");
        }

        return y;

    }

    public static double fIV(double ID, double vg, double vd, double vt, double vss, double Ms, double ms, double gamma, double mu0, double cox, double w, double l, double va_prima) throws fIVnoSolution {

        // Variables
        double vs, y, veosr, veodr, l_prima, lambda;

        if (Ms == Double.POSITIVE_INFINITY)
        {
            vs = 0;
        }
        else
        {
            vs = Math.pow(ID / Ms, 1 / ms);
        }
        veosr = vss * Math.log(1 + Math.exp(((vg - vt - vs)) / vss));
        veodr = vss * Math.log(1 + Math.exp(((vg - vt - vd)) / vss));

        lambda = 1 / (va_prima * l);

        l_prima = (l / (1 + lambda * Math.abs(vd-vs)));

        y = (mu0 * cox * (w / l_prima) * (Math.pow(veosr, gamma + 2) - Math.pow(veodr, gamma + 2)) / (gamma + 2)) - ID;

        // If the solution is NaN means that we do not have a valid solution
        if (Double.isNaN(y) || Double.isInfinite(y))
        {
            throw new fIVnoSolution("fIV: NaN value for individual");
        }

        return y;

    }

    public static double busquedaceros(double IA, double IB, double vg, double vd, double vt, double vss, double Ms, double ms, double gamma, double mu0, double cox, double w, double l, double va_prima) throws ParameterSetNoConvergence {

        // declaration of variables
        double fa, fr, IR = 0;
        int iter;
        boolean isSolutionFound = false;

        // compute differences in points IA and IB
        fa = fIV(IA, vg, vd, vt, vss, Ms, ms, gamma, mu0, cox, w, l, va_prima);

        // search for solution
        for (iter = 0; (iter < 1000) && !isSolutionFound; iter++)
        {
            IR = (IA + IB) / 2; // corriente media

            fr = fIV(IR, vg, vd, vt, vss, Ms, ms, gamma, mu0, cox, w, l, va_prima); // f(corriente media)

            if (Math.abs(fr) < 1.0E-15)
            {
                isSolutionFound = true;
            }
            else
            {
                if (fa * fr < 0)
                {
                    IB = IR;
                }
                else if (fa * fr > 0)
                {
                    IA = IR;
                    fa = fr;
                }
            }
        }

        if (!isSolutionFound)
        {
            throw new ParameterSetNoConvergence("busquedaceros: Solution not found");
        }

        return IR;
    }
    public static double busquedaceros(double IA, double IB, double MR, double VG, double VTC, double VD, double ghamma, double k, double W, double L, int ilinear, double mk, double VSS) throws ParameterSetNoConvergence {

        // declaration of variables
        double fa, fb, fr, IR;
        int solution, iteration;

        // initialization of variables
        IR = 0;
        solution = 0;
        iteration = 0;

        // compute differences in points IA and IB
        fa = fIV(IA, MR, VG, VTC, VD, ghamma, k, W, L, ilinear, mk, VSS);
        fb = fIV(IB, MR, VG, VTC, VD, ghamma, k, W, L, ilinear, mk, VSS);

        // search for solution
        while ((solution == 0) && (iteration < 1000)) {

            IR = (IA + IB) / 2; // corriente media

            fr = fIV(IR, MR, VG, VTC, VD, ghamma, k, W, L, ilinear, mk, VSS); // f(corriente media)

            if (Math.abs(fr) < 1.0E-15) {
                //System.out.println("Solution found");
                solution = 1;
            }
            if (fa * fr < 0) {
                IB = IR;
            } else if (fa * fr > 0) {
                IA = IR;
                fa = fr;
            }
            iteration += 1;
        }

        if (solution == 0) {
            throw new ParameterSetNoConvergence("busquedaceros: Solution not found");
        }

        return IR;

    }

    public static double fIV(double ID, double VGS, double VT, double VDS, double gamma, double k, double W, double L, double VSS) throws fIVnoSolution {

        // Variables
        double y;
        double Veosr, Veodr;

        Veosr = VSS * Math.log(1 + Math.exp(((VGS - VT - 0)) / VSS));
        Veodr = VSS * Math.log(1 + Math.exp(((VGS - VT - VDS)) / VSS));

        // Compute ID
        //if ((VGS-VT) >= VDS) {
        y = ((k) * (W / L) * (Math.pow(Veosr, gamma + 2) - Math.pow(Veodr, gamma + 2)) / (gamma + 2)) - ID;
        //}else{
        //	y=((k)*(W/L_2_5um)*(Math.pow(Veosr, ghamma+2)/(ghamma+2)))-ID;
        //}

        // If the solution is NaN means that we do not have a valid solution
        if (Double.isNaN(y)) {
            throw new fIVnoSolution("fIV: NaN value for individual");
        }

        return y;

    }

    public static double busquedaceros(double IA, double IB, double VG, double VTC, double VD, double ghamma, double k, double W, double L, double VSS) throws ParameterSetNoConvergence {

        // declaration of variables
        double fa, fb, fr, IR;
        int solution, iteration;

        // initialization of variables
        IR = 0;
        solution = 0;
        iteration = 0;

        // compute differences in points IA and IB
        fa = fIV(IA, VG, VTC, VD, ghamma, k, W, L, VSS);
        fb = fIV(IB, VG, VTC, VD, ghamma, k, W, L, VSS);

        // search for solution
        while ((solution == 0) && (iteration < 1000)) {

            IR = (IA + IB) / 2; // corriente media

            fr = fIV(IR, VG, VTC, VD, ghamma, k, W, L, VSS); // f(corriente media)

            if (Math.abs(fr) < 1.0E-15)
            {
                //System.out.println("Solution found");
                solution = 1;
            }
            if (fa * fr < 0) {
                IB = IR;
            } else if (fa * fr > 0) {
                IA = IR;
                fa = fr;
            }
            iteration += 1;
        }

        if (solution == 0) {
            //throw new ParameterSetNoConvergence("busquedaceros: Solution not found");
        }

        return IR;

    }

    public static double outputCharacteristics(double[][] IVexp, double[] iaa, double[] vg, double[] vd, double vt, double vss, double alpha, double ms, double gamma, double mu0, double cox, double w, double l, double va_prima) {

        int num_points = vd.length;
        int num_curvas = vg.length;
        double IA, IB, Ms;

        double[] outputs = new double[num_points * num_curvas];
        double[] targets = new double[num_points * num_curvas];
        double[][] IVsim = new double[num_points][num_curvas];
        int n = 0;

        for (int i2 = 0; i2 < num_curvas; i2++)
        {
            for (int i1 = 0; i1 < num_points; i1++)
            {
                if (i1 > 1)
                {
                    IA = (IVsim[i1 - 1][i2]) / 2; // I assign the value of the previous point
                    IB = (IVsim[i1 - 1][i2]) * 2; // I assign the value of the previous point
                }
                else
                {
                    IA = iaa[i2];
                    IB = 0;
                }

                Ms = contactConductance(alpha, vss, vg[i2], vt, gamma);

                IVsim[i1][i2] = busquedaceros(IA, IB, vg[i2], vd[i1], vt, vss, Ms, ms, gamma, mu0, cox, w, l, va_prima);

                //System.out.println("i1: "+i1+ "i2: "+i2+ "  I_D_SIM:" +IVsim[i1][i2]+ "  I_D_EXP:" +IVexp[i1][i2]);

                targets[n] = IVexp[i1][i2];
                outputs[n] = IVsim[i1][i2];
                n += 1;
            } // fin de i1
        }   // fin de i2
        return Fitness.NRMSE(targets, outputs);
    }

    public static double outputCharacteristics(double[][] IVexp, double[] iaa, double[] vg, double[] vd, double vt, double vss, double ms, double []Ms, double gamma, double mu0, double cox, double w, double l, double va_prima)
    {
        int num_points = vd.length;
        int num_curvas = vg.length;
        double IA, IB;

        double[] outputs = new double[num_points * num_curvas];
        double[] targets = new double[num_points * num_curvas];
        double[][] IVsim = new double[num_points][num_curvas];
        int n = 0;

        for (int i2 = 0; i2 < num_curvas; i2++)
        {
            for (int i1 = 0; i1 < num_points; i1++)
            {
                if (i1 > 1)
                {
                    IA = (IVsim[i1 - 1][i2]) / 10; // I assign the value of the previous point
                    IB = (IVsim[i1 - 1][i2]) * 10; // I assign the value of the previous point
                }
                else
                {
                    IA = iaa[i2];
                    IB = 0;
                }

                IVsim[i1][i2] = busquedaceros(IA, IB, vg[i2], vd[i1], vt, vss, Ms[i2], ms, gamma, mu0, cox, w, l, va_prima);
                targets[n] = IVexp[i1][i2];
                outputs[n] = IVsim[i1][i2];
                n += 1;
            } // fin de i1
        }   // fin de i2
        return Fitness.NRMSE(targets, outputs);
    }
    public static double outputCharacteristics(double[][] IVexp, double[] iaa, double[] vg, double[] vd, double vt, double vss, double []Ms, double ms, double gamma, double mu0, double cox, double w, double l, double va_prima) {

        int num_points = vd.length;
        int num_curvas = vg.length;
        double IA, IB;

        double[] outputs = new double[num_points * num_curvas];
        double[] targets = new double[num_points * num_curvas];
        double[][] IVsim = new double[num_points][num_curvas];
        int n = 0;

        for (int i2 = 0; i2 < num_curvas; i2++)
        {
            for (int i1 = 0; i1 < num_points; i1++)
            {
                if (i1 > 1)
                {
                    IA = (IVsim[i1 - 1][i2]) / 2; // I assign the value of the previous point
                    IB = (IVsim[i1 - 1][i2]) * 2; // I assign the value of the previous point
                }
                else
                {
                    IA = iaa[i2];
                    IB = 0;
                }

                IVsim[i1][i2] = busquedaceros(IA, IB, vg[i2], vd[i1], vt, vss, Ms[i2], ms, gamma, mu0, cox, w, l, va_prima);
                targets[n] = IVexp[i1][i2];
                outputs[n] = IVsim[i1][i2];
                n += 1;
            } // fin de i1
        }   // fin de i2
        return Fitness.NRMSE(targets, outputs);
    }
    public static double outputCharacteristics(double[][] IVexp, double[] VGS, double[] VDS, double[] IAA, double W, double L, double k, double gamma, double[] MC, double VT, double VSS, double mk, int ilinear) {

        int points, incurvas;
        points = VDS.length;
        incurvas = VGS.length;
        double IA, IB;

        double[] outputs = new double[points * incurvas];
        double[] targets = new double[points * incurvas];
        double[][] IVsim = new double[points][incurvas];
        int n = 0;

        for (int i2 = 0; i2 < incurvas; i2++) {
            for (int i1 = 0; i1 < points; i1++) {
                if (i1 > 1) {

                    //if (mk > 1.1) {
                    IA = (IVsim[i1 - 1][i2]) / 2; // I assign the value of the previous point
                    IB = (IVsim[i1 - 1][i2]) * 2; // I assign the value of the previous point
                    //} else {
                    //    IA = (IVsim[i1 - 1][i2]) / 2; // I assign the value of the previous point
                    //    IB = (IVsim[i1 - 1][i2]) * 2; // I assign the value of the previous point
                    //}
                } else {
                    IA = IAA[i2];
                    IB = 0;
                }
                IVsim[i1][i2] = busquedaceros(IA, IB, MC[i2], VGS[i2], VT, VDS[i1], gamma, k, W, L, ilinear, mk, VSS);
                targets[n] = IVexp[i1][i2];
                outputs[n] = IVsim[i1][i2];
                n += 1;

            } // fin de i1
        }   // fin de i2

        return Fitness.NRMSE(targets, outputs);

    }

    public static double outputCharacteristics(double[] IVexp, double[] VGS, double[] VDS, double[] IAA, double W, double L, double k, double gamma, double[] MC, double VT, double VSS, double mk, int ilinear) {

        int points, incurvas;
        points = VDS.length;
        incurvas = VGS.length;
        double IA, IB;

        double[] outputs = new double[points * incurvas];
        double[] targets = new double[points * incurvas];
        double[][] IVsim = new double[points][incurvas];
        int n = 0;

        for (int i2 = 0; i2 < incurvas; i2++) {
            for (int i1 = 0; i1 < points; i1++) {
                if (i1 > 1) {

                    //if (mk > 1.1) {
                    IA = (IVsim[i1 - 1][i2])/ 2; // I assign the value of the previous point
                    IB = (IVsim[i1 - 1][i2])* 2; // I assign the value of the previous point
                    //} else {
                    //    IA = (IVsim[i1 - 1][i2]) / 2; // I assign the value of the previous point
                    //    IB = (IVsim[i1 - 1][i2]) * 2; // I assign the value of the previous point
                    //}
                } else {
                    IA = IAA[i2];
                    IB = 0;
                }
                IVsim[i1][i2] = busquedaceros(IA, IB, MC[i2], VGS[i2], VT, VDS[i1], gamma, k, W, L, ilinear, mk, VSS);
                targets[n] = IVexp[i1];
                outputs[n] = IVsim[i1][i2];
                n += 1;

            } // fin de i1
        }   // fin de i2

        return Fitness.NRMSE(targets, outputs);

    }

    public static double outputCharacteristics(double[][] IVexp, double[] VGS, double[] VDS, double[] IAA, double W, double L, double k, double gamma, double alpha, double VT, double VSS, double mk, int ilinear) {

        int points = VDS.length;
        int incurvas = VGS.length;
        int n = 0;

        double IA, IB, MC;

        //System.out.println("Points: "+points+ " Curvas: "+ incurvas);

        double[] outputs = new double[points * incurvas];
        double[] targets = new double[points * incurvas];
        double[][] IVsim = new double[points][incurvas];

        for (int i2 = 0; i2 < incurvas; i2++) {

            MC = contactConductance(alpha, VSS, VGS[i2], VT, gamma);
            //System.out.println(" i2: " +i2 + " MC: " + MC);

            for (int i1 = 0; i1 < points; i1++) {

                if (i1 > 1) {
                    IA = (IVsim[i1 - 1][i2]) / 2; // I assign the value of the previous point
                    IB = (IVsim[i1 - 1][i2]) * 2; // I assign the value of the previous point
                } else {
                    IA = IAA[i2];
                    IB = 0;
                }

                IVsim[i1][i2] = busquedaceros(IA, IB, MC, VGS[i2], VT, VDS[i1], gamma, k, W, L, ilinear, mk, VSS);
                targets[n] = IVexp[i1][i2];
                outputs[n] = IVsim[i1][i2];

                //System.out.println("i1:" +i1+ " i2: " +i2 + " IVsim: " + IVsim[i1][i2] + " IVexp: "+ IVexp[i1][i2] + " IAA: "+ IA);

                n += 1;

            } // fin de i1
        }   // fin de i2

        return Fitness.NRMSE(targets, outputs);

    }

    public static double outputCharacteristics(double[] IVexp, double[] VGS, double[] VDS, double[] IAA, double W, double L, double k, double gamma, double alpha, double VT, double VSS, double mk, int ilinear) {

        int points, incurvas;
        points = VDS.length;
        incurvas = VGS.length;
        double IA, IB, MC;

        double[] outputs = new double[points * incurvas];
        double[] targets = new double[points * incurvas];
        double[][] IVsim = new double[points][incurvas];
        int n = 0;

        for (int i2 = 0; i2 < incurvas; i2++) {
            for (int i1 = 0; i1 < points; i1++) {
                if (i1 > 1) {

                    //if (mk > 1.1) {
                    IA = (IVsim[i1 - 1][i2])/ 2; // I assign the value of the previous point
                    IB = (IVsim[i1 - 1][i2])* 2; // I assign the value of the previous point
                    //} else {
                    //    IA = (IVsim[i1 - 1][i2]) / 2; // I assign the value of the previous point
                    //    IB = (IVsim[i1 - 1][i2]) * 2; // I assign the value of the previous point
                    //}
                } else {
                    IA = IAA[i2];
                    IB = 0;
                }

                MC = contactConductance(alpha, VSS, VGS[i2], VT, gamma);

                IVsim[i1][i2] = busquedaceros(IA, IB, MC, VGS[i2], VT, VDS[i1], gamma, k, W, L, ilinear, mk, VSS);
                targets[n] = IVexp[i1];
                outputs[n] = IVsim[i1][i2];
                n += 1;

            } // fin de i1
        }   // fin de i2

        return Fitness.NRMSE(targets, outputs);

    }

    public static double outputCharacteristics(double[][] IVexp, double[] VGS, double[] VDS, double[] IAA, double W, double L, double k, double gamma, double []RC, double VT, double VSS) {

        int points, incurvas;
        points = VDS.length;
        incurvas = VGS.length;
        double IA, IB;

        double[] outputs = new double[points * incurvas];
        double[] targets = new double[points * incurvas];
        double[][] IVsim = new double[points][incurvas];
        int n = 0;

        for (int i2 = 0; i2 < incurvas; i2++) {
            for (int i1 = 0; i1 < points; i1++) {
                if (i1 > 1) {

                    //if (mk > 1.1) {
                    IA = (IVsim[i1 - 1][i2])/ 2; // I assign the value of the previous point
                    IB = (IVsim[i1 - 1][i2])* 2; // I assign the value of the previous point
                    //} else {
                    //    IA = (IVsim[i1 - 1][i2]) / 2; // I assign the value of the previous point
                    //    IB = (IVsim[i1 - 1][i2]) * 2; // I assign the value of the previous point
                    //}
                } else {
                    IA = IAA[i2];
                    IB = 0;
                }
                IVsim[i1][i2] = busquedaceros(IA, IB, RC[i2], VGS[i2], VT, VDS[i1], gamma, k, W, L, 1, 1.0, VSS);
                targets[n] = IVexp[i1][i2];
                outputs[n] = IVsim[i1][i2];
                n += 1;

            } // fin de i1
        }   // fin de i2

        return Fitness.NRMSE(targets, outputs);

    }

    public static double contactEffects(double[][] IVexp, double[] VGS, double[] VDS, double W, double L, double k, double gamma, double[] MC, double VT, double VSS, double mk, int ilinear) throws NegativeConctactVoltage, NaNConctactVoltage {

        int n, points, incurvas;
        double error, Veodr;

        points = VDS.length;
        incurvas = VGS.length;
        double[][] Vcon = new double[points][incurvas];
        double[][] Vcon2 = new double[points][incurvas];
        double[] outputs = new double[points * incurvas];
        double[] targets = new double[points * incurvas];

        // Extract the contact voltage
        n = 0;
        for (int i2 = 0; i2 < incurvas; i2++) {
            for (int i1 = 0; i1 < points; i1++) {

                // from the compact model
                //if ((VGSP[i2]-VTC) >= VDS[i1]){
                Veodr = VSS * Math.log(1 + Math.exp((VGS[i2] - VT - VDS[i1]) / VSS));
                Vcon[i1][i2] = VGS[i2] - VT - VSS * Math.log(Math.exp(Math.pow((IVexp[i1][i2]) * (L / (W * k)) * (gamma + 2) + Math.pow(Veodr, gamma + 2), 1.0 / (gamma + 2)) / VSS) - 1);
                //} else {
                //    Vcon[i1][i2]=Vcon[i1-1][i2];
                //Vcon[i1][i2]=VGSP[i2]-VTC-VSS*(Math.log(Math.exp(Math.pow(ID[i1][i2]*(L_2_5um/(W*k))*(ghamma+2), 1.0/(ghamma+2))/VSS)-1));
                //}
                // using the contact resistances
                if (ilinear == 0) {
                    Vcon2[i1][i2] = Math.pow((IVexp[i1][i2]) / MC[i2], 1 / 2);
                } else if (ilinear == 1) {
                    Vcon2[i1][i2] = (IVexp[i1][i2]) * MC[i2];
                } else {
                    Vcon2[i1][i2] = Math.pow((IVexp[i1][i2]) / MC[i2], 1 / mk);
                }

                outputs[n] = Vcon[i1][i2];
                targets[n] = Vcon2[i1][i2];
                //System.out.println("target: "+targets[n]+ "-- output: "+ outputs[n] );

                n++;
                //System.out.println("Vcon: " + Vcon[i1][i2] + " Vcon2: "+ Vcon2[i1][i2]);

                if (nanContactVoltage(Vcon2[i1][i2]) || nanContactVoltage(Vcon[i1][i2])) {
                    throw new NaNConctactVoltage("contactEffects: NaN value for contacts");
                } else if (negativeContactVoltage(Vcon[i1][i2]) || negativeContactVoltage(Vcon2[i1][i2])) {
                    throw new NegativeConctactVoltage("contactEffects: Conctac effects negative");
                } else if (infContactVoltage(Vcon[i1][i2]) || infContactVoltage(Vcon2[i1][i2])) {
                    throw new NegativeConctactVoltage("contactEffects: Conctac effects negative");
                }
            }
        }

        int numsum = 0;
        double sum = 0;
        double mean;
        double num = 0;
        double den = 0;

        for (int i2 = 0; i2 < incurvas; i2++) {
            for (int i1 = 0; i1 < points; i1++) {

                // from the compact model
                if ((VGS[i2] - VT) >= VDS[i1]) {

                    sum += Vcon2[i1][i2];
                    numsum = numsum + 1;
                }

            }

        }

        mean = sum / numsum;

        for (int i2 = 0; i2 < incurvas; i2++) {

            for (int i1 = 0; i1 < points; i1++) {

                // from the compact model
                if ((VGS[i2] - VT) >= VDS[i1]) {

                    num += (Math.pow(Vcon2[i1][i2] - Vcon[i1][i2], 2));
                    den += (Math.pow(Vcon2[i1][i2] - mean, 2));
                }
            }
        }

        // compute nrmse
        error = Math.sqrt(num / den);

        return error;

    }

    public static double contactEffects(double[] IVexp, double[] VGS, double[] VDS, double W, double L, double k, double gamma, double[] MC, double VT, double VSS, double mk, int ilinear) throws NegativeConctactVoltage, NaNConctactVoltage {

        int n, points, incurvas;
        double error, Veodr;

        points = VDS.length;
        incurvas = VGS.length;
        double[][] Vcon = new double[points][incurvas];
        double[][] Vcon2 = new double[points][incurvas];
        double[] outputs = new double[points * incurvas];
        double[] targets = new double[points * incurvas];

        // Extract the contact voltage
        n = 0;
        for (int i2 = 0; i2 < incurvas; i2++) {
            for (int i1 = 0; i1 < points; i1++) {

                // from the compact model
                //if ((VGSP[i2]-VTC) >= VDS[i1]){
                Veodr = VSS * Math.log(1 + Math.exp((VGS[i2] - VT - VDS[i1]) / VSS));
                Vcon[i1][i2] = VGS[i2] - VT - VSS * Math.log(Math.exp(Math.pow((IVexp[i1]) * (L / (W * k)) * (gamma + 2) + Math.pow(Veodr, gamma + 2), 1.0 / (gamma + 2)) / VSS) - 1);
                //} else {
                //    Vcon[i1][i2]=Vcon[i1-1][i2];
                //Vcon[i1][i2]=VGSP[i2]-VTC-VSS*(Math.log(Math.exp(Math.pow(ID[i1][i2]*(L_2_5um/(W*k))*(ghamma+2), 1.0/(ghamma+2))/VSS)-1));
                //}
                // using the contact resistances
                if (ilinear == 0) {
                    Vcon2[i1][i2] = Math.pow((IVexp[i1]) / MC[i2], 1 / 2);
                } else if (ilinear == 1) {
                    Vcon2[i1][i2] = (IVexp[i1]) * MC[i2];
                } else {
                    Vcon2[i1][i2] = Math.pow((IVexp[i1]) / MC[i2], 1 / mk);
                }

                outputs[n] = Vcon[i1][i2];
                targets[n] = Vcon2[i1][i2];
                //System.out.println("target: "+targets[n]+ "-- output: "+ outputs[n] );

                n++;
                //System.out.println("Vcon: " + Vcon[i1][i2] + " Vcon2: "+ Vcon2[i1][i2]);

                if (nanContactVoltage(Vcon2[i1][i2]) || nanContactVoltage(Vcon[i1][i2])) {
                    throw new NaNConctactVoltage("contactEffects: NaN value for contacts");
                } else if (negativeContactVoltage(Vcon[i1][i2]) || negativeContactVoltage(Vcon2[i1][i2])) {
                    throw new NegativeConctactVoltage("contactEffects: Conctac effects negative");
                } else if (infContactVoltage(Vcon[i1][i2]) || infContactVoltage(Vcon2[i1][i2])) {
                    throw new NegativeConctactVoltage("contactEffects: Conctac effects negative");
                }
            }
        }

        int numsum = 0;
        double sum = 0;
        double mean;
        double num = 0;
        double den = 0;

        for (int i2 = 0; i2 < incurvas; i2++) {
            for (int i1 = 0; i1 < points; i1++) {

                // from the compact model
                if ((VGS[i2] - VT) >= VDS[i1]) {

                    sum += Vcon2[i1][i2];
                    numsum = numsum + 1;
                }

            }

        }

        mean = sum / numsum;

        for (int i2 = 0; i2 < incurvas; i2++) {

            for (int i1 = 0; i1 < points; i1++) {

                // from the compact model
                if ((VGS[i2] - VT) >= VDS[i1]) {

                    num += (Math.pow(Vcon2[i1][i2] - Vcon[i1][i2], 2));
                    den += (Math.pow(Vcon2[i1][i2] - mean, 2));
                }
            }
        }

        // compute nrmse
        error = Math.sqrt(num / den);

        return error;

    }

    public static double contactEffects(double[] IVexp, double[] VGS, double[] VDS, double W, double L, double k, double gamma, double alpha, double VT, double VSS, double mk, int ilinear) throws NegativeConctactVoltage, NaNConctactVoltage {

        int n, points, incurvas;
        double error, Veodr, MC;

        points = VDS.length;
        incurvas = VGS.length;
        double[][] Vcon = new double[points][incurvas];
        double[][] Vcon2 = new double[points][incurvas];
        double[] outputs = new double[points * incurvas];
        double[] targets = new double[points * incurvas];

        // Extract the contact voltage
        n = 0;
        for (int i2 = 0; i2 < incurvas; i2++) {
            for (int i1 = 0; i1 < points; i1++) {

                // from the compact model
                //if ((VGSP[i2]-VTC) >= VDS[i1]){
                Veodr = VSS * Math.log(1 + Math.exp((VGS[i2] - VT - VDS[i1]) / VSS));
                Vcon[i1][i2] = VGS[i2] - VT - VSS * Math.log(Math.exp(Math.pow((IVexp[i1]) * (L / (W * k)) * (gamma + 2) + Math.pow(Veodr, gamma + 2), 1.0 / (gamma + 2)) / VSS) - 1);
                //} else {
                //    Vcon[i1][i2]=Vcon[i1-1][i2];
                //Vcon[i1][i2]=VGSP[i2]-VTC-VSS*(Math.log(Math.exp(Math.pow(ID[i1][i2]*(L_2_5um/(W*k))*(ghamma+2), 1.0/(ghamma+2))/VSS)-1));
                //}
                // using the contact resistances
                MC = contactConductance(alpha, VSS, VGS[i2], VT, gamma);

                if (ilinear == 0) {
                    Vcon2[i1][i2] = Math.pow((IVexp[i1]) / MC, 1 / 2);
                } else if (ilinear == 1) {
                    Vcon2[i1][i2] = (IVexp[i1]) * MC;
                } else {
                    Vcon2[i1][i2] = Math.pow((IVexp[i1]) / MC, 1 / mk);
                }

                outputs[n] = Vcon[i1][i2];
                targets[n] = Vcon2[i1][i2];
                //System.out.println("target: "+targets[n]+ "-- output: "+ outputs[n] );

                n++;
                //System.out.println("Vcon: " + Vcon[i1][i2] + " Vcon2: "+ Vcon2[i1][i2]);

                if (nanContactVoltage(Vcon2[i1][i2]) || nanContactVoltage(Vcon[i1][i2])) {
                    throw new NaNConctactVoltage("contactEffects: NaN value for contacts");
                } else if (negativeContactVoltage(Vcon[i1][i2]) || negativeContactVoltage(Vcon2[i1][i2])) {
                    throw new NegativeConctactVoltage("contactEffects: Conctac effects negative");
                } else if (infContactVoltage(Vcon[i1][i2]) || infContactVoltage(Vcon2[i1][i2])) {
                    throw new NegativeConctactVoltage("contactEffects: Conctac effects negative");
                }
            }
        }

        int numsum = 0;
        double sum = 0;
        double mean;
        double num = 0;
        double den = 0;

        for (int i2 = 0; i2 < incurvas; i2++) {
            for (int i1 = 0; i1 < points; i1++) {

                // from the compact model
                if ((VGS[i2] - VT) >= VDS[i1]) {

                    sum += Vcon2[i1][i2];
                    numsum = numsum + 1;
                }

            }

        }

        mean = sum / numsum;

        for (int i2 = 0; i2 < incurvas; i2++) {

            for (int i1 = 0; i1 < points; i1++) {

                // from the compact model
                if ((VGS[i2] - VT) >= VDS[i1]) {

                    num += (Math.pow(Vcon2[i1][i2] - Vcon[i1][i2], 2));
                    den += (Math.pow(Vcon2[i1][i2] - mean, 2));
                }
            }
        }

        // compute nrmse
        error = Math.sqrt(num / den);

        return error;

    }


    public static double contactEffectsAllRegimes(double[][] IVexp, double[] VGS, double[] VDS, double W, double L, double k, double gamma, double[] MC, double VT, double VSS, double mk, int ilinear) throws NegativeConctactVoltage, NaNConctactVoltage {

        int n, points, incurvas;
        double Veodr;

        points = VDS.length;
        incurvas = VGS.length;
        double[][] Vcon = new double[points][incurvas];
        double[][] Vcon2 = new double[points][incurvas];
        double[] outputs = new double[points * incurvas];
        double[] targets = new double[points * incurvas];

        // Extract the contact voltage
        n = 0;
        for (int i2 = 0; i2 < incurvas; i2++) {
            for (int i1 = 0; i1 < points; i1++) {

                // from the compact model
                //if ((VGSP[i2]-VTC) >= VDS[i1]){
                Veodr = VSS * Math.log(1 + Math.exp((VGS[i2] - VT - VDS[i1]) / VSS));
                Vcon[i1][i2] = VGS[i2] - VT - VSS * Math.log(Math.exp(Math.pow((IVexp[i1][i2]) * (L / (W * k)) * (gamma + 2) + Math.pow(Veodr, gamma + 2), 1.0 / (gamma + 2)) / VSS) - 1);
                //} else {
                //    Vcon[i1][i2]=Vcon[i1-1][i2];
                //Vcon[i1][i2]=VGSP[i2]-VTC-VSS*(Math.log(Math.exp(Math.pow(ID[i1][i2]*(L_2_5um/(W*k))*(ghamma+2), 1.0/(ghamma+2))/VSS)-1));
                //}
                // using the contact resistances
                if (ilinear == 0) {
                    Vcon2[i1][i2] = Math.pow((IVexp[i1][i2]) / MC[i2], 1 / 2);
                } else if (ilinear == 1) {
                    Vcon2[i1][i2] = (IVexp[i1][i2]) * MC[i2];
                } else {
                    Vcon2[i1][i2] = Math.pow((IVexp[i1][i2]) / MC[i2], 1 / mk);
                }

                outputs[n] = Vcon[i1][i2];
                targets[n] = Vcon2[i1][i2];
                //System.out.println("target: "+targets[n]+ "-- output: "+ outputs[n] );

                n++;
                //System.out.println("Vcon: " + Vcon[i1][i2] + " Vcon2: "+ Vcon2[i1][i2]);

                if (nanContactVoltage(Vcon2[i1][i2]) || nanContactVoltage(Vcon[i1][i2])) {
                    throw new NaNConctactVoltage("contactEffects: NaN value for contacts");
                } else if (negativeContactVoltage(Vcon[i1][i2]) || negativeContactVoltage(Vcon2[i1][i2])) {
                    throw new NegativeConctactVoltage("contactEffects: Conctac effects negative");
                } else if (infContactVoltage(Vcon[i1][i2]) || infContactVoltage(Vcon2[i1][i2])) {
                    throw new NegativeConctactVoltage("contactEffects: Conctac effects negative");
                }
            }
        }

        return Fitness.NRMSE(targets, outputs);

    }

    public static double contactEffects(double[][] IVexp, double[] VGS, double[] VDS, double W, double L, double k, double gamma, double RC, double VT, double VSS) throws NegativeConctactVoltage, NaNConctactVoltage {

        int n, points, incurvas;
        double error, Veodr;

        points = VDS.length;
        incurvas = VGS.length;
        double[][] Vcon = new double[points][incurvas];
        double[][] Vcon2 = new double[points][incurvas];
        double[] outputs = new double[points * incurvas];
        double[] targets = new double[points * incurvas];

        // Extract the contact voltage
        n = 0;
        for (int i2 = 0; i2 < incurvas; i2++) {
            for (int i1 = 0; i1 < points; i1++) {

                // from the compact model
                //if ((VGSP[i2]-VTC) >= VDS[i1]){
                Veodr = VSS * Math.log(1 + Math.exp((VGS[i2] - VT - VDS[i1]) / VSS));
                Vcon[i1][i2] = VGS[i2] - VT - VSS * Math.log(Math.exp(Math.pow((IVexp[i1][i2]) * (L / (W * k)) * (gamma + 2) + Math.pow(Veodr, gamma + 2), 1.0 / (gamma + 2)) / VSS) - 1);
                //} else {
                //    Vcon[i1][i2]=Vcon[i1-1][i2];
                //Vcon[i1][i2]=VGSP[i2]-VTC-VSS*(Math.log(Math.exp(Math.pow(ID[i1][i2]*(L_2_5um/(W*k))*(ghamma+2), 1.0/(ghamma+2))/VSS)-1));
                //}
                // using the contact resistances
                Vcon2[i1][i2] = (IVexp[i1][i2]) * RC;

                outputs[n] = Vcon[i1][i2];
                targets[n] = Vcon2[i1][i2];
                //System.out.println("target: "+targets[n]+ "-- output: "+ outputs[n] );

                n++;
                //System.out.println("Vcon: " + Vcon[i1][i2] + " Vcon2: "+ Vcon2[i1][i2]);

                if (nanContactVoltage(Vcon2[i1][i2]) || nanContactVoltage(Vcon[i1][i2])) {
                    throw new NaNConctactVoltage("contactEffects: NaN value for contacts");
                } else if (negativeContactVoltage(Vcon[i1][i2]) || negativeContactVoltage(Vcon2[i1][i2])) {
                    throw new NegativeConctactVoltage("contactEffects: Conctac effects negative");
                } else if (infContactVoltage(Vcon[i1][i2]) || infContactVoltage(Vcon2[i1][i2])) {
                    throw new NegativeConctactVoltage("contactEffects: Conctac effects negative");
                }
            }
        }

        int numsum = 0;
        double sum = 0;
        double mean;
        double num = 0;
        double den = 0;

        for (int i2 = 0; i2 < incurvas; i2++) {
            for (int i1 = 0; i1 < points; i1++) {

                // from the compact model
                if ((VGS[i2] - VT) >= VDS[i1]) {

                    sum += Vcon2[i1][i2];
                    numsum = numsum + 1;
                }

            }

        }

        mean = sum / numsum;

        for (int i2 = 0; i2 < incurvas; i2++) {

            for (int i1 = 0; i1 < points; i1++) {

                // from the compact model
                if ((VGS[i2] - VT) >= VDS[i1]) {

                    num += (Math.pow(Vcon2[i1][i2] - Vcon[i1][i2], 2));
                    den += (Math.pow(Vcon2[i1][i2] - mean, 2));
                }
            }
        }

        // compute nrmse
        error = Math.sqrt(num / den);

        return error;

    }
    public static double contactEffects(double[][] IVexp, double[] VGS, double[] VDS, double W, double L, double k, double gamma, double []RC, double VT, double VSS) throws NegativeConctactVoltage, NaNConctactVoltage {

        int n, points, incurvas;
        double error, Veodr;

        points = VDS.length;
        incurvas = VGS.length;
        double[][] Vcon = new double[points][incurvas];
        double[][] Vcon2 = new double[points][incurvas];
        double[] outputs = new double[points * incurvas];
        double[] targets = new double[points * incurvas];

        // Extract the contact voltage
        n = 0;
        for (int i2 = 0; i2 < incurvas; i2++) {
            for (int i1 = 0; i1 < points; i1++) {

                // from the compact model
                //if ((VGSP[i2]-VTC) >= VDS[i1]){
                Veodr = VSS * Math.log(1 + Math.exp((VGS[i2] - VT - VDS[i1]) / VSS));
                Vcon[i1][i2] = VGS[i2] - VT - VSS * Math.log(Math.exp(Math.pow((IVexp[i1][i2]) * (L / (W * k)) * (gamma + 2) + Math.pow(Veodr, gamma + 2), 1.0 / (gamma + 2)) / VSS) - 1);
                //} else {
                //    Vcon[i1][i2]=Vcon[i1-1][i2];
                //Vcon[i1][i2]=VGSP[i2]-VTC-VSS*(Math.log(Math.exp(Math.pow(ID[i1][i2]*(L_2_5um/(W*k))*(ghamma+2), 1.0/(ghamma+2))/VSS)-1));
                //}
                // using the contact resistances
                Vcon2[i1][i2] = (IVexp[i1][i2]) * RC[i2];

                outputs[n] = Vcon[i1][i2];
                targets[n] = Vcon2[i1][i2];
                //System.out.println("target: "+targets[n]+ "-- output: "+ outputs[n] );

                n++;
                //System.out.println("Vcon: " + Vcon[i1][i2] + " Vcon2: "+ Vcon2[i1][i2]);

                if (nanContactVoltage(Vcon2[i1][i2]) || nanContactVoltage(Vcon[i1][i2])) {
                    throw new NaNConctactVoltage("contactEffects: NaN value for contacts");
                } else if (negativeContactVoltage(Vcon[i1][i2]) || negativeContactVoltage(Vcon2[i1][i2])) {
                    throw new NegativeConctactVoltage("contactEffects: Conctac effects negative");
                } else if (infContactVoltage(Vcon[i1][i2]) || infContactVoltage(Vcon2[i1][i2])) {
                    throw new NegativeConctactVoltage("contactEffects: Conctac effects negative");
                }
            }
        }

        int numsum = 0;
        double sum = 0;
        double mean;
        double num = 0;
        double den = 0;

        for (int i2 = 0; i2 < incurvas; i2++) {
            for (int i1 = 0; i1 < points; i1++) {

                // from the compact model
                if ((VGS[i2] - VT) >= VDS[i1]) {

                    sum += Vcon2[i1][i2];
                    numsum = numsum + 1;
                }

            }

        }

        mean = sum / numsum;

        for (int i2 = 0; i2 < incurvas; i2++) {

            for (int i1 = 0; i1 < points; i1++) {

                // from the compact model
                if ((VGS[i2] - VT) >= VDS[i1]) {

                    num += (Math.pow(Vcon2[i1][i2] - Vcon[i1][i2], 2));
                    den += (Math.pow(Vcon2[i1][i2] - mean, 2));
                }
            }
        }

        // compute nrmse
        error = Math.sqrt(num / den);

        return error;

    }
    public static double contactEffects(double[][] IVexp, double[] VGS, double[] VDS, double W, double L, double k, double gamma, double alpha, double VT, double VSS, double mk, int ilinear) throws NegativeConctactVoltage, NaNConctactVoltage {

        int n, points, incurvas;
        double error, Veodr;

        points = VDS.length;
        incurvas = VGS.length;
        double[][] Vcon = new double[points][incurvas];
        double[][] Vcon2 = new double[points][incurvas];
        double[] outputs = new double[points * incurvas];
        double[] targets = new double[points * incurvas];
        double MC;
        
        // Extract the contact voltage
        n = 0;
        for (int i2 = 0; i2 < incurvas; i2++) {
            for (int i1 = 0; i1 < points; i1++) {

                // from the compact model
                //if ((VGSP[i2]-VTC) >= VDS[i1]){
                Veodr = VSS * Math.log(1 + Math.exp((VGS[i2] - VT - VDS[i1]) / VSS));
                Vcon[i1][i2] = VGS[i2] - VT - VSS * Math.log(Math.exp(Math.pow((IVexp[i1][i2]) * (L / (W * k)) * (gamma + 2) + Math.pow(Veodr, gamma + 2), 1.0 / (gamma + 2)) / VSS) - 1);
                //} else {
                //    Vcon[i1][i2]=Vcon[i1-1][i2];
                //Vcon[i1][i2]=VGSP[i2]-VTC-VSS*(Math.log(Math.exp(Math.pow(ID[i1][i2]*(L_2_5um/(W*k))*(ghamma+2), 1.0/(ghamma+2))/VSS)-1));
                //}
                // using the contact resistances
                MC = contactConductance(alpha, VSS, VGS[i2], VT, gamma);

                if (ilinear == 0) {
                    Vcon2[i1][i2] = Math.pow((IVexp[i1][i2]) / MC, 1 / 2);
                } else if (ilinear == 1) {
                    Vcon2[i1][i2] = (IVexp[i1][i2]) * MC;
                } else {
                    Vcon2[i1][i2] = Math.pow((IVexp[i1][i2]) / MC, 1 / mk);
                }

                outputs[n] = Vcon[i1][i2];
                targets[n] = Vcon2[i1][i2];
                //System.out.println("target: "+targets[n]+ "-- output: "+ outputs[n] );

                n++;
                //System.out.println("Vcon: " + Vcon[i1][i2] + " Vcon2: "+ Vcon2[i1][i2]);

                if (nanContactVoltage(Vcon2[i1][i2]) || nanContactVoltage(Vcon[i1][i2])) {
                    throw new NaNConctactVoltage("contactEffects: NaN value for contacts");
                } else if (negativeContactVoltage(Vcon[i1][i2]) || negativeContactVoltage(Vcon2[i1][i2])) {
                    throw new NegativeConctactVoltage("contactEffects: Conctac effects negative");
                } else if (infContactVoltage(Vcon[i1][i2]) || infContactVoltage(Vcon2[i1][i2])) {
                    throw new NegativeConctactVoltage("contactEffects: Conctac effects negative");
                }
            }
        }

        int numsum = 0;
        double sum = 0;
        double mean;
        double num = 0;
        double den = 0;

        for (int i2 = 0; i2 < incurvas; i2++) {
            for (int i1 = 0; i1 < points; i1++) {

                // from the compact model
                if ((VGS[i2] - VT) >= VDS[i1]) {

                    sum += Vcon2[i1][i2];
                    numsum = numsum + 1;
                }

            }

        }

        mean = sum / numsum;

        for (int i2 = 0; i2 < incurvas; i2++) {

            for (int i1 = 0; i1 < points; i1++) {

                // from the compact model
                if ((VGS[i2] - VT) >= VDS[i1]) {

                    num += (Math.pow(Vcon2[i1][i2] - Vcon[i1][i2], 2));
                    den += (Math.pow(Vcon2[i1][i2] - mean, 2));
                }
            }
        }

        // compute nrmse
        error = Math.sqrt(num / den);

        return error;

    }

    public static double contactEffects(double[][] IVexp, double[] vg, double[] vd, double vt, double vss, double alpha, double ms, double gamma, double mu0, double cox, double w, double l, double va_prima) throws NegativeConctactVoltage, NaNConctactVoltage {

        int num_points = vd.length;
        int num_curvas = vg.length;
        double[][] Vcon = new double[num_points][num_curvas];
        double[][] Vcon2 = new double[num_points][num_curvas];
        double[] outputs = new double[num_points * num_curvas];
        double[] targets = new double[num_points * num_curvas];
        double Ms;
        double l_prima;
        double vcona, vconb;
        double lambda = 1 / (va_prima * l);
        int n;
        double error, Veodr;
        double iterations;
        // Extract the contact voltage
        n = 0;
        for (int i2 = 0; i2 < num_curvas; i2++)
        {
            for (int i1 = 0; i1 < num_points; i1++)
            {
                Ms = contactConductance(alpha, vss, vg[i2], vt, gamma);

                Veodr = vss * Math.log(1 + Math.exp((vg[i2] - vt - vd[i1]) / vss));

                l_prima = l;
                vcona = vg[i2] - vt - vss * Math.log(Math.exp(Math.pow((IVexp[i1][i2]) * (l_prima / (w * mu0 * cox)) * (gamma + 2) + Math.pow(Veodr, gamma + 2), 1.0 / (gamma + 2)) / vss) - 1);

                l_prima = (l / (1 + lambda * Math.abs(vd[i1]-vcona)));
                vconb = vg[i2] - vt - vss * Math.log(Math.exp(Math.pow((IVexp[i1][i2]) * (l_prima / (w * mu0 * cox)) * (gamma + 2) + Math.pow(Veodr, gamma + 2), 1.0 / (gamma + 2)) / vss) - 1);

                iterations = 0;
                while ((Math.abs((vconb-vcona)/vconb)>0.001) && (iterations < 1000))
                {
                    vcona = vconb;
                    l_prima = (l / (1 + lambda * Math.abs(vd[i1]-vcona)));
                    vconb = vg[i2] - vt - vss * Math.log(Math.exp(Math.pow((IVexp[i1][i2]) * (l_prima / (w * mu0 * cox)) * (gamma + 2) + Math.pow(Veodr, gamma + 2), 1.0 / (gamma + 2)) / vss) - 1);

                    iterations++;
                }

                if (iterations >= 1000)
                {
                    throw new NaNConctactVoltage("contactEffects: NaN value for contacts");
                }

                Vcon[i1][i2] = vconb;
                Vcon2[i1][i2] = Math.pow((IVexp[i1][i2]) / Ms, 1 / ms);

                outputs[n] = Vcon[i1][i2];
                targets[n] = Vcon2[i1][i2];

                n++;

                if (nanContactVoltage(Vcon2[i1][i2]) || nanContactVoltage(Vcon[i1][i2]))
                {
                    throw new NaNConctactVoltage("contactEffects: NaN value for contacts");
                }
                else if (negativeContactVoltage(Vcon[i1][i2]))
                {
                    throw new NegativeConctactVoltage("contactEffects: Conctact effects negative");
                }
                else if (negativeContactVoltage(Vcon2[i1][i2]))
                {
                    throw new NegativeConctactVoltage("contactEffects: Conctact effects negative");
                }
                else if (infContactVoltage(Vcon[i1][i2]) || infContactVoltage(Vcon2[i1][i2]))
                {
                    throw new NegativeConctactVoltage("contactEffects: Conctact effects infinite");
                }
            }
        }

        int numsum = 0;
        double sum = 0;
        double mean;
        double num = 0;
        double den = 0;

        for (int i2 = 0; i2 < num_curvas; i2++) {
            for (int i1 = 0; i1 < num_points; i1++) {

                // from the compact model
                if ((vg[i2] - vt) >= vd[i1]) {

                    sum += Vcon2[i1][i2];
                    numsum = numsum + 1;
                }
            }
        }

        mean = sum / numsum;

        for (int i2 = 0; i2 < num_curvas; i2++) {
            for (int i1 = 0; i1 < num_points; i1++) {

                // from the compact model
                if ((vg[i2] - vt) >= vd[i1]) {

                    num += (Math.pow(Vcon2[i1][i2] - Vcon[i1][i2], 2));
                    den += (Math.pow(Vcon2[i1][i2] - mean, 2));
                }
            }
        }

        // compute nrmse
        error = Math.sqrt(num / den);

        return error;

    }

    public static double contactEffects(double[][] IVexp, double[] vg, double[] vd, double vt, double vss, double[]Ms, double ms, double gamma, double mu0, double cox, double w, double l, double va_prima) throws NegativeConctactVoltage, NaNConctactVoltage {

        int num_points = vd.length;
        int num_curvas = vg.length;
        double[][] Vcon = new double[num_points][num_curvas];
        double[][] Vcon2 = new double[num_points][num_curvas];
        double[] outputs = new double[num_points * num_curvas];
        double[] targets = new double[num_points * num_curvas];
        double l_prima;
        double vcona, vconb;
        double lambda = 1 / (va_prima * l);
        int n;
        double error, Veodr;
        double iterations;
        // Extract the contact voltage
        n = 0;
        for (int i2 = 0; i2 < num_curvas; i2++)
        {
            for (int i1 = 0; i1 < num_points; i1++)
            {
                Veodr = vss * Math.log(1 + Math.exp((vg[i2] - vt - vd[i1]) / vss));

                l_prima = l;
                vcona = vg[i2] - vt - vss * Math.log(Math.exp(Math.pow((IVexp[i1][i2]) * (l_prima / (w * mu0 * cox)) * (gamma + 2) + Math.pow(Veodr, gamma + 2), 1.0 / (gamma + 2)) / vss) - 1);

                l_prima = (l / (1 + lambda * Math.abs(vd[i1]-vcona)));
                vconb = vg[i2] - vt - vss * Math.log(Math.exp(Math.pow((IVexp[i1][i2]) * (l_prima / (w * mu0 * cox)) * (gamma + 2) + Math.pow(Veodr, gamma + 2), 1.0 / (gamma + 2)) / vss) - 1);

                iterations = 0;
                while ((Math.abs((vconb-vcona)/vconb)>0.001) && (iterations < 1000))
                {
                    vcona = vconb;
                    l_prima = (l / (1 + lambda * Math.abs(vd[i1]-vcona)));
                    vconb = vg[i2] - vt - vss * Math.log(Math.exp(Math.pow((IVexp[i1][i2]) * (l_prima / (w * mu0 * cox)) * (gamma + 2) + Math.pow(Veodr, gamma + 2), 1.0 / (gamma + 2)) / vss) - 1);

                    iterations++;
                }

                if (iterations >= 1000)
                {
                    throw new NaNConctactVoltage("contactEffects: NaN value for contacts");
                }

                Vcon[i1][i2] = vconb;
                Vcon2[i1][i2] = Math.pow((IVexp[i1][i2]) / Ms[i2], 1 / ms);

                outputs[n] = Vcon[i1][i2];
                targets[n] = Vcon2[i1][i2];
                //System.out.println("target: "+targets[n]+ "-- output: "+ outputs[n] );

                n++;
                //System.out.println("Vcon: " + Vcon[i1][i2] + " Vcon2: "+ Vcon2[i1][i2]);

                if (nanContactVoltage(Vcon2[i1][i2]) || nanContactVoltage(Vcon[i1][i2]))
                {
                    throw new NaNConctactVoltage("contactEffects: NaN value for contacts");
                }
                else if (negativeContactVoltage(Vcon[i1][i2]))
                {
                    throw new NegativeConctactVoltage("contactEffects: Conctact effects negative");
                }
                else if (negativeContactVoltage(Vcon2[i1][i2]))
                {
                    throw new NegativeConctactVoltage("contactEffects: Conctact effects negative");
                }
                else if (infContactVoltage(Vcon[i1][i2]) || infContactVoltage(Vcon2[i1][i2]))
                {
                    throw new NegativeConctactVoltage("contactEffects: Conctact effects infinite");
                }
            }
        }

        int numsum = 0;
        double sum = 0;
        double mean;
        double num = 0;
        double den = 0;

        for (int i2 = 0; i2 < num_curvas; i2++) {
            for (int i1 = 0; i1 < num_points; i1++) {

                // from the compact model
                if ((vg[i2] - vt) >= vd[i1]) {

                    sum += Vcon2[i1][i2];
                    numsum = numsum + 1;
                }
            }
        }

        mean = sum / numsum;

        for (int i2 = 0; i2 < num_curvas; i2++) {
            for (int i1 = 0; i1 < num_points; i1++) {

                // from the compact model
                if ((vg[i2] - vt) >= vd[i1]) {

                    num += (Math.pow(Vcon2[i1][i2] - Vcon[i1][i2], 2));
                    den += (Math.pow(Vcon2[i1][i2] - mean, 2));
                }
            }
        }

        // compute nrmse
        error = Math.sqrt(num / den);

        return error;

    }

    public static double transferCharacteristics(double[][] IVexp, double[] VGS, double[] VDS, double IAA, double W, double L, double k, double gamma, double alphaSource, double VT, double VSS, double mk, int ilinear) {

        int points, incurvas;
        points = VDS.length;
        incurvas = VGS.length;
        double IA, IB;

        double[] MC = new double[incurvas];
        double[] outputs = new double[points * incurvas];
        double[] targets = new double[points * incurvas];
        double[][] IVsim = new double[incurvas][points];
        int n = 0;

        for (int i2 = 0; i2 < incurvas; i2++) {
            MC[i2] = contactConductance(alphaSource, VSS, VGS[i2], VT, gamma);
            for (int i1 = 0; i1 < points; i1++) {
                if (i1 > 1) {
                    IA = (IVsim[i2][i1 - 1])/ 2; // I assign the value of the previous point
                    IB = (IVsim[i2][i1 - 1])* 2; // I assign the value of the previous point

                } else {
                    IA = IAA;
                    IB = 0;
                }
                //System.out.println("VT: "+VT+ " VG: "+VGS[i2]+ " VDS:" + VDS[i1]);
                IVsim[i2][i1] = busquedaceros(IA, IB, MC[i2], VGS[i2], VT, VDS[i1], gamma, k, W, L, ilinear, mk, VSS);
                targets[n] = IVexp[i2][i1];
                outputs[n] = IVsim[i2][i1];
                n += 1;
                //System.out.println("target: "+targets[n]+ "-- output: "+ outputs[n] );
                //System.out.println("Difference: "+ Math.abs(targets[n]-outputs[n]));

            } // fin de i1
        }   // fin de i2

        return Fitness.NRMSE(targets, outputs);

    }

    public static double transferCharacteristicsAllRegimes(double[] IVexp, double[] VGS, double[] VDS, double [] m2, double [] Ioff, double IAA, double W, double L, double k, double gamma, double alphaSource, double VT, double VSS, double mk, int ilinear) {

        int points, incurvas;
        points = VDS.length;
        incurvas = VGS.length;
        double IA, IB;

        double[] MC = new double[incurvas];
        double[] outputs = new double[points * incurvas];
        double[] targets = new double[points * incurvas];
        double[][] IVsim = new double[incurvas][points];
        double iv;
        int n = 0;

        for (int i2 = 0; i2 < incurvas; i2++) {
            MC[i2] = contactConductance(alphaSource, VSS, VGS[i2], VT, gamma);
            for (int i1 = 0; i1 < points; i1++) {
                if (i1 > 1) {
                    IA = (IVsim[i2][i1 - 1])/ 2; // I assign the value of the previous point
                    IB = (IVsim[i2][i1 - 1])* 2; // I assign the value of the previous point

                } else {
                    IA = IAA;
                    IB = 0;
                }
                //System.out.println("VT: "+VT+ " VG: "+VGS[i2]+ " VDS:" + VDS[i1]);
                iv = busquedaceros(IA, IB, MC[i2], VGS[i2], VT, VDS[i1], gamma, k, W, L, ilinear, mk, VSS);

                IVsim[i2][i1] =  Ioff[i1]*Math.pow(1+ Math.pow(iv/Ioff[i1], m2[i1]), 1/m2[i1]);
                targets[n] = IVexp[i1];
                outputs[n] = IVsim[i2][i1];
                n += 1;

                if (Double.isInfinite(IVsim[i2][i1]) || Double.isNaN(IVsim[i2][i1]) || IVsim[i2][i1]<0)
                {
                    throw new ParameterSetNoConvergence("busquedaceros: Solution not found");
                }
                //System.out.println("IVsim[i2][i1]: "+IVsim[i2][i1]);
                //System.out.println("Difference: "+ Math.abs(targets[n]-outputs[n]));

            } // fin de i1
        }   // fin de i2

        return Fitness.NRMSE(targets, outputs);

    }


    public static double transferCharacteristicsAllRegimes(double[][] IVexp, double[] VGS, double[] VDS, double [] m2, double [] Ioff, double IAA, double W, double L, double k, double gamma, double alphaSource, double VT, double VSS, double mk, int ilinear) {

        int points, incurvas;
        points = VDS.length;
        incurvas = VGS.length;
        double IA, IB;

        double[] MC = new double[incurvas];
        double[] outputs = new double[points * incurvas];
        double[] targets = new double[points * incurvas];
        double[][] IVsim = new double[incurvas][points];
        double iv;
        int n = 0;

        for (int i2 = 0; i2 < incurvas; i2++) {
            MC[i2] = contactConductance(alphaSource, VSS, VGS[i2], VT, gamma);
            for (int i1 = 0; i1 < points; i1++) {
                if (i1 > 1) {
                    IA = (IVsim[i2][i1 - 1])/ 2; // I assign the value of the previous point
                    IB = (IVsim[i2][i1 - 1])* 2; // I assign the value of the previous point

                } else {
                    IA = IAA;
                    IB = 0;
                }
                //System.out.println("VT: "+VT+ " VG: "+VGS[i2]+ " VDS:" + VDS[i1]);
                iv = busquedaceros(IA, IB, MC[i2], VGS[i2], VT, VDS[i1], gamma, k, W, L, ilinear, mk, VSS);

                IVsim[i2][i1] =  Ioff[i1]*Math.pow(1+ Math.pow(iv/Ioff[i1], m2[i1]), 1/m2[i1]);
                targets[n] = IVexp[i2][i1];
                outputs[n] = IVsim[i2][i1];
                n += 1;

                if (Double.isInfinite(IVsim[i2][i1]) || Double.isNaN(IVsim[i2][i1]) || IVsim[i2][i1]<0)
                    {
                    throw new ParameterSetNoConvergence("busquedaceros: Solution not found");
                }
                //System.out.println("IVsim[i2][i1]: "+IVsim[i2][i1]);
                //System.out.println("Difference: "+ Math.abs(targets[n]-outputs[n]));

            } // fin de i1
        }   // fin de i2

        return Fitness.NRMSE(targets, outputs);

    }
}
