% Function integral for the APEX program.

% Copyright by Davide Vione and Marco Bodrato
% This free software is released with a BY-NC licence. You are free to Share (to copy, distribute and transmit the work) and 
% to Remix (to adapt the work), under the following conditions:
% Attribution   You must attribute the work in the manner specified by the author or licensor 
%                (but not in any way that suggests that they endorse you or your use of the work). 
% Noncommercial  You may not use this work for commercial purposes.

% This is part of the APEX program
% Aqueous Photochemistry of Environmentally occurring Xenobiotics

function Area = integral (X,Y)
	Area = 0;
	for I = 2:length(X),
	  Area = Area + (Y(I)+Y(I-1))*(X(I)-X(I-1))/2;
	endfor;
endfunction;
