/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.pathwayscoringplugin;

import cytoscape.CyEdge;
import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import cytoscape.layout.CyLayouts;
import cytoscape.pathwayscoringplugin.ScoreFlowAlgorithm;
import cytoscape.plugin.CytoscapePlugin;
import cytoscape.util.CytoscapeAction;
import cytoscape.view.CyNetworkView;
import cytoscape.visual.ArrowShape;
import cytoscape.visual.CalculatorCatalog;
import cytoscape.visual.EdgeAppearance;
import cytoscape.visual.EdgeAppearanceCalculator;
import cytoscape.visual.GlobalAppearanceCalculator;
import cytoscape.visual.LineStyle;
import cytoscape.visual.NodeAppearance;
import cytoscape.visual.NodeAppearanceCalculator;
import cytoscape.visual.NodeShape;
import cytoscape.visual.VisualMappingManager;
import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.VisualStyle;
import cytoscape.visual.calculators.BasicCalculator;
import cytoscape.visual.calculators.Calculator;
import cytoscape.visual.mappings.BoundaryRangeValues;
import cytoscape.visual.mappings.ContinuousMapping;
import cytoscape.visual.mappings.DiscreteMapping;
import cytoscape.visual.mappings.Interpolator;
import cytoscape.visual.mappings.LinearNumberToColorInterpolator;
import cytoscape.visual.mappings.ObjectMapping;
import cytoscape.visual.mappings.PassThroughMapping;
import giny.model.Edge;
import giny.model.GraphObject;
import giny.model.Node;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.xml.rpc.ServiceException;
import keggapi.KEGGLocator;
import keggapi.KEGGPortType;
import keggapi.PathwayElement;
import keggapi.PathwayElementRelation;
import keggapi.Subtype;

public class PathwayScoringPlugin
extends CytoscapePlugin {
    public int wind;
    public static final String vsName = "KGML_Style";

    public PathwayScoringPlugin() {
        JMenu menu = Cytoscape.getDesktop().getCyMenus().getOperationsMenu();
        JMenu submenu = new JMenu("Pathway Scoring Plugin");
        JMenuItem item = new JMenuItem("Load Experimental Data");
        item.addActionListener((ActionListener)((Object)new RunAlgorithmAction()));
        submenu.add(item);
        item = new JMenuItem("Load KEGG Pathway");
        item.addActionListener((ActionListener)((Object)new LoadFileAction()));
        submenu.add(item);
        item = new JMenuItem("Export Node Scores");
        item.addActionListener((ActionListener)((Object)new SaveFileAction()));
        submenu.add(item);
        menu.add(submenu);
        CyNetworkView networkView = Cytoscape.getCurrentNetworkView();
        VisualMappingManager manager = Cytoscape.getVisualMappingManager();
        CalculatorCatalog catalog = manager.getCalculatorCatalog();
        VisualStyle vs = this.createVisualStyle();
        catalog.addVisualStyle(vs);
        networkView.setVisualStyle(vs.getName());
        manager.setVisualStyle(vs);
        networkView.redrawGraph(false, true);
        String osName = System.getProperty("os.name");
        boolean result = osName.matches("(?i:.*windows.*)");
        this.wind = result ? 1 : 0;
    }

    VisualStyle createVisualStyle() {
        NodeAppearanceCalculator nodeAppCalc = new NodeAppearanceCalculator();
        EdgeAppearanceCalculator edgeAppCalc = new EdgeAppearanceCalculator();
        GlobalAppearanceCalculator globalAppCalc = new GlobalAppearanceCalculator();
        PassThroughMapping npm = new PassThroughMapping(String.class, "NAME");
        BasicCalculator nlc = new BasicCalculator("KGML Node Label Calculator", (ObjectMapping)npm, VisualPropertyType.NODE_LABEL);
        nodeAppCalc.setCalculator((Calculator)nlc);
        PassThroughMapping npm2 = new PassThroughMapping(String.class, "ENTREZ_ID");
        BasicCalculator ntc = new BasicCalculator("KGML Node Tooltip Calculator", (ObjectMapping)npm2, VisualPropertyType.NODE_TOOLTIP);
        nodeAppCalc.setCalculator((Calculator)ntc);
        PassThroughMapping epm = new PassThroughMapping(String.class, "Weight");
        BasicCalculator elc = new BasicCalculator("KGML Edge Label Calculator", (ObjectMapping)epm, VisualPropertyType.EDGE_LABEL);
        edgeAppCalc.setCalculator((Calculator)elc);
        PassThroughMapping epm2 = new PassThroughMapping(String.class, "interaction");
        BasicCalculator etc = new BasicCalculator("KGML Edge Tooltip Calculator", (ObjectMapping)epm2, VisualPropertyType.EDGE_TOOLTIP);
        edgeAppCalc.setCalculator((Calculator)etc);
        EdgeAppearance edgeApp = new EdgeAppearance();
        edgeApp.set(VisualPropertyType.EDGE_LABEL_COLOR, (Object)Color.RED);
        edgeAppCalc.setDefaultAppearance(edgeApp);
        NodeAppearance nodeApp = new NodeAppearance();
        nodeApp.set(VisualPropertyType.NODE_FONT_SIZE, (Object)8);
        nodeAppCalc.setDefaultAppearance(nodeApp);
        DiscreteMapping disMapping = new DiscreteMapping(NodeShape.class, "NODE_TYPE");
        disMapping.setControllingAttributeName("NODE_TYPE");
        disMapping.putMapValue((Object)"map", (Object)NodeShape.ROUND_RECT);
        disMapping.putMapValue((Object)"gene", (Object)NodeShape.ELLIPSE);
        disMapping.putMapValue((Object)"group", (Object)NodeShape.OCTAGON);
        disMapping.putMapValue((Object)"compound", (Object)NodeShape.DIAMOND);
        disMapping.putMapValue((Object)"ortholog", (Object)NodeShape.DIAMOND);
        BasicCalculator shapeCalculator = new BasicCalculator("KGML Node Shape Calculator", (ObjectMapping)disMapping, VisualPropertyType.NODE_SHAPE);
        nodeAppCalc.setCalculator((Calculator)shapeCalculator);
        DiscreteMapping disMap = new DiscreteMapping(Number.class, "NODE_TYPE");
        disMap.putMapValue((Object)"map", (Object)50.0);
        disMap.putMapValue((Object)"gene", (Object)50.0);
        disMap.putMapValue((Object)"group", (Object)50.0);
        disMap.putMapValue((Object)"compound", (Object)50.0);
        disMap.putMapValue((Object)"ortholog", (Object)50.0);
        BasicCalculator sizeCalculator = new BasicCalculator("KGML Node Size Calculator", (ObjectMapping)disMap, VisualPropertyType.NODE_SIZE);
        nodeAppCalc.setCalculator((Calculator)sizeCalculator);
        DiscreteMapping arrowMapping = new DiscreteMapping(ArrowShape.class, "interaction");
        arrowMapping.setControllingAttributeName("interaction");
        arrowMapping.putMapValue((Object)"activation", (Object)ArrowShape.ARROW);
        arrowMapping.putMapValue((Object)"inhibition", (Object)ArrowShape.T);
        arrowMapping.putMapValue((Object)"dissociation", (Object)ArrowShape.NONE);
        BasicCalculator edgeArrowCalculator = new BasicCalculator("KGML Edge Arrow Shape Calculator", (ObjectMapping)arrowMapping, VisualPropertyType.EDGE_TGTARROW_SHAPE);
        edgeAppCalc.setCalculator((Calculator)edgeArrowCalculator);
        DiscreteMapping lineMapping = new DiscreteMapping(LineStyle.class, "interaction");
        lineMapping.setControllingAttributeName("interaction");
        lineMapping.putMapValue((Object)"activation", (Object)LineStyle.SOLID);
        lineMapping.putMapValue((Object)"inhibition", (Object)LineStyle.SOLID);
        lineMapping.putMapValue((Object)"dissociation", (Object)LineStyle.LONG_DASH);
        BasicCalculator lineCalculator = new BasicCalculator("KGML Line Style Calculator", (ObjectMapping)lineMapping, VisualPropertyType.EDGE_LINE_STYLE);
        edgeAppCalc.setCalculator((Calculator)lineCalculator);
        ContinuousMapping continMap = new ContinuousMapping(Color.class, "SCORE");
        continMap.setControllingAttributeName("SCORE");
        LinearNumberToColorInterpolator numToColor = new LinearNumberToColorInterpolator();
        continMap.setInterpolator((Interpolator)numToColor);
        Color lev0 = new Color(30, 130, 30);
        Color lev1 = new Color(30, 230, 30);
        Color lev2 = new Color(240, 240, 20);
        Color lev3 = new Color(240, 180, 20);
        Color lev4 = new Color(240, 90, 30);
        Color lev5 = new Color(250, 60, 20);
        Color lev6 = new Color(255, 20, 0);
        BoundaryRangeValues bv0 = new BoundaryRangeValues((Object)lev0, (Object)lev0, (Object)lev0);
        BoundaryRangeValues bv1 = new BoundaryRangeValues((Object)lev1, (Object)lev1, (Object)lev1);
        BoundaryRangeValues bv2 = new BoundaryRangeValues((Object)lev2, (Object)lev2, (Object)lev2);
        BoundaryRangeValues bv3 = new BoundaryRangeValues((Object)lev3, (Object)lev3, (Object)lev3);
        BoundaryRangeValues bv4 = new BoundaryRangeValues((Object)lev4, (Object)lev4, (Object)lev4);
        BoundaryRangeValues bv5 = new BoundaryRangeValues((Object)lev5, (Object)lev5, (Object)lev5);
        BoundaryRangeValues bv6 = new BoundaryRangeValues((Object)lev6, (Object)lev6, (Object)lev6);
        continMap.addPoint(0.0, bv0);
        continMap.addPoint(20.0, bv1);
        continMap.addPoint(40.0, bv2);
        continMap.addPoint(100.0, bv3);
        continMap.addPoint(200.0, bv4);
        continMap.addPoint(500.0, bv5);
        continMap.addPoint(1500.0, bv6);
        BasicCalculator nodeColorCalculator = new BasicCalculator("Node Color Calc", (ObjectMapping)continMap, VisualPropertyType.NODE_FILL_COLOR);
        nodeAppCalc.setCalculator((Calculator)nodeColorCalculator);
        VisualStyle visualStyle = new VisualStyle(vsName, nodeAppCalc, edgeAppCalc, globalAppCalc);
        return visualStyle;
    }

    class LoadFileAction
    extends CytoscapeAction {
        public void actionPerformed(ActionEvent e) {
            String pathway_id = "";
            while (pathway_id.length() <= 9) {
                pathway_id = (String)JOptionPane.showInputDialog(null, "Give a pathway name", "Pathway selection", 1, null, null, "path:hsa0");
                pathway_id = pathway_id.trim();
            }
            try {
                this.LoadPathway(pathway_id);
            }
            catch (RemoteException e1) {
                e1.printStackTrace();
            }
        }

        public void LoadPathway(String pathway_id) throws RemoteException {
            KEGGLocator locator = new KEGGLocator();
            KEGGPortType serv = null;
            try {
                String node_id1;
                serv = locator.getKEGGPort();
                PathwayElement[] elm = serv.get_elements_by_pathway(pathway_id);
                PathwayElementRelation[] rel = serv.get_element_relations_by_pathway(pathway_id);
                String pname = "KEGG_" + pathway_id;
                CyNetwork pathway = Cytoscape.createNetwork((String)pname);
                int i = 0;
                while (i < elm.length) {
                    String temp;
                    String id;
                    int ed;
                    int st;
                    node_id1 = String.valueOf(pathway_id.substring(pathway_id.length() - 4)) + "_" + Integer.toString(elm[i].getElement_id());
                    CyNode node1 = Cytoscape.getCyNode((String)node_id1, (boolean)true);
                    pathway.addNode((Node)node1);
                    System.out.println(String.valueOf(elm[i].getElement_id()) + " " + elm[i].getType());
                    String[] node_name = elm[i].getNames();
                    String kegg_id = "";
                    int j = 0;
                    while (j < node_name.length) {
                        kegg_id = String.valueOf(kegg_id) + " " + node_name[j];
                        ++j;
                    }
                    String n_type = elm[i].getType();
                    Cytoscape.getNodeAttributes().setAttribute(node_id1, "NODE_TYPE", n_type);
                    Cytoscape.getNodeAttributes().setAttribute(node_id1, "SCORE", Integer.valueOf(0));
                    if (n_type.equals("map")) {
                        String p_name = kegg_id;
                        String res = serv.bget(kegg_id);
                        if (res != "") {
                            st = res.indexOf("NAME") + 12;
                            ed = res.indexOf("Homo sapiens (human)") - 3;
                            p_name = st > -1 && ed > -1 ? res.substring(st, ed) : "not found";
                            System.out.println("map kegg_id " + p_name);
                        }
                        Cytoscape.getNodeAttributes().setAttribute(node_id1, "TARGET_PROCESS", "yes");
                        Cytoscape.getNodeAttributes().setAttribute(node_id1, "NAME", kegg_id.substring(6, kegg_id.length()));
                        Cytoscape.getNodeAttributes().setAttribute(node_id1, "ENTREZ_ID", p_name);
                    }
                    if (n_type.equals("gene")) {
                        id = serv.bget(node_name[0]);
                        String p_name = "";
                        if (id != "") {
                            st = id.indexOf("NAME") + 12;
                            ed = id.indexOf("DEFINITION");
                            p_name = st > -1 && ed > -1 ? ((temp = id.substring(st, ed)).indexOf(",") != -1 ? temp.substring(0, temp.indexOf(",")) : temp) : "not found";
                            System.out.println("gene_id " + p_name);
                        }
                        String temp2 = kegg_id.replaceAll("hsa:", "");
                        Cytoscape.getNodeAttributes().setAttribute(node_id1, "TARGET_PROCESS", "no");
                        Cytoscape.getNodeAttributes().setAttribute(node_id1, "NAME", p_name);
                        Cytoscape.getNodeAttributes().setAttribute(node_id1, "ENTREZ_ID", temp2.substring(1, temp2.length()));
                    }
                    if (n_type.equals("group")) {
                        Cytoscape.getNodeAttributes().setAttribute(node_id1, "TARGET_PROCESS", "no");
                        Cytoscape.getNodeAttributes().setAttribute(node_id1, "NAME", "Gene_Group");
                        kegg_id = "";
                        int[] comp = elm[i].getComponents();
                        int j2 = 0;
                        while (j2 < comp.length) {
                            kegg_id = String.valueOf(kegg_id) + " " + pathway_id.substring(pathway_id.length() - 4) + "_" + Integer.toString(comp[j2]);
                            ++j2;
                        }
                        System.out.println("group members " + kegg_id);
                        Cytoscape.getNodeAttributes().setAttribute(node_id1, "ENTREZ_ID", kegg_id.substring(1, kegg_id.length()));
                    }
                    if (n_type.equals("compound")) {
                        id = serv.bget(kegg_id);
                        String p_name = "";
                        if (id != "") {
                            st = id.indexOf("NAME") + 12;
                            ed = id.indexOf("REMARK");
                            p_name = st > -1 && ed > -1 ? ((temp = id.substring(st, ed)).indexOf(";") != -1 ? temp.substring(0, temp.indexOf(";")) : temp) : "not found";
                            System.out.println("compund_name" + p_name);
                        }
                        Cytoscape.getNodeAttributes().setAttribute(node_id1, "TARGET_PROCESS", "no");
                        Cytoscape.getNodeAttributes().setAttribute(node_id1, "NAME", p_name);
                        Cytoscape.getNodeAttributes().setAttribute(node_id1, "ENTREZ_ID", kegg_id);
                    }
                    if (n_type.equals("ortholog")) {
                        id = serv.bget(kegg_id);
                        String p_name = "";
                        if (id != "") {
                            st = id.indexOf("NAME") + 12;
                            ed = id.indexOf("DEFINITION");
                            p_name = st > -1 && ed > -1 ? id.substring(st, ed - 1) : "not found";
                            System.out.println("ortholog_name" + p_name);
                        }
                        Cytoscape.getNodeAttributes().setAttribute(node_id1, "TARGET_PROCESS", "no");
                        Cytoscape.getNodeAttributes().setAttribute(node_id1, "NAME", p_name);
                        Cytoscape.getNodeAttributes().setAttribute(node_id1, "ENTREZ_ID", kegg_id);
                    }
                    ++i;
                }
                i = 0;
                while (i < rel.length) {
                    String rtype;
                    node_id1 = String.valueOf(pathway_id.substring(pathway_id.length() - 4)) + "_" + Integer.toString(rel[i].getElement_id1());
                    String node_id2 = String.valueOf(pathway_id.substring(pathway_id.length() - 4)) + "_" + Integer.toString(rel[i].getElement_id2());
                    CyNode node1 = Cytoscape.getCyNode((String)node_id1, (boolean)true);
                    CyNode node2 = Cytoscape.getCyNode((String)node_id2, (boolean)true);
                    Subtype[] stype = rel[i].getSubtypes();
                    if (stype.length > 0 && (rtype = stype[0].getRelation()) != null) {
                        if (rtype.contains("inhibition") || rtype.contains("repression")) {
                            CyEdge edge = Cytoscape.getCyEdge((Node)node1, (Node)node2, (String)"interaction", (Object)"inhibition", (boolean)true);
                            pathway.addEdge((Edge)edge);
                            Cytoscape.getEdgeAttributes().setAttribute(edge.getIdentifier(), "Weight", Integer.valueOf(0));
                        } else if (rtype.contains("compound")) {
                            String node_id3 = String.valueOf(pathway_id.substring(pathway_id.length() - 4)) + "_" + Integer.toString(stype[0].getElement_id());
                            CyNode node3 = Cytoscape.getCyNode((String)node_id3, (boolean)true);
                            CyEdge edge = Cytoscape.getCyEdge((Node)node1, (Node)node3, (String)"interaction", (Object)"activation", (boolean)true);
                            CyEdge edge2 = Cytoscape.getCyEdge((Node)node3, (Node)node2, (String)"interaction", (Object)"activation", (boolean)true);
                            pathway.addEdge((Edge)edge);
                            pathway.addEdge((Edge)edge2);
                            Cytoscape.getEdgeAttributes().setAttribute(edge.getIdentifier(), "Weight", Integer.valueOf(0));
                            Cytoscape.getEdgeAttributes().setAttribute(edge2.getIdentifier(), "Weight", Integer.valueOf(0));
                        } else if (rtype.contains("bind") && rtype.contains("association")) {
                            CyEdge edge = Cytoscape.getCyEdge((Node)node2, (Node)node1, (String)"interaction", (Object)"activation", (boolean)true);
                            pathway.addEdge((Edge)edge);
                            Cytoscape.getEdgeAttributes().setAttribute(edge.getIdentifier(), "Weight", Integer.valueOf(0));
                        } else if (rtype.contains("dissociation")) {
                            CyEdge edge = Cytoscape.getCyEdge((Node)node1, (Node)node2, (String)"interaction", (Object)"dissociation", (boolean)true);
                            pathway.addEdge((Edge)edge);
                            Cytoscape.getEdgeAttributes().setAttribute(edge.getIdentifier(), "Weight", Integer.valueOf(0));
                        } else {
                            CyEdge edge = Cytoscape.getCyEdge((Node)node1, (Node)node2, (String)"interaction", (Object)"activation", (boolean)true);
                            pathway.addEdge((Edge)edge);
                            Cytoscape.getEdgeAttributes().setAttribute(edge.getIdentifier(), "Weight", Integer.valueOf(0));
                        }
                    }
                    ++i;
                }
                CyAttributes node_attr = Cytoscape.getNodeAttributes();
                Iterator it = Cytoscape.getCurrentNetwork().nodesIterator();
                while (it.hasNext()) {
                    String tid;
                    GraphObject cnode1 = (GraphObject)it.next();
                    String id1 = cnode1.getIdentifier();
                    String ntype = node_attr.getStringAttribute(id1, "NODE_TYPE");
                    if (!ntype.equals("group") || (tid = node_attr.getStringAttribute(id1, "ENTREZ_ID")).contains("hsa")) continue;
                    Pattern p = Pattern.compile("\\s+");
                    String[] node_id = p.split(tid);
                    String res = "";
                    int ind = 0;
                    while (ind < node_id.length) {
                        String k = node_id[ind].trim();
                        String r1 = node_attr.getStringAttribute(k, "ENTREZ_ID");
                        if (r1 != null) {
                            res = String.valueOf(res) + " " + r1;
                        }
                        ++ind;
                    }
                    String fres = res.substring(1);
                    node_attr.setAttribute(id1, "ENTREZ_ID", fres.trim());
                    System.out.println("group " + id1 + "- kegg id:" + fres);
                }
                CyNetworkView networkView = Cytoscape.getCurrentNetworkView();
                VisualMappingManager manager = Cytoscape.getVisualMappingManager();
                CalculatorCatalog catalog = manager.getCalculatorCatalog();
                VisualStyle vs = catalog.getVisualStyle(PathwayScoringPlugin.vsName);
                if (vs == null) {
                    vs = PathwayScoringPlugin.this.createVisualStyle();
                    catalog.addVisualStyle(vs);
                }
                networkView.setVisualStyle(vs.getName());
                manager.setVisualStyle(vs);
                CyLayouts.getLayout((String)"hierarchical").doLayout();
                networkView.redrawGraph(false, true);
            }
            catch (ServiceException e) {
                JOptionPane.showMessageDialog(null, "KEGG API cannot be reachable, please check internet connection!", "information", 1);
            }
        }
    }

    class RunAlgorithmAction
    extends CytoscapeAction {
        private static final long serialVersionUID = 1L;

        public void actionPerformed(ActionEvent e) {
            String chip_file = null;
            String array_file = null;
            Object path_name = null;
            CyNetwork net = Cytoscape.getCurrentNetwork();
            if (net == Cytoscape.getNullNetwork()) {
                JOptionPane.showMessageDialog(null, "Firstly, load a network ...", "information", 1);
            } else {
                Object[] ftype = new Object[]{"Load only ChIP-seq file", "Load only Microarray file", "Load both ChIP-seq and Microarray files"};
                String res = (String)JOptionPane.showInputDialog(null, "Select data file type(s):\n", "Input file upload", -1, null, ftype, "Load both ChIP-seq and Microarray files");
                if (res != null && res.length() > 0) {
                    List cyEdgesList;
                    List cyNodesList;
                    JFileChooser chooser;
                    int fileType = 0;
                    if (res.compareTo("Load only ChIP-seq file") == 0) {
                        chooser = new JFileChooser();
                        chooser.setDialogTitle("Select a chip-seq score file...");
                        if (chooser.showOpenDialog(null) == 0) {
                            chip_file = PathwayScoringPlugin.this.wind == 1 ? String.valueOf(chooser.getSelectedFile().getParent()) + "\\" + chooser.getSelectedFile().getName() : String.valueOf(chooser.getSelectedFile().getParent()) + "//" + chooser.getSelectedFile().getName();
                            fileType = 1;
                        }
                    } else if (res.compareTo("Load only Microarray file") == 0) {
                        JFileChooser chooser2 = new JFileChooser();
                        chooser2.setDialogTitle("Select a microarray score file...");
                        if (chooser2.showOpenDialog(null) == 0) {
                            array_file = PathwayScoringPlugin.this.wind == 1 ? String.valueOf(chooser2.getSelectedFile().getParent()) + "\\" + chooser2.getSelectedFile().getName() : String.valueOf(chooser2.getSelectedFile().getParent()) + "//" + chooser2.getSelectedFile().getName();
                            fileType = 2;
                        }
                    } else if (res.compareTo("Load both ChIP-seq and Microarray files") == 0) {
                        chooser = new JFileChooser();
                        chooser.setDialogTitle("Select a chip-seq score file...");
                        if (chooser.showOpenDialog(null) == 0) {
                            chip_file = PathwayScoringPlugin.this.wind == 1 ? String.valueOf(chooser.getSelectedFile().getParent()) + "\\" + chooser.getSelectedFile().getName() : String.valueOf(chooser.getSelectedFile().getParent()) + "//" + chooser.getSelectedFile().getName();
                            fileType = 1;
                            JFileChooser chooser2 = new JFileChooser();
                            chooser2.setCurrentDirectory(chooser.getSelectedFile().getParentFile());
                            chooser2.setDialogTitle("Select a microarray score file...");
                            if (chooser2.showOpenDialog(null) == 0) {
                                array_file = PathwayScoringPlugin.this.wind == 1 ? String.valueOf(chooser2.getSelectedFile().getParent()) + "\\" + chooser2.getSelectedFile().getName() : String.valueOf(chooser2.getSelectedFile().getParent()) + "//" + chooser2.getSelectedFile().getName();
                                fileType = 3;
                            }
                        }
                    }
                    ScoreFlowAlgorithm sflow = new ScoreFlowAlgorithm(net, chip_file, array_file, fileType);
                    Hashtable<String, Double> node_score = sflow.RunAlgorithm();
                    CyAttributes node_attr = Cytoscape.getNodeAttributes();
                    List nodeList = cyNodesList = Cytoscape.getCyNodesList();
                    for (CyNode node : nodeList) {
                        String id = node.getIdentifier().trim();
                        String dim = id.concat(" " + id);
                        if (node_score.containsKey(dim)) {
                            node_attr.setAttribute(id, "SCORE", Integer.valueOf(node_score.get(dim).intValue()));
                            continue;
                        }
                        node_attr.setAttribute(id, "SCORE", Integer.valueOf(0));
                    }
                    CyAttributes edge_attr = Cytoscape.getEdgeAttributes();
                    List edgeList = cyEdgesList = Cytoscape.getCyEdgesList();
                    for (CyEdge edge : edgeList) {
                        String t;
                        String id = edge.getIdentifier().trim();
                        String s = edge.getSource().toString().trim();
                        String dim = s.concat(" " + (t = edge.getTarget().toString().trim()));
                        if (node_score.containsKey(dim)) {
                            edge_attr.setAttribute(id, "Weight", Integer.valueOf(node_score.get(dim).intValue()));
                            continue;
                        }
                        edge_attr.setAttribute(id, "Weight", Integer.valueOf(0));
                    }
                    JOptionPane.showMessageDialog(null, "Score computation is finished!", "Info", 1);
                    CyNetworkView networkView = Cytoscape.getCurrentNetworkView();
                    networkView.redrawGraph(false, true);
                }
            }
        }
    }

    class SaveFileAction
    extends CytoscapeAction {
        private static final long serialVersionUID = 1L;

        public void actionPerformed(ActionEvent e) {
            JFileChooser chooser = new JFileChooser();
            chooser.setCurrentDirectory(new File("."));
            chooser.setDialogTitle("Choose a directory to save the node scores ...");
            chooser.setFileSelectionMode(1);
            chooser.setAcceptAllFileFilterUsed(false);
            if (chooser.showOpenDialog(null) == 0) {
                String direct = chooser.getCurrentDirectory().getAbsolutePath();
                String title = Cytoscape.getCurrentNetwork().getTitle().substring(10);
                String filename = null;
                filename = PathwayScoringPlugin.this.wind == 1 ? String.valueOf(direct) + "\\" + title + "_node_scores.txt" : String.valueOf(direct) + "//" + title + "_node_scores.txt";
                BufferedWriter bf = null;
                try {
                    try {
                        List cyNodesList;
                        bf = new BufferedWriter(new FileWriter(filename));
                        CyAttributes node_attr = Cytoscape.getNodeAttributes();
                        List nodeList = cyNodesList = Cytoscape.getCyNodesList();
                        bf.write("NODE_ID \t NODE_TYPE \t NAME \t TARGET_PROCESS \t SCORE");
                        bf.newLine();
                        for (CyNode node : nodeList) {
                            bf.write(node.getIdentifier());
                            bf.write("\t");
                            bf.write(node_attr.getStringAttribute(node.getIdentifier(), "NODE_TYPE"));
                            bf.write("\t");
                            bf.write(node_attr.getStringAttribute(node.getIdentifier(), "NAME"));
                            bf.write("\t");
                            bf.write(node_attr.getStringAttribute(node.getIdentifier(), "TARGET_PROCESS"));
                            bf.write("\t");
                            bf.write(node_attr.getAttribute(node.getIdentifier(), "SCORE").toString());
                            bf.newLine();
                        }
                        String res = "The node scores are saved to the file in: " + filename;
                        JOptionPane.showMessageDialog(null, res, "Info", 1);
                    }
                    catch (FileNotFoundException ex) {
                        ex.printStackTrace();
                        try {
                            if (bf != null) {
                                bf.flush();
                                bf.close();
                            }
                        }
                        catch (IOException ex2) {
                            ex2.printStackTrace();
                        }
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        try {
                            if (bf != null) {
                                bf.flush();
                                bf.close();
                            }
                        }
                        catch (IOException ex3) {
                            ex3.printStackTrace();
                        }
                    }
                }
                finally {
                    try {
                        if (bf != null) {
                            bf.flush();
                            bf.close();
                        }
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
    }
}

