/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.pathwayscoringplugin;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import giny.model.Edge;
import giny.model.GraphObject;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;

public class ScoreFlowAlgorithm {
    public String chip_file;
    public String array_file;
    public int level;
    public int fileCount;
    public CyNetwork cnet;

    public ScoreFlowAlgorithm(CyNetwork net, String chip_file, String array_file, int fileCount) {
        this.cnet = net;
        this.chip_file = chip_file;
        this.array_file = array_file;
        this.fileCount = fileCount;
    }

    public Hashtable<String, Double> RunAlgorithm() {
        Hashtable<String, String[]> graph = new Hashtable<String, String[]>();
        Hashtable<String, Double> output_score = new Hashtable<String, Double>();
        Hashtable<String, Integer> adjacency_matrix = new Hashtable<String, Integer>();
        Hashtable<String, String[]> chipseq = new Hashtable<String, String[]>();
        Hashtable<String, String[]> marray = new Hashtable<String, String[]>();
        Hashtable<String, Double> score = new Hashtable<String, Double>();
        Hashtable<Integer, Vector<String>> bfs_level = new Hashtable<Integer, Vector<String>>();
        Vector<String> graph_node = new Vector<String>();
        this.ReadNodeInfo(graph, graph_node);
        this.ReadEdgeInfo(graph_node, adjacency_matrix);
        if (this.fileCount == 1) {
            this.ReadChipFile(chipseq, this.chip_file);
            this.ConstructChipScore(graph, score, chipseq);
        } else if (this.fileCount == 2) {
            this.ReadArrayFile(marray, this.array_file);
            this.ConstructArrayScore(graph, score, marray);
        } else if (this.fileCount == 3) {
            this.ReadChipFile(chipseq, this.chip_file);
            this.ReadArrayFile(marray, this.array_file);
            this.ConstructCombinedScores(graph, score, chipseq, marray);
        }
        this.level = 1;
        this.level = this.PerformBFS(graph_node, adjacency_matrix, bfs_level);
        this.InitializeMatrix(graph_node, adjacency_matrix, score, output_score);
        this.ScoreComputation(this.level, bfs_level, graph, graph_node, score, output_score, adjacency_matrix);
        this.CycleComputation(this.level, bfs_level, graph, graph_node, score, output_score, adjacency_matrix);
        this.ComputeGoalNodeScore(this.level, bfs_level, graph, graph_node, score, output_score, adjacency_matrix);
        this.PrintGoalNodeScore(graph, output_score);
        return output_score;
    }

    public void PrintGoalNodeScore(Hashtable<String, String[]> graph, Hashtable<String, Double> output_score) {
        System.out.println("----- GOAL NODE SCORES -----");
        Enumeration<String> keys = graph.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement().trim();
            String dim = key.concat(" " + key);
            String[] gr = graph.get(key);
            if (!gr[0].equals("map")) continue;
            double temp = output_score.get(dim);
            System.out.println("Map id: " + key + " name: " + gr[3] + " --- score: " + temp);
        }
    }

    public void ComputeGoalNodeScore(int level, Hashtable<Integer, Vector<String>> bfs_level, Hashtable<String, String[]> graph, Vector<String> graph_node, Hashtable<String, Double> score, Hashtable<String, Double> output_score, Hashtable<String, Integer> adjacency_matrix) {
        Vector<String> member = new Vector();
        int i = 1;
        while (i < level) {
            member.clear();
            member = bfs_level.get(i);
            this.SortRelations(member, adjacency_matrix);
            int j = 0;
            while (j < member.size()) {
                String id_j = member.get(j).trim();
                String dim1 = id_j.concat(" " + id_j);
                String[] gr = graph.get(id_j);
                if (gr[0].equals("map")) {
                    int k = 0;
                    while (k < graph_node.size()) {
                        String id_k = graph_node.get(k).trim();
                        String dim2 = id_k.concat(" " + id_j);
                        String[] g = graph.get(id_k);
                        if (adjacency_matrix.containsKey(dim2) && g[0].equals("map")) {
                            String dim3 = id_k.concat(" " + id_k);
                            double temp = Double.valueOf(output_score.get(dim1)) + Double.valueOf(output_score.get(dim3));
                            output_score.put(dim1, temp);
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public void CycleComputation(int level, Hashtable<Integer, Vector<String>> bfs_level, Hashtable<String, String[]> graph, Vector<String> graph_node, Hashtable<String, Double> score, Hashtable<String, Double> output_score, Hashtable<String, Integer> adjacency_matrix) {
        int no_change_node = 0;
        int iteration = 0;
        Vector lnode = new Vector();
        while (no_change_node != graph_node.size()) {
            System.out.println("**************** ITERATION -------------> " + ++iteration);
            no_change_node = 0;
            int i = 1;
            while (i < level) {
                lnode.clear();
                lnode = (Vector)bfs_level.get(i).clone();
                this.SortRelations(lnode, adjacency_matrix);
                int j = 0;
                while (j < lnode.size()) {
                    double diff;
                    String id_j = ((String)lnode.get(j)).trim();
                    String dim1 = id_j.concat(" " + id_j);
                    double new_diagonal = score.get(id_j);
                    int s = 0;
                    while (s < graph_node.size()) {
                        String id_s = graph_node.get(s).trim();
                        if (!id_j.equals(id_s)) {
                            String dim2 = id_s.concat(" " + id_j);
                            new_diagonal += Double.valueOf(output_score.get(dim2)).doubleValue();
                        }
                        ++s;
                    }
                    if (new_diagonal < 0.0) {
                        new_diagonal = 0.0;
                    }
                    if (Math.abs(diff = new_diagonal - Double.valueOf(output_score.get(dim1))) < 1.0E-6) {
                        ++no_change_node;
                    } else {
                        output_score.put(dim1, new_diagonal);
                        String[] gr = graph.get(id_j);
                        if (!gr[0].equals("map")) {
                            String dim2;
                            String id_k;
                            double totalscore = 0.0;
                            int k = 0;
                            while (k < graph_node.size()) {
                                id_k = graph_node.get(k).trim();
                                dim2 = id_j.concat(" " + id_k);
                                if (adjacency_matrix.containsKey(dim2)) {
                                    totalscore += Double.valueOf(score.get(id_k)).doubleValue();
                                }
                                ++k;
                            }
                            k = 0;
                            while (k < graph_node.size()) {
                                id_k = graph_node.get(k).trim();
                                dim2 = id_j.concat(" " + id_k);
                                if (adjacency_matrix.containsKey(dim2)) {
                                    double temp;
                                    String[] g = graph.get(id_k);
                                    if (Double.valueOf(output_score.get(dim1)) == 0.0) {
                                        output_score.put(dim2, 0.0);
                                    } else if (g[0].equals("map")) {
                                        temp = Double.valueOf(output_score.get(dim1)) * (double)Integer.valueOf(adjacency_matrix.get(dim2)).intValue();
                                        output_score.put(dim2, temp);
                                        System.out.println("node " + id_j + " => Map " + id_k + " : " + temp);
                                    } else {
                                        temp = totalscore == 0.0 ? 0.0 : (double)Integer.valueOf(adjacency_matrix.get(dim2)).intValue() * (Double.valueOf(output_score.get(dim1)) * Double.valueOf(score.get(id_k)) / totalscore);
                                        output_score.put(dim2, temp);
                                    }
                                }
                                ++k;
                            }
                        }
                    }
                    ++j;
                }
                ++i;
            }
            System.out.println("Total nodes:" + graph_node.size() + " stable nodes: " + no_change_node);
        }
    }

    /*
     * Exception decompiling
     */
    public void SortRelations(Vector<String> a, Hashtable<String, Integer> adjacency_matrix) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: CONTINUE without a while class org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.GotoStatement.getTargetStartBlock(GotoStatement.java:102)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.IfStatement.getStructuredStatement(IfStatement.java:110)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.getStructuredStatementPlaceHolder(Op03SimpleStatement.java:550)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:727)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void ScoreComputation(int level, Hashtable<Integer, Vector<String>> bfs_level, Hashtable<String, String[]> graph, Vector<String> graph_node, Hashtable<String, Double> score, Hashtable<String, Double> output_score, Hashtable<String, Integer> adjacency_matrix) {
        Vector member = new Vector();
        int i = 1;
        while (i < level) {
            member.clear();
            member = (Vector)bfs_level.get(i).clone();
            this.SortRelations(member, adjacency_matrix);
            int j = 0;
            while (j < member.size()) {
                String[] gr;
                String id_j = ((String)member.get(j)).trim();
                String dim1 = id_j.concat(" " + id_j);
                int s = 0;
                while (s < graph_node.size()) {
                    String id_s = graph_node.get(s).trim();
                    if (!id_j.equals(id_s)) {
                        String dim2 = id_s.concat(" " + id_j);
                        double temp = Double.valueOf(output_score.get(dim1)) + Double.valueOf(output_score.get(dim2));
                        output_score.put(dim1, temp);
                    }
                    ++s;
                }
                if (Double.valueOf(output_score.get(dim1)) < 0.0) {
                    output_score.put(dim1, 0.0);
                }
                if (!(gr = graph.get(id_j))[0].equals("map")) {
                    String dim2;
                    String id_k;
                    double totalscore = 0.0;
                    int k = 0;
                    while (k < graph_node.size()) {
                        id_k = graph_node.get(k).trim();
                        dim2 = id_j.concat(" " + id_k);
                        if (adjacency_matrix.containsKey(dim2)) {
                            totalscore += Double.valueOf(score.get(id_k)).doubleValue();
                        }
                        ++k;
                    }
                    k = 0;
                    while (k < graph_node.size()) {
                        id_k = graph_node.get(k).trim();
                        dim2 = id_j.concat(" " + id_k);
                        if (adjacency_matrix.containsKey(dim2)) {
                            if (Double.valueOf(output_score.get(dim1)) == 0.0) {
                                output_score.put(dim2, 0.0);
                            } else {
                                double temp;
                                String[] g = graph.get(id_k);
                                if (g[0].equals("map")) {
                                    temp = Double.valueOf(output_score.get(dim1)) * (double)Integer.valueOf(adjacency_matrix.get(dim2)).intValue();
                                    output_score.put(dim2, temp);
                                } else {
                                    temp = totalscore == 0.0 ? 0.0 : (double)Integer.valueOf(adjacency_matrix.get(dim2)).intValue() * (Double.valueOf(output_score.get(dim1)) * Double.valueOf(score.get(id_k)) / totalscore);
                                    output_score.put(dim2, temp);
                                }
                            }
                        }
                        ++k;
                    }
                } else {
                    int k = 0;
                    while (k < graph_node.size()) {
                        String id_k = graph_node.get(k).trim();
                        String dim2 = id_j.concat(" " + id_k);
                        if (adjacency_matrix.containsKey(dim2)) {
                            double temp = Double.valueOf(output_score.get(dim1)) * (double)Integer.valueOf(adjacency_matrix.get(dim2)).intValue();
                            output_score.put(dim2, temp);
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public void ReadNodeInfo(Hashtable<String, String[]> graph, Vector<String> graph_node) {
        CyAttributes node_attr = Cytoscape.getNodeAttributes();
        Iterator it = this.cnet.nodesIterator();
        while (it.hasNext()) {
            GraphObject cnode1 = (GraphObject)it.next();
            String id = cnode1.getIdentifier();
            String ntype = node_attr.getStringAttribute(id, "NODE_TYPE");
            String name = node_attr.getStringAttribute(id, "NAME");
            String target = node_attr.getStringAttribute(id, "TARGET_PROCESS");
            String hsaid = node_attr.getStringAttribute(id, "ENTREZ_ID");
            String[] ncbi_id = null;
            if (ntype.equals("gene") || ntype.equals("group")) {
                ncbi_id = hsaid.split(" ");
            } else {
                Pattern p = Pattern.compile("\\s+");
                ncbi_id = p.split(hsaid);
            }
            String[] vec = new String[]{ntype, name, target};
            String[] both = ScoreFlowAlgorithm.concat(vec, ncbi_id);
            graph.put(id, both);
            if (graph_node.contains(id)) continue;
            graph_node.add(id);
        }
    }

    public static <T> T[] concat(T[] first, T[] second) {
        T[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    public void ReadEdgeInfo(Vector<String> graph_node, Hashtable<String, Integer> adjacency_matrix) {
        CyAttributes attributes = Cytoscape.getEdgeAttributes();
        Iterator it = this.cnet.edgesIterator();
        while (it.hasNext()) {
            Edge cedge = (Edge)it.next();
            String source1 = cedge.getSource().getIdentifier().trim();
            String target1 = cedge.getTarget().getIdentifier().trim();
            String ed_type = (String)attributes.getAttribute(cedge.getIdentifier(), "interaction");
            int rel = 1;
            if (ed_type.equals("activation")) {
                rel = 1;
            } else if (ed_type.equals("inhibition")) {
                rel = -1;
            }
            if (!graph_node.contains(source1)) {
                graph_node.add(source1);
            }
            if (!graph_node.contains(target1)) {
                graph_node.add(target1);
            }
            String ky = source1.concat(" " + target1);
            adjacency_matrix.put(ky, rel);
        }
    }

    public void ReadChipFile(Hashtable<String, String[]> chipseq, String chip_file) {
        BufferedReader br = null;
        try {
            try {
                String record;
                br = new BufferedReader(new FileReader(chip_file));
                while ((record = br.readLine()) != null) {
                    String[] line = record.split("\t");
                    String id = line[0].trim();
                    String[] res = new String[]{line[1], line[2]};
                    chipseq.put(id, res);
                }
                JOptionPane.showMessageDialog(null, "ChIP-seq file was successfully uploaded ...", "information", 1);
            }
            catch (FileNotFoundException ex) {
                ex.printStackTrace();
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException ex3) {
                    ex3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void ReadArrayFile(Hashtable<String, String[]> marray, String array_file) {
        BufferedReader br = null;
        try {
            try {
                String record;
                br = new BufferedReader(new FileReader(array_file));
                while ((record = br.readLine()) != null) {
                    String[] line = record.split("\t");
                    String id = line[0].trim();
                    if (id.contains("NA")) continue;
                    String[] res = new String[]{line[1], line[2]};
                    marray.put(id, res);
                }
                JOptionPane.showMessageDialog(null, "Microarray file was successfully uploaded ...", "information", 1);
            }
            catch (FileNotFoundException ex) {
                ex.printStackTrace();
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException ex3) {
                    ex3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void ConstructChipScore(Hashtable<String, String[]> graph, Hashtable<String, Double> score, Hashtable<String, String[]> chipseq) {
        Vector<String> ncbi = new Vector<String>();
        Enumeration<String> keys = graph.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            String[] val = graph.get(key);
            score.put(key, 0.0);
            System.out.println("Node: " + key);
            if (val[0].equals("gene") || val[0].equals("group")) {
                this.copyVector(ncbi, 3, val, val.length);
                int count = 0;
                double rank_chip = 0.0;
                int index = 0;
                while (index < ncbi.size()) {
                    String k = ncbi.get(index).trim();
                    if (chipseq.containsKey(k)) {
                        String[] res = chipseq.get(k);
                        double rc = Double.parseDouble(res[1]);
                        rank_chip += (1.0 - rc) * 100.0;
                        ++count;
                    }
                    ++index;
                }
                double total_gene = count;
                if (total_gene > 0.0) {
                    rank_chip /= total_gene;
                }
                score.put(key, rank_chip);
            }
            System.out.println(" self score: " + score.get(key));
        }
        this.NormalizedInputScores(graph, score);
    }

    public void ConstructArrayScore(Hashtable<String, String[]> graph, Hashtable<String, Double> score, Hashtable<String, String[]> marray) {
        Vector<String> ncbi = new Vector<String>();
        Enumeration<String> keys = graph.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            String[] val = graph.get(key);
            score.put(key, 0.0);
            System.out.println("Node: " + key);
            if (val[0].equals("gene") || val[0].equals("group")) {
                this.copyVector(ncbi, 3, val, val.length);
                int count = 0;
                double rank_array = 0.0;
                int index = 0;
                while (index < ncbi.size()) {
                    String k = ncbi.get(index).trim();
                    if (marray.containsKey(k)) {
                        String[] res = marray.get(k);
                        rank_array += Double.parseDouble(res[1]);
                        ++count;
                    }
                    ++index;
                }
                double total_gene = count;
                if (total_gene > 0.0) {
                    rank_array /= total_gene;
                }
                score.put(key, rank_array);
            }
            System.out.println(" self score: " + score.get(key));
        }
        this.NormalizedInputScores(graph, score);
    }

    public void ConstructCombinedScores(Hashtable<String, String[]> graph, Hashtable<String, Double> score, Hashtable<String, String[]> chipseq, Hashtable<String, String[]> marray) {
        Vector<String> ncbi = new Vector<String>();
        Enumeration<String> keys = graph.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            String[] val = graph.get(key);
            score.put(key, 0.0);
            if (val[0].equals("gene") || val[0].equals("group")) {
                this.copyVector(ncbi, 3, val, val.length);
                int count = 0;
                int count2 = 0;
                double rank_array = 0.0;
                double rank_chip = 0.0;
                int index = 0;
                while (index < ncbi.size()) {
                    String[] res;
                    String k = ncbi.get(index).trim();
                    if (marray.containsKey(k)) {
                        res = marray.get(k);
                        rank_array += Double.parseDouble(res[1]);
                        ++count;
                    }
                    if (chipseq.containsKey(k)) {
                        res = chipseq.get(k);
                        double rc = Double.parseDouble(res[1]);
                        rank_chip += (1.0 - rc) * 100.0;
                        ++count2;
                    }
                    ++index;
                }
                double total_gene = count;
                if (total_gene > 0.0) {
                    rank_array /= total_gene;
                }
                if ((total_gene = (double)count2) > 0.0) {
                    rank_chip /= total_gene;
                }
                double temp = 0.0;
                temp = rank_array == 0.0 && rank_chip == 0.0 ? 0.0 : (rank_array == 0.0 ? rank_chip : (rank_chip == 0.0 ? rank_array : rank_chip * rank_array));
                score.put(key, temp);
            }
            System.out.println(" self score: " + score.get(key));
        }
        this.NormalizedInputScores(graph, score);
    }

    public void NormalizedInputScores(Hashtable<String, String[]> graph, Hashtable<String, Double> score) {
        String[] val2;
        Enumeration<String> keys2;
        int same_gene;
        String[] val;
        String key;
        Vector<String> ncbi = new Vector<String>();
        Enumeration<String> keys = graph.keys();
        while (keys.hasMoreElements()) {
            key = keys.nextElement();
            val = graph.get(key);
            if (!val[0].equals("gene")) continue;
            this.copyVector(ncbi, 3, val, val.length);
            same_gene = 0;
            keys2 = graph.keys();
            while (keys2.hasMoreElements()) {
                String k = keys2.nextElement();
                val2 = graph.get(k);
                if (!val2[0].equals("gene") || k.equals(key)) continue;
                Vector<String> ncbi2 = new Vector<String>();
                this.copyVector(ncbi2, 3, val2, val2.length);
                if (!this.checkEquality(ncbi, ncbi2)) continue;
                ++same_gene;
                System.out.println("same gene for => " + key + " - " + k);
            }
            if (same_gene <= 0) continue;
            System.out.println("same gene for => " + key + " prev:" + score.get(key));
            double ratio = same_gene + 1;
            double temp = Double.valueOf(score.get(key)) / ratio;
            score.put(key, temp);
        }
        keys = graph.keys();
        while (keys.hasMoreElements()) {
            key = keys.nextElement();
            val = graph.get(key);
            if (!val[0].equals("group")) continue;
            this.copyVector(ncbi, 3, val, val.length);
            same_gene = 0;
            keys2 = graph.keys();
            while (keys2.hasMoreElements()) {
                String k = keys2.nextElement();
                val2 = graph.get(k);
                if (!val2[0].equals("group") || k.equals(key)) continue;
                Vector<String> ncbi2 = new Vector<String>();
                this.copyVector(ncbi2, 3, val2, val2.length);
                if (!this.checkEquality(ncbi, ncbi2)) continue;
                ++same_gene;
            }
            if (same_gene <= 0) continue;
            double ratio = same_gene + 1;
            double temp = Double.valueOf(score.get(key)) / ratio;
            score.put(key, temp);
        }
    }

    public int PerformBFS(Vector<String> graph_node, Hashtable<String, Integer> adjacency_matrix, Hashtable<Integer, Vector<String>> bfs_level) {
        Vector node = (Vector)graph_node.clone();
        Vector parent_node = (Vector)node.clone();
        int i = 0;
        while (i < node.size()) {
            String id = ((String)node.get(i)).trim();
            int j = 0;
            while (j < node.size()) {
                String id2 = ((String)node.get(j)).trim();
                String dim = id.concat(" " + id2);
                if (adjacency_matrix.containsKey(dim)) {
                    parent_node.remove(id2);
                }
                ++j;
            }
            ++i;
        }
        bfs_level.put(this.level, (Vector)parent_node.clone());
        Vector<String> temp_level = new Vector<String>();
        boolean cont = true;
        while (cont) {
            String id;
            Vector other_node = (Vector)node.clone();
            int i2 = 0;
            while (i2 < parent_node.size()) {
                id = ((String)parent_node.get(i2)).trim();
                other_node.remove(id);
                ++i2;
            }
            temp_level.clear();
            i2 = 0;
            while (i2 < parent_node.size()) {
                id = ((String)parent_node.get(i2)).trim();
                int j = 0;
                while (j < other_node.size()) {
                    String id2 = ((String)other_node.get(j)).trim();
                    String dim = id.concat(" " + id2);
                    if (adjacency_matrix.containsKey(dim) && !temp_level.contains(id2)) {
                        temp_level.add(id2);
                    }
                    ++j;
                }
                ++i2;
            }
            ++this.level;
            bfs_level.put(this.level, (Vector)temp_level.clone());
            parent_node.clear();
            parent_node = (Vector)temp_level.clone();
            i2 = 0;
            while (i2 < parent_node.size()) {
                id = ((String)parent_node.get(i2)).trim();
                node.remove(id);
                ++i2;
            }
            if (!parent_node.isEmpty()) continue;
            cont = false;
        }
        return this.level;
    }

    public void InitializeMatrix(Vector<String> graph_node, Hashtable<String, Integer> adjacency_matrix, Hashtable<String, Double> score, Hashtable<String, Double> output_score) {
        int i = 0;
        while (i < graph_node.size()) {
            String id = graph_node.get(i).trim();
            int j = 0;
            while (j < graph_node.size()) {
                String id2 = graph_node.get(j).trim();
                String dim = id.concat(" " + id2);
                if (id.equals(id2)) {
                    output_score.put(dim, score.get(id));
                } else if (adjacency_matrix.containsKey(dim)) {
                    output_score.put(dim, score.get(id));
                } else {
                    output_score.put(dim, 0.0);
                }
                ++j;
            }
            ++i;
        }
    }

    public void copyVector(Vector<String> vect, int pos, String[] arr, int len) {
        vect.clear();
        int j = pos;
        while (j < len) {
            vect.add(arr[j]);
            ++j;
        }
    }

    public boolean checkEquality(Vector<String> vect1, Vector<String> vect2) {
        Enumeration<String> vEnum = vect1.elements();
        while (vEnum.hasMoreElements()) {
            if (vect2.contains(vEnum.nextElement())) continue;
            return false;
        }
        return true;
    }
}

