load DrugCombExample.mat;
% UniProt_Term, UniProt_GO: GO annotation information (i.e. UniProt_GO) for
%   each protein (i.e. UniProt_Term) was retrieved from database UniProt.

% ProtProtInter should be protein-protein interaction data.
% Since the calculation will take several minutes, ProtInterStruct has
%   already been given in DrugCombExample.mat.
ProtInterStruct = GetIntMatShortPath(GetInteractMatrix(ProtProtInter));

% GeneOntology: The hierarchical structures of Gene Ontology (GO) was
%   retrieved from www.geneontology.org.
GOAncestors = GOTermAncestors(GeneOntology);

% Target_DrugComb: UniProt ID of the targets of combination drugs.
% Target_RandComb: Randomly generated protein pairs.
[DrugComb_TarI,DrugComb_TarILoc] = GetConnectInteract(Target_DrugComb);
[RandComb_TarI,RandComb_TarILoc] = GetConnectInteract(Target_RandComb);

% Since the calculation will take several minutes, DrugComb_Neib and
%   RandComb_Neib have already been given in DrugCombExample.mat.
DrugComb_Neib = GetInteractNeighbor(DrugComb_TarI,ProtInterStruct, ...
    UniProt_Term,UniProt_GO,GOAncestors);
RandComb_Neib = GetInteractNeighbor(RandComb_TarI,ProtInterStruct, ...
    UniProt_Term,UniProt_GO,GOAncestors);

[DrugComb_Attr,RandComb_Attr] = GetConnectAttribute( ...
    DrugComb_TarILoc,DrugComb_Neib,RandComb_TarILoc,RandComb_Neib);

% Construction of SVM classfier and prediction.
pPositNo = size(DrugComb_Attr,1);
pNegatNo = size(RandComb_Attr,1);
pTotalNo = pPositNo+pNegatNo;
pYTrain = zeros(pTotalNo,1);
pYTrain(1:pPositNo) = 1;
pXTrain = [DrugComb_Attr(:,SVMOptimModel{1}); ...
    RandComb_Attr(:,SVMOptimModel{1})];
pSVMStruct = JzSVMTrain(pXTrain,pYTrain, ...
    'OptimMethod','SMO','Autoscale',false);
Predict1 = JzSVMPredict(pSVMStruct,DrugComb_Attr(:,SVMOptimModel{1}));
Predict2 = JzSVMPredict(pSVMStruct,RandComb_Attr(:,SVMOptimModel{1}));
