function [oCellCat,oOLocInI,oILocInO] = CellArrayDataCat( ...
    iCellArray,iDataType)
error(nargchk(1,2,nargin,'struct'));
pErrId = ['Matlab:',mfilename];
if size(iCellArray,2) > 1
    error(pErrId,'The column number of iCellArray should equal 1.');
end
if size(iCellArray,1) >= 2^64
    error(pErrId,'Out of memory for iCellArray concatenation.');
end
pCellArraySize = cellfun('size',iCellArray,1);
pCellCatLength = sum(pCellArraySize);
if pCellCatLength >= 2^64
    error(pErrId,'Out of memory for iCellArray concatenation.');
end
pCheckNE = pCellArraySize > 0;
if all(pCheckNE)
    iDataType = f_CheckDataType(iCellArray{1},nargin);
    [oCellCat,oOLocInI,oILocInO] = f_CellArrayCat(iCellArray, ...
        pCellArraySize,pCellCatLength);
elseif all(~pCheckNE)
    oCellCat = [];
    oOLocInI = 0;
    oILocInO = num2cell(zeros(size(iCellArray),'uint8'));
else
    pLocate = find(pCheckNE);
    pNECellArray = iCellArray(pCheckNE);
    pNECellArraySize = pCellArraySize(pCheckNE);
    iDataType = f_CheckDataType(pNECellArray{1},nargin);
    [oCellCat,pNEOLocInI,pNEILocInO] = f_CellArrayCat(pNECellArray, ...
        pNECellArraySize,pCellCatLength);
    oOLocInI = pLocate(pNEOLocInI);
    oILocInO = num2cell(zeros(size(iCellArray),'uint8'));
    oILocInO(pLocate) = pNEILocInO;
end

function [o_CellCat,o_OLocInI,o_ILocInO] = f_CellArrayCat( ...
        i_CellArray,i_CellArraySize,i_CellCatLength)
    p_Column = cellfun('size',i_CellArray,2);
    if all(p_Column == p_Column(1))
        p_Column = p_Column(1);
    else
        error(pErrId,['The column number of each element ' ...
            'in "iCellArray" should be consistent.']);
    end
    p_CALength = size(i_CellArray,1);
    p_LocEnd = cumsum(i_CellArraySize);
    if p_LocEnd(end) < 2^8
        p_LocEnd = uint8(p_LocEnd);
    elseif p_LocEnd(end) < 2^16
        p_LocEnd = uint16(p_LocEnd);
    elseif p_LocEnd(end) < 2^32
        p_LocEnd = uint32(p_LocEnd);
    elseif p_LocEnd(end) < 2^64
        p_LocEnd = uint64(p_LocEnd);
    else
        error(pErrId,'Out of memory for iCellArray concatenation.');
    end
    p_LocBegin = [1; (p_LocEnd(1:(end-1))+1)];
    switch iDataType
        case {'cell','cellstr'}
            o_CellCat = cell(i_CellCatLength,p_Column);
        case {'logical'}
            o_CellCat = false(i_CellCatLength,p_Column);
        otherwise
            o_CellCat = zeros(i_CellCatLength,p_Column,iDataType);
    end
    o_ILocInO = cell(p_CALength,1);
    for p_I1 = 1:p_CALength
        o_ILocInO{p_I1} = (p_LocBegin(p_I1):p_LocEnd(p_I1))';
        o_CellCat(o_ILocInO{p_I1},:) = i_CellArray{p_I1};
    end
    if p_CALength < 2^8
        o_OLocInI = zeros(i_CellCatLength,1,'uint8');
    elseif p_CALength < 2^16
        o_OLocInI = zeros(i_CellCatLength,1,'uint16');
    elseif p_CALength < 2^32
        o_OLocInI = zeros(i_CellCatLength,1,'uint32');
    else
        o_OLocInI = zeros(i_CellCatLength,1,'uint64');
    end
    for p_I1 = 1:p_CALength
        o_OLocInI(o_ILocInO{p_I1}) = p_I1;
    end
end

function o_DataType = f_CheckDataType(i_CellArraySample,i_NoArgIn)
    p_DataTypeErr = false;
    if i_NoArgIn == 1
        if iscell(i_CellArraySample)
            o_DataType = 'cell';
        elseif isnumeric(i_CellArraySample)
            o_DataType = 'double';
        elseif islogical(i_CellArraySample)
            o_DataType = 'logical';
        else
            p_DataTypeErr = true;
        end
    else
        o_DataType = lower(iDataType);
        if ~ismember(iDataType,{'cellstr','cell','double','single', ...
                'logical','int8','int16','int32','int64','uint8', ...
                'uint16','uint32','uint64'})
            p_DataTypeErr = true;
        end
    end
    if p_DataTypeErr
        error(pErrId,['Unrecognized data type of iCellArray, should ' ...
            'be cell array of string, numeric number, or logical.']);
    end
end

end
